/*
 * Show the contents of the hint file
 *
 * Jim Rees, Apollo Computer, Dec 1987
 */

#include "/us/ins/ubase.ins.c"
#include "/us/ins/error.ins.c"
#include "/us/ins/network.ins.c"
#include "/sys/ins/ms.ins.c"

#include <stdio.h>

#define NHASH	64
#define NITEMS	3
#define NHINT	3
#define NBUCK	(NHASH * NITEMS)

char *hintfile = "`node_data/hint_file";
int nodenum;
int compar();

struct item {
	node_t match_node;
	internet_t search_list[NHINT];
};

struct hintfile {
	long vers;
	network_t my_net;
	network_$hdwr primary_net_type;
	short primary_net_cnum;
	struct item bucket[NBUCK];
} hints;

main(ac, av)
int ac;
char *av[];
{
	int i, j, k;
	long size_mapped;
	struct hintfile *hp;
	struct item *ip;
	status_$t st;

	while (ac > 1 && av[1][0] == '-') {
		switch (av[1][1]) {
		case 'h':
			hintfile = av[2];
			ac--;
			av++;
			break;
		case 'n':
			sscanf(av[2], "%x", &nodenum);
			ac--;
			av++;
			break;
		}
		ac--;
		av++;
	}

	hp = (struct hintfile *) ms_$mapl(*hintfile, (short) strlen(hintfile),
	    0L, (long) sizeof (struct hintfile),
	    ms_$nr_xor_1w, ms_$r, (char) 0, size_mapped, st);
	if (st.all != status_$ok) {
		error_$print(st);
		exit(1);
	}

	if (hp->vers == 7)
		bcopy(hp, &hints, sizeof (struct hintfile));
	else
		/* pre-sr10 */
		bcopy(hp, (char *) &hints + 2, sizeof (struct hintfile));
	if (hints.vers != 7) {
		fprintf(stderr, "Bad magic\n");
		exit(1);
	}
	qsort(hints.bucket, NBUCK, sizeof (struct item), compar);

	for (i = 0; i < NBUCK; i++) {
		ip = &hints.bucket[i];
		if (ip->match_node == 0)
			continue;
		if (nodenum == 0 || nodenum == ip->match_node) {
			printf("%05x:", ip->match_node);
			for (k = 0; k < NHINT; k++)
				if (ip->search_list[k].node != 0)
					printf(" %5x.%05x", ip->search_list[k].network, ip->search_list[k].node);
			printf("\n");
		}
	}
	exit(0);
}

compar(i1, i2)
struct item *i1, *i2;
{
	return (i1->match_node - i2->match_node);
}
