
/* Life game simulation. Nickolai Zeldovich, 1996 */

#define SIZE 10
#define POINTS 5000          
#define SETSIZE (short)256

#nolist
#include <stdio.h>
#include "/sys/ins/base.ins.c"
#include "/sys/ins/gpr.ins.c"
#include "/sys/ins/error.ins.c"
#include "/sys/ins/time.ins.c"
#include "/sys/ins/kbd.ins.c"
#list

short int map[129][103];          
short int newMap[129][103];
short int x1,y1,x2,y2,i,j,s,xcoord,ycoord;
int l,q,w;
short int done_mouse_io; 
boolean unobs;       
short int C_COLOR;                                       

status_$t            status;
gpr_$bitmap_desc_t   display_bitmap;
gpr_$offset_t        display_bitmap_size;
gpr_$rgb_plane_t     hi_plane;
gpr_$disp_char_t     display_characteristics;
gpr_$bitmap_desc_t     cursor_bitmap_descriptor;
gpr_$event_t         event_type;
gpr_$keyset_t        mouse_buttons, key_set;
gpr_$position_t      position,cursor_position;
char                 event_data;      

void check(messagex)
char *messagex;
{
   if (status.all)
   {   error_$print (status);
       printf("Error occurred while %s.\n", messagex);
   }
}

void pause(t)
float t;
{
time_$clock_t  time;
    
   time.high16 = 0;
   time.low32  = 250000 * t;
   
   time_$wait (time_$relative, time, status);
   check("pausing");
}
   
  
void init(mode)
gpr_$display_mode_t   mode;
{
static short int         unit = 1;
static short int         disp_len = sizeof(gpr_$disp_char_t);
       short int         disp_len_returned;
       short int         unobscured;
   
   gpr_$inq_disp_characteristics(mode, unit, disp_len,
                                 display_characteristics,
                                 disp_len_returned, status);
   check("in init after inquiring");
  
   display_bitmap_size.x_size = display_characteristics.x_window_size;
   display_bitmap_size.y_size = display_characteristics.y_window_size;
   hi_plane                   = display_characteristics.n_planes - 1;
   
   gpr_$init(mode, unit, display_bitmap_size,
             hi_plane, display_bitmap, status);
   check("in init after initializing");
}

/****************************************************************************/
void create_cursor_pattern()
{
 static gpr_$offset_t          size_of_bitmap        =  {16,16};
        gpr_$attribute_desc_t  attributes_descriptor;
   
/*Allocate a small main memory bitmap.*/
   gpr_$allocate_attribute_block(attributes_descriptor, status);
   gpr_$allocate_bitmap(size_of_bitmap, hi_plane, attributes_descriptor,
                        cursor_bitmap_descriptor, status);

/*Draw an arrow pattern inside the main bitmap.*/
   gpr_$set_bitmap(cursor_bitmap_descriptor, status);
   gpr_$move(8, 15, status);
   gpr_$line(8, 0, status);
   gpr_$line(1, 7, status);
   gpr_$line(15,7, status);
   gpr_$line(8, 0, status);
}
/****************************************************************************/
void activate_cursor()
{
 static unsigned char    cursor_active   =  true;
 static gpr_$position_t  cursor_position =  {200,200};
 static gpr_$position_t  cursor_origin   =  {8,0};

/*Make the main memory bitmap into the current cursor pattern.*/
   gpr_$set_cursor_pattern(cursor_bitmap_descriptor, status);

/*Establish 200,200 as the starting current cursor position.*/
   gpr_$set_cursor_position(cursor_position, status);

/*Make the cursor visible.*/
   gpr_$set_cursor_active(cursor_active, status);

/*Sets position 8,0 as the cursor origin.*/
   gpr_$set_cursor_origin(cursor_origin, status);
}
/****************************************************************************/

disable_cursor()          
{
 static unsigned char    cursor_active    = false;

   gpr_$set_cursor_active(cursor_active,status);
}

draw()   
{
   gpr_$clear(C_COLOR,status);
   for(i=1;i<=128;i++) {
   for(j=1;j<=102;j++) {
      if(map[i][j]==1) {
         x1=i*SIZE;
         y1=j*SIZE;
         x2=(i+1)*SIZE-2;
         y2=(j+1)*SIZE-2;
         gpr_$draw_box(x1,y1,x2,y2,status);
      }                     
   } }       
}               

calculate()
{  
   for(i=1;i<=128;i++) {
      for(j=1;j<=102;j++) {
         s=9*map[i][j]+
              map[i][j-1]+
              map[i][j+1]+
              map[i+1][j]+
              map[i-1][j]+
                 map[i+1][j-1]+
                 map[i+1][j+1]+
                 map[i-1][j-1]+
                 map[i-1][j+1];
         if(!(s<3)) {
         if(s==3) newMap[i][j]=1; else
         if(s!=11) if(s!=12) newMap[i][j]=0;
         }
      }
   }   
}

point(x,y)
int x,y;
{
map[x][y]=1;
}

main()
{                
   init(gpr_$borrow);
#ifdef COLOR
   C_COLOR=2;
   gpr_$set_draw_value(1,status);
#else
   C_COLOR=0;
#endif
   gpr_$clear(C_COLOR,status);
   for(i=0;i<=129;i++) {
   for(j=0;j<=103;j++) {
   map[i][j]=0;
   } }

/* Cursor (Mouse) I/O */                

   create_cursor_pattern();
   activate_cursor();
   gpr_$set_bitmap(display_bitmap,status);   

   event_type=gpr_$locator;
   gpr_$enable_input(event_type,key_set,status);

   event_type=gpr_$buttons;
   lib_$init_set(mouse_buttons,SETSIZE);
   lib_$add_to_set(mouse_buttons,SETSIZE,KBD_$M1D);
   lib_$add_to_set(mouse_buttons,SETSIZE,KBD_$M2D);
   lib_$add_to_set(mouse_buttons,SETSIZE,KBD_$M3D);
   gpr_$enable_input(event_type,mouse_buttons,status); 

   done_mouse_io=0;
   
   while (done_mouse_io==0) {

      unobs=gpr_$event_wait(event_type,event_data,position,status); 
      cursor_position=position;

/* Check the cursor event */

      if(event_type==gpr_$buttons) {
         if(event_data==KBD_$M1D) {
            xcoord=(position.x_coord)/SIZE;
            ycoord=(position.y_coord)/SIZE;
            map[xcoord][ycoord]=1; 
            x1=xcoord*SIZE;
            y1=ycoord*SIZE;
            x2=x1+SIZE-2;
            y2=y1+SIZE-2;
            gpr_$set_cursor_active(false,status);
            gpr_$draw_box(x1,y1,x2,y2,status);   
            gpr_$set_cursor_active(true,status);
         }
         if(event_data==KBD_$M3D) {
            xcoord=(position.x_coord)/SIZE;
            ycoord=(position.y_coord)/SIZE;
            map[xcoord][ycoord]=0; 
            x1=xcoord*SIZE;
            y1=ycoord*SIZE;
            x2=x1+SIZE-2;
            y2=y1+SIZE-2;
            gpr_$set_cursor_active(false,status);
            gpr_$set_draw_value(C_COLOR,status);
            gpr_$draw_box(x1,y1,x2,y2,status); 
            gpr_$set_draw_value(1,status);
            gpr_$set_cursor_active(true,status);
         }                       
         if(event_data==KBD_$M2D) {
            done_mouse_io=1;
         }
      }                                                   

      if(event_type==gpr_$locator) {
         gpr_$set_cursor_position(cursor_position,status);
      }                     

/* End cursor event check */

   }                      

   disable_cursor(); 

   for(i=0;i<=129;i++) for(j=0;j<=103;j++) newMap[i][j]=map[i][j];

/* Main loop */

   while (0<1) {
   draw();    
   calculate();
   for(i=1;i<=128;i++) for(j=1;j<=102;j++) map[i][j]=newMap[i][j];
   }           

/* End of main loop */

   gpr_$terminate((short)0, status);
}


