
/* 3D figure rotation. Nickolai Zeldovich, 1996 */

#define MAXV 200           
#define MAXF 20
#define D_ALPHA_X -0.03
#define D_ALPHA_Y -0.02
#define D_ALPHA_Z -0.01
#define SETSIZE (short)256
#define SIZE 100           
#define Z0 5000

#nolist
#include <stdio.h>
#include <math.h>
#include "/sys/ins/base.ins.c"
#include "/sys/ins/gpr.ins.c"
#include "/sys/ins/error.ins.c"
#include "/sys/ins/time.ins.c"
#include "/sys/ins/kbd.ins.c"
#list

struct vect {
   double x,y,z;
};        

struct sqr {
   double x1,y1,x2,y2;
};              

struct face_type {
   short int cnt;
   short int face[MAXV];
};
 
struct sqr turn_x,turn_y,turn_z;
struct vect v[MAXV],v_new;
struct face_type f[MAXF];
int f_cnt,v_cnt;
int figure;     

short int B_COLOR;

int i,j;          
short int xcoord,ycoord;

short int done_mouse_io; 
boolean unobs;                                              

status_$t            status;
gpr_$bitmap_desc_t   display_bitmap;
gpr_$offset_t        display_bitmap_size;
gpr_$rgb_plane_t     hi_plane;
gpr_$disp_char_t     display_characteristics;
gpr_$bitmap_desc_t     cursor_bitmap_descriptor;
gpr_$event_t         event_type;
gpr_$keyset_t        mouse_buttons, key_set;
gpr_$position_t      position,cursor_position,old_position,origin;
char                 event_data;

void check(messagex)
char *messagex;
{
   if (status.all)
   {   error_$print (status);
       printf("Error occurred while %s.\n", messagex);
   }
}

void pause(t)
float t;
{
time_$clock_t  time;
    
   time.high16 = 0;
   time.low32  = 250000 * t;
   
   time_$wait (time_$relative, time, status);
   check("pausing");
}
   
  
void init(mode)
gpr_$display_mode_t   mode;
{
static short int         unit = 1;
static short int         disp_len = sizeof(gpr_$disp_char_t);
       short int         disp_len_returned;
       short int         unobscured;
   
   gpr_$inq_disp_characteristics(mode, unit, disp_len,
                                 display_characteristics,
                                 disp_len_returned, status);
   check("in init after inquiring");
  
   display_bitmap_size.x_size = display_characteristics.x_window_size;
   display_bitmap_size.y_size = display_characteristics.y_window_size;
   hi_plane                   = display_characteristics.n_planes - 1;
   
   gpr_$init(mode, unit, display_bitmap_size,
             hi_plane, display_bitmap, status);
   check("in init after initializing");
}

/****************************************************************************/
void create_cursor_pattern()
{
 static gpr_$offset_t          size_of_bitmap        =  {16,16};
        gpr_$attribute_desc_t  attributes_descriptor;
   
/*Allocate a small main memory bitmap.*/
   gpr_$allocate_attribute_block(attributes_descriptor, status);
   gpr_$allocate_bitmap(size_of_bitmap, hi_plane, attributes_descriptor,
                        cursor_bitmap_descriptor, status);

/*Draw an arrow pattern inside the main bitmap.*/
   gpr_$set_bitmap(cursor_bitmap_descriptor, status);
   gpr_$move(8, 15, status);
   gpr_$line(8, 0, status);
   gpr_$line(1, 7, status);
   gpr_$line(15,7, status);
   gpr_$line(8, 0, status);
}
/****************************************************************************/
void activate_cursor()
{
 static unsigned char    cursor_active   =  true;
 static gpr_$position_t  cursor_position =  {0,0};
 static gpr_$position_t  cursor_origin   =  {8,0};

/*Make the main memory bitmap into the current cursor pattern.*/
   gpr_$set_cursor_pattern(cursor_bitmap_descriptor, status);

/*Establish 0,0 as the starting current cursor position.*/
   gpr_$set_cursor_position(cursor_position, status);

/*Make the cursor visible.*/
   gpr_$set_cursor_active(cursor_active, status);

/*Sets position 8,0 as the cursor origin.*/
   gpr_$set_cursor_origin(cursor_origin, status);
}
/****************************************************************************/

disable_cursor()          
{
 static unsigned char    cursor_active    = false;

   gpr_$set_cursor_active(cursor_active,status);
}

struct vect multiply_xy(m,v)

struct sqr m;
struct vect v;               

/* 
  
   r ( x )  =  m ( x1  x2 )  *  v ( x )
     ( y )       ( y1  y2 )       ( y )

*/          

{
   struct vect r;
   r.x=m.x1*v.x+m.x2*v.y;
   r.y=m.y1*v.x+m.y2*v.y;
   r.z=v.z;
   return r;
}      

struct vect multiply_xz(m,v)

struct sqr m;
struct vect v;               

{
   struct vect r;
   r.x=m.x1*v.x+m.x2*v.z;
   r.z=m.y1*v.x+m.y2*v.z;
   r.y=v.y;
   return r;
}      

struct vect multiply_yz(m,v)

struct sqr m;
struct vect v;               

{
   struct vect r;
   r.y=m.x1*v.y+m.x2*v.z;
   r.z=m.y1*v.y+m.y2*v.z;
   r.x=v.x;
   return r;
}      

display_vect(v)

struct vect v;               
{

short int x_position,y_position;
double factor;

   factor=1/(1+v.z/Z0);   
   x_position=v.x*factor;
   y_position=v.y*factor;
   gpr_$line(x_position,y_position,status);   
}

move_to(v)

struct vect v;
{

short int x_position,y_position;
double factor;

   factor=1/(1+v.z/Z0);   
   x_position=v.x*factor;
   y_position=v.y*factor;
   gpr_$move(x_position,y_position,status);
}   

display_face(f)

struct face_type f;
{                         
   int i;
   double x1,y1,z1,x2,y2,z2,nx,ny,nz,vx,vy,vz,dot_product;

   x1=v[f.face[0]].x-v[f.face[1]].x;
   y1=v[f.face[0]].y-v[f.face[1]].y;
   z1=v[f.face[0]].z-v[f.face[1]].z;
   x2=v[f.face[2]].x-v[f.face[1]].x;
   y2=v[f.face[2]].y-v[f.face[1]].y;
   z2=v[f.face[2]].z-v[f.face[1]].z;

   nx=y1*z2-z1*y2;
   ny=z1*x2-x1*z2;
   nz=x1*y2-y1*x2;                       

   vx=(0-v[f.face[1]].x);
   vy=(0-v[f.face[1]].y);
   vz=v[f.face[1]].z-Z0;
    
   dot_product=nx*vx+ny*vy+nz*vz;
 
   if(dot_product>0) {
      move_to(v[f.face[f.cnt-1]]);
      for(i=0;i<f.cnt;i++) 
         display_vect(v[f.face[i]]);
   }

}

define_cube()

{
/* VECTOR DEFINITION */   

   v_cnt=8;     

   v[0].x=SIZE;
   v[0].y=SIZE;
   v[0].z=SIZE;
   v[1].x-=SIZE;
   v[1].y=SIZE;
   v[1].z=SIZE;
   v[2].x-=SIZE;
   v[2].y-=SIZE;
   v[2].z=SIZE;
   v[3].x=SIZE;
   v[3].y-=SIZE;
   v[3].z=SIZE;
   v[4].x=SIZE;
   v[4].y=SIZE;
   v[4].z-=SIZE;
   v[5].x-=SIZE;
   v[5].y=SIZE;
   v[5].z-=SIZE;
   v[6].x-=SIZE;
   v[6].y-=SIZE;
   v[6].z-=SIZE;
   v[7].x=SIZE;
   v[7].y-=SIZE;
   v[7].z-=SIZE;  

/* FACE DEFINITION */

/* FACES _HAVE_ TO BE DEFINED IN CLOCKWISE DIRECTION */

   f_cnt=6;
   f[0].cnt=4;           
   f[0].face[0]=0;
   f[0].face[1]=3;
   f[0].face[2]=2;
   f[0].face[3]=1;
   f[1].cnt=4;    
   f[1].face[0]=4;
   f[1].face[1]=5;
   f[1].face[2]=6;
   f[1].face[3]=7;
   f[2].cnt=4;    
   f[2].face[0]=0;
   f[2].face[1]=4;
   f[2].face[2]=7;
   f[2].face[3]=3;
   f[3].cnt=4;    
   f[3].face[0]=1;
   f[3].face[1]=5;
   f[3].face[2]=4;
   f[3].face[3]=0;
   f[4].cnt=4;    
   f[4].face[0]=3;
   f[4].face[1]=7;
   f[4].face[2]=6;
   f[4].face[3]=2;
   f[5].cnt=4;    
   f[5].face[0]=1;
   f[5].face[1]=2;
   f[5].face[2]=6;
   f[5].face[3]=5;
}
 
define_pyramid()

{
   v_cnt=5;
   v[0].x=0;
   v[0].y=SIZE;
   v[0].z=0;
   v[1].x=SIZE;
   v[1].y-=SIZE;
   v[1].z=SIZE;
   v[2].x=SIZE;
   v[2].y-=SIZE;
   v[2].z-=SIZE;
   v[3].x-=SIZE;
   v[3].y-=SIZE;
   v[3].z-=SIZE;
   v[4].x-=SIZE;
   v[4].y-=SIZE;
   v[4].z=SIZE;
   
   f_cnt=5;
   f[0].cnt=3;
   f[0].face[0]=0;
   f[0].face[1]=2;
   f[0].face[2]=1;
   f[1].cnt=3;
   f[1].face[0]=0;
   f[1].face[1]=3;
   f[1].face[2]=2;
   f[2].cnt=3;
   f[2].face[0]=0;
   f[2].face[1]=4;
   f[2].face[2]=3;
   f[3].cnt=3;
   f[3].face[0]=0;
   f[3].face[1]=1;
   f[3].face[2]=4;
   f[4].cnt=4;
   f[4].face[0]=1;
   f[4].face[1]=2;
   f[4].face[2]=3;
   f[4].face[3]=4;
}

define_tetra()

{
   v_cnt=4;
   v[0].x-=SIZE;
   v[0].y-=SIZE;
   v[0].z=0;
   v[1].x=SIZE;
   v[1].y-=SIZE;
   v[1].z=0;
   v[2].x=0;
   v[2].y=SIZE;
   v[2].z-=SIZE;
   v[3].x=0;
   v[3].y=SIZE;
   v[3].z=SIZE;
   f_cnt=4;
   f[0].cnt=3;
   f[0].face[0]=0;
   f[0].face[1]=3;
   f[0].face[2]=1;
   f[1].cnt=3;
   f[1].face[0]=1;
   f[1].face[1]=2;
   f[1].face[2]=0;
   f[2].cnt=3;
   f[2].face[0]=1;
   f[2].face[1]=3;
   f[2].face[2]=2;
   f[3].cnt=3;
   f[3].face[0]=0;
   f[3].face[1]=2;
   f[3].face[2]=3;
}

define_octo()

{
   v_cnt=6;
   v[0].x=0;
   v[0].y=SIZE*2;
   v[0].z=0;
   v[1].x-=SIZE;
   v[1].y-=SIZE*sqrt(3);
   v[1].z-=SIZE;
   v[2].x=SIZE;
   v[2].y-=SIZE*sqrt(3);
   v[2].z-=SIZE;
   v[3].x-=SIZE;
   v[3].y=SIZE*sqrt(3);
   v[3].z=SIZE;
   v[4].x=SIZE;
   v[4].y=SIZE*sqrt(3);
   v[4].z=SIZE;
   v[5].x=0;
   v[5].y-=SIZE*2;
   v[5].z=0;
   f_cnt=8;
   f[0].cnt=3;
   f[0].face[0]=0;
   f[0].face[1]=1;
   f[0].face[2]=2;
   f[1].cnt=3;
   f[1].face[0]=3;
   f[1].face[1]=4;
   f[1].face[2]=5;
   f[2].cnt=3;
   f[2].face[0]=5;
   f[2].face[1]=4;
   f[2].face[2]=2;
   f[3].cnt=3;
   f[3].face[0]=1;
   f[3].face[1]=3;
   f[3].face[2]=5;
   f[4].cnt=3;
   f[4].face[0]=0;
   f[4].face[1]=4;
   f[4].face[2]=3;
   f[5].cnt=3;
   f[5].face[0]=1;
   f[5].face[1]=5;
   f[5].face[2]=2;
   f[6].cnt=3;
   f[6].face[0]=0;
   f[6].face[1]=3;
   f[6].face[2]=1;
   f[7].cnt=3;
   f[7].face[0]=2;
   f[7].face[1]=4;
   f[7].face[2]=0;                                        
}

main(argc,argv)
   int argc;
   char *argv[];
{               
   if(argc!=2) {
      printf("\n");
      printf("Usage: %s <figure#>\n\n",argv[0]); 
      printf(" 1 - Cube\n");
      printf(" 2 - Pyramid\n");  
      printf(" 3 - Tetrahedron (Triangular Pyramid)\n");
      printf(" 4 - Octahedron (2 Square Pyramids)\n");
      printf("\n");
   } else { 
   figure=atoi(argv[1]);
   init(gpr_$borrow);
#ifdef COLOR
   B_COLOR=2;
   gpr_$set_draw_value(1,status);
#else
   B_COLOR=0;
#endif 
   gpr_$clear(B_COLOR,status);

#ifdef SMALL
   origin.x_coord=512;
   origin.y_coord=384;
#else
   origin.x_coord=640;
   origin.y_coord=512;
#endif
   gpr_$set_coordinate_origin(origin,status);

   v_cnt=0;
   for(i=0;i<MAXV;i++) { v[i].x=0; v[i].y=0; v[i].z=0; }

/* Cursor (Mouse) I/O */                

/*   create_cursor_pattern();
   activate_cursor();
   gpr_$set_bitmap(display_bitmap,status);   

   event_type=gpr_$locator;
   gpr_$enable_input(event_type,key_set,status);

   event_type=gpr_$buttons;
   lib_$init_set(mouse_buttons,SETSIZE);
   lib_$add_to_set(mouse_buttons,SETSIZE,KBD_$M1D);
   lib_$add_to_set(mouse_buttons,SETSIZE,KBD_$M2D);
   lib_$add_to_set(mouse_buttons,SETSIZE,KBD_$M3D);
   gpr_$enable_input(event_type,mouse_buttons,status); 

   done_mouse_io=0;
   
   while (done_mouse_io==0) {

      unobs=gpr_$event_wait(event_type,event_data,position,status); 
      cursor_position=position;

      if(event_type==gpr_$buttons) {
         if(event_data==KBD_$M1D) {
            xcoord=position.x_coord;
            ycoord=position.y_coord;
            if(v_cnt==0)
               gpr_$move(xcoord,ycoord,status);
            else
               gpr_$line(xcoord,ycoord,status);
            v[v_cnt].x=xcoord;
            v[v_cnt].y=ycoord;
            v_cnt=v_cnt+1;
         }
         if(event_data==KBD_$M3D) {
            done_mouse_io=1;
         }                       
         if(event_data==KBD_$M2D) {
            done_mouse_io=1;
         }
      }                                                   

      if(event_type==gpr_$locator) {  
         if(!(v_cnt==0)) {
            xcoord=v[v_cnt-1].x;
            ycoord=v[v_cnt-1].y;
            gpr_$move(xcoord,ycoord,status);
            gpr_$set_cursor_active(false,status);
            gpr_$set_draw_value(B_COLOR,status);
            gpr_$line(old_position.x_coord,old_position.y_coord,status); 
            gpr_$set_draw_value(1,status);
            gpr_$move(xcoord,ycoord,status); 
            gpr_$line(cursor_position.x_coord,cursor_position.y_coord,status);

           move_to(v[0]);
         
           for(i=1;i<v_cnt;i++) 
              display_vect(v[i]);

            gpr_$set_cursor_active(true,status);
         }
         gpr_$set_cursor_position(cursor_position,status); 
         old_position=cursor_position;
      }

   }                      

   disable_cursor();   */        

/* ROTATION MATRIX DEFINITION */

   turn_x.x1=cos(D_ALPHA_X);
   turn_x.y1=sin(D_ALPHA_X);
   turn_x.x2-=turn_x.y1;
   turn_x.y2=turn_x.x1;      
   turn_y.x1=cos(D_ALPHA_Y);
   turn_y.y1=sin(D_ALPHA_Y);
   turn_y.x2-=turn_y.y1;
   turn_y.y2=turn_y.x1;      
   turn_z.x1=cos(D_ALPHA_Z);
   turn_z.y1=sin(D_ALPHA_Z);
   turn_z.x2-=turn_z.y1;
   turn_z.y2=turn_z.x1; 

if(figure==1) define_cube(); else
if(figure==2) define_pyramid(); else
if(figure==3) define_tetra(); else
if(figure==4) define_octo(); else  
   define_cube;

   while(1) {

      gpr_$clear(B_COLOR,status);

      for(i=0;i<f_cnt;i++)
         display_face(f[i]); 

      for(i=0;i<v_cnt;i++) {
         v_new=multiply_xy(turn_z,v[i]);
         v[i]=v_new;
         v_new=multiply_xz(turn_y,v[i]);
         v[i]=v_new;
         v_new=multiply_yz(turn_x,v[i]);
         v[i]=v_new;
      }  

/*      pause(0.1);     */

   }

   gpr_$terminate((short)0, status);
   }
}


