
/* 2D figure rotation. Nickolai Zeldovich, 1996 */

#define MAXV 200           
#define D_ALPHA 0.03
#define SETSIZE (short)256

#nolist
#include <stdio.h>
#include <math.h>
#include "/sys/ins/base.ins.c"
#include "/sys/ins/gpr.ins.c"
#include "/sys/ins/error.ins.c"
#include "/sys/ins/time.ins.c"
#include "/sys/ins/kbd.ins.c"
#list

struct vect {
   double x,y;
};        

struct sqr {
   double x1,y1,x2,y2;
};
 
struct sqr turn;
struct vect v[MAXV],v_new[MAXV];
int v_cnt;

int i;          
short int xcoord,ycoord;         

short int done_mouse_io; 
boolean unobs;                                              

status_$t            status;          
gpr_$bitmap_desc_t   display_bitmap;
gpr_$offset_t        display_bitmap_size;
gpr_$rgb_plane_t     hi_plane;
gpr_$disp_char_t     display_characteristics;
gpr_$bitmap_desc_t     cursor_bitmap_descriptor;
gpr_$event_t         event_type;
gpr_$keyset_t        mouse_buttons, key_set;
gpr_$position_t      position,cursor_position,old_position,origin;
char                 event_data;

void check(messagex)
char *messagex;
{
   if (status.all)
   {   error_$print (status);
       printf("Error occurred while %s.\n", messagex);
   }
}

void pause(t)
float t;
{
time_$clock_t  time;
    
   time.high16 = 0;
   time.low32  = 250000 * t;
   
   time_$wait (time_$relative, time, status);
   check("pausing");
}
   
  
void init(mode)
gpr_$display_mode_t   mode;
{
static short int         unit = 1;
static short int         disp_len = sizeof(gpr_$disp_char_t);
       short int         disp_len_returned;
       short int         unobscured;
   
   gpr_$inq_disp_characteristics(mode, unit, disp_len,
                                 display_characteristics,
                                 disp_len_returned, status);
   check("in init after inquiring");
  
   display_bitmap_size.x_size = display_characteristics.x_window_size;
   display_bitmap_size.y_size = display_characteristics.y_window_size;
   hi_plane                   = display_characteristics.n_planes - 1;
   
   gpr_$init(mode, unit, display_bitmap_size,
             hi_plane, display_bitmap, status);
   check("in init after initializing");
}

/****************************************************************************/
void create_cursor_pattern()
{
 static gpr_$offset_t          size_of_bitmap        =  {16,16};
        gpr_$attribute_desc_t  attributes_descriptor;
   
/*Allocate a small main memory bitmap.*/
   gpr_$allocate_attribute_block(attributes_descriptor, status);
   gpr_$allocate_bitmap(size_of_bitmap, hi_plane, attributes_descriptor,
                        cursor_bitmap_descriptor, status);

/*Draw an arrow pattern inside the main bitmap.*/
   gpr_$set_bitmap(cursor_bitmap_descriptor, status);
   gpr_$move(8, 15, status);
   gpr_$line(8, 0, status);
   gpr_$line(1, 7, status);
   gpr_$line(15,7, status);
   gpr_$line(8, 0, status);
}
/****************************************************************************/
void activate_cursor()
{
 static unsigned char    cursor_active   =  true;
 static gpr_$position_t  cursor_position =  {0,0};
 static gpr_$position_t  cursor_origin   =  {8,0};

/*Make the main memory bitmap into the current cursor pattern.*/
   gpr_$set_cursor_pattern(cursor_bitmap_descriptor, status);
            
/*Establish the starting current cursor position.*/
   gpr_$set_cursor_position(cursor_position, status);

/*Make the cursor visible.*/
   gpr_$set_cursor_active(cursor_active, status);

/*Sets position 8,0 as the cursor origin.*/
   gpr_$set_cursor_origin(cursor_origin, status);
}
/****************************************************************************/

disable_cursor()          
{
 static unsigned char    cursor_active    = false;

   gpr_$set_cursor_active(cursor_active,status);
}

struct vect multiply(m,v)

struct sqr m;
struct vect v;               

/* 
  
   r ( x )  =  m ( x1  x2 )  *  v ( x )
     ( y )       ( y1  y2 )       ( y )

*/          

{
   struct vect r;
   r.x=m.x1*v.x+m.x2*v.y;
   r.y=m.y1*v.x+m.y2*v.y;
   return r;
}      

display_vect(v)

struct vect v;               
{

short int x_position,y_position;

   x_position=v.x;
   y_position=v.y;
/*   gpr_$move(0,0,status);   */
   gpr_$line(x_position,y_position,status);   
}

move_to(v)

struct vect v;
{

short int x_position,y_position;

   x_position=v.x;
   y_position=v.y;
   gpr_$move(x_position,y_position,status);
}

main()
{                
   init(gpr_$borrow);
#ifdef COLOR
      gpr_$clear(2,status); 
      gpr_$set_draw_value(1,status);
#else
      gpr_$clear(0,status);
#endif 

#ifdef SMALL
   origin.x_coord=512;
   origin.y_coord=384;
#else
   origin.x_coord=640;
   origin.y_coord=512;
#endif            
   gpr_$set_coordinate_origin(origin,status);

   v_cnt=0;

/* Cursor (Mouse) I/O */                

   create_cursor_pattern();
   activate_cursor();
   gpr_$set_bitmap(display_bitmap,status);   

   event_type=gpr_$locator;
   gpr_$enable_input(event_type,key_set,status);

   event_type=gpr_$buttons;
   lib_$init_set(mouse_buttons,SETSIZE);
   lib_$add_to_set(mouse_buttons,SETSIZE,KBD_$M1D);
   lib_$add_to_set(mouse_buttons,SETSIZE,KBD_$M2D);
   lib_$add_to_set(mouse_buttons,SETSIZE,KBD_$M3D);
   gpr_$enable_input(event_type,mouse_buttons,status); 

   done_mouse_io=0;
   
   while (done_mouse_io==0) {

      unobs=gpr_$event_wait(event_type,event_data,position,status); 
      cursor_position=position;

      if(event_type==gpr_$buttons) {
         if(event_data==KBD_$M1D) {
            xcoord=position.x_coord;
            ycoord=position.y_coord;
            if(v_cnt==0)
               gpr_$move(xcoord,ycoord,status);
            else
               gpr_$line(xcoord,ycoord,status);
            v[v_cnt].x=xcoord;
            v[v_cnt].y=ycoord;
            v_cnt=v_cnt+1;
         }
         if(event_data==KBD_$M3D) {
            done_mouse_io=1;
         }                       
         if(event_data==KBD_$M2D) {
            done_mouse_io=1;
         }
      }                                                   

      if(event_type==gpr_$locator) {  
         if(!(v_cnt==0)) {
            xcoord=v[v_cnt-1].x;
            ycoord=v[v_cnt-1].y;
            gpr_$move(xcoord,ycoord,status);
            gpr_$set_cursor_active(false,status);
#ifdef COLOR
            gpr_$set_draw_value(2,status);
#else
            gpr_$set_draw_value(0,status);
#endif
            gpr_$line(old_position.x_coord,old_position.y_coord,status); 
#ifdef COLOR
            gpr_$set_draw_value(1,status);
#else
            gpr_$set_draw_value(1,status);
#endif                                   
            gpr_$move(xcoord,ycoord,status); 
            gpr_$line(cursor_position.x_coord,cursor_position.y_coord,status);

           move_to(v[0]);
         
           for(i=1;i<v_cnt;i++) 
              display_vect(v[i]);

            gpr_$set_cursor_active(true,status);
         }
         gpr_$set_cursor_position(cursor_position,status); 
         old_position=cursor_position;
      }

   }                      

   disable_cursor(); 

   turn.x1=cos(D_ALPHA);
   turn.y1=sin(D_ALPHA);
   turn.x2-=sin(D_ALPHA);
   turn.y2=turn.x1;     

   while(1) {
    
#ifdef COLOR
      gpr_$clear(2,status);
#else
      gpr_$clear(0,status);
#endif

      move_to(v[0]);
         
      for(i=1;i<v_cnt;i++) 
         display_vect(v[i]);

      for(i=0;i<v_cnt;i++) {
         v_new[i]=multiply(turn,v[i]);
         v[i]=v_new[i];
      }  
 
/*      pause(0.1);     */

   }

   gpr_$terminate((short)0, status);
}


