
/* 3D figure rotation. Nickolai Zeldovich, 1996 */

#define MAXV 200           
#define D_ALPHA_X 0.03
#define D_ALPHA_Y 0.02
#define D_ALPHA_Z 0.01
#define SETSIZE (short)256
#define CUBE_SIZE 100           
#define Z_FACTOR 0.001

#nolist
#include <stdio.h>
#include <math.h>
#include "/sys/ins/base.ins.c"
#include "/sys/ins/gpr.ins.c"
#include "/sys/ins/error.ins.c"
#include "/sys/ins/time.ins.c"
#include "/sys/ins/kbd.ins.c"
#list

struct vect {
   double x,y,z;
};        

struct sqr {
   double x1,y1,x2,y2;
};
 
struct sqr turn_x,turn_y,turn_z;
struct vect v[MAXV],v_new[MAXV];
int v_cnt;     

short int B_COLOR;

int i;          
short int xcoord,ycoord;

short int done_mouse_io; 
boolean unobs;                                              

status_$t            status;
gpr_$bitmap_desc_t   display_bitmap;
gpr_$offset_t        display_bitmap_size;
gpr_$rgb_plane_t     hi_plane;
gpr_$disp_char_t     display_characteristics;
gpr_$bitmap_desc_t     cursor_bitmap_descriptor;
gpr_$event_t         event_type;
gpr_$keyset_t        mouse_buttons, key_set;
gpr_$position_t      position,cursor_position,old_position,origin;
char                 event_data;

void check(messagex)
char *messagex;
{
   if (status.all)
   {   error_$print (status);
       printf("Error occurred while %s.\n", messagex);
   }
}

void pause(t)
float t;
{
time_$clock_t  time;
    
   time.high16 = 0;
   time.low32  = 250000 * t;
   
   time_$wait (time_$relative, time, status);
   check("pausing");
}
   
  
void init(mode)
gpr_$display_mode_t   mode;
{
static short int         unit = 1;
static short int         disp_len = sizeof(gpr_$disp_char_t);
       short int         disp_len_returned;
       short int         unobscured;
   
   gpr_$inq_disp_characteristics(mode, unit, disp_len,
                                 display_characteristics,
                                 disp_len_returned, status);
   check("in init after inquiring");
  
   display_bitmap_size.x_size = display_characteristics.x_window_size;
   display_bitmap_size.y_size = display_characteristics.y_window_size;
   hi_plane                   = display_characteristics.n_planes - 1;
   
   gpr_$init(mode, unit, display_bitmap_size,
             hi_plane, display_bitmap, status);
   check("in init after initializing");
}

/****************************************************************************/
void create_cursor_pattern()
{
 static gpr_$offset_t          size_of_bitmap        =  {16,16};
        gpr_$attribute_desc_t  attributes_descriptor;
   
/*Allocate a small main memory bitmap.*/
   gpr_$allocate_attribute_block(attributes_descriptor, status);
   gpr_$allocate_bitmap(size_of_bitmap, hi_plane, attributes_descriptor,
                        cursor_bitmap_descriptor, status);

/*Draw an arrow pattern inside the main bitmap.*/
   gpr_$set_bitmap(cursor_bitmap_descriptor, status);
   gpr_$move(8, 15, status);
   gpr_$line(8, 0, status);
   gpr_$line(1, 7, status);
   gpr_$line(15,7, status);
   gpr_$line(8, 0, status);
}
/****************************************************************************/
void activate_cursor()
{
 static unsigned char    cursor_active   =  true;
 static gpr_$position_t  cursor_position =  {0,0};
 static gpr_$position_t  cursor_origin   =  {8,0};

/*Make the main memory bitmap into the current cursor pattern.*/
   gpr_$set_cursor_pattern(cursor_bitmap_descriptor, status);

/*Establish 0,0 as the starting current cursor position.*/
   gpr_$set_cursor_position(cursor_position, status);

/*Make the cursor visible.*/
   gpr_$set_cursor_active(cursor_active, status);

/*Sets position 8,0 as the cursor origin.*/
   gpr_$set_cursor_origin(cursor_origin, status);
}
/****************************************************************************/

disable_cursor()          
{
 static unsigned char    cursor_active    = false;

   gpr_$set_cursor_active(cursor_active,status);
}

struct vect multiply_xy(m,v)

struct sqr m;
struct vect v;               

/* 
  
   r ( x )  =  m ( x1  x2 )  *  v ( x )
     ( y )       ( y1  y2 )       ( y )

*/          

{
   struct vect r;
   r.x=m.x1*v.x+m.x2*v.y;
   r.y=m.y1*v.x+m.y2*v.y;
   r.z=v.z;
   return r;
}      

struct vect multiply_xz(m,v)

struct sqr m;
struct vect v;               

{
   struct vect r;
   r.x=m.x1*v.x+m.x2*v.z;
   r.z=m.y1*v.x+m.y2*v.z;
   r.y=v.y;
   return r;
}      

struct vect multiply_yz(m,v)

struct sqr m;
struct vect v;               

{
   struct vect r;
   r.y=m.x1*v.y+m.x2*v.z;
   r.z=m.y1*v.y+m.y2*v.z;
   r.x=v.x;
   return r;
}      

display_vect(v)

struct vect v;               
{

short int x_position,y_position;
double factor;

   factor=1+v.z*Z_FACTOR;   
   x_position=v.x*factor;
   y_position=v.y*factor;
/*   gpr_$move(0,0,status);   */
   gpr_$line(x_position,y_position,status);   
}

move_to(v)

struct vect v;
{

short int x_position,y_position;
double factor;

   factor=1+v.z*Z_FACTOR;   
   x_position=v.x*factor;
   y_position=v.y*factor;
   gpr_$move(x_position,y_position,status);
}

main()
{                
   init(gpr_$borrow);
#ifdef COLOR
   B_COLOR=2;
   gpr_$set_draw_value(1,status);
#else
   B_COLOR=0;
#endif 
   gpr_$clear(B_COLOR,status);

#ifdef SMALL
   origin.x_coord=512;
   origin.y_coord=384;
#else
   origin.x_coord=640;
   origin.y_coord=512;
#endif
   gpr_$set_coordinate_origin(origin,status);

   v_cnt=0;

/* Cursor (Mouse) I/O */                

/*   create_cursor_pattern();
   activate_cursor();
   gpr_$set_bitmap(display_bitmap,status);   

   event_type=gpr_$locator;
   gpr_$enable_input(event_type,key_set,status);

   event_type=gpr_$buttons;
   lib_$init_set(mouse_buttons,SETSIZE);
   lib_$add_to_set(mouse_buttons,SETSIZE,KBD_$M1D);
   lib_$add_to_set(mouse_buttons,SETSIZE,KBD_$M2D);
   lib_$add_to_set(mouse_buttons,SETSIZE,KBD_$M3D);
   gpr_$enable_input(event_type,mouse_buttons,status); 

   done_mouse_io=0;
   
   while (done_mouse_io==0) {

      unobs=gpr_$event_wait(event_type,event_data,position,status); 
      cursor_position=position;

      if(event_type==gpr_$buttons) {
         if(event_data==KBD_$M1D) {
            xcoord=position.x_coord;
            ycoord=position.y_coord;
            if(v_cnt==0)
               gpr_$move(xcoord,ycoord,status);
            else
               gpr_$line(xcoord,ycoord,status);
            v[v_cnt].x=xcoord;
            v[v_cnt].y=ycoord;
            v_cnt=v_cnt+1;
         }
         if(event_data==KBD_$M3D) {
            done_mouse_io=1;
         }                       
         if(event_data==KBD_$M2D) {
            done_mouse_io=1;
         }
      }                                                   

      if(event_type==gpr_$locator) {  
         if(!(v_cnt==0)) {
            xcoord=v[v_cnt-1].x;
            ycoord=v[v_cnt-1].y;
            gpr_$move(xcoord,ycoord,status);
            gpr_$set_cursor_active(false,status);
            gpr_$set_draw_value(B_COLOR,status);
            gpr_$line(old_position.x_coord,old_position.y_coord,status); 
            gpr_$set_draw_value(1,status);
            gpr_$move(xcoord,ycoord,status); 
            gpr_$line(cursor_position.x_coord,cursor_position.y_coord,status);

           move_to(v[0]);
         
           for(i=1;i<v_cnt;i++) 
              display_vect(v[i]);

            gpr_$set_cursor_active(true,status);
         }
         gpr_$set_cursor_position(cursor_position,status); 
         old_position=cursor_position;
      }

   }                      

   disable_cursor();   */

   v_cnt=8;
   v[0].x=CUBE_SIZE;
   v[0].y=CUBE_SIZE;
   v[0].z=CUBE_SIZE;
   v[1].x-=CUBE_SIZE;
   v[1].y=CUBE_SIZE;
   v[1].z=CUBE_SIZE;
   v[2].x-=CUBE_SIZE;
   v[2].y-=CUBE_SIZE;
   v[2].z=CUBE_SIZE;
   v[3].x=CUBE_SIZE;
   v[3].y-=CUBE_SIZE;
   v[3].z=CUBE_SIZE;
   v[4].x=CUBE_SIZE;
   v[4].y=CUBE_SIZE;
   v[4].z-=CUBE_SIZE;
   v[5].x-=CUBE_SIZE;
   v[5].y=CUBE_SIZE;
   v[5].z-=CUBE_SIZE;
   v[6].x-=CUBE_SIZE;
   v[6].y-=CUBE_SIZE;
   v[6].z-=CUBE_SIZE;
   v[7].x=CUBE_SIZE;
   v[7].y-=CUBE_SIZE;
   v[7].z-=CUBE_SIZE;               

   turn_x.x1=cos(D_ALPHA_X);
   turn_x.y1=sin(D_ALPHA_X);
   turn_x.x2-=turn_x.y1;
   turn_x.y2=turn_x.x1;      
   turn_y.x1=cos(D_ALPHA_Y);
   turn_y.y1=sin(D_ALPHA_Y);
   turn_y.x2-=turn_y.y1;
   turn_y.y2=turn_y.x1;      
   turn_z.x1=cos(D_ALPHA_Z);
   turn_z.y1=sin(D_ALPHA_Z);
   turn_z.x2-=turn_z.y1;
   turn_z.y2=turn_z.x1;      

   while(1) {

      gpr_$clear(B_COLOR,status);

      move_to(v[0]);
         
/*      for(i=1;i<v_cnt;i++) 
         display_vect(v[i]);    */
      display_vect(v[1]);
      display_vect(v[2]);
      display_vect(v[3]);
      display_vect(v[0]);
      display_vect(v[4]);
      display_vect(v[5]);
      display_vect(v[6]);
      display_vect(v[7]);
      display_vect(v[3]);
      move_to(v[7]);
      display_vect(v[4]);
      move_to(v[2]);
      display_vect(v[6]);
      move_to(v[1]);
      display_vect(v[5]);

      for(i=0;i<v_cnt;i++) {
         v_new[i]=multiply_xy(turn_z,v[i]);
         v[i]=v_new[i];
         v_new[i]=multiply_xz(turn_y,v[i]);
         v[i]=v_new[i];
         v_new[i]=multiply_yz(turn_x,v[i]);
         v[i]=v_new[i];
      }  

/*      pause(0.1);     */

   }

   gpr_$terminate((short)0, status);
}


