/*
 * Copyright (c) 1988 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 *
 * Written by Jim Rees
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/errno.h>
#include <sys/dir.h>

#include "/us/ins/ubase.ins.c"
#include "/us/ins/network.ins.c"
#include "/us/ins/msg.ins.c"

#include "netboot.h"

boolean debug, verbose;
char *ErrMsg();
extern char *sys_errlist[];

main(ac, av)
char *av[];
{
	u_short timeout = 32767, socket, transid, brqstlen, datlen;
	node_t nodeid;
	pkt_$pkttyp pkttyp;
	boot_rqst_t brqst;
	char dat[PSIZE];
	boot_reply_t breply;
	status_$t st;

	while (ac > 1 && av[1][0] == '-') {
		switch (av[1][1]) {
		case 'd':
			debug = true;
			break;
		case 'v':
			verbose = true;
			break;
		}
		ac--;
		av++;
	}

	if (!msg_$open(network_$netman_sock,msg_$max_depth)) {
		fprintf(stderr, "netman socket is in use\n");
		exit(1);
	}

	for (;;) {
		while (!msg_$wait(network_$netman_sock, timeout))
			if (debug)
				printf("msg_$wait returns false\n");

		msg_$rcv(network_$netman_sock, nodeid, socket, pkttyp, transid,
		  brqst, (u_short) sizeof brqst, brqstlen, dat, (u_short) sizeof dat, datlen, st);
		if (st.all != status_$ok)
			fprintf(stderr, "msg_$rcv: %s\n", ErrMsg(st));

		if (brqst.service != msg_boot_service) {
			fprintf(stderr, "unsupported service type %d\n", brqst.service);
			continue;
		}
		if (debug)
			dumphdr(&brqst, brqstlen);

		bzero(&breply, sizeof breply);
		breply.service = msg_boot_service;
		breply.version = boot_version;

		if (verbose)
			printf("%x: ", nodeid);

		switch (brqst.kind) {

		case boot_volun_rqst:
			if (verbose)
				printf("Boot volunteer request\n");
			breply.kind = boot_volun_reply;
			breply.st = 0;
			msend(nodeid, socket, transid, &breply, boot_reply_t1_len, dat, 0);
			break;

		case boot_load_rqst:
			if (verbose)
				printf("Request for file '%s'\n", brqst.name);
			breply.kind = boot_load_reply;
			sendfile(brqst.name, nodeid, socket, transid, &breply);
			break;

		case boot_sysboot_rqst:
			if (verbose)
				printf("Boot block request\n");
			breply.kind = boot_sysboot_reply;
			sendfile("bootn.rfc", nodeid, socket, transid, &breply);
			break;

		case boot_ld_rqst:
			if (verbose)
				printf("ls request\n");
			sendls(brqst.name, nodeid, socket, transid, &breply);
			break;

		default:
			fprintf((verbose ? stdout : stderr), "Unknown request kind %d\n", brqst.kind);
			break;
		}
	}
}

dumphdr(br, len)
boot_rqst_t *br;
int len;
{
	int fd;
	char fname[4];
	static int n;

	sprintf(fname, "x%d", n++);
	fd = creat(fname, 0666);
	write(fd, br, len);
	close(fd);
	printf("%s: service=%d version=%d machid=%d kind=%d flags=%x\n",
	  fname, br->service, br->version, br->machid, br->kind, br->osflags);
}

sendfile(name, nodeid, socket, transid, rpp)
char *name;
node_t nodeid;
u_short socket, transid;
boot_reply_t *rpp;
{
	int fd;
	u_short n;
	int flen, nsent = 0;
	char dat[PSIZE];

	if (debug)
		printf("request for file '%s'\n", name);

	if ((fd = open(name, 0)) < 0) {
		perror(name);
		rpp->st = errno;
		sprintf(rpp->errmsg, "%s: %s", name, sys_errlist[errno]);
		msend(nodeid, socket, transid, rpp, boot_reply_t1_len, dat, 0);
		return;
	}

	flen = lseek(fd, 0L, 2);
	lseek(fd, 0L, 0);

	rpp->st = 0;
	rpp->low = 0x13d800;
	rpp->high = 0x13d800 + (10 * PSIZE);
	rpp->start = 0x13d818;
	rpp->eof = false;
	rpp->eor = false;

	while ((n = read(fd, dat, sizeof dat)) > 0) {
		if (nsent + n >= flen)
			rpp->eof = true;
		rpp->copy = rpp->low + nsent;
		msend(nodeid, socket, transid, rpp, boot_reply_t2_len, dat, n);
		nsent += n;
		if (debug)
			printf("sent %d bytes\n", nsent);
		if (rpp->eof)
			break;
	}

	close(fd);
}

sendls(name, nodeid, socket, transid, rpp)
char *name;
node_t nodeid;
u_short socket, transid;
boot_reply_t *rpp;
{
	DIR *dirp;
	struct direct *dp;
	char buf[PSIZE];
	int blen;

	rpp->kind = boot_ld_reply;

/*	if (strlen(name) == 0)*/
		name = ".";

	if ((dirp = opendir(name)) == NULL) {
		perror(name);
		rpp->st = errno;
		sprintf(rpp->errmsg, "%s: %s", name, sys_errlist[errno]);
		msend(nodeid, socket, transid, rpp, boot_reply_t1_len, NULL, 0);
		return;
	}

	rpp->st = 0;
	rpp->low = rpp->copy = 0x13d800;
	rpp->high = 0x13d800 + (10 * PSIZE);
	rpp->start = 0x13d818;
	rpp->eof = false;
	rpp->eor = false;

	blen = 0;
	while ((dp = readdir(dirp)) != NULL) {
		if (blen + dp->d_namlen + 2 > sizeof buf) {
			msend(nodeid, socket, transid, rpp, boot_reply_t2_len, buf, blen + 1);
			rpp->copy += 1024;
			blen = 0;
		}
		sprintf(&buf[blen], "%s\n", dp->d_name);
		blen += dp->d_namlen + 1;
		if (debug)
			printf("ls: %s\n", dp->d_name);
	}
	rpp->eof = true;
	msend(nodeid, socket, transid, rpp, boot_reply_t2_len, buf, blen + 1);

	closedir(dirp);
}

msend(nodeid, socket, transid, hdr, hdrlen, dat, datlen)
node_t nodeid;
u_short socket, transid;
char *hdr, *dat;
short hdrlen, datlen;
{
	extern std_$call send_reply();

	send_reply(nodeid, socket, transid, *hdr, hdrlen, *dat, datlen);
}

char *
ErrMsg(code)
status_$t code;
{
	static char msg[120];
	short n;
	extern std_$call error_$get_string();

	error_$get_string(code, msg, (short) (sizeof msg - 1), n);
	msg[n] = '\0';
	return msg;
}

dosleep()
{
	static struct timeval tv = {0, 20000};

	select(0, NULL, NULL, NULL, &tv);
}
