#define PSIZE 1024

#define boot_version		1

#define msg_echo_service	0
#define msg_boot_service	1
#define msg_dump_service	2

#define boot_ld_rqst		2
#define boot_ld_reply		3
#define boot_load_rqst		4
#define boot_load_reply		5
#define boot_volun_rqst		6
#define boot_volun_reply	7
#define boot_sysboot_rqst	8
#define boot_sysboot_reply	9

#define pkt_non_aegis_mask	((short) 0x1)
#define pkt_sw_diag_mask	((short) 0x2)
#define pkt_user_mask		((short) 0x4)
#define pkt_paging_mask		((short) 0x8)
#define pkt_please_mask		((short) 0x10)
#define pkt_thank_you_mask	((short) 0x20)
#define pkt_hw_diag_mask	((short) 0x40)
#define pkt_brdcst_mask		((short) 0x80)

#define network_netman_sock 3

typedef struct {
	short service, version;
	char machid, kind;
	short osflags;
	short namlen;
	char name[32];
	unsigned short startpage, endpage;
} boot_rqst_t;

typedef struct {
	short service, version, kind;
	long st;
	union {
		struct {
			unsigned long high, low, start, copy;
			unsigned char eof, eor;
		} u1;
		char errmsg[60];
	} u;
} boot_reply_t;

#define boot_reply_t1_len	(10+2+32)
#define boot_reply_t2_len	28

typedef struct {
	long toid;
	short pkttyp;
	char zeros, earlyack;
	long fromid;
} pkt_hdwr_hdr;

typedef struct {
	char version, chksum, pkttyp, qdepth;
	unsigned short hdrlen, hdrdatlen, datlen, transid;
} pkt_cntl_hdr;

typedef struct {
	pkt_hdwr_hdr hdwr;
	pkt_cntl_hdr cntl;
	char lnth, curr;
	unsigned short srcsock, srcnode;
	short route[2];
} boot_hdr_t;
