/***********************************************************\
*                                                           *
*       melt                                                *
*                                                           *
*       Copyright 1987 by Stephen Coy                       *
*                                                           *
*       This code may be distributed provided that no       *
*       money is charged for it and source code is          *
*       included with any object.                           *
*                                                           *
\***********************************************************/

#nolist
#include "/sys/ins/base.ins.c"
#include "/sys/ins/gpr.ins.c"

#define rnd()   (rand()/2)
#define DELTA   1
#define RANGE   (DELTA*2+1)

gpr_$offset_t           init_bitmap_size = {1280, 1024};
gpr_$bitmap_desc_t      init_bitmap;
gpr_$display_mode_t     mode = gpr_$borrow_nc;
gpr_$plane_t            hi_plane_id = 7;
gpr_$offset_t           size;
status_$t               status;

main()
{               
    init();
    disolve();
}

init()
{                    
    gpr_$init(mode,
            (short)1,
            init_bitmap_size,
            hi_plane_id,
            init_bitmap,
            status);
    gpr_$inq_bitmap(init_bitmap, status);
}
                       
disolve()
{                    
    register int    x, y;
    int             max_x, max_y;
    gpr_$window_t   window;
    gpr_$position_t dest;                

    gpr_$inq_bitmap_dimensions(init_bitmap,   
                         size,
                         hi_plane_id,
                         status);
    max_x = size.x_size;
    max_y = size.y_size;

    for(;;) {         
        x = rnd()%(max_x-RANGE) + RANGE;
        y = rnd()%(max_y-RANGE) + RANGE;  
        window.window_size.x_size  = x;
        window.window_size.y_size  = y;
        x = max_x - x;
        y = max_y - y;
        x = rnd() % x;
        y = rnd() % y;
        window.window_base.x_coord = x;
        window.window_base.y_coord = y;
        dest.x_coord = (rnd() % RANGE - DELTA) + x;
        dest.y_coord = (rnd() % RANGE - DELTA) + y;

        gpr_$pixel_blt(init_bitmap,
                       window,
                       dest,
                       status);
    }
}
