/*
  Morse code.

  Written by Jim Rees, Apollo Computer, 1986.
*/

#include <stdio.h>

#ifdef apollo
#include "/sys/ins/base.ins.c"
#include "/sys/ins/tone.ins.c"
#include "/sys/ins/time.ins.c"
#include "/sys/ins/cal.ins.c"
#endif

#include "morse.h"

#define DIT	1
#define DAH	3
#define IBG	1	/* inter-bit gap */
#define ICG	3	/* inter-character gap */
#define IWG	7	/* inter-word gap */

extern struct morse tab[];

char *mbits[128];

int speed = 20, vflag, tflag, iflag;
#ifdef apollo
time_$clock_t dit;
#endif

main(ac, av)
int ac;
char *av[];
{
	int c;
	char *cp;

	while (ac > 1 && av[1][0] == '-') {
		switch (av[1][1]) {
		case 's':
			speed = atoi(av[2]);
			ac--;
			av++;
			break;
		case 'v':
			vflag = 1;
			break;
		case 'i':
			iflag = 1;
			break;
		case 't':		/* timing check */
			vflag = tflag = 1;
			break;
		}
		ac--;
		av++;
	}

	inittab();

#ifdef apollo
	cal_$sec_to_clock(1L, dit);
	dit.low32 /= speed * 6 / 5;
#endif

	if (iflag)
		while ((c = getchar()) != EOF)
			msend(c);
	else {
		while (ac > 1) {
			for (cp = av[1]; *cp; cp++)
				msend(*cp);
			msend(' ');
			ac--;
			av++;
		}
	}

	if (vflag)
		putchar('\n');
	exit(0);
}

inittab()
{
	struct morse *mtp;

	for (mtp = tab; mtp->c != 0; mtp++)
		mbits[mtp->c] = mtp->bits;
}

msend(c)
char c;
{
	char *cp;

	c &= 0x7f;
	if (c >= 'A' && c <= 'Z')
		c |= 0x20;

	for (cp = mbits[c]; cp != NULL && *cp; cp++) {
		switch (*cp) {
		case '.':
			mtone(DIT);
			break;
		case '-':
			mtone(DAH);
			break;
		case ' ':
			mwait(IWG - 2 * ICG);
			break;
		default:
			fprintf(stderr, "Bad table entry \"%s\" for '%c'\n", mbits[c], c);
			break;
		}
		mwait(IBG);
	}
	mwait(ICG - IBG);
}

mtone(n)
int n;
{
	if (tflag)
		ttone(n);
	else if (vflag)
		vtone(n);
	else
		stone(n);
}

ttone(n)
int n;
{
	while (n--)
		putchar('_');
}

vtone(n)
int n;
{
	if (n == 1)
		putchar('.');
	else if (n == 3)
		putchar('-');
	else
		printf("<tone %d>", n);
}

stone(n)
int n;
{
#ifdef apollo
	time_$clock_t t;

	t.high16 = dit.high16;
	t.low32 = dit.low32 * n;
	tone_$time(t);
#endif
}

mwait(n)
int n;
{
	if (vflag)
		vwait(n);
	else
		swait(n);
}

vwait(n)
int n;
{
	if (tflag)
		while (n--)
			putchar(' ');
	else if (n > 1)
		putchar(' ');
}

swait(n)
int n;
{
#ifdef apollo
	time_$clock_t t;
	status_$t st;

	t.high16 = dit.high16;
	t.low32 = dit.low32 * n;
	time_$wait(time_$relative, t, st);
#endif
}
