#ifndef INCLUDED_FLOPDRV
#define INCLUDED_FLOPDRV

/*
 * flopdrv.h
 *   Public definitions for the MSDOS floppy driver.
 *
 *   Version 1.1 - July 22, 1993
 *   Jef Rijmenants
 */

int flopdrv_acquire(
   char * ddf_pathname
);

int flopdrv_release();

int flopdrv_start_drive(
   unsigned int disk_type
);

int flopdrv_stop_drive();

int flopdrv_read_sector(
   unsigned int cyl_num,
   unsigned int head_num,
   unsigned int sect_num,
   unsigned char *sector_buffer
);

int flopdrv_write_sector(
   unsigned int cyl_num,
   unsigned int head_num,
   unsigned int sect_num,
   unsigned char *sector_buffer
);

int flopdrv_read_cylinder(
   unsigned int cyl_num,
   unsigned char *cylinder_buffer
);

int flopdrv_write_cylinder(
   unsigned int cyl_num,
   unsigned char *cylinder_buffer
);

int flopdrv_format_disk();

int flopdrv_get_drive_type();

int flopdrv_cylinder_io_possible();

#endif
