#ifndef INCLUDED_PBU
#define INCLUDED_PBU

#if _ISP__A88K
#define bytes_per_page  4096
#else
#define bytes_per_page  1024
#endif
typedef unsigned short pbu_$unit_t;
typedef char pbu_$buffer_t[bytes_per_page];

/* interrupts */
#define pbu_$interrupt_enable   0x1
#define pbu_$interrupt_advance  0x2
typedef unsigned short pbu_$interrupt_return_t;
typedef unsigned short pbu_$wait_index_t;

/* dma */
typedef unsigned short pbu_$dma_channel_t;
typedef short enum {
   pbu_$dma_read,
   pbu_$dma_write
} pbu_$dma_direction_t;
typedef short pbu_$dma_opts_t;

/* CSR page */
typedef char pbu_$csr_page_t[bytes_per_page];
typedef pbu_$csr_page_t *pbu_$csr_page_ptr_t;

/* DDF */
typedef char pbu_$ddf_int_list_entry_t[32];

typedef struct {
   short  xxxx_1;
   short  xxxx_2;
   unsigned short  xxxx_3;
#if _ISP__A88K  || _ISP__M68K
   uid_$t  dev_uid __attribute((__aligned(1)));
#else
   uid_$t  dev_uid;
#endif
   char  device_sn[16];
   char  call_lib_name[64];
   char  int_lib_name[64];
   char  init_ep[32];
   char  cleanup_ep[32];
   pbu_$ddf_int_list_entry_t  xxxx_4[8];
   pinteger  csr_page_iova;
   short  stack_size;
   char  rev[8];
   char  sn[16];
   char  user_info[64];
   short  xxxx_5;
   pinteger  xxxx_6;
   pinteger  xxxx_7;
   linteger  xxxx_8;
   linteger  xxxx_9;
   linteger  xxxx_10;
   short  dma_channel;
   pinteger  xxxx_11;
   pbu_$ddf_int_list_entry_t  xxxx_12[8];
   uid_$t  ddf_uid;
   pbu_$ddf_int_list_entry_t  xxxx_13[16];
   pinteger  xxxx_14;
   pinteger  xxxx_15;
   pinteger  xxxx_16;
} pbu_$ddf_t;

typedef pbu_$ddf_t *pbu_$ddf_ptr_t;

/* pbu routines */

extern void pbu_$acquire(
   name_$long_pname_t  pathname,
   short  &namelen,
   boolean  &xdebug,
   pbu_$unit_t  *unit,
   status_$t  *status
);

extern void pbu_$release (
   pbu_$unit_t  &unit,
   boolean  &force,
   status_$t  *status
);

extern void pbu_$dma_start(
   pbu_$unit_t  &unit,
   pbu_$dma_channel_t  &chan,
   pbu_$dma_direction_t  &direction,
   pbu_$buffer_t  buffer,
   pinteger  &length,
   pbu_$dma_opts_t  &opts,
   status_$t  *status
);

extern void pbu2_$dma_start(
   pbu_$unit_t  &unit,
   pbu_$dma_channel_t  &chan,
   pbu_$dma_direction_t  &direction,
   pbu_$buffer_t  buffer,
   linteger  &iova,
   linteger  &length,
   pbu_$dma_opts_t  &opts,
   status_$t  *status
);

extern long int pbu_$dma_stop(
   pbu_$unit_t  &unit,
   pbu_$dma_channel_t  &chan,
   status_$t  *status
);

extern long int pbu2_$dma_stop(
   pbu_$unit_t  &unit,
   pbu_$dma_channel_t  &chan,
   status_$t  *status
);

extern void pbu_$enable_device(
   pbu_$unit_t  &unit,
   status_$t  *status
);

extern void pbu_$disable_device(
   pbu_$unit_t  &unit,
   status_$t  *status
);

extern pbu_$wait_index_t pbu_$wait(
   pbu_$unit_t  &unit,
   long  &timeout,
   boolean  &quit_enable,
   status_$t  *status
);

extern void pbu2_$wire(
   pbu_$unit_t  &unit,
   pbu_$buffer_t  buffer,
   linteger  &length,
   status_$t  *status
);

extern void pbu2_$unwire(
   pbu_$unit_t  &unit,
   pbu_$buffer_t  buffer,
   linteger  &length,
   boolean  &touch,
   status_$t  *status
);

extern linteger pbu2_$allocate_map(
   pbu_$unit_t  &unit,
   linteger  &length,
   boolean  &force_flag,
   linteger  &iova,
   status_$t  *status
);

extern void pbu2_$free_map(
   pbu_$unit_t  &unit,
   status_$t  *status
);

extern linteger pbu2_$map(
   pbu_$unit_t  &unit,
   pbu_$buffer_t  buffer,
   linteger  &length,
   linteger  &iova,
   status_$t  *status
);

extern void pbu2_$unmap(
   pbu_$unit_t  &unit,
   pbu_$buffer_t  buffer,
   linteger  &length,
   linteger  &iova,
   status_$t  *status
);

extern void pbu_$get_info(
   pinteger  &length,
   short  *info,
   status_$t  *status
);

#endif
