/*
 * flopdrv.c
 *   The routines of the MSDOS floppy driver that the application
 *   needs to link with. The rest of the driver gets loaded when
 *   the device is acquired.
 *
 *   Version 1.1 - July 22, 1993
 *   Jef Rijmenants
 */


#include <stdio.h>
#include <apollo/base.h>
#include <apollo/error.h>
#include "pbu.h"
#include "flopdrv.h"
#include "flopdrv_priv.h"


pbu_$unit_t flopdrv_pbu_unit;


/*
 * flopdrv_acquire
 *   Acquire the device. The driver libraries are installed and
 *   the driver init routine gets called automatically.
 */
int flopdrv_acquire(
   char * ddf_pathname
)
{
   status_$t sts;
   boolean debug;
   int ret_sts;

   ret_sts = FLOPDRV_OK;
   debug = false;
   pbu_$acquire(ddf_pathname, (short)strlen(ddf_pathname), debug,
      &flopdrv_pbu_unit, &sts);
   if (sts.all != status_$ok) {
      fprintf(stderr, "ERROR: Failed to acquire device.\n");
      /* error_$print(sts); */
      ret_sts = FLOPDRV_FAIL;
   }
   return ret_sts;
}


/*
 * flopdrv_release()
 *   Release the device. The driver cleanup routine gets called
 *   automatically.
 */
int flopdrv_release()
{
   status_$t sts;
   boolean force;
   int ret_sts;

   ret_sts = FLOPDRV_OK;
   force = true;
   pbu_$release(flopdrv_pbu_unit, force, &sts);
   if (sts.all != status_$ok) {
      fprintf(stderr, "ERROR: Problem releasing device.\n");
      /* error_$print(sts); */
      ret_sts = FLOPDRV_FAIL;
   }
   return ret_sts;
}  
