/*
 * flopdrv_int.c
 *   GPIO interrupt-side routine(s) for the MSDOS floppy driver.
 *
 *   Version 1.1 - July 22, 1993
 *   Jef Rijmenants
 */

#include <stdio.h>
#include <apollo/base.h>
#include <apollo/error.h>
#include "pbu.h"
#include "flopdrv_priv.h"

/* the device control block must be allocated by the interrupt
   side (to have it wired, I guess) */
flopdrv_ctrl_blk_t flopdrv_cb;


/*
 * flopdrv_interrupt
 *   The GPIO driver interrupt service routine.
 */
pbu_$interrupt_return_t flopdrv_interrupt(
   pbu_$unit_t &unit
)
{
   /* check if a command was busy */
   if (flopdrv_cb.command_sts == FLOPDRV_CMD_BUSY) { 
      return pbu_$interrupt_advance + pbu_$interrupt_enable;
   }

   /* unexpected interrupts, should not happen, but ... */
   return pbu_$interrupt_enable;
}
