#ifndef INCLUDED_FLOPDRV_PRIV
#define INCLUDED_FLOPDRV_PRIV

/*
 * flopdrv_priv.h
 *   Private definitions for the MSDOS floppy driver.
 *
 *   Version 1.1 - July 22, 1993
 *   Jef Rijmenants
 */

#include "pbu.h"

/* floppy drive type */
#define FLOPDRV_3_5_DRIVE  0
#define FLOPDRV_5_25_DRIVE 1

/* floppy disk type */
#define FLOPDRV_DSHD_FLOPPY  0
#define FLOPDRV_DSDD_FLOPPY  1

/* command status */
#define FLOPDRV_CMD_NONE  0
#define FLOPDRV_CMD_BUSY  1

/* MSDOS standard sector size */
#define FLOPDRV_BYTES_PER_SECTOR  512

#define FLOPDRV_MAX_RETRIES 3
#define FLOPDRV_TIMEOUT_COUNT 100000

#define FLOPDRV_FAIL 0
#define FLOPDRV_OK   1
#define FLOPDRV_FALSE 0
#define FLOPDRV_TRUE  1

/* codes returned by pbu_$wait */
#define WAIT_EC_ADVANCE  0
#define WAIT_TIMEOUT     1
#define WAIT_QUIT        2


/*
 * CSR page (control and status registers)
 */
typedef struct {
   unsigned char pad_1;
   unsigned char pad_2;
   unsigned char do_reg;   /* WO reg, motor control, drive select */
   unsigned char pad_3;
   unsigned char stat_reg; /* RO reg, controllet status */
   unsigned char data_reg; /* RW reg, data, commands, reports */
   unsigned char pad_4;
   unsigned char di_reg;   /* RW, configuration */
   unsigned char pad_5[bytes_per_page-8];
} flopdrv_csr_page_t __attribute((__device));
typedef flopdrv_csr_page_t *flopdrv_csr_page_p;


/*
 * Driver control block (must be allocated in the interrupt part)
 */
typedef struct {
   pbu_$ddf_ptr_t ddf_p;     /* pointer to mapped ddf */
   flopdrv_csr_page_p csr_p; /* pointer to mapped csr page */   
   pbu_$unit_t pbu_unit;     /* pbu unit number */
   int command_sts;          /* command status */
} flopdrv_ctrl_blk_t __attribute((__device));
typedef flopdrv_ctrl_blk_t *flopdrv_ctrl_blk_p;

extern flopdrv_ctrl_blk_t flopdrv_cb;

/* if I/O map hardware is not present, DMA transfers are limited to 1 kb ! */
int flopdrv_iomap_present;


/*
 * user callable routines
 */
int flopdrv_start_drive(
   unsigned int disk_type
);

int flopdrv_stop_drive();

int flopdrv_read_sector(
   unsigned int cyl_num,
   unsigned int head_num,
   unsigned int sect_num,
   unsigned char *sector_buffer
);

int flopdrv_write_sector(
   unsigned int cyl_num,
   unsigned int head_num,
   unsigned int sect_num,
   unsigned char *sector_buffer
);

int flopdrv_read_cylinder(
   unsigned int cyl_num,
   unsigned char *cylinder_buffer
);

int flopdrv_write_cylinder(
   unsigned int cyl_num,
   unsigned char *cylinder_buffer
);
int flopdrv_format_track(
   unsigned int cyl_num,
   unsigned int head_num
);

int flopdrv_format_disk();

int flopdrv_get_drive_type();

int flopdrv_cylinder_io_possible();


/*
 * basic floppy commands
 */
int flopdrv_start_drive_cmd();

int flopdrv_stop_drive_cmd();

int flopdrv_calibrate_drive_cmd();

int flopdrv_position_head_cmd(
   unsigned int cylinder
);

int flopdrv_read_id_cmd();

int flopdrv_read_sector_cmd(
   unsigned int cyl_num,
   unsigned int head_num,
   unsigned int sect_num,
   unsigned char *sector_buffer
);

int flopdrv_write_sector_cmd(
   unsigned int cyl_num,
   unsigned int head_num,
   unsigned int sect_num,
   unsigned char *sector_buffer
);

int flopdrv_read_cylinder_cmd(
   unsigned int cyl_num,
   unsigned char *cylinder_buffer
);

int flopdrv_write_cylinder_cmd(
   unsigned int cyl_num,
   unsigned char *cylinder_buffer
);

int flopdrv_format_track_cmd(
   unsigned int cyl_num,
   unsigned int head_num
);


/*
 * control functions
 */
int flopdrv_put_command(
   unsigned char *command,
   unsigned int num_bytes
);

int flopdrv_get_status(
   unsigned char *status,
   unsigned int num_bytes
);


/*
 * debug routines
 */
void flopdrv_print_status_reg();

void flopdrv_print_status_info(
   unsigned int stat_type,
   unsigned char stat
);

void flopdrv_dump_sector(
   unsigned int cyl_num,
   unsigned int head_num,
   unsigned int sect_num
);

#endif
