/*****************************************************************************
    MTS include file

    11/24/92    mdl     written
    11/26/92    mdl     added remaining routine headers
    12/09/92    mdl     added driver_$rpd_t for 'standard' read position format
                        added driver_$direction_t for generic SCSI command
    01/15/93    mdl     removed Domain standard call formats per Tom Crewson
    02/01/93    mdl     added timeout parameter to generic call
    02/08/93    mdl     added ex_prewire and ex_preunwire calls to speed up large I/O
****************************************************************************/
typedef unsigned char buffer_ptr_t[10];

typedef long enum {                            /* scsi operation status */
       driver_good_status,
       driver_check_condition,
       driver_condition_met,
       driver_rsv1,
       driver_busy,
       driver_rsv2,
       driver_rsv3,
       driver_rsv4,
       driver_intermediate_good,
       driver_rsv5,
       driver_intermediate_condition_met,
       driver_rsv6,
       driver_reservation_conflict,
       driver_rsv7,
       driver_rsv8,
       driver_rsv9,
       driver_undefined_status
} driver_$status_t;

typedef short enum {                           /* i/o direction */
       driver_read,
       driver_write
} driver_$direction_t;

typedef union {                                /* read position returned data buffer structure */

       struct {                                /**** Read Position Data ****/
           unsigned short   bop:1;             /* (0:7)    beginning of partition (LBOT): 1 bit */
           unsigned short   eop:1;             /* (0:6)    end of partition (between LEOT & PEOT): 1 bit */
           unsigned short   rsv0_0:3;          /* (0:5-3)  reserved: 3 bits */
           unsigned short   bpu:1;             /* (0:2)    block position unknown: 1 bit */
           unsigned short   rsv0_1:2;          /* (0:1-0)  reserved: 2 bits */
           unsigned         partition:8;       /* (1)      partition number: 8 bits */
           unsigned         rsv2_3:16;         /* (2-3)    reserved: 16 bits */
           unsigned         first_block:32;    /* (4-7)    current block address: 32 bits */
           unsigned         last_block:32;     /* (8-11)   last block address - ignored: 32 bits */
           unsigned         rsv12_12:8;        /* (12)     reserved: 8 bits */
           unsigned         buffer_blocks:32;  /* (13-15)  number of blocks in buffer - ignored: 32 bits */
           unsigned         buffer_bytes:32;   /* (16-19)  number of bytes in buffer - ignored: 32 bits */
       } rpd;

       unsigned char all[12];

} driver_$rpd_t;

extern boolean  ex_prewired[7];
extern linteger scsi_$max_xfer_length;

extern void ex_initialize(                      /* initialize driver */
/*   unsigned char     scsi_id,                 /* scsi id of target device */
/*   status_$t        *d_status                 /* DomainOS returned status */
   );

extern void ex_terminate(                       /* clean up & terminate driver usage */
/*   unsigned char    &scsi_id,                   /* scsi id of target device */
/*   status_$t        *d_status                   /* DomainOS returned status */
   );

extern void ex_erase(                           /* erase command */
/*   unsigned char    &scsi_id,                   /* scsi id of target device */
/*   unsigned char    &cdb_byte_01,               /* 1st byte of CDB */
/*   driver_$status_t *status                     /* scsi status */
   );

extern void ex_generic(                         /* generic scsi command */
/*   unsigned char    &scsi_id,                   /* scsi id of target device */
/*   buffer_ptr_t     cdb,                        /* complete CDB */
/*   unsigned char    &cdb_length,                /* size of CDB */
/*   buffer_ptr_t     buffer_ptr,                 /* buffer for data read/written */
/*   linteger         &length,                    /* size of buffer */
/*   driver_$direction_t &write,                  /* true if writing to device, false if reading from device */
/*   linteger         &time,                      /* number of milliseconds to wait before command times out */
/*   driver_$status_t *status                     /* scsi status */
   );

extern void ex_inquiry(                         /* device inquiry command */
/*   unsigned char    &scsi_id,                   /* scsi id of target device */
/*   unsigned char    &cdb_byte_01,               /* 2nd byte of CDB */
/*   buffer_ptr_t     buffer_ptr,                 /* buffer for returned inquiry info */
/*   linteger         &length,                    /* size of buffer */
/*   driver_$status_t *status                     /* scsi status */
   );

extern void ex_load(                            /* load/unload command */
/*   unsigned char    &scsi_id,                   /* scsi id of target device */
/*   unsigned char    &cdb_byte_04,               /* 4th byte of CDB */
/*   driver_$status_t *status                     /* scsi status */
   );

extern void ex_locate(                          /* locate command */
/*   unsigned char    &scsi_id,                   /* scsi id of target device */
/*   unsigned char    &cdb_byte_01,               /* 2nd byte of CDB */
/*   linteger         &number,                    /* block address to locate */
/*   driver_$status_t *status                     /* scsi status */
   );

extern void ex_mode_select(                     /* mode select command */
/*   unsigned char    &scsi_id,                   /* scsi id of target device */
/*   unsigned char    &cdb_byte_01,               /* 2nd byte of CDB */
/*   buffer_ptr_t     buffer_ptr,                 /* buffer for mode select pages */
/*   linteger         &length,                    /* size of buffer */
/*   driver_$status_t *status                     /* scsi status */
   );

extern void ex_mode_sense(                      /* mode sense command */
/*   unsigned char    &scsi_id,                   /* scsi id of target device */
/*   unsigned char    &cdb_byte_01,               /* 2nd byte of CDB */
/*   unsigned char    &cdb_byte_02,               /* 3rd byte of CDB */
/*   buffer_ptr_t     buffer_ptr,                 /* buffer for mode sense pages */
/*   linteger         &length,                    /* size of buffer */
/*   driver_$status_t *status                     /* scsi status */
   );

extern void ex_prewire(                           /* wire buffer routine */
/*   unsigned char    &scsi_id,                   /* scsi id of target device */
/*   buffer_ptr_t     buffer_ptr,                 /* buffer to write */
/*   linteger         &length,                    /* size of buffer */
/*   status_$t        *status                     /* results of unwire */
   );

extern void ex_preunwire(                         /* unwire buffer routine */
/*   unsigned char    &scsi_id,                    /* scsi id of target device */
/*   status_$t        *status                      /* results of unwire */
   );

extern void ex_read(                            /* read command */
/*   unsigned char    &scsi_id,                   /* scsi id of target device */
/*   unsigned char    &cdb_byte_01,               /* 2nd byte of CDB */
/*   buffer_ptr_t     buffer_ptr,                 /* buffer for data read */
/*   linteger         &length,                    /* size of buffer */
/*   linteger         *length_read,               /* number of bytes read */
/*   driver_$status_t *status                     /* scsi status */
   );

extern void ex_read_block_limits(               /* read block limits command */
/*   unsigned char    &scsi_id,                   /* scsi id of target device */
/*   buffer_ptr_t     buffer_ptr,                 /* buffer for limits returned */
/*   driver_$status_t *status                     /* scsi status */
   );

extern void ex_read_position(                   /* read position command */
/*   unsigned char    &scsi_id,                   /* scsi id of target device */
/*   unsigned char    &cdb_byte_01,               /* 2nd byte of CDB */
/*   buffer_ptr_t     buffer_ptr,                 /* buffer for position data */
/*   driver_$status_t *status                     /* scsi status */
   );

extern void ex_request_sense(                   /* request sense command */
/*   unsigned char    &scsi_id,                   /* scsi id of target device */
/*   unsigned char    &cdb_byte_05,               /* 6th byte of CDB */
/*   buffer_ptr_t     buffer_ptr,                 /* buffer for sense data read */
/*   linteger         &length,                    /* size of buffer */
/*   driver_$status_t *status                     /* scsi status */
   );

extern void ex_rewind(                          /* rewind command */
/*   unsigned char    &scsi_id,                   /* scsi id of target device */
/*   driver_$status_t *status                     /* scsi status */
   );

extern void ex_space(                           /* space command */
/*   unsigned char    &scsi_id,                   /* scsi id of target device */
/*   unsigned char    &cdb_byte_01,               /* 2nd byte of CDB */
/*   unsigned char    &cdb_byte_05,               /* 6th byte of CDB */
/*   linteger         &number,                    /* number of "units" to space */
/*   driver_$status_t *status                     /* scsi status */
   );

extern void ex_test_unit_ready(                 /* test unit ready command */
/*   unsigned char    &scsi_id,                   /* scsi id of target device */
/*   driver_$status_t *status                     /* scsi status */
   );

extern void ex_verify(                          /* verify command */
/*   unsigned char    &scsi_id,                   /* scsi id of target device */
/*   unsigned char    &cdb_byte_01,               /* 2nd byte of CDB */
/*   linteger         &number,                    /* number of blocks to verify */
/*   driver_$status_t *status                     /* scsi status */
   );

extern void ex_write(                           /* write command */
/*   unsigned char    &scsi_id,                   /* scsi id of target device */
/*   unsigned char    &cdb_byte_01,               /* 2nd byte of CDB */
/*   buffer_ptr_t     buffer_ptr,                 /* buffer to write */
/*   linteger         &length,                    /* size of buffer */
/*   driver_$status_t *status                     /* scsi status */
   );

extern void ex_write_filemarks(                 /* write filemarks command */
/*   unsigned char    &scsi_id,                   /* scsi id of target device */
/*   unsigned char    &cdb_byte_01,               /* 2nd byte of CDB */
/*   unsigned char    &cdb_byte_05,               /* 6th byte of CDB */
/*   linteger         &number,                    /* number of filemarks to write */
/*   driver_$status_t *status                     /* scsi status */
   );
