/*******************************************************************************
*									       *
* smartIndent.c -- Maintain, and allow user to edit, macros for smart indent   *
*									       *
* Copyright (c) 1997 Universities Research Association, Inc.		       *
* All rights reserved.							       *
* 									       *
* This material resulted from work developed under a Government Contract and   *
* is subject to the following license:  The Government retains a paid-up,      *
* nonexclusive, irrevocable worldwide license to reproduce, prepare derivative *
* works, perform publicly and display publicly by or for the Government,       *
* including the right to distribute to other Government contractors.  Neither  *
* the United States nor the United States Department of Energy, nor any of     *
* their employees, makes any warrenty, express or implied, or assumes any      *
* legal liability or responsibility for the accuracy, completeness, or         *
* usefulness of any information, apparatus, product, or process disclosed, or  *
* represents that its use would not infringe privately owned rights.           *
*                                        				       *
* Fermilab Nirvana GUI Library						       *
* July, 1997								       *
*									       *
* Written by Mark Edel							       *
*									       *
*******************************************************************************/
#include <stdio.h>
#include <limits.h>
#include <Xm/Xm.h>
#ifdef VMS
#include "../util/VMSparam.h"
#else
#include <sys/param.h>
#endif /*VMS*/
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Text.h>
#include <Xm/LabelG.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/SeparatoG.h>
#include <Xm/PanedW.h>
#include "../util/DialogF.h"
#include "../util/misc.h"
#include "textBuf.h"
#include "nedit.h"
#include "text.h"
#include "preferences.h"
#include "interpret.h"
#include "macro.h"
#include "window.h"
#include "parse.h"
#include "shift.h"
#include "help.h"
#include "smartIndent.h"

static char MacroEndBoundary[] = "--End-of-Macro--";

typedef struct {
    char *lmName;
    char *initMacro;
    char *newlineMacro;
    char *modMacro;
} smartIndentRec;

typedef struct {
    Program *newlineMacro;
    Program *modMacro;
} windowSmartIndentData;

/* Smart indent macros dialog information */
static struct {
    Widget shell;
    Widget lmOptMenu;
    Widget lmPulldown;
    Widget initMacro;
    Widget newlineMacro;
    Widget modMacro;
    char *langModeName;
} SmartIndentDialog = {NULL};

/* Common smart indent macros dialog information */
static struct {
    Widget shell;
    Widget text;
} CommonDialog = {NULL};

static int NSmartIndentSpecs = 0;
static smartIndentRec *SmartIndentSpecs[MAX_LANGUAGE_MODES];
static char *CommonMacros = NULL;

static void executeNewlineMacro(WindowInfo *window,smartIndentCBStruct *cbInfo);
static void executeModMacro(WindowInfo *window,smartIndentCBStruct *cbInfo);
static void insertShiftedMacro(textBuffer *buf, char *macro);
static int isDefaultIndentSpec(smartIndentRec *indentSpec);
static smartIndentRec *findIndentSpec(char *modeName);
static char *ensureNewline(char *string);
static int loadDefaultIndentSpec(char *lmName);
static int siParseError(char *stringStart, char *stoppedAt, char *message);
static void destroyCB(Widget w, XtPointer clientData, XtPointer callData);
static void langModeCB(Widget w, XtPointer clientData, XtPointer callData);
static void commonDialogCB(Widget w, XtPointer clientData, XtPointer callData);
static void lmDialogCB(Widget w, XtPointer clientData, XtPointer callData);
static void okCB(Widget w, XtPointer clientData, XtPointer callData);
static void applyCB(Widget w, XtPointer clientData, XtPointer callData);
static void checkCB(Widget w, XtPointer clientData, XtPointer callData);
static void restoreCB(Widget w, XtPointer clientData, XtPointer callData);
static void deleteCB(Widget w, XtPointer clientData, XtPointer callData);
static void dismissCB(Widget w, XtPointer clientData, XtPointer callData);
static void helpCB(Widget w, XtPointer clientData, XtPointer callData);
static int checkSmartIndentDialogData(void);
static smartIndentRec *getSmartIndentDialogData(void);
static void setSmartIndentDialogData(smartIndentRec *is);
static void comDestroyCB(Widget w, XtPointer clientData, XtPointer callData);
static void comOKCB(Widget w, XtPointer clientData, XtPointer callData);
static void comApplyCB(Widget w, XtPointer clientData, XtPointer callData);
static void comCheckCB(Widget w, XtPointer clientData, XtPointer callData);
static void comRestoreCB(Widget w, XtPointer clientData, XtPointer callData);
static void comDismissCB(Widget w, XtPointer clientData, XtPointer callData);
static int updateSmartIndentCommonData(void);
static int checkSmartIndentCommonDialogData(void);
static int updateSmartIndentData(void);
static char *readSIMacro(char **inPtr);
static smartIndentRec *copyIndentSpec(smartIndentRec *is);
void freeIndentSpec(smartIndentRec *is);
int indentSpecsDiffer(smartIndentRec *is1, smartIndentRec *is2);

#define N_DEFAULT_INDENT_SPECS 3
static smartIndentRec DefaultIndentSpecs[N_DEFAULT_INDENT_SPECS] = {
{"C",
"# C Macros and tuning parameters are shared with C++, and are declared\n\
# in the common section.  Press Common / Shared Initialization above.\n",
"return cFindSmartIndentDist($1)\n",
"if ($2 == \"}\" || $2 == \"{\" || $2 == \"#\")\n\
    cBraceOrPound($1, $2)\n"},
{"C++",
"# C++ Macros and tuning parameters are shared with C, and are declared\n\
# in the common section.  Press Common / Shared Initialization above.\n",
"return cFindSmartIndentDist($1)\n",
"if ($2 == \"}\" || $2 == \"{\" || $2 == \"#\")\n\
    cBraceOrPound($1, $2)\n"},
{"Python",
"# Number of characters in a normal indent level.  May be a number, or the\n\
# string \"default\", meaning, guess the value from the current tab settings.\n\
$pyIndentDist = \"default\"\n",
"if (get_range($1-1, $1) != \":\")\n\
    return -1\n\
return measureIndent($1) + defaultIndent($pyIndentDist)\n", NULL}
};

static char DefaultCommonMacros[] = {'#','\n',
'#',' ','C','/','C','+','+',' ','S','t','y','l','e','/','t','u','n','i','n','g',' ','p','a','r','a','m','e','t','e','r','s','\n',
'#','\n',
'\n',
'#',' ','N','u','m','b','e','r',' ','o','f',' ','c','h','a','r','a','c','t','e','r','s',' ','i','n',' ','a',' ','n','o','r','m','a','l',' ','i','n','d','e','n','t',' ','l','e','v','e','l','.',' ',' ','M','a','y',' ','b','e',' ','a',' ','n','u','m','b','e','r',',',' ','o','r',' ','t','h','e','\n',
'#',' ','s','t','r','i','n','g',' ','\"','d','e','f','a','u','l','t','\"',',',' ','m','e','a','n','i','n','g',',',' ','g','u','e','s','s',' ','t','h','e',' ','v','a','l','u','e',' ','f','r','o','m',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','t','a','b',' ','s','e','t','t','i','n','g','s','.','\n',
'$','c','I','n','d','e','n','t','D','i','s','t',' ','=',' ','\"','d','e','f','a','u','l','t','\"','\n',
'\n',
'#',' ','N','u','m','b','e','r',' ','o','f',' ','c','h','a','r','a','c','t','e','r','s',' ','i','n',' ','a',' ','l','i','n','e',' ','c','o','n','t','i','n','u','a','t','i','o','n','.',' ',' ','M','a','y',' ','b','e',' ','a',' ','n','u','m','b','e','r',' ','o','r',' ','t','h','e','\n',
'#',' ','s','t','r','i','n','g',' ','\"','d','e','f','a','u','l','t','\"',',',' ','m','e','a','n','i','n','g',',',' ','g','u','e','s','s',' ','t','h','e',' ','v','a','l','u','e',' ','f','r','o','m',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','t','a','b',' ','s','e','t','t','i','n','g','s','.','\n',
'$','c','C','o','n','t','i','n','u','a','t','i','o','n','I','n','d','e','n','t',' ','=',' ','\"','d','e','f','a','u','l','t','\"','\n',
'\n',
'#',' ','H','o','w',' ','f','a','r',' ','b','a','c','k',' ','f','r','o','m',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','p','o','s','i','t','i','o','n',' ','t','o',' ','s','e','a','r','c','h',' ','f','o','r',' ','a','n',' ','a','n','c','h','o','r','i','n','g',' ','p','o','s','i','t','i','o','n','\n',
'#',' ','o','n',' ','w','h','i','c','h',' ','t','o',' ','b','a','s','e',' ','i','n','d','e','n','t','.',' ',' ','W','h','e','n',' ','n','o',' ','r','e','l','i','a','b','l','e',' ','i','n','d','i','c','a','t','o','r','s',' ','o','f',' ','p','r','o','p','e','r',' ','i','n','d','e','n','t',' ','l','e','v','e','l','\n',
'#',' ','c','a','n',' ','b','e',' ','f','o','u','n','d',' ','w','i','t','h','i','n',' ','t','h','e',' ','r','e','q','u','e','s','t','e','d',' ','d','i','s','t','a','n','c','e',',',' ','r','e','v','e','r','t','s',' ','t','o',' ','p','l','a','i','n',' ','a','u','t','o',' ','i','n','d','e','n','t','.','\n',
'$','c','M','a','x','S','e','a','r','c','h','B','a','c','k','L','i','n','e','s',' ','=',' ','1','0','\n',
'\n',
'#','\n',
'#',' ','F','i','n','d',' ','t','h','e',' ','s','t','a','r','t',' ','o','f',' ','t','h','e',' ','l','i','n','e',' ','c','o','n','t','a','i','n','i','n','g',' ','p','o','s','i','t','i','o','n',' ','$','1','\n',
'#','\n',
'd','e','f','i','n','e',' ','s','t','a','r','t','O','f','L','i','n','e',' ','{','\n',
'\n',
' ',' ',' ',' ','f','o','r',' ','(','i','=','$','1','-','1',';',' ',';',' ','i','-','-',')',' ','{','\n',
'	','i','f',' ','(','i',' ','<','=',' ','0',')','\n',
'	',' ',' ',' ',' ','r','e','t','u','r','n',' ','0','\n',
'	','i','f',' ','(','g','e','t','_','c','h','a','r','a','c','t','e','r','(','i',')',' ','=','=',' ','\"','\\','n','\"',')','\n',
'	',' ',' ',' ',' ','r','e','t','u','r','n',' ','i',' ','+',' ','1','\n',
' ',' ',' ',' ','}','\n',
'}','\n',
'\n',
'#','\n',
'#',' ','F','i','n','d',' ','t','h','e',' ','i','n','d','e','n','t',' ','l','e','v','e','l',' ','o','f',' ','t','h','e',' ','l','i','n','e',' ','c','o','n','t','a','i','n','i','n','g',' ','c','h','a','r','a','c','t','e','r',' ','p','o','s','i','t','i','o','n',' ','$','1','\n',
'#','\n',
'd','e','f','i','n','e',' ','m','e','a','s','u','r','e','I','n','d','e','n','t',' ','{','\n',
' ',' ',' ',' ','\n',
' ',' ',' ',' ','#',' ','m','e','a','s','u','r','e',' ','t','h','e',' ','i','n','d','e','n','t','a','t','i','o','n',' ','t','o',' ','t','h','e',' ','f','i','r','s','t',' ','n','o','n','-','w','h','i','t','e',' ','c','h','a','r','a','c','t','e','r',' ','o','n',' ','t','h','e',' ','l','i','n','e','\n',
' ',' ',' ',' ','i','n','d','e','n','t',' ','=',' ','0','\n',
' ',' ',' ',' ','f','o','r',' ','(','i','=','s','t','a','r','t','O','f','L','i','n','e','(','$','1',')',';',' ','i',' ','<',' ','$','t','e','x','t','_','l','e','n','g','t','h',';',' ','i','+','+',')',' ','{','\n',
'	','c',' ','=',' ','g','e','t','_','c','h','a','r','a','c','t','e','r','(','i',')','\n',
'	','i','f',' ','(','c',' ','!','=',' ','\"',' ','\"',' ','&','&',' ','c',' ','!','=',' ','\"','\\','t','\"',')','\n',
'	',' ',' ',' ',' ','b','r','e','a','k','\n',
'	','i','f',' ','(','c',' ','=','=',' ','\"','\\','t','\"',')','\n',
'	',' ',' ',' ',' ','i','n','d','e','n','t',' ','+','=',' ','$','t','a','b','_','d','i','s','t',' ','-',' ','(','i','n','d','e','n','t',' ','%',' ','$','t','a','b','_','d','i','s','t',')','\n',
'	','e','l','s','e','\n',
'	',' ',' ',' ',' ','i','n','d','e','n','t','+','+','\n',
' ',' ',' ',' ','}','\n',
' ',' ',' ',' ','r','e','t','u','r','n',' ','i','n','d','e','n','t','\n',
'}','\n',
'\n',
'#','\n',
'#',' ','M','a','k','e',' ','a',' ','s','t','r','i','n','g',' ','t','o',' ','p','r','o','d','u','c','e',' ','a','n',' ','i','n','d','e','n','t',' ','o','f',' ','$','1',' ','c','h','a','r','a','c','t','e','r','s','\n',
'#','\n',
'd','e','f','i','n','e',' ','m','a','k','e','I','n','d','e','n','t','S','t','r','i','n','g',' ','{','\n',
'\n',
' ',' ',' ',' ','i','f',' ','(','$','u','s','e','_','t','a','b','s',')',' ','{','\n',
'	','n','T','a','b','s',' ','=',' ','$','1',' ','/',' ','$','t','a','b','_','d','i','s','t','\n',
'	','n','S','p','a','c','e','s',' ','=',' ','$','1',' ','%',' ','$','t','a','b','_','d','i','s','t','\n',
' ',' ',' ',' ','}',' ','e','l','s','e',' ','{','\n',
'	','n','T','a','b','s',' ','=',' ','0','\n',
'	','n','S','p','a','c','e','s',' ','=',' ','$','1','\n',
' ',' ',' ',' ','}','\n',
' ',' ',' ',' ','i','n','d','e','n','t','S','t','r','i','n','g',' ','=',' ','\"','\"','\n',
' ',' ',' ',' ','f','o','r',' ','(','i','=','0',';',' ','i','<','n','T','a','b','s',';',' ','i','+','+',')','\n',
'	','i','n','d','e','n','t','S','t','r','i','n','g',' ','=',' ','i','n','d','e','n','t','S','t','r','i','n','g',' ','\"','\\','t','\"','\n',
' ',' ',' ',' ','f','o','r',' ','(','i','=','0',';',' ','i','<','n','S','p','a','c','e','s',';',' ','i','+','+',')','\n',
'	','i','n','d','e','n','t','S','t','r','i','n','g',' ','=',' ','i','n','d','e','n','t','S','t','r','i','n','g',' ','\"',' ','\"','\n',
' ',' ',' ',' ','r','e','t','u','r','n',' ','i','n','d','e','n','t','S','t','r','i','n','g','\n',
'}','\n',
'\n',
'#','\n',
'#',' ','I','f',' ','$','1',' ','i','s',' ','a',' ','n','u','m','b','e','r',',',' ','j','u','s','t',' ','p','a','s','s',' ','i','t',' ','o','n','.',' ',' ','I','f',' ','i','t',' ','i','s',' ','t','h','e',' ','s','t','r','i','n','g',' ','\"','d','e','f','a','u','l','t','\"',',','\n',
'#',' ','f','i','g','u','r','e',' ','o','u','t',' ','a',' ','r','e','a','s','o','n','a','b','l','e',' ','i','n','d','e','n','t',' ','d','i','s','t','a','n','c','e',' ','f','o','r',' ','a',' ','s','t','r','u','c','t','u','r','e','d',' ','l','a','n','g','u','a','g','e','s','\n',
'#',' ','l','i','k','e',' ','C',',',' ','b','a','s','e','d',' ','o','n',' ','h','o','w',' ','t','a','b','s',' ','a','r','e',' ','s','e','t','.','\n',
'#','\n',
'd','e','f','i','n','e',' ','d','e','f','a','u','l','t','I','n','d','e','n','t',' ','{','\n',
'\n',
' ',' ',' ',' ','i','f',' ','(','$','1',' ','!','=',' ','\"','d','e','f','a','u','l','t','\"',')','\n',
' ',' ',' ',' ','	','r','e','t','u','r','n',' ','$','1','\n',
' ',' ',' ',' ','i','f',' ','(','$','e','m','_','t','a','b','_','d','i','s','t',' ','!','=',' ','-','1',')','\n',
' ',' ',' ',' ','	','r','e','t','u','r','n',' ','$','e','m','_','t','a','b','_','d','i','s','t','\n',
' ',' ',' ',' ','i','f',' ','(','$','t','a','b','_','d','i','s','t',' ','<','=',' ','8',')','\n',
' ',' ',' ',' ','	','r','e','t','u','r','n',' ','$','t','a','b','_','d','i','s','t','\n',
' ',' ',' ',' ','r','e','t','u','r','n',' ','4','\n',
'}','\n',
' ',' ',' ','\n',
'#','\n',
'#',' ','I','f',' ','$','1',' ','i','s',' ','a',' ','n','u','m','b','e','r',',',' ','j','u','s','t',' ','p','a','s','s',' ','i','t',' ','o','n','.',' ',' ','I','f',' ','i','t',' ','i','s',' ','t','h','e',' ','s','t','r','i','n','g',' ','\"','d','e','f','a','u','l','t','\"',',','\n',
'#',' ','f','i','g','u','r','e',' ','o','u','t',' ','a',' ','r','e','a','s','o','n','a','b','l','e',' ','a','m','o','u','n','t',' ','o','f',' ','i','n','d','e','n','t','a','t','i','o','n',' ','f','o','r',' ','c','o','n','t','i','n','u','e','d',' ','l','i','n','e','s','\n',
'#',' ','b','a','s','e','d',' ','o','n',' ','h','o','w',' ','t','a','b','s',' ','a','r','e',' ','s','e','t','.','\n',
'#','\n',
'd','e','f','i','n','e',' ','d','e','f','a','u','l','t','C','o','n','t','I','n','d','e','n','t',' ','{','\n',
'\n',
' ',' ',' ',' ','i','f',' ','(','$','1',' ','!','=',' ','\"','d','e','f','a','u','l','t','\"',')','\n',
' ',' ',' ',' ','	','r','e','t','u','r','n',' ','$','1','\n',
' ',' ',' ',' ','i','f',' ','(','$','e','m','_','t','a','b','_','d','i','s','t',' ','!','=',' ','-','1',')','\n',
' ',' ',' ',' ','	','r','e','t','u','r','n',' ','$','e','m','_','t','a','b','_','d','i','s','t',' ','*',' ','2','\n',
' ',' ',' ',' ','i','f',' ','(','$','t','a','b','_','d','i','s','t',' ','<','=',' ','8',')','\n',
' ',' ',' ',' ','	','r','e','t','u','r','n',' ','$','t','a','b','_','d','i','s','t',' ','*',' ','2','\n',
' ',' ',' ',' ','r','e','t','u','r','n',' ','8','\n',
'}','\n',
'\n',
'#','\n',
'#',' ','F','i','n','d',' ','t','h','e',' ','e','n','d',' ','o','f',' ','t','h','e',' ','c','o','n','d','i','t','i','o','n','a','l',' ','p','a','r','t',' ','o','f',' ','i','f','/','w','h','i','l','e','/','f','o','r',',',' ','b','y',' ','l','o','o','k','i','n','g',' ','f','o','r',' ','b','a','l','a','n','c','e','d','\n',
'#',' ','p','a','r','e','n','t','h','e','s','i','s',' ','b','e','t','w','e','e','n',' ','$','1',' ','a','n','d',' ','$','2','.',' ',' ','r','e','t','u','r','n','s',' ','-','1',' ','i','f',' ','p','a','r','e','n','s',' ','d','o','n',''','t',' ','b','a','l','a','n','c','e',' ','b','e','f','o','r','e','\n',
'#',' ','$','2',',',' ','o','r',' ','i','f',' ','n','o',' ','p','a','r','e','n','s',' ','a','r','e',' ','f','o','u','n','d','\n',
'#','\n',
'd','e','f','i','n','e',' ','f','i','n','d','B','a','l','a','n','c','i','n','g','P','a','r','e','n',' ','{','\n',
'\n',
' ',' ',' ',' ','o','p','e','n','P','a','r','e','n','s',' ','=',' ','0','\n',
' ',' ',' ',' ','p','a','r','e','n','s','F','o','u','n','d',' ','=',' ','0','\n',
' ',' ',' ',' ','f','o','r',' ','(','i','=','$','1',';',' ','i','<','$','2',';',' ','i','+','+',')',' ','{','\n',
'	','c',' ','=',' ','g','e','t','_','c','h','a','r','a','c','t','e','r','(','i',')','\n',
'	','i','f',' ','(','c',' ','=','=',' ','\"','(','\"',')',' ','{','\n',
'	',' ',' ',' ',' ','o','p','e','n','P','a','r','e','n','s','+','+','\n',
'	',' ',' ',' ',' ','p','a','r','e','n','s','F','o','u','n','d',' ','=',' ','1','\n',
'	','}',' ','e','l','s','e',' ','i','f',' ','(','c',' ','=','=',' ','\"',')','\"',')','\n',
'	',' ',' ',' ',' ','o','p','e','n','P','a','r','e','n','s','-','-','\n',
'	','e','l','s','e',' ','i','f',' ','(','!','p','a','r','e','n','s','F','o','u','n','d',' ','&','&',' ','c',' ','!','=',' ','\"',' ','\"',' ','&','&',' ','c',' ','!','=',' ','\"','\\','t','\"',')','\n',
'	',' ',' ',' ',' ','r','e','t','u','r','n',' ','-','1','\n',
'	','i','f',' ','(','p','a','r','e','n','s','F','o','u','n','d',' ','&','&',' ','o','p','e','n','P','a','r','e','n','s',' ','<','=','0',')','\n',
'	',' ',' ',' ',' ','r','e','t','u','r','n',' ','i','+','1','\n',
' ',' ',' ',' ','}','\n',
' ',' ',' ',' ','r','e','t','u','r','n',' ','-','1','\n',
'}','\n',
'\n',
'#','\n',
'#',' ','S','k','i','p',' ','o','v','e','r',' ','b','l','a','n','k',' ','s','p','a','c','e',' ','a','n','d',' ','c','o','m','m','e','n','t','s',' ','a','n','d',' ','p','r','e','p','r','o','c','e','s','s','o','r',' ','d','i','r','e','c','t','i','v','e','s',' ','f','r','o','m',' ','p','o','s','i','t','i','o','n','\n',
'#',' ','$','1',' ','t','o',' ','a',' ','m','a','x','i','m','u','m',' ','o','f',' ','$','2','.','\n',
'#',' ','i','f',' ','$','3',' ','i','s',' ','n','o','n','-','z','e','r','o',',',' ','n','e','w','l','i','n','e','s',' ','a','r','e',' ','c','o','n','s','i','d','e','r','e','d',' ','b','l','a','n','k',' ','s','p','a','c','e',' ','a','s',' ','w','e','l','l','.',' ',' ','R','e','t','u','r','n',' ','-','1','\n',
'#',' ','i','f',' ','t','h','e',' ','m','a','x','i','m','u','m',' ','p','o','s','i','t','i','o','n',' ','(','$','2',')',' ','i','s',' ','h','i','t',' ','m','i','d','-','c','o','m','m','e','n','t',' ','o','r',' ','m','i','d','-','d','i','r','e','c','t','i','v','e','\n',
'#','\n',
'd','e','f','i','n','e',' ','c','S','k','i','p','B','l','a','n','k','S','p','a','c','e',' ','{','\n',
' ',' ',' ',' ','\n',
' ',' ',' ',' ','f','o','r',' ','(','i','=','$','1',';',' ','i','<','$','2',';',' ','i','+','+',')',' ','{','\n',
'	','c',' ','=',' ','g','e','t','_','c','h','a','r','a','c','t','e','r','(','i',')','\n',
'	','i','f',' ','(','c',' ','=','=',' ','\"','/','\"',')',' ','{','\n',
'	',' ',' ',' ',' ','i','f',' ','(','i','+','1',' ','>','=',' ','$','2',')','\n',
'	','	','r','e','t','u','r','n',' ','i','\n',
'	',' ',' ',' ',' ','i','f',' ','(','g','e','t','_','c','h','a','r','a','c','t','e','r','(','i','+','1',')',' ','=','=',' ','\"','*','\"',')',' ','{','\n',
'	','	','f','o','r',' ','(','i','=','i','+','1',';',' ',';',' ','i','+','+',')',' ','{','\n',
'	','	',' ',' ',' ',' ','i','f',' ','(','i','+','1',' ','>','=',' ','$','2',')','\n',
'	','	','	','r','e','t','u','r','n',' ','-','1','\n',
'	','	',' ',' ',' ',' ','i','f',' ','(','g','e','t','_','c','h','a','r','a','c','t','e','r','(','i',')',' ','=','=',' ','\"','*','\"',' ','&','&',' ','g','e','t','_','c','h','a','r','a','c','t','e','r','(','i','+','1',')',' ','=','=',' ','\"','/','\"',')',' ','{','\n',
'	','	','	','i','+','+','\n',
'	','	','	','b','r','e','a','k','\n',
'	','	',' ',' ',' ',' ','}','\n',
'	','	','}','\n',
'	',' ',' ',' ',' ','}',' ','e','l','s','e',' ','i','f',' ','(','g','e','t','_','c','h','a','r','a','c','t','e','r','(','i','+','1',')',' ','=','=',' ','\"','/','\"',')',' ','{','\n',
'	','	','f','o','r',' ','(','i','=','i','+','1',';',' ','i','<','$','2',';',' ','i','+','+',')',' ','{','\n',
'	','	',' ',' ',' ',' ','i','f',' ','(','g','e','t','_','c','h','a','r','a','c','t','e','r','(','i',')',' ','=','=',' ','\"','\\','n','\"',')',' ','{','\n',
'	','	','	','i','f',' ','(','!','$','3',')','\n',
'	','	','	',' ',' ',' ',' ','r','e','t','u','r','n',' ','i','\n',
'	','	','	','b','r','e','a','k','\n',
'	','	',' ',' ',' ',' ','}','\n',
'	','	','}','\n',
'	',' ',' ',' ',' ','}','\n',
'	','}',' ','e','l','s','e',' ','i','f',' ','(','c',' ','=','=',' ','\"','#','\"',' ','&','&',' ','$','3',')',' ','{','\n',
'	',' ',' ',' ',' ','f','o','r',' ','(','i','=','i','+','1',';',' ',';',' ','i','+','+',')',' ','{','\n',
'	','	','i','f',' ','(','i',' ','>','=',' ','$','2',')',' ','{','\n',
'	','	',' ',' ',' ',' ','i','f',' ','(','g','e','t','_','c','h','a','r','a','c','t','e','r','(','i','-','1',')',' ','=','=',' ','\"','\\','\\','\"',')','\n',
'	','	','	','r','e','t','u','r','n',' ','-','1','\n',
'	','	',' ',' ',' ',' ','e','l','s','e','\n',
'	','	','	','b','r','e','a','k','\n',
'	','	','}','\n',
'	','	','i','f',' ','(','g','e','t','_','c','h','a','r','a','c','t','e','r','(','i',')',' ','=','=',' ','\"','\\','n','\"',' ','&','&',' ','g','e','t','_','c','h','a','r','a','c','t','e','r','(','i','-','1',')',' ','!','=',' ','\"','\\','\\','\"',')','\n',
'	','	',' ',' ',' ',' ','b','r','e','a','k','\n',
'	',' ',' ',' ',' ','}','\n',
'	','}',' ','e','l','s','e',' ','i','f',' ','(','!','(','c',' ','=','=',' ','\"',' ','\"',' ','|','|',' ','c',' ','=','=',' ','\"','\\','t','\"',' ','|','|',' ','(','$','3',' ','&','&',' ','c','=','=','\"','\\','n','\"',')',')',')','\n',
'	',' ',' ',' ',' ','r','e','t','u','r','n',' ','i','\n',
' ',' ',' ',' ','}','\n',
' ',' ',' ',' ','r','e','t','u','r','n',' ','$','2','\n',
'}','\n',
'\n',
'#','\n',
'#',' ','S','e','a','r','c','h',' ','b','a','c','k','w','a','r','d',' ','f','o','r',' ','a','n',' ','a','n','c','h','o','r',' ','p','o','i','n','t',':',' ','a',' ','l','i','n','e',' ','e','n','d','i','n','g',' ','b','r','a','c','e',',',' ','o','r',' ','s','e','m','i','c','o','l','o','n','\n',
'#',' ','o','r',' ','c','a','s','e',' ','s','t','a','t','e','m','e','n','t',',',' ','f','o','l','l','o','w','e','d',' ','(','i','g','n','o','r','i','n','g',' ','b','l','a','n','k',' ','l','i','n','e','s',' ','a','n','d',' ','c','o','m','m','e','n','t','s',')',' ','b','y',' ','w','h','a','t',' ','w','e','\n',
'#',' ','a','s','s','u','m','e',' ','i','s',' ','a',' ','p','r','o','p','e','r','l','y',' ','i','n','d','e','n','t','e','d',' ','l','i','n','e',',',' ','a',' ','b','r','a','c','e',' ','o','n',' ','a',' ','l','i','n','e',' ','b','y',' ','i','t','s','e','l','f',',',' ','o','r',' ','a',' ','c','a','s','e','\n',
'#',' ','s','t','a','t','e','m','e','n','t','.',' ',' ','R','e','t','u','r','n','s',' ','t','h','e',' ','p','o','s','i','t','i','o','n',' ','o','f',' ','t','h','e',' ','f','i','r','s','t',' ','n','o','n','-','w','h','i','t','e',',',' ','n','o','n',' ','c','o','m','m','e','n','t','\n',
'#',' ','c','h','a','r','a','c','t','e','r',' ','o','n',' ','t','h','e',' ','l','i','n','e','.',' ',' ','r','e','t','u','r','n','s',' ','-','1',' ','i','f',' ','a','n',' ','a','n','c','h','o','r',' ','p','o','s','i','t','i','o','n',' ','c','a','n',''','t',' ','b','e',' ','f','o','u','n','d','\n',
'#',' ','b','e','f','o','r','e',' ','$','c','M','a','x','S','e','a','r','c','h','B','a','c','k','L','i','n','e','s','.','\n',
'#','\n',
'd','e','f','i','n','e',' ','c','F','i','n','d','I','n','d','e','n','t','A','n','c','h','o','r','P','o','i','n','t',' ','{','\n',
'\n',
' ',' ',' ',' ','n','L','i','n','e','s',' ','=',' ','0','\n',
' ',' ',' ',' ','a','n','c','h','o','r','P','o','s',' ','=',' ','$','1','\n',
' ',' ',' ',' ','f','o','r',' ','(','i','=','$','1','-','1',';',' ','i','>','0',';',' ','i','-','-',')',' ','{','\n',
'	','c',' ','=',' ','g','e','t','_','c','h','a','r','a','c','t','e','r','(','i',')','\n',
'	','i','f',' ','(','c',' ','=','=',' ','\"',';','\"',' ','|','|',' ','c',' ','=','=',' ','\"','{','\"',' ','|','|',' ','c',' ','=','=',' ','\"','}','\"',' ','|','|',' ','c',' ','=','=',' ','\"',':','\"',')',' ','{','\n',
'\n',
'	',' ',' ',' ',' ','#',' ','V','e','r','i','f','y',' ','t','h','a','t',' ','i','t',''','s',' ','l','i','n','e',' ','e','n','d','i','n','g','\n',
'	',' ',' ',' ',' ','l','i','n','e','E','n','d',' ','=',' ','c','S','k','i','p','B','l','a','n','k','S','p','a','c','e','(','i','+','1',',',' ','$','1',',',' ','0',')','\n',
'	',' ',' ',' ',' ','i','f',' ','(','l','i','n','e','E','n','d',' ','=','=',' ','-','1',' ','|','|',' ','\\','\n',
'	',' ',' ',' ',' ','	',' ',' ',' ',' ','(','l','i','n','e','E','n','d',' ','!','=',' ','$','t','e','x','t','_','l','e','n','g','t','h',' ','&','&',' ','g','e','t','_','c','h','a','r','a','c','t','e','r','(','l','i','n','e','E','n','d',')',' ','!','=',' ','\"','\\','n','\"',')',')','\n',
' ',' ',' ','	','	','c','o','n','t','i','n','u','e','\n',
'\n',
'	',' ',' ',' ',' ','#',' ','i','f',' ','i','t',''','s',' ','a',' ','c','o','l','o','n',',',' ','i','t',''','s',' ','o','n','l','y',' ','m','e','a','n','i','n','g','f','u','l',' ','i','f',' ','\"','c','a','s','e','\"',' ','b','e','g','i','n','s',' ','t','h','e',' ','l','i','n','e','\n',
'	',' ',' ',' ',' ','i','f',' ','(','c',' ','=','=',' ','\"',':','\"',')',' ','{','\n',
'	',' ',' ',' ',' ','	','l','i','n','e','S','t','a','r','t',' ','=',' ','s','t','a','r','t','O','f','L','i','n','e','(','i',')','\n',
'	','	','c','a','s','e','S','t','a','r','t',' ','=',' ','c','S','k','i','p','B','l','a','n','k','S','p','a','c','e','(','l','i','n','e','S','t','a','r','t',',',' ','l','i','n','e','E','n','d',',',' ','0',')','\n',
'	','	','i','f',' ','(','g','e','t','_','r','a','n','g','e','(','c','a','s','e','S','t','a','r','t',',',' ','c','a','s','e','S','t','a','r','t','+','4',')',' ','!','=',' ','\"','c','a','s','e','\"',')','\n',
'	','	',' ',' ',' ',' ','c','o','n','t','i','n','u','e','\n',
'	','	','d','e','l','i','m',' ','=',' ','g','e','t','_','c','h','a','r','a','c','t','e','r','(','c','a','s','e','S','t','a','r','t','+','4',')','\n',
'	','	','i','f',' ','(','d','e','l','i','m','!','=','\"',' ','\"',' ','&','&',' ','d','e','l','i','m','!','=','\"','\\','t','\"',' ','&','&',' ','d','e','l','i','m','!','=','\"','(','\"',' ','&','&',' ','d','e','l','i','m','!','=','\"',':','\"',')','\n',
'	','	',' ',' ',' ',' ','c','o','n','t','i','n','u','e','\n',
'	','	','i','s','C','a','s','e',' ','=',' ','1','\n',
'	',' ',' ',' ',' ','}',' ','e','l','s','e','\n',
'	',' ',' ',' ',' ','	','i','s','C','a','s','e',' ','=',' ','0','\n',
'\n',
'	',' ',' ',' ',' ','#',' ','M','o','v','e',' ','f','o','r','w','a','r','d',' ','p','a','s','t',' ','b','l','a','n','k',' ','l','i','n','e','s',' ','a','n','d',' ','c','o','m','m','e','n','t',' ','l','i','n','e','s',' ','t','o',' ','f','i','n','d','\n',
'	',' ',' ',' ',' ','#',' ',' ',' ',' ','n','o','n','-','b','l','a','n','k',',',' ','n','o','n','-','c','o','m','m','e','n','t',' ','l','i','n','e','-','s','t','a','r','t','\n',
'	',' ',' ',' ',' ','a','n','c','h','o','r','P','o','s',' ','=',' ','c','S','k','i','p','B','l','a','n','k','S','p','a','c','e','(','l','i','n','e','E','n','d',',',' ','$','1',',',' ','1',')','\n',
'\n',
'	',' ',' ',' ',' ','#',' ','A','c','c','e','p','t',' ','i','f',' ','i','t',''','s',' ','b','e','f','o','r','e',' ','t','h','e',' ','r','e','q','u','e','s','t','e','d',' ','p','o','s','i','t','i','o','n',',',' ','o','t','h','e','r','w','i','s','e','\n',
'	',' ',' ',' ',' ','#',' ',' ',' ',' ','c','o','n','t','i','n','u','e',' ','f','u','r','t','h','e','r',' ','b','a','c','k',' ','i','n',' ','t','h','e',' ','f','i','l','e',' ','a','n','d',' ','t','r','y',' ','a','g','a','i','n','\n',
'	',' ',' ',' ',' ','i','f',' ','(','a','n','c','h','o','r','P','o','s',' ','!','=',' ','-','1',' ','&','&',' ','a','n','c','h','o','r','P','o','s',' ','<',' ','$','1',')','\n',
'	','	','b','r','e','a','k','\n',
'\n',
'	',' ',' ',' ',' ','#',' ','A',' ','c','a','s','e',' ','s','t','a','t','e','m','e','n','t',' ','b','y',' ','i','t','s','e','l','f',' ','i','s',' ','a','n',' ','a','c','c','e','p','t','a','b','l','e',' ','a','n','c','h','o','r','\n',
'	',' ',' ',' ',' ','i','f',' ','(','i','s','C','a','s','e',')','\n',
'	',' ',' ',' ',' ','	','r','e','t','u','r','n',' ','c','a','s','e','S','t','a','r','t','\n',
'\n',
'	',' ',' ',' ',' ','#',' ','A',' ','b','r','a','c','e',' ','o','n',' ','a',' ','l','i','n','e',' ','b','y',' ','i','t','s','e','l','f',' ','i','s',' ','a','n',' ','a','c','c','e','p','t','a','b','l','e',' ','a','n','c','h','o','r',',',' ','e','v','e','n','\n',
'	',' ',' ',' ',' ','#',' ',' ',' ',' ','i','f',' ','i','t',' ','d','o','e','s','n',''','t',' ','f','o','l','l','o','w',' ','a',' ','s','e','m','i','c','o','l','o','n',' ','o','r',' ','a','n','o','t','h','e','r',' ','b','r','a','c','e','\n',
'	',' ',' ',' ',' ','i','f',' ','(','c',' ','=','=',' ','\"','{','\"',' ','|','|',' ','c',' ','=','=',' ','\"','}','\"',')',' ','{','\n',
'	','	','f','o','r',' ','(','j',' ','=',' ','i','-','1',';',' ',';',' ','j','-','-',')',' ','{','\n',
'	','	',' ',' ',' ',' ','i','f',' ','(','j',' ','=','=',' ','0',')','\n',
'	','	','	','r','e','t','u','r','n',' ','i','\n',
'	','	',' ',' ',' ',' ','c','h',' ','=',' ','g','e','t','_','c','h','a','r','a','c','t','e','r','(','j',')','\n',
'	','	',' ',' ',' ',' ','i','f',' ','(','c','h',' ','=','=',' ','\"','\\','n','\"',')','\n',
'	','	',' ',' ',' ',' ',' ',' ',' ','r','e','t','u','r','n',' ','i','\n',
'	','	',' ',' ',' ',' ','i','f',' ','(','c','h',' ','!','=',' ','\"','\\','t','\"',' ','&','&',' ','c','h',' ','!','=',' ','\"',' ','\"',')','\n',
'	','	',' ',' ',' ',' ',' ',' ',' ','b','r','e','a','k','\n',
'	','	','}','\n',
'	',' ',' ',' ',' ','}','\n',
'\n',
'	','}',' ','e','l','s','e',' ','i','f',' ','(','c',' ','=','=',' ','\"','\\','n','\"',')','\n',
'	',' ',' ',' ',' ','i','f',' ','(','+','+','n','L','i','n','e','s',' ','>',' ','$','c','M','a','x','S','e','a','r','c','h','B','a','c','k','L','i','n','e','s',')','\n',
'	','	','r','e','t','u','r','n',' ','-','1','\n',
' ',' ',' ',' ','}','\n',
' ',' ',' ',' ','i','f',' ','(','i',' ','<','=',' ','0',')','\n',
'	','r','e','t','u','r','n',' ','-','1','\n',
' ',' ',' ',' ','r','e','t','u','r','n',' ','a','n','c','h','o','r','P','o','s','\n',
'}','\n',
'\n',
'#','\n',
'#',' ','a','d','j','u','s','t',' ','t','h','e',' ','i','n','d','e','n','t',' ','o','n',' ','a',' ','l','i','n','e',' ','a','b','o','u','t',' ','t','o',' ','r','e','c','i','v','e',' ','e','i','t','h','e','r',' ','a',' ','r','i','g','h','t',' ','o','r',' ','l','e','f','t',' ','b','r','a','c','e','\n',
'#',' ','o','r',' ','p','o','u','n','d',' ','(','#',')',' ','c','h','a','r','a','c','t','e','r',' ','(','$','2',')',' ','f','o','l','l','o','w','i','n','g',' ','p','o','s','i','t','i','o','n',' ','$','1','\n',
'#','\n',
'd','e','f','i','n','e',' ','c','B','r','a','c','e','O','r','P','o','u','n','d',' ','{','\n',
'\n',
' ',' ',' ',' ','#',' ','F','i','n','d',' ','s','t','a','r','t',' ','o','f',' ','t','h','e',' ','l','i','n','e',',',' ','a','n','d',' ','m','a','k','e',' ','s','u','r','e',' ','t','h','e','r','e',''','s',' ','n','o','t','h','i','n','g',' ','b','u','t',' ','w','h','i','t','e','-','s','p','a','c','e','\n',
' ',' ',' ',' ','#',' ',' ',' ','b','e','f','o','r','e',' ','t','h','e',' ','c','h','a','r','a','c','t','e','r','.',' ',' ','I','f',' ','t','h','e','r','e',''','s',' ','a','n','y','t','h','i','n','g',' ','b','e','f','o','r','e',' ','i','t',',',' ','d','o',' ','n','o','t','h','i','n','g','\n',
' ',' ',' ',' ','f','o','r',' ','(','i','=','$','1','-','1',';',' ',';',' ','i','-','-',')',' ','{','\n',
'	','i','f',' ','(','i',' ','<',' ','0',')',' ','{','\n',
'	',' ',' ',' ',' ','l','i','n','e','S','t','a','r','t',' ','=',' ','0','\n',
'	',' ',' ',' ',' ','b','r','e','a','k','\n',
'	','}','\n',
'	','c',' ','=',' ','g','e','t','_','c','h','a','r','a','c','t','e','r','(','i',')','\n',
'	','i','f',' ','(','c',' ','=','=',' ','\"','\\','n','\"',')',' ','{','\n',
'	',' ',' ',' ',' ','l','i','n','e','S','t','a','r','t',' ','=',' ','i',' ','+',' ','1','\n',
'	',' ',' ',' ',' ','b','r','e','a','k','\n',
'	','}','\n',
'	','i','f',' ','(','c',' ','!','=',' ','\"',' ','\"',' ','&','&',' ','c',' ','!','=',' ','\"','\\','t','\"',')','\n',
'	',' ',' ',' ',' ','r','e','t','u','r','n','\n',
' ',' ',' ',' ','}','\n',
'\n',
' ',' ',' ',' ','#',' ','I','f',' ','t','h','e',' ','c','h','a','r','a','c','t','e','r',' ','w','a','s',' ','a',' ','p','o','u','n','d',',',' ','d','r','a','g',' ','i','t',' ','a','l','l',' ','t','h','e',' ','w','a','y',' ','t','o',' ','t','h','e',' ','l','e','f','t',' ','m','a','r','g','i','n','\n',
' ',' ',' ',' ','i','f',' ','(','$','2',' ','=','=',' ','\"','#','\"',')',' ','{','\n',
'	','r','e','p','l','a','c','e','_','r','a','n','g','e','(','l','i','n','e','S','t','a','r','t',',',' ','$','1',',',' ','\"','\"',')','\n',
'	','r','e','t','u','r','n','\n',
' ',' ',' ',' ','}','\n',
'\n',
' ',' ',' ',' ','#',' ','F','i','n','d',' ','t','h','e',' ','p','o','s','i','t','i','o','n',' ','o','n',' ','w','h','i','c','h',' ','t','o',' ','b','a','s','e',' ','t','h','e',' ','i','n','d','e','n','t','\n',
' ',' ',' ',' ','i','n','d','e','n','t',' ','=',' ','c','F','i','n','d','S','m','a','r','t','I','n','d','e','n','t','D','i','s','t','(','$','1',' ','-',' ','1',',',' ','\"','n','o','C','o','n','t','i','n','u','e','\"',')','\n',
' ',' ',' ',' ','i','f',' ','(','i','n','d','e','n','t',' ','=','=',' ','-','1',')','\n',
'	','r','e','t','u','r','n','\n',
' ',' ',' ',' ','\n',
' ',' ',' ',' ','#',' ','A','d','j','u','s','t',' ','t','h','e',' ','i','n','d','e','n','t',' ','i','f',' ','i','t',''','s',' ','a',' ','r','i','g','h','t',' ','b','r','a','c','e',' ','(','l','e','f','t',' ','n','e','e','d','s',' ','n','o',' ','a','d','j','u','s','t','m','e','n','t',')','\n',
' ',' ',' ',' ','i','f',' ','(','$','2',' ','=','=',' ','\"','}','\"',')',' ','{','\n',
'	','i','n','d','e','n','t',' ','-','=',' ','d','e','f','a','u','l','t','I','n','d','e','n','t','(','$','c','I','n','d','e','n','t','D','i','s','t',')','\n',
' ',' ',' ',' ',' ',' ',' ',' ','i','f',' ','(','i','n','d','e','n','t',' ','<',' ','0',')','\n',
'	',' ',' ',' ',' ','i','n','d','e','n','t',' ','=',' ','0','\n',
' ',' ',' ',' ','}','\n',
'\n',
' ',' ',' ',' ','#',' ','R','e','p','l','a','c','e',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','i','n','d','e','n','t',' ','w','i','t','h',' ','t','h','e',' ','n','e','w',' ','i','n','d','e','n','t',' ','s','t','r','i','n','g','\n',
' ',' ',' ',' ','i','n','s','e','r','t','S','t','r',' ','=',' ','m','a','k','e','I','n','d','e','n','t','S','t','r','i','n','g','(','i','n','d','e','n','t',')','\n',
' ',' ',' ',' ','r','e','p','l','a','c','e','_','r','a','n','g','e','(','l','i','n','e','S','t','a','r','t',',',' ','$','1',',',' ','i','n','s','e','r','t','S','t','r',')','\n',
'}','\n',
'\n',
'#','\n',
'#',' ','F','i','n','d',' ','S','m','a','r','t',' ','I','n','d','e','n','t',' ','D','i','s','t','a','n','c','e',' ','f','o','r',' ','a',' ','n','e','w','l','i','n','e',' ','c','h','a','r','a','c','t','e','r',' ','i','n','s','e','r','t','e','d',' ','a','t',' ','$','1',',','\n',
'#',' ','o','r',' ','r','e','t','u','r','n',' ','-','1',' ','t','o',' ','g','i','v','e',' ','u','p','.',' ',' ','A','d','d','i','n','g',' ','t','h','e',' ','o','p','t','i','o','n','a','l',' ','a','r','g','u','m','e','n','t',' ','\"','n','o','C','o','n','t','i','n','u','e','\"','\n',
'#',' ','w','i','l','l',' ','s','t','o','p',' ','t','h','e',' ','r','o','u','t','i','n','e',' ','f','r','o','m',' ','i','n','s','e','r','t','i','n','g',' ','l','i','n','e',' ','c','o','n','t','i','n','u','a','t','i','o','n',' ','i','n','d','e','n','t','s','\n',
'#','\n',
'd','e','f','i','n','e',' ','c','F','i','n','d','S','m','a','r','t','I','n','d','e','n','t','D','i','s','t',' ','{','\n',
'\n',
' ',' ',' ',' ','#',' ','F','i','n','d',' ','a',' ','k','n','o','w','n',' ','g','o','o','d',' ','i','n','d','e','n','t',' ','t','o',' ','b','a','s','e',' ','t','h','e',' ','n','e','w',' ','i','n','d','e','n','t',' ','u','p','o','n','\n',
' ',' ',' ',' ','a','n','c','h','o','r','P','o','s',' ','=',' ','c','F','i','n','d','I','n','d','e','n','t','A','n','c','h','o','r','P','o','i','n','t','(','$','1',')','\n',
' ',' ',' ',' ','i','f',' ','(','a','n','c','h','o','r','P','o','s',' ','=','=',' ','-','1',')','\n',
'	','r','e','t','u','r','n',' ','-','1','\n',
'\n',
' ',' ',' ',' ','#',' ','F','i','n','d',' ','t','h','e',' ','i','n','d','e','n','t','a','t','i','o','n',' ','o','f',' ','t','h','a','t',' ','l','i','n','e','\n',
' ',' ',' ',' ','a','n','c','h','o','r','I','n','d','e','n','t',' ','=',' ','m','e','a','s','u','r','e','I','n','d','e','n','t','(','a','n','c','h','o','r','P','o','s',')','\n',
'\n',
' ',' ',' ',' ','#',' ','L','o','o','k',' ','f','o','r',' ','s','p','e','c','i','a','l',' ','k','e','y','w','o','r','d','s',' ','w','h','i','c','h',' ','a','f','f','e','c','t',' ','i','n','d','e','n','t',' ','(','f','o','r',',',' ','i','f',',',' ','e','l','s','e',' ','w','h','i','l','e',',',' ','d','o',')','\n',
' ',' ',' ',' ','#',' ',' ',' ',' ','a','n','d',' ','m','o','d','i','f','y',' ','t','h','e',' ','c','o','n','t','i','n','u','a','t','i','o','n',' ','i','n','d','e','n','t',' ','d','i','s','t','a','n','c','e',' ','t','o',' ','t','h','e',' ','n','o','r','m','a','l',' ','i','n','d','e','n','t','\n',
' ',' ',' ',' ','#',' ',' ',' ',' ','d','i','s','t','a','n','c','e',' ','w','h','e','n',' ','a',' ','c','o','m','p','l','e','t','e','d',' ','s','t','a','t','e','m','e','n','t',' ','o','f',' ','t','h','i','s',' ','t','y','p','e',' ','o','c','c','u','p','i','e','s',' ','t','h','e',' ','l','i','n','e','.','\n',
' ',' ',' ',' ','i','f',' ','(','$','n','_','a','r','g','s',' ','>','=',' ','2',' ','&','&',' ','$','2',' ','=','=',' ','\"','n','o','C','o','n','t','i','n','u','e','\"',')',' ','{','\n',
'	','c','o','n','t','i','n','u','e','I','n','d','e','n','t',' ','=',' ','0','\n',
'	','$','a','l','l','o','w','S','e','m','i',' ','=',' ','0','\n',
' ',' ',' ',' ','}',' ','e','l','s','e','\n',
'	','c','o','n','t','i','n','u','e','I','n','d','e','n','t',' ','=',' ','c','C','a','l','c','C','o','n','t','i','n','u','e','I','n','d','e','n','t','(','a','n','c','h','o','r','P','o','s',',',' ','$','1',')','\n',
'\n',
' ',' ',' ',' ','#',' ','M','o','v','e',' ','f','o','r','w','a','r','d',' ','f','r','o','m',' ','a','n','c','h','o','r',' ','p','o','i','n','t',',',' ','i','g','n','o','r','i','n','g',' ','c','o','m','m','e','n','t','s',' ','a','n','d',' ','b','l','a','n','k',' ','l','i','n','e','s',',','\n',
' ',' ',' ',' ','#',' ',' ',' ','r','e','m','e','m','b','e','r','i','n','g',' ','t','h','e',' ','l','a','s','t',' ','n','o','n','-','w','h','i','t','e',',',' ','n','o','n','-','c','o','m','m','e','n','t',' ','c','h','a','r','a','c','t','e','r','.',' ',' ','I','f',' ','$','1',' ','i','s','\n',
' ',' ',' ',' ','#',' ',' ',' ','i','n',' ','t','h','e',' ','m','i','d','d','l','e',' ','o','f',' ','a',' ','c','o','m','m','e','n','t',',',' ','g','i','v','e',' ','u','p','\n',
' ',' ',' ',' ','l','a','s','t','C','h','a','r',' ','=',' ','g','e','t','_','c','h','a','r','a','c','t','e','r','(','a','n','c','h','o','r','P','o','s',')','\n',
' ',' ',' ',' ','i','f',' ','(','a','n','c','h','o','r','P','o','s',' ','<',' ','$','1',')',' ','{','\n',
'	','f','o','r',' ','(','i','=','a','n','c','h','o','r','P','o','s',';',';',')',' ','{','\n',
' ',' ',' ','	',' ',' ',' ',' ','i',' ','=',' ','c','S','k','i','p','B','l','a','n','k','S','p','a','c','e','(','i',',',' ','$','1',',',' ','1',')','\n',
'	',' ',' ',' ',' ','i','f',' ','(','i',' ','=','=',' ','-','1',')','\n',
'	','	','r','e','t','u','r','n',' ','-','1','\n',
' ','	',' ',' ',' ',' ','i','f',' ','(','i',' ','>','=',' ','$','1',')','\n',
' ','	','	','b','r','e','a','k','\n',
' ','	',' ',' ',' ',' ','l','a','s','t','C','h','a','r',' ','=',' ','g','e','t','_','c','h','a','r','a','c','t','e','r','(','i','+','+',')','\n',
'	','}','\n',
' ',' ',' ',' ','}','\n',
'\n',
' ',' ',' ',' ','#',' ','R','e','t','u','r','n',' ','t','h','e',' ','n','e','w',' ','i','n','d','e','n','t',' ','b','a','s','e','d',' ','o','n',' ','t','h','e',' ','t','y','p','e',' ','o','f',' ','t','h','e',' ','l','a','s','t',' ','c','h','a','r','a','c','t','e','r','.','\n',
' ',' ',' ',' ','#',' ',' ',' ','I','n',' ','a',' ','f','o','r',' ','s','t','m','t',',',' ','h','o','w','e','v','e','r',',',' ','l','a','s','t',' ','c','h','a','r','a','c','t','e','r',' ','m','a','y',' ','b','e',' ','a',' ','s','e','m','i','c','o','l','o','n',' ','a','n','d',' ','n','o','t','\n',
' ',' ',' ',' ','#',' ',' ',' ','s','i','g','n','a','l',' ','t','h','e',' ','e','n','d',' ','o','f',' ','t','h','e',' ','s','t','a','t','e','m','e','n','t','\n',
' ',' ',' ',' ','i','f',' ','(','l','a','s','t','C','h','a','r',' ','=','=',' ','\"','{','\"',')','\n',
'	','r','e','t','u','r','n',' ','a','n','c','h','o','r','I','n','d','e','n','t',' ','+',' ','d','e','f','a','u','l','t','I','n','d','e','n','t','(','$','c','I','n','d','e','n','t','D','i','s','t',')','\n',
' ',' ',' ',' ','e','l','s','e',' ','i','f',' ','(','l','a','s','t','C','h','a','r',' ','=','=',' ','\"','}','\"',')','\n',
'	','r','e','t','u','r','n',' ','a','n','c','h','o','r','I','n','d','e','n','t','\n',
' ',' ',' ',' ','e','l','s','e',' ','i','f',' ','(','l','a','s','t','C','h','a','r',' ','=','=',' ','\"',';','\"',')',' ','{','\n',
'	','i','f',' ','(','$','a','l','l','o','w','S','e','m','i',')','\n',
'	',' ',' ',' ',' ','r','e','t','u','r','n',' ','a','n','c','h','o','r','I','n','d','e','n','t',' ','+',' ','c','o','n','t','i','n','u','e','I','n','d','e','n','t','\n',
'	','e','l','s','e','\n',
'	',' ',' ',' ',' ','r','e','t','u','r','n',' ','a','n','c','h','o','r','I','n','d','e','n','t','\n',
' ',' ',' ',' ','}',' ','e','l','s','e',' ','i','f',' ','(','l','a','s','t','C','h','a','r',' ','=','=',' ','\"',':','\"',' ','&','&',' ','g','e','t','_','r','a','n','g','e','(','a','n','c','h','o','r','P','o','s',',',' ','a','n','c','h','o','r','P','o','s','+','4',')',' ','=','=',' ','\"','c','a','s','e','\"',')','\n',
' ',' ',' ',' ','	','r','e','t','u','r','n',' ','a','n','c','h','o','r','I','n','d','e','n','t',' ','+',' ','d','e','f','a','u','l','t','I','n','d','e','n','t','(','$','c','I','n','d','e','n','t','D','i','s','t',')','\n',
' ',' ',' ',' ','r','e','t','u','r','n',' ','a','n','c','h','o','r','I','n','d','e','n','t',' ','+',' ','c','o','n','t','i','n','u','e','I','n','d','e','n','t','\n',
'}','\n',
'\n',
'#','\n',
'#',' ','C','a','l','c','u','l','a','t','e',' ','t','h','e',' ','c','o','n','t','i','n','u','a','t','i','o','n',' ','i','n','d','e','n','t',' ','d','i','s','t','a','n','c','e',' ','f','o','r',' ','s','t','a','t','e','m','e','n','t','s',' ','n','o','t',' ','e','n','d','i','n','g',' ','i','n','\n',
'#',' ','s','e','m','i','c','o','l','o','n','s',' ','o','r',' ','b','r','a','c','e','s','.',' ',' ','T','h','i','s',' ','i','s',' ','n','o','t',' ','n','e','c','e','s','s','a','r','i','l','y',' ','$','c','o','n','t','i','n','u','e','I','n','d','e','n','t','.',' ',' ','I','t',' ','m','a','y','\n',
'#',' ','b','e',' ','a','d','j','u','s','t','e','d',' ','i','f',' ','t','h','e',' ','s','t','a','t','e','m','e','n','t',' ','c','o','n','t','a','i','n','s',' ','i','f',',',' ','w','h','i','l','e',',',' ','f','o','r',',',' ','o','r',' ','e','l','s','e','.','\n',
'#','\n',
'#',' ','A','s',' ','a',' ','s','i','d','e',' ','e','f','f','e','c','t',',',' ','a','l','s','o',' ','r','e','t','u','r','n',' ','$','a','l','l','o','w','S','e','m','i',' ','t','o',' ','h','e','l','p',' ','d','i','s','t','i','n','g','u','i','s','h',' ','s','t','a','t','e','m','e','n','t','s','\n',
'#',' ','w','h','i','c','h',' ','m','i','g','h','t',' ','c','o','n','t','a','i','n',' ','a','n',' ','e','m','b','e','d','d','e','d',' ','s','e','m','i','c','o','l','o','n',',',' ','w','h','i','c','h',' ','s','h','o','u','l','d',' ','n','o','t',' ','b','e',' ','i','n','t','e','r','p','r','e','t','e','d','\n',
'#',' ','a','s',' ','a','n',' ','e','n','d',' ','o','f',' ','s','t','a','t','e','m','e','n','t',' ','c','h','a','r','a','c','t','e','r','.','\n',
'#','\n',
'd','e','f','i','n','e',' ','c','C','a','l','c','C','o','n','t','i','n','u','e','I','n','d','e','n','t',' ','{','\n',
'\n',
' ',' ',' ',' ','a','n','c','h','o','r','P','o','s',' ','=',' ','$','1','\n',
' ',' ',' ',' ','m','a','x','P','o','s',' ','=',' ','$','2','\n',
'\n',
' ',' ',' ',' ','#',' ','F','i','g','u','r','e',' ','o','u','t',' ','i','f',' ','t','h','e',' ','a','n','c','h','o','r',' ','i','s',' ','o','n',' ','a',' ','k','e','y','w','o','r','d',' ','w','h','i','c','h',' ','c','h','a','n','g','e','s',' ','i','n','d','e','n','t','.',' ',' ','A',' ','s','p','e','c','i','a','l','\n',
' ',' ',' ',' ','#',' ',' ',' ','c','a','s','e',' ','i','s',' ','m','a','d','e',' ','f','o','r',' ','e','l','s','e','s',' ','n','e','s','t','e','d',' ','i','n',' ','a','f','t','e','r',' ','b','r','a','c','e','s','\n',
' ',' ',' ',' ','a','n','c','h','o','r','I','s','F','o','r',' ','=',' ','0','\n',
' ',' ',' ',' ','$','a','l','l','o','w','S','e','m','i',' ','=',' ','0','\n',
' ',' ',' ',' ','i','f',' ','(','g','e','t','_','c','h','a','r','a','c','t','e','r','(','a','n','c','h','o','r','P','o','s',')',' ','=','=',' ','\"','}','\"',')',' ','{','\n',
'	','f','o','r',' ','(','i','=','a','n','c','h','o','r','P','o','s','+','1',';',' ','i','<','m','a','x','P','o','s',';',' ','i','+','+',')',' ','{','\n',
'	',' ',' ',' ',' ','c',' ','=',' ','g','e','t','_','c','h','a','r','a','c','t','e','r','(','i',')','\n',
'	',' ',' ',' ',' ','i','f',' ','(','c',' ','!','=',' ','\"',' ','\"',' ','&','&',' ','c',' ','!','=',' ','\"','\\','t','\"',')','\n',
'	','	','b','r','e','a','k','\n',
'	','}','\n',
'	','i','f',' ','(','g','e','t','_','r','a','n','g','e','(','i',',',' ','i','+','4',')',' ','=','=',' ','\"','e','l','s','e','\"',')',' ','{','\n',
'	',' ',' ',' ',' ','k','e','y','w','o','r','d','E','n','d',' ','=',' ','i',' ','+',' ','4','\n',
'	',' ',' ',' ',' ','n','e','e','d','s','B','a','l','a','n','c','e','d','P','a','r','e','n','s',' ','=',' ','0','\n',
'	','}',' ','e','l','s','e','\n',
'	',' ',' ',' ',' ','r','e','t','u','r','n',' ','d','e','f','a','u','l','t','C','o','n','t','I','n','d','e','n','t','(','$','c','C','o','n','t','i','n','u','a','t','i','o','n','I','n','d','e','n','t',')','\n',
' ',' ',' ',' ','}',' ','e','l','s','e',' ','i','f',' ','(','g','e','t','_','r','a','n','g','e','(','a','n','c','h','o','r','P','o','s',',',' ','a','n','c','h','o','r','P','o','s',' ','+',' ','4',')',' ','=','=',' ','\"','e','l','s','e','\"',')',' ','{','\n',
'	','k','e','y','w','o','r','d','E','n','d',' ','=',' ','a','n','c','h','o','r','P','o','s',' ','+',' ','4','\n',
'	','n','e','e','d','s','B','a','l','a','n','c','e','d','P','a','r','e','n','s',' ','=',' ','0','\n',
' ',' ',' ',' ','}',' ','e','l','s','e',' ','i','f',' ','(','g','e','t','_','r','a','n','g','e','(','a','n','c','h','o','r','P','o','s',',',' ','a','n','c','h','o','r','P','o','s',' ','+',' ','2',')',' ','=','=',' ','\"','d','o','\"',')',' ','{','\n',
'	','k','e','y','w','o','r','d','E','n','d',' ','=',' ','a','n','c','h','o','r','P','o','s',' ','+',' ','2','\n',
'	','n','e','e','d','s','B','a','l','a','n','c','e','d','P','a','r','e','n','s',' ','=',' ','0','\n',
' ',' ',' ',' ','}',' ','e','l','s','e',' ','i','f',' ','(','g','e','t','_','r','a','n','g','e','(','a','n','c','h','o','r','P','o','s',',',' ','a','n','c','h','o','r','P','o','s',' ','+',' ','3',')',' ','=','=',' ','\"','f','o','r','\"',')',' ','{','\n',
'	','k','e','y','w','o','r','d','E','n','d',' ','=',' ','a','n','c','h','o','r','P','o','s',' ','+',' ','3','\n',
'	','a','n','c','h','o','r','I','s','F','o','r',' ','=',' ','1','\n',
'	','n','e','e','d','s','B','a','l','a','n','c','e','d','P','a','r','e','n','s',' ','=',' ','1','\n',
' ',' ',' ',' ','}',' ','e','l','s','e',' ','i','f',' ','(','g','e','t','_','r','a','n','g','e','(','a','n','c','h','o','r','P','o','s',',',' ','a','n','c','h','o','r','P','o','s',' ','+',' ','2',')',' ','=','=',' ','\"','i','f','\"',')',' ','{','\n',
'	','k','e','y','w','o','r','d','E','n','d',' ','=',' ','a','n','c','h','o','r','P','o','s',' ','+',' ','2','\n',
'	','n','e','e','d','s','B','a','l','a','n','c','e','d','P','a','r','e','n','s',' ','=',' ','1','\n',
' ',' ',' ',' ','}',' ','e','l','s','e',' ','i','f',' ','(','g','e','t','_','r','a','n','g','e','(','a','n','c','h','o','r','P','o','s',',',' ','a','n','c','h','o','r','P','o','s',' ','+',' ','5',')',' ','=','=',' ','\"','w','h','i','l','e','\"',')',' ','{','\n',
'	','k','e','y','w','o','r','d','E','n','d',' ','=',' ','a','n','c','h','o','r','P','o','s',' ','+',' ','5','\n',
'	','n','e','e','d','s','B','a','l','a','n','c','e','d','P','a','r','e','n','s',' ','=',' ','1','\n',
' ',' ',' ',' ','}',' ','e','l','s','e','\n',
'	','r','e','t','u','r','n',' ','d','e','f','a','u','l','t','C','o','n','t','I','n','d','e','n','t','(','$','c','C','o','n','t','i','n','u','a','t','i','o','n','I','n','d','e','n','t',')','\n',
'\n',
' ',' ',' ',' ','#',' ','I','f',' ','t','h','e',' ','k','e','y','w','o','r','d',' ','m','u','s','t',' ','b','e',' ','f','o','l','l','o','w','e','d',' ','b','a','l','a','n','c','e','d',' ','p','a','r','e','n','t','h','e','s','i','s',',',' ','f','i','n','d',' ','t','h','e',' ','e','n','d',' ','o','f','\n',
' ',' ',' ',' ','#',' ','t','h','e',' ','s','t','a','t','e','m','e','n','t',' ','b','y',' ','f','o','l','l','o','w','i','n','g',' ','b','a','l','a','n','c','e','d',' ','p','a','r','e','n','s','.',' ',' ','I','f',' ','t','h','e',' ','p','a','r','e','n','s',' ','a','r','e','n',''','t','\n',
' ',' ',' ',' ','#',' ','b','a','l','a','n','c','e','d',' ','b','y',' ','m','a','x','P','o','s',',',' ','c','o','n','t','i','n','u','e',' ','t','h','e',' ','c','o','n','d','i','t','i','o','n','.',' ',' ','I','n',' ','t','h','e',' ','s','p','e','c','i','a','l',' ','c','a','s','e',' ','o','f','\n',
' ',' ',' ',' ','#',' ','t','h','e',' ','f','o','r',' ','k','e','y','w','o','r','d',',',' ','a',' ','s','e','m','i','c','o','l','o','n',' ','c','a','n',' ','e','n','d',' ','t','h','e',' ','l','i','n','e',' ','a','n','d',' ','t','h','e',' ','c','a','l','l','e','r',' ','s','h','o','u','l','d',' ','b','e','\n',
' ',' ',' ',' ','#',' ','s','i','g','n','a','l','e','d',' ','t','o',' ','a','l','l','o','w',' ','t','h','a','t','\n',
' ',' ',' ',' ','i','f',' ','(','n','e','e','d','s','B','a','l','a','n','c','e','d','P','a','r','e','n','s',')',' ','{','\n',
'	','s','t','m','t','E','n','d',' ','=',' ','f','i','n','d','B','a','l','a','n','c','i','n','g','P','a','r','e','n','(','k','e','y','w','o','r','d','E','n','d',',',' ','m','a','x','P','o','s',')','\n',
'	','i','f',' ','(','s','t','m','t','E','n','d',' ','=','=',' ','-','1',')',' ','{','\n',
'	',' ',' ',' ',' ','$','a','l','l','o','w','S','e','m','i',' ','=',' ','a','n','c','h','o','r','I','s','F','o','r','\n',
'	',' ',' ',' ',' ','r','e','t','u','r','n',' ','d','e','f','a','u','l','t','C','o','n','t','I','n','d','e','n','t','(','$','c','C','o','n','t','i','n','u','a','t','i','o','n','I','n','d','e','n','t',')','\n',
'	','}','\n',
' ',' ',' ',' ','}',' ','e','l','s','e','\n',
'	','s','t','m','t','E','n','d',' ','=',' ','k','e','y','w','o','r','d','E','n','d','\n',
'\n',
' ',' ',' ',' ','#',' ','c','h','e','c','k',' ','i','f',' ','t','h','e',' ','s','t','a','t','e','m','e','n','t',' ','e','n','d','s',' ','t','h','e',' ','l','i','n','e','\n',
' ',' ',' ',' ','l','i','n','e','E','n','d',' ','=',' ','c','S','k','i','p','B','l','a','n','k','S','p','a','c','e','(','s','t','m','t','E','n','d',',',' ','m','a','x','P','o','s',',',' ','0',')','\n',
' ',' ',' ',' ','i','f',' ','(','l','i','n','e','E','n','d',' ','=','=',' ','-','1',')','	','	',' ',' ',' ',' ','	',' ',' ',' ',' ','#',' ','e','n','d','s',' ','i','n',' ','c','o','m','m','e','n','t',' ','o','r',' ','p','r','e','p','r','o','c','\n',
'	','r','e','t','u','r','n',' ','-','1','\n',
' ',' ',' ',' ','i','f',' ','(','l','i','n','e','E','n','d',' ','=','=',' ','m','a','x','P','o','s',')',' ',' ','	',' ',' ',' ',' ','	',' ',' ',' ',' ','#',' ','m','a','x','P','o','s',' ','h','a','p','p','e','n','s',' ','a','t',' ','s','t','m','t',' ','e','n','d','\n',
'	','r','e','t','u','r','n',' ','d','e','f','a','u','l','t','I','n','d','e','n','t','(','$','c','I','n','d','e','n','t','D','i','s','t',')','\n',
' ',' ',' ',' ','c',' ','=',' ','g','e','t','_','c','h','a','r','a','c','t','e','r','(','l','i','n','e','E','n','d',')','\n',
' ',' ',' ',' ','i','f',' ','(','c',' ','!','=',' ','\"','\\','n','\"',')',' ',' ',' ','	','	',' ',' ',' ',' ','	',' ',' ',' ',' ','#',' ','s','o','m','e','t','h','i','n','g',' ','p','a','s','t',' ','l','a','s','t',' ','p','a','r','e','n',' ','o','n',' ','l','i','n','e',',','\n',
'	','r','e','t','u','r','n',' ','d','e','f','a','u','l','t','I','n','d','e','n','t','(','$','c','I','n','d','e','n','t','D','i','s','t',')',' ',' ','#',' ',' ',' ','p','r','o','b','a','b','l','y',' ','q','u','o','t','e','d',' ','o','r',' ','e','x','t','r','a',' ','b','r','a','c','e','s','\n',
'\n',
' ',' ',' ',' ','#',' ','s','t','m','t',' ','c','o','n','t','i','n','t','i','n','u','e','s',' ','b','e','y','o','n','d',' ','m','a','t','c','h','i','n','g',' ','p','a','r','e','n',' ','&','&',' ','n','e','w','l','i','n','e',',',' ','w','e',''','r','e',' ','i','n','\n',
' ',' ',' ',' ','#',' ',' ',' ','t','h','e',' ','c','o','n','d','i','t','i','o','n','a','l',' ','p','a','r','t',',',' ','c','a','l','c','u','l','a','t','e',' ','t','h','e',' ','c','o','n','t','i','n','u','e',' ','i','n','d','e','n','t',' ','d','i','s','t','a','n','c','e','\n',
' ',' ',' ',' ','#',' ',' ',' ','r','e','c','u','r','s','i','v','e','l','y',',',' ','b','a','s','e','d',' ','o','n',' ','t','h','e',' ','a','n','c','h','o','r',' ','p','o','i','n','t',' ','o','f',' ','t','h','e',' ','n','e','w',' ','l','i','n','e','\n',
' ',' ',' ',' ','n','e','w','A','n','c','h','o','r',' ','=',' ','c','S','k','i','p','B','l','a','n','k','S','p','a','c','e','(','l','i','n','e','E','n','d','+','1',',',' ','m','a','x','P','o','s',',',' ','1',')','\n',
' ',' ',' ',' ','i','f',' ','(','n','e','w','A','n','c','h','o','r',' ','=','=',' ','-','1',')','\n',
'	','r','e','t','u','r','n',' ','-','1','\n',
' ',' ',' ',' ','i','f',' ','(','n','e','w','A','n','c','h','o','r',' ','=','=',' ','m','a','x','P','o','s',')','\n',
'	','r','e','t','u','r','n',' ','d','e','f','a','u','l','t','I','n','d','e','n','t','(','$','c','I','n','d','e','n','t','D','i','s','t',')','\n',
' ',' ',' ',' ','r','e','t','u','r','n',' ','c','C','a','l','c','C','o','n','t','i','n','u','e','I','n','d','e','n','t','(','n','e','w','A','n','c','h','o','r',',',' ','m','a','x','P','o','s',')',' ','+',' ','d','e','f','a','u','l','t','I','n','d','e','n','t','(','$','c','I','n','d','e','n','t','D','i','s','t',')','\n',
'}','\n',
'\0'};

/*
** Turn on smart-indent (well almost).  Unfortunately, this doesn't do
** everything.  It requires that the smart indent callback (SmartIndentCB)
** is already attached to all of the text widgets in the window, and that the
** smartIndent resource must be turned on in the widget.  These are done
** separately, because they are required per-text widget, and therefore must
** be repeated whenever a new text widget is created within this window
** (a split-window command).
*/
void BeginSmartIndent(WindowInfo *window, int warn)
{
    windowSmartIndentData *winData;
    smartIndentRec *indentMacros;
    char *modeName, *stoppedAt, *errMsg;
    static int initialized;

    /* Find the window's language mode.  If none is set, warn the user */
    modeName = LanguageModeName(window->languageMode);
    if (modeName == NULL) {
    	if (warn)
	    DialogF(DF_WARN, window->shell, 1,
"No language-specific mode has been set for this file.\n\
\n\
To use smart indent in this window, please select a\n\
language from the Preferences -> Language Modes menu.", "Dismiss");
    	return;
    }
    
    /* Look up the appropriate smart-indent macros for the language */
    indentMacros = findIndentSpec(modeName);
    if (indentMacros == NULL) {
    	if (warn)
	    DialogF(DF_WARN, window->shell, 1,
"Smart indent is not available in languagemode\n\
%s.\n\
\n\
You can create new smart indent macros in the\n\
Preferences -> Default Settings -> Smart Indent\n\
dialog, or choose a different language mode from:\n\
Preferences -> Language Mode.", "Dismiss", modeName);
    	return;
    }
    
    /* Compile and run the common and language-specific initialization macros
       (Note that when these return, the immediate commands in the file have not
       necessarily been executed yet.  They are only SCHEDULED for execution) */
    if (!initialized) {
    	if (!ReadMacroString(window, CommonMacros,
	    	"smart indent common initialization macros"))
    	    return;
	initialized = True;
    }
    if (!ReadMacroString(window, indentMacros->initMacro,
	    "smart indent initialization macro"))
    	return;
    
    /* Compile the newline and modify macros and attach them to the window */
    winData = (windowSmartIndentData *)XtMalloc(sizeof(windowSmartIndentData));
    winData->newlineMacro = ParseMacro(indentMacros->newlineMacro, &errMsg,
    	    &stoppedAt);
    if (winData->newlineMacro == NULL) {
    	ParseError(window->shell, indentMacros->newlineMacro, stoppedAt,
    	    	"newline macro", errMsg);
    	return;
    }
    if (indentMacros->modMacro == NULL)
    	winData->modMacro = NULL;
    else {
    	winData->modMacro = ParseMacro(indentMacros->modMacro, &errMsg,
    	    	&stoppedAt);
    	if (winData->modMacro == NULL) {
    	    ParseError(window->shell, indentMacros->modMacro, stoppedAt,
    	    	    "smart indent modify macro", errMsg);
    	    return;
    	}
    }
    window->smartIndentData = (void *)winData;
}

void EndSmartIndent(WindowInfo *window)
{
    windowSmartIndentData *winData =
    	    (windowSmartIndentData *)window->smartIndentData;
    
    if (winData == NULL)
    	return;

    /* Free programs and allocated data */
    if (winData->modMacro != NULL)
    	FreeProgram(winData->modMacro);
    FreeProgram(winData->newlineMacro);
    XtFree((char *)winData);
    window->smartIndentData = NULL;
}

/*
** Returns true if there are smart indent macros for a named language
*/
int SmartIndentMacrosAvailable(char *languageModeName)
{
    return findIndentSpec(languageModeName) != NULL;
}

/*
** Attaches to the text widget's smart-indent callback to invoke a user
** defined macro when the text widget requires an indent (not just when the
** user types a newline, but also when the widget does an auto-wrap with
** auto-indent on), or the user types some other character.
*/
void SmartIndentCB(Widget w, XtPointer clientData, XtPointer callData) 
{
    WindowInfo *window = (WindowInfo *)clientData;
    smartIndentCBStruct *cbInfo = (smartIndentCBStruct *)callData;
    
    if (window->smartIndentData == NULL)
    	return;
    if (cbInfo->reason == CHAR_TYPED)
	executeModMacro(window, cbInfo);
    else if (cbInfo->reason == NEWLINE_INDENT_NEEDED)
	executeNewlineMacro(window, cbInfo);
}

/*
** Run the newline macro with information from the smart-indent callback
** structure passed by the widget
*/
static void executeNewlineMacro(WindowInfo *window, smartIndentCBStruct *cbInfo)
{
    windowSmartIndentData *winData =
    	    (windowSmartIndentData *)window->smartIndentData;
    static DataValue posValue = {INT_TAG, {0}};
    DataValue result;
    RestartData *continuation;
    char *errMsg;
    int stat;
   
    /* Call newline macro with the position at which to add newline/indent */
    posValue.val.n = cbInfo->pos;
    stat = ExecuteMacro(window, winData->newlineMacro, 1, &posValue, &result,
    	    &continuation, &errMsg);
    
    /* Don't allow preemption or time limit.  Must get return value */
    while (stat == MACRO_TIME_LIMIT)
    	stat = ContinueMacro(continuation, &result, &errMsg);
    
    /* Collect Garbage.  Note that the mod macro does not collect garbage,
       (because collecting per-line is more efficient than per-character)
       but GC now depends on the newline macro being mandatory */
    SafeGC();
    
    /* Process errors in macro execution */
    if (stat == MACRO_PREEMPT || stat == MACRO_ERROR) {
    	DialogF(DF_ERR, window->shell, 1, "Error in smart indent macro:\n%s",
    	    	"Dismiss", stat == MACRO_ERROR ? errMsg :
    	    	"dialogs and shell commands not permitted");
    	EndSmartIndent(window);
    	return;
    }
    	
    /* Validate and return the result */
    if (result.tag != INT_TAG || result.val.n < -1 || result.val.n > 1000) {
    	DialogF(DF_ERR, window->shell, 1,
    	    	"Smart indent macros must return\ninteger indent distance",
    	    	"Dismiss");
    	EndSmartIndent(window);
    	return;
    }
    cbInfo->indentRequest = result.val.n;
}

/*
** Run the modification macro with information from the smart-indent callback
** structure passed by the widget
*/
static void executeModMacro(WindowInfo *window,smartIndentCBStruct *cbInfo)
{
    windowSmartIndentData *winData =
    	    (windowSmartIndentData *)window->smartIndentData;
    static DataValue args[2] = {{INT_TAG, {0}}, {STRING_TAG, {0}}};
    static int inModCB = False;
    DataValue result;
    RestartData *continuation;
    char *errMsg;
    int stat;
    
    /* Check for inappropriate calls and prevent re-entering if the macro
       makes a buffer modification */
    if (winData == NULL || winData->modMacro == NULL || inModCB)
    	return;
	
    /* Call modification macro with the position of the modification,
       and the character(s) inserted.  Don't allow
       preemption or time limit.  Execution must not overlap or re-enter */
    args[0].val.n = cbInfo->pos;
    args[1].val.str = AllocString(strlen(cbInfo->charsTyped) + 1);
    strcpy(args[1].val.str, cbInfo->charsTyped);
    inModCB = True;
	stat = ExecuteMacro(window, winData->modMacro, 3, args, &result,
    		&continuation, &errMsg);
	while (stat == MACRO_TIME_LIMIT)
    	    stat = ContinueMacro(continuation, &result, &errMsg);
    inModCB = False;
    
    /* Process errors in macro execution */
    if (stat == MACRO_PREEMPT || stat == MACRO_ERROR) {
    	DialogF(DF_ERR, window->shell, 1,
    	    	"Error in smart indent modification macro:\n%s", "Dismiss",
    	    	stat == MACRO_ERROR ? errMsg :
    	    	"dialogs and shell commands not permitted");
    	EndSmartIndent(window);
    	return;
    }
}

void EditSmartIndentMacros(WindowInfo *window)
{
#define BORDER 4
    Widget form, lmOptMenu, lmLbl, lmForm, lmBtn;
    Widget okBtn, applyBtn, checkBtn, deleteBtn, commonBtn;
    Widget dismissBtn, helpBtn, restoreBtn, pane;
    Widget initForm, newlineForm, modifyForm;
    Widget initLbl, newlineLbl, modifyLbl;
    XmString s1;
    char *lmName;
    Arg args[20];
    int n;

    /* if the dialog is already displayed, just pop it to the top and return */
    if (SmartIndentDialog.shell != NULL) {
    	RaiseShellWindow(SmartIndentDialog.shell);
    	return;
    }
    
    if (LanguageModeName(0) == NULL) {
    	DialogF(DF_WARN, window->shell, 1, "No Language Modes defined",
		"Dismiss");
    	return;
    }
    
    /* Decide on an initial language mode */
    lmName = LanguageModeName(window->languageMode == PLAIN_LANGUAGE_MODE ? 0 :
    	    window->languageMode);
    SmartIndentDialog.langModeName = CopyAllocatedString(lmName);

    /* Create a form widget in an application shell */
    n = 0;
    XtSetArg(args[n], XmNdeleteResponse, XmDO_NOTHING); n++;
    XtSetArg(args[n], XmNiconName, "Smart Indent Macros"); n++;
    XtSetArg(args[n], XmNtitle, "Smart Indent Macros"); n++;
    SmartIndentDialog.shell = XtAppCreateShell(APP_NAME, APP_CLASS,
	    applicationShellWidgetClass, TheDisplay, args, n);
    AddSmallIcon(SmartIndentDialog.shell);
    form = XtVaCreateManagedWidget("editSmartIndentMacros", xmFormWidgetClass,
	    SmartIndentDialog.shell, XmNautoUnmanage, False,
	    XmNresizePolicy, XmRESIZE_NONE, 0);
    XtAddCallback(form, XmNdestroyCallback, destroyCB, NULL);
    AddMotifCloseCallback(SmartIndentDialog.shell, dismissCB, NULL);
       
    lmForm = XtVaCreateManagedWidget("lmForm", xmFormWidgetClass,
    	    form,
	    XmNleftAttachment, XmATTACH_POSITION,
	    XmNleftPosition, 1,
	    XmNtopAttachment, XmATTACH_POSITION,
	    XmNtopPosition, 1,
	    XmNrightAttachment, XmATTACH_POSITION,
	    XmNrightPosition, 99, 0);
 
    SmartIndentDialog.lmPulldown = CreateLanguageModeMenu(lmForm, langModeCB,
    	    NULL);
    n = 0;
    XtSetArg(args[n], XmNspacing, 0); n++;
    XtSetArg(args[n], XmNmarginWidth, 0); n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNleftPosition, 50); n++;
    XtSetArg(args[n], XmNsubMenuId, SmartIndentDialog.lmPulldown); n++;
    lmOptMenu = XmCreateOptionMenu(lmForm, "langModeOptMenu", args, n);
    XtManageChild(lmOptMenu);
    SmartIndentDialog.lmOptMenu = lmOptMenu;
    
    lmLbl = XtVaCreateManagedWidget("lmLbl", xmLabelGadgetClass, lmForm,
    	    XmNlabelString, s1=XmStringCreateSimple("Language Mode:"),
    	    XmNmnemonic, 'L',
    	    XmNuserData, XtParent(SmartIndentDialog.lmOptMenu),
    	    XmNalignment, XmALIGNMENT_END,
	    XmNrightAttachment, XmATTACH_POSITION,
	    XmNrightPosition, 50,
	    XmNtopAttachment, XmATTACH_FORM,
	    XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
	    XmNbottomWidget, lmOptMenu, 0);
    XmStringFree(s1);
    
    lmBtn = XtVaCreateManagedWidget("lmBtn", xmPushButtonWidgetClass, lmForm,
    	    XmNlabelString, s1=MKSTRING("Add / Modify\nLanguage Mode..."),
    	    XmNmnemonic, 'A',
    	    XmNrightAttachment, XmATTACH_FORM,
    	    XmNtopAttachment, XmATTACH_FORM, 0);
    XtAddCallback(lmBtn, XmNactivateCallback, lmDialogCB, NULL);
    XmStringFree(s1);
    
    commonBtn = XtVaCreateManagedWidget("commonBtn", xmPushButtonWidgetClass,
    	    lmForm,
    	    XmNlabelString, s1=MKSTRING("Common / Shared\nInitialization..."),
    	    XmNmnemonic, 'C',
    	    XmNleftAttachment, XmATTACH_FORM,
    	    XmNtopAttachment, XmATTACH_FORM, 0);
    XtAddCallback(commonBtn, XmNactivateCallback, commonDialogCB, NULL);
    XmStringFree(s1);
    
    okBtn = XtVaCreateManagedWidget("ok", xmPushButtonWidgetClass, form,
    	    XmNlabelString, s1=XmStringCreateSimple("OK"),
    	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 1,
    	    XmNrightAttachment, XmATTACH_POSITION,
    	    XmNrightPosition, 13,
    	    XmNbottomAttachment, XmATTACH_FORM,
    	    XmNbottomOffset, BORDER, 0);
    XtAddCallback(okBtn, XmNactivateCallback, okCB, NULL);
    XmStringFree(s1);
    
    applyBtn = XtVaCreateManagedWidget("apply", xmPushButtonWidgetClass, form,
    	    XmNlabelString, s1=XmStringCreateSimple("Apply"),
    	    XmNmnemonic, 'y',
    	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 13,
    	    XmNrightAttachment, XmATTACH_POSITION,
    	    XmNrightPosition, 26,
    	    XmNbottomAttachment, XmATTACH_FORM,
    	    XmNbottomOffset, BORDER, 0);
    XtAddCallback(applyBtn, XmNactivateCallback, applyCB, NULL);
    XmStringFree(s1);
    
    checkBtn = XtVaCreateManagedWidget("check", xmPushButtonWidgetClass, form,
    	    XmNlabelString, s1=XmStringCreateSimple("Check"),
    	    XmNmnemonic, 'k',
    	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 26,
    	    XmNrightAttachment, XmATTACH_POSITION,
    	    XmNrightPosition, 39,
    	    XmNbottomAttachment, XmATTACH_FORM,
    	    XmNbottomOffset, BORDER, 0);
    XtAddCallback(checkBtn, XmNactivateCallback, checkCB, NULL);
    XmStringFree(s1);
    
    deleteBtn = XtVaCreateManagedWidget("delete", xmPushButtonWidgetClass, form,
    	    XmNlabelString, s1=XmStringCreateSimple("Delete"),
    	    XmNmnemonic, 'D',
    	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 39,
    	    XmNrightAttachment, XmATTACH_POSITION,
    	    XmNrightPosition, 52,
    	    XmNbottomAttachment, XmATTACH_FORM,
    	    XmNbottomOffset, BORDER, 0);
    XtAddCallback(deleteBtn, XmNactivateCallback, deleteCB, NULL);
    XmStringFree(s1);
    
    restoreBtn = XtVaCreateManagedWidget("restore", xmPushButtonWidgetClass, form,
    	    XmNlabelString, s1=XmStringCreateSimple("Restore Defaults"),
    	    XmNmnemonic, 'f',
    	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 52,
    	    XmNrightAttachment, XmATTACH_POSITION,
    	    XmNrightPosition, 73,
    	    XmNbottomAttachment, XmATTACH_FORM,
    	    XmNbottomOffset, BORDER, 0);
    XtAddCallback(restoreBtn, XmNactivateCallback, restoreCB, NULL);
    XmStringFree(s1);
    
    dismissBtn = XtVaCreateManagedWidget("dismiss", xmPushButtonWidgetClass,
    	    form,
    	    XmNlabelString, s1=XmStringCreateSimple("Dismiss"),
    	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 73,
    	    XmNrightAttachment, XmATTACH_POSITION,
    	    XmNrightPosition, 86,
    	    XmNbottomAttachment, XmATTACH_FORM,
    	    XmNbottomOffset, BORDER, 0);
    XtAddCallback(dismissBtn, XmNactivateCallback, dismissCB, NULL);
    XmStringFree(s1);
    
    helpBtn = XtVaCreateManagedWidget("help", xmPushButtonWidgetClass,
    	    form,
    	    XmNlabelString, s1=XmStringCreateSimple("Help"),
    	    XmNmnemonic, 'H',
    	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 86,
    	    XmNrightAttachment, XmATTACH_POSITION,
    	    XmNrightPosition, 99,
    	    XmNbottomAttachment, XmATTACH_FORM,
    	    XmNbottomOffset, BORDER, 0);
    XtAddCallback(helpBtn, XmNactivateCallback, helpCB, NULL);
    XmStringFree(s1);
    
    pane = XtVaCreateManagedWidget("pane", xmPanedWindowWidgetClass,  form,
   	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 1,
   	    XmNrightAttachment, XmATTACH_POSITION,
    	    XmNrightPosition, 99,
	    XmNtopAttachment, XmATTACH_WIDGET,
	    XmNtopWidget, lmForm,
	    XmNbottomAttachment, XmATTACH_WIDGET,
	    XmNbottomWidget, okBtn, 0);
     	    /* XmNmarginWidth, 0, XmNmarginHeight, 0, XmNseparatorOn, False,
    	    XmNspacing, 3, XmNsashIndent, -2, */

    initForm = XtVaCreateManagedWidget("initForm", xmFormWidgetClass,
	    pane, 0);
    initLbl = XtVaCreateManagedWidget("initLbl", xmLabelGadgetClass, initForm,
    	    XmNlabelString, s1=XmStringCreateSimple(
    	     "Language Specific Initialization Macro Commands and Definitions"),
    	    XmNmnemonic, 'I', 0);
    XmStringFree(s1);
    n = 0;
    XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
    XtSetArg(args[n], XmNrows, 5); n++;
    XtSetArg(args[n], XmNcolumns, 80); n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNtopWidget, initLbl); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
    SmartIndentDialog.initMacro = XmCreateScrolledText(initForm,
    	    "initMacro", args, n);
    XtManageChild(SmartIndentDialog.initMacro);
    RemapDeleteKey(SmartIndentDialog.initMacro);
    XtVaSetValues(initLbl, XmNuserData, SmartIndentDialog.initMacro, 0);

    newlineForm = XtVaCreateManagedWidget("newlineForm", xmFormWidgetClass,
	    pane, 0);
    newlineLbl = XtVaCreateManagedWidget("newlineLbl", xmLabelGadgetClass,
    	    newlineForm,
    	    XmNlabelString, s1=XmStringCreateSimple("Newline Macro"),
    	    XmNmnemonic, 'N', 0);
    XmStringFree(s1);
    XtVaCreateManagedWidget("newlineArgsLbl", xmLabelGadgetClass,
    	    newlineForm, XmNalignment, XmALIGNMENT_END,
    	    XmNlabelString, s1=XmStringCreateSimple(
	       "($1 is insert position, return indent request or -1)"),
	    XmNrightAttachment, XmATTACH_FORM, 0);
    XmStringFree(s1);
    n = 0;
    XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
    XtSetArg(args[n], XmNrows, 5); n++;
    XtSetArg(args[n], XmNcolumns, 80); n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNtopWidget, newlineLbl); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
    SmartIndentDialog.newlineMacro = XmCreateScrolledText(newlineForm,
    	    "newlineMacro", args, n);
    XtManageChild(SmartIndentDialog.newlineMacro);
    RemapDeleteKey(SmartIndentDialog.newlineMacro);
    XtVaSetValues(newlineLbl, XmNuserData, SmartIndentDialog.newlineMacro, 0);

    modifyForm = XtVaCreateManagedWidget("modifyForm", xmFormWidgetClass,
	    pane, 0);
    modifyLbl = XtVaCreateManagedWidget("modifyLbl", xmLabelGadgetClass,
    	    modifyForm, XmNlabelString,s1=XmStringCreateSimple("Type-in Macro"),
    	    XmNmnemonic, 'M', 0);
    XmStringFree(s1);
    XtVaCreateManagedWidget("modifyArgsLbl", xmLabelGadgetClass,
    	    modifyForm, XmNalignment, XmALIGNMENT_END,
    	    XmNlabelString, s1=XmStringCreateSimple(
	        "($1 is position, $2 is character just inserted)"),
	    XmNrightAttachment, XmATTACH_FORM, 0);
    XmStringFree(s1);
    n = 0;
    XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
    XtSetArg(args[n], XmNrows, 5); n++;
    XtSetArg(args[n], XmNcolumns, 80); n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNtopWidget, modifyLbl); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
    SmartIndentDialog.modMacro = XmCreateScrolledText(modifyForm,
    	    "modifyMacro", args, n);
    XtManageChild(SmartIndentDialog.modMacro);
    RemapDeleteKey(SmartIndentDialog.modMacro);
    XtVaSetValues(modifyLbl, XmNuserData, SmartIndentDialog.modMacro, 0);

    /* Set initial default button */
    XtVaSetValues(form, XmNdefaultButton, okBtn, 0);
    XtVaSetValues(form, XmNcancelButton, dismissBtn, 0);
    
    /* Handle mnemonic selection of buttons and focus to dialog */
    AddDialogMnemonicHandler(form);
    
    /* Fill in the dialog information for the selected language mode */
    setSmartIndentDialogData(findIndentSpec(lmName));
    SetLangModeMenu(SmartIndentDialog.lmOptMenu,SmartIndentDialog.langModeName);
    
    /* Realize all of the widgets in the new dialog */
    XtRealizeWidget(SmartIndentDialog.shell);
}

static void destroyCB(Widget w, XtPointer clientData, XtPointer callData)
{
    XtFree(SmartIndentDialog.langModeName);
    SmartIndentDialog.shell = NULL;
}

static void langModeCB(Widget w, XtPointer clientData, XtPointer callData)
{
    char *modeName;
    int i, resp;
    static smartIndentRec emptyIndentSpec = {NULL, NULL, NULL, NULL};
    smartIndentRec *oldMacros, *newMacros;
	    
    /* Get the newly selected mode name.  If it's the same, do nothing */
    XtVaGetValues(w, XmNuserData, &modeName, 0);
    if (!strcmp(modeName, SmartIndentDialog.langModeName))
    	return;

    /* Find the original macros */
    for (i=0; i<NSmartIndentSpecs; i++)
    	if (!strcmp(SmartIndentDialog.langModeName,SmartIndentSpecs[i]->lmName))
	    break;
    oldMacros = i == NSmartIndentSpecs ? &emptyIndentSpec : SmartIndentSpecs[i];
    
    /* Check if the macros have changed, if so allow user to apply, discard,
       or cancel */
    newMacros = getSmartIndentDialogData();
    if (indentSpecsDiffer(oldMacros, newMacros)) {
	resp = DialogF(DF_QUES, SmartIndentDialog.shell, 3,
      "Smart indent macros for language mode\n%s were changed.  Apply changes?",
		"Apply", "Discard", "Cancel", oldMacros->lmName);
	if (resp == 3) {
	    SetLangModeMenu(SmartIndentDialog.lmOptMenu,
		    SmartIndentDialog.langModeName);
	    return;
    	} else if (resp == 1) {
	    if (checkSmartIndentDialogData()) {
		if (oldMacros == &emptyIndentSpec) {
		    SmartIndentSpecs[NSmartIndentSpecs++] =
		    	    copyIndentSpec(newMacros);
	    	} else {
		    freeIndentSpec(oldMacros);
		    SmartIndentSpecs[i] = copyIndentSpec(newMacros);
		}
	    } else {
     	    	SetLangModeMenu(SmartIndentDialog.lmOptMenu,
		    	SmartIndentDialog.langModeName);
		return;
	    }
     	}
    }
    freeIndentSpec(newMacros);
    
    /* Fill the dialog with the new language mode information */
    SmartIndentDialog.langModeName = CopyAllocatedString(modeName);
    setSmartIndentDialogData(findIndentSpec(modeName));
}

static void lmDialogCB(Widget w, XtPointer clientData, XtPointer callData)
{
    EditLanguageModes(SmartIndentDialog.shell);
}

static void commonDialogCB(Widget w, XtPointer clientData, XtPointer callData)
{
    EditCommonSmartIndentMacro();
}

static void okCB(Widget w, XtPointer clientData, XtPointer callData)
{
    /* change the macro */
    if (!updateSmartIndentData())
    	return;
    
    /* pop down and destroy the dialog */
    XtDestroyWidget(SmartIndentDialog.shell);
}

static void applyCB(Widget w, XtPointer clientData, XtPointer callData)
{
    /* change the patterns */
    updateSmartIndentData();
}
	
static void checkCB(Widget w, XtPointer clientData, XtPointer callData)
{
    if (checkSmartIndentDialogData())
	DialogF(DF_INF, SmartIndentDialog.shell, 1,
    		"Macros compiled without error", "Dismiss");
}
	
static void restoreCB(Widget w, XtPointer clientData, XtPointer callData)
{
   int i;
   smartIndentRec *defaultIS;
    
    /* Find the default indent spec */
    for (i=0; i<N_DEFAULT_INDENT_SPECS; i++)
    	if (!strcmp(SmartIndentDialog.langModeName,
		DefaultIndentSpecs[i].lmName))
	    break;
    if (i == N_DEFAULT_INDENT_SPECS) {
    	DialogF(DF_WARN, SmartIndentDialog.shell, 1,
 		"There are no default indent macros\nfor language mode %s",
 		"Dismiss", SmartIndentDialog.langModeName);
    	return;
    }
    defaultIS = &DefaultIndentSpecs[i];
    
    if (DialogF(DF_WARN, SmartIndentDialog.shell, 2,
"Are you sure you want to discard\n\
all changes to smart indent macros\n\
for language mode %s?", "Discard", "Cancel",
	    SmartIndentDialog.langModeName) == 2)
    	return;
    
    /* if a stored version of the indent macros exist, replace them, if not,
       add a new one */
    for (i=0; i<NSmartIndentSpecs; i++)
    	if (!strcmp(SmartIndentDialog.langModeName,SmartIndentSpecs[i]->lmName))
	    break;
    if (i < NSmartIndentSpecs) {
     	freeIndentSpec(SmartIndentSpecs[i]);
   	SmartIndentSpecs[i] = copyIndentSpec(defaultIS);
    } else
    	SmartIndentSpecs[NSmartIndentSpecs++] = copyIndentSpec(defaultIS);
   
    /* Update the dialog */
    setSmartIndentDialogData(defaultIS);
}
	
static void deleteCB(Widget w, XtPointer clientData, XtPointer callData)
{
    int i;
    
    if (DialogF(DF_WARN, SmartIndentDialog.shell, 2,
"Are you sure you want to delete smart indent\n\
macros for language mode %s?", "Yes, Delete", "Cancel",
    	    SmartIndentDialog.langModeName) == 2)
    	return;
    /* if a stored version of the pattern set exists, delete it from the list */
    for (i=0; i<NSmartIndentSpecs; i++)
    	if (!strcmp(SmartIndentDialog.langModeName,SmartIndentSpecs[i]->lmName))
	    break;
    if (i < NSmartIndentSpecs) {
     	freeIndentSpec(SmartIndentSpecs[i]);
   	memmove(&SmartIndentSpecs[i], &SmartIndentSpecs[i+1],
   	    	(NSmartIndentSpecs-1 - i) * sizeof(smartIndentRec *));
    	NSmartIndentSpecs--;
    }
    
    /* Clear out the dialog */
    setSmartIndentDialogData(NULL);
}

static void dismissCB(Widget w, XtPointer clientData, XtPointer callData)
{
    /* pop down and destroy the dialog */
    XtDestroyWidget(SmartIndentDialog.shell);
}

static void helpCB(Widget w, XtPointer clientData, XtPointer callData)
{
    Help(SmartIndentDialog.shell, HELP_SMART_INDENT);
}

static int checkSmartIndentDialogData(void)
{
    char *widgetText, *errMsg, *stoppedAt;
    Program *prog;
    
    /* Check the initialization macro */
    if (!TextWidgetIsBlank(SmartIndentDialog.initMacro)) {
	widgetText =ensureNewline(XmTextGetString(SmartIndentDialog.initMacro));
	if (!CheckMacroString(SmartIndentDialog.shell, widgetText,
		"initialization macro", &stoppedAt)) {
    	    XmTextSetInsertionPosition(SmartIndentDialog.initMacro,
		    stoppedAt - widgetText);
	    XmProcessTraversal(SmartIndentDialog.initMacro, XmTRAVERSE_CURRENT);
	    XtFree(widgetText);
	    return False;
	}
	XtFree(widgetText);
    }
    
    /* Test compile the newline macro */
    if (TextWidgetIsBlank(SmartIndentDialog.newlineMacro)) {
    	DialogF(DF_WARN, SmartIndentDialog.shell, 1, "Newline macro required",
    	    	"Dismiss");
    	return False;
    }
    widgetText = ensureNewline(XmTextGetString(SmartIndentDialog.newlineMacro));
    prog = ParseMacro(widgetText, &errMsg, &stoppedAt);
    if (prog == NULL) {
 	ParseError(SmartIndentDialog.shell, widgetText, stoppedAt,
    	    	"newline macro", errMsg);
     	XmTextSetInsertionPosition(SmartIndentDialog.newlineMacro,
		stoppedAt - widgetText);
	XmProcessTraversal(SmartIndentDialog.newlineMacro, XmTRAVERSE_CURRENT);
  	XtFree(widgetText);
    	return False;
    }
    XtFree(widgetText);
    FreeProgram(prog);
    
    /* Test compile the modify macro */
    if (!TextWidgetIsBlank(SmartIndentDialog.modMacro)) {
    	widgetText = ensureNewline(XmTextGetString(SmartIndentDialog.modMacro));
    	prog = ParseMacro(widgetText, &errMsg, &stoppedAt);
	if (prog == NULL) {
    	    ParseError(SmartIndentDialog.shell, widgetText, stoppedAt,
    	    	    "modify macro", errMsg);
     	    XmTextSetInsertionPosition(SmartIndentDialog.modMacro,
		    stoppedAt - widgetText);
	    XmProcessTraversal(SmartIndentDialog.modMacro, XmTRAVERSE_CURRENT);
    	    XtFree(widgetText);
    	    return False;
    	}
    	XtFree(widgetText);
	FreeProgram(prog);
    }
    return True;
}

static smartIndentRec *getSmartIndentDialogData(void)
{
    smartIndentRec *is;
    
    is = (smartIndentRec *)XtMalloc(sizeof(smartIndentRec));
    is->lmName = CopyAllocatedString(SmartIndentDialog.langModeName);
    is->initMacro = TextWidgetIsBlank(SmartIndentDialog.initMacro) ? NULL :
	    ensureNewline(XmTextGetString(SmartIndentDialog.initMacro));
    is->newlineMacro = TextWidgetIsBlank(SmartIndentDialog.newlineMacro) ? NULL:
	    ensureNewline(XmTextGetString(SmartIndentDialog.newlineMacro));
    is->modMacro = TextWidgetIsBlank(SmartIndentDialog.modMacro) ? NULL :
	    ensureNewline(XmTextGetString(SmartIndentDialog.modMacro));
    return is;
}

static void setSmartIndentDialogData(smartIndentRec *is)
{
    if (is == NULL) {
	XmTextSetString(SmartIndentDialog.initMacro, "");
	XmTextSetString(SmartIndentDialog.newlineMacro, "");
	XmTextSetString(SmartIndentDialog.modMacro, "");
    } else {
	if (is->initMacro == NULL)
	    XmTextSetString(SmartIndentDialog.initMacro, "");
	else
	    XmTextSetString(SmartIndentDialog.initMacro, is->initMacro);
	XmTextSetString(SmartIndentDialog.newlineMacro, is->newlineMacro);
	if (is->modMacro == NULL)
	    XmTextSetString(SmartIndentDialog.modMacro, "");
	else
	    XmTextSetString(SmartIndentDialog.modMacro, is->modMacro);
    }
}

void EditCommonSmartIndentMacro(void)
{
#define VERT_BORDER 4
    Widget form, topLbl;
    Widget okBtn, applyBtn, checkBtn;
    Widget dismissBtn, restoreBtn;
    XmString s1;
    Arg args[20];
    int n;

    /* if the dialog is already displayed, just pop it to the top and return */
    if (CommonDialog.shell != NULL) {
    	RaiseShellWindow(CommonDialog.shell);
    	return;
    }

    /* Create a form widget in an application shell */
    n = 0;
    XtSetArg(args[n], XmNdeleteResponse, XmDO_NOTHING); n++;
    XtSetArg(args[n], XmNiconName, "Common Smart Indent Macros"); n++;
    XtSetArg(args[n], XmNtitle, "Common Smart Indent Macros"); n++;
    CommonDialog.shell = XtAppCreateShell(APP_NAME, APP_CLASS,
	    applicationShellWidgetClass, TheDisplay, args, n);
    AddSmallIcon(CommonDialog.shell);
    form = XtVaCreateManagedWidget("editCommonSIMacros", xmFormWidgetClass,
	    CommonDialog.shell, XmNautoUnmanage, False,
	    XmNresizePolicy, XmRESIZE_NONE, 0);
    XtAddCallback(form, XmNdestroyCallback, comDestroyCB, NULL);
    AddMotifCloseCallback(CommonDialog.shell, comDismissCB, NULL);
    
    topLbl = XtVaCreateManagedWidget("topLbl", xmLabelGadgetClass, form,
    	    XmNlabelString, s1=XmStringCreateSimple(
	        "Common Definitions for Smart Indent Macros"),
    	    XmNmnemonic, 'C',
	    XmNtopAttachment, XmATTACH_FORM,
	    XmNtopOffset, VERT_BORDER,
	    XmNleftAttachment, XmATTACH_POSITION,
	    XmNleftPosition, 1, 0);

    okBtn = XtVaCreateManagedWidget("ok", xmPushButtonWidgetClass, form,
    	    XmNlabelString, s1=XmStringCreateSimple("OK"),
    	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 6,
    	    XmNrightAttachment, XmATTACH_POSITION,
    	    XmNrightPosition, 18,
    	    XmNbottomAttachment, XmATTACH_FORM,
    	    XmNbottomOffset, VERT_BORDER, 0);
    XtAddCallback(okBtn, XmNactivateCallback, comOKCB, NULL);
    XmStringFree(s1);
    
    applyBtn = XtVaCreateManagedWidget("apply", xmPushButtonWidgetClass, form,
    	    XmNlabelString, s1=XmStringCreateSimple("Apply"),
    	    XmNmnemonic, 'y',
    	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 22,
    	    XmNrightAttachment, XmATTACH_POSITION,
    	    XmNrightPosition, 35,
    	    XmNbottomAttachment, XmATTACH_FORM,
    	    XmNbottomOffset, VERT_BORDER, 0);
    XtAddCallback(applyBtn, XmNactivateCallback, comApplyCB, NULL);
    XmStringFree(s1);
    
    checkBtn = XtVaCreateManagedWidget("check", xmPushButtonWidgetClass, form,
    	    XmNlabelString, s1=XmStringCreateSimple("Check"),
    	    XmNmnemonic, 'k',
    	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 39,
    	    XmNrightAttachment, XmATTACH_POSITION,
    	    XmNrightPosition, 52,
    	    XmNbottomAttachment, XmATTACH_FORM,
    	    XmNbottomOffset, VERT_BORDER, 0);
    XtAddCallback(checkBtn, XmNactivateCallback, comCheckCB, NULL);
    XmStringFree(s1);
    
    restoreBtn = XtVaCreateManagedWidget("restore", xmPushButtonWidgetClass,
    form,
    	    XmNlabelString, s1=XmStringCreateSimple("Restore Default"),
    	    XmNmnemonic, 'f',
    	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 56,
    	    XmNrightAttachment, XmATTACH_POSITION,
    	    XmNrightPosition, 77,
    	    XmNbottomAttachment, XmATTACH_FORM,
    	    XmNbottomOffset, VERT_BORDER, 0);
    XtAddCallback(restoreBtn, XmNactivateCallback, comRestoreCB, NULL);
    XmStringFree(s1);
    
    dismissBtn = XtVaCreateManagedWidget("dismiss", xmPushButtonWidgetClass,
    	    form,
    	    XmNlabelString, s1=XmStringCreateSimple("Dismiss"),
    	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 81,
    	    XmNrightAttachment, XmATTACH_POSITION,
    	    XmNrightPosition, 94,
    	    XmNbottomAttachment, XmATTACH_FORM,
    	    XmNbottomOffset, VERT_BORDER, 0);
    XtAddCallback(dismissBtn, XmNactivateCallback, comDismissCB, NULL);
    XmStringFree(s1);
    
    n = 0;
    XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
    XtSetArg(args[n], XmNrows, 24); n++;
    XtSetArg(args[n], XmNcolumns, 80); n++;
    XtSetArg(args[n], XmNvalue, CommonMacros); n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNtopWidget, topLbl); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNleftPosition, 1); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNrightPosition, 99); n++;
    XtSetArg(args[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNbottomWidget, okBtn); n++;
    XtSetArg(args[n], XmNbottomOffset, VERT_BORDER); n++;
    CommonDialog.text = XmCreateScrolledText(form, "commonText", args, n);
    XtManageChild(CommonDialog.text);
    RemapDeleteKey(CommonDialog.text);
    XtVaSetValues(topLbl, XmNuserData, CommonDialog.text, 0);

    /* Set initial default button */
    XtVaSetValues(form, XmNdefaultButton, okBtn, 0);
    XtVaSetValues(form, XmNcancelButton, dismissBtn, 0);
    
    /* Handle mnemonic selection of buttons and focus to dialog */
    AddDialogMnemonicHandler(form);
    
    /* Realize all of the widgets in the new dialog */
    XtRealizeWidget(CommonDialog.shell);
}

static void comDestroyCB(Widget w, XtPointer clientData, XtPointer callData)
{
    CommonDialog.shell = NULL;
}

static void comOKCB(Widget w, XtPointer clientData, XtPointer callData)
{
    /* change the macro */
    if (!updateSmartIndentCommonData())
    	return;
    
    /* pop down and destroy the dialog */
    XtDestroyWidget(CommonDialog.shell);
}

static void comApplyCB(Widget w, XtPointer clientData, XtPointer callData)
{
    /* change the macro */
    updateSmartIndentCommonData();
}
	
static void comCheckCB(Widget w, XtPointer clientData, XtPointer callData)
{
    if (checkSmartIndentCommonDialogData())
	DialogF(DF_INF, CommonDialog.shell, 1,
    		"Macros compiled without error", "Dismiss");
}
	
static void comRestoreCB(Widget w, XtPointer clientData, XtPointer callData)
{
    if (DialogF(DF_WARN, CommonDialog.shell, 2,
"Are you sure you want to discard all\n\
changes to common smart indent macros", "Discard", "Cancel") == 2)
    	return;
    
    /* replace common macros with default */
    if (CommonMacros != NULL)
    	XtFree(CommonMacros);
    CommonMacros = XtNewString(DefaultCommonMacros);
   
    /* Update the dialog */
    XmTextSetString(CommonDialog.text, CommonMacros);
}

static void comDismissCB(Widget w, XtPointer clientData, XtPointer callData)
{
    /* pop down and destroy the dialog */
    XtDestroyWidget(CommonDialog.shell);
}

/*
** Update the smart indent macros being edited in the dialog
** with the information that the dialog is currently displaying, and
** apply changes to any window which is currently using the macros.
*/
static int updateSmartIndentCommonData(void)
{
    WindowInfo *window;
    	
    /* Make sure the patterns are valid and compile */
    if (!checkSmartIndentCommonDialogData())
    	return False;
    
    /* Get the current data */
    CommonMacros = ensureNewline(XmTextGetString(CommonDialog.text));
    
    /* Re-execute initialization macros (macros require a window to function,
       since user could theoretically execute an action routine, but it
       probably won't be referenced in a smart indent initialization) */
    if (!ReadMacroString(WindowList, CommonMacros, "common macros"))
    	return False;

    /* Find windows that are currently using smart indent and
       re-initialize the smart indent macros (in case they have initialization
       data which depends on common data) */
    for (window=WindowList; window!=NULL; window=window->next) {
    	if (window->indentStyle == SMART_INDENT &&
    		window->languageMode != PLAIN_LANGUAGE_MODE) {
    	    EndSmartIndent(window);
    	    BeginSmartIndent(window, False);
    	}
    }
    
    /* Note that preferences have been changed */
    MarkPrefsChanged();

    return True;
}

static int checkSmartIndentCommonDialogData(void)
{
    char *widgetText, *stoppedAt;
    
    if (!TextWidgetIsBlank(CommonDialog.text)) {
	widgetText = ensureNewline(XmTextGetString(CommonDialog.text));
	if (!CheckMacroString(CommonDialog.shell, widgetText,
		"macros", &stoppedAt)) {
    	    XmTextSetInsertionPosition(CommonDialog.text, stoppedAt-widgetText);
	    XmProcessTraversal(CommonDialog.text, XmTRAVERSE_CURRENT);
	    XtFree(widgetText);
	    return False;
	}
	XtFree(widgetText);
    }
    return True;
}

/*
** Update the smart indent macros being edited in the dialog
** with the information that the dialog is currently displaying, and
** apply changes to any window which is currently using the macros.
*/
static int updateSmartIndentData(void)
{
    smartIndentRec *newMacros;
    WindowInfo *window;
    char *lmName;
    int i;
    	
    /* Make sure the patterns are valid and compile */
    if (!checkSmartIndentDialogData())
    	return False;
    
    /* Get the current data */
    newMacros = getSmartIndentDialogData();
    
    /* Find the original macros */
    for (i=0; i<NSmartIndentSpecs; i++)
    	if (!strcmp(SmartIndentDialog.langModeName,SmartIndentSpecs[i]->lmName))
	    break;
    
    /* If it's a new language, add it at the end, otherwise free the
       existing macros and replace it */
    if (i == NSmartIndentSpecs) {
    	SmartIndentSpecs[NSmartIndentSpecs++] = newMacros;
    } else {
	freeIndentSpec(SmartIndentSpecs[i]);
	SmartIndentSpecs[i] = newMacros;
    }
    
    /* Find windows that are currently using this indent specification and
       re-do the smart indent macros */
    for (window=WindowList; window!=NULL; window=window->next) {
    	lmName = LanguageModeName(window->languageMode);
	if (lmName != NULL && !strcmp(lmName, newMacros->lmName)) {
	    XtSetSensitive(window->smartIndentItem, True);
    	    if (window->indentStyle == SMART_INDENT &&
    		    window->languageMode != PLAIN_LANGUAGE_MODE) {
    	    	EndSmartIndent(window);
    	    	BeginSmartIndent(window, False);
    	    }
    	}
    }
    
    /* Note that preferences have been changed */
    MarkPrefsChanged();

    return True;
}

static int loadDefaultIndentSpec(char *lmName)
{
    int i;
    
    for (i=0; i<N_DEFAULT_INDENT_SPECS; i++) {
    	if (!strcmp(lmName, DefaultIndentSpecs[i].lmName)) {
    	    SmartIndentSpecs[NSmartIndentSpecs++] =
		    copyIndentSpec(&DefaultIndentSpecs[i]);
    	    return True;
    	}
    }
    return False;
}

int LoadSmartIndentString(char *inString)
{
   char *errMsg, *macroStart, *inPtr = inString;
   smartIndentRec is, *isCopy;
   int i;

   for (;;) {
   	
	/* skip over blank space */
	inPtr += strspn(inPtr, " \t\n");
	
	/* finished */
	if (*inPtr == '\0')
	    return True;

	/* read language mode name */
	is.lmName = ReadSymbolicField(&inPtr);
	if (is.lmName == NULL)
    	    return siParseError(inString, inPtr, "language mode name required");
	if (!SkipDelimiter(&inPtr, &errMsg)) {
    	    XtFree(is.lmName);
    	    return siParseError(inString, inPtr, errMsg);
    	}
    	
	/* look for "Default" keyword, and if it's there, return the default
	   smart indent macros */
	if (!strncmp(inPtr, "Default", 7)) {
    	    inPtr += 7;
    	    if (!loadDefaultIndentSpec(is.lmName)) {
    		XtFree(is.lmName);
    		return siParseError(inString, inPtr,
    	    		"no default smart indent macros");
    	    }
    	    XtFree(is.lmName);
    	    continue;
	}

	/* read the initialization macro (arbitrary text terminated by the
	   macro end boundary string) */
	is.initMacro = readSIMacro(&inPtr);
	if (is.initMacro == NULL) {
    	    XtFree(is.lmName);
    	    return siParseError(inString, inPtr,
    	    	    "no end boundary to initialization macro");
	}
	
	/* read the newline macro */
	is.newlineMacro = readSIMacro(&inPtr);
	if (is.newlineMacro == NULL) {
    	    XtFree(is.lmName);
    	    XtFree(is.initMacro);
    	    return siParseError(inString, inPtr,
    	    	    "no end boundary to newline macro");
	}
	
	/* read the modify macro */
	macroStart = inPtr + strspn(inPtr, " \t\n");
	is.modMacro = readSIMacro(&inPtr);
	if (is.modMacro == NULL) {
    	    XtFree(is.lmName);
    	    XtFree(is.initMacro);
    	    XtFree(is.newlineMacro);
    	    return siParseError(inString, inPtr,
    	    	    "no end boundary to modify macro");
	}
	
	/* if there's no mod macro, make it null so it won't be executed */
	if (is.modMacro[0] == '\0') {
	    XtFree(is.modMacro);
            is.modMacro = NULL;
    	}
    	
    	/* create a new data structure and add/change it in the list */
	isCopy = (smartIndentRec *)XtMalloc(sizeof(smartIndentRec));
	*isCopy = is;
	for (i=0; i<NSmartIndentSpecs; i++) {
	    if (!strcmp(SmartIndentSpecs[i]->lmName, is.lmName)) {
		freeIndentSpec(SmartIndentSpecs[i]);
		SmartIndentSpecs[i] = isCopy;
		break;
	    }
	}
	if (i == NSmartIndentSpecs)
	    SmartIndentSpecs[NSmartIndentSpecs++] = isCopy;
    }
}

int LoadSmartIndentCommonString(char *inString)
{
    int shiftedLen;
    char *inPtr = inString;
    
    /* If called from -import, can replace existing ones */
    if (CommonMacros != NULL)
	XtFree(CommonMacros);
    
    /* skip over blank space */
    inPtr += strspn(inPtr, " \t\n");

    /* look for "Default" keyword, and if it's there, return the default
       smart common macro */
    if (!strncmp(inPtr, "Default", 7)) {
    	CommonMacros = XtNewString(DefaultCommonMacros);
	return True;
    }
        
    /* Remove leading tabs added by writer routine */
    CommonMacros = ShiftText(inPtr, SHIFT_LEFT, True, 8, 8, &shiftedLen);
    return True;
}

/*
** Read a macro (arbitrary text terminated by the macro end boundary string)
** from the position pointed to by *inPtr, trim off added tabs and return an
** allocated copy of the string, and advance *inPtr to the end of the macro.
** Returns NULL if the macro end boundary string is not found.
*/
static char *readSIMacro(char **inPtr)
{
    char *retStr, *macroStr, *macroEnd;
    int shiftedLen;
    
    /* Strip leading newline */
    if (**inPtr == '\n')
    	(*inPtr)++;
    
    /* Find the end of the macro */
    macroEnd = strstr(*inPtr, MacroEndBoundary);
    if (macroEnd == NULL)
	return NULL;
    
    /* Copy the macro */
    macroStr = XtMalloc(macroEnd - *inPtr + 1);
    strncpy(macroStr, *inPtr, macroEnd - *inPtr);
    macroStr[macroEnd - *inPtr] = '\0';
    
    /* Remove leading tabs added by writer routine */
    *inPtr = macroEnd + strlen(MacroEndBoundary);
    retStr = ShiftText(macroStr, SHIFT_LEFT, True, 8, 8, &shiftedLen);
    XtFree(macroStr);
    return retStr;
}

static smartIndentRec *copyIndentSpec(smartIndentRec *is)
{
    smartIndentRec *ris = (smartIndentRec *)XtMalloc(sizeof(smartIndentRec));
    ris->lmName = CopyAllocatedString(is->lmName);
    ris->initMacro = CopyAllocatedString(is->initMacro);
    ris->newlineMacro = CopyAllocatedString(is->newlineMacro);
    ris->modMacro = CopyAllocatedString(is->modMacro);
    return ris;
}

void freeIndentSpec(smartIndentRec *is)
{
    XtFree(is->lmName);
    if (is->initMacro != NULL) XtFree(is->initMacro);
    XtFree(is->newlineMacro);
    if (is->modMacro != NULL)XtFree(is->modMacro);
}

int indentSpecsDiffer(smartIndentRec *is1, smartIndentRec *is2)
{
    return AllocatedStringsDiffer(is1->initMacro, is2->initMacro) ||
	    AllocatedStringsDiffer(is1->newlineMacro, is2->newlineMacro) ||
	    AllocatedStringsDiffer(is1->modMacro, is2->modMacro);
}

static int siParseError(char *stringStart, char *stoppedAt, char *message)
{
    return ParseError(NULL, stringStart, stoppedAt,
    	    "smart indent specification", message);
}

char *WriteSmartIndentString(void)
{
    int i;
    smartIndentRec *sis;
    textBuffer *outBuf;
    char *outStr, *escapedStr;
    
    outBuf = BufCreate();
    for (i=0; i<NSmartIndentSpecs; i++) {
    	sis = SmartIndentSpecs[i];
    	BufInsert(outBuf, outBuf->length, "\t");
    	BufInsert(outBuf, outBuf->length, sis->lmName);
    	BufInsert(outBuf, outBuf->length, ":");
    	if (isDefaultIndentSpec(sis))
    	    BufInsert(outBuf, outBuf->length, "Default\n");
    	else {
    	    insertShiftedMacro(outBuf, sis->initMacro);
    	    insertShiftedMacro(outBuf, sis->newlineMacro);
    	    insertShiftedMacro(outBuf, sis->modMacro);
    	}
    }
    
    /* Get the output string, and lop off the trailing newline */
    outStr = BufGetRange(outBuf, 0, outBuf->length > 0 ? outBuf->length-1 : 0);
    BufFree(outBuf);
    
    /* Protect newlines and backslashes from translation by the resource
       reader */
    escapedStr = EscapeSensitiveChars(outStr);
    XtFree(outStr);
    return escapedStr;
}

char *WriteSmartIndentCommonString(void)
{
    int len;
    char *outStr, *escapedStr;
    
    if (!strcmp(CommonMacros, DefaultCommonMacros))
    	return XtNewString("Default");
    if (CommonMacros == NULL)
    	return XtNewString("");
    
    /* Shift the macro over by a tab to keep .nedit file bright and clean */
    outStr = ShiftText(CommonMacros, SHIFT_RIGHT, True, 8, 8, &len);
	
    /* Protect newlines and backslashes from translation by the resource
       reader */
    escapedStr = EscapeSensitiveChars(outStr);
    XtFree(outStr);
    
    /* If there's a trailing escaped newline, remove it */
    len = strlen(escapedStr);
    if (len > 1 && escapedStr[len-1] == '\n' && escapedStr[len-2] == '\\')
    	escapedStr[len-2] = '\0';
    return escapedStr;
}

/*
** Insert macro text "macro" into buffer "buf" shifted right by 8 characters
** (so it looks nice in the .nedit file), and terminated with a macro-end-
** boundary string.
*/
static void insertShiftedMacro(textBuffer *buf, char  *macro)
{
    char *shiftedMacro;
    int shiftedLen;
    
    if (macro != NULL) {
	shiftedMacro = ShiftText(macro, SHIFT_RIGHT, True, 8, 8, &shiftedLen);
	BufInsert(buf, buf->length, shiftedMacro);
	XtFree(shiftedMacro);
    }
    BufInsert(buf, buf->length, "\t");
    BufInsert(buf, buf->length, MacroEndBoundary);
    BufInsert(buf, buf->length, "\n");
}

static int isDefaultIndentSpec(smartIndentRec *indentSpec)
{
    int i;
   
    for (i=0; i<N_DEFAULT_INDENT_SPECS; i++)
    	if (!strcmp(indentSpec->lmName, DefaultIndentSpecs[i].lmName))
    	    return !indentSpecsDiffer(indentSpec, &DefaultIndentSpecs[i]);
    return False;
}
    
static smartIndentRec *findIndentSpec(char *modeName)
{
    int i;

    if (modeName == NULL)
    	return NULL;
    
    for (i=0; i<NSmartIndentSpecs; i++)
    	if (!strcmp(modeName, SmartIndentSpecs[i]->lmName))
    	    return SmartIndentSpecs[i];
    return NULL;
}

/*
** If "string" is not terminated with a newline character,  return a
** reallocated string which does end in a newline (otherwise, just pass on
** string as function value).  (The macro language requires newline terminators
** for statements, but the text widget doesn't force it like the NEdit text
** buffer does, so this might avoid some confusion.)
*/
static char *ensureNewline(char *string)
{
    char *newString;
    int length;
    
    if (string == NULL)
	return NULL;
    length = strlen(string);
    if (length == 0 || string[length-1] == '\n')
	return string;
    newString = XtMalloc(length + 2);
    strcpy(newString, string);
    newString[length] = '\n';
    newString[length+1] = '\0';
    XtFree(string);
    return newString;
}
