/*******************************************************************************
*									       *
* help.c -- Nirvana Editor help display					       *
*									       *
* Copyright (c) 1991 Universities Research Association, Inc.		       *
* All rights reserved.							       *
* 									       *
* This material resulted from work developed under a Government Contract and   *
* is subject to the following license:  The Government retains a paid-up,      *
* nonexclusive, irrevocable worldwide license to reproduce, prepare derivative *
* works, perform publicly and display publicly by or for the Government,       *
* including the right to distribute to other Government contractors.  Neither  *
* the United States nor the United States Department of Energy, nor any of     *
* their employees, makes any warranty, express or implied, or assumes any      *
* legal liability or responsibility for the accuracy, completeness, or         *
* usefulness of any information, apparatus, product, or process disclosed, or  *
* represents that its use would not infringe privately owned rights.           *
*                                        				       *
* Fermilab Nirvana GUI Library						       *
* September 10, 1991							       *
*									       *
* Written by Mark Edel							       *
*									       *
*******************************************************************************/
#ifdef VMS
#include "../util/VMSparam.h"
#else
#include <sys/param.h>
#endif /*VMS*/
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/ScrolledW.h>
#include <Xm/ScrollBar.h>
#include <Xm/PushB.h>
#include "../util/misc.h"
#include "../util/DialogF.h"
#include "textBuf.h"
#include "text.h"
#include "textSel.h"
#include "nedit.h"
#include "search.h"
#include "window.h"
#include "preferences.h"
#include "help.h"
#include "file.h"

static char *HelpTitles[NUM_TOPICS] = {
"Version",
"Getting Started",
"Finding and Replacing Text",
"Selecting Text",
"Cut and Paste",
"Auto / Smart Indent",
"Tabs / Emulated Tabs",
"Programming with NEdit",
"Finding Declarations (ctags)",
"Using the Mouse",
"Keyboard Shortcuts",
"Shifting and Filling",
"Syntax Highlighting",
"Crash Recovery",
"Preferences",
"Shell Commands/Filters",
"Regular Expressions",
"NEdit Command Line",
"Server Mode and nc",
"Customizing NEdit",
"X Resources",
"Key Binding",
"Learn/Replay",
"Macro Language",
"Macro Subroutines",
"Actions Routines",
"Highlighting Patterns",
"Smart Indent Macros",
"Problems/Bugs",
"Mailing Lists",
"Distribution Policy",
"Tabs Dialog"};

static char AuxString0[] = {'N','E','d','i','t',' ','V','e','r','s','i','o','n',' ','5','.','0','.','2','\n',
'M','a','r','c','h',' ','1','1',',',' ','1','9','9','8','\n',
'\n',
'C','o','p','y','r','i','g','h','t',' ','(','c',')',' ','1','9','9','2',',',' ','1','9','9','3',',',' ','1','9','9','4',',',' ','1','9','9','6',',',' ','1','9','9','7',',',' ','1','9','9','8','\n',
'U','n','i','v','e','r','s','i','t','i','e','s',' ','R','e','s','e','a','r','c','h',' ','A','s','s','o','c','i','a','t','i','o','n',',',' ','I','n','c','.','\n',
'A','l','l',' ','r','i','g','h','t','s',' ','r','e','s','e','r','v','e','d','.','\n',
'\n',
'N','E','d','i','t',' ','w','a','s',' ','w','r','i','t','t','e','n',' ','b','y',' ','M','a','r','k',' ','E','d','e','l',',',' ','J','o','y',' ','K','y','r','i','a','k','o','p','u','l','o','s',',',' ','A','r','n','u','l','f','o',' ','Z','e','p','e','d','a','-','N','a','v','r','a','t','i','l',',',' ',
'S','u','r','e','s','h',' ','R','a','v','o','o','r',',',' ','D','o','n','n','a',' ','R','e','i','d',',',' ','a','n','d',' ','J','e','f','f',' ','K','a','l','l','e','n','b','a','c','h',',',' ',
'a','t',' ','F','e','r','m','i',' ','N','a','t','i','o','n','a','l',' ','A','c','c','e','l','e','r','a','t','o','r',' ','L','a','b','o','r','a','t','o','r','y','*','.','\n',
'\n',
'T','h','e',' ','r','e','g','u','l','a','r',' ','e','x','p','r','e','s','s','i','o','n',' ','m','a','t','c','h','i','n','g',' ','r','o','u','t','i','n','e','s',' ','u','s','e','d',' ','i','n',' ','N','E','d','i','t',' ','a','r','e',' ','a','d','a','p','t','e','d',' ','(','w','i','t','h',' ',
'p','e','r','m','i','s','s','i','o','n',')',' ','f','r','o','m',' ','o','r','i','g','i','n','a','l',' ','c','o','d','e',' ','w','r','i','t','t','e','n',' ','b','y',' ','H','e','n','r','y',' ','S','p','e','n','c','e','r',' ','a','t',' ','t','h','e',' ',
'U','n','i','v','e','r','s','i','t','y',' ','o','f',' ','T','o','r','o','n','t','o','.','\n',
'\n',
'S','y','n','t','a','x',' ','h','i','g','h','l','i','g','h','t','i','n','g',' ','p','a','t','t','e','r','n','s',' ','w','e','r','e',' ','c','o','n','t','r','i','b','u','t','e','d',' ','b','y',':',' ',
'S','i','m','o','n',' ','T','.',' ','M','a','c','D','o','n','a','l','d',',',' ',' ','M','a','u','r','i','c','e',' ','L','e','y','s','e','n','s',',',' ','M','a','t','t',' ','M','a','j','k','a',',',' ','A','l','f','r','e','d',' ','S','m','e','e','n','k',',',' ',
'A','l','a','i','n',' ','F','a','r','g','u','e','s',',',' ','C','h','r','i','s','t','o','p','h','e','r',' ','C','o','n','r','a','d',',',' ','S','c','o','t','t',' ','M','a','r','k','i','n','s','o','n',',',' ','K','o','n','r','a','d',' ','B','e','r','n','l','o','e','h','r',',',' ',
'I','v','a','n',' ','H','e','r','m','a','n',',',' ','P','a','t','r','i','c','e',' ','V','e','n','a','n','t',',',' ','C','h','r','i','s','t','i','a','n',' ','D','e','n','a','t',',',' ','P','h','i','l','i','p','p','e',' ','C','o','u','t','o','n',',',' ',
'M','a','x',' ','V','o','h','l','k','e','n',',',' ','a','n','d',' ','M','a','r','k','u','s',' ','S','c','h','w','a','r','z','e','n','b','e','r','g','.','\n',
'\n',
'N','E','d','i','t',' ','s','o','u','r','c','e','s',',',' ','e','x','e','c','u','t','a','b','l','e','s',',',' ','a','d','d','i','t','i','o','n','a','l',' ','d','o','c','u','m','e','n','t','a','t','i','o','n',',',' ','a','n','d',' ','c','o','n','t','r','i','b','u','t','e','d',' ',
's','o','f','t','w','a','r','e',' ','a','r','e',' ','a','v','a','i','l','a','b','l','e',' ','f','r','o','m',' ','f','t','p','.','f','n','a','l','.','g','o','v',' ','i','n',' ','t','h','e',' ','/','p','u','b','/','n','e','d','i','t',' ','d','i','r','e','c','t','o','r','y','.','\n',
'\n',
'S','e','n','d',' ','q','u','e','s','t','i','o','n','s',' ','o','r',' ','c','o','m','m','e','n','t','s',' ','t','o',':',' ','n','e','d','i','t','_','s','u','p','p','o','r','t','@','f','n','a','l','.','g','o','v','.','\n',
'\n',
'M','a','r','k',' ','E','d','e','l','\n',
'e','d','e','l','@','f','n','a','l','.','g','o','v','\n',
'F','e','r','m','i',' ','N','a','t','i','o','n','a','l',' ','A','c','c','e','l','e','r','a','t','o','r',' ','L','a','b','o','r','a','t','o','r','y','\n',
'P','.','O','.',' ','B','o','x',' ','5','0','0','\n',
'B','a','t','a','v','i','a',',',' ','I','L',' ','6','0','1','4','8','\n',
'\n',
'*',' ','F','e','r','m','i',' ','N','a','t','i','o','n','a','l',' ','A','c','c','e','l','e','r','a','t','o','r',' ','L','a','b','o','r','a','t','o','r','y',' ','i','s',' ',
'o','p','e','r','a','t','e','d',' ','b','y',' ','U','n','i','v','e','r','s','i','t','i','e','s',' ','R','e','s','e','a','r','c','h',' ','A','s','s','o','c','i','a','t','i','o','n',',',' ','I','n','c','.',',',' ','u','n','d','e','r',' ',
'c','o','n','t','r','a','c','t',' ','D','E','-','A','C','0','2','-','7','6','C','H','O','3','0','0','0',' ','w','i','t','h',' ','t','h','e',' ','U','.','S','.',' ','D','e','p','a','r','t','m','e','n','t',' ','o','f',' ','E','n','e','r','g','y','.','\0'};

static char AuxString1[] = {'W','e','l','c','o','m','e',' ','t','o',' ','N','E','d','i','t','!','\n',
'\n',
'N','E','d','i','t',' ','i','s',' ','a',' ','s','t','a','n','d','a','r','d',' ','G','U','I',' ','(','G','r','a','p','h','i','c','a','l',' ','U','s','e','r',' ','I','n','t','e','r','f','a','c','e',')',' ','s','t','y','l','e',' ','t','e','x','t',' ','e','d','i','t','o','r',' ','f','o','r',' ',
'p','r','o','g','r','a','m','s',' ','a','n','d',' ','p','l','a','i','n','-','t','e','x','t',' ','f','i','l','e','s','.',' ',' ','U','s','e','r','s',' ','o','f',' ','M','a','c','i','n','t','o','s','h',' ','a','n','d',' ','M','S',' ','W','i','n','d','o','w','s',' ','b','a','s','e','d',' ',
't','e','x','t',' ','e','d','i','t','o','r','s',' ','s','h','o','u','l','d',' ','f','i','n','d',' ','N','E','d','i','t',' ','a',' ','f','a','m','i','l','i','a','r',' ','a','n','d',' ','c','o','m','f','o','r','t','a','b','l','e',' ','e','n','v','i','r','o','n','m','e','n','t','.',' ',' ',
'N','E','d','i','t',' ','p','r','o','v','i','d','e','s',' ','a','l','l',' ','o','f',' ','t','h','e',' ','s','t','a','n','d','a','r','d',' ','m','e','n','u',',',' ','d','i','a','l','o','g',',',' ','e','d','i','t','i','n','g',',',' ','a','n','d',' ','m','o','u','s','e',' ',
's','u','p','p','o','r','t',',',' ','a','s',' ','w','e','l','l',' ','a','s',' ','a','l','l',' ','o','f',' ','t','h','e',' ','s','t','a','n','d','a','r','d',' ','s','h','o','r','t','c','u','t','s',' ','t','o',' ','w','h','i','c','h',' ','t','h','e',' ','u','s','e','r','s',' ',
'o','f',' ','m','o','d','e','r','n',' ','G','U','I',' ','b','a','s','e','d',' ','e','n','v','i','r','o','n','m','e','n','t','s',' ','a','r','e',' ','a','c','c','u','s','t','o','m','e','d','.',' ',' ','F','o','r',' ','u','s','e','r','s',' ','o','f',' ','o','l','d','e','r',' ',
's','t','y','l','e',' ','U','n','i','x',' ','e','d','i','t','o','r','s',',',' ','w','e','l','c','o','m','e',' ','t','o',' ','t','h','e',' ','w','o','r','l','d',' ','o','f',' ','m','o','u','s','e','-','b','a','s','e','d',' ','e','d','i','t','i','n','g','!','\n',
'\n',
'H','e','l','p',' ','s','e','c','t','i','o','n','s',' ','o','f',' ','i','n','t','e','r','e','s','t',' ','t','o',' ','n','e','w',' ','u','s','e','r','s',' ','a','r','e',' ','l','i','s','t','e','d',' ','u','n','d','e','r',' ','t','h','e',' ','\"','B','a','s','i','c',' ',
'O','p','e','r','a','t','i','o','n','\"',' ','h','e','a','d','i','n','g',' ','i','n',' ','t','h','e',' ','t','o','p','-','l','e','v','e','l',' ','H','e','l','p',' ','m','e','n','u',':','\n',
'\n',
'	','S','e','l','e','c','t','i','n','g',' ','T','e','x','t','\n',
'	','F','i','n','d','i','n','g',' ','a','n','d',' ','R','e','p','l','a','c','i','n','g',' ','T','e','x','t','\n',
'	','C','u','t',' ','a','n','d',' ','P','a','s','t','e','\n',
'	','U','s','i','n','g',' ','t','h','e',' ','M','o','u','s','e','\n',
'	','K','e','y','b','o','a','r','d',' ','S','h','o','r','t','c','u','t','s','\n',
'	','S','h','i','f','t','i','n','g',' ','a','n','d',' ','F','i','l','l','i','n','g','\n',
'\n',
'P','r','o','g','r','a','m','m','e','r','s',' ','s','h','o','u','l','d',' ','a','l','s','o',' ','r','e','a','d',' ','t','h','e',' ','i','n','t','r','o','d','u','c','t','o','r','y',' ','s','e','c','t','i','o','n',' ','u','n','d','e','r',' ','t','h','e',' ',
'\"','F','e','a','t','u','r','e','s',' ','f','o','r',' ','P','r','o','g','r','a','m','m','i','n','g','\"',' ','s','e','c','t','i','o','n',':','\n',
'\n',
'	','P','r','o','g','r','a','m','m','i','n','g',' ','w','i','t','h',' ','N','E','d','i','t','\n',
'\n',
'I','f',' ','y','o','u',' ','g','e','t',' ','i','n','t','o',' ','t','r','o','u','b','l','e',',',' ','t','h','e',' ','U','n','d','o',' ','c','o','m','m','a','n','d',' ','i','n',' ','t','h','e',' ','E','d','i','t',' ','m','e','n','u',' ','c','a','n',' ','r','e','v','e','r','s','e',' ',
'a','n','y',' ','m','o','d','i','f','i','c','a','t','i','o','n','s',' ','t','h','a','t',' ','y','o','u',' ','m','a','k','e','.',' ',' ','N','E','d','i','t',' ','d','o','e','s',' ','n','o','t',' ','c','h','a','n','g','e',' ','t','h','e',' ','f','i','l','e',' ','y','o','u',' ','a','r','e',' ',
'e','d','i','t','i','n','g',' ','u','n','t','i','l',' ','y','o','u',' ','t','e','l','l',' ','i','t',' ','t','o',' ','S','a','v','e','.','\n',
'\n',
'E','d','i','t','i','n','g',' ','a','n',' ','E','x','i','s','t','i','n','g',' ','F','i','l','e','\n',
'\n',
'T','o',' ','o','p','e','n',' ','a','n',' ','e','x','i','s','t','i','n','g',' ','f','i','l','e',',',' ','c','h','o','o','s','e',' ','O','p','e','n','.','.','.',' ','f','r','o','m',' ','t','h','e',' ','f','i','l','e',' ','m','e','n','u','.',' ','S','e','l','e','c','t',' ','t','h','e',' ',
'f','i','l','e',' ','t','h','a','t',' ','y','o','u',' ','w','a','n','t',' ','t','o',' ','o','p','e','n',' ','i','n',' ','t','h','e',' ','p','o','p','-','u','p',' ','d','i','a','l','o','g',' ','t','h','a','t',' ','a','p','p','e','a','r','s',' ','a','n','d',' ','c','l','i','c','k',' ','o','n',' ',
'O','K','.',' ',' ','Y','o','u',' ','m','a','y',' ','o','p','e','n',' ','a','n','y',' ','n','u','m','b','e','r',' ','o','f',' ','f','i','l','e','s',' ','a','t',' ','t','h','e',' ','s','a','m','e',' ','t','i','m','e','.',' ',' ','E','a','c','h',' ','f','i','l','e',' ','w','i','l','l',' ',
'a','p','p','e','a','r',' ','i','n',' ','i','t','s',' ','o','w','n',' ','e','d','i','t','o','r',' ','w','i','n','d','o','w','.',' ',' ','U','s','i','n','g',' ','O','p','e','n','.','.','.',' ','r','a','t','h','e','r',' ','t','h','a','n',' ','r','e','-','t','y','p','i','n','g',' ','t','h','e',' ',
'N','E','d','i','t',' ','c','o','m','m','a','n','d',' ','a','n','d',' ','r','u','n','n','i','n','g',' ','a','d','d','i','t','i','o','n','a','l',' ','c','o','p','i','e','s',' ','o','f',' ','N','E','d','i','t',',',' ','w','i','l','l',' ','g','i','v','e',' ','y','o','u',' ','q','u','i','c','k',' ',
'a','c','c','e','s','s',' ','t','o',' ','a','l','l',' ','o','f',' ','t','h','e',' ','f','i','l','e','s',' ','y','o','u',' ','h','a','v','e',' ','o','p','e','n',' ','v','i','a',' ','t','h','e',' ','W','i','n','d','o','w','s',' ','m','e','n','u',',',' ','a','n','d',' ','e','n','s','u','r','e',' ',
't','h','a','t',' ','y','o','u',' ','d','o','n',''','t',' ','a','c','c','i','d','e','n','t','a','l','l','y',' ','o','p','e','n',' ','t','h','e',' ','s','a','m','e',' ','f','i','l','e',' ','t','w','i','c','e','.',' ',' ','N','E','d','i','t',' ','h','a','s',' ','n','o',' ',
'\"','m','a','i','n','\"',' ','w','i','n','d','o','w','.',' ',' ','I','t',' ','r','e','m','a','i','n','s',' ','r','u','n','n','i','n','g',' ','a','s',' ','l','o','n','g',' ','a','s',' ','a','t',' ','l','e','a','s','t',' ','o','n','e',' ','e','d','i','t','o','r',' ','w','i','n','d','o','w',' ',
'i','s',' ','o','p','e','n','.','\n',
'\n',
'C','r','e','a','t','i','n','g',' ','a',' ','N','e','w',' ','F','i','l','e','\n',
'\n',
'I','f',' ','y','o','u',' ','a','l','r','e','a','d','y',' ','h','a','v','e',' ','a','n',' ','e','m','p','t','y',' ','(','U','n','t','i','t','l','e','d',')',' ','w','i','n','d','o','w',' ','d','i','s','p','l','a','y','e','d',',',' ','j','u','s','t',' ','b','e','g','i','n',' ',
't','y','p','i','n','g',' ','i','n',' ','t','h','e',' ','w','i','n','d','o','w','.',' ',' ','T','o',' ','c','r','e','a','t','e',' ','a',' ','n','e','w',' ','U','n','t','i','t','l','e','d',' ','w','i','n','d','o','w',',',' ','c','h','o','o','s','e',' ','N','e','w',' ','f','r','o','m',' ',
't','h','e',' ','F','i','l','e',' ','m','e','n','u','.',' ',' ','T','o',' ','g','i','v','e',' ','t','h','e',' ','f','i','l','e',' ','a',' ','n','a','m','e',' ','a','n','d',' ','s','a','v','e',' ','i','t','s',' ','c','o','n','t','e','n','t','s',' ','t','o',' ','t','h','e',' ',
'd','i','s','k',',',' ','c','h','o','o','s','e',' ','S','a','v','e',' ','o','r',' ','S','a','v','e',' ','A','s','.','.','.',' ','f','r','o','m',' ','t','h','e',' ','F','i','l','e',' ','m','e','n','u','.','\n',
'\n',
'B','a','c','k','u','p',' ','F','i','l','e','s','\n',
'\n',
'N','E','d','i','t',' ','m','a','i','n','t','a','i','n','s',' ','p','e','r','i','o','d','i','c',' ','b','a','c','k','u','p','s',' ','o','f',' ','t','h','e',' ','f','i','l','e',' ','y','o','u',' ','a','r','e',' ','e','d','i','t','i','n','g',' ','s','o',' ','t','h','a','t',' ','y','o','u',' ',
'c','a','n',' ','r','e','c','o','v','e','r',' ','t','h','e',' ','f','i','l','e',' ','i','n',' ','t','h','e',' ','e','v','e','n','t',' ','o','f',' ','a',' ','p','r','o','b','l','e','m',' ','s','u','c','h',' ','a','s',' ','a',' ','s','y','s','t','e','m',' ','c','r','a','s','h',',',' ',
'n','e','t','w','o','r','k',' ','f','a','i','l','u','r','e',',',' ','o','r',' ','X',' ','s','e','r','v','e','r',' ','c','r','a','s','h','.',' ',' ','T','h','e','s','e',' ','f','i','l','e','s',' ','a','r','e',' ','s','a','v','e','d',' ','u','n','d','e','r',' ','t','h','e',' ','n','a','m','e',' ',
'~','f','i','l','e','n','a','m','e',' ','(','o','n',' ','U','n','i','x',')',' ','o','r',' ','_','f','i','l','e','n','a','m','e',' ','(','o','n',' ','V','M','S',')',',',' ','w','h','e','r','e',' ','f','i','l','e','n','a','m','e',' ','i','s',' ','t','h','e',' ','n','a','m','e',' ','o','f',' ',
't','h','e',' ','f','i','l','e',' ','y','o','u',' ','w','e','r','e',' ','e','d','i','t','i','n','g','.',' ',' ','I','f',' ','a','n',' ','N','E','d','i','t',' ','p','r','o','c','e','s','s',' ','i','s',' ','k','i','l','l','e','d',',',' ','s','o','m','e',' ','o','f',' ','t','h','e','s','e',' ',
'b','a','c','k','u','p',' ','f','i','l','e','s',' ','m','a','y',' ','r','e','m','a','i','n',' ','i','n',' ','y','o','u','r',' ','d','i','r','e','c','t','o','r','y','.',' ',' ','(','T','o',' ','r','e','m','o','v','e',' ','o','n','e',' ','o','f',' ','t','h','e','s','e',' ','f','i','l','e','s',' ',
'o','n',' ','U','n','i','x',',',' ','y','o','u',' ','m','a','y',' ','h','a','v','e',' ','t','o',' ','p','r','e','f','i','x',' ','t','h','e',' ','~',' ','(','t','i','l','d','e',')',' ','c','h','a','r','a','c','t','e','r',' ','w','i','t','h',' ','a',' ',
'(','b','a','c','k','s','l','a','s','h',')',' ','t','o',' ','p','r','e','v','e','n','t',' ','t','h','e',' ','s','h','e','l','l',' ','f','r','o','m',' ','i','n','t','e','r','p','r','e','t','i','n','g',' ','i','t',' ','a','s',' ','a',' ','s','p','e','c','i','a','l',' ',
'c','h','a','r','a','c','t','e','r','.',')','\n',
'\n',
'S','h','o','r','t','c','u','t','s','\n',
'\n',
'A','s',' ','y','o','u',' ','b','e','c','o','m','e',' ','m','o','r','e',' ','f','a','m','i','l','i','a','r',' ','w','i','t','h',' ','N','E','d','i','t',',',' ','s','u','b','s','t','i','t','u','t','e',' ','t','h','e',' ','c','o','n','t','r','o','l',' ','a','n','d',' ',
'f','u','n','c','t','i','o','n',' ','k','e','y','s',' ','s','h','o','w','n',' ','o','n',' ','t','h','e',' ','r','i','g','h','t',' ','s','i','d','e',' ','o','f',' ','t','h','e',' ','m','e','n','u','s',' ','f','o','r',' ','p','u','l','l','i','n','g',' ','d','o','w','n',' ','m','e','n','u','s',' ',
'w','i','t','h',' ','t','h','e',' ','m','o','u','s','e','.','\n',
'\n',
'D','i','a','l','o','g','s',' ','a','r','e',' ','a','l','s','o',' ','s','t','r','e','a','m','l','i','n','e','d',' ','s','o',' ','y','o','u',' ','c','a','n',' ','e','n','t','e','r',' ','i','n','f','o','r','m','a','t','i','o','n',' ','q','u','i','c','k','l','y',' ','a','n','d',' ',
'w','i','t','h','o','u','t',' ','u','s','i','n','g',' ','t','h','e',' ','m','o','u','s','e','*','.',' ',' ','T','o',' ','m','o','v','e',' ','t','h','e',' ','k','e','y','b','o','a','r','d',' ','f','o','c','u','s',' ','a','r','o','u','n','d',' ','a',' ','d','i','a','l','o','g',',',' ',
'u','s','e',' ','t','h','e',' ','t','a','b',' ','a','n','d',' ','a','r','r','o','w',' ','k','e','y','s','.',' ',' ','O','n','e',' ','o','f',' ','t','h','e',' ','b','u','t','t','o','n','s',' ','i','n',' ','a',' ','d','i','a','l','o','g',' ','i','s',' ','u','s','u','a','l','l','y',' ',
'd','r','a','w','n',' ','w','i','t','h',' ','a',' ','t','h','i','c','k',',',' ','i','n','d','e','n','t','e','d',',',' ','o','u','t','l','i','n','e','.',' ',' ','T','h','i','s',' ','b','u','t','t','o','n',' ','c','a','n',' ','b','e',' ','a','c','t','i','v','a','t','e','d',' ','b','y',' ',
'p','r','e','s','s','i','n','g',' ','r','e','t','u','r','n',' ','o','r',' ','e','n','t','e','r','.',' ',' ','T','h','e',' ','C','a','n','c','e','l',' ','o','r',' ','D','i','s','m','i','s','s',' ','b','u','t','t','o','n',' ','c','a','n',' ','b','e',' ','a','c','t','i','v','a','t','e','d',' ',
'b','y',' ','p','r','e','s','s','i','n','g',' ','e','s','c','a','p','e','.',' ',' ','F','o','r',' ','e','x','a','m','p','l','e',',',' ','t','o',' ','r','e','p','l','a','c','e',' ','t','h','e',' ','s','t','r','i','n','g',' ','\"','t','h','i','n','g','\"',' ','w','i','t','h',' ',
'\"','t','h','i','n','g','s','\"',' ','t','y','p','e',':','\n',
'\n',
' ',' ',' ',' ','<','c','t','r','l','-','r','>','t','h','i','n','g','<','t','a','b','>','t','h','i','n','g','s','<','r','e','t','u','r','n','>','\n',
'\n',
'T','o',' ','o','p','e','n',' ','a',' ','f','i','l','e',' ','n','a','m','e','d',' ','\"','w','h','o','l','e','_','e','a','r','t','h','.','c','\"',',',' ','t','y','p','e',':','\n',
'\n',
' ',' ',' ',' ','<','c','t','r','l','-','o','>','w','h','o','<','r','e','t','u','r','n','>','\n',
'\n',
'(','h','o','w',' ','m','u','c','h',' ','o','f',' ','t','h','e',' ','f','i','l','e','n','a','m','e',' ','y','o','u',' ','n','e','e','d',' ','t','o',' ','t','y','p','e',' ','d','e','p','e','n','d','s',' ','o','n',' ','t','h','e',' ','o','t','h','e','r',' ','f','i','l','e','s',' ','i','n',' ',
't','h','e',' ','d','i','r','e','c','t','o','r','y',')','.',' ',' ','S','e','e',' ','t','h','e',' ','s','e','c','t','i','o','n',' ','c','a','l','l','e','d',' ','K','e','y','b','o','a','r','d',' ','S','h','o','r','t','c','u','t','s',' ','f','o','r',' ','m','o','r','e',' ',
'd','e','t','a','i','l','s','.','\n',
'\n',
'*',' ','U','s','e','r','s',' ','w','h','o',' ','h','a','v','e',' ','s','e','t',' ','t','h','e','i','r',' ','k','e','y','b','o','a','r','d',' ','f','o','c','u','s',' ','m','o','d','e',' ','t','o',' ','\"','p','o','i','n','t','e','r','\"',' ','s','h','o','u','l','d',' ','s','e','t',' ',
'\"','P','o','p','u','p','s',' ','U','n','d','e','r',' ','P','o','i','n','t','e','r','\"',' ','i','n',' ','t','h','e',' ','D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s',' ','m','e','n','u',' ','t','o',' ','a','v','o','i','d',' ','t','h','e',' ',
'a','d','d','i','t','i','o','n','a','l',' ','s','t','e','p',' ','o','f',' ','m','o','v','i','n','g',' ','t','h','e',' ','m','o','u','s','e',' ','i','n','t','o',' ','t','h','e',' ','d','i','a','l','o','g','.','\0'};

static char AuxString2[] = {'T','h','e',' ','S','e','a','r','c','h',' ','m','e','n','u',' ','c','o','n','t','a','i','n','s',' ','a',' ','n','u','m','b','e','r',' ','o','f',' ','c','o','m','m','a','n','d','s',' ','f','o','r',' ','f','i','n','d','i','n','g',' ','a','n','d',' ','r','e','p','l','a','c','i','n','g',' ','t','e','x','t','.','\n',
'\n',
'T','h','e',' ','F','i','n','d','.','.','.',' ','a','n','d',' ','R','e','p','l','a','c','e','.','.','.',' ','c','o','m','m','a','n','d','s',' ','p','r','e','s','e','n','t',' ','d','i','a','l','o','g','s',' ','f','o','r',' ','e','n','t','e','r','i','n','g',' ','t','e','x','t',' ','f','o','r',' ',
's','e','a','r','c','h','i','n','g',' ','a','n','d',' ','r','e','p','l','a','c','i','n','g','.',' ',' ','T','h','e','s','e',' ','d','i','a','l','o','g','s',' ','a','l','s','o',' ','a','l','l','o','w',' ','y','o','u',' ','t','o',' ','c','h','o','o','s','e',' ','w','h','e','t','h','e','r',' ','y','o','u',' ',
'w','a','n','t',' ','t','h','e',' ','s','e','a','r','c','h',' ','t','o',' ','b','e',' ','s','e','n','s','i','t','i','v','e',' ','t','o',' ','u','p','p','e','r',' ','a','n','d',' ','l','o','w','e','r',' ','c','a','s','e',',',' ','o','r',' ','w','h','e','t','h','e','r',' ','t','o',' ','u','s','e',' ','t','h','e',' ',
's','t','a','n','d','a','r','d',' ','U','n','i','x',' ','p','a','t','t','e','r','n',' ','m','a','t','c','h','i','n','g',' ','c','h','a','r','a','c','t','e','r','s',' ','(','r','e','g','u','l','a','r',' ','e','x','p','r','e','s','s','i','o','n','s',')','.',' ',' ','S','e','a','r','c','h','e','s',' ',
'b','e','g','i','n',' ','a','t',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','t','e','x','t',' ','i','n','s','e','r','t','i','o','n',' ','p','o','s','i','t','i','o','n','.','\n',
'\n',
'F','i','n','d',' ','A','g','a','i','n',' ','a','n','d',' ','R','e','p','l','a','c','e',' ','A','g','a','i','n',' ','r','e','p','e','a','t',' ','t','h','e',' ','l','a','s','t',' ','f','i','n','d',' ','o','r',' ','r','e','p','l','a','c','e',' ','c','o','m','m','a','n','d',' ','w','i','t','h','o','u','t',' ',
'p','r','o','m','p','t','i','n','g',' ','f','o','r',' ','s','e','a','r','c','h',' ','s','t','r','i','n','g','s','.',' ',' ','T','o',' ','s','e','l','e','c','t','i','v','e','l','y',' ','r','e','p','l','a','c','e',' ','t','e','x','t',',',' ','u','s','e',' ','t','h','e',' ','t','w','o',' ',
'c','o','m','m','a','n','d','s',' ','i','n',' ','c','o','m','b','i','n','a','t','i','o','n',':',' ','F','i','n','d',' ','A','g','a','i','n',',',' ','t','h','e','n',' ','R','e','p','l','a','c','e',' ','A','g','a','i','n',' ','i','f',' ',
't','h','e',' ','h','i','g','h','l','i','g','h','t','e','d',' ','s','t','r','i','n','g',' ','s','h','o','u','l','d',' ','b','e',' ','r','e','p','l','a','c','e','d',',',' ','o','r',' ','F','i','n','d',' ','A','g','a','i','n',' ','a','g','a','i','n',' ','t','o',' ','g','o',' ','t','o',' ','t','h','e',' ',
'n','e','x','t',' ','s','t','r','i','n','g','.','\n',
'\n',
'F','i','n','d',' ','S','e','l','e','c','t','i','o','n',' ','s','e','a','r','c','h','e','s',' ','f','o','r',' ','t','h','e',' ','t','e','x','t',' ','c','o','n','t','a','i','n','e','d',' ','i','n',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','p','r','i','m','a','r','y',' ',
's','e','l','e','c','t','i','o','n',' ','(','s','e','e',' ','S','e','l','e','c','t','i','n','g',' ','T','e','x','t',')','.',' ',' ','T','h','e',' ','s','e','l','e','c','t','e','d',' ','t','e','x','t',' ','d','o','e','s',' ','n','o','t',' ','h','a','v','e',' ','t','o',' ',
'b','e',' ','i','n',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','e','d','i','t','o','r',' ','w','i','n','d','o','w',',',' ','i','t',' ','m','a','y',' ','e','v','e','n',' ','b','e',' ','i','n',' ','a','n','o','t','h','e','r',' ','p','r','o','g','r','a','m','.',' ',' ','F','o','r',' ',
'e','x','a','m','p','l','e',',',' ','i','f',' ','t','h','e',' ','w','o','r','d',' ','d','o','g',' ','a','p','p','e','a','r','s',' ','s','o','m','e','w','h','e','r','e',' ','i','n',' ','a',' ','w','i','n','d','o','w',' ','o','n',' ','y','o','u','r',' ','s','c','r','e','e','n',',',' ','a','n','d',' ',
'y','o','u',' ','w','a','n','t',' ','t','o',' ','f','i','n','d',' ','i','t',' ','i','n',' ','t','h','e',' ','f','i','l','e',' ','y','o','u',' ','a','r','e',' ','e','d','i','t','i','n','g',',',' ','s','e','l','e','c','t',' ','t','h','e',' ',
'w','o','r','d',' ','d','o','g',' ','b','y',' ','d','r','a','g','g','i','n','g',' ','t','h','e',' ','m','o','u','s','e',' ','a','c','r','o','s','s',' ','i','t',',',' ','s','w','i','t','c','h',' ','t','o',' ','y','o','u','r',' ','N','E','d','i','t',' ','w','i','n','d','o','w',' ','a','n','d',' ',
'c','h','o','o','s','e',' ','F','i','n','d',' ','S','e','l','e','c','t','i','o','n',' ','f','r','o','m',' ','t','h','e',' ','S','e','a','r','c','h',' ','m','e','n','u','.','\n',
'\n',
'S','e','a','r','c','h','i','n','g',' ','B','a','c','k','w','a','r','d','s','\n',
'\n',
'H','o','l','d','i','n','g',' ','d','o','w','n',' ','t','h','e',' ','s','h','i','f','t',' ','k','e','y',' ','w','h','i','l','e',' ','c','h','o','o','s','i','n','g',' ','a','n','y',' ','o','f',' ','t','h','e',' ','s','e','a','r','c','h',' ','o','r',' ','r','e','p','l','a','c','e',' ',
'c','o','m','m','a','n','d','s',' ','f','r','o','m',' ','t','h','e',' ','m','e','n','u',' ','(','o','r',' ','u','s','i','n','g',' ','t','h','e',' ','k','e','y','b','o','a','r','d',' ','s','h','o','r','t','c','u','t',')',',',' ','w','i','l','l',' ','s','e','a','r','c','h',' ','i','n',' ',
't','h','e',' ','r','e','v','e','r','s','e',' ','d','i','r','e','c','t','i','o','n','.',' ',' ','U','s','e','r','s',' ','w','h','o',' ','h','a','v','e',' ','s','e','t',' ','t','h','e',' ','s','e','a','r','c','h',' ','d','i','r','e','c','t','i','o','n',' ','u','s','i','n','g',' ',
't','h','e',' ','b','u','t','t','o','n','s',' ','i','n',' ','t','h','e',' ','s','e','a','r','c','h',' ','d','i','a','l','o','g',',',' ','m','a','y',' ','f','i','n','d',' ','i','t',' ','a',' ','b','i','t',' ','c','o','n','f','u','s','i','n','g',' ','t','h','a','t',' ','F','i','n','d',' ',
'A','g','a','i','n',' ','a','n','d',' ','R','e','p','l','a','c','e',' ','A','g','a','i','n',' ','d','o','n',''','t',' ','c','o','n','t','i','n','u','e',' ','i','n',' ','t','h','e',' ','s','a','m','e',' ','d','i','r','e','c','t','i','o','n',' ','a','s',' ','t','h','e',' ',
'o','r','i','g','i','n','a','l',' ','s','e','a','r','c','h',' ','(','f','o','r',' ','e','x','p','e','r','i','e','n','c','e','d',' ','u','s','e','r','s',',',' ','c','o','n','s','i','s','t','e','n','c','y',' ',
'o','f',' ','t','h','e',' ','d','i','r','e','c','t','i','o','n',' ','i','m','p','l','i','e','d',' ','b','y',' ','t','h','e',' ','s','h','i','f','t',' ','k','e','y',' ','i','s',' ','m','o','r','e',' ','i','m','p','o','r','t','a','n','t',')','.','\n',
'\n',
'S','e','l','e','c','t','i','v','e',' ','R','e','p','l','a','c','e','m','e','n','t','\n',
'\n',
'T','o',' ','r','e','p','l','a','c','e',' ','o','n','l','y',' ','s','o','m','e',' ','o','c','c','u','r','r','e','n','c','e','s',' ','o','f',' ','a',' ','s','t','r','i','n','g',' ','w','i','t','h','i','n',' ','a',' ','f','i','l','e',',',' ','c','h','o','o','s','e',' ','R','e','p','l','a','c','e','.','.','.',' ',
'f','r','o','m',' ','t','h','e',' ','S','e','a','r','c','h',' ','m','e','n','u',',',' ','e','n','t','e','r',' ','t','h','e',' ','s','t','r','i','n','g',' ','t','o',' ','s','e','a','r','c','h',' ','f','o','r',' ','a','n','d',' ','t','h','e',' ','s','t','r','i','n','g',' ','t','o',' ',
's','u','b','s','t','i','t','u','t','e',',',' ','a','n','d',' ','f','i','n','i','s','h',' ','b','y',' ','p','r','e','s','s','i','n','g',' ','t','h','e',' ','F','i','n','d',' ','b','u','t','t','o','n','.',' ',' ','W','h','e','n',' ','t','h','e',' ','f','i','r','s','t',' ',
'o','c','c','u','r','r','e','n','c','e',' ','i','s',' ','h','i','g','h','l','i','g','h','t','e','d',',',' ','u','s','e',' ','e','i','t','h','e','r',' ','R','e','p','l','a','c','e',' ','A','g','a','i','n',' ','(','^','T',')',' ','t','o',' ','r','e','p','l','a','c','e',' ','i','t',',',' ','o','r',' ',
'F','i','n','d',' ','A','g','a','i','n',' ','(','^','G',')',' ','t','o',' ','m','o','v','e',' ','t','o',' ','t','h','e',' ','n','e','x','t',' ','o','c','c','u','r','r','e','n','c','e',' ','w','i','t','h','o','u','t',' ','r','e','p','l','a','c','i','n','g',' ','i','t',',',' ','a','n','d',' ',
'c','o','n','t','i','n','u','e',' ','i','n',' ','s','u','c','h',' ','a',' ','m','a','n','n','e','r',' ','t','h','r','o','u','g','h',' ','a','l','l',' ','o','c','c','u','r','r','e','n','c','e','s',' ','o','f',' ','i','n','t','e','r','e','s','t','.','\n',
'\n',
'T','o',' ','r','e','p','l','a','c','e',' ','a','l','l',' ','o','c','c','u','r','r','e','n','c','e','s',' ','o','f',' ','a',' ','s','t','r','i','n','g',' ','w','i','t','h','i','n',' ','s','o','m','e',' ','r','a','n','g','e',' ','o','f',' ','t','e','x','t',',',' ',
's','e','l','e','c','t',' ','t','h','e',' ','r','a','n','g','e',' ','(','s','e','e',' ','S','e','l','e','c','t','i','n','g',' ','T','e','x','t',')',',',' ','c','h','o','o','s','e',' ','R','e','p','l','a','c','e','.','.','.',' ','f','r','o','m',' ','t','h','e',' ',
'S','e','a','r','c','h',' ','m','e','n','u',',',' ','t','y','p','e',' ','t','h','e',' ','s','t','r','i','n','g',' ','t','o',' ','s','e','a','r','c','h',' ','f','o','r',' ','a','n','d',' ','t','h','e',' ','s','t','r','i','n','g',' ','t','o',' ','s','u','b','s','t','i','t','u','t','e',',',' ','a','n','d',' ',
'p','r','e','s','s',' ','t','h','e',' ','\"','R','.',' ','i','n',' ','S','e','l','e','c','t','i','o','n','\"',' ','b','u','t','t','o','n',' ','i','n',' ','t','h','e',' ','d','i','a','l','o','g','.',' ',' ','N','o','t','e',' ','t','h','a','t',' ','s','e','l','e','c','t','i','n','g',' ','t','e','x','t',' ',
'i','n',' ','t','h','e',' ','R','e','p','l','a','c','e','.','.','.',' ','d','i','a','l','o','g',' ','w','i','l','l',' ','u','n','s','e','l','e','c','t',' ','t','h','e',' ','t','e','x','t',' ','i','n',' ','t','h','e',' ','w','i','n','d','o','w','.','\0'};

static char AuxString3[] = {'N','E','d','i','t',' ',
'h','a','s',' ','t','w','o',' ','g','e','n','e','r','a','l',' ','t','y','p','e','s',' ','o','f',' ','s','e','l','e','c','t','i','o','n','s',',',' ','p','r','i','m','a','r','y',' ','(','h','i','g','h','l','i','g','h','t','e','d',' ','t','e','x','t',')',',',' ','a','n','d',' ',
's','e','c','o','n','d','a','r','y',' ','(','u','n','d','e','r','l','i','n','e','d',' ','t','e','x','t',')','.',' ','S','e','l','e','c','t','i','o','n','s',' ','c','a','n',' ','c','o','v','e','r',' ','e','i','t','h','e','r',' ',
'a',' ','s','i','m','p','l','e',' ','r','a','n','g','e',' ','o','f',' ','t','e','x','t',' ','b','e','t','w','e','e','n',' ','t','w','o',' ','p','o','i','n','t','s',' ','i','n',' ','t','h','e',' ','f','i','l','e',',',' ','o','r',' ','t','h','e','y',' ','c','a','n',' ',
'c','o','v','e','r',' ','a',' ','r','e','c','t','a','n','g','u','l','a','r',' ','a','r','e','a',' ','o','f',' ','t','h','e',' ','f','i','l','e','.',' ',' ','R','e','c','t','a','n','g','u','l','a','r',' ','s','e','l','e','c','t','i','o','n','s',' ',
'a','r','e',' ','o','n','l','y',' ','u','s','e','f','u','l',' ','w','i','t','h',' ','n','o','n','-','p','r','o','p','o','r','t','i','o','n','a','l',' ','(','f','i','x','e','d',' ','s','p','a','c','i','n','g',')',' ','f','o','n','t','s','.','\n',
'\n',
'T','o',' ','s','e','l','e','c','t',' ','t','e','x','t',' ','f','o','r',' ','c','o','p','y','i','n','g',',',' ','d','e','l','e','t','i','n','g',',',' ','o','r',' ','r','e','p','l','a','c','i','n','g',',',' ','p','r','e','s','s',' ','t','h','e',' ','l','e','f','t',' ',
'm','o','u','s','e',' ','b','u','t','t','o','n',' ','w','i','t','h',' ','t','h','e',' ','p','o','i','n','t','e','r',' ','a','t',' ','o','n','e',' ','e','n','d',' ','o','f',' ','t','h','e',' ','t','e','x','t',' ','y','o','u',' ','w','a','n','t',' ','t','o',' ','s','e','l','e','c','t',',',' ',
'a','n','d',' ','d','r','a','g',' ','i','t',' ','t','o',' ','t','h','e',' ','o','t','h','e','r',' ','e','n','d','.',' ',' ','T','h','e',' ','t','e','x','t',' ','w','i','l','l',' ','b','e','c','o','m','e',' ','h','i','g','h','l','i','g','h','t','e','d','.',' ',' ','T','o',' ',
's','e','l','e','c','t',' ','a',' ','w','h','o','l','e',' ','w','o','r','d',',',' ','d','o','u','b','l','e',' ','c','l','i','c','k',' ','(','c','l','i','c','k',' ','t','w','i','c','e',' ','q','u','i','c','k','l','y',' ','i','n',' ','s','u','c','c','e','s','s','i','o','n',')','.',' ',' ',
'D','o','u','b','l','e',' ','c','l','i','c','k','i','n','g',' ','a','n','d',' ','t','h','e','n',' ','d','r','a','g','g','i','n','g',' ','t','h','e',' ','m','o','u','s','e',' ','w','i','l','l',' ','s','e','l','e','c','t',' ','a',' ','n','u','m','b','e','r',' ','o','f',' ','w','o','r','d','s','.',' ',' ',
'S','i','m','i','l','a','r','l','y',',',' ','y','o','u',' ','c','a','n',' ','s','e','l','e','c','t',' ',
'a',' ','w','h','o','l','e',' ','l','i','n','e',' ','o','r',' ','a',' ','n','u','m','b','e','r',' ','o','f',' ','l','i','n','e','s',' ','b','y',' ','t','r','i','p','l','e',' ','c','l','i','c','k','i','n','g',' ','o','r',' ','t','r','i','p','l','e',' ','c','l','i','c','k','i','n','g',' ','a','n','d',' ',
'd','r','a','g','g','i','n','g','.',' ',' ','Q','u','a','d','r','u','p','l','e',' ','c','l','i','c','k','i','n','g',' ','s','e','l','e','c','t','s',' ','t','h','e',' ','w','h','o','l','e',' ','f','i','l','e','.',' ',' ',
'A','f','t','e','r',' ','r','e','l','e','a','s','i','n','g',' ','t','h','e',' ','m','o','u','s','e',' ','b','u','t','t','o','n',',',' ','y','o','u',' ','c','a','n',' ','s','t','i','l','l',' ','a','d','j','u','s','t',' ','a',' ','s','e','l','e','c','t','i','o','n',' ',
'b','y',' ','h','o','l','d','i','n','g',' ','d','o','w','n',' ','t','h','e',' ','s','h','i','f','t',' ','k','e','y',' ','a','n','d',' ','d','r','a','g','g','i','n','g',' ','o','n',' ','e','i','t','h','e','r',' ','e','n','d',' ','o','f',' ','t','h','e',' ','s','e','l','e','c','t','i','o','n','.',' ',' ',
'T','o',' ','d','e','l','e','t','e',' ','t','h','e',' ','s','e','l','e','c','t','e','d',' ','t','e','x','t',',',' ','p','r','e','s','s',' ','d','e','l','e','t','e',' ','o','r',' ','b','a','c','k','s','p','a','c','e','.',' ',' ','T','o',' ','r','e','p','l','a','c','e',' ','i','t',',',' ',
'b','e','g','i','n',' ','t','y','p','i','n','g','.','\n',
'\n',
'T','o',' ','s','e','l','e','c','t',' ','a',' ','r','e','c','t','a','n','g','l','e',' ','o','r',' ','c','o','l','u','m','n',' ','o','f',' ','t','e','x','t',',',' ','h','o','l','d',' ','t','h','e',' ','C','t','r','l',' ','k','e','y',' ','w','h','i','l','e',' ','d','r','a','g','g','i','n','g',' ',
't','h','e',' ','m','o','u','s','e','.',' ',' ','R','e','c','t','a','n','g','u','l','a','r',' ','s','e','l','e','c','t','i','o','n','s',' ','c','a','n',' ','b','e',' ','u','s','e','d',' ','i','n',' ','a','n','y',' ','c','o','n','t','e','x','t',' ','t','h','a','t',' ',
'n','o','r','m','a','l',' ','s','e','l','e','c','t','i','o','n','s',' ','c','a','n',' ','b','e',' ','u','s','e','d',',',' ','i','n','c','l','u','d','i','n','g',' ','c','u','t','t','i','n','g',' ','a','n','d',' ','p','a','s','t','i','n','g',',',' ','f','i','l','l','i','n','g',',',' ',
's','h','i','f','t','i','n','g',',',' ','d','r','a','g','g','i','n','g',',',' ','a','n','d',' ','s','e','a','r','c','h','i','n','g','.',' ',' ','O','p','e','r','a','t','i','o','n','s',' ','o','n',' ','r','e','c','t','a','n','g','u','l','a','r',' ','s','e','l','e','c','t','i','o','n','s',' ',
'a','u','t','o','m','a','t','i','c','a','l','l','y',' ','f','i','l','l',' ','i','n',' ','t','a','b','s',' ','a','n','d',' ','s','p','a','c','e','s',' ','t','o',' ','m','a','i','n','t','a','i','n',' ','a','l','i','g','n','m','e','n','t',' ','o','f',' ','t','e','x','t',' ',
'w','i','t','h','i','n',' ','a','n','d',' ','t','o',' ','t','h','e',' ','r','i','g','h','t',' ','o','f',' ','t','h','e',' ','s','e','l','e','c','t','i','o','n','.',' ',' ','N','o','t','e',' ','t','h','a','t',' ','t','h','e',' ','i','n','t','e','r','p','r','e','t','a','t','i','o','n',' ',
'o','f',' ','r','e','c','t','a','n','g','u','l','a','r',' ','s','e','l','e','c','t','i','o','n','s',' ','b','y',' ','F','i','l','l',' ','P','a','r','a','g','r','a','p','h',' ','i','s',' ','s','l','i','g','h','t','l','y',' ','d','i','f','f','e','r','e','n','t',' ','f','r','o','m',' ','t','h','a','t',' ',
'o','f',' ','o','t','h','e','r',' ','c','o','m','m','a','n','d','s',',',' ','t','h','e',' ','s','e','c','t','i','o','n',' ','t','i','t','l','e','d',' ','\"','S','h','i','f','t','i','n','g',' ','a','n','d',' ','F','i','l','l','i','n','g','\"',' ','h','a','s',' ','d','e','t','a','i','l','s','.','\n',
'\n',
'T','h','e',' ','m','i','d','d','l','e',' ','m','o','u','s','e',' ','b','u','t','t','o','n',' ','c','a','n',' ','b','e',' ','u','s','e','d',' ','t','o',' ','m','a','k','e',' ','a','n',' ',
'a','d','d','i','t','i','o','n','a','l',' ','s','e','l','e','c','t','i','o','n',' ','(','c','a','l','l','e','d',' ','t','h','e',' ','s','e','c','o','n','d','a','r','y',' ','s','e','l','e','c','t','i','o','n',')','.',' ',' ','A','s',' ','s','o','o','n',' ','a','s',' ','t','h','e',' ',
'b','u','t','t','o','n',' ','i','s',' ','r','e','l','e','a','s','e','d',',',' ','t','h','e',' ','c','o','n','t','e','n','t','s',' ','o','f',' ','t','h','i','s',' ','s','e','l','e','c','t','i','o','n',' ','w','i','l','l',' ','b','e',' ',
'c','o','p','i','e','d',' ','t','o',' ','t','h','e',' ','i','n','s','e','r','t',' ','p','o','s','i','t','i','o','n',' ','o','f',' ','t','h','e',' ','w','i','n','d','o','w',' ','w','h','e','r','e',' ','t','h','e',' ','m','o','u','s','e',' ','w','a','s',' ','l','a','s','t',' ',
'c','l','i','c','k','e','d',' ','(','t','h','e',' ','d','e','s','t','i','n','a','t','i','o','n',' ','w','i','n','d','o','w',')','.',' ',' ','T','h','i','s',' ','p','o','s','i','t','i','o','n',' ','i','s',' ','m','a','r','k','e','d',' ','b','y',' ','a',' ','c','a','r','e','t',' ',
's','h','a','p','e','d',' ','c','u','r','s','o','r',' ','w','h','e','n',' ','t','h','e',' ',
'm','o','u','s','e',' ','i','s',' ','o','u','t','s','i','d','e',' ','o','f',' ','t','h','e',' ','d','e','s','t','i','n','a','t','i','o','n',' ','w','i','n','d','o','w','.',' ',' ',
'I','f',' ','t','h','e','r','e',' ','i','s',' ','a',' ','(','p','r','i','m','a','r','y',')',' ','s','e','l','e','c','t','i','o','n',',',' ','a','d','j','a','c','e','n','t',' ','t','o',' ','t','h','e',' ','c','u','r','s','o','r',' ',
'i','n',' ','t','h','e',' ','w','i','n','d','o','w',',',' ',
't','h','e',' ','n','e','w',' ','t','e','x','t',' ','w','i','l','l',' ','r','e','p','l','a','c','e',' ','t','h','e',' ','s','e','l','e','c','t','e','d',' ','t','e','x','t','.',' ',' ','H','o','l','d','i','n','g',' ','t','h','e',' ','s','h','i','f','t',' ','k','e','y',' ',
'w','h','i','l','e',' ','m','a','k','i','n','g',' ','t','h','e',' ','s','e','c','o','n','d','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','w','i','l','l',' ','m','o','v','e',' ','t','h','e',' ','t','e','x','t',',',' ','d','e','l','e','t','i','n','g',' ','i','t',' ',
'a','t',' ','t','h','e',' ','s','i','t','e',' ','o','f',' ','t','h','e',' ','s','e','c','o','n','d','a','r','y',' ','s','e','l','e','c','t','i','o','n',',',' ','r','a','t','h','e','r',' ','t','h','a','n',' ',
'c','o','p','y','i','n','g',' ','i','t','.','\n',
'\n',
'S','e','l','e','c','t','e','d',' ','t','e','x','t',' ','c','a','n',' ','a','l','s','o',' ','b','e',' ','d','r','a','g','g','e','d',' ','t','o',' ','a',' ','n','e','w',' ','l','o','c','a','t','i','o','n',' ','i','n',' ','t','h','e',' ','f','i','l','e',' ','u','s','i','n','g',' ','t','h','e',' ',
'm','i','d','d','l','e',' ','m','o','u','s','e',' ','b','u','t','t','o','n','.',' ',' ','H','o','l','d','i','n','g',' ','t','h','e',' ','s','h','i','f','t',' ','k','e','y',' ','w','h','i','l','e',' ',
'd','r','a','g','g','i','n','g',' ','t','h','e',' ','t','e','x','t',' ','w','i','l','l',' ','c','o','p','y',' ','t','h','e',' ','s','e','l','e','c','t','e','d',' ','t','e','x','t',',',' ','l','e','a','v','i','n','g',' ','t','h','e',' ','o','r','i','g','i','n','a','l',' ',
't','e','x','t',' ','i','n',' ','p','l','a','c','e','.',' ',' ','H','o','l','d','i','n','g',' ','t','h','e',' ','c','o','n','t','r','o','l',' ','k','e','y',' ','w','i','l','l',' ','d','r','a','g',' ','t','h','e',' ','t','e','x','t',' ','i','n',' ','o','v','e','r','l','a','y',' ',
'm','o','d','e','.','\n',
'\n',
'N','o','r','m','a','l','l','y',',',' ','d','r','a','g','g','i','n','g',' ','m','o','v','e','s',' ','t','e','x','t',' ','b','y',' ','r','e','m','o','v','i','n','g',' ','i','t',' ','f','r','o','m',' ','t','h','e',' ',
's','e','l','e','c','t','e','d',' ','p','o','s','i','t','i','o','n',' ','a','t',' ','t','h','e',' ','s','t','a','r','t',' ','o','f',' ','t','h','e',' ','d','r','a','g',',',' ','a','n','d',' ','i','n','s','e','r','t','i','n','g',' ','i','t',' ','a','t',' ','a',' ',
'n','e','w',' ','p','o','s','i','t','i','o','n',' ','r','e','l','a','t','i','v','e',' ','t','o',' ','t','o',' ','t','h','e',' ','m','o','u','s','e','.',' ',' ','D','r','a','g','g','i','n','g',' ','a',' ','b','l','o','c','k',' ','o','f',' ','t','e','x','t',' ',
'o','v','e','r',' ','e','x','i','s','t','i','n','g',' ','c','h','a','r','a','c','t','e','r','s',',',' ','d','i','s','p','l','a','c','e','s',' ','t','h','e',' ','c','h','a','r','a','c','t','e','r','s',' ','t','o',' ',
't','h','e',' ','e','n','d',' ','o','f',' ','t','h','e',' ','s','e','l','e','c','t','i','o','n','.',' ',' ','I','n',' ','o','v','e','r','l','a','y',' ','m','o','d','e',',',' ','c','h','a','r','a','c','t','e','r','s',' ','w','h','i','c','h',' ','a','r','e',' ',
'o','c','c','l','u','d','e','d',' ','b','y',' ','b','l','o','c','k','s',' ','o','f',' ','t','e','x','t',' ','b','e','i','n','g',' ','d','r','a','g','g','e','d',' ','a','r','e',' ','s','i','m','p','l','y',' ','r','e','m','o','v','e','d','.',' ',' ','W','h','e','n',' ',
'd','r','a','g','g','i','n','g',' ','n','o','n','-','r','e','c','t','a','n','g','u','l','a','r',' ','s','e','l','e','c','t','i','o','n','s',',',' ','o','v','e','r','l','a','y',' ','m','o','d','e',' ','a','l','s','o',' ','c','o','n','v','e','r','t','s',' ','t','h','e',' ',
's','e','l','e','c','t','i','o','n',' ','t','o',' ','r','e','c','t','a','n','g','u','l','a','r',' ','f','o','r','m',',',' ','a','l','l','o','w','i','n','g',' ','i','t',' ','t','o',' ','b','e',' ','d','r','a','g','g','e','d',' ','o','u','t','s','i','d','e',' ','o','f',' ',
't','h','e',' ','b','o','u','n','d','s',' ','o','f',' ','t','h','e',' ','e','x','i','s','t','i','n','g',' ','t','e','x','t','.','\n',
'\n',
'T','h','e',' ','s','e','c','t','i','o','n',' ','\"','U','s','i','n','g',' ','t','h','e',' ','M','o','u','s','e','\"',' ','s','u','m','a','r','i','z','e','s',' ','t','h','e',' ','m','o','u','s','e',' ','c','o','m','m','a','n','d','s',' ','f','o','r',' ','m','a','k','i','n','g',' ',
'p','r','i','m','a','r','y',' ','a','n','d',' ','s','e','c','o','n','d','a','r','y',' ','s','e','l','e','c','t','i','o','n','s','.',' ',' ','P','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n','s',' ','c','a','n',' ','a','l','s','o',' ','b','e',' ','m','a','d','e',' ',
'v','i','a',' ','k','e','y','b','o','a','r','d',' ','c','o','m','m','a','n','d','s',',',' ','s','e','e',' ','\"','K','e','y','b','o','a','r','d',' ','S','h','o','r','t','c','u','t','s','\"','.','\0'};

static char AuxString4[] = {'T','h','e',' ','e','a','s','i','e','s','t',' ','w','a','y',' ','t','o',' ','c','o','p','y',' ','a','n','d',' ','m','o','v','e',' ','t','e','x','t',' ','a','r','o','u','n','d',' ','i','n',' ','y','o','u','r',' ','f','i','l','e',' ','o','r',' ','b','e','t','w','e','e','n',' ',
'w','i','n','d','o','w','s',',',' ','i','s',' ','t','o',' ','u','s','e',' ','t','h','e',' ','c','l','i','p','b','o','a','r','d',',',' ','a','n',' ','i','m','a','g','i','n','a','r','y',' ','a','r','e','a',' ','t','h','a','t',' ','t','e','m','p','o','r','a','r','i','l','y',' ','s','t','o','r','e','s',' ',
't','e','x','t',' ','a','n','d',' ','d','a','t','a','.',' ',' ','T','h','e',' ','C','u','t',' ','c','o','m','m','a','n','d',' ','r','e','m','o','v','e','s',' ','t','h','e',' ',
's','e','l','e','c','t','e','d',' ','t','e','x','t',' ','(','s','e','e',' ','S','e','l','e','c','t','i','n','g',' ','T','e','x','t',')',' ','f','r','o','m',' ','y','o','u','r',' ','f','i','l','e',' ','a','n','d',' ','p','l','a','c','e','s',' ','i','t',' ','i','n',' ','t','h','e',' ',
'c','l','i','p','b','o','a','r','d','.',' ',' ','O','n','c','e',' ','t','e','x','t',' ','i','s',' ','i','n',' ',
't','h','e',' ','c','l','i','p','b','o','a','r','d',',',' ','t','h','e',' ','P','a','s','t','e',' ','c','o','m','m','a','n','d',' ','w','i','l','l',' ','c','o','p','y',' ','i','t',' ','t','o',' ','t','h','e',' ','i','n','s','e','r','t',' ','p','o','s','i','t','i','o','n',' ','i','n',' ','t','h','e',' ',
'c','u','r','r','e','n','t',' ','w','i','n','d','o','w','.',' ',' ','F','o','r',' ','e','x','a','m','p','l','e',',',' ','t','o',' ','m','o','v','e',' ','s','o','m','e',' ','t','e','x','t',' ','f','r','o','m',' ','o','n','e',' ','p','l','a','c','e',' ','t','o',' ','a','n','o','t','h','e','r',',',' ',
's','e','l','e','c','t',' ','i','t',' ','b','y',' ',
'd','r','a','g','g','i','n','g',' ','t','h','e',' ','m','o','u','s','e',' ','o','v','e','r',' ','i','t',',',' ','c','h','o','o','s','e',' ','C','u','t',' ','t','o',' ','r','e','m','o','v','e',' ','i','t',',',' ',
'c','l','i','c','k',' ','t','h','e',' ','p','o','i','n','t','e','r',' ','t','o',' ','m','o','v','e',' ','t','h','e',' ','i','n','s','e','r','t',' ','p','o','i','n','t',' ','w','h','e','r','e',' ','y','o','u',' ','w','a','n','t',' ','t','h','e',' ','t','e','x','t',' ','i','n','s','e','r','t','e','d',',',' ',
't','h','e','n',' ','c','h','o','o','s','e',' ','P','a','s','t','e',' ','t','o',' ','i','n','s','e','r','t',' ','i','t','.',' ',' ','C','o','p','y',' ','c','o','p','i','e','s',' ','t','e','x','t',' ','t','o',' ','t','h','e',' ','c','l','i','p','b','o','a','r','d',' ','w','i','t','h','o','u','t',' ',
'd','e','l','e','t','i','n','g',' ','i','t',' ','f','r','o','m',' ','y','o','u','r',' ','f','i','l','e','.',' ',' ','Y','o','u',' ','c','a','n',' ','a','l','s','o',' ','u','s','e',' ','t','h','e',' ','c','l','i','p','b','o','a','r','d',' ','t','o',' ','t','r','a','n','s','f','e','r',' ','t','e','x','t',' ',
't','o',' ','a','n','d',' ','f','r','o','m',' ','o','t','h','e','r',' ','M','o','t','i','f',' ','p','r','o','g','r','a','m','s',' ','a','n','d',' ','X',' ','p','r','o','g','r','a','m','s',' ','w','h','i','c','h',' ','m','a','k','e',' ','p','r','o','p','e','r',' ','u','s','e',' ','o','f',' ',
't','h','e',' ','c','l','i','p','b','o','a','r','d','.','\n',
'\n',
'T','h','e','r','e',' ','a','r','e',' ','m','a','n','y',' ','o','t','h','e','r',' ','m','e','t','h','o','d','s',' ','f','o','r',' ','c','o','p','y','i','n','g',' ','a','n','d',' ','m','o','v','i','n','g',' ','t','e','x','t',' ','w','i','t','h','i','n',' ',
'N','E','d','i','t',' ','w','i','n','d','o','w','s',' ','a','n','d',' ','b','e','t','w','e','e','n',' ','N','E','d','i','t',' ','a','n','d',' ','o','t','h','e','r',' ','p','r','o','g','r','a','m','s','.',' ',' ','T','h','e',' ','m','o','s','t',' ','c','o','m','m','o','n',' ',
's','u','c','h',' ','m','e','t','h','o','d',' ','i','s',' ','c','l','i','c','k','i','n','g',' ','t','h','e',' ','m','i','d','d','l','e',' ','m','o','u','s','e',' ','b','u','t','t','o','n',' ','t','o',' ','c','o','p','y',' ','t','h','e',' ','p','r','i','m','a','r','y',' ',
's','e','l','e','c','t','i','o','n',' ','(','t','o',' ','t','h','e',' ','c','l','i','c','k','e','d',' ','p','o','s','i','t','i','o','n',')','.',' ',' ','C','o','p','y','i','n','g',' ','t','h','e',' ','s','e','l','e','c','t','i','o','n',' ','b','y',' ','c','l','i','c','k','i','n','g',' ',
't','h','e',' ','m','i','d','d','l','e',' ','m','o','u','s','e',' ','b','u','t','t','o','n',' ','i','n',' ','m','a','n','y',' ','c','a','s','e','s',' ','i','s',' ','t','h','e',' ','o','n','l','y',' ','w','a','y',' ','t','o',' ','t','r','a','n','s','f','e','r',' ','d','a','t','a',' ',
't','o',' ','a','n','d',' ','f','r','o','m',' ','m','a','n','y',' ','X',' ','p','r','o','g','r','a','m','s','.',' ',' ','H','o','l','d','i','n','g',' ','t','h','e',' ','S','h','i','f','t',' ','k','e','y',' ','w','h','i','l','e',' ','c','l','i','c','k','i','n','g',' ','t','h','e',' ',
'm','i','d','d','l','e',' ','m','o','u','s','e',' ','b','u','t','t','o','n',' ','m','o','v','e','s',' ','t','h','e',' ','t','e','x','t',',',' ','d','e','l','e','t','i','n','g',' ','i','t',' ','f','r','o','m',' ','i','t','s',' ','o','r','i','g','i','n','a','l',' ',
'p','o','s','i','t','i','o','n',',',' ','r','a','t','h','e','r',' ','t','h','a','n',' ','c','o','p','y','i','n','g',' ','i','t','.',' ',' ','O','t','h','e','r',' ','m','e','t','h','o','d','s',' ','f','o','r',' ','t','r','a','n','s','f','e','r','r','i','n','g',' ','t','e','x','t',' ',
'i','n','c','l','u','d','e',' ','s','e','c','o','n','d','a','r','y',' ','s','e','l','e','c','t','i','o','n','s',',',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','d','r','a','g','g','i','n','g',',',' ','k','e','y','b','o','a','r','d','-','b','a','s','e','d',' ',
's','e','l','e','c','t','i','o','n',' ','c','o','p','y','i','n','g',',',' ','a','n','d',' ','d','r','a','g',' ','a','n','d',' ','d','r','o','p','.',' ',' ','T','h','e','s','e',' ','a','r','e',' ','d','e','s','c','r','i','b','e','d',' ','i','n',' ','d','e','t','a','i','l',' ','i','n',' ',
't','h','e',' ','s','e','c','t','i','o','n','s',':',' ','S','e','l','e','c','t','i','n','g',' ','T','e','x','t',',',' ','U','s','i','n','g',' ','t','h','e',' ','M','o','u','s','e',',',' ','a','n','d',' ','K','e','y','b','o','a','r','d',' ','S','h','o','r','t','c','u','t','s','.','\0'};


static char AuxString5[] = {'P','r','o','g','r','a','m','m','e','r','s',' ','w','h','o',' ','u','s','e',' ','s','t','r','u','c','t','u','r','e','d',' ','l','a','n','g','u','a','g','e','s',' ','u','s','u','a','l','l','y',' ','r','e','q','u','i','r','e',' ','s','o','m','e',' ','f','o','r','m',' ','o','f',' ',
'a','u','t','o','m','a','t','i','c',' ','i','n','d','e','n','t',',',' ','s','o',' ','t','h','a','t',' ','t','h','e','y',' ','d','o','n',''','t',' ','h','a','v','e',' ','t','o',' ','c','o','n','t','i','n','u','a','l','l','y',' ','r','e','-','t','y','p','e',' ','t','h','e',' ',
's','e','q','u','e','n','c','e','s',' ','o','f',' ','t','a','b','s',' ','a','n','d','/','o','r',' ','s','p','a','c','e','s',' ','n','e','e','d','e','d',' ','t','o',' ','m','a','i','n','t','a','i','n',' ','l','e','n','g','t','h','y',' ','r','u','n','n','i','n','g',' ','i','n','d','e','n','t','s','.',' ',' ',
'V','e','r','s','i','o','n',' ','5','.','0',' ','o','f',' ','N','E','d','i','t',' ','i','s',' ','t','h','e',' ','f','i','r','s','t',' ','r','e','l','e','a','s','e',' ','o','f',' ','N','E','d','i','t',' ','t','o',' ','o','f','f','e','r',' ','\"','s','m','a','r','t','\"',' ',
'i','n','d','e','n','t',',',' ','a','t',' ','l','e','a','s','t',' ','e','x','p','e','r','i','m','e','n','t','a','l','l','y',',',' ','i','n',' ','a','d','d','i','t','i','o','n',' ','t','o',' ','t','h','e',' ','t','r','a','d','i','t','i','o','n','a','l',' ','a','u','t','o','m','a','t','i','c',' ',
'i','n','d','e','n','t',' ','w','h','i','c','h',' ','s','i','m','p','l','y',' ','l','i','n','e','s',' ','u','p',' ','t','h','e',' ','c','u','r','s','o','r',' ','p','o','s','i','t','i','o','n',' ','w','i','t','h',' ','t','h','e',' ','p','r','e','v','i','o','u','s',' ','l','i','n','e','.','\n',
'\n',
'S','m','a','r','t',' ','I','n','d','e','n','t','\n',
'\n',
'S','m','a','r','t',' ','I','n','d','e','n','t',' ','i','n',' ','t','h','i','s',' ','r','e','l','e','a','s','e',' ','m','u','s','t',' ','s','t','i','l','l',' ','b','e',' ','c','o','n','s','i','d','e','r','e','d',' ','s','o','m','e','w','h','a','t',' ',
'e','x','p','e','r','i','m','e','n','t','a','l','.',' ',' ','S','m','a','r','t',' ','i','n','d','e','n','t',' ','m','a','c','r','o','s',' ','a','r','e',' ','o','n','l','y',' ','a','v','a','i','l','a','b','l','e',' ','b','y',' ','d','e','f','a','u','l','t',' ','f','o','r',' ','C',' ',
'a','n','d',' ','C','+','+',',',' ','a','n','d',' ','w','h','i','l','e',' ','t','h','e','s','e',' ','c','a','n',' ','e','a','s','i','l','y',' ','b','e',' ','c','o','n','f','i','g','u','r','e','d',' ','f','o','r',' ','d','i','f','f','e','r','e','n','t',' ','d','e','f','a','u','l','t',' ',
'i','n','d','e','n','t','a','t','i','o','n',' ','d','i','s','t','a','n','c','e','s',',',' ','t','h','e','y',' ','m','a','y',' ','n','o','t',' ','c','o','n','f','o','r','m',' ','t','o',' ','e','v','e','r','y','o','n','e',''','s',' ','e','x','a','c','t',' ','C',' ',
'p','r','o','g','r','a','m','m','i','n','g',' ','s','t','y','l','e','.',' ',' ','S','m','a','r','t',' ','i','n','d','e','n','t',' ','i','s',' ','p','r','o','g','r','a','m','m','e','d',' ','i','n',' ','t','e','r','m','s',' ','o','f',' ','m','a','c','r','o','s',' ','i','n',' ','t','h','e',' ',
'N','E','d','i','t',' ','m','a','c','r','o',' ','l','a','n','g','u','a','g','e',' ','w','h','i','c','h',' ','c','a','n',' ','b','e',' ','e','n','t','e','r','e','d',' ','i','n',':',' ','P','r','e','f','e','r','e','n','c','e','s',' ','-','>',' ','D','e','f','a','u','l','t',' ',
'S','e','t','t','i','n','g','s',' ','-','>',' ','I','n','d','e','n','t',' ','-','>',' ','P','r','o','g','r','a','m',' ','S','m','a','r','t',' ','I','n','d','e','n','t','.',' ',' ','H','o','o','k','s',' ','a','r','e',' ','p','r','o','v','i','d','e','d',' ','f','o','r',' ',
'i','n','t','e','r','v','e','n','i','n','g',' ','a','t',' ','t','h','e',' ','p','o','i','n','t',' ','t','h','a','t',' ','a',' ','n','e','w','l','i','n','e',' ','i','s',' ','e','n','t','e','r','e','d',',',' ','e','i','t','h','e','r',' ','v','i','a',' ','t','h','e',' ','u','s','e','r',' ',
'p','r','e','s','s','i','n','g',' ','t','h','e',' ','E','n','t','e','r',' ','k','e','y',',',' ','o','r',' ','t','h','r','o','u','g','h',' ','a','u','t','o','-','w','r','a','p','p','i','n','g',';',' ','a','n','d',' ','f','o','r',' ','a','r','b','i','t','r','a','r','y',' ',
't','y','p','e','-','i','n',' ','t','o',' ','a','c','t',' ','o','n',' ','s','p','e','c','i','f','i','c',' ','c','h','a','r','a','c','t','e','r','s',' ','t','y','p','e','d','.','\n',
'\n',
'T','o',' ','t','y','p','e',' ','a',' ','n','e','w','l','i','n','e',' ','c','h','a','r','a','c','t','e','r',' ','w','i','t','h','o','u','t',' ','i','n','v','o','k','i','n','g',' ','s','m','a','r','t','-','i','n','d','e','n','t',' ','w','h','e','n',' ','o','p','e','r','a','t','i','n','g',' ',
'i','n',' ','s','m','a','r','t','-','i','n','d','e','n','t',' ','m','o','d','e',',',' ','h','o','l','d',' ','t','h','e',' ','C','t','r','l',' ','k','e','y',' ','w','h','i','l','e',' ','p','r','e','s','s','i','n','g',' ','t','h','e',' ','R','e','t','u','r','n',' ','o','r',' ',
'E','n','t','e','r',' ','k','e','y','.','\n',
'\n',
'A','u','t','o','-','I','n','d','e','n','t','\n',
'\n',
'W','i','t','h',' ','I','n','d','e','n','t',' ','s','e','t',' ','t','o',' ','A','u','t','o',' ','(','t','h','e',' ','d','e','f','a','u','l','t',')',',',' ','N','E','d','i','t',' ','k','e','e','p','s',' ','a',' ','r','u','n','n','i','n','g',' ','i','n','d','e','n','t','.',' ',' ',
'W','h','e','n',' ','y','o','u',' ','p','r','e','s','s',' ','t','h','e',' ','R','e','t','u','r','n',' ','o','r',' ','E','n','t','e','r',' ','k','e','y',',',' ',
's','p','a','c','e','s',' ','a','n','d',' ','t','a','b','s',' ','a','r','e',' ','i','n','s','e','r','t','e','d',' ','t','o',' ','l','i','n','e',' ','u','p',' ','t','h','e',' ','i','n','s','e','r','t',' ','p','o','i','n','t',' ','u','n','d','e','r',' ','t','h','e',' ','s','t','a','r','t',' ','o','f',' ',
't','h','e',' ','p','r','e','v','i','o','u','s',' ','l','i','n','e','.',' ',' ','C','t','r','l','+','R','e','t','u','r','n',' ','i','n',' ','a','u','t','o','-','i','n','d','e','n','t',' ','m','o','d','e',' ','a','c','t','s',' ','l','i','k','e',' ','a',' ','n','o','r','m','a','l',' ',
'r','e','t','u','r','n',',',' ','W','i','t','h',' ','a','u','t','o','-','i','n','d','e','n','t',' ','t','u','r','n','e','d',' ','o','f','f',',',' ','C','t','r','l','+','R','e','t','u','r','n',' ','d','o','e','s',' ','i','n','d','e','n','t','a','t','i','o','n','.','\n',
'\n',
'B','l','o','c','k',' ','I','n','d','e','n','t','a','t','i','o','n',' ','A','d','j','u','s','t','m','e','n','t','\n',
'\n',
'T','h','e',' ','S','h','i','f','t',' ','L','e','f','t',' ','a','n','d',' ','S','h','i','f','t',' ','R','i','g','h','t',' ','c','o','m','m','a','n','d','s',' ','a','s',' ','w','e','l','l',' ','a','s',' ','r','e','c','t','a','n','g','u','l','a','r',' ','d','r','a','g','g','i','n','g',' ',
'c','a','n',' ','b','e',' ','u','s','e','d',' ','t','o',' ','a','d','j','u','s','t',' ','t','h','e',' ',
'i','n','d','e','n','t','a','t','i','o','n',' ','f','o','r',' ','s','e','v','e','r','a','l',' ','l','i','n','e','s',' ','a','t',' ','o','n','c','e','.',' ',' ','T','o',' ','s','h','i','f','t',' ','a',' ','b','l','o','c','k',' ','o','f',' ','t','e','x','t',' ','o','n','e',' ',
'c','h','a','r','a','c','t','e','r',' ',
't','o',' ','t','h','e',' ','r','i','g','h','t',',',' ','s','e','l','e','c','t',' ','t','h','e',' ','t','e','x','t',',',' ','t','h','e','n',' ','c','h','o','o','s','e',' ','S','h','i','f','t',' ','R','i','g','h','t',' ','f','r','o','m',' ','t','h','e',' ','E','d','i','t',' ','m','e','n','u','.',' ',' ',
'N','o','t','e',' ','t','h','a','t',' ','t','h','e',' ','a','c','c','e','l','e','r','a','t','o','r',' ','k','e','y','s',' ','f','o','r',' ','t','h','e','s','e',' ','m','e','n','u',' ','i','t','e','m','s',' ','a','r','e',' ','C','t','r','l','+','9',' ','a','n','d',' ','C','t','r','l','+','0',',',' ',
'w','h','i','c','h',' ','c','o','r','r','e','s','p','o','n','d',' ','t','o',' ',' ','t','h','e',' ','r','i','g','h','t',' ','a','n','d',' ','l','e','f','t',' ','p','a','r','e','n','t','h','e','s','i','s',' ','o','n',' ','m','o','s','t',' ','k','e','y','b','o','a','r','d','s','.',' ',' ',
'R','e','m','e','m','b','e','r',' ','t','h','e','m',' ','a','s',' ','a','d','j','u','s','t','i','n','g',' ','t','h','e',' ','t','e','x','t',' ','i','n',' ','t','h','e',' ','d','i','r','e','c','t','i','o','n',' ','p','o','i','n','t','e','d',' ','t','o',' ','b','y',' ','t','h','e',' ',
'p','a','r','e','n','t','h','e','s','i','s',' ','c','h','a','r','a','c','t','e','r','.',' ',' ','H','o','l','d','i','n','g',' ','t','h','e',' ','S','h','i','f','t',' ','k','e','y',' ','w','h','i','l','e',' ','s','e','l','e','c','t','i','n','g',' ','e','i','t','h','e','r',' ',
'S','h','i','f','t',' ','L','e','f','t',' ','o','r',' ','S','h','i','f','t',' ','R','i','g','h','t',' ','w','i','l','l',' ','s','h','i','f','t',' ','t','h','e',' ','t','e','x','t',' ','b','y',' ','o','n','e',' ','t','a','b',' ','s','t','o','p',' ','(','o','r',' ','b','y',' ','o','n','e',' ',
'e','m','u','l','a','t','e','d',' ','t','a','b',' ','s','t','o','p',' ','i','f',' ','t','a','b',' ','e','m','u','l','a','t','i','o','n',' ','i','s',' ','t','u','r','n','e','d',' ','o','n',')','.',' ',' ','T','h','e',' ','h','e','l','p',' ','s','e','c','t','i','o','n',' ',
'\"','S','h','i','f','t','i','n','g',' ','a','n','d',' ','F','i','l','l','i','n','g','\"',' ','u','n','d','e','r',' ','\"','B','a','s','i','c',' ','O','p','e','r','a','t','i','o','n','\"',' ','h','a','s',' ','d','e','t','a','i','l','s','.','\0'};


static char AuxString6[] = {'C','h','a','n','g','i','n','g',' ','t','h','e',' ','T','a','b',' ','D','i','s','t','a','n','c','e','\n',
'\n',
'T','a','b','s',' ','a','r','e',' ','i','m','p','o','r','t','a','n','t',' ','f','o','r',' ','p','r','o','g','r','a','m','m','i','n','g',' ','i','n',' ','l','a','n','g','u','a','g','e','s',' ','w','h','i','c','h',' ','u','s','e',' ','i','n','d','e','n','t','a','t','i','o','n',' ',
't','o',' ','s','h','o','w',' ','n','e','s','t','i','n','g',',',' ','a','s',' ','s','h','o','r','t','-','h','a','n','d',' ','f','o','r',' ','p','r','o','d','u','c','i','n','g',' ','w','h','i','t','e','-','s','p','a','c','e',' ','f','o','r',' ','l','e','a','d','i','n','g',' ',
'i','n','d','e','n','t','s','.',' ',' ','A','s',' ','a',' ','p','r','o','g','r','a','m','m','e','r',',',' ','y','o','u',' ','h','a','v','e',' ','t','o',' ','d','e','c','i','d','e',' ','h','o','w',' ','t','o',' ','u','s','e',' ','i','n','d','e','n','t','a','t','i','o','n',',',' ',
'a','n','d',' ','h','o','w',' ','o','r',' ','w','h','e','t','h','e','r',' ','t','a','b',' ','c','h','a','r','a','c','t','e','r','s',' ','m','a','p',' ','t','o',' ','y','o','u','r',' ','i','n','d','e','n','t','a','t','i','o','n',' ','s','c','h','e','m','e','.','\n',
'\n',
'I','d','e','a','l','l','y',',',' ','t','a','b',' ','c','h','a','r','a','c','t','e','r','s',' ','m','a','p',' ','d','i','r','e','c','t','l','y',' ','t','o',' ','t','h','e',' ','a','m','o','u','n','t',' ','o','f',' ','i','n','d','e','n','t',' ','t','h','a','t',' ','y','o','u',' ',
'u','s','e',' ','t','o',' ','d','i','s','t','i','n','g','u','i','s','h',' ','n','e','s','t','i','n','g',' ','l','e','v','e','l','s',' ','i','n',' ','y','o','u','r',' ','c','o','d','e','.',' ',' ','U','n','f','o','r','t','u','n','a','t','e','l','y',',',' ','t','h','e',' ',
'U','n','i','x',' ','s','t','a','n','d','a','r','d',' ','f','o','r',' ','i','n','t','e','r','p','r','e','t','a','t','i','o','n',' ','o','f',' ','t','a','b',' ','c','h','a','r','a','c','t','e','r','s',' ','i','s',' ','e','i','g','h','t',' ','c','h','a','r','a','c','t','e','r','s',' ',
'(','p','r','o','b','a','b','l','y',' ','d','a','t','i','n','g',' ','b','a','c','k',' ','t','o',' ','m','e','c','h','a','n','i','c','a','l',' ','c','a','p','a','b','i','l','i','t','i','e','s',' ','o','f',' ','t','h','e',' ','o','r','i','g','i','n','a','l',' ',
't','e','l','e','t','y','p','e',')',',',' ','w','h','i','c','h',' ','i','s',' ','u','s','u','a','l','l','y',' ','t','o','o',' ','c','o','a','r','s','e',' ','f','o','r',' ','a',' ','s','i','n','g','l','e',' ','i','n','d','e','n','t','.','\n',
'\n',
'M','o','s','t',' ','t','e','x','t',' ','e','d','i','t','o','r','s',',',' ','N','E','d','i','t',' ','i','n','c','l','u','d','e','d',',',' ','a','l','l','o','w',' ','y','o','u',' ','t','o',' ','c','h','a','n','g','e',' ','t','h','e',' ',
'i','n','t','e','r','p','r','e','t','a','t','i','o','n',' ','o','f',' ','t','h','e',' ','t','a','b',' ','c','h','a','r','a','c','t','e','r',',',' ','a','n','d',' ','m','a','n','y',' ','p','r','o','g','r','a','m','m','e','r','s',' ','t','a','k','e',' ',
'a','d','v','a','n','t','a','g','e',' ','o','f',' ','t','h','i','s',',',' ','a','n','d',' ','s','e','t',' ','t','h','e','i','r',' ','t','a','b','s',' ','t','o',' ','3',' ','o','r',' ','4',' ','c','h','a','r','a','c','t','e','r','s',' ','t','o',' ','m','a','t','c','h',' ',
't','h','e','i','r',' ','p','r','o','g','r','a','m','m','i','n','g',' ','s','t','y','l','e','.',' ',' ','I','n',' ','N','E','d','i','t',' ','y','o','u',' ','s','e','t',' ','t','h','e',' ','h','a','r','d','w','a','r','e',' ','t','a','b',' ','d','i','s','t','a','n','c','e',' ','i','n',' ',
'P','r','e','f','e','r','e','n','c','e','s',' ','-','>',' ','T','a','b','s','.','.','.',' ','f','o','r',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','w','i','n','d','o','w',',',' ','o','r',' ','P','r','e','f','e','r','e','n','c','e','s',' ','-','>',' ',
'D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s',' ','-','>',' ','T','a','b','s','.','.','.',' ','(','g','e','n','e','r','a','l',')',',',' ','o','r',' ','P','r','e','f','e','r','e','n','c','e','s',' ','-','>',' ','D','e','f','a','u','l','t',' ',
'S','e','t','t','i','n','g','s',' ','-','>',' ','L','a','n','g','u','a','g','e',' ','M','o','d','e','s','.','.','.',' ','(','l','a','n','g','u','a','g','e','-','s','p','e','c','i','f','i','c',')',' ','t','o',' ','c','h','a','n','g','e',' ','t','h','e',' ',
'd','e','f','a','u','l','t','s',' ','f','o','r',' ','f','u','t','u','r','e',' ','w','i','n','d','o','w','s','.','\n',
'\n',
'C','h','a','n','g','i','n','g',' ','t','h','e',' ','m','e','a','n','i','n','g',' ','o','f',' ','t','h','e',' ','t','a','b',' ','c','h','a','r','a','c','t','e','r',' ','m','a','k','e','s',' ','p','r','o','g','r','a','m','m','i','n','g',' ','m','u','c','h',' ','e','a','s','i','e','r',' ',
'w','h','i','l','e',' ','y','o','u',''','r','e',' ','i','n',' ','t','h','e',' ','e','d','i','t','o','r',',',' ','b','u','t',' ','c','a','n',' ','c','a','u','s','e',' ','y','o','u',' ','h','e','a','d','a','c','h','e','s',' ','o','u','t','s','i','d','e',' ','o','f',' ','t','h','e',' ',
'e','d','i','t','o','r',',',' ','b','e','c','a','u','s','e',' ','t','h','e','r','e',' ','i','s',' ','n','o',' ','w','a','y',' ','t','o',' ','p','a','s','s',' ','a','l','o','n','g',' ','t','h','e',' ','t','a','b',' ','s','e','t','t','i','n','g',' ','a','s',' ','p','a','r','t',' ',
'o','f',' ','a',' ','p','l','a','i','n','-','t','e','x','t',' ','f','i','l','e','.',' ',' ','A','l','l',' ','o','f',' ','t','h','e',' ','o','t','h','e','r',' ','t','o','o','l','s',' ','w','h','i','c','h',' ','d','i','s','p','l','a','y',',',' ','p','r','i','n','t',',',' ','a','n','d',' ',
'o','t','h','e','r','w','i','s','e',' ','p','r','o','c','e','s','s',' ','y','o','u','r',' ','s','o','u','r','c','e',' ','c','o','d','e',' ','h','a','v','e',' ','t','o',' ','b','e',' ','m','a','d','e',' ','a','w','a','r','e',' ','o','f',' ','h','o','w',' ','t','h','e',' ',
't','a','b','s',' ','a','r','e',' ','s','e','t',',',' ','a','n','d',' ','m','u','s','t',' ','b','e',' ','a','b','l','e',' ','t','o',' ','h','a','n','d','l','e',' ','t','h','e',' ','c','h','a','n','g','e','.',' ',' ','N','o','n','-','s','t','a','n','d','a','r','d',' ','t','a','b','s',' ',
'c','a','n',' ','a','l','s','o',' ','c','o','n','f','u','s','e',' ','o','t','h','e','r',' ','p','r','o','g','r','a','m','m','e','r','s',',',' ','o','r',' ','m','a','k','e',' ','e','d','i','t','i','n','g',' ','y','o','u','r',' ','c','o','d','e',' ','d','i','f','f','i','c','u','l','t',' ',
'f','o','r',' ','t','h','e','m',' ','i','f',' ','t','h','e','i','r',' ','t','e','x','t',' ','e','d','i','t','o','r','s',' ','d','o','n',''','t',' ','s','u','p','p','o','r','t',' ','c','h','a','n','g','e','s',' ','i','n',' ','t','a','b',' ','d','i','s','t','a','n','c','e','.','\n',
'\n',
'E','m','u','l','a','t','e','d',' ','T','a','b','s','\n',
'\n',
'A','n',' ','a','l','t','e','r','n','a','t','i','v','e',' ','t','o',' ','c','h','a','n','g','i','n','g',' ','t','h','e',' ','i','n','t','e','r','p','r','e','t','a','t','i','o','n',' ','o','f',' ','t','h','e',' ','t','a','b',' ','c','h','a','r','a','c','t','e','r',' ','i','s',' ',
't','a','b',' ','e','m','u','l','a','t','i','o','n','.',' ',' ','I','n',' ','t','h','e',' ','T','a','b','s','.','.','.',' ','d','i','a','l','o','g','(','s',')',',',' ','t','u','r','n','i','n','g',' ','o','n',' ','E','m','u','l','a','t','e','d',' ','T','a','b','s',' ',
'c','a','u','s','e','s',' ','t','h','e',' ','T','a','b',' ','k','e','y',' ','t','o',' ','i','n','s','e','r','t',' ','t','h','e',' ','c','o','r','r','e','c','t',' ','n','u','m','b','e','r',' ','o','f',' ','s','p','a','c','e','s',' ','a','n','d','/','o','r',' ','t','a','b','s',' ',
't','o',' ','b','r','i','n','g',' ','t','h','e',' ','c','u','r','s','o','r',' ','t','h','e',' ','n','e','x','t',' ','e','m','u','l','a','t','e','d',' ','t','a','b',' ','s','t','o','p',',',' ','a','s',' ','i','f',' ','t','a','b','s',' ','w','e','r','e',' ','s','e','t',' ','a','t',' ',
't','h','e',' ','e','m','u','l','a','t','e','d',' ','t','a','b',' ','d','i','s','t','a','n','c','e',' ','r','a','t','h','e','r',' ','t','h','a','n',' ','t','h','e',' ','h','a','r','d','w','a','r','e',' ','t','a','b',' ','d','i','s','t','a','n','c','e','.',' ',
'B','a','c','k','s','p','a','c','i','n','g',' ','i','m','m','e','d','i','a','t','e','l','y',' ','a','f','t','e','r',' ','e','n','t','e','r','i','n','g',' ','a','n',' ','e','m','u','l','a','t','e','d',' ','t','a','b',' ','w','i','l','l',' ','d','e','l','e','t','e',' ','t','h','e',' ',
'f','i','c','t','i','t','i','o','u','s',' ','t','a','b',' ','a','s',' ','a',' ','u','n','i','t',',',' ','b','u','t',' ','a','s',' ','s','o','o','n',' ','a','s',' ','y','o','u',' ','m','o','v','e',' ','t','h','e',' ','c','u','r','s','o','r',' ','a','w','a','y',' ','f','r','o','m',' ',
't','h','e',' ','s','p','o','t',',',' ','N','E','d','i','t',' ','w','i','l','l',' ','f','o','r','g','e','t',' ','t','h','a','t',' ','t','h','e',' ','c','o','l','l','e','c','t','i','o','n',' ','o','f',' ','s','p','a','c','e','s',' ','a','n','d',' ','t','a','b','s',' ','i','s',' ','a',' ',
't','a','b',',',' ','a','n','d',' ','w','i','l','l',' ','t','r','e','a','t',' ','i','t',' ','a','s',' ','s','e','p','a','r','a','t','e',' ','c','h','a','r','a','c','t','e','r','s','.',' ',' ','T','o',' ','e','n','t','e','r',' ','a',' ','r','e','a','l',' ','t','a','b',' ',
'c','h','a','r','a','c','t','e','r',' ','w','i','t','h',' ','\"','E','m','u','l','a','t','e',' ','T','a','b','s','\"',' ','t','u','r','n','e','d',' ','o','n',',',' ','u','s','e',' ','C','t','r','l','+','T','a','b','.','\n',
'\n',
'I','t',' ','i','s',' ','a','l','s','o',' ','p','o','s','s','i','b','l','e',' ','t','o',' ','t','e','l','l',' ','N','E','d','i','t',' ','n','o','t',' ','t','o',' ','i','n','s','e','r','t',' ','A','N','Y',' ','t','a','b',' ','c','h','a','r','a','c','t','e','r','s',' ','a','t',' ',
'a','l','l',' ','i','n',' ','t','h','e',' ','c','o','u','r','s','e',' ','o','f',' ','p','r','o','c','e','s','s','i','n','g',' ','e','m','u','l','a','t','e','d',' ','t','a','b','s',',',' ','a','n','d',' ','i','n',' ','s','h','i','f','t','i','n','g',' ','a','n','d',' ',
'r','e','c','t','a','n','g','u','l','a','r',' ','i','n','s','e','r','t','i','o','n','/','d','e','l','e','t','i','o','n',' ','o','p','e','r','a','t','i','o','n','s',',',' ','f','o','r',' ','p','r','o','g','r','a','m','m','e','r','s',' ','w','h','o',' ','w','o','r','r','y',' ',
'a','b','o','u','t',' ','t','h','e',' ','m','i','s','i','n','t','e','r','p','r','e','t','a','t','i','o','n',' ','o','f',' ','t','a','b',' ','c','h','a','r','a','c','t','e','r','s',' ','o','n',' ','o','t','h','e','r',' ','s','y','s','t','e','m','s','.','\0'};

static char AuxString7[] = {'T','h','o','u','g','h',' ','g','e','n','e','r','a','l',' ','i','n',' ','a','p','p','e','a','r','a','n','c','e',',',' ','N','E','d','i','t',' ','h','a','s',' ','m','a','n','y',' ',
'f','e','a','t','u','r','e','s',' ','i','n','t','e','n','d','e','d',' ','s','p','e','c','i','f','i','c','a','l','l','y',' ','f','o','r',' ','p','r','o','g','r','a','m','m','e','r','s','.',' ',' ','M','a','j','o','r',' ',
'p','r','o','g','r','a','m','m','i','n','g','-','r','e','l','a','t','e','d',' ','t','o','p','i','c','s',' ','a','r','e',' ','l','i','s','t','e','d',' ','i','n',' ','s','e','p','a','r','a','t','e',' ','s','e','c','t','i','o','n','s',' ','u','n','d','e','r',' ','t','h','e',' ','h','e','a','d','i','n','g',':',' ',
'\"','F','e','a','t','u','r','e','s',' ','f','o','r',' ','P','r','o','g','r','a','m','m','i','n','g','\"',':',' ','S','y','n','t','a','x',' ','H','i','g','h','l','i','g','h','t','i','n','g',',',' ',
'T','a','b','s',' ','a','n','d',' ','T','a','b',' ','E','m','u','l','a','t','i','o','n',',',' ','c','t','a','g','s',' ','s','u','p','p','o','r','t',',',' ','a','n','d',' ','A','u','t','o','m','a','t','i','c',' ','I','n','d','e','n','t','.',' ',' ','M','i','n','o','r',' ','t','o','p','i','c','s',' ',
'r','e','l','a','t','e','d',' ','t','o',' ','p','r','o','g','r','a','m','m','i','n','g',' ','a','r','e',' ','d','i','s','c','u','s','s','e','d',' ','b','e','l','o','w',':','\n',
'\n',
'L','a','n','g','u','a','g','e',' ','M','o','d','e','s','\n',
'\n',
'W','h','e','n',' ','n','e','d','i','t',' ','i','n','i','t','i','a','l','l','y',' ','r','e','a','d','s',' ','a',' ','f','i','l','e',',',' ','i','t',' ','a','t','t','e','m','p','t','s',' ','t','o',' ','d','e','t','e','r','m','i','n','e',' ','w','h','e','t','h','e','r',' ','t','h','e',' ',
'f','i','l','e',' ','i','s',' ','i','n',' ','o','n','e',' ','o','f',' ','t','h','e',' ','c','o','m','p','u','t','e','r',' ','l','a','n','g','u','a','g','e','s',' ','t','h','a','t',' ','i','t',' ','k','n','o','w','s',' ','a','b','o','u','t','.',' ',' ','K','n','o','w','i','n','g',' ',
'w','h','a','t',' ','l','a','n','g','u','a','g','e',' ','a',' ','f','i','l','e',' ','i','s',' ','w','r','i','t','t','e','n',' ','i','n',' ','a','l','l','o','w','s',' ','N','E','d','i','t',' ','t','o',' ','a','s','s','i','g','n',' ','h','i','g','h','l','i','g','h','t',' ',
'p','a','t','t','e','r','n','s',' ','a','n','d',' ','s','m','a','r','t',' ','i','n','d','e','n','t',' ','m','a','c','r','o','s',',',' ','a','n','d',' ','t','o',' ','s','e','t',' ','l','a','n','g','u','a','g','e',' ','s','p','e','c','i','f','i','c',' ',
'p','r','e','f','e','r','e','n','c','e','s',' ','l','i','k','e',' ','w','o','r','d',' ','d','e','l','i','m','i','t','e','r','s',',',' ','t','a','b',' ','e','m','u','l','a','t','i','o','n',',',' ','a','n','d',' ','a','u','t','o','-','i','n','d','e','n','t','.',' ',' ',
'L','a','n','g','u','a','g','e',' ','m','o','d','e',' ','c','a','n',' ','b','e',' ','r','e','c','o','g','n','i','z','e','d',' ','f','r','o','m',' ','b','o','t','h',' ','t','h','e',' ','f','i','l','e',' ','n','a','m','e',' ','a','n','d',' ','f','r','o','m',' ','t','h','e',' ',
'f','i','r','s','t',' ','2','0','0',' ','c','h','a','r','a','c','t','e','r','s',' ','o','f',' ','c','o','n','t','e','n','t','.',' ',' ','L','a','n','g','u','a','g','e',' ','m','o','d','e',' ','r','e','c','o','g','n','i','t','i','o','n',' ','a','n','d',' ',
'l','a','n','g','u','a','g','e','-','s','p','e','c','i','f','i','c',' ','p','r','e','f','e','r','e','n','c','e','s',' ','a','r','e',' ','c','o','n','f','i','g','u','r','e','d',' ',
'i','n',':',' ','P','r','e','f','e','r','e','n','c','e','s',' ','-','>',' ','D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s',' ','-','>',' ','L','a','n','g','u','a','g','e',' ','M','o','d','e','s','.','.','.','.','\n',
'\n',
'Y','o','u',' ','c','a','n',' ','s','e','t',' ','t','h','e',' ','l','a','n','g','u','a','g','e',' ','m','o','d','e',' ','m','a','n','u','a','l','l','y',' ','f','o','r',' ','a',' ','w','i','n','d','o','w',',',' ','b','y',' ','s','e','l','e','c','t','i','n','g',' ',
'i','t',' ','f','r','o','m',' ','t','h','e',' ','m','e','n','u',':',' ','P','r','e','f','e','r','e','n','c','e','s',' ','-','>',' ','L','a','n','g','u','a','g','e',' ','M','o','d','e','s','.','\n',
'\n',
'L','i','n','e',' ','N','u','m','b','e','r','s','\n',
'\n',
'T','o',' ','f','i','n','d',' ','a',' ','p','a','r','t','i','c','u','l','a','r',' ','l','i','n','e',' ','i','n',' ','a',' ','s','o','u','r','c','e',' ','f','i','l','e',' ','b','y',' ','l','i','n','e',' ','n','u','m','b','e','r',',',' ','c','h','o','o','s','e',' ','G','o','t','o',' ',
'L','i','n','e',' ','#','.','.','.',' ','f','r','o','m',' ','t','h','e',' ','S','e','a','r','c','h',' ','m','e','n','u','.',' ',' ','Y','o','u',' ','c','a','n',' ','a','l','s','o',' ','d','i','r','e','c','t','l','y',' ','s','e','l','e','c','t',' ','t','h','e',' ','l','i','n','e',' ',
'n','u','m','b','e','r',' ','t','e','x','t',' ','i','n',' ','t','h','e',' ','c','o','m','p','i','l','e','r',' ','m','e','s','s','a','g','e',' ','i','n',' ','t','h','e',' ','t','e','r','m','i','n','a','l',' ','e','m','u','l','a','t','o','r',' ','w','i','n','d','o','w',' ',
'(','x','t','e','r','m',',',' ','d','e','c','t','e','r','m',',',' ','w','i','n','t','e','r','m',',',' ','e','t','c','.',')',' ','w','h','e','r','e',' ','y','o','u',' ','r','a','n',' ','t','h','e',' ','c','o','m','p','i','l','e','r',',',' ','a','n','d',' ','c','h','o','o','s','e',' ',
'G','o','t','o',' ','S','e','l','e','c','t','e','d',' ','f','r','o','m',' ','t','h','e',' ','S','e','a','r','c','h',' ','m','e','n','u','.','\n',
'\n',
'T','o',' ','f','i','n','d',' ','o','u','t',' ','t','h','e',' ','l','i','n','e',' ','n','u','m','b','e','r',' ','o','f',' ','a',' ','p','a','r','t','i','c','u','l','a','r',' ','l','i','n','e',' ','i','n',' ','y','o','u','r',' ','f','i','l','e',',',' ','t','u','r','n',' ','o','n',' ',
'S','t','a','t','i','s','t','i','c','s',' ','L','i','n','e',' ','i','n',' ','t','h','e',' ','P','r','e','f','e','r','e','n','c','e','s',' ','m','e','n','u',' ','a','n','d',' ','p','o','s','i','t','i','o','n',' ','t','h','e',' ','i','n','s','e','r','t','i','o','n',' ','p','o','i','n','t',' ',
'a','n','y','w','h','e','r','e',' ','o','n',' ','t','h','e',' ','l','i','n','e','.',' ',' ','T','h','e',' ','s','t','a','t','i','s','t','i','c','s',' ','l','i','n','e',' ','c','o','n','t','i','n','u','o','u','s','l','y',' ','u','p','d','a','t','e','s',' ','t','h','e',' ','l','i','n','e',' ',
'n','u','m','b','e','r',' ','o','f',' ','t','h','e',' ','l','i','n','e',' ','c','o','n','t','a','i','n','i','n','g',' ','t','h','e',' ','c','u','r','s','o','r','.','\n',
'\n',
'M','a','t','c','h','i','n','g',' ','P','a','r','e','n','t','h','e','s','e','s','\n',
'\n',
'T','o',' ','h','e','l','p',' ','y','o','u',' ','i','n','s','p','e','c','t',' ','n','e','s','t','e','d',' ','p','a','r','e','n','t','h','e','s','e','s',',',' ','b','r','a','c','k','e','t','s',',',' ','b','r','a','c','e','s',',',' ','q','u','o','t','e','s',',',' ','a','n','d',' ','o','t','h','e','r',' ',
'c','h','a','r','a','c','t','e','r','s',',',' ','N','E','d','i','t',' ','h','a','s',' ','b','o','t','h',' ','a','n',' ','a','u','t','o','m','a','t','i','c',' ','p','a','r','e','n','t','h','e','s','i','s',' ','m','a','t','c','h','i','n','g',' ','m','o','d','e',',',' ','a','n','d',' ','a',' ',
'F','i','n','d',' ','M','a','t','c','h','i','n','g',' ','c','o','m','m','a','n','d','.',' ',' ','A','u','t','o','m','a','t','i','c',' ','p','a','r','e','n','t','h','e','s','i','s',' ','m','a','t','c','h','i','n','g',' ','i','s',' ','a','c','t','i','v','a','t','e','d',' ','w','h','e','n',' ',
'y','o','u',' ','t','y','p','e',',',' ','o','r',' ','m','o','v','e',' ','t','h','e',' ','i','n','s','e','r','t','i','o','n',' ','c','u','r','s','o','r',' ','a','f','t','e','r',' ','a',' ','p','a','r','e','n','t','h','e','s','i','s',',',' ','b','r','a','c','k','e','t',',',' ','o','r',' ',
'b','r','a','c','e','.',' ',' ','I','t',' ','m','o','m','e','n','t','a','r','i','l','y',' ','h','i','g','h','l','i','g','h','t','s',' ','t','h','e',' ','m','a','t','c','h','i','n','g',' ','c','h','a','r','a','c','t','e','r',' ','i','f',' ','t','h','a','t',' ','c','h','a','r','a','c','t','e','r',' ',
'i','s',' ','v','i','s','i','b','l','e',' ','i','n',' ','t','h','e',' ','w','i','n','d','o','w','.',' ',' ','T','o',' ','f','i','n','d',' ','a',' ','m','a','t','c','h','i','n','g',' ','c','h','a','r','a','c','t','e','r',' ','a','n','y','w','h','e','r','e',' ','i','n',' ',
't','h','e',' ','f','i','l','e',',',' ','s','e','l','e','c','t',' ','i','t',' ','o','r',' ','p','o','s','i','t','i','o','n',' ','t','h','e',' ','c','u','r','s','o','r',' ','a','f','t','e','r',' ','i','t',',',' ','a','n','d',' ','c','h','o','o','s','e',' ','F','i','n','d',' ',
'M','a','t','c','h','i','n','g',' ','f','r','o','m',' ','t','h','e',' ','S','e','a','r','c','h',' ','m','e','n','u','.',' ',' ','I','f',' ',
't','h','e',' ','c','h','a','r','a','c','t','e','r',' ','m','a','t','c','h','e','s',' ','i','t','s','e','l','f',',',' ','s','u','c','h',' ','a','s',' ','a',' ','q','u','o','t','e',' ','o','r',' ','s','l','a','s','h',',',' ','s','e','l','e','c','t',' ','t','h','e',' ','f','i','r','s','t',' ',
'c','h','a','r','a','c','t','e','r',' ','o','f',' ','t','h','e',' ','p','a','i','r','.',' ',' ','N','E','d','i','t',' ','w','i','l','l',' ','m','a','t','c','h',' ','{',',',' ','(',',',' ','[',',',' ','<',',',' ','\"',',',' ','\'',',',' ','`',',',' ','/',',',' ','a','n','d',' ','\\','.','\n',
'\n',
'O','p','e','n','i','n','g',' ','I','n','c','l','u','d','e','d',' ','F','i','l','e','s','\n',
'\n',
'T','h','e',' ','O','p','e','n',' ','S','e','l','e','c','t','e','d',' ','c','o','m','m','a','n','d',' ','i','n',' ','t','h','e',' ','F','i','l','e',' ','m','e','n','u',' ','u','n','d','e','r','s','t','a','n','d','s',' ','t','h','e',' ','C',' ',
'p','r','e','p','r','o','c','e','s','s','o','r',''','s',' ','#','i','n','c','l','u','d','e',' ',
's','y','n','t','a','x',',',' ','s','o',' ','s','e','l','e','c','t','i','n','g',' ','a','n',' ','#','i','n','c','l','u','d','e',' ','l','i','n','e',' ','a','n','d',' ','i','n','v','o','k','i','n','g',' ','O','p','e','n',' ','S','e','l','e','c','t','e','d',' ','w','i','l','l',' ',
'g','e','n','e','r','a','l','l','y',' ','f','i','n','d',' ','t','h','e',' ','f','i','l','e',' ','r','e','f','e','r','r','e','d',' ','t','o',',',' ','u','n','l','e','s','s',' ','d','o','i','n','g',' ','s','o',' ','d','e','p','e','n','d','s',' ','o','n',' ','t','h','e',' ',
's','e','t','t','i','n','g','s',' ','o','f',' ','c','o','m','p','i','l','e','r',' ','s','w','i','t','c','h','e','s',' ','o','r',' ','o','t','h','e','r',' ','i','n','f','o','r','m','a','t','i','o','n',' ','n','o','t',' ','a','v','a','i','l','a','b','l','e',' ','t','o',' ','N','E','d','i','t','.','\n',
'\n',
'I','n','t','e','r','f','a','c','e',' ','t','o',' ','P','r','o','g','r','a','m','m','i','n','g',' ','T','o','o','l','s','\n',
'\n',
'I','n','t','e','g','r','a','t','e','d',' ','s','o','f','t','w','a','r','e',' ','d','e','v','e','l','o','p','m','e','n','t',' ','e','n','v','i','r','o','n','m','e','n','t','s',' ','s','u','c','h',' ','a','s',' ','S','G','I',''','s',' ','C','a','s','e','V','i','s','i','o','n',' ','a','n','d',' ',
'C','e','n','t','e','r','l','i','n','e',' ','S','o','f','t','w','a','r','e',''','s',' ','C','o','d','e',' ','C','e','n','t','e','r',',',' ','c','a','n',' ','b','e',' ','i','n','t','e','r','f','a','c','e','d',' ',
'd','i','r','e','c','t','l','y',' ','w','i','t','h',' ','N','E','d','i','t',' ','v','i','a',' ','t','h','e',' ','c','l','i','e','n','t',' ','s','e','r','v','e','r',' ','i','n','t','e','r','f','a','c','e','.',' ',' ','T','h','e','s','e',' ',
't','o','o','l','s',' ','a','l','l','o','w',' ','y','o','u',' ','t','o',' ','c','l','i','c','k',' ','d','i','r','e','c','t','l','y',' ','o','n',' ','c','o','m','p','i','l','e','r',' ','a','n','d',' ','r','u','n','t','i','m','e',' ','e','r','r','o','r',' ','m','e','s','s','a','g','e','s',' ',
'a','n','d',' ','r','e','q','u','e','s','t',' ','N','E','d','i','t',' ','t','o',' ','o','p','e','n',' ','f','i','l','e','s',',',' ','a','n','d',' ','s','e','l','e','c','t',' ','l','i','n','e','s',' ','o','f',' ','i','n','t','e','r','e','s','t','.',' ',' ',
'T','h','e',' ','e','a','s','i','e','s','t',' ','m','e','t','h','o','d',' ','i','s',' ','u','s','u','a','l','l','y',' ','t','o',' ','u','s','e',' ',
't','h','e',' ','t','o','o','l',''','s',' ','i','n','t','e','r','f','a','c','e',' ','f','o','r',' ','c','h','a','r','a','c','t','e','r','-','b','a','s','e','d',' ','e','d','i','t','o','r','s',' ','l','i','k','e',' ','v','i',',',' ','t','o',' ','i','n','v','o','k','e',' ','n','c',',',' ',
'b','u','t',' ','p','r','o','g','r','a','m','a','t','i','c',' ','i','n','t','e','r','f','a','c','e','s',' ','c','a','n',' ','a','l','s','o',' ','b','e',' ','d','e','r','i','v','e','d',' ','u','s','i','n','g',' ','t','h','e',' ','s','o','u','r','c','e',' ','c','o','d','e',' ',
'f','o','r',' ','n','c','.','\n',
'\n',
'T','h','e','r','e',' ','a','r','e',' ','a','l','s','o',' ','s','o','m','e',' ','s','i','m','p','l','e',' ','c','o','m','p','i','l','e','/','r','e','v','i','e','w',',',' ','g','r','e','p',',',' ','c','t','r','e','e',',',' ','a','n','d',' ','c','t','a','g','s',' ','b','r','o','w','s','e','r','s',' ',
'a','v','a','i','l','a','b','l','e',' ','i','n',' ','t','h','e',' ','N','E','d','i','t',' ','c','o','n','t','r','i','b',' ','d','i','r','e','c','t','o','r','y',' ','o','n',' ','f','t','p','.','f','n','a','l','.','g','o','v','.','\0'};

static char AuxString8[] = {'N','E','d','i','t',' ','c','a','n',' ','p','r','o','c','e','s','s',' ','t','a','g','s',' ','f','i','l','e','s',' ','g','e','n','e','r','a','t','e','d',' ','u','s','i','n','g',' ','t','h','e',' ','U','n','i','x',' ','c','t','a','g','s',' ','c','o','m','m','a','n','d','.',' ',' ',
'C','t','a','g','s',' ','c','r','e','a','t','e','s',' ','i','n','d','e','x',' ','f','i','l','e','s',' ','c','o','r','r','e','l','a','t','i','n','g',' ','n','a','m','e','s',' ','o','f',' ','f','u','n','c','t','i','o','n','s',' ','a','n','d',' ','d','e','c','l','a','r','a','t','i','o','n','s',' ',
'w','i','t','h',' ','t','h','e','i','r',' ','l','o','c','a','t','i','o','n','s',' ','i','n',' ','C',',',' ','F','o','r','t','r','a','n',',',' ','o','r',' ','P','a','s','c','a','l',' ','s','o','u','r','c','e',' ','c','o','d','e',' ','f','i','l','e','s','.',' ','(','S','e','e',' ','t','h','e',' ',
'c','t','a','g','s',' ','m','a','n','u','a','l',' ','p','a','g','e',' ','f','o','r',' ','m','o','r','e',' ','i','n','f','o','r','m','a','t','i','o','n',')','.',' ',' ','C','t','a','g','s',' ','p','r','o','d','u','c','e','s',' ','a',' ','f','i','l','e',' ','c','a','l','l','e','d',' ',
'\"','t','a','g','s','\"',' ','w','h','i','c','h',' ','c','a','n',' ','b','e',' ','l','o','a','d','e','d',' ','b','y',' ','N','E','d','i','t','.',' ',' ','O','n','c','e',' ','l','o','a','d','e','d',',',' ','t','h','e',' ','i','n','f','o','r','m','a','t','i','o','n',' ','i','n',' ',
't','h','e',' ','t','a','g','s',' ','f','i','l','e',' ','e','n','a','b','l','e','s',' ','N','E','d','i','t',' ','t','o',' ','g','o',' ','d','i','r','e','c','t','l','y',' ','t','o',' ','t','h','e',' ','d','e','c','l','a','r','a','t','i','o','n',' ','o','f',' ','a',' ',
'h','i','g','h','l','i','g','h','t','e','d',' ','f','u','n','c','t','i','o','n',' ','o','r',' ','d','a','t','a',' ','s','t','r','u','c','t','u','r','e',' ','n','a','m','e',' ','w','i','t','h',' ','a',' ','s','i','n','g','l','e',' ','c','o','m','m','a','n','d','.',' ',' ','T','o',' ',
'l','o','a','d',' ','a',' ','t','a','g','s',' ','f','i','l','e',',',' ','s','e','l','e','c','t',' ','\"','L','o','a','d',' ','T','a','g','s',' ','F','i','l','e','\"',' ','f','r','o','m',' ','t','h','e',' ','F','i','l','e',' ','m','e','n','u',' ','a','n','d',' ','c','h','o','o','s','e',' ',
'a',' ','t','a','g','s',' ','f','i','l','e',' ','t','o',' ','l','o','a','d',',',' ','o','r',' ','s','p','e','c','i','f','y',' ','t','h','e',' ','n','a','m','e',' ','o','f',' ','t','h','e',' ','t','a','g','s',' ','f','i','l','e',' ','o','n',' ','t','h','e',' ','N','E','d','i','t',' ',
'c','o','m','m','a','n','d',' ','l','i','n','e',':','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t',' ','-','t','a','g','s',' ','t','a','g','s','\n',
'\n',
'N','E','d','i','t',' ','c','a','n',' ','a','l','s','o',' ','b','e',' ','s','e','t',' ','t','o',' ','l','o','a','d',' ','a',' ','t','a','g','s',' ','f','i','l','e',' ','a','u','t','o','m','a','t','i','c','a','l','l','y',' ','w','h','e','n',' ','i','t',' ','s','t','a','r','t','s',' ','u','p','.',' ',' ',
'S','e','t','t','i','n','g',' ','t','h','e',' ','X',' ','r','e','s','o','u','r','c','e',' ','n','e','d','i','t','.','t','a','g','F','i','l','e',' ','t','o',' ','t','h','e',' ','n','a','m','e',' ','o','f',' ','a',' ','t','a','g',' ','f','i','l','e',' ','t','e','l','l','s',' ','N','E','d','i','t',' ',
't','o',' ','l','o','o','k',' ','f','o','r',' ','t','h','a','t',' ','f','i','l','e',' ','a','t',' ','s','t','a','r','t','u','p',' ','t','i','m','e',' ','(','s','e','e',' ','C','u','s','t','o','m','i','z','i','n','g',' ','N','E','d','i','t',')','.',' ',' ','T','h','e',' ','f','i','l','e',' ','n','a','m','e',' ',
'c','a','n',' ','b','e',' ','e','i','t','h','e','r',' ','a',' ','c','o','m','p','l','e','t','e',' ','p','a','t','h',' ','n','a','m','e',',',' ','i','n',' ','w','h','i','c','h',' ','c','a','s','e',' ','N','E','d','i','t',' ','w','i','l','l',' ','a','l','w','a','y','s',' ','l','o','a','d',' ',
't','h','e',' ','s','a','m','e',' ','t','a','g','s',' ','f','i','l','e',',',' ','o','r',' ','a',' ','f','i','l','e',' ','n','a','m','e',' ','w','i','t','h','o','u','t',' ','a',' ','p','a','t','h',' ','o','r',' ','w','i','t','h',' ','a',' ','r','e','l','a','t','i','v','e',' ','p','a','t','h',',',' ',
'i','n',' ','w','h','i','c','h',' ','c','a','s','e',' ','N','E','d','i','t',' ','w','i','l','l',' ','l','o','a','d',' ','i','t',' ','s','t','a','r','t','i','n','g',' ','f','r','o','m',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','d','i','r','e','c','t','o','r','y','.',' ',' ','T','h','e',' ',
's','e','c','o','n','d',' ','o','p','t','i','o','n',' ','a','l','l','o','w','s',' ','y','o','u',' ','t','o',' ','h','a','v','e',' ','d','i','f','f','e','r','e','n','t',' ','t','a','g','s',' ','f','i','l','e','s',' ','f','o','r',' ','d','i','f','f','e','r','e','n','t',' ',
'p','r','o','j','e','c','t','s',',',' ','e','a','c','h',' ','a','u','t','o','m','a','t','i','c','a','l','l','y',' ','l','o','a','d','e','d',' ','d','e','p','e','n','d','i','n','g',' ','o','n',' ','t','h','e',' ','d','i','r','e','c','t','o','r','y',' ','y','o','u',''','r','e',' ','i','n',' ',
'w','h','e','n',' ','y','o','u',' ','s','t','a','r','t',' ','N','E','d','i','t','.',' ',' ','S','e','t','t','i','n','g',' ','t','h','e',' ','n','a','m','e',' ','t','o',' ','\"','t','a','g','s','\"',' ','i','s',' ','a','n',' ','o','b','v','i','o','u','s',' ','c','h','o','i','c','e',' ',
's','i','n','c','e',' ','t','h','i','s',' ','i','s',' ','t','h','e',' ','n','a','m','e',' ','t','h','a','t',' ','c','t','a','g','s',' ','u','s','e','s','.','\n',
'\n',
'T','o',' ','f','i','n','d',' ','t','h','e',' ','d','e','f','i','n','i','t','i','o','n',' ','o','f',' ','a',' ','f','u','n','c','t','i','o','n',' ','o','r',' ','d','a','t','a',' ','s','t','r','u','c','t','u','r','e',' ','o','n','c','e',' ','a',' ','t','a','g','s',' ','f','i','l','e',' ','i','s',' ',
'l','o','a','d','e','d',',',' ','s','e','l','e','c','t',' ','t','h','e',' ','n','a','m','e',' ','a','n','y','w','h','e','r','e',' ','i','t',' ','a','p','p','e','a','r','s',' ','i','n',' ','y','o','u','r',' ','p','r','o','g','r','a','m',' ','(','s','e','e',' ','S','e','l','e','c','t','i','n','g',' ',
'T','e','x','t',')',' ','a','n','d',' ','c','h','o','o','s','e',' ','\"','F','i','n','d',' ','D','e','f','i','n','i','t','i','o','n','\"',' ','f','r','o','m',' ','t','h','e',' ','S','e','a','r','c','h',' ','m','e','n','u','.','\0'};

static char AuxString9[] = {'M','o','u','s','e','-','b','a','s','e','d',' ',
'e','d','i','t','i','n','g',' ','i','s',' ','w','h','a','t',' ','N','E','d','i','t',' ','i','s',' ','a','l','l',' ','a','b','o','u','t',',',' ','a','n','d',' ','l','e','a','r','n','i','n','g',' ','t','o',' ','u','s','e',' ','t','h','e',' ','m','o','r','e',' ','a','d','v','a','n','c','e','d',' ',
'f','e','a','t','u','r','e','s',' ','l','i','k','e',' ','s','e','c','o','n','d','a','r','y',' ','s','e','l','e','c','t','i','o','n','s',' ','a','n','d',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ',
'd','r','a','g','g','i','n','g',' ','w','i','l','l',' ','b','e',' ','w','e','l','l',' ','w','o','r','t','h',' ','y','o','u','r',' ','w','h','i','l','e','.','\n',
'\n',
'I','f',' ','y','o','u',' ','d','o','n',''','t',' ','h','a','v','e',' ','t','i','m','e',' ','t','o',' ','l','e','a','r','n',' ','e','v','e','r','y','t','h','i','n','g',',',' ','y','o','u',' ','c','a','n',' ','g','e','t',' ','b','y',' ','a','d','e','q','u','a','t','e','l','y',' ','w','i','t','h',' ',
'j','u','s','t',' ','t','h','e',' ','l','e','f','t',' ','m','o','u','s','e',' ','b','u','t','t','o','n',':',' ',' ','C','l','i','c','k','i','n','g',' ','t','h','e',' ','l','e','f','t',' ','b','u','t','t','o','n',' ',
'm','o','v','e','s',' ','t','h','e',' ','c','u','r','s','o','r','.',' ',' ',
'D','r','a','g','g','i','n','g',' ','w','i','t','h',' ','t','h','e',' ','l','e','f','t',' ','b','u','t','t','o','n',' ','m','a','k','e','s',' ','a',' ','s','e','l','e','c','t','i','o','n','.',' ',' ','H','o','l','d','i','n','g',' ','t','h','e',' ','s','h','i','f','t',' ',
'k','e','y',' ','w','h','i','l','e',' ','c','l','i','c','k','i','n','g',' ','e','x','t','e','n','d','s',' ','t','h','e',' ','e','x','i','s','t','i','n','g',' ','s','e','l','e','c','t','i','o','n',',',' ','o','r',' ','b','e','g','i','n','s',' ','a',' ','s','e','l','e','c','t','i','o','n',' ',
'b','e','t','w','e','e','n',' ','t','h','e',' ','c','u','r','s','o','r',' ','a','n','d',' ','t','h','e',' ','m','o','u','s','e','.',' ',' ','D','o','u','b','l','e',' ','o','r',' ','t','r','i','p','l','e',' ','c','l','i','c','k','i','n','g',' ','s','e','l','e','c','t','s',' ','a',' ',
'w','h','o','l','e',' ','w','o','r','d',' ','o','r',' ','a',' ','w','h','o','l','e',' ','l','i','n','e','.','\n',
'\n',
'T','h','i','s',' ','s','e','c','t','i','o','n',' ','w','i','l','l',' ','m','a','k','e',' ','m','o','r','e',' ','s','e','n','s','e',' ','i','f',' ','y','o','u',' ','a','l','s','o',' ','r','e','a','d',' ','t','h','e',' ','s','e','c','t','i','o','n',' ','c','a','l','l','e','d',',',' ',
'\"','S','e','l','e','c','t','i','n','g',' ','T','e','x','t','\"',',',' ','w','h','i','c','h',' ','e','x','p','l','a','i','n','s',' ','t','h','e',' ','t','e','r','m','i','n','o','l','o','g','y',' ','o','f',' ','s','e','l','e','c','t','i','o','n','s',',',' ','i','.','e','.',' ',
'w','h','a','t',' ','i','s',' ','m','e','a','n','t',' ','b','y',' ','p','r','i','m','a','r','y',',',' ','s','e','c','o','n','d','a','r','y',',',' ','r','e','c','t','a','n','g','u','l','a','r',',',' ','e','t','c','.','\n',
'\n',
'\n',
'G','E','N','E','R','A','L','\n',
'\n',
'G','e','n','e','r','a','l',' ','m','e','a','n','i','n','g',' ','o','f',' ','m','o','u','s','e',' ','b','u','t','t','o','n','s',' ','a','n','d',' ','m','o','d','i','f','i','e','r',' ','k','e','y','s',':','\n',
'\n',
'B','u','t','t','o','n','s','\n',
'\n',
' ',' ','B','u','t','t','o','n',' ','1',' ','(','l','e','f','t',')',' ',' ',' ',' ','C','u','r','s','o','r',' ','p','o','s','i','t','i','o','n',' ','a','n','d',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n','\n',
'\n',
' ',' ','B','u','t','t','o','n',' ','2',' ','(','m','i','d','d','l','e',')',' ',' ','S','e','c','o','n','d','a','r','y',' ','s','e','l','e','c','t','i','o','n','s',',',' ','a','n','d',' ','d','r','a','g','g','i','n','g',' ','a','n','d','\n',
' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ','c','o','p','y','i','n','g',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n','\n',
'\n',
' ',' ','B','u','t','t','o','n',' ','3',' ','(','r','i','g','h','t',')',' ',' ',' ','Q','u','i','c','k','-','a','c','c','e','s','s',' ','p','r','o','g','r','a','m','m','a','b','l','e',' ','m','e','n','u',' ','a','n','d',' ','p','a','n','\n',
' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ','s','c','r','o','l','l','i','n','g','\n',
'\n',
'M','o','d','i','f','i','e','r',' ','k','e','y','s','\n',
'\n',
' ',' ','S','h','i','f','t',' ',' ',' ','O','n',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n','s',',',' ','(','l','e','f','t',' ','m','o','u','s','e',' ','b','u','t','t','o','n',')',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ','E','x','t','e','n','d','s',' ','s','e','l','e','c','t','i','o','n',' ','t','o',' ','t','h','e',' ','m','o','u','s','e',' ','p','o','i','n','t','e','r','\n',
' ',' ',' ',' ',' ',' ',' ',' ',' ',' ','O','n',' ','s','e','c','o','n','d','a','r','y',' ','a','n','d',' ','c','o','p','y',' ','o','p','e','r','a','t','i','o','n','s',',',' ','(','m','i','d','d','l','e',')',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ','T','o','g','g','l','e','s',' ','b','e','t','w','e','e','n',' ','m','o','v','e',' ','a','n','d',' ','c','o','p','y','\n',
'\n',
' ',' ','C','t','r','l',' ',' ',' ',' ','M','a','k','e','s',' ','s','e','l','e','c','t','i','o','n',' ','r','e','c','t','a','n','g','u','l','a','r',' ','o','r',' ','i','n','s','e','r','t','i','o','n','\n',
' ',' ',' ',' ',' ',' ',' ',' ',' ',' ','c','o','l','u','m','n','a','r','\n',
'\n',
' ',' ','A','l','t','*',' ',' ',' ',' ','(','o','n',' ','r','e','l','e','a','s','e',')',' ','E','x','c','h','a','n','g','e',' ','p','r','i','m','a','r','y',' ','a','n','d',' ','s','e','c','o','n','d','a','r','y','\n',
' ',' ',' ',' ',' ',' ',' ',' ',' ',' ','s','e','l','e','c','t','i','o','n','s','.','\n',
'\n',
'\n',
'L','e','f','t',' ','M','o','u','s','e',' ','B','u','t','t','o','n','\n',
'\n',
'T','h','e',' ','l','e','f','t',' ','m','o','u','s','e',' ','b','u','t','t','o','n',' ','i','s',' ','u','s','e','d',' ','t','o',' ','p','o','s','i','t','i','o','n',' ','t','h','e',' ','c','u','r','s','o','r',' ','a','n','d',' ','t','o',' ','m','a','k','e',' ','p','r','i','m','a','r','y',' ',
's','e','l','e','c','t','i','o','n','s','\n',
'\n',
' ',' ','C','l','i','c','k',' ','	','M','o','v','e','s',' ','t','h','e',' ','c','u','r','s','o','r','\n',
' ','\n',
' ',' ','D','o','u','b','l','e',' ','C','l','i','c','k','	','S','e','l','e','c','t','s',' ','a',' ','w','h','o','l','e',' ','w','o','r','d','\n',
'\n',
' ',' ','T','r','i','p','l','e',' ','C','l','i','c','k','	','S','e','l','e','c','t','s',' ','a',' ','w','h','o','l','e',' ','l','i','n','e','\n',
'\n',
' ',' ','Q','u','a','d',' ','C','l','i','c','k','	','S','e','l','e','c','t','s',' ','t','h','e',' ','w','h','o','l','e',' ','f','i','l','e','\n',
'\n',
' ',' ','S','h','i','f','t',' ','C','l','i','c','k','	','A','d','j','u','s','t','s',' ','(','e','x','t','e','n','d','s',' ','o','r',' ','s','h','r','i','n','k','s',')',' ','t','h','e','\n',
' ','	','	','s','e','l','e','c','t','i','o','n',',',' ','o','r',' ','i','f',' ','t','h','e','r','e',' ','i','s',' ','n','o',' ','e','x','i','s','t','i','n','g','\n',
' ','	','	','s','e','l','e','c','t','i','o','n',',',' ','b','e','g','i','n','s',' ','a',' ','n','e','w',' ','s','e','l','e','c','t','i','o','n','\n',
' ','	','	','b','e','t','w','e','e','n',' ','t','h','e',' ','c','u','r','s','o','r',' ','a','n','d',' ','t','h','e',' ','m','o','u','s','e','.','\n',
'\n',
' ',' ','C','t','r','l','+','S','h','i','f','t','+','	','A','d','j','u','s','t','s',' ','(','e','x','t','e','n','d','s',' ','o','r',' ','s','h','r','i','n','k','s',')',' ','t','h','e','\n',
' ',' ','C','l','i','c','k',' ','	','s','e','l','e','c','t','i','o','n',' ','r','e','c','t','a','n','g','u','l','a','r','l','y','.','\n',
'\n',
' ',' ','D','r','a','g','	','	','S','e','l','e','c','t','s',' ','t','e','x','t',' ','b','e','t','w','e','e','n',' ','w','h','e','r','e',' ','t','h','e',' ','m','o','u','s','e','\n',
' ','	','	','w','a','s',' ','p','r','e','s','s','e','d',' ','a','n','d',' ','w','h','e','r','e',' ','i','t',' ','w','a','s',' ','r','e','l','e','a','s','e','d','.','\n',
'\n',
' ',' ','C','t','r','l','+','D','r','a','g','	','S','e','l','e','c','t','s',' ','r','e','c','t','a','n','g','l','e',' ','b','e','t','w','e','e','n',' ','w','h','e','r','e',' ','t','h','e','\n',
' ','	','	','m','o','u','s','e',' ','w','a','s',' ','p','r','e','s','s','e','d',' ','a','n','d',' ','w','h','e','r','e',' ','i','t',' ','w','a','s','\n',
' ','	','	','r','e','l','e','a','s','e','d','.','\n',
'\n',
'\n',
'R','i','g','h','t',' ','M','o','u','s','e',' ','B','u','t','t','o','n','\n',
'\n',
'T','h','e',' ','r','i','g','h','t',' ','m','o','u','s','e',' ','b','u','t','t','o','n',' ','p','o','s','t','s',' ','a',' ','p','r','o','g','r','a','m','m','a','b','l','e',' ','m','e','n','u',' ','f','o','r',' ','f','r','e','q','u','e','n','t','l','y',' ','u','s','e','d',' ',
'c','o','m','m','a','n','d','s','.','\n',
'\n',
' ',' ','C','l','i','c','k','/','D','r','a','g',' ',' ',' ','P','o','p','s',' ','u','p',' ','t','h','e',' ','b','a','c','k','g','r','o','u','n','d',' ','m','e','n','u',' ','(','p','r','o','g','r','a','m','m','e','d','\n',
' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ','f','r','o','m',' ','P','r','e','f','e','r','e','n','c','e','s',' ','-','>',' ','D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s',' ','-','>','\n',
'	',' ',' ',' ',' ',' ',' ',' ','C','u','s','t','o','m','i','z','e',' ','M','e','n','u','s',' ','-','>',' ','W','i','n','d','o','w',' ','B','a','c','k','g','r','o','u','n','d',')','.','\n',
'\n',
' ',' ','C','t','r','l','+','D','r','a','g',' ',' ',' ',' ','P','a','n',' ','s','c','r','o','l','l','i','n','g','.',' ',' ','S','c','r','o','l','l','s',' ','t','h','e',' ','w','i','n','d','o','w','\n',
' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ','b','o','t','h',' ','v','e','r','t','i','c','a','l','l','y',' ','a','n','d',' ','h','o','r','i','z','o','n','t','a','l','l','y',',',' ','a','s',' ','i','f','\n',
'	',' ',' ',' ',' ',' ',' ',' ','y','o','u',' ','h','a','d',' ','g','r','a','b','b','e','d',' ','i','t',' ','w','i','t','h',' ','y','o','u','r',' ','m','o','u','s','e','.','\n',
'\n',
'\n',
'M','i','d','d','l','e',' ','M','o','u','s','e',' ','B','u','t','t','o','n','\n',
'\n',
'T','h','e',' ','m','i','d','d','l','e',' ','m','o','u','s','e',' ','b','u','t','t','o','n',' ','i','s',' ','f','o','r',' ','m','a','k','i','n','g',' ','s','e','c','o','n','d','a','r','y',' ','s','e','l','e','c','t','i','o','n','s',',',' ','a','n','d',' ','c','o','p','y','i','n','g',' ','a','n','d',' ',
'd','r','a','g','g','i','n','g',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n','\n',
'\n',
' ',' ','C','l','i','c','k',' ',' ',' ',' ',' ',' ',' ',' ','C','o','p','i','e','s',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','t','o',' ','t','h','e','\n',
' ','	',' ',' ',' ',' ',' ',' ',' ','c','l','i','c','k','e','d',' ','p','o','s','i','t','i','o','n','.','\n',
'\n',
' ',' ','S','h','i','f','t','+','C','l','i','c','k',' ',' ','M','o','v','e','s',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','t','o',' ','t','h','e','\n',
' ','	',' ',' ',' ',' ',' ',' ',' ','c','l','i','c','k','e','d',' ','p','o','s','i','t','i','o','n',',',' ','d','e','l','e','t','i','n','g',' ','i','t',' ','f','r','o','m',' ','i','t','s','\n',
' ','	',' ',' ',' ',' ',' ',' ',' ','o','r','i','g','i','n','a','l',' ','p','o','s','i','t','i','o','n','.','\n',
'\n',
' ',' ','D','r','a','g','	',' ',' ',' ',' ',' ',' ',' ','1',')',' ','O','u','t','s','i','d','e',' ','o','f',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',':','\n',
' ','	',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ','B','e','g','i','n','s',' ','a',' ','s','e','c','o','n','d','a','r','y',' ','s','e','l','e','c','t','i','o','n','.','\n',
' ','	',' ',' ',' ',' ',' ',' ',' ','2',')',' ','I','n','s','i','d','e',' ','o','f',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',':','\n',
' ','	',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ','M','o','v','e','s',' ','t','h','e',' ','s','e','l','e','c','t','i','o','n',' ','b','y',' ','d','r','a','g','g','i','n','g','.','\n',
'\n',
' ',' ','C','t','r','l','+','D','r','a','g',' ',' ',' ',' ','1',')',' ','O','u','t','s','i','d','e',' ','o','f',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',':','\n',
' ','	',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ','B','e','g','i','n','s',' ','a',' ','r','e','c','t','a','n','g','u','l','a','r',' ','s','e','c','o','n','d','a','r','y','\n',
' ','	',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ','s','e','l','e','c','t','i','o','n','.','\n',
' ','	',' ',' ',' ',' ',' ',' ',' ','2',')',' ','I','n','s','i','d','e',' ','o','f',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',':','\n',
' ','	',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ','D','r','a','g','s',' ','t','h','e',' ','s','e','l','e','c','t','i','o','n',' ','i','n',' ','o','v','e','r','l','a','y','\n',
' ','	',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ','m','o','d','e',' ','(','s','e','e',' ','b','e','l','o','w',')','.','\n',
'\n',
'W','h','e','n',' ','t','h','e',' ','m','o','u','s','e',' ','b','u','t','t','o','n',' ','i','s',' ','r','e','l','e','a','s','e','d',' ','a','f','t','e','r',' ','c','r','e','a','t','i','n','g',' ','a',' ','s','e','c','o','n','d','a','r','y',' ','s','e','l','e','c','t','i','o','n',':','\n',
'\n',
' ',' ','N','o',' ','M','o','d','i','f','i','e','r','s','	','I','f',' ','t','h','e','r','e',' ','i','s',' ','a',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',',','\n',
' ','	','	','r','e','p','l','a','c','e','s',' ','i','t',' ','w','i','t','h',' ','t','h','e',' ','s','e','c','o','n','d','a','r','y','\n',
' ','	','	','s','e','l','e','c','t','i','o','n','.',' ',' ','O','t','h','e','r','w','i','s','e',',',' ','i','n','s','e','r','t','s',' ','t','h','e','\n',
' ','	','	','s','e','c','o','n','d','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','a','t',' ','t','h','e',' ','c','u','r','s','o','r','\n',
' ','	','	','p','o','s','i','t','i','o','n','.','\n',
'\n',
' ',' ','S','h','i','f','t',' ','	','M','o','v','e',' ','t','h','e',' ','s','e','c','o','n','d','a','r','y',' ','s','e','l','e','c','t','i','o','n',',',' ','d','e','l','e','t','i','n','g','\n',
' ','	','	','i','t',' ','f','r','o','m',' ','i','t','s',' ','o','r','i','g','i','n','a','l',' ','p','o','s','i','t','i','o','n','.',' ',' ','I','f','\n',
' ','	','	','t','h','e','r','e',' ','i','s',' ','a',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',',',' ','t','h','e',' ','m','o','v','e','\n',
' ','	','	','w','i','l','l',' ','r','e','p','l','a','c','e',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n','\n',
' ','	','	','w','i','t','h',' ','t','h','e',' ','s','e','c','o','n','d','a','r','y',' ','s','e','l','e','c','t','i','o','n','.','\n',
' ','	','	','O','t','h','e','r','w','i','s','e',',',' ','m','o','v','e','s',' ','t','h','e',' ','s','e','c','o','n','d','a','r','y','\n',
' ','	','	','s','e','l','e','c','t','i','o','n',' ','t','o',' ','t','o',' ','t','h','e',' ','c','u','r','s','o','r',' ','p','o','s','i','t','i','o','n','.','\n',
'\n',
' ',' ','A','l','t','*','	','	','E','x','c','h','a','n','g','e',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','a','n','d',' ','s','e','c','o','n','d','a','r','y','\n',
' ','	','	','s','e','l','e','c','t','i','o','n','s','.','\n',
'\n',
'\n',
'W','h','i','l','e',' ','m','o','v','i','n','g',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','b','y',' ','d','r','a','g','g','i','n','g',' ','w','i','t','h',' ','t','h','e',' ','m','i','d','d','l','e',' ','m','o','u','s','e',' ','b','u','t','t','o','n',':','\n',
'\n',
' ',' ','S','h','i','f','t',' ',' ',' ','L','e','a','v','e','s',' ','a',' ','c','o','p','y',' ','o','f',' ','t','h','e',' ','o','r','i','g','i','n','a','l','\n',
' ','	',' ',' ','s','e','l','e','c','t','i','o','n',' ','i','n',' ','p','l','a','c','e',' ','r','a','t','h','e','r',' ','t','h','a','n','\n',
' ','	',' ',' ','r','e','m','o','v','i','n','g',' ','i','t',' ','o','r',' ','b','l','a','n','k','i','n','g',' ','t','h','e',' ','a','r','e','a','.','\n',
' ','\n',
' ',' ','C','t','r','l','	',' ',' ','C','h','a','n','g','e','s',' ','f','r','o','m',' ','i','n','s','e','r','t',' ','m','o','d','e',' ','t','o',' ','o','v','e','r','l','a','y','\n',
' ','	',' ',' ','m','o','d','e',' ','(','s','e','e',' ','b','e','l','o','w',')','.','\n',
'\n',
' ',' ','E','s','c','a','p','e',' ',' ','C','a','n','c','e','l','s',' ','d','r','a','g',' ','i','n',' ','p','r','o','g','r','e','s','s','.','\n',
'\n',
'O','v','e','r','l','a','y',' ','M','o','d','e',':',' ','N','o','r','m','a','l','l','y',',',' ','d','r','a','g','g','i','n','g',' ','m','o','v','e','s',' ','t','e','x','t',' ','b','y',' ','r','e','m','o','v','i','n','g',' ','i','t',' ','f','r','o','m',' ','t','h','e',' ',
's','e','l','e','c','t','e','d',' ','p','o','s','i','t','i','o','n',' ','a','t',' ','t','h','e',' ','s','t','a','r','t',' ','o','f',' ','t','h','e',' ','d','r','a','g',',',' ','a','n','d',' ','i','n','s','e','r','t','i','n','g',' ','i','t',' ','a','t',' ','a',' ',
'n','e','w',' ','p','o','s','i','t','i','o','n',' ','r','e','l','a','t','i','v','e',' ','t','o',' ','t','o',' ','t','h','e',' ','m','o','u','s','e','.',' ','W','h','e','n',' ','y','o','u',' ','d','r','a','g',' ','a',' ','b','l','o','c','k',' ','o','f',' ','t','e','x','t',' ',
'o','v','e','r',' ','e','x','i','s','t','i','n','g',' ','c','h','a','r','a','c','t','e','r','s',',',' ','t','h','e',' ','e','x','i','s','t','i','n','g',' ','c','h','a','r','a','c','t','e','r','s',' ','a','r','e',' ','d','i','s','p','l','a','c','e','d',' ','t','o',' ',
't','h','e',' ','e','n','d',' ','o','f',' ','t','h','e',' ','s','e','l','e','c','t','i','o','n','.',' ',' ','I','n',' ','o','v','e','r','l','a','y',' ','m','o','d','e',',',' ','c','h','a','r','a','c','t','e','r','s',' ','w','h','i','c','h',' ','a','r','e',' ',
'o','c','c','l','u','d','e','d',' ','b','y',' ','b','l','o','c','k','s',' ','o','f',' ','t','e','x','t',' ','b','e','i','n','g',' ','d','r','a','g','g','e','d',' ','a','r','e',' ','s','i','m','p','l','y',' ','r','e','m','o','v','e','d','.',' ',' ','W','h','e','n',' ',
'd','r','a','g','g','i','n','g',' ','n','o','n','-','r','e','c','t','a','n','g','u','l','a','r',' ','s','e','l','e','c','t','i','o','n','s',',',' ','o','v','e','r','l','a','y',' ','m','o','d','e',' ','a','l','s','o',' ','c','o','n','v','e','r','t','s',' ','t','h','e',' ',
's','e','l','e','c','t','i','o','n',' ','t','o',' ','r','e','c','t','a','n','g','u','l','a','r',' ','f','o','r','m',',',' ','a','l','l','o','w','i','n','g',' ','i','t',' ','t','o',' ','b','e',' ','d','r','a','g','g','e','d',' ','o','u','t','s','i','d','e',' ','o','f',' ',
't','h','e',' ','b','o','u','n','d','s',' ','o','f',' ','t','h','e',' ','e','x','i','s','t','i','n','g',' ','t','e','x','t','.','\n',
'\n',
'\n',
'*',' ','T','h','e',' ','A','l','t',' ','k','e','y',' ','m','a','y',' ','b','e',' ','l','a','b','e','l','e','d',' ','M','e','t','a',' ','o','r',' ','C','o','m','p','o','s','e','-','C','h','a','r','a','c','t','e','r',' ','o','n',' ','s','o','m','e',' ',
'k','e','y','b','o','a','r','d','s','.',' ',' ','S','o','m','e',' ','w','i','n','d','o','w',' ','m','a','n','a','g','e','r','s',',',' ','i','n','c','l','u','d','i','n','g',' ','d','e','f','a','u','l','t',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','s',' ',
'o','f',' ','m','w','m',',',' ','b','i','n','d',' ','c','o','m','b','i','n','a','t','i','o','n','s',' ','o','f',' ','t','h','e',' ','A','l','t',' ','k','e','y',' ','a','n','d',' ','m','o','u','s','e',' ','b','u','t','t','o','n','s',' ','t','o',' ','w','i','n','d','o','w',' ',
'm','a','n','a','g','e','r',' ','o','p','e','r','a','t','i','o','n','s','.',' ',' ','I','n',' ','N','E','d','i','t',',',' ','A','l','t',' ','i','s',' ','o','n','l','y',' ','u','s','e','d',' ','o','n',' ','b','u','t','t','o','n',' ','r','e','l','e','a','s','e',',',' ',
's','o',' ','r','e','g','a','r','d','l','e','s','s',' ','o','f',' ','t','h','e',' ','w','i','n','d','o','w',' ','m','a','n','a','g','e','r',' ','b','i','n','d','i','n','g','s',' ','f','o','r',' ','A','l','t','-','m','o','d','i','f','i','e','d',' ','m','o','u','s','e',' ',
'b','u','t','t','o','n','s',',',' ','y','o','u',' ','c','a','n',' ','s','t','i','l','l',' ','d','o',' ','t','h','e',' ','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','N','E','d','i','t',' ','o','p','e','r','a','t','i','o','n',' ','b','y',' ','u','s','i','n','g',' ',
't','h','e',' ','A','l','t',' ','k','e','y',' ','A','F','T','E','R',' ','t','h','e',' ','i','n','i','t','i','a','l',' ','m','o','u','s','e',' ','p','r','e','s','s',',',' ','s','o',' ','t','h','a','t',' ','A','l','t',' ','i','s',' ','h','e','l','d',' ','w','h','i','l','e',' ',
'y','o','u',' ','r','e','l','e','a','s','e',' ','t','h','e',' ','m','o','u','s','e',' ','b','u','t','t','o','n','.',' ',' ','I','f',' ','y','o','u',' ','f','i','n','d',' ','t','h','i','s',' ','d','i','f','f','i','c','u','l','t',' ','o','r',' ',
'a','n','n','o','y','i','n','g',',',' ','y','o','u',' ','c','a','n',' ','r','e','-','c','o','n','f','i','g','u','r','e',' ','m','o','s','t',' ','w','i','n','d','o','w',' ','m','a','n','a','g','e','r','s',' ','t','o',' ','s','k','i','p',' ','t','h','i','s',' ',
'b','i','n','d','i','n','g',',',' ','o','r',' ','y','o','u',' ','c','a','n',' ','r','e','-','c','o','n','f','i','g','u','r','e',' ','N','E','d','i','t',' ','t','o',' ','u','s','e',' ','a',' ','d','i','f','f','e','r','e','n','t',' ','k','e','y',' ',
'c','o','m','b','i','n','a','t','i','o','n','.','\0'};

static char AuxString10[] = {'M','o','s','t',' ','o','f',' ','t','h','e',' ','k','e','y','b','o','a','r','d',' ','s','h','o','r','t','c','u','t','s',' ','i','n',' ','N','E','d','i','t',' ','a','r','e',' ','s','h','o','w','n',' ','o','n',' ','t','h','e',' ','r','i','g','h','t',' ','h','a','n','d',' ','s','i','d','e','s',' ',
'o','f',' ','t','h','e',' ','p','u','l','l','-','d','o','w','n',' ','m','e','n','u','s','.',' ',' ','H','o','w','e','v','e','r',',',' ','t','h','e','r','e',' ','a','r','e',' ','m','o','r','e',' ','w','h','i','c','h',' ','a','r','e',' ','n','o','t',' ','a','s',' ','o','b','v','i','o','u','s','.',' ',' ',
'T','h','e','s','e',' ','i','n','c','l','u','d','e',';',' ','d','i','a','l','o','g',' ','b','u','t','t','o','n',' ','s','h','o','r','t','c','u','t','s',';',' ','m','e','n','u',' ','a','n','d',' ',
'd','i','a','l','o','g',' ','m','n','e','m','o','n','i','c','s',';',' ','l','a','b','e','l','e','d',' ','k','e','y','b','o','a','r','d',' ','k','e','y','s',',',' ','s','u','c','h',' ','a','s',' ','t','h','e',' ','a','r','r','o','w','s',',',' ','p','a','g','e','-','u','p',',',' ',
'p','a','g','e','-','d','o','w','n',',',' ','a','n','d',' ','h','o','m','e',';',' ','a','n','d',' ','o','p','t','i','o','n','a','l',' ','S','h','i','f','t',' ','m','o','d','i','f','i','e','r','s',' ','o','n',' ','a','c','c','e','l','e','r','a','t','o','r',' ','k','e','y','s',',',' ','l','i','k','e',' ',
'[','S','h','i','f','t',']','C','t','r','l','+','F','.','\n',
'\n',
'\n',
'M','e','n','u',' ','A','c','c','e','l','e','r','a','t','o','r','s','\n',
'\n',
'P','r','e','s','s','i','n','g',' ','t','h','e',' ','k','e','y',' ','c','o','m','b','i','n','a','t','i','o','n','s',' ','s','h','o','w','n',' ','o','n',' ','t','h','e',' ','r','i','g','h','t',' ','o','f',' ','t','h','e',' ','m','e','n','u',' ','i','t','e','m','s',' ','i','s',' ','a',' ',
's','h','o','r','t','c','u','t',' ','f','o','r',' ','s','e','l','e','c','t','i','n','g',' ','t','h','e',' ','m','e','n','u',' ','i','t','e','m',' ','w','i','t','h',' ','t','h','e',' ','m','o','u','s','e','.',' ',' ','S','o','m','e',' ','i','t','e','m','s',' ','h','a','v','e',' ','t','h','e',' ',
's','h','i','f','t',' ','k','e','y',' ','e','n','c','l','o','s','e','d',' ','i','n',' ','b','r','a','c','k','e','t','s',',',' ','s','u','c','h',' ','a','s',' ','[','S','h','i','f','t',']','C','t','r','l','+','F','.',' ',' ','T','h','i','s',' ','i','n','d','i','c','a','t','e','s',' ',
't','h','a','t',' ','t','h','e',' ','s','h','i','f','t',' ','k','e','y',' ','i','s',' ','o','p','t','i','o','n','a','l','.',' ',' ','I','n',' ','s','e','a','r','c','h',' ','c','o','m','m','a','n','d','s',',',' ','i','n','c','l','u','d','i','n','g',' ','t','h','e',' ','s','h','i','f','t',' ',
'k','e','y',' ','r','e','v','e','r','s','e','s',' ','t','h','e',' ','d','i','r','e','c','t','i','o','n',' ','o','f',' ','t','h','e',' ','s','e','a','r','c','h','.',' ',' ','I','n',' ','S','h','i','f','t',' ','c','o','m','m','a','n','d','s',',',' ','i','t',' ','m','a','k','e','s',' ','t','h','e',' ',
'c','o','m','m','a','n','d',' ','s','h','i','f','t',' ','t','h','e',' ','s','e','l','e','c','t','e','d',' ','t','e','x','t',' ','b','y',' ','a',' ','w','h','o','l','e',' ','t','a','b',' ','s','t','o','p',' ','r','a','t','h','e','r',' ','t','h','a','n',' ','b','y',' ',
's','i','n','g','l','e',' ','c','h','a','r','a','c','t','e','r','s','.','\n',
'\n',
'\n',
'M','e','n','u',' ','M','n','e','m','o','n','i','c','s','\n',
'\n',
'P','r','e','s','s','i','n','g',' ','t','h','e',' ','A','l','t',' ','k','e','y',' ','i','n',' ','c','o','m','b','i','n','a','t','i','o','n',' ','w','i','t','h',' ','o','n','e',' ','o','f',' ','t','h','e',' ','u','n','d','e','r','l','i','n','e','d',' ','c','h','a','r','a','c','t','e','r','s',' ',
'i','n',' ','t','h','e',' ','m','e','n','u',' ','b','a','r',' ','p','u','l','l','s',' ','d','o','w','n',' ','t','h','a','t',' ','m','e','n','u','.',' ',' ','O','n','c','e',' ','t','h','e',' ','m','e','n','u',' ','i','s',' ','p','u','l','l','e','d',' ','d','o','w','n',',',' ',
't','y','p','i','n','g',' ','t','h','e',' ','u','n','d','e','r','l','i','n','e','d',' ','c','h','a','r','a','c','t','e','r','s',' ','i','n',' ','a',' ','m','e','n','u',' ','i','t','e','m',' ','(','w','i','t','h','o','u','t',' ','t','h','e',' ','A','l','t',' ','k','e','y',')',' ',
'a','c','t','i','v','a','t','e','s',' ','t','h','a','t',' ','i','t','e','m','.',' ',' ','W','i','t','h',' ','a',' ','m','e','n','u',' ','p','u','l','l','e','d',' ','d','o','w','n',',',' ','y','o','u',' ','c','a','n',' ','a','l','s','o',' ','u','s','e',' ','t','h','e',' ','a','r','r','o','w',' ',
'k','e','y','s',' ','t','o',' ','s','e','l','e','c','t',' ','m','e','n','u',' ','i','t','e','m','s',',',' ','a','n','d',' ','t','h','e',' ','s','p','a','c','e',' ','o','r',' ','e','n','t','e','r',' ','k','e','y','s',' ','t','o',' ','a','c','t','i','v','a','t','e',' ','t','h','e','m','.','\n',
'\n',
'\n',
'K','e','y','b','o','a','r','d',' ','S','h','o','r','t','c','u','t','s',' ','w','i','t','h','i','n',' ','D','i','a','l','o','g','s','\n',
'\n',
'O','n','e',' ','b','u','t','t','o','n',' ','i','n',' ','a',' ','d','i','a','l','o','g',' ','i','s',' ','u','s','u','a','l','l','y',' ','m','a','r','k','e','d',' ','w','i','t','h',' ','a',' ','t','h','i','c','k',' ','i','n','d','e','n','t','e','d',' ','o','u','t','l','i','n','e','.',' ',' ',
'P','r','e','s','s','i','n','g',' ','t','h','e',' ','R','e','t','u','r','n',' ','o','r',' ','E','n','t','e','r',' ','k','e','y',' ','a','c','t','i','v','a','t','e','s',' ','t','h','i','s',' ','b','u','t','t','o','n','.','\n',
'\n',
'A','l','l',' ','d','i','a','l','o','g','s',' ','h','a','v','e',' ','e','i','t','h','e','r',' ','a',' ','C','a','n','c','e','l',' ','o','r',' ','D','i','s','m','i','s','s',' ','b','u','t','t','o','n','.',' ',' ','T','h','i','s',' ','b','u','t','t','o','n',' ','c','a','n',' ',
'b','e',' ','a','c','t','i','v','a','t','e','d',' ','b','y',' ','p','r','e','s','s','i','n','g',' ','t','h','e',' ','E','s','c','a','p','e',' ','(','o','r',' ','E','s','c',')',' ','k','e','y','.','\n',
'\n',
'P','r','e','s','s','i','n','g',' ','t','h','e',' ','t','a','b',' ','k','e','y',' ','m','o','v','e','s',' ','t','h','e',' ','k','e','y','b','o','a','r','d',' ','f','o','c','u','s',' ','t','o',' ','t','h','e',' ','n','e','x','t',' ','i','t','e','m',' ','i','n',' ','a',' ',
'd','i','a','l','o','g','.',' ',' ','W','i','t','h','i','n',' ','a','n',' ','a','s','s','o','c','i','a','t','e','d',' ','g','r','o','u','p',' ','o','f',' ','b','u','t','t','o','n','s',',',' ','t','h','e',' ','a','r','r','o','w',' ','k','e','y','s',' ','m','o','v','e',' ',
't','h','e',' ','f','o','c','u','s',' ','a','m','o','n','g',' ','t','h','e',' ','b','u','t','t','o','n','s','.',' ',' ','S','h','i','f','t','+','T','a','b',' ','m','o','v','e','s',' ','b','a','c','k','w','a','r','d',' ','t','h','r','o','u','g','h',' ','t','h','e',' ','i','t','e','m','s','.','\n',
'\n',
'M','o','s','t',' ','i','t','e','m','s',' ','i','n',' ','d','i','a','l','o','g','s',' ','h','a','v','e',' ','a','n',' ','u','n','d','e','r','l','i','n','e',' ','u','n','d','e','r',' ','o','n','e',' ','c','h','a','r','a','c','t','e','r',' ','i','n',' ','t','h','e','i','r',' ','n','a','m','e','.',' ',' ',
'P','r','e','s','s','i','n','g',' ','t','h','e',' ','A','l','t',' ','k','e','y',' ','a','l','o','n','g',' ','w','i','t','h',' ','t','h','i','s',' ','c','h','a','r','a','c','t','e','r',',',' ','a','c','t','i','v','a','t','e','s',' ','a',' ','b','u','t','t','o','n',' ','a','s',' ','i','f',' ','y','o','u',' ',
'h','a','d',' ','p','r','e','s','s','e','d',' ','i','t',' ','w','i','t','h',' ','t','h','e',' ','m','o','u','s','e',',',' ','o','r',' ','m','o','v','e','s',' ','t','h','e',' ','k','e','y','b','o','a','r','d',' ','f','o','c','u','s',' ','t','o',' ','t','h','e',' ','a','s','s','o','c','i','a','t','e','d',' ',
't','e','x','t',' ','f','i','e','l','d',' ','o','r',' ','l','i','s','t','.','\n',
'\n',
'Y','o','u',' ','c','a','n',' ','s','e','l','e','c','t',' ','i','t','e','m','s',' ','f','r','o','m',' ','a',' ','l','i','s','t',' ','b','y',' ','u','s','i','n','g',' ','t','h','e',' ','a','r','r','o','w',' ','k','e','y','s',' ','t','o',' ','m','o','v','e',' ','t','h','e',' ',
's','e','l','e','c','t','i','o','n',' ','a','n','d',' ','s','p','a','c','e',' ','t','o',' ','s','e','l','e','c','t','.','\n',
'\n',
'I','n',' ','f','i','l','e',' ','s','e','l','e','c','t','i','o','n',' ','d','i','a','l','o','g','s',',',' ','y','o','u',' ','c','a','n',' ','t','y','p','e',' ','t','h','e',' ','b','e','g','i','n','n','i','n','g',' ','c','h','a','r','a','c','t','e','r','s',' ','o','f',' ','t','h','e',' ',
'f','i','l','e',' ','n','a','m','e',' ','o','r',' ','d','i','r','e','c','t','o','r','y',' ','i','n',' ','t','h','e',' ','l','i','s','t',' ','t','o',' ','s','e','l','e','c','t',' ','f','i','l','e','s','\n',
'\n',
'\n',
'L','a','b','e','l','e','d',' ','F','u','n','c','t','i','o','n',' ','K','e','y','s',' ','\n',
'\n',
'T','h','e',' ','l','a','b','e','l','e','d',' ','f','u','n','c','t','i','o','n',' ','k','e','y','s',' ','o','n',' ','s','t','a','n','d','a','r','d',' ','w','o','r','k','s','t','a','t','i','o','n',' ','a','n','d',' ','P','C',' ','k','e','y','b','o','a','r','d','s',',',' ','l','i','k','e',' ',
't','h','e',' ','a','r','r','o','w','s',',',' ','a','n','d',' ','p','a','g','e','-','u','p',' ','a','n','d',' ','p','a','g','e','-','d','o','w','n',',',' ','a','r','e',' ','a','c','t','i','v','e',' ','i','n',' ','N','E','d','i','t',',',' ','t','h','o','u','g','h',' ','n','o','t',' ',
's','h','o','w','n',' ','i','n',' ','t','h','e',' ','p','u','l','l','-','d','o','w','n',' ','m','e','n','u','s','.','\n',
'\n',
'H','o','l','d','i','n','g',' ','d','o','w','n',' ','t','h','e',' ','c','o','n','t','r','o','l',' ','k','e','y',' ','w','h','i','l','e',' ','p','r','e','s','s','i','n','g',' ','a',' ','n','a','m','e','d',' ','k','e','y',' ','e','x','t','e','n','d','s',' ','t','h','e',' ',
's','c','o','p','e',' ','o','f',' ','t','h','e',' ','a','c','t','i','o','n',' ','t','h','a','t',' ','i','t',' ','p','e','r','f','o','r','m','s','.',' ',' ','F','o','r',' ','e','x','a','m','p','l','e',',',' ','H','o','m','e',' ','n','o','r','m','a','l','l','y',' ','m','o','v','e','s',' ',
't','h','e',' ','i','n','s','e','r','t',' ','c','u','r','s','o','r',' ','t','h','e',' ','b','e','g','i','n','n','i','n','g',' ','o','f',' ','a',' ','l','i','n','e','.',' ',' ','C','t','r','l','+','H','o','m','e',' ','m','o','v','e','s',' ','i','t',' ','t','o',' ','t','h','e',' ',
'b','e','g','i','n','n','i','n','g',' ','o','f',' ','t','h','e',' ','f','i','l','e','.',' ','B','a','c','k','s','p','a','c','e',' ','d','e','l','e','t','e','s',' ','o','n','e',' ','c','h','a','r','a','c','t','e','r',',',' ','C','t','r','l','+','B','a','c','k','s','p','a','c','e',' ',
'd','e','l','e','t','e','s',' ','o','n','e',' ','w','o','r','d','.','\n',
'\n',
'H','o','l','d','i','n','g',' ','d','o','w','n',' ','t','h','e',' ','s','h','i','f','t',' ','k','e','y',' ','w','h','i','l','e',' ','p','r','e','s','s','i','n','g',' ','a',' ','n','a','m','e','d',' ','k','e','y',' ','b','e','g','i','n','s',' ','o','r',' ','e','x','t','e','n','d','s',' ',
'a',' ','s','e','l','e','c','t','i','o','n','.',' ',' ','C','o','m','b','i','n','i','n','g',' ','t','h','e',' ','s','h','i','f','t',' ','a','n','d',' ','c','o','n','t','r','o','l',' ','k','e','y','s',' ','c','o','m','b','i','n','e','s',' ','t','h','e','i','r',' ',
'a','c','t','i','o','n','s','.',' ',' ','F','o','r',' ','e','x','a','m','p','l','e',',',' ','t','o',' ','s','e','l','e','c','t',' ','a',' ','w','o','r','d',' ','w','i','t','h','o','u','t',' ','u','s','i','n','g',' ','t','h','e',' ','m','o','u','s','e',',',' ',
'p','o','s','i','t','i','o','n',' ','t','h','e',' ','c','u','r','s','o','r',' ','a','t',' ','t','h','e',' ','b','e','g','i','n','n','i','n','g',' ','o','f',' ','t','h','e',' ','w','o','r','d',' ','a','n','d',' ','p','r','e','s','s',' ',
'C','t','r','l','+','S','h','i','f','t','+','R','i','g','h','t','A','r','r','o','w','.',' ',' ','T','h','e',' ','A','l','t',' ','k','e','y',' ','m','o','d','i','f','i','e','s',' ','s','e','l','e','c','t','i','o','n',' ','c','o','m','m','a','n','d','s',' ','t','o',' ','m','a','k','e',' ',
't','h','e',' ','s','e','l','e','c','t','i','o','n',' ','r','e','c','t','a','n','g','u','l','a','r','.','\n',
'\n',
'U','n','d','e','r',' ','X',' ','a','n','d',' ','M','o','t','i','f',',',' ','t','h','e','r','e',' ','a','r','e',' ','s','e','v','e','r','a','l',' ','l','e','v','e','l','s',' ','o','f',' ','t','r','a','n','s','l','a','t','i','o','n',' ','b','e','t','w','e','e','n',' ',
'k','e','y','b','o','a','r','d',' ','k','e','y','s',' ','a','n','d',' ','t','h','e',' ','a','c','t','i','o','n','s',' ','t','h','e','y',' ','p','e','r','f','o','r','m',' ','i','n',' ','a',' ','p','r','o','g','r','a','m','.',' ',' ','T','h','e',' ',
'\"','C','u','s','t','o','m','i','z','i','n','g',' ','N','E','d','i','t','\"',',',' ','a','n','d',' ','\"','X',' ','R','e','s','o','u','r','c','e','s','\"',' ','s','e','c','t','i','o','n','s',' ','o','f',' ','t','h','e',' ','H','e','l','p',' ',
'm','e','n','u',' ','h','a','v','e',' ','m','o','r','e',' ','i','n','f','o','r','m','a','t','i','o','n',' ','o','n',' ','t','h','i','s',' ','s','u','b','j','e','c','t','.',' ',' ','B','e','c','a','u','s','e',' ','o','f',' ','a','l','l',' ','o','f',' ','t','h','i','s',' ',
'c','o','n','f','i','g','u','r','a','b','i','l','i','t','y',',',' ','a','n','d',' ','s','i','n','c','e',' ','k','e','y','b','o','a','r','d','s',' ','a','n','d',' ','s','t','a','n','d','a','r','d','s',' ','f','o','r',' ','t','h','e',' ','m','e','a','n','i','n','g',' ','o','f',' ',
's','o','m','e',' ','k','e','y','s',' ','v','a','r','y',' ','f','r','o','m',' ','m','a','c','h','i','n','e',' ','t','o',' ','m','a','c','h','i','n','e',',',' ','t','h','e',' ','m','a','p','p','i','n','g','s',' ','m','a','y',' ','b','e',' ','c','h','a','n','g','e','d',' ','f','r','o','m',' ',
't','h','e',' ','d','e','f','a','u','l','t','s',' ','l','i','s','t','e','d',' ','b','e','l','o','w','.','\n',
'\n',
'M','o','d','i','f','i','e','r',' ','K','e','y','s',' ','(','i','n',' ','g','e','n','e','r','a','l',')','\n',
'\n',
' ',' ','C','t','r','l','	',' ','E','x','t','e','n','d','s',' ','t','h','e',' ','s','c','o','p','e',' ','o','f',' ','t','h','e',' ','a','c','t','i','o','n',' ','t','h','a','t',' ','t','h','e',' ','k','e','y','\n',
' ','	',' ','w','o','u','l','d',' ','o','t','h','e','r','w','i','s','e',' ','p','e','r','f','o','r','m','.',' ',' ','F','o','r',' ','e','x','a','m','p','l','e',',',' ','H','o','m','e','\n',
' ','	',' ','n','o','r','m','a','l','l','y',' ','m','o','v','e','s',' ','t','h','e',' ','i','n','s','e','r','t',' ','c','u','r','s','o','r',' ','t','h','e',' ','b','e','g','i','n','n','i','n','g',' ','o','f','\n',
' ','	',' ','a',' ','l','i','n','e','.',' ','C','t','r','l','+','H','o','m','e',' ','m','o','v','e','s',' ','i','t',' ','t','o',' ','t','h','e',' ','b','e','g','i','n','n','i','n','g',' ','o','f','\n',
' ','	',' ','t','h','e',' ','f','i','l','e','.',' ',' ','B','a','c','k','s','p','a','c','e',' ','d','e','l','e','t','e','s',' ','o','n','e',' ','c','h','a','r','a','c','t','e','r',',',' ','C','t','r','l','+','\n',
' ','	',' ','B','a','c','k','s','p','a','c','e',' ','d','e','l','e','t','e','s',' ','o','n','e',' ','w','o','r','d','.','\n',
'\n',
' ',' ','S','h','i','f','t',' ',' ','E','x','t','e','n','d','s',' ','t','h','e',' ','s','e','l','e','c','t','i','o','n',' ','t','o',' ','t','h','e',' ','c','u','r','s','o','r',' ','p','o','s','i','t','i','o','n','.',' ','I','f','\n',
' ','	',' ','t','h','e','r','e',''','s',' ','n','o',' ','s','e','l','e','c','t','i','o','n',',',' ','b','e','g','i','n','s',' ','o','n','e',' ','b','e','t','w','e','e','n',' ','t','h','e',' ','o','l','d','\n',
' ','	',' ','a','n','d',' ','n','e','w',' ','c','u','r','s','o','r',' ','p','o','s','i','t','i','o','n','s','.','\n',
'\n',
' ',' ','A','l','t','	',' ','W','h','e','n',' ','m','o','d','i','f','y','i','n','g',' ','a',' ','s','e','l','e','c','t','i','o','n',',',' ','m','a','k','e','s',' ','t','h','e',' ','s','e','l','e','c','t','i','o','n','\n',
' ','	',' ','r','e','c','t','a','n','g','u','l','a','r','.','\n',
'\n',
'(','F','o','r',' ','t','h','e',' ','e','f','f','e','c','t','s',' ','o','f',' ','m','o','d','i','f','i','e','r',' ','k','e','y','s',' ','o','n',' ','m','o','u','s','e',' ','b','u','t','t','o','n',' ','p','r','e','s','s','e','s',',',' ','s','e','e',' ',
't','h','e',' ','s','e','c','t','i','o','n',' ','t','i','t','l','e','d',' ','\"','U','s','i','n','g',' ','t','h','e',' ','M','o','u','s','e','\"',')','\n',
'\n',
'A','l','l',' ','K','e','y','b','o','a','r','d','s','\n',
'\n',
' ',' ','E','s','c','a','p','e','	','C','a','n','c','e','l','s',' ','o','p','e','r','a','t','i','o','n',' ','i','n',' ','p','r','o','g','r','e','s','s',':',' ','m','e','n','u','\n',
' ',' ','	','	','s','e','l','e','c','t','i','o','n',',',' ','d','r','a','g',',',' ','s','e','l','e','c','t','i','o','n',',',' ','e','t','c','.',' ',' ','A','l','s','o','\n',
' ',' ','	','	','e','q','u','i','v','a','l','e','n','t',' ','t','o',' ','c','a','n','c','e','l',' ','b','u','t','t','o','n',' ','i','n',' ','d','i','a','l','o','g','s','.','\n',
'\n',
' ',' ','B','a','c','k','s','p','a','c','e','	','D','e','l','e','t','e',' ','t','h','e',' ','c','h','a','r','a','c','t','e','r',' ','b','e','f','o','r','e',' ','t','h','e',' ','c','u','r','s','o','r','\n',
'\n',
' ',' ','C','t','r','l','+','B','S','	','D','e','l','e','t','e',' ','t','h','e',' ','w','o','r','d',' ','b','e','f','o','r','e',' ','t','h','e',' ','c','u','r','s','o','r','\n',
'\n',
' ',' ','A','r','r','o','w','s','\n',
'\n',
' ',' ',' ',' ','L','e','f','t','	','M','o','v','e',' ','t','h','e',' ','c','u','r','s','o','r',' ','t','o',' ','t','h','e',' ','l','e','f','t',' ','o','n','e',' ','c','h','a','r','a','c','t','e','r','\n',
'\n',
' ',' ',' ',' ','C','t','r','l','+','L','e','f','t',' ',' ',' ','M','o','v','e',' ','t','h','e',' ','c','u','r','s','o','r',' ','b','a','c','k','w','a','r','d',' ','o','n','e',' ','w','o','r','d','\n',
' ',' ',' ',' ','	','	','(','W','o','r','d',' ','d','e','l','i','m','i','t','e','r','s',' ','a','r','e',' ','s','e','t','t','a','b','l','e',',',' ','s','e','e','\n',
' ',' ',' ',' ','	','	','C','u','s','t','o','m','i','z','i','n','g',' ','N','E','d','i','t',',',' ','a','n','d',' ','X',' ','R','e','s','o','u','r','c','e','s',')','\n',
'\n',
' ',' ',' ',' ','R','i','g','h','t','	','M','o','v','e',' ','t','h','e',' ','c','u','r','s','o','r',' ','t','o',' ','t','h','e',' ','r','i','g','h','t',' ','o','n','e',' ','c','h','a','r','a','c','t','e','r','\n',
'\n',
' ',' ',' ',' ','C','t','r','l','+','R','i','g','h','t',' ',' ','M','o','v','e',' ','t','h','e',' ','c','u','r','s','o','r',' ','f','o','r','w','a','r','d',' ','o','n','e',' ','w','o','r','d','\n',
'\n',
' ',' ',' ',' ','U','p',' ',' ','	','M','o','v','e',' ','t','h','e',' ','c','u','r','s','o','r',' ','u','p',' ','o','n','e',' ','l','i','n','e','\n',
'\n',
' ',' ',' ',' ','C','t','r','l','+','U','p','	','M','o','v','e',' ','t','h','e',' ','c','u','r','s','o','r',' ','u','p',' ','o','n','e',' ','p','a','r','a','g','r','a','p','h','.','\n',
' ',' ',' ',' ','	','	','(','P','a','r','a','g','r','a','p','h','s',' ','a','r','e',' ','d','e','l','i','m','i','t','e','d',' ','b','y',' ','b','l','a','n','k',' ','l','i','n','e','s',')','\n',
'\n',
' ',' ',' ',' ','D','o','w','n','	','M','o','v','e',' ','t','h','e',' ','c','u','r','s','o','r',' ','d','o','w','n',' ','o','n','e',' ','l','i','n','e','.','\n',
'\n',
' ',' ',' ',' ','C','t','r','l','+','D','o','w','n','	','M','o','v','e',' ','t','h','e',' ','c','u','r','s','o','r',' ','d','o','w','n',' ','o','n','e',' ','p','a','r','a','g','r','a','p','h','.','\n',
'\n',
' ',' ','C','t','r','l','+','R','e','t','u','r','n','	','R','e','t','u','r','n',' ','w','i','t','h',' ','a','u','t','o','m','a','t','i','c',' ','i','n','d','e','n','t',',',' ','r','e','g','a','r','d','l','e','s','s','\n',
' ',' ','	','	','o','f',' ','t','h','e',' ','s','e','t','t','i','n','g',' ','o','f',' ','A','u','t','o',' ','I','n','d','e','n','t','.','\n',
'\n',
' ',' ','S','h','i','f','t','+','R','e','t','u','r','n','	','R','e','t','u','r','n',' ','w','i','t','h','o','u','t',' ','a','u','t','o','m','a','t','i','c',' ','i','n','d','e','n','t',',','\n',
' ',' ','	','	','r','e','g','a','r','d','l','e','s','s',' ','o','f',' ','t','h','e',' ','s','e','t','t','i','n','g',' ','o','f',' ','A','u','t','o',' ','I','n','d','e','n','t','.','\n',
'\n',
' ',' ','C','t','r','l','+','T','a','b','	','I','n','s','e','r','t',' ','a','n',' ','a','s','c','i','i',' ','t','a','b',' ','c','h','a','r','a','c','t','e','r',',',' ','w','i','t','h','o','u','t','\n',
' ',' ','	','	','p','r','o','c','e','s','s','i','n','g',' ','e','m','u','l','a','t','e','d',' ','t','a','b','s','.','\n',
'\n',
' ',' ','A','l','t','+','C','t','r','l','+','<','c','>','	','I','n','s','e','r','t',' ','t','h','e',' ','c','o','n','t','r','o','l','-','c','o','d','e',' ','e','q','u','i','v','a','l','e','n','t',' ','o','f','\n',
' ',' ','	','	','a',' ','k','e','y',' ','<','c','>','\n',
'\n',
' ',' ','C','t','r','l','+','/','	','S','e','l','e','c','t',' ','e','v','e','r','y','t','h','i','n','g',' ','(','s','a','m','e',' ','a','s',' ','S','e','l','e','c','t','\n',
' ',' ',' ',' ',' ','	','	','A','l','l',' ','m','e','n','u',' ','i','t','e','m',' ','o','r',' ','^','A',')','\n',
'\n',
' ',' ','C','t','r','l','+','\\','	','U','n','s','e','l','e','c','t','\n',
'\n',
' ',' ','C','t','r','l','+','U','	','D','e','l','e','t','e',' ','t','o',' ','s','t','a','r','t',' ','o','f',' ','l','i','n','e','\n',
'\n',
'P','C',' ','S','t','a','n','d','a','r','d',' ','K','e','y','b','o','a','r','d','\n',
'\n',
' ',' ','C','t','r','l','+','I','n','s','e','r','t','	','C','o','p','y',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','t','o',' ','t','h','e','\n',
' ','	','	','c','l','i','p','b','o','a','r','d',' ','(','s','a','m','e',' ','a','s',' ','C','o','p','y',' ','m','e','n','u',' ','i','t','e','m',' ','o','r',' ','^','C',')','\n',
' ','	','	','f','o','r',' ','c','o','m','p','a','t','i','b','i','l','i','t','y',' ','w','i','t','h',' ','M','o','t','i','f',' ','s','t','a','n','d','a','r','d',' ','k','e','y','\n',
' ','	','	','b','i','n','d','i','n','g','\n',
' ',' ','S','h','i','f','t','+','C','t','r','l','+','\n',
' ',' ','I','n','s','e','r','t','	','C','o','p','y',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','t','o',' ','t','h','e',' ','c','u','r','s','o','r','\n',
' ','	','	','l','o','c','a','t','i','o','n','.','\n',
'\n',
' ',' ','D','e','l','e','t','e','	','D','e','l','e','t','e',' ','t','h','e',' ','c','h','a','r','a','c','t','e','r',' ','b','e','f','o','r','e',' ','t','h','e',' ','c','u','r','s','o','r','.','\n',
' ','	','	','(','C','a','n',' ','b','e',' ','c','o','n','f','i','g','u','r','e','d',' ','t','o',' ','d','e','l','e','t','e',' ','t','h','e',' ','c','h','a','r','a','c','t','e','r','\n',
' ','	','	','a','f','t','e','r',' ','t','h','e',' ','c','u','r','s','o','r',',',' ','s','e','e',' ','C','u','s','t','o','m','i','z','i','n','g',' ','N','E','d','i','t',',','\n',
' ','	','	','a','n','d',' ','X',' ','R','e','s','o','u','r','c','e','s',')','\n',
'\n',
' ',' ','C','t','r','l','+','D','e','l','e','t','e','	','D','e','l','e','t','e',' ','t','o',' ','e','n','d',' ','o','f',' ','l','i','n','e','.','\n',
'\n',
' ',' ','S','h','i','f','t','+','D','e','l','e','t','e','	','C','u','t',',',' ','r','e','m','o','v','e',' ','t','h','e',' ','c','u','r','r','e','n','t','l','y',' ','s','e','l','e','c','t','e','d',' ','t','e','x','t','\n',
' ','	','	','a','n','d',' ','p','l','a','c','e',' ','i','t',' ','i','n',' ','t','h','e',' ','c','l','i','p','b','o','a','r','d','.',' ','(','s','a','m','e',' ','a','s','\n',
' ','	','	','C','u','t',' ','m','e','n','u',' ','i','t','e','m',' ','o','r',' ','^','X',')',' ','f','o','r',' ','c','o','m','p','a','t','i','b','i','l','i','t','y','\n',
' ','	','	','w','i','t','h',' ','M','o','t','i','f',' ','s','t','a','n','d','a','r','d',' ','k','e','y',' ','b','i','n','d','i','n','g','\n',
' ',' ','S','h','i','f','t','+','C','t','r','l','+','\n',
' ',' ','D','e','l','e','t','e','	','C','u','t',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','t','o',' ','t','h','e',' ','c','u','r','s','o','r','\n',
' ','	','	','l','o','c','a','t','i','o','n','.','\n',
'\n',
' ',' ','H','o','m','e','	','	','M','o','v','e',' ','t','h','e',' ','c','u','r','s','o','r',' ','t','o',' ','t','h','e',' ','b','e','g','i','n','n','i','n','g',' ','o','f',' ','t','h','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ','l','i','n','e','\n',
'\n',
' ',' ','C','t','r','l','+','H','o','m','e','	','M','o','v','e',' ','t','h','e',' ','c','u','r','s','o','r',' ','t','o',' ','t','h','e',' ','b','e','g','i','n','n','i','n','g',' ','o','f',' ','t','h','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ','f','i','l','e','\n',
'\n',
' ',' ','E','n','d','	','	','M','o','v','e',' ','t','h','e',' ','c','u','r','s','o','r',' ','t','o',' ','t','h','e',' ','e','n','d',' ','o','f',' ','t','h','e',' ','l','i','n','e','\n',
'\n',
' ',' ','C','t','r','l','+','E','n','d','	','M','o','v','e',' ','t','h','e',' ','c','u','r','s','o','r',' ','t','o',' ','t','h','e',' ','e','n','d',' ','o','f',' ','t','h','e',' ','f','i','l','e','\n',
'\n',
' ',' ','P','a','g','e','U','p','	','S','c','r','o','l','l',' ','a','n','d',' ','m','o','v','e',' ','t','h','e',' ','c','u','r','s','o','r',' ','u','p',' ','b','y',' ','o','n','e',' ','p','a','g','e','.','\n',
'\n',
' ',' ','C','t','r','l','+','P','a','g','e','U','p',' ',' ',' ','S','c','r','o','l','l',' ','a','n','d',' ','m','o','v','e',' ','t','h','e',' ','c','u','r','s','o','r',' ','l','e','f','t',' ','b','y',' ','o','n','e','\n',
' ',' ','	','	','p','a','g','e','.','\n',
' ',' ','P','a','g','e','D','o','w','n','	','S','c','r','o','l','l',' ','a','n','d',' ','m','o','v','e',' ','t','h','e',' ','c','u','r','s','o','r',' ','d','o','w','n',' ','b','y',' ','o','n','e','\n',
' ',' ','	','	','p','a','g','e','.','\n',
'\n',
' ',' ','C','t','r','l','+','P','a','g','e','D','o','w','n',' ','S','c','r','o','l','l',' ','a','n','d',' ','m','o','v','e',' ','t','h','e',' ','c','u','r','s','o','r',' ','r','i','g','h','t',' ','b','y',' ','o','n','e','\n',
' ',' ','	','	','p','a','g','e','.','\n',
'\n',
' ',' ','F','1','0','	','	','M','a','k','e',' ','t','h','e',' ','m','e','n','u',' ','b','a','r',' ','a','c','t','i','v','e',' ','f','o','r',' ','k','e','y','b','o','a','r','d','\n',
' ',' ','	','	','i','n','p','u','t',' ','(','A','r','r','o','w',' ','K','e','y','s',',',' ','R','e','t','u','r','n',',',' ','E','s','c','a','p','e',',','\n',
' ',' ','	','	','a','n','d',' ','t','h','e',' ','S','p','a','c','e',' ','B','a','r',')','\n',
'\n',
'S','p','e','c','i','a','l','t','y',' ','K','e','y','b','o','a','r','d','s',' ','\n',
'\n',
'O','n',' ','m','a','c','h','i','n','e','s',' ','w','i','t','h',' ','d','i','f','f','e','r','e','n','t',' ','s','t','y','l','e','s',' ','o','f',' ','k','e','y','b','o','a','r','d','s',',',' ','g','e','n','e','r','a','l','l','y',',',' ','t','e','x','t',' ',
'e','d','i','t','i','n','g',' ','a','c','t','i','o','n','s',' ','a','r','e',' ','p','r','o','p','e','r','l','y',' ','m','a','t','c','h','e','d',' ','t','o',' ','t','h','e',' ','l','a','b','e','l','e','d',' ','k','e','y','s',',',' ','s','u','c','h',' ','a','s',' ',
'R','e','m','o','v','e',',',' ','N','e','x','t','-','s','c','r','e','e','n',',',' ','e','t','c','.','.',' ',' ','I','f',' ','y','o','u',' ','p','r','e','f','e','r',' ','d','i','f','f','e','r','e','n','t',' ','k','e','y',' ','b','i','n','d','i','n','g','s',',',' ','s','e','e',' ',
't','h','e',' ','s','e','c','t','i','o','n',' ','t','i','t','l','e','d',' ','\"','K','e','y',' ','B','i','n','d','i','n','g','\"',' ','u','n','d','e','r',' ','t','h','e',' ','C','u','s','t','o','m','i','z','i','n','g',' ',
'h','e','a','d','i','n','g',' ','i','n',' ','t','h','e',' ','H','e','l','p',' ','m','e','n','u','.','\0'};

static char AuxString11[] = {'S','h','i','f','t','i','n','g',' ','a','n','d',' ','F','i','l','l','i','n','g','\n',
'\n',
'\n',
'S','h','i','f','t',' ','L','e','f','t',',',' ','S','h','i','f','t',' ','R','i','g','h','t',' ','\n',
'\n',
'W','h','i','l','e',' ','s','h','i','f','t','i','n','g',' ','b','l','o','c','k','s',' ','o','f',' ','t','e','x','t',' ','i','s',' ','m','o','s','t',' ','i','m','p','o','r','t','a','n','t',' ','f','o','r',' ','p','r','o','g','r','a','m','m','e','r','s',' ','(','S','e','e',' ',
'F','e','a','t','u','r','e','s',' ','f','o','r',' ','P','r','o','g','r','a','m','m','i','n','g',')',',',' ','i','t',' ','i','s',' ','a','l','s','o',' ','u','s','e','f','u','l',' ','f','o','r',' ','o','t','h','e','r',' ','t','a','s','k','s',',',' ','s','u','c','h',' ','a','s',' ',
'c','r','e','a','t','i','n','g',' ','i','n','d','e','n','t','e','d',' ','p','a','r','a','g','r','a','p','h','s','.','\n',
'\n',
'T','o',' ','s','h','i','f','t',' ','a',' ','b','l','o','c','k',' ','o','f',' ','t','e','x','t',' ','o','n','e',' ','t','a','b',' ','s','t','o','p',' ','t','o',' ','t','h','e',' ','r','i','g','h','t',',',' ','s','e','l','e','c','t',' ','t','h','e',' ','t','e','x','t',',',' ',
't','h','e','n',' ','c','h','o','o','s','e',' ','S','h','i','f','t',' ','R','i','g','h','t',' ','f','r','o','m',' ','t','h','e',' ','E','d','i','t',' ','m','e','n','u','.',' ',' ','N','o','t','e',' ','t','h','a','t',' ','t','h','e',' ','a','c','c','e','l','e','r','a','t','o','r',' ',
'k','e','y','s',' ','f','o','r',' ','t','h','e','s','e',' ','m','e','n','u',' ','i','t','e','m','s',' ','a','r','e',' ','C','t','r','l','+','9',' ','a','n','d',' ','C','t','r','l','+','0',',',' ','w','h','i','c','h',' ','c','o','r','r','e','s','p','o','n','d',' ','t','o',' ',
't','h','e',' ','r','i','g','h','t',' ','a','n','d',' ','l','e','f','t',' ','p','a','r','e','n','t','h','e','s','i','s',' ','o','n',' ','m','o','s','t',' ','k','e','y','b','o','a','r','d','s','.',' ',' ','R','e','m','e','m','b','e','r',' ','t','h','e','m',' ','a','s',' ',
'a','d','j','u','s','t','i','n','g',' ','t','h','e',' ','t','e','x','t',' ','i','n',' ','t','h','e',' ','d','i','r','e','c','t','i','o','n',' ','p','o','i','n','t','e','d',' ','t','o',' ','b','y',' ','t','h','e',' ','p','a','r','e','n','t','h','e','s','i','s',' ',
'c','h','a','r','a','c','t','e','r','.',' ',' ','H','o','l','d','i','n','g',' ','t','h','e',' ','S','h','i','f','t',' ','k','e','y',' ','w','h','i','l','e',' ','s','e','l','e','c','t','i','n','g',' ','e','i','t','h','e','r',' ','S','h','i','f','t',' ','L','e','f','t',' ','o','r',' ',
'S','h','i','f','t',' ','R','i','g','h','t',' ','w','i','l','l',' ','s','h','i','f','t',' ','t','h','e',' ','t','e','x','t',' ','b','y',' ','o','n','e',' ','c','h','a','r','a','c','t','e','r','.','\n',
'\n',
'I','t',' ','i','s',' ','a','l','s','o',' ','p','o','s','s','i','b','l','e',' ','t','o',' ','s','h','i','f','t',' ','b','l','o','c','k','s',' ','o','f',' ','t','e','x','t',' ','b','y',' ','s','e','l','e','c','t','i','n','g',' ','t','h','e',' ','t','e','x','t',' ',
'r','e','c','t','a','n','g','u','l','a','r','l','y',',',' ','a','n','d',' ','d','r','a','g','g','i','n','g',' ','i','t',' ','l','e','f','t',' ','o','r',' ','r','i','g','h','t',' ','(','a','n','d',' ','u','p',' ','o','r',' ','d','o','w','n',' ','a','s',' ','w','e','l','l',')','.',' ',' ',
'U','s','i','n','g',' ','a',' ','r','e','c','t','a','n','g','u','l','a','r',' ','s','e','l','e','c','t','i','o','n',' ','a','l','s','o',' ','c','a','u','s','e','s',' ','t','a','b','s',' ','w','i','t','h','i','n',' ','t','h','e',' ','s','e','l','e','c','t','i','o','n',' ','t','o',' ',
'b','e',' ','r','e','c','a','l','c','u','l','a','t','e','d',' ','a','n','d',' ','s','u','b','s','t','i','t','u','t','e','d',',',' ','s','u','c','h',' ','t','h','a','t',' ','t','h','e',' ','n','o','n','-','w','h','i','t','e','s','p','a','c','e',' ','c','h','a','r','a','c','t','e','r','s',' ',
'r','e','m','a','i','n',' ','s','t','a','t','i','o','n','a','r','y',' ','w','i','t','h',' ','r','e','s','p','e','c','t',' ','t','o',' ','t','h','e',' ','s','e','l','e','c','t','i','o','n','.','\n',
'\n',
'\n',
'F','i','l','l','i','n','g',' ','\n',
'\n',
'T','e','x','t',' ','f','i','l','l','i','n','g',' ','u','s','i','n','g',' ','t','h','e',' ','F','i','l','l',' ','P','a','r','a','g','r','a','p','h',' ','c','o','m','m','a','n','d',' ','i','n',' ','t','h','e',' ','E','d','i','t',' ','m','e','n','u',' ','i','s',' ','o','n','e',' ',
'o','f',' ','t','h','e',' ','m','o','s','t',' ','i','m','p','o','r','t','a','n','t',' ','c','o','n','c','e','p','t','s',' ','i','n',' ','N','E','d','i','t','.',' ',' ','A','n','d',' ','i','t',' ','w','i','l','l',' ','b','e',' ','w','e','l','l',' ','w','o','r','t','h',' ',
'y','o','u','r',' ','w','h','i','l','e',' ','t','o',' ','u','n','d','e','r','s','t','a','n','d',' ','h','o','w',' ','t','o',' ','u','s','e',' ','i','t',' ','p','r','o','p','e','r','l','y','.','\n',
'\n',
'I','n',' ','p','l','a','i','n',' ','t','e','x','t',' ','f','i','l','e','s',',',' ','u','n','l','i','k','e',' ','w','o','r','d','-','p','r','o','c','e','s','s','o','r',' ','f','i','l','e','s',',',' ','t','h','e','r','e',' ','i','s',' ','n','o',' ','w','a','y',' ','t','o',' ',
't','e','l','l',' ','w','h','i','c','h',' ','l','i','n','e','s',' ','a','r','e',' ','c','o','n','t','i','n','u','a','t','i','o','n','s',' ','o','f',' ','o','t','h','e','r',' ','l','i','n','e','s',',',' ','a','n','d',' ','w','h','i','c','h',' ','l','i','n','e','s',' ','a','r','e',' ',
'm','e','a','n','t',' ','t','o',' ','b','e',' ','s','e','p','a','r','a','t','e',',',' ','b','e','c','a','u','s','e',' ','t','h','e','r','e',' ','i','s',' ','n','o',' ','d','i','s','t','i','n','c','t','i','o','n',' ','i','n',' ','m','e','a','n','i','n','g',' ',
'b','e','t','w','e','e','n',' ','n','e','w','l','i','n','e',' ','c','h','a','r','a','c','t','e','r','s',' ','w','h','i','c','h',' ','s','e','p','a','r','a','t','e',' ','l','i','n','e','s',' ','i','n',' ','a',' ','p','a','r','a','g','r','a','p','h',',',' ','a','n','d',' ',
'o','n','e','s',' ','w','h','i','c','h',' ','s','e','p','a','r','a','t','e',' ','p','a','r','a','g','r','a','p','h','s',' ','f','r','o','m',' ','o','t','h','e','r',' ','t','e','x','t','.',' ',' ','T','h','i','s',' ','m','a','k','e','s',' ','i','t',' ',
'i','m','p','o','s','s','i','b','l','e',' ','f','o','r',' ','a',' ','t','e','x','t',' ','e','d','i','t','o','r',' ','l','i','k','e',' ','N','E','d','i','t',' ','t','o',' ','t','e','l','l',' ','p','a','r','t','s',' ','o','f',' ','t','h','e',' ','t','e','x','t',' ',
'w','h','i','c','h',' ','b','e','l','o','n','g',' ','t','o','g','e','t','h','e','r',' ','a','s',' ','a',' ','p','a','r','a','g','r','a','p','h',' ','f','r','o','m',' ','c','a','r','e','f','u','l','l','y',' ','a','r','r','a','n','g','e','d',' ',
'i','n','d','i','v','i','d','u','a','l',' ','l','i','n','e','s','.','\n',
'\n',
'I','n',' ','c','o','n','t','i','n','u','o','u','s',' ','w','r','a','p',' ','m','o','d','e',' ','(','P','r','e','f','e','r','e','n','c','e','s',' ','-','>',' ','W','r','a','p',' ','-','>',' ','C','o','n','t','i','n','u','o','u','s',')',',',' ','l','i','n','e','s',' ',
'a','u','t','o','m','a','t','i','c','a','l','l','y',' ','w','r','a','p',' ','a','n','d',' ','u','n','w','r','a','p',' ','t','h','e','m','s','e','l','v','e','s',' ','t','o',' ','l','i','n','e',' ','u','p',' ','p','r','o','p','e','r','l','y',' ','a','t',' ','t','h','e',' ',
'r','i','g','h','t',' ','m','a','r','g','i','n','.',' ',' ','I','n',' ','t','h','i','s',' ','m','o','d','e',',',' ','y','o','u',' ','s','i','m','p','l','y',' ','o','m','i','t',' ','t','h','e',' ','n','e','w','l','i','n','e','s',' ','w','i','t','h','i','n',' ',
'p','a','r','a','g','r','a','p','h','s',' ','a','n','d',' ','l','e','t',' ','N','E','d','i','t',' ','m','a','k','e',' ','t','h','e',' ','l','i','n','e',' ','b','r','e','a','k','s',' ','a','s',' ','n','e','e','d','e','d','.',' ',' ','U','n','f','o','r','t','u','n','a','t','e','l','y',',',' ',
'c','o','n','t','i','n','u','o','u','s',' ','w','r','a','p',' ','m','o','d','e',' ','i','s',' ','n','o','t',' ','a','p','p','r','o','p','r','i','a','t','e',' ','i','n',' ','t','h','e',' ','m','a','j','o','r','i','t','y',' ','o','f',' ','s','i','t','u','a','t','i','o','n','s',',',' ',
'b','e','c','a','u','s','e',' ','f','i','l','e','s',' ','w','i','t','h',' ','e','x','t','r','e','m','e','l','y',' ','l','o','n','g',' ','l','i','n','e','s',' ','a','r','e',' ','n','o','t',' ','c','o','m','m','o','n',' ','u','n','d','e','r',' ','U','n','i','x',' ','a','n','d',' ',
'm','a','y',' ','n','o','t',' ','b','e',' ','c','o','m','p','a','t','i','b','l','e',' ','w','i','t','h',' ','a','l','l',' ','t','o','o','l','s',',',' ','a','n','d',' ','b','e','c','a','u','s','e',' ','y','o','u',' ','c','a','n',''','t',' ','a','c','h','i','e','v','e',' ',
'e','f','f','e','c','t','s',' ','l','i','k','e',' ','i','n','d','e','n','t','e','d',' ','s','e','c','t','i','o','n','s',',',' ','c','o','l','u','m','n','s',',',' ','o','r',' ','p','r','o','g','r','a','m',' ','c','o','m','m','e','n','t','s',',',' ','a','n','d',' ','s','t','i','l','l',' ',
't','a','k','e',' ','a','d','v','a','n','t','a','g','e',' ','o','f',' ','t','h','e',' ','a','u','t','o','m','a','t','i','c',' ','w','r','a','p','p','i','n','g','.','\n',
'\n',
'W','i','t','h','o','u','t',' ','c','o','n','t','i','n','u','o','u','s',' ','w','r','a','p','p','i','n','g',',',' ','p','a','r','a','g','r','a','p','h',' ','f','i','l','l','i','n','g',' ','i','s',' ','n','o','t',' ','e','n','t','i','r','e','l','y',' ',
'a','u','t','o','m','a','t','i','c','.',' ',' ','A','u','t','o','-','N','e','w','l','i','n','e',' ','w','r','a','p','p','i','n','g',' ','k','e','e','p','s',' ','p','a','r','a','g','r','a','p','h','s',' ','l','i','n','e','d',' ','u','p',' ','a','s',' ','y','o','u',' ',
't','y','p','e',',',' ','b','u','t',' ','o','n','c','e',' ','e','n','t','e','r','e','d',',',' ','N','E','d','i','t',' ','c','a','n',' ','n','o',' ','l','o','n','g','e','r',' ','d','i','s','t','i','n','g','u','i','s','h',' ','n','e','w','l','i','n','e','s',' ','w','h','i','c','h',' ',
'j','o','i','n',' ','w','r','a','p','p','e','d',' ','t','e','x','t',',',' ','a','n','d',' ','n','e','w','l','i','n','e','s',' ','w','h','i','c','h',' ','m','u','s','t',' ','b','e',' ','p','r','e','s','e','r','v','e','d','.',' ',' ','T','h','e','r','e','f','o','r','e',',',' ',
'e','d','i','t','i','n','g',' ','i','n',' ','t','h','e',' ','m','i','d','d','l','e',' ','o','f',' ','a',' ','p','a','r','a','g','r','a','p','h',' ','w','i','l','l',' ','o','f','t','e','n',' ','l','e','a','v','e',' ','t','h','e',' ','r','i','g','h','t',' ','m','a','r','g','i','n',' ',
'm','e','s','s','y',' ','a','n','d',' ','u','n','e','v','e','n','.','\n',
'\n',
'S','i','n','c','e',' ','N','E','d','i','t',' ','c','a','n',''','t',' ','a','c','t',' ','a','u','t','o','m','a','t','i','c','a','l','l','y',' ','t','o',' ','k','e','e','p',' ','y','o','u','r',' ','t','e','x','t',' ','l','i','n','e','d',' ','u','p',',',' ','y','o','u',' ',
'n','e','e','d',' ','t','o',' ','t','e','l','l',' ','i','t',' ','e','x','p','l','i','c','i','t','l','y',' ','w','h','e','r','e',' ','t','o',' ','o','p','e','r','a','t','e',',',' ','a','n','d',' ','t','h','a','t',' ','i','s',' ','w','h','a','t',' ','F','i','l','l',' ',
'P','a','r','a','g','r','a','p','h',' ','i','s',' ','f','o','r','.',' ',' ','I','t',' ','a','r','r','a','n','g','e','s',' ','l','i','n','e','s',' ','t','o',' ','f','i','l','l',' ','t','h','e',' ','s','p','a','c','e',' ','b','e','t','w','e','e','n',' ','t','w','o',' ',
'm','a','r','g','i','n','s',',',' ','w','r','a','p','p','i','n','g',' ','t','h','e',' ','l','i','n','e','s',' ','n','e','a','t','l','y',' ','a','t',' ','w','o','r','d',' ','b','o','u','n','d','a','r','i','e','s','.',' ',' ','N','o','r','m','a','l','l','y',',',' ','t','h','e',' ',
'l','e','f','t',' ','m','a','r','g','i','n',' ','f','o','r',' ','f','i','l','l','i','n','g',' ','i','s',' ','i','n','f','e','r','r','e','d',' ','f','r','o','m',' ','t','h','e',' ','t','e','x','t',' ','b','e','i','n','g',' ','f','i','l','l','e','d','.',' ',' ','T','h','e',' ',
'f','i','r','s','t',' ','l','i','n','e',' ','o','f',' ','e','a','c','h',' ','p','a','r','a','g','r','a','p','h',' ','i','s',' ','c','o','n','s','i','d','e','r','e','d',' ','s','p','e','c','i','a','l',',',' ','a','n','d',' ','i','t','s',' ','l','e','f','t',' ',
'i','n','d','e','n','t','a','t','i','o','n',' ','i','s',' ','m','a','i','n','t','a','i','n','e','d',' ','s','e','p','a','r','a','t','e','l','y',' ','f','r','o','m',' ','t','h','e',' ','r','e','m','a','i','n','i','n','g',' ','l','i','n','e','s',' ','(','f','o','r',' ',
'l','e','a','d','i','n','g',' ','i','n','d','e','n','t','s',',',' ','b','u','l','l','e','t',' ','p','o','i','n','t','s',',',' ','n','u','m','b','e','r','e','d',' ','p','a','r','a','g','r','a','p','h','s',',',' ','e','t','c','.',')','.',' ',' ','O','t','h','e','r','w','i','s','e',',',' ',
't','h','e',' ','l','e','f','t',' ','m','a','r','g','i','n',' ','i','s',' ','d','e','t','e','r','m','i','n','e','d',' ','b','y',' ','t','h','e',' ','f','u','r','t','h','e','s','t',' ','l','e','f','t',' ','n','o','n','-','w','h','i','t','e','s','p','a','c','e',' ',
'c','h','a','r','a','c','t','e','r','.',' ',' ','T','h','e',' ','r','i','g','h','t',' ','m','a','r','g','i','n',' ','i','s',' ','e','i','t','h','e','r',' ','t','h','e',' ','W','r','a','p',' ','M','a','r','g','i','n',',',' ','s','e','t',' ','i','n',' ','t','h','e',' ',
'p','r','e','f','e','r','e','n','c','e','s',' ','m','e','n','u',' ','(','b','y',' ','d','e','f','a','u','l','t',',',' ','t','h','e',' ','r','i','g','h','t',' ','e','d','g','e',' ','o','f',' ','t','h','e',' ','w','i','n','d','o','w',')',',',' ','o','r',' ','c','a','n',' ',
'a','l','s','o',' ','b','e',' ','c','h','o','s','e','n',' ','o','n',' ','t','h','e',' ','f','l','y',' ','b','y',' ','u','s','i','n','g',' ','a',' ','r','e','c','t','a','n','g','u','l','a','r',' ','s','e','l','e','c','t','i','o','n',' ','(','s','e','e',' ','b','e','l','o','w',')','.','\n',
'\n',
'T','h','e','r','e',' ','a','r','e',' ','t','h','r','e','e',' ','w','a','y','s',' ','t','o',' ','u','s','e',' ','F','i','l','l',' ','P','a','r','a','g','r','a','p','h','.',' ',' ','T','h','e',' ','s','i','m','p','l','e','s','t',' ','i','s',',',' ','w','h','i','l','e',' ','y','o','u',' ',
'a','r','e',' ','t','y','p','i','n','g',' ','t','e','x','t',',',' ','a','n','d',' ','t','h','e','r','e',' ','i','s',' ','n','o',' ','s','e','l','e','c','t','i','o','n',',',' ','s','i','m','p','l','y',' ','s','e','l','e','c','t',' ','F','i','l','l',' ','P','a','r','a','g','r','a','p','h',' ',
'(','o','r',' ','t','y','p','e',' ','C','t','r','l','+','J',')',',',' ','a','n','d',' ','N','E','d','i','t',' ','w','i','l','l',' ','a','r','r','a','n','g','e',' ','t','h','e',' ','t','e','x','t',' ','i','n',' ','t','h','e',' ','p','a','r','a','g','r','a','p','h',' ',
'a','d','j','a','c','e','n','t',' ','t','o',' ','t','h','e',' ','c','u','r','s','o','r','.',' ',' ','A',' ','p','a','r','a','g','r','a','p','h',',',' ','i','n',' ','t','h','i','s',' ','c','a','s','e',',',' ','m','e','a','n','s',' ','a','n',' ','a','r','e','a',' ','o','f',' ',
't','e','x','t',' ','d','e','l','i','m','i','t','e','d',' ','b','y',' ','b','l','a','n','k',' ','l','i','n','e','s','.','\n',
'\n',
'T','h','e',' ','s','e','c','o','n','d',' ','w','a','y',' ','t','o',' ','u','s','e',' ','F','i','l','l',' ','P','a','r','a','g','r','a','p','h',' ','i','s',' ','w','i','t','h',' ','a',' ','s','e','l','e','c','t','i','o','n','.',' ',' ','I','f',' ','y','o','u',' ','s','e','l','e','c','t',' ',
'a',' ','r','a','n','g','e',' ','o','f',' ','t','e','x','t',' ','a','n','d',' ','t','h','e','n',' ','c','h','o','s','e',' ','F','i','l','l',' ','P','a','r','a','g','r','a','p','h',',',' ','a','l','l',' ','o','f',' ','t','h','e',' ','t','e','x','t',' ','i','n',' ','t','h','e',' ',
's','e','l','e','c','t','i','o','n',' ','w','i','l','l',' ','b','e',' ','f','i','l','l','e','d','.',' ',' ','A','g','a','i','n',',',' ','c','o','n','t','i','n','u','o','u','s',' ','t','e','x','t',' ','b','e','t','w','e','e','n',' ','b','l','a','n','k',' ','l','i','n','e','s',' ','i','s',' ',
'i','n','t','e','r','p','r','e','t','e','d',' ','a','s',' ','p','a','r','a','g','r','a','p','h','s',' ','a','n','d',' ','f','i','l','l','e','d',' ','i','n','d','i','v','i','d','u','a','l','l','y',',',' ','r','e','s','p','e','c','t','i','n','g',' ','l','e','a','d','i','n','g',' ',
'i','n','d','e','n','t','s',' ','a','n','d',' ','b','l','a','n','k',' ','l','i','n','e','s','.','\n',
'\n',
'T','h','e',' ','t','h','i','r','d',',',' ','a','n','d',' ','m','o','s','t',' ','v','e','r','s','i','t','i','l','e',',',' ','w','a','y',' ','t','o',' ','u','s','e',' ','F','i','l','l',' ','P','a','r','a','g','r','a','p','h',' ','i','s',' ','w','i','t','h',' ','a',' ',
'r','e','c','t','a','n','g','u','l','a','r',' ','s','e','l','e','c','t','i','o','n','.',' ',' ','F','i','l','l',' ','P','a','r','a','g','r','a','p','h',' ','t','r','e','a','t','s',' ','r','e','c','t','a','n','g','u','l','a','r',' ','s','e','l','e','c','t','i','o','n','s',' ',
'd','i','f','f','e','r','e','n','t','l','y',' ','f','r','o','m',' ','o','t','h','e','r',' ','c','o','m','m','a','n','d','s','.',' ',' ','I','n','s','t','e','a','d',' ','o','f',' ','s','i','m','p','l','y',' ','f','i','l','l','i','n','g',' ','t','h','e',' ','t','e','x','t',' ',
'i','n','s','i','d','e',' ','t','h','e',' ','r','e','c','t','a','n','g','u','l','a','r',' ','s','e','l','e','c','t','i','o','n',',',' ','N','E','d','i','t',' ','i','n','t','e','r','p','r','e','t','s',' ','t','h','e',' ','r','i','g','h','t',' ','e','d','g','e',' ','o','f',' ',
't','h','e',' ','s','e','l','e','c','t','i','o','n',' ','a','s',' ','t','h','e',' ','r','e','q','u','e','s','t','e','d',' ','w','r','a','p',' ','m','a','r','g','i','n','.',' ',' ','T','e','x','t',' ','t','o',' ','t','h','e',' ','l','e','f','t',' ','o','f',' ','t','h','e',' ',
's','e','l','e','c','t','i','o','n',' ','i','s',' ','n','o','t',' ','d','i','s','t','u','r','b','e','d',' ','(','t','h','e',' ','u','s','u','a','l',' ','i','n','t','e','r','p','r','e','t','a','t','i','o','n',' ','o','f',' ','a',' ','r','e','c','t','a','n','g','u','l','a','r',' ',
's','e','l','e','c','t','i','o','n',')',',',' ','b','u','t',' ','t','e','x','t',' ','t','o',' ','t','h','e',' ','r','i','g','h','t',' ','o','f',' ','t','h','e',' ','s','e','l','e','c','t','i','o','n',' ','i','s',' ','i','n','c','l','u','d','e','d',' ','i','n',' ','t','h','e',' ',
'o','p','e','r','a','t','i','o','n',' ','a','n','d',' ','i','s',' ','p','u','l','l','e','d',' ','i','n',' ','t','o',' ','t','h','e',' ','s','e','l','e','c','t','e','d',' ','r','e','g','i','o','n','.',' ',' ','T','h','i','s',' ','m','e','t','h','o','d',' ','e','n','a','b','l','e','s',' ','y','o','u',' ',
't','o',' ','f','i','l','l',' ','t','e','x','t',' ','t','o',' ','a','n',' ','a','r','b','i','t','r','a','r','y',' ','r','i','g','h','t',' ','m','a','r','g','i','n',',',' ','w','i','t','h','o','u','t',' ','g','o','i','n','g',' ','b','a','c','k',' ','a','n','d',' ','f','o','r','t','h',' ',
't','o',' ','t','h','e',' ','w','r','a','p','-','m','a','r','g','i','n',' ','d','i','a','l','o','g',',',' ','a','s',' ','w','e','l','l',' ','a','s',' ','t','o',' ','e','x','c','l','u','d','e',' ','t','e','x','t',' ','t','o',' ','t','h','e',' ','l','e','f','t',' ','o','f',' ',
't','h','e',' ','s','e','l','e','c','t','i','o','n',' ','s','u','c','h',' ','a','s',' ','c','o','m','m','e','n','t',' ','b','a','r','s',' ','o','r',' ','o','t','h','e','r',' ','t','e','x','t',' ','c','o','l','u','m','n','s','.','\0'};

static char AuxString12[] = {'S','y','n','t','a','x',' ','H','i','g','h','l','i','g','h','t','i','n','g',' ','m','e','a','n','s',' ','u','s','i','n','g',' ','c','o','l','o','r','s',' ','a','n','d',' ','f','o','n','t','s',' ','t','o',' ','h','e','l','p',' ','d','i','s','t','i','n','g','u','i','s','h',' ',
'l','a','n','g','u','a','g','e',' ','e','l','e','m','e','n','t','s',' ','i','n',' ','p','r','o','g','r','a','m','m','i','n','g',' ','l','a','n','g','u','a','g','e','s',' ','a','n','d',' ','o','t','h','e','r',' ','t','y','p','e','s',' ','o','f',' ',
's','t','r','u','c','t','u','r','e','d',' ','f','i','l','e','s','.',' ',' ','P','r','o','g','r','a','m','m','e','r','s',' ','u','s','e',' ','s','y','n','t','a','x',' ','h','i','g','h','l','i','g','h','t','i','n','g',' ','t','o',' ','u','n','d','e','r','s','t','a','n','d',' ',
'c','o','d','e',' ','f','a','s','t','e','r',' ','a','n','d',' ','b','e','t','t','e','r',',',' ','a','n','d',' ','t','o',' ','s','p','o','t',' ','m','a','n','y',' ','k','i','n','d','s',' ','o','f',' ','s','y','n','t','a','x',' ','e','r','r','o','r','s',' ','m','o','r','e',' ',
'q','u','i','c','k','l','y','.','\n',
'\n',
'T','o',' ','u','s','e',' ','s','y','n','t','a','x',' ','h','i','g','h','l','i','g','h','t','i','n','g',' ','i','n',' ','N','E','d','i','t',',',' ','s','e','l','e','c','t',' ','H','i','g','h','l','i','g','h','t',' ','S','y','n','t','a','x',' ','i','n',' ','t','h','e',' ',
'P','r','e','f','e','r','e','n','c','e','s',' ','m','e','n','u','.',' ',' ','I','f',' ','N','E','d','i','t',' ','r','e','c','o','g','n','i','z','e','s',' ','t','h','e',' ','c','o','m','p','u','t','e','r',' ','l','a','n','g','u','a','g','e',' ','t','h','a','t',' ','y','o','u',' ',
'a','r','e',' ','u','s','i','n','g',',',' ','a','n','d',' ','h','i','g','h','l','i','g','h','t','i','n','g',' ','r','u','l','e','s',' ','(','p','a','t','t','e','r','n','s',')',' ','a','r','e',' ','a','v','a','i','l','a','b','l','e',' ','f','o','r',' ','t','h','a','t',' ',
'l','a','n','g','u','a','g','e',',',' ','i','t',' ','w','i','l','l',' ','h','i','g','h','l','i','g','h','t',' ','y','o','u','r',' ','t','e','x','t',',',' ','a','n','d',' ','m','a','i','n','t','a','i','n',' ','t','h','e',' ','h','i','g','h','l','i','g','h','t','i','n','g',',',' ',
'a','u','t','o','m','a','t','i','c','a','l','l','y',',',' ','a','s',' ','y','o','u',' ','t','y','p','e','.','\n',
'\n',
'I','f',' ','N','E','d','i','t',' ','d','o','e','s','n',''','t',' ','c','o','r','r','e','c','t','l','y',' ','r','e','c','o','g','n','i','z','e',' ','t','h','e',' ','t','y','p','e',' ','o','f',' ','t','h','e',' ','f','i','l','e',' ','y','o','u',' ','a','r','e',' ',
'e','d','i','t','i','n','g',',',' ','y','o','u',' ','c','a','n',' ','m','a','n','u','a','l','l','y',' ','s','e','l','e','c','t',' ','a',' ','l','a','n','g','u','a','g','e',' ','m','o','d','e',' ','f','r','o','m',' ','L','a','n','g','u','a','g','e',' ','M','o','d','e','s',' ','i','n',' ',
't','h','e',' ','P','r','e','f','e','r','e','n','c','e','s',' ','m','e','n','u','.',' ',' ','Y','o','u',' ','c','a','n',' ','a','l','s','o',' ','p','r','o','g','r','a','m',' ','t','h','e',' ','m','e','t','h','o','d',' ','t','h','a','t',' ','N','E','d','i','t',' ','u','s','e','s',' ',
't','o',' ','r','e','c','o','g','n','i','z','e',' ','l','a','n','g','u','a','g','e',' ','m','o','d','e','s',' ','i','n',' ','P','r','e','f','e','r','e','n','c','e','s',' ','-','>',' ','D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s',' ','-','>',' ',
'L','a','n','g','u','a','g','e',' ','M','o','d','e','s','.','.','.','.','\n',
'\n',
'I','f',' ','n','o',' ','h','i','g','h','l','i','g','h','t','i','n','g',' ','p','a','t','t','e','r','n','s',' ','a','r','e',' ','a','v','a','i','l','a','b','l','e',' ','f','o','r',' ','t','h','e',' ','l','a','n','g','u','a','g','e',' ','t','h','a','t',' ','y','o','u',' ',
'w','a','n','t',' ','t','o',' ','u','s','e',',',' ','y','o','u',' ','c','a','n',' ','c','r','e','a','t','e',' ','n','e','w',' ','p','a','t','t','e','r','n','s',' ','r','e','l','a','t','i','v','e','l','y',' ','q','u','i','c','k','l','y','.',' ',' ','T','h','e',' ',
'H','e','l','p',' ','s','e','c','t','i','o','n',' ','\"','H','i','g','h','l','i','g','h','t','i','n','g',' ','P','a','t','t','e','r','n','s','\"',' ','u','n','d','e','r',' ','\"','C','u','s','t','o','m','i','z','i','n','g','\"',',',' ','h','a','s',' ','d','e','t','a','i','l','s','.','\n',
'\n',
'I','f',' ','y','o','u',' ','a','r','e',' ','s','a','t','i','s','f','i','e','d',' ','w','i','t','h',' ','w','h','a','t',' ','N','E','d','i','t',' ','i','s',' ','h','i','g','h','l','i','g','h','t','i','n','g',',',' ','b','u','t',' ','w','o','u','l','d',' ','l','i','k','e',' ','i','t',' ',
't','o',' ','u','s','e',' ','d','i','f','f','e','r','e','n','t',' ','c','o','l','o','r','s',' ','o','r',' ','f','o','n','t','s',',',' ','y','o','u',' ','c','a','n',' ','c','h','a','n','g','e',' ','t','h','e','s','e',' ','b','y',' ','s','e','l','e','c','t','i','n','g',' ',
'P','r','e','f','e','r','e','n','c','e','s',' ','-','>',' ','D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s',' ','-','>',' ','S','y','n','t','a','x',' ','H','i','g','h','l','i','g','h','t','i','n','g',' ','-','>',' ','T','e','x','t',' ','D','r','a','w','i','n','g',' ',
'S','t','y','l','e','s','.',' ',' ','H','i','g','h','l','i','g','h','t','i','n','g',' ','p','a','t','t','e','r','n','s',' ','a','r','e',' ',
'c','o','n','n','e','c','t','e','d',' ','w','i','t','h',' ','f','o','n','t',' ','a','n','d',' ','c','o','l','o','r',' ','i','n','f','o','r','m','a','t','i','o','n',' ','t','h','r','o','u','g','h',' ','a',' ','c','o','m','m','o','n',' ','s','e','t',' ','o','f',' ',
's','t','y','l','e','s',' ','s','o',' ','t','h','a','t',' ','c','o','l','o','r','i','n','g','s',' ','d','e','f','i','n','e','d',' ','f','o','r',' ','o','n','e',' ','l','a','n','g','u','a','g','e',' ','w','i','l','l',' ','b','e',' ','s','i','m','i','l','a','r',' ',
'a','c','r','o','s','s',' ','o','t','h','e','r','s',',',' ','a','n','d',' ','p','a','t','t','e','r','n','s',' ','w','i','t','h','i','n',' ','t','h','e',' ','s','a','m','e',' ','l','a','n','g','u','a','g','e',' ','w','h','i','c','h',' ','a','r','e',' ','m','e','a','n','t',' ','t','o',' ',
'a','p','p','e','a','r',' ','i','d','e','n','t','i','c','a','l',' ','c','a','n',' ','b','e',' ','c','h','a','n','g','e','d',' ','i','n',' ','t','h','e',' ','s','a','m','e',' ','p','l','a','c','e','.',' ',' ','T','o',' ','u','n','d','e','r','s','t','a','n','d',' ','w','h','i','c','h',' ',
's','t','y','l','e','s',' ','a','r','e',' ','u','s','e','d',' ','t','o',' ','h','i','g','h','l','i','g','h','t',' ','t','h','e',' ','l','a','n','g','u','a','g','e',' ','y','o','u',' ','a','r','e',' ','i','n','t','e','r','e','s','t','e','d',' ','i','n',',',' ','y','o','u',' ',
'm','a','y',' ','n','e','e','d',' ','t','o',' ','l','o','o','k',' ','a','t',' ','\"','P','a','t','t','e','r','n','s',' ','f','o','r',' ','H','i','g','h','l','i','g','h','t','i','n','g','\"',' ','s','e','c','t','i','o','n',',',' ','a','s',' ','w','e','l','l','.','\n',
'\n',
'S','y','n','t','a','x',' ','h','i','g','h','l','i','g','h','t','i','n','g',' ','i','s',' ','C','P','U',' ','i','n','t','e','n','s','i','v','e',',',' ','a','n','d',' ','u','n','d','e','r',' ','s','o','m','e',' ','c','i','r','c','u','m','s','t','a','n','c','e','s',' ','c','a','n',' ',
'a','f','f','e','c','t',' ','N','E','d','i','t',''','s',' ','r','e','s','p','o','n','s','i','v','e','n','e','s','s','.',' ',' ','I','f',' ','y','o','u',' ','h','a','v','e',' ','a',' ','p','a','r','t','i','c','u','l','a','r','l','y',' ','s','l','o','w',' ','s','y','s','t','e','m',',',' ',
'o','r',' ','w','o','r','k',' ','w','i','t','h',' ','v','e','r','y',' ','l','a','r','g','e',' ','f','i','l','e','s',',',' ','y','o','u',' ','m','a','y',' ','n','o','t',' ','w','a','n','t',' ','t','o',' ','u','s','e',' ','i','t',' ','a','l','l',' ','o','f',' ','t','h','e',' ',
't','i','m','e','.',' ',' ','S','y','n','t','a','x',' ','h','i','g','h','l','i','g','h','t','i','n','g',' ','i','n','t','r','o','d','u','c','e','s',' ','t','w','o',' ','k','i','n','d','s',' ','o','f',' ','d','e','l','a','y','s','.',' ',' ','T','h','e',' ','f','i','r','s','t',' ','i','s',' ',
'a','n',' ','i','n','i','t','i','a','l',' ','p','a','r','s','i','n','g',' ','d','e','l','a','y',',',' ','p','r','o','p','o','r','t','i','o','n','a','l',' ','t','o',' ','t','h','e',' ','s','i','z','e',' ','o','f',' ','t','h','e',' ','f','i','l','e','.',' ',' ','T','h','i','s',' ',
'd','e','l','a','y',' ','i','s',' ','a','l','s','o',' ','i','n','c','u','r','r','e','d',' ','w','h','e','n',' ','p','a','s','t','i','n','g',' ','l','a','r','g','e',' ','s','e','c','t','i','o','n','s',' ','o','f',' ','t','e','x','t',',',' ','f','i','l','t','e','r','i','n','g',' ',
't','e','x','t',' ','t','h','r','o','u','g','h',' ','s','h','e','l','l',' ','c','o','m','m','a','n','d','s',',',' ','a','n','d',' ','o','t','h','e','r',' ','c','i','r','c','u','m','s','t','a','n','c','e','s',' ','i','n','v','o','l','v','i','n','g',' ','c','h','a','n','g','e','s',' ',
't','o',' ','l','a','r','g','e',' ','a','m','o','u','n','t','s',' ','o','f',' ','t','e','x','t','.',' ',' ','T','h','e',' ','s','e','c','o','n','d',' ','k','i','n','d',' ','o','f',' ','d','e','l','a','y',' ','h','a','p','p','e','n','s',' ','w','h','e','n',' ','t','e','x','t',' ','w','h','i','c','h',' ',
'h','a','s',' ','n','o','t',' ','p','r','e','v','i','o','u','s','l','y',' ','b','e','e','n',' ','v','i','s','i','b','l','e',' ','i','s',' ','s','c','r','o','l','l','e','d',' ','i','n',' ','t','o',' ','v','i','e','w','.',' ',' ','D','e','p','e','n','d','i','n','g',' ','o','n',' ',
'y','o','u','r',' ','s','y','s','t','e','m',',',' ','a','n','d',' ','t','h','e',' ','h','i','g','h','l','i','g','h','t',' ','p','a','t','t','e','r','n','s',' ','y','o','u',' ','a','r','e',' ','u','s','i','n','g',',',' ','t','h','i','s',' ','m','a','y',' ','o','r',' ','m','a','y',' ',
'n','o','t',' ','b','e',' ','n','o','t','i','c','e','a','b','l','e','.',' ',' ','A',' ','t','y','p','i','n','g',' ','d','e','l','a','y',' ','i','s',' ','a','l','s','o',' ','p','o','s','s','i','b','l','e',',',' ','b','u','t',' ','u','n','l','i','k','e','l','y',' ','i','f',' ',
'y','o','u',' ','a','r','e',' ','o','n','l','y',' ','u','s','i','n','g',' ','t','h','e',' ','b','u','i','l','t','-','i','n',' ','p','a','t','t','e','r','n','s','.','\0'};

static char AuxString13[] = {'I','f',' ','a',' ','s','y','s','t','e','m',' ','c','r','a','s','h',',',' ','n','e','t','w','o','r','k',' ','f','a','i','l','u','r','e',',',' ','X',' ','s','e','r','v','e','r',' ','c','r','a','s','h',',',' ','o','r',' ','p','r','o','g','r','a','m',' ','e','r','r','o','r',' ','s','h','o','u','l','d',' ',
'h','a','p','p','e','n',' ','w','h','i','l','e',' ','y','o','u',' ','a','r','e',' ','e','d','i','t','i','n','g',' ','a',' ','f','i','l','e',',',' ','y','o','u',' ','c','a','n',' ','s','t','i','l','l',' ','r','e','c','o','v','e','r',' ','m','o','s','t',' ','o','f',' ','y','o','u','r',' ','w','o','r','k','.',' ',' ',
'N','E','d','i','t',' ','m','a','i','n','t','a','i','n','s',' ','a',' ','b','a','c','k','u','p',' ','f','i','l','e',' ','w','h','i','c','h',' ','i','t',' ','u','p','d','a','t','e','s',' ','p','e','r','i','o','d','i','c','a','l','l','y',' ','(','e','v','e','r','y',' ','8',' ','e','d','i','t','i','n','g',' ',
'o','p','e','r','a','t','i','o','n','s',' ','o','r',' ','8','0',' ','c','h','a','r','a','c','t','e','r','s',' ','t','y','p','e','d',')','.',' ',' ','T','h','i','s',' ','f','i','l','e',' ','i','s',' ','h','a','s',' ','t','h','e',' ','s','a','m','e',' ','n','a','m','e',' ','a','s',' ','t','h','e',' ',
'f','i','l','e',' ','t','h','a','t',' ','y','o','u',' ','a','r','e',' ','e','d','i','t','i','n','g',',',' ','b','u','t',' ','w','i','t','h',' ','t','h','e',' ','c','h','a','r','a','c','t','e','r',' ','\"','~','\"',' ','(','t','i','l','d','e',')',' ','o','n',' ','U','n','i','x',' ','o','r',' ',
'\"','_','\"',' ','(','u','n','d','e','r','s','c','o','r','e',')',' ','o','n',' ','V','M','S',' ','p','r','e','f','i','x','e','d',' ',
't','o',' ','t','h','e',' ','n','a','m','e','.',' ',' ','T','o',' ','r','e','c','o','v','e','r',' ','a',' ','f','i','l','e',' ','a','f','t','e','r',' ','a',' ','c','r','a','s','h',',',' ','s','i','m','p','l','y',' ','r','e','n','a','m','e',' ','t','h','e',' ','f','i','l','e',' ','t','o',' ',
'r','e','m','o','v','e',' ','t','h','e',' ','t','i','l','d','e',' ','o','r',' ','u','n','d','e','r','s','c','o','r','e',' ','c','h','a','r','a','c','t','e','r',',',' ','r','e','p','l','a','c','i','n','g',' ','t','h','e',' ','o','l','d','e','r',' ','v','e','r','s','i','o','n',' ','o','f',' ','t','h','e',' ',
'f','i','l','e','.',' ',' ',
'(','B','e','c','a','u','s','e',' ','s','e','v','e','r','a','l',' ','o','f',' ','t','h','e',' ','U','n','i','x',' ','s','h','e','l','l','s',' ','c','o','n','s','i','d','e','r',' ','t','h','e',' ','t','i','l','d','e',' ','t','o',' ','b','e',' ','a',' ','s','p','e','c','i','a','l',' ',
'c','h','a','r','a','c','t','e','r',',',' ','y','o','u',' ','m','a','y',' ','h','a','v','e',' ','t','o',' ','p','r','e','f','i','x',' ','t','h','e',' ','c','h','a','r','a','c','t','e','r',' ','w','i','t','h',' ','a',' ','\"','\\','\"',' ','(','b','a','c','k','s','l','a','s','h',')',' ',
'w','h','e','n',' ','y','o','u',' ','m','o','v','e',' ','o','r',' ','d','e','l','e','t','e',' ','a','n',' ','N','E','d','i','t',' ','b','a','c','k','u','p',' ','f','i','l','e','.',')','\n',
'\n',
'E','x','a','m','p','l','e',',',' ','t','o',' ','r','e','c','o','v','e','r',' ','t','h','e',' ','f','i','l','e',' ','c','a','l','l','e','d',' ','\"','h','e','l','p','.','c','\"',' ','o','n',' ','U','n','i','x',' ','t','y','p','e',' ','t','h','e',' ','c','o','m','m','a','n','d',':','\n',
'\n',
' ',' ',' ',' ','m','v',' ','\\','~','h','e','l','p','.','c',' ','h','e','l','p','.','c','\n',
'\n',
'O','n',' ','V','M','S',',',' ','t','y','p','e',':','\n',
'\n',
' ',' ',' ',' ','R','E','N','A','M','E',' ','_','H','E','L','P','.','C',' ','H','E','L','P','.','C','\0'};

static char AuxString14[] = {'T','h','e',' ','P','r','e','f','e','r','e','n','c','e','s',' ','m','e','n','u',' ','a','l','l','o','w','s',' ','y','o','u',' ','t','o',' ','s','e','t',' ','o','p','t','i','o','n','s',' ','f','o','r',' ','b','o','t','h',' ','t','h','e',' ','c','u','r','r','e','n','t',' ',
'e','d','i','t','i','n','g',' ','w','i','n','d','o','w',',',' ','a','n','d',' ','d','e','f','a','u','l','t',' ','v','a','l','u','e','s',' ','f','o','r',' ','n','e','w','l','y',' ','c','r','e','a','t','e','d',' ','w','i','n','d','o','w','s',' ','a','n','d',' ','f','u','t','u','r','e',' ',
'N','E','d','i','t',' ','s','e','s','s','i','o','n','s','.',' ',' ','O','p','t','i','o','n','s',' ','i','n',' ','t','h','e',' ','P','r','e','f','e','r','e','n','c','e','s',' ','m','e','n','u',' ','i','t','s','e','l','f',' ','(','n','o','t',' ','i','n',' ','t','h','e',' ',
'D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s',' ','s','u','b','-','m','e','n','u',')',' ',
't','a','k','e',' ','e','f','f','e','c','t',' ','i','m','m','e','d','i','a','t','e','l','y',' ','a','n','d',' ','r','e','f','e','r',' ','t','o',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','w','i','n','d','o','w',' ','o','n','l','y','.',' ',' ','O','p','t','i','o','n','s',' ',
'i','n',' ','t','h','e',' ','D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s',' ','s','u','b','-','m','e','n','u',' ','h','a','v','e',' ','n','o',' ','e','f','f','e','c','t',' ','o','n',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','w','i','n','d','o','w',',',' ',
'b','u','t',' ','i','n','s','t','e','a','d',' ','p','r','o','v','i','d','e',' ','i','n','i','t','i','a','l',' ','s','e','t','t','i','n','g','s',' ','f','o','r',' ','f','u','t','u','r','e',' ','w','i','n','d','o','w','s',' ','c','r','e','a','t','e','d',' ','u','s','i','n','g',' ',
't','h','e',' ','N','e','w',' ','o','r',' ','O','p','e','n',' ','c','o','m','m','a','n','d','s','.',' ',' ','P','r','e','f','e','r','e','n','c','e','s',' ','s','e','t',' ','i','n',' ','t','h','e',' ','D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s',' ',
's','u','b','-','m','e','n','u',' ','c','a','n',' ','a','l','s','o',' ','b','e',' ','s','a','v','e','d',' ','i','n',' ','a',' ','f','i','l','e',' ',
't','h','a','t',' ','i','s',' ','a','u','t','o','m','a','t','i','c','a','l','l','y',' ','r','e','a','d',' ','b','y',' ','N','E','d','i','t',' ','a','t',' ','s','t','a','r','t','u','p',' ','t','i','m','e',',',' ','b','y',' ','s','e','l','e','c','t','i','n','g',' ',
'S','a','v','e',' ','D','e','f','a','u','l','t','s','.','\n',
'\n',
'P','r','e','f','e','r','e','n','c','e','s',' ','M','e','n','u','\n',
'\n',
' ',' ',' ',' ','D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s',' ','-','-',' ','M','e','n','u',' ','o','f',' ','i','n','i','t','i','a','l',' ','s','e','t','t','i','n','g','s',' ','f','o','r','\n',
' ',' ',' ',' ',' ',' ',' ',' ','f','u','t','u','r','e',' ','w','i','n','d','o','w','s','.',' ',' ','G','e','n','e','r','a','l','l','y',' ','t','h','e',' ','s','a','m','e',' ','a','s',' ','t','h','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','o','p','t','i','o','n','s',' ','i','n',' ','t','h','e',' ','m','a','i','n',' ','p','a','r','t',' ','o','f',' ','t','h','e',' ','m','e','n','u',',',' ','b','u','t',' ','a','p','p','l','y','\n',
' ',' ',' ',' ',' ',' ',' ',' ','a','s',' ','d','e','f','a','u','l','t','s',' ','f','o','r',' ','f','u','t','u','r','e',' ','w','i','n','d','o','w','s',' ','c','r','e','a','t','e','d',' ','d','u','r','i','n','g','\n',
' ',' ',' ',' ',' ',' ',' ',' ','t','h','i','s',' ','N','E','d','i','t',' ','s','e','s','s','i','o','n','.',' ',' ','T','h','e','s','e',' ','s','e','t','t','i','n','g','s',' ','c','a','n',' ','b','e',' ','s','a','v','e','d','\n',
' ',' ',' ',' ',' ',' ',' ',' ','u','s','i','n','g',' ','t','h','e',' ','S','a','v','e',' ','D','e','f','a','u','l','t','s',' ','c','o','m','m','a','n','d',' ','b','e','l','o','w',',',' ','t','o',' ','b','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','l','o','a','d','e','d',' ','a','u','t','o','m','a','t','i','c','a','l','l','y',' ','e','a','c','h',' ','t','i','m','e',' ','N','E','d','i','t',' ','i','s',' ','s','t','a','r','t','e','d','.','\n',
'\n',
' ',' ',' ',' ','S','a','v','e',' ','D','e','f','a','u','l','t','s',' ','-','-',' ','S','a','v','e',' ','t','h','e',' ','d','e','f','a','u','l','t',' ','o','p','t','i','o','n','s',' ','a','s',' ','s','e','t','\n',
' ',' ',' ',' ',' ',' ',' ',' ','u','n','d','e','r',' ','D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s',' ','f','o','r',' ','f','u','t','u','r','e',' ','N','E','d','i','t',' ','s','e','s','s','i','o','n','s','.','\n',
'\n',
' ',' ',' ',' ','S','t','a','t','i','s','t','i','c','s',' ','L','i','n','e',' ','-','-',' ','S','h','o','w',' ','t','h','e',' ','f','u','l','l',' ','f','i','l','e',' ','n','a','m','e',',',' ','l','i','n','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','n','u','m','b','e','r',',',' ','a','n','d',' ','l','e','n','g','t','h',' ','o','f',' ','t','h','e',' ','f','i','l','e',' ','b','e','i','n','g',' ','e','d','i','t','e','d','.','\n',
'\n',
' ',' ',' ',' ','L','a','n','g','u','a','g','e',' ','M','o','d','e',' ','-','-',' ','T','e','l','l','s',' ','N','E','d','i','t',' ','w','h','a','t',' ','l','a','n','g','u','a','g','e',' ','(','i','f',' ','a','n','y',')',' ','t','o','\n',
' ',' ',' ',' ',' ',' ',' ',' ','a','s','s','u','m','e',',',' ','f','o','r',' ','s','e','l','e','c','t','i','n','g',' ','l','a','n','g','u','a','g','e','-','s','p','e','c','i','f','i','c',' ','f','e','a','t','u','r','e','s','\n',
'	','s','u','c','h',' ','a','s',' ','h','i','g','h','l','i','g','h','t',' ','p','a','t','t','e','r','n','s',' ','a','n','d',' ','s','m','a','r','t',' ','i','n','d','e','n','t',' ','m','a','c','r','o','s',',','\n',
'	','a','n','d',' ','s','e','t','t','i','n','g',' ','l','a','n','g','u','a','g','e',' ','s','p','e','c','i','f','i','c',' ','p','r','e','f','e','r','e','n','c','e','s',' ','l','i','k','e',' ','w','o','r','d','\n',
'	','d','e','l','i','m','i','t','e','r','s',',',' ','t','a','b',' ','e','m','u','l','a','t','i','o','n',',',' ','a','n','d',' ','a','u','t','o','-','i','n','d','e','n','t','.',' ',' ','S','e','e','\n',
'	','F','e','a','t','u','r','e','s',' ','f','o','r',' ','P','r','o','g','r','a','m','m','i','n','g',' ','-','>',' ','P','r','o','g','r','a','m','m','i','n','g',' ','W','i','t','h',' ','N','E','d','i','t','\n',
'	','f','o','r',' ','m','o','r','e',' ','i','n','f','o','r','m','a','t','i','o','n','.','\n',
'\n',
' ',' ',' ',' ','A','u','t','o',' ','I','n','d','e','n','t',' ','-','-',' ','S','e','t','t','i','n','g',' ','A','u','t','o',' ','I','n','d','e','n','t',' ','\"','o','n','\"',' ','m','a','i','n','t','a','i','n','s',' ','a','\n',
' ',' ',' ',' ',' ',' ',' ',' ','r','u','n','n','i','n','g',' ','i','n','d','e','n','t',' ','(','p','r','e','s','s','i','n','g',' ','t','h','e',' ','r','e','t','u','r','n',' ','k','e','y',' ','w','i','l','l',' ','l','i','n','e','\n',
'	','u','p',' ','t','h','e',' ','c','u','r','s','o','r',' ','w','i','t','h',' ','t','h','e',' ','i','n','d','e','n','t',' ','l','e','v','e','l',' ','o','f',' ','t','h','e',' ','p','r','e','v','i','o','u','s','\n',
'	','l','i','n','e',')','.',' ',' ','I','f',' ','s','m','a','r','t',' ','i','n','d','e','n','t',' ','m','a','c','r','o','s',' ','a','r','e',' ','a','v','a','i','l','a','b','l','e',' ','f','o','r','\n',
'	','t','h','e',' ','c','u','r','r','e','n','t',' ','l','a','n','g','u','a','g','e',' ','m','o','d','e',',',' ','s','m','a','r','t',' ','i','n','d','e','n','t',' ','c','a','n',' ','b','e','\n',
'	','s','e','l','e','c','t','e','d',' ','a','n','d',' ','N','E','d','i','t',' ','w','i','l','l',' ','a','t','t','e','m','p','t',' ','t','o',' ','g','u','e','s','s',' ','p','r','o','p','e','r','\n',
'	','l','a','n','g','u','a','g','e',' ','i','n','d','e','n','t','a','t','i','o','n',' ','f','o','r',' ','e','a','c','h',' ','n','e','w',' ','l','i','n','e','.',' ',' ','S','e','e','\n',
'	','H','e','l','p',' ','-','>',' ','F','e','a','t','u','r','e','s',' ','f','o','r',' ','P','r','o','g','r','a','m','m','i','n','g',' ','-','>',' ','A','u','t','o','m','a','t','i','c','\n',
'	','I','n','d','e','n','t',' ','f','o','r',' ','m','o','r','e',' ','i','n','f','o','r','m','a','t','i','o','n','.','\n',
'\n',
' ',' ',' ',' ','W','r','a','p',' ','-','-',' ','C','h','o','o','s','e',' ','b','e','t','w','e','e','n',' ','t','w','o',' ','s','t','y','l','e','s',' ','o','f',' ','a','u','t','o','m','a','t','i','c',' ','w','r','a','p','p','i','n','g','\n',
' ',' ',' ',' ',' ',' ',' ',' ','o','r',' ','n','o','n','e','.',' ',' ','A','u','t','o',' ','N','e','w','l','i','n','e',' ','w','r','a','p',',',' ','w','r','a','p','s',' ','t','e','x','t',' ','a','t',' ','w','o','r','d','\n',
'	','b','o','u','n','d','a','r','i','e','s',' ','w','h','e','n',' ','t','h','e',' ','c','u','r','s','o','r',' ','r','e','a','c','h','e','s',' ','t','h','e',' ','r','i','g','h','t',' ','m','a','r','g','i','n',',','\n',
'	','b','y',' ','r','e','p','l','a','c','i','n','g',' ','t','h','e',' ','s','p','a','c','e',' ','o','r',' ','t','a','b',' ','a','t',' ','t','h','e',' ','l','a','s','t',' ','w','o','r','d','\n',
'	','b','o','u','n','d','a','r','y',' ','w','i','t','h',' ','a',' ','n','e','w','l','i','n','e',' ','c','h','a','r','a','c','t','e','r','.',' ',' ','C','o','n','t','i','n','u','o','u','s',' ','W','r','a','p','\n',
'	','w','r','a','p','s',' ','l','o','n','g',' ','l','i','n','e','s',' ','w','h','i','c','h',' ','e','x','t','e','n','d',' ','p','a','s','t',' ','t','h','e',' ','r','i','g','h','t',' ','m','a','r','g','i','n','.','\n',
'	','C','o','n','t','i','n','u','o','u','s',' ','W','r','a','p',' ','m','o','d','e',' ','i','s',' ','t','y','p','i','c','a','l','l','y',' ','u','s','e','d',' ','t','o',' ','p','r','o','d','u','c','e','\n',
'	','f','i','l','e','s',' ','w','h','e','r','e',' ','n','e','w','l','i','n','e','s',' ','a','r','e',' ','o','m','m','i','t','t','e','d',' ','w','i','t','h','i','n',' ','p','a','r','a','g','r','a','p','h','s',',','\n',
'	','t','o',' ','m','a','k','e',' ','t','e','x','t',' ','f','i','l','l','i','n','g',' ','a','u','t','o','m','a','t','i','c',' ','(','a',' ','k','i','n','d',' ','o','f',' ','p','o','o','r','-','m','a','n',''','s','\n',
'	','w','o','r','d',' ','p','r','o','c','e','s','s','o','r',')','.',' ',' ','T','e','x','t',' ','o','f',' ','t','h','i','s',' ','s','t','y','l','e',' ','i','s',' ','c','o','m','m','o','n',' ','o','n','\n',
'	','M','a','c','s',' ','a','n','d',' ','P','C','s',' ','b','u','t',' ','i','s',' ','n','o','t',' ','n','e','c','e','s','s','a','r','i','l','y',' ','s','u','p','p','o','r','t','e','d',' ','v','e','r','y','\n',
'	','w','e','l','l',' ','u','n','d','e','r',' ','U','n','i','x',' ','(','e','x','c','e','p','t',' ','i','n',' ','p','r','o','g','r','a','m','s',' ','w','h','i','c','h',' ','d','e','a','l',' ','w','i','t','h','\n',
'	','e','-','m','a','i','l',',',' ','f','o','r',' ','w','h','i','c','h',' ','i','t',' ','i','s',' ','o','f','t','e','n',' ','t','h','e',' ','f','o','r','m','a','t',' ','o','f',' ','c','h','o','i','c','e',')','.','\n',
'\n',
'	','W','r','a','p',' ','M','a','r','g','i','n',' ','-','-',' ','S','e','t',' ','m','a','r','g','i','n',' ','f','o','r',' ','A','u','t','o',' ','N','e','w','l','i','n','e',' ','W','r','a','p',',','\n',
' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ','C','o','n','t','i','n','u','o','u','s',' ','W','r','a','p',',',' ','a','n','d',' ','F','i','l','l',' ','P','a','r','a','g','r','a','p','h','.',' ',' ','L','i','n','e','s',' ','m','a','y',',','\n',
' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ','b','e',' ','w','r','a','p','p','e','d',' ','a','t',' ','t','h','e',' ','r','i','g','h','t',' ','m','a','r','g','i','n',' ','o','f',' ','t','h','e',' ','w','i','n','d','o','w',',',' ','o','r','\n',
' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ','t','h','e',' ','m','a','r','g','i','n',' ','c','a','n',' ','b','e',' ','s','e','t',' ','a','t',' ','a',' ','s','p','e','c','i','f','i','c',' ','c','o','l','u','m','n','.','\n',
'\n',
' ',' ',' ',' ','T','a','b','s',' ','-','-',' ','S','e','t',' ','t','h','e',' ','t','a','b',' ','d','i','s','t','a','n','c','e',' ','(','n','u','m','b','e','r',' ','o','f',' ','c','h','a','r','a','c','t','e','r','s','\n',
' ',' ',' ',' ',' ',' ',' ',' ','b','e','t','w','e','e','n',' ','t','a','b',' ','s','t','o','p','s',')',' ','f','o','r',' ','t','a','b',' ','c','h','a','r','a','c','t','e','r','s',',',' ','a','n','d','\n',
' ',' ',' ',' ',' ',' ',' ',' ','c','o','n','t','r','o','l',' ','t','a','b',' ','e','m','u','l','a','t','i','o','n',' ','a','n','d',' ','u','s','e',' ','o','f',' ','t','a','b',' ','c','h','a','r','a','c','t','e','r','s','\n',
' ',' ',' ',' ',' ',' ',' ',' ','i','n',' ','p','a','d','d','i','n','g',' ','a','n','d',' ','e','m','u','l','a','t','e','d',' ','t','a','b','s','.','\n',
'\n',
' ',' ',' ',' ','T','e','x','t',' ','F','o','n','t','.','.','.',' ','-','-',' ','C','h','a','n','g','e',' ','t','h','e',' ','f','o','n','t','(','s',')',' ','u','s','e','d',' ','t','o',' ','d','i','s','p','l','a','y','\n',
'	','t','e','x','t',' ','(','f','o','n','t','s',' ','f','o','r',' ','m','e','n','u','s',' ','a','n','d',' ','d','i','a','l','o','g','s',' ','m','u','s','t',' ','b','e',' ','s','e','t','\n',
'	','u','s','i','n','g',' ','X',' ','r','e','s','o','u','r','c','e','s',' ','f','o','r',' ','t','h','e',' ','t','e','x','t',' ','a','r','e','a',' ','o','f',' ','t','h','e',' ','w','i','n','d','o','w',')','.','\n',
'	','S','e','e',' ','b','e','l','o','w',' ','f','o','r',' ','m','o','r','e',' ','i','n','f','o','r','m','a','t','i','o','n','.','\n',
'\n',
' ',' ',' ',' ','H','i','g','h','l','i','g','h','t',' ','S','y','n','t','a','x',' ','-','-',' ','I','f',' ','N','E','d','i','t',' ','r','e','c','o','g','n','i','z','e','s',' ','t','h','e',' ','l','a','n','g','u','a','g','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','b','e','i','n','g',' ','e','d','i','t','e','d',',',' ','a','n','d',' ','h','i','g','h','l','i','g','h','t','i','n','g',' ','p','a','t','t','e','r','n','s',' ','a','r','e','\n',
'	','a','v','a','i','l','a','b','l','e',' ','f','o','r',' ','t','h','a','t',' ','l','a','n','g','u','a','g','e',',',' ','u','s','e',' ','f','o','n','t','s',' ','a','n','d',' ','c','o','l','o','r','s','\n',
'	','t','o',' ','e','n','h','a','n','c','e',' ','v','i','e','w','i','n','g',' ','o','f',' ','t','h','e',' ','f','i','l','e','.',' ',' ','(','S','e','e',' ','H','e','l','p',' ','-','>','\n',
'	','F','e','a','t','u','r','e','s',' ','f','o','r',' ','P','r','o','g','r','a','m','m','i','n','g',' ','-','>',' ','S','y','n','t','a','x',' ','H','i','g','h','l','i','g','h','t','i','n','g','\n',
'	','f','o','r',' ','m','o','r','e',' ','i','n','f','o','r','m','a','t','i','o','n','.','\n',
'\n',
' ',' ',' ',' ','M','a','k','e',' ','B','a','c','k','u','p',' ','C','o','p','y',' ','-','-',' ','O','n',' ','S','a','v','e',',',' ','w','r','i','t','e',' ','a',' ','b','a','c','k','u','p',' ','c','o','p','y',' ','o','f','\n',
' ',' ',' ',' ','	','t','h','e',' ','f','i','l','e',' ','a','s',' ','i','t',' ','e','x','i','s','t','e','d',' ','b','e','f','o','r','e',' ','t','h','e',' ','S','a','v','e',' ','c','o','m','m','a','n','d','\n',
' ',' ',' ',' ','	','w','i','t','h',' ','t','h','e',' ','e','x','t','e','n','s','i','o','n',' ','.','b','c','k',' ','(','U','n','i','x',' ','o','n','l','y',')','.','\n',
'\n',
' ',' ',' ',' ','I','n','c','r','e','m','e','n','t','a','l',' ','B','a','c','k','u','p',' ','-','-',' ','P','e','r','i','o','d','i','c','a','l','l','y',' ','m','a','k','e',' ','a',' ','b','a','c','k','u','p',' ','c','o','p','y','\n',
' ',' ',' ',' ',' ',' ',' ',' ','o','f',' ','t','h','e',' ','f','i','l','e',' ','b','e','i','n','g',' ','e','d','i','t','e','d',' ','u','n','d','e','r',' ','t','h','e',' ','n','a','m','e',' ','~','f','i','l','e','n','a','m','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','o','n',' ','U','n','i','x',' ','o','r',' ','_','f','i','l','e','n','a','m','e',' ','o','n',' ','V','M','S',' ','(','s','e','e',' ','C','r','a','s','h',' ','R','e','c','o','v','e','r','y',')','.','\n',
'\n',
' ',' ',' ',' ','S','h','o','w',' ','M','a','t','c','h','i','n','g',' ','(','.','.',')',' ','-','-',' ','M','o','m','e','n','t','a','r','i','l','y',' ','h','i','g','h','l','i','g','h','t',' ','m','a','t','c','h','i','n','g','\n',
' ',' ',' ',' ',' ',' ',' ',' ','p','a','r','e','n','t','h','e','s','i','s',',',' ','b','r','a','c','k','e','t','s',',',' ','a','n','d',' ','b','r','a','c','e','s',' ','w','h','e','n',' ','o','n','e',' ','o','f','\n',
' ',' ',' ',' ',' ',' ',' ',' ','t','h','e','s','e',' ','c','h','a','r','a','c','t','e','r','s',' ','i','s',' ','t','y','p','e','d',',',' ','o','r',' ','w','h','e','n',' ','t','h','e',' ','i','n','s','e','r','t','i','o','n','\n',
' ',' ',' ',' ',' ',' ',' ',' ','c','u','r','s','o','r',' ','i','s',' ','p','o','s','i','t','i','o','n','e','d',' ','a','f','t','e','r',' ','i','t','.','\n',
'\n',
' ',' ',' ',' ','O','v','e','r','t','y','p','e',' ','-','-',' ','I','n',' ','o','v','e','r','t','y','p','e',' ','m','o','d','e',',',' ','n','e','w',' ','c','h','a','r','a','c','t','e','r','s',' ','e','n','t','e','r','e','d','\n',
' ',' ',' ',' ',' ',' ',' ',' ','r','e','p','l','a','c','e',' ','t','h','e',' ','c','h','a','r','a','c','t','e','r','s',' ','i','n',' ','f','r','o','n','t',' ','o','f',' ','t','h','e',' ','i','n','s','e','r','t','i','o','n','\n',
' ',' ',' ',' ',' ',' ',' ',' ','c','u','r','s','o','r',',',' ','r','a','t','h','e','r',' ','t','h','a','n',' ','b','e','i','n','g',' ','i','n','s','e','r','t','e','d',' ','b','e','f','o','r','e',' ','t','h','e','m','.','\n',
'\n',
' ',' ',' ',' ','R','e','a','d',' ','O','n','l','y',' ','-','-',' ','L','o','c','k',' ','t','h','e',' ','f','i','l','e',' ','a','g','a','i','n','s','t',' ','a','c','c','i','d','e','n','t','a','l','\n',
' ',' ',' ',' ',' ',' ',' ',' ','m','o','d','i','f','i','c','a','t','i','o','n','.',' ',' ','T','h','i','s',' ','t','e','m','p','o','r','a','r','i','l','y',' ','p','r','e','v','e','n','t','s',' ','t','h','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','f','i','l','e',' ','f','r','o','m',' ','b','e','i','n','g',' ','m','o','d','i','f','i','e','d',' ','i','n',' ','t','h','i','s',' ','N','E','d','i','t',' ','s','e','s','s','i','o','n','.','\n',
' ',' ',' ',' ',' ',' ',' ',' ','N','o','t','e',' ','t','h','a','t',' ','t','h','i','s',' ','i','s',' ','d','i','f','e','r','e','n','t',' ','f','r','o','m',' ','s','e','t','t','i','n','g',' ','t','h','e',' ','f','i','l','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','p','r','o','t','e','c','t','i','o','n','.','\n',
'\n',
'P','r','e','f','e','r','e','n','c','e','s',' ','-','>',' ','D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s',' ','M','e','n','u','\n',
'\n',
'O','p','t','i','o','n','s',' ','i','n',' ','t','h','e',' ','P','r','e','f','e','r','e','n','c','e','s',' ','-','>',' ','D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s',' ','m','e','n','u',' ','h','a','v','e',' ','t','h','e',' ','s','a','m','e',' ',
'm','e','a','n','i','n','g',' ','a','s',' ','t','h','o','s','e',' ','i','n',' ','t','h','e',' ','t','o','p','-','l','e','v','e','l',' ','P','r','e','f','e','r','e','n','c','e','s',' ','m','e','n','u',',',' ','e','x','c','e','p','t',' ','t','h','a','t',' ','t','h','e','y',' ',
'a','p','p','l','y',' ','t','o',' ','f','u','t','u','r','e',' ','N','E','d','i','t',' ','w','i','n','d','o','w','s',' ','a','n','d',' ','f','u','t','u','r','e',' ','N','E','d','i','t',' ','s','e','s','s','i','o','n','s',' ','i','f',' ','s','a','v','e','d',' ',
'w','i','t','h',' ','t','h','e',' ','S','a','v','e',' ','D','e','f','a','u','l','t','s',' ','c','o','m','m','a','n','d','.',' ',' ','A','d','d','i','t','i','o','n','a','l',' ','o','p','t','i','o','n','s',' ','w','h','i','c','h',' ','a','p','p','e','a','r',' ','i','n',' ',
't','h','i','s',' ','m','e','n','u',' ','a','r','e',':','\n',
'\n',
' ',' ',' ',' ','L','a','n','g','u','a','g','e',' ','M','o','d','e','s',' ','-','-',' ','D','e','f','i','n','e',' ','l','a','n','g','u','a','g','e',' ','r','e','c','o','g','n','i','t','i','o','n','\n',
' ',' ',' ',' ',' ',' ',' ',' ','i','n','f','o','r','m','a','t','i','o','n',' ','(','f','o','r',' ','d','e','t','e','r','m','i','n','i','n','g',' ','l','a','n','g','u','a','g','e',' ','m','o','d','e',' ','f','r','o','m','\n',
'	','f','i','l','e',' ','n','a','m','e',' ','o','r',' ','c','o','n','t','e','n','t',')',' ','a','n','d',' ','s','e','t',' ','l','a','n','g','u','a','g','e',' ','s','p','e','c','i','f','i','c','\n',
'	','p','r','e','f','e','r','e','n','c','e','s','.','\n',
'\n',
' ',' ',' ',' ','C','u','s','t','o','m','i','z','e',' ','M','e','n','u','s',' ','-','-',' ','A','d','d','/','r','e','m','o','v','e',' ','i','t','e','m','s',' ','f','r','o','m',' ','t','h','e',' ','S','h','e','l','l',',','\n',
' ',' ',' ',' ',' ',' ',' ',' ','M','a','c','r','o',',',' ','a','n','d',' ','w','i','n','d','o','w',' ','b','a','c','k','g','r','o','u','n','d',' ','m','e','n','u','s',' ','(','s','e','e',' ','b','e','l','o','w',')','.','\n',
'\n',
' ',' ',' ',' ','S','e','a','r','c','h','i','n','g',' ','-','-',' ','O','p','t','i','o','n','s',' ','f','o','r',' ','c','o','n','t','r','o','l','l','i','n','g',' ','t','h','e',' ','b','e','h','a','v','i','o','r',' ','o','f','\n',
' ',' ',' ',' ',' ',' ',' ',' ','F','i','n','d',' ','a','n','d',' ','R','e','p','l','a','c','e',' ','c','o','m','m','a','n','d','s',':','\n',
'\n',
'	',' ',' ',' ',' ','V','e','r','b','o','s','e',' ','-',' ','P','r','e','s','e','n','t','s',' ','s','e','a','r','c','h',' ','r','e','s','u','l','t','s',' ','i','n',' ','d','i','a','l','o','g','\n',
'	',' ',' ',' ',' ',' ',' ',' ',' ','f','o','r','m',',',' ','a','s','k','s',' ','b','e','f','o','r','e',' ','w','r','a','p','p','i','n','g',' ','a',' ','s','e','a','r','c','h',' ','b','a','c','k','\n',
'	','	','a','r','o','u','n','d',' ','t','h','e',' ','b','e','g','i','n','n','i','n','g',' ','(','o','r',' ','e','n','d',')',' ','o','f',' ','t','h','e',' ','f','i','l','e','.','\n',
'\n',
'	',' ',' ',' ',' ','K','e','e','p',' ','D','i','a','l','o','g','s',' ','U','p',' ','-',' ','D','o','n',''','t',' ','p','o','p',' ','d','o','w','n',' ','R','e','p','l','a','c','e',' ','a','n','d','\n',
'	',' ',' ',' ',' ',' ',' ',' ',' ','F','i','n','d',' ','b','o','x','e','s',' ','a','f','t','e','r',' ','s','e','a','r','c','h','i','n','g','.','\n',
'\n',
'	',' ',' ',' ',' ','D','e','f','a','u','l','t',' ','S','e','a','r','c','h',' ','S','t','y','l','e',' ','-',' ','I','n','i','t','i','a','l',' ','s','e','t','t','i','n','g',' ','f','o','r','\n',
'	',' ',' ',' ',' ',' ',' ',' ',' ','s','e','a','r','c','h',' ','t','y','p','e',' ','i','n',' ','F','i','n','d',' ','a','n','d',' ','R','e','p','l','a','c','e',' ','d','i','a','l','o','g','s','.','\n',
'\n',
' ',' ',' ',' ','S','y','n','t','a','x',' ','H','i','g','h','l','i','g','h','t','i','n','g',' ','-','-',' ','P','r','o','g','r','a','m',' ','a','n','d',' ','c','o','n','f','i','g','u','r','e',' ','e','n','h','a','n','c','e','d','\n',
' ',' ',' ',' ',' ',' ',' ',' ','t','e','x','t',' ','d','i','s','p','l','a','y',' ','f','o','r',' ','n','e','w',' ','o','r',' ','s','u','p','p','o','r','t','e','d',' ','l','a','n','g','u','a','g','e','s',' ','(','S','e','e','\n',
'	','F','e','a','t','u','r','e','s',' ','f','o','r',' ','P','r','o','g','r','a','m','m','i','n','g',' ','-','>',' ','S','y','n','t','a','x',' ','H','i','g','h','l','i','g','h','t','i','n','g',')','.','\n',
'\n',
' ',' ',' ',' ','I','n','i','t','i','a','l',' ','W','i','n','d','o','w',' ','S','i','z','e',' ','-','-',' ','D','e','f','a','u','l','t',' ','s','i','z','e',' ','f','o','r',' ','n','e','w',' ','w','i','n','d','o','w','s','.','\n',
'\n',
'C','h','a','n','g','i','n','g',' ','F','o','n','t','(','s',')','\n',
'\n',
'T','h','e',' ','f','o','n','t',' ','u','s','e','d',' ','t','o',' ','d','i','s','p','l','a','y',' ','t','e','x','t',' ','i','n',' ','N','E','d','i','t',' ','i','s',' ','s','e','t',' ','u','n','d','e','r',' ','P','r','e','f','e','r','e','n','c','e','s',' ','-','>',' ',
'T','e','x','t',' ','F','o','n','t',' ','(','f','o','r',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','w','i','n','d','o','w',')',',',' ','o','r',' ','P','r','e','f','e','r','e','n','c','e','s',' ','-','>',' ','D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s',' ',
'T','e','x','t',' ','F','o','n','t',' ','(','f','o','r',' ','f','u','t','u','r','e',' ','w','i','n','d','o','w','s',')','.',' ',' ','T','h','e','s','e',' ','d','i','a','l','o','g','s',' ','a','l','s','o',' ','a','l','l','o','w',' ','y','o','u',' ','t','o',' ','s','e','t',' ',
'f','o','n','t','s',' ','f','o','r',' ','s','y','n','t','a','x',' ','h','i','g','h','l','i','g','h','t','i','n','g','.',' ',' ','I','f',' ','y','o','u',' ','d','o','n',''','t',' ','i','n','t','e','n','d',' ','t','o',' ','u','s','e',' ','s','y','n','t','a','x',' ',
'h','i','g','h','l','i','g','h','t','i','n','g',',',' ','y','o','u',' ','c','a','n',' ','i','g','n','o','r','e',' ','m','o','s','t',' ','o','f',' ','t','h','e',' ','d','i','a','l','o','g',',',' ','a','n','d',' ','j','u','s','t',' ','s','e','t',' ','t','h','e',' ',
'f','i','e','l','d',' ','l','a','b','e','l','e','d',' ','P','r','i','m','a','r','y',' ','F','o','n','t','.','\n',
'\n',
'U','n','l','e','s','s',' ','y','o','u',' ','a','r','e',' ','a','b','s','o','l','u','t','e','l','y',' ','c','e','r','t','a','i','n',' ','a','b','o','u','t',' ','t','h','e',' ','t','y','p','e','s',' ','o','f',' ','f','i','l','e','s',' ','t','h','a','t',' ','y','o','u',' ',
'w','i','l','l',' ','b','e',' ','e','d','i','t','i','n','g',' ','w','i','t','h',' ','N','E','d','i','t',',',' ','y','o','u',' ','s','h','o','u','l','d',' ','c','h','o','o','s','e',' ','a',' ','f','i','x','e','d','-','s','p','a','c','i','n','g',' ','f','o','n','t','.',' ',' ',
'M','a','n','y',',',' ','i','f',' ','n','o','t',' ','m','o','s','t',',',' ','p','l','a','i','n','-','t','e','x','t',' ','f','i','l','e','s',' ','a','r','e',' ','w','r','i','t','t','e','n',' ','e','x','p','e','c','t','i','n','g',' ','t','o',' ','b','e',' ','v','i','e','w','e','d',' ',
'w','i','t','h',' ','f','i','x','e','d',' ','c','h','a','r','a','c','t','e','r',' ','s','p','a','c','i','n','g',',',' ','a','n','d',' ','w','i','l','l',' ','l','o','o','k',' ','w','r','o','n','g',' ','w','i','t','h',' ','p','r','o','p','o','r','t','i','o','n','a','l',' ','s','p','a','c','i','n','g','.',' ',' ',
'N','E','d','i','t',''','s',' ','f','i','l','l','i','n','g',',',' ','w','r','a','p','p','i','n','g',',',' ','a','n','d',' ','r','e','c','t','a','n','g','u','l','a','r',' ','o','p','e','r','a','t','i','o','n','s',' ','w','i','l','l',' ','a','l','s','o',' ','w','o','r','k',' ','s','t','r','a','n','g','e','l','y',' ',
'i','f',' ','y','o','u',' ','c','h','o','o','s','e',' ','a',' ','p','r','o','p','o','r','t','i','o','n','a','l',' ','f','o','n','t','.','\n',
'\n',
'N','o','t','e',' ','t','h','a','t',' ','i','n',' ','t','h','e',' ','f','o','n','t',' ','b','r','o','w','s','e','r',' ','(','t','h','e',' ','d','i','a','l','o','g',' ',
'b','r','o','u','g','h','t',' ','u','p',' ','b','y',' ','t','h','e',' ','B','r','o','w','s','e','.','.','.',' ','b','u','t','t','o','n',')',',',' ','t','h','e',' ','s','u','b','s','e','t',' ','o','f',' ','f','o','n','t','s',' ','w','h','i','c','h',' ','a','r','e',' ','s','h','o','w','n',' ','i','s',' ',
'n','a','r','r','o','w','e','d',' ','d','e','p','e','n','d','i','n','g',' ','o','n',' ','t','h','e',' ','c','h','a','r','a','c','t','e','r','i','s','t','i','c','s',' ','a','l','r','e','a','d','y',' ','s','e','l','e','c','t','e','d','.',' ',' ','I','t',' ','i','s',' ',
't','h','e','r','e','f','o','r','e',' ','i','m','p','o','r','t','a','n','t',' ','t','o',' ','k','n','o','w',' ','t','h','a','t',' ','y','o','u',' ','c','a','n',' ','u','n','s','e','l','e','c','t',' ','c','h','a','r','a','c','t','e','r','i','s','t','i','c','s',' ',
'f','r','o','m',' ','t','h','e',' ','l','i','s','t','s',' ','b','y',' ','c','l','i','c','k','i','n','g',' ','o','n',' ','t','h','e',' ','s','e','l','e','c','t','e','d',' ','i','t','e','m','s',' ','a',' ','s','e','c','o','n','d',' ','t','i','m','e','.','\n',
'\n',
'F','o','n','t','s',' ','f','o','r',' ','s','y','n','t','a','x',' ','h','i','g','h','l','i','g','h','t','i','n','g',' ','s','h','o','u','l','d',' ','i','d','e','a','l','l','y',' ','m','a','t','c','h',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','f','o','n','t',' ',
'i','n',' ','b','o','t','h',' ','h','e','i','g','h','t',' ','a','n','d',' ','s','p','a','c','i','n','g','.',' ',' ','A',' ','m','i','s','m','a','t','c','h',' ','i','n',' ','s','p','a','c','i','n','g',' ','w','i','l','l',' ','r','e','s','u','l','t',' ','i','n',' ','s','i','m','i','l','a','r',' ',
'd','i','s','t','o','r','t','i','o','n','s',' ','a','s',' ','c','h','o','o','s','i','n','g',' ','a',' ','p','r','o','p','o','r','t','i','o','n','a','l',' ','f','o','n','t',':',' ','c','o','l','u','m','n',' ','a','l','i','g','n','m','e','n','t',' ','w','i','l','l',' ',
's','o','m','e','t','i','m','e','s',' ','l','o','o','k',' ','w','r','o','n','g',',',' ','a','n','d',' ','r','e','c','t','a','n','g','u','l','a','r',' ','o','p','e','r','a','t','i','o','n','s',',',' ','w','r','a','p','p','i','n','g',',',' ','a','n','d',' ','f','i','l','l','i','n','g',' ',
'w','i','l','l',' ','b','e','h','a','v','e',' ','s','t','r','a','n','g','e','l','y','.',' ',' ','A',' ','m','i','s','m','a','t','c','h',' ','i','n',' ','h','e','i','g','h','t',' ','w','i','l','l',' ','c','a','u','s','e',' ','w','i','n','d','o','w','s',' ','t','o',' ','r','e','-','s','i','z','e',' ',
't','h','e','m','s','e','l','v','e','s',' ','s','l','i','g','h','t','l','y',' ','w','h','e','n',' ','s','y','n','t','a','x',' ','h','i','g','h','l','i','g','h','t','i','n','g',' ','i','s',' ','t','u','r','n','e','d',' ','o','n',' ','o','r',' ','o','f','f',',',' ','a','n','d',' ',
'i','n','c','r','e','a','s','e',' ','t','h','e',' ',
'i','n','t','e','r','-',' ','l','i','n','e',' ','s','p','a','c','i','n','g',' ','o','f',' ','t','h','e',' ','t','e','x','t','.',' ',' ','U','n','f','o','r','t','u','n','a','t','e','l','y',',',' ','o','n',' ','s','o','m','e',' ','s','y','s','t','e','m','s',' ','i','t',' ','i','s',' ',
'h','a','r','d',' ','t','o',' ','f','i','n','d',' ','s','e','t','s',' ','o','f',' ','f','o','n','t','s',' ','w','h','i','c','h',' ','m','a','t','c','h',' ','e','x','a','c','t','l','y',' ','i','n',' ','h','e','i','g','h','t','.','\n',
'\n',
'C','u','s','t','o','m','i','z','i','n','g',' ','M','e','n','u','s','\n',
'\n',
'Y','o','u',' ','c','a','n',' ','a','d','d',' ','o','r',' ','c','h','a','n','g','e',' ','i','t','e','m','s',' ','i','n',' ','t','h','e',' ','S','h','e','l','l',',',' ','M','a','c','r','o',',',' ','a','n','d',' ','w','i','n','d','o','w',' ','b','a','c','k','g','r','o','u','n','d',' ',
'm','e','n','u','s',' ','u','n','d','e','r',' ','P','r','e','f','e','r','e','n','c','e','s',' ','-','>',' ','D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s',' ','-','>',' ','C','u','s','t','o','m','i','z','e',' ','M','e','n','u','s','.',' ',' ','W','h','e','n',' ',
'y','o','u',' ','c','h','o','o','s','e',' ','o','n','e',' ','o','f',' ','t','h','e','s','e',',',' ','y','o','u',' ','w','i','l','l',' ','s','e','e',' ','a',' ','d','i','a','l','o','g',' ','w','i','t','h',' ','a',' ','l','i','s','t',' ','o','f',' ','t','h','e',' ',
'c','u','r','r','e','n','t',' ','u','s','e','r','-','c','o','n','f','i','g','u','r','a','b','l','e',' ','i','t','e','m','s',' ','f','r','o','m',' ','t','h','e',' ','m','e','n','u',' ','o','n',' ','t','h','e',' ','l','e','f','t','.',' ',' ',
'T','o',' ','c','h','a','n','g','e',' ','a','n',' ','e','x','i','s','t','i','n','g',' ','i','t','e','m',',',' ','s','e','l','e','c','t',' ','i','t',' ','f','r','o','m',' ','t','h','e',' ','l','i','s','t',',',' ','a','n','d',' ','i','t','s',' ','p','r','o','p','e','r','t','i','e','s',' ',
'w','i','l','l',' ','a','p','p','e','a','r',' ','i','n',' ','t','h','e',' ','r','e','m','a','i','n','i','n','g',' ','f','i','e','l','d','s',' ','o','f',' ','t','h','e',' ','d','i','a','l','o','g',',',' ','w','h','e','r','e',' ','y','o','u',' ','m','a','y',' ','c','h','a','n','g','e',' ',
't','h','e','m','.',' ',' ','S','e','l','e','c','t','i','n','g',' ','t','h','e',' ','i','t','e','m',' ','\"','N','e','w','\"',' ','f','r','o','m',' ','t','h','e',' ','l','i','s','t',' ','a','l','l','o','w','s',' ','y','o','u',' ','t','o',' ','e','n','t','e','r',' ','n','e','w',' ',
'i','t','e','m','s',' ','i','n',' ','t','h','e',' ','m','e','n','u','.','\n',
'\n',
'H','o','p','e','f','u','l','l','y',' ','m','o','s','t',' ','o','f',' ','t','h','e',' ','c','h','a','r','a','c','t','e','r','i','s','t','i','c','s',' ','a','r','e',' ','s','e','l','f',' ','e','x','p','l','a','n','a','t','o','r','y',',',' ','b','u','t',' ','h','e','r','e',' ','a','r','e',' ',
'a',' ','f','e','w',' ','t','h','i','n','g','s',' ','t','o',' ','n','o','t','e',':','\n',
'\n',
'A','c','c','e','l','e','r','a','t','o','r',' ','k','e','y','s',' ','a','r','e',' ','k','e','y','b','o','a','r','d',' ','s','h','o','r','t','c','u','t','s',' ','w','h','i','c','h',' ','a','p','p','e','a','r',' ','o','n',' ','t','h','e',' ','r','i','g','h','t',' ','h','a','n','d',' ',
's','i','d','e',' ','o','f',' ','t','h','e',' ','m','e','n','u','s',',',' ','a','n','d',' ','a','l','l','o','w',' ','y','o','u',' ','a','v','o','i','d',' ','p','u','l','l','i','n','g',' ','d','o','w','n',' ','t','h','e',' ','m','e','n','u',' ','a','n','d',' ','a','c','t','i','v','a','t','e',' ',
't','h','e',' ','c','o','m','m','a','n','d',' ','w','i','t','h',' ','a',' ','s','i','n','g','l','e',' ','k','e','y','s','t','r','o','k','e','.',' ',' ','E','n','t','e','r',' ','a','c','c','e','l','e','r','a','t','o','r','s',' ','b','y',' ','t','y','p','i','n','g',' ','t','h','e',' ','k','e','y','s',' ',
'e','x','a','c','t','l','y',' ','a','s',' ','y','o','u',' ','w','o','u','l','d',' ','t','o',' ','a','c','t','i','v','a','t','e',' ','t','h','e',' ','c','o','m','m','a','n','d','.','\n',
'\n',
'M','n','e','m','o','n','i','c','s',' ','a','r','e',' ','a',' ','s','i','n','g','l','e',' ','l','e','t','t','e','r',' ','w','h','i','c','h',' ','s','h','o','u','l','d',' ','b','e',' ','p','a','r','t',' ','o','f',' ','t','h','e',' ','m','e','n','u',' ','i','t','e','m',' ','n','a','m','e',',',' ',
'w','h','i','c','h',' ','a','l','l','o','w',' ','u','s','e','r','s',' ','t','o',' ','t','r','a','v','e','r','s','e',' ','a','n','d',' ','a','c','t','i','v','a','t','e',' ','m','e','n','u',' ','i','t','e','m','s',' ','b','y',' ','t','y','p','i','n','g',' ','k','e','y','s',' ','w','h','e','n',' ',
't','h','e',' ','m','e','n','u',' ','i','s',' ','p','u','l','l','e','d',' ','d','o','w','n','.','\n',
'\n',
'I','n',' ','t','h','e',' ','S','h','e','l','l',' ','C','o','m','m','a','n','d',' ','f','i','e','l','d',' ','o','f',' ','t','h','e',' ','S','h','e','l','l',' ','C','o','m','m','a','n','d','s',' ','d','i','a','l','o','g',',',' ','t','h','e',' ','%',' ','c','h','a','r','a','c','t','e','r',' ',
'e','x','p','a','n','d','s',' ','t','o',' ','t','h','e',' ','n','a','m','e',' ','(','i','n','c','l','u','d','i','n','g',' ','d','i','r','e','c','t','o','r','y',' ','p','a','t','h',')',' ','o','f',' ','t','h','e',' ','f','i','l','e',' ','i','n',' ','t','h','e',' ','w','i','n','d','o','w','.',' ',' ',
'T','o',' ','i','n','c','l','u','d','e',' ','a',' ','%',' ','c','h','a','r','a','c','t','e','r',' ','i','n',' ','t','h','e',' ','c','o','m','m','a','n','d',',',' ','u','s','e',' ','%','%','.','\n',
'\n',
'T','h','e',' ','M','e','n','u',' ','E','n','t','r','y',' ','f','i','e','l','d',' ','c','a','n',' ','c','o','n','t','a','i','n',' ','s','p','e','c','i','a','l',' ',
'c','h','a','r','a','c','t','e','r','s',' ','f','o','r',' ','c','o','n','s','t','r','u','c','t','i','n','g',' ','h','i','e','r','a','r','c','h','i','c','a','l',' ','s','u','b','-','m','e','n','u','s',',',' ','a','n','d',' ','f','o','r',' ','m','a','k','i','n','g',' ','i','t','e','m','s',' ',
'w','h','i','c','h',' ','a','p','p','e','a','r',' ','o','n','l','y',' ','i','n',' ','c','e','r','t','a','i','n',' ','l','a','n','g','u','a','g','e',' ','m','o','d','e','s','.',' ',' ','T','h','e',' ','r','i','g','h','t',' ','a','n','g','l','e',' ','b','r','a','c','k','e','t',' ',
'c','h','a','r','a','c','t','e','r',' ','\"','>','\"',' ','c','r','e','a','t','e','s',' ','a',' ','s','u','b','-','m','e','n','u','.',' ',' ','T','h','e',' ','n','a','m','e',' ','o','f',' ','t','h','e',' ','i','t','e','m',' ','i','t','s','e','l','f',' ','s','h','o','u','l','d',' ',
'b','e',' ','t','h','e',' ','l','a','s','t',' ','e','l','e','m','e','n','t',' ','o','f',' ','t','h','e',' ','p','a','t','h',' ','f','o','r','m','e','d',' ','f','r','o','m',' ','s','u','c','c','e','s','s','i','v','e',' ','s','u','b','-','m','e','n','u',' ','n','a','m','e','s',' ',
'j','o','i','n','e','d',' ','w','i','t','h',' ','\"','>','\"','.',' ',' ','M','e','n','u',' ','p','a','n','e','s',' ','a','r','e',' ','c','a','l','l','e','d',' ','i','n',' ','t','o',' ','e','x','i','s','t','e','n','c','e',' ','s','i','m','p','l','y',' ','b','y',' ',
'n','a','m','i','n','g',' ','t','h','e','m',' ','a','s',' ','p','a','r','t',' ','o','f',' ','a',' ','M','e','n','u',' ','E','n','t','r','y',' ','n','a','m','e','.',' ',' ','T','o',' ','p','u','t',' ','s','e','v','e','r','a','l',' ','i','t','e','m','s',' ','i','n',' ','t','h','e',' ','s','a','m','e',' ',
's','u','b','-','m','e','n','u',',',' ','r','e','p','e','a','t',' ','t','h','e',' ','s','a','m','e',' ','h','i','e','r','a','r','c','h','i','c','a','l',' ','s','e','q','u','e','n','c','e',' ','f','o','r',' ','e','a','c','h','.',' ',' ','F','o','r',' ',
'e','x','a','m','p','l','e',',',' ','i','n',' ','t','h','e',' ','M','a','c','r','o',' ','C','o','m','m','a','n','d','s',' ','d','i','a','l','o','g',',',' ','t','w','o',' ','i','t','e','m','s',' ','w','i','t','h',' ','m','e','n','u',' ','e','n','t','r','i','e','s',':',' ','a','>','b','>','c',' ','a','n','d',' ',
'a','>','b','>','d',' ','w','o','u','l','d',' ','c','r','e','a','t','e',' ','a',' ','s','i','n','g','l','e',' ','s','u','b',' ','m','e','n','u',' ','u','n','d','e','r',' ','t','h','e',' ','m','a','c','r','o',' ','m','e','n','u',' ','c','a','l','l','e','d',' ','\"','a','\"',',',' ',
'w','h','i','c','h',' ','w','o','u','l','d',' ','c','o','n','t','a','i','n',' ','a',' ','s','i','n','g','l','e',' ','s','u','b','-','m','e','n','u',',',' ','b',',',' ','h','o','l','d','i','n','g',' ','t','h','e',' ','a','c','t','u','a','l',' ','i','t','e','m','s',',',' ','c',' ','a','n','d',' ','d',':','\n',
'\n',
' ',' ',' ',' ','+','-','-','-','+','+','-','-','-','+','+','-','-','-','+','\n',
' ',' ',' ',' ','|','a',' ','>','|','|','b',' ','>','|','|','c',' ',' ','|','\n',
' ',' ',' ',' ','+','-','-','-','+','+','-','-','-','+','|','d',' ',' ','|','\n',
' ',' ',' ',' ','	',' ',' ',' ',' ',' ',' ','+','-','-','-','+','\n',
'\n',
'T','o',' ','q','u','a','l','i','f','y',' ','a',' ','m','e','n','u',' ','e','n','t','r','y',' ','w','i','t','h',' ','a',' ','l','a','n','g','u','a','g','e',' ','m','o','d','e',',',' ','s','i','m','p','l','y',' ','a','d','d',' ','a','n',' ','a','t','-','s','i','g','n',' ','\"','@','\"',' ',
'a','t',' ','t','h','e',' ','e','n','d',' ','o','f',' ','t','h','e',' ','m','e','n','u',' ','c','o','m','m','a','n','d',',',' ','f','o','l','l','o','w','e','d',' ','(','n','o',' ','s','p','a','c','e',')',' ','b','y',' ','a',' ','l','a','n','g','u','a','g','e',' ','m','o','d','e',' ',
'n','a','m','e','.',' ',' ','T','o',' ','m','a','k','e',' ','a',' ','m','e','n','u',' ','i','t','e','m',' ','w','h','i','c','h',' ','a','p','p','e','a','r','s',' ','i','n',' ','s','e','v','e','r','a','l',' ','l','a','n','g','u','a','g','e',' ',
'm','o','d','e','s',',',' ','a','p','p','e','n','d',' ','a','d','d','i','t','i','o','n','a','l',' ','@','s',' ','a','n','d',' ','l','a','n','g','u','a','g','e',' ','m','o','d','e',' ','n','a','m','e','s','.',' ',' ','F','o','r',' ','e','x','a','m','p','l','e',',',' ',
'a','n',' ','i','t','e','m',' ','w','i','t','h',' ','t','h','e',' ','m','e','n','u',' ','e','n','t','r','y',':','\n',
'\n',
' ',' ','M','a','k','e',' ','C',' ','P','r','o','t','o','t','y','p','e','s','@','C','@','C','+','+','\n',
'\n',
'w','o','u','l','d',' ','a','p','p','e','a','r',' ','o','n','l','y',' ','i','n',' ','C',' ','a','n','d',' ','C','+','+',' ','l','a','n','g','u','a','g','e',' ','m','o','d','e','s',',',' ','a','n','d',':','\n',
'\n',
' ',' ','M','a','k','e',' ','C','l','a','s','s',' ','T','e','m','p','l','a','t','e','@','C','+','+','\n',
'\n',
'w','o','u','l','d',' ','a','p','p','e','a','r',' ','o','n','l','y',' ','i','n',' ','C','+','+',' ','m','o','d','e','.','\n',
'\n',
'M','e','n','u',' ','i','t','e','m','s',' ','w','i','t','h',' ','n','o',' ','q','u','a','l','i','f','i','c','a','t','i','o','n',' ','a','p','p','e','a','r',' ','i','n',' ','a','l','l',' ','l','a','n','g','u','a','g','e',' ','m','o','d','e','s','.','\n',
'\n',
'\n',
'S','h','a','r','i','n','g',' ','C','u','s','t','o','m','i','z','a','t','i','o','n','s',' ','w','i','t','h',' ','O','t','h','e','r',' ','N','E','d','i','t',' ','U','s','e','r','s','\n',
'\n',
'I','f',' ','y','o','u',' ','h','a','v','e',' ','w','r','i','t','t','e','n',' ','m','a','c','r','o',' ','o','r',' ','s','h','e','l','l',' ','m','e','n','u',' ','c','o','m','m','a','n','d','s',',',' ','h','i','g','h','l','i','g','h','t',' ','p','a','t','t','e','r','n','s',',',' ',
'o','r',' ','s','m','a','r','t','-','i','n','d','e','n','t',' ','m','a','c','r','o','s',' ','t','h','a','t',' ','y','o','u',' ','w','a','n','t',' ','t','o',' ','s','h','a','r','e',' ','w','i','t','h',' ','o','t','h','e','r',' ','N','E','d','i','t',' ','u','s','e','r','s',',',' ','y','o','u',' ',
'c','a','n',' ','m','a','k','e',' ','a',' ','f','i','l','e',' ','w','h','i','c','h',' ','t','h','e','y',' ','c','a','n',' ','l','o','a','d',' ','i','n','t','o',' ','t','h','e','i','r',' ','n','e','d','i','t',' ','e','n','v','i','r','o','n','m','e','n','t','.','\n',
'\n',
'T','o',' ','l','o','a','d',' ','s','u','c','h',' ','a',' ','f','i','l','e',',',' ','s','t','a','r','t',' ','n','e','d','i','t',' ','w','i','t','h',' ','t','h','e',' ','c','o','m','m','a','n','d',':','\n',
'\n',
' ',' ',' ','n','e','d','i','t',' ','-','i','m','p','o','r','t',' ','<','f','i','l','e','>','\n',
'\n',
'I','n',' ','t','h','e',' ','n','e','w',' ','n','e','d','i','t',' ','s','e','s','s','i','o','n',',',' ','v','e','r','i','f','y',' ','t','h','a','t',' ','t','h','e',' ','i','m','p','o','r','t','e','d',' ','p','a','t','t','e','r','n','s',' ','o','r',' ','m','a','c','r','o','s',' ','d','o',' ',
'w','h','a','t',' ','y','o','u',' ','w','a','n','t',',',' ','t','h','e','n',' ','s','e','l','e','c','t',' ','P','r','e','f','e','r','e','n','c','e','s',' ','-','>',' ','S','a','v','e',' ','D','e','f','a','u','l','t','s','.',' ',' ',
'S','a','v','i','n','g',' ','i','n','c','o','r','p','o','r','a','t','e','s',' ','t','h','e',' ','c','h','a','n','g','e','s',' ','i','n','t','o',' ','y','o','u','r',' ','o','w','n',' ','.','n','e','d','i','t',' ','f','i','l','e',',',' ','s','o',' ','t','h','e',' ','n','e','x','t',' ',
't','i','m','e',' ','y','o','u',' ','r','u','n',' ','n','e','d','i','t',',',' ','y','o','u',' ','w','i','l','l',' ','n','o','t',' ','h','a','v','e',' ','t','o',' ','i','m','p','o','r','t',' ','t','h','e',' ','d','i','s','t','r','i','b','u','t','i','o','n',' ','f','i','l','e','.','\n',
'\n',
'L','o','a','d','i','n','g',' ','a',' ','c','u','s','t','o','m','i','z','a','t','i','o','n',' ','f','i','l','e',' ','i','s',' ','a','u','t','o','m','a','t','e','d',',',' ','b','u','t',' ','c','r','e','a','t','i','n','g',' ','o','n','e',' ','i','s',' ','n','o','t','.',' ',' ',
'T','o',' ','p','r','o','d','u','c','e',' ','a',' ','f','i','l','e',' ','t','o',' ','b','e',' ','i','m','p','o','r','t','e','d',' ','b','y',' ','o','t','h','e','r',' ','u','s','e','r','s',',',' ','y','o','u',' ','m','u','s','t',' ','m','a','k','e',' ','a',' ','c','o','p','y',' ','o','f',' ',
'y','o','u','r',' ','o','w','n',' ','.','n','e','d','i','t',' ','f','i','l','e',',',' ','a','n','d',' ','e','d','i','t',' ','i','t',',',' ','b','y',' ','h','a','n','d',',',' ','t','o',' ','r','e','m','o','v','e',' ','e','v','e','r','y','t','h','i','n','g',' ','b','u','t',' ','t','h','e',' ',
'f','e','w',' ','i','t','e','m','s',' ','o','f',' ','i','n','t','e','r','e','s','t',' ','t','o',' ','t','h','e',' ','r','e','c','i','p','i','e','n','t','.',' ',' ','L','e','a','v','e',' ','o','n','l','y',' ','t','h','e',' ','i','n','d','i','v','i','d','u','a','l',' ',
'r','e','s','o','u','r','c','e','(','s',')',',',' ','a','n','d',' ','w','i','t','h','i','n',' ','t','h','o','s','e',' ','r','e','s','o','u','r','c','e','s',',',' ','o','n','l','y',' ','t','h','e',' ','p','a','r','t','i','c','u','l','a','r',' ','m','a','c','r','o',',',' ',
'p','a','t','t','e','r','n',',',' ','s','t','y','l','e',',',' ','e','t','c',',',' ','t','h','a','t',' ','y','o','u',' ','w','i','s','h',' ','t','o',' ','e','x','c','h','a','n','g','e','.',' ',' ','F','o','r',' ','e','x','a','m','p','l','e',',',' ','t','o',' ','s','h','a','r','e',' ','a',' ',
'h','i','g','h','l','i','g','h','t','i','n','g',' ','p','a','t','t','e','r','n',' ','s','e','t',',',' ','y','o','u',' ','w','o','u','l','d',' ','i','n','c','l','u','d','e',' ','t','h','e',' ','p','a','t','t','e','r','n','s',',',' ','a','n','y',' ','n','e','w',' ','s','t','y','l','e','s',' ',
'y','o','u',' ','a','d','d','e','d',',',' ','a','n','d',' ','l','a','n','g','u','a','g','e',' ','m','o','d','e',' ','i','n','f','o','r','m','a','t','i','o','n',' ','o','n','l','y',' ','i','f',' ','t','h','e',' ','p','a','t','t','e','r','n','s',' ','a','r','e',' ',
'i','n','t','e','n','d','e','d',' ','t','o',' ','s','u','p','p','o','r','t',' ','a',' ','n','e','w',' ','l','a','n','g','u','a','g','e',' ','r','a','t','h','e','r',' ','t','h','a','n',' ','u','p','d','a','t','i','n','g',' ','a','n',' ','e','x','i','s','t','i','n','g',' ','o','n','e','.',' ',
'F','o','r',' ','e','x','a','m','p','l','e',':','\n',
'\n',
' ',' ',' ','n','e','d','i','t','.','h','i','g','h','l','i','g','h','t','P','a','t','t','e','r','n','s',':','\\','\n',
'	','M','y',' ','L','a','n','g','u','a','g','e',':','1',':','0','{','\\','n','\\','\n',
'	','	','C','o','m','m','e','n','t',':','\"','#','\"',':','\"','$','\"',':',':','C','o','m','m','e','n','t',':',':','\\','n','\\','\n',
'	','	','L','o','o','p',' ','H','e','a','d','e','r',':','\"','^','[',' ','\\','\\','t',']','*','l','o','o','p',':','\"',':',':',':','L','o','o','p',':',':','\\','n','\\','\n',
'	','}','\n',
' ',' ',' ','n','e','d','i','t','.','l','a','n','g','u','a','g','e','M','o','d','e','s',':',' ','M','y',' ','L','a','n','g','u','a','g','e',':','.','m','y',':',':',':',':',':',':','\n',
' ',' ',' ','n','e','d','i','t','.','s','t','y','l','e','s',':',' ','L','o','o','p',':','b','l','u','e',':','B','o','l','d','\n',
'\n',
'R','e','s','o','u','r','c','e','s',' ','a','r','e',' ','i','n',' ','t','h','e',' ','f','o','r','m','a','t',' ','o','f',' ','X',' ','r','e','s','o','u','r','c','e',' ','f','i','l','e','s',',',' ','b','u','t',' ','t','h','e',' ','f','o','r','m','a','t',' ','o','f',' ','t','e','x','t',' ',
'w','i','t','h','i','n',' ','m','u','l','t','i','p','l','e','-','i','t','e','m',' ','r','e','s','o','u','r','c','e','s',' ','l','i','k','e',' ','h','i','g','h','l','i','g','h','t',' ','p','a','t','t','e','r','n','s',',',' ','l','a','n','g','u','a','g','e',' ','m','o','d','e','s',',',' ',
'm','a','c','r','o','s',',',' ','s','t','y','l','e','s',',',' ','e','t','c','.',',',' ','a','r','e',' ','p','r','i','v','a','t','e',' ','t','o',' ','N','E','d','i','t','.',' ',' ','E','a','c','h',' ','r','e','s','o','u','r','c','e',' ','i','s',' ','a',' ','s','t','r','i','n','g',' ',
'w','h','i','c','h',' ','e','n','d','s',' ','a','t',' ','t','h','e',' ','f','i','r','s','t',' ','n','e','w','l','i','n','e',' ','c','h','a','r','a','c','t','e','r',' ','n','o','t',' ','e','s','c','a','p','e','d',' ','w','i','t','h',' ','\\',',',' ','s','o',' ','y','o','u',' ','m','u','s','t',' ',
'b','e',' ','c','a','r','e','f','u','l',' ','a','b','o','u','t',' ','h','o','w',' ','y','o','u',' ','t','r','e','a','t',' ','e','n','d','s',' ','o','f',' ','l','i','n','e','s','.',' ',' ','W','h','i','l','e',' ','y','o','u',' ','c','a','n',' ','g','e','n','e','r','a','l','l','y',' ',
'j','u','s','t',' ','c','u','t',' ','a','n','d',' ','p','a','s','t','e',' ','i','n','d','e','n','t','e','d',' ','s','e','c','t','i','o','n','s',',',' ','i','f',' ','s','o','m','e','t','h','i','n','g',' ','w','h','i','c','h',' ','w','a','s',' ','o','r','i','g','i','n','a','l','l','y',' ',
'i','n',' ','t','h','e',' ','m','i','d','d','l','e',' ','o','f',' ','a',' ','r','e','s','o','u','r','c','e',' ','s','t','r','i','n','g',' ','i','s',' ','n','o','w',' ','a','t',' ','t','h','e',' ','e','n','d',',',' ','y','o','u',' ','m','u','s','t',' ','r','e','m','o','v','e',' ','t','h','e',' ',
'\\',' ','l','i','n','e',' ','c','o','n','t','i','n','u','a','t','i','o','n',' ','c','h','a','r','a','c','t','e','r','(','s',')',' ','s','o',' ','i','t',' ','w','i','l','l',' ','n','o','t',' ','j','o','i','n',' ','t','h','e',' ','n','e','x','t',' ','l','i','n','e',' ','i','n','t','o',' ',
't','h','e',' ','r','e','s','o','u','r','c','e','.',' ',' ','C','o','n','v','e','r','s','e','l','y',',',' ','i','f',' ','s','o','m','e','t','h','i','n','g',' ','w','h','i','c','h',' ','w','a','s',' ','o','r','i','g','i','n','a','l','l','y',' ','a','t',' ','t','h','e',' ','e','n','d',' ',
'o','f',' ','a',' ','r','e','s','o','u','r','c','e',' ','i','s',' ','n','o','w',' ','i','n',' ','t','h','e',' ','m','i','d','d','l','e',',',' ','y','o','u',''','l','l',' ','h','a','v','e',' ','t','o',' ','a','d','d',' ','c','o','n','t','i','n','u','a','t','i','o','n',' ',
'c','h','a','r','a','c','t','e','r','(','s',')',' ','t','o',' ','m','a','k','e',' ','s','u','r','e',' ','t','h','a','t',' ','t','h','e',' ','r','e','s','o','u','r','c','e',' ','s','t','r','i','n','g',' ','i','s',' ','p','r','o','p','e','r','l','y',' ','c','o','n','t','i','n','u','e','d',' ',
'f','r','o','m',' ','b','e','g','i','n','n','i','n','g',' ','t','o',' ','e','n','d',',',' ','a','n','d',' ','p','o','s','s','i','b','l','y',' ','n','e','w','l','i','n','e',' ','c','h','a','r','a','c','t','e','r','(','s',')',' ','(','\\','n',')',' ','t','o',' ','m','a','k','e',' ',
's','u','r','e',' ','t','h','a','t',' ','i','t',' ','i','s',' ','p','r','o','p','e','r','l','y',' ','s','e','p','a','r','a','t','e','d',' ','f','r','o','m',' ','t','h','e',' ','n','e','x','t',' ','i','t','e','m','.','\0'};

static char AuxString15[] = {'T','h','e',' ','S','h','e','l','l',' ','m','e','n','u',' ','(','U','n','i','x',' ','v','e','r','s','i','o','n','s',' ','o','n','l','y',')',' ','a','l','l','o','w','s',' ','y','o','u',' ','t','o',' ','e','x','e','c','u','t','e',' ','U','n','i','x',' ','s','h','e','l','l',' ','c','o','m','m','a','n','d','s',' ',
'f','r','o','m',' ','w','i','t','h','i','n',' ','N','E','d','i','t','.',' ',' ','Y','o','u',' ','c','a','n',' ','a','d','d',' ','i','t','e','m','s',' ','t','o',' ','t','h','e',' ','m','e','n','u',' ','t','o',' ','e','x','t','e','n','d',' ','N','E','d','i','t',''','s',' ','c','o','m','m','a','n','d',' ',
's','e','t',' ','o','r',' ','t','o',' ','i','n','c','o','r','p','o','r','a','t','e',' ','c','u','s','t','o','m',' ','a','u','t','o','m','a','t','i','c',' ','e','d','i','t','i','n','g',' ','f','e','a','t','u','r','e','s',' ','u','s','i','n','g',' ','s','h','e','l','l',' ','c','o','m','m','a','n','d','s',' ',
'o','r',' ','e','d','i','t','i','n','g',' ','l','a','n','g','u','a','g','e','s',' ','l','i','k','e',' ','a','w','k',' ','a','n','d',' ',
's','e','d','.',' ',' ','T','o',' ','a','d','d',' ','i','t','e','m','s',' ','t','o',' ','t','h','e',' ','m','e','n','u',',',' ','s','e','l','e','c','t',' ','P','r','e','f','e','r','e','n','c','e','s',' ','-','>',' ','D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s',' ',
'C','u','s','t','o','m','i','z','e',' ','M','e','n','u','s',' ','-','>',' ','S','h','e','l','l',' ','M','e','n','u','.',' ',' ','N','E','d','i','t',' ','c','o','m','e','s',' ','p','r','e','-','c','o','n','f','i','g','u','r','e','d',' ','w','i','t','h',' ',
'a',' ','f','e','w',' ','u','s','e','f','u','l',' ','U','n','i','x',' ','c','o','m','m','a','n','d','s',' ','l','i','k','e',' ','s','p','e','l','l',' ','a','n','d',' ','s','o','r','t',',',' ','b','u','t',' ','w','e',' ','e','n','c','o','u','r','a','g','e',' ','y','o','u',' ','t','o',' ',
'a','d','d',' ','y','o','u','r',' ','o','w','n',' ','c','u','s','t','o','m',' ','e','x','t','e','n','s','i','o','n','s','.','\n',
'\n',
'F','i','l','t','e','r',' ','S','e','l','e','c','t','i','o','n','.','.','.',' ','p','r','o','m','p','t','s',' ','y','o','u',' ','f','o','r',' ','a',' ','U','n','i','x',' ','c','o','m','m','a','n','d',' ','t','o',' ',
'u','s','e',' ','t','o',' ','p','r','o','c','e','s','s',' ','t','h','e',' ','c','u','r','r','e','n','t','l','y',' ','s','e','l','e','c','t','e','d',' ','t','e','x','t','.',' ',' ','T','h','e',' ','o','u','t','p','u','t',' ','f','r','o','m',' ','t','h','i','s',' ',
'c','o','m','m','a','n','d',' ','r','e','p','l','a','c','e','s',' ','t','h','e',' ','c','o','n','t','e','n','t','s',' ','o','f',' ','t','h','e',' ','s','e','l','e','c','t','i','o','n','.','\n',
'\n',
'E','x','e','c','u','t','e',' ','C','o','m','m','a','n','d','.','.','.',' ','p','r','o','m','p','t','s',' ','y','o','u',' ','f','o','r',' ','a',' ','U','n','i','x',' ','c','o','m','m','a','n','d',' ','a','n','d',' ','r','e','p','l','a','c','e','s',' ','t','h','e',' ',
'c','u','r','r','e','n','t',' ','s','e','l','e','c','t','i','o','n',' ','w','i','t','h',' ','t','h','e',' ','o','u','t','p','u','t',' ','o','f',' ','t','h','e',' ','c','o','m','m','a','n','d','.',' ',' ','I','f',' ','t','h','e','r','e',' ','i','s',' ','n','o',' ',
's','e','l','e','c','t','i','o','n',',',' ','i','t',' ','d','e','p','o','s','i','t','s',' ','t','h','e',' ','o','u','t','p','u','t',' ','a','t',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','i','n','s','e','r','t','i','o','n',' ','p','o','i','n','t','.','\n',
'\n',
'E','x','e','c','u','t','e',' ','C','o','m','m','a','n','d',' ','L','i','n','e',' ','u','s','e','s',' ','t','h','e',' ','p','o','s','i','t','i','o','n',' ','o','f',' ','t','h','e',' ','c','u','r','s','o','r',' ','i','n',' ','t','h','e',' ','w','i','n','d','o','w',' ',
't','o',' ','i','n','d','i','c','a','t','e',' ','a',' ','l','i','n','e',' ','t','o',' ','e','x','e','c','u','t','e',' ','a','s',' ','a',' ','s','h','e','l','l',' ','c','o','m','m','a','n','d',' ','l','i','n','e','.',' ',' ','T','h','e',' ','c','u','r','s','o','r',' ','m','a','y',' ',
'b','e',' ','p','o','s','i','t','i','o','n','e','d',' ','a','n','y','w','h','e','r','e',' ','o','n',' ','t','h','e',' ','l','i','n','e','.',' ',' ','T','h','i','s',' ','c','o','m','m','a','n','d',' ','a','l','l','o','w','s',' ','y','o','u',' ','t','o',' ','u','s','e',' ',
'a','n',' ','N','E','d','i','t',' ','w','i','n','d','o','w',' ','a','s',' ','a','n',' ','e','d','i','t','a','b','l','e',' ','c','o','m','m','a','n','d',' ','w','i','n','d','o','w',' ','f','o','r',' ','s','a','v','i','n','g',' ','o','u','t','p','u','t',' ',
'a','n','d',' ','s','a','v','i','n','g',' ','c','o','m','m','a','n','d','s',' ','f','o','r',' ','r','e','-','e','x','e','c','u','t','i','o','n','.','\n',
'\n',
'T','h','e',' ','X',' ','r','e','s','o','u','r','c','e',' ','c','a','l','l','e','d',' ','n','e','d','i','t','.','s','h','e','l','l',' ','(','S','e','e',' ','C','u','s','t','o','m','i','z','i','n','g',' ','N','E','d','i','t',')',' ','d','e','t','e','r','m','i','n','e','s',' ',
'w','h','i','c','h',' ','U','n','i','x',' ','s','h','e','l','l',' ','i','s',' ','u','s','e','d',' ','t','o',' ','e','x','e','c','u','t','e',' ','c','o','m','m','a','n','d','s','.',' ',' ','T','h','e',' ','d','e','f','a','u','l','t',' ','v','a','l','u','e',' ','f','o','r',' ',
't','h','i','s',' ','r','e','s','o','u','r','c','e',' ','i','s',' ','/','b','i','n','/','c','s','h','.','\0'};

static char AuxString16[] = {'R','e','g','u','l','a','r',' ','e','x','p','r','e','s','s','i','o','n','s',' ','a','r','e',' ','a','v','a','i','l','a','b','l','e',' ','i','n',' ','t','h','e',' ','F','i','n','d','.','.','.',' ','a','n','d',' ','R','e','p','l','a','c','e','.','.','.',' ',
'd','i','a','l','o','g','s',' ','a','s',' ','a',' ','w','a','y',' ','t','o',' ','m','a','t','c','h',' ','i','n','e','x','a','c','t',' ','s','e','q','u','e','n','c','e','s',' ','o','f',' ','c','h','a','r','a','c','t','e','r','s','.',' ',' ',
'R','e','g','u','l','a','r',' ','e','x','p','r','e','s','s','i','o','n',' ','s','u','b','s','t','i','t','u','t','i','o','n',' ','c','a','n',' ','a','l','s','o',' ','b','e',' ','u','s','e','d',' ','t','o',' ','p','r','o','g','r','a','m',' ',
'a','u','t','o','m','a','t','i','c',' ','e','d','i','t','i','n','g',' ','o','p','e','r','a','t','i','o','n','s','.',' ',' ','F','o','r',' ','e','x','a','m','p','l','e',',',' ','t','h','e',' ','f','o','l','l','o','w','i','n','g',' ','a','r','e',' ',
's','e','a','r','c','h',' ','a','n','d',' ','r','e','p','l','a','c','e',' ','s','t','r','i','n','g','s',' ','t','o',' ','f','i','n','d',' ','o','c','c','u','r','r','e','n','c','e','s',' ','o','f',' ','t','h','e',' ',
's','u','b','r','o','u','t','i','n','e',' ','g','e','t','_','x',',',' ','r','e','v','e','r','s','e',' ','t','h','e',' ','f','i','r','s','t',' ','a','n','d',' ','s','e','c','o','n','d',' ','p','a','r','a','m','e','t','e','r','s',',',' ','a','d','d',' ','a',' ',
't','h','i','r','d',' ','p','a','r','a','m','e','t','e','r',' ','o','f',' ','N','U','L','L',',',' ','a','n','d',' ','c','h','a','n','g','e',' ','t','h','e',' ','n','a','m','e',' ','t','o',' ','n','e','w','_','g','e','t','_','x','\"',':','\n',
'\n',
'	','S','e','a','r','c','h',' ','s','t','r','i','n','g',':',' ',' ','g','e','t','_','x','\\','(','(','[','^',' ',',',']','*',')',',',' ','(','[','^','\\',')',']','*',')','\\',')','\n',
'	','R','e','p','l','a','c','e',' ','s','t','r','i','n','g',':',' ','n','e','w','_','g','e','t','_','x','(','\\','2',',',' ','\\','1',',',' ','N','U','L','L',')','\n',
'\n',
'T','o',' ','u','s','e',' ','r','e','g','u','l','a','r',' ','e','x','p','r','e','s','s','i','o','n','s',',',' ','c','l','i','c','k',' ','o','n',' ','t','h','e',' ','R','e','g','u','l','a','r',' ','E','x','p','r','e','s','s','i','o','n',' ','b','u','t','t','o','n',' ',
'i','n',' ','t','h','e',' ','F','i','n','d','.','.','.',' ','o','r',' ','R','e','p','l','a','c','e','.','.','.',' ','d','i','a','l','o','g','s',' ','b','e','f','o','r','e',' ','d','o','i','n','g',' ','a',' ','s','e','a','r','c','h',' ','o','r',' ',
'r','e','p','l','a','c','e','m','e','n','t','.','\n',
'\n',
'R','e','g','u','l','a','r',' ','E','x','p','r','e','s','s','i','o','n',' ','S','y','n','t','a','x','\n',
'\n',
'T','h','e',' ','c','o','m','p','o','n','e','n','t','s',' ','o','f',' ','a',' ','r','e','g','u','l','a','r',' ','e','x','p','r','e','s','s','i','o','n',' ','a','r','e',':',' ','b','r','a','n','c','h','e','s',',',' ',
'p','i','e','c','e','s',',',' ','a','t','o','m','s',',',' ','a','n','d',' ','r','a','n','g','e','s','.',' ','A',' ','r','e','g','u','l','a','r',' ','e','x','p','r','e','s','s','i','o','n',' ','c','o','n','s','i','s','t','s',' ','o','f',' ','z','e','r','o',' ','o','r',' ',
'm','o','r','e',' ','b','r','a','n','c','h','e','s',',',' ','s','e','p','a','r','a','t','e','d',' ','b','y',' ','`','|',''','.',' ',' ','I','t',' ','m','a','t','c','h','e','s',' ','a','n','y','t','h','i','n','g',' ','t','h','a','t',' ','m','a','t','c','h','e','s',' ','o','n','e',' ',
'o','f',' ','t','h','e',' ','b','r','a','n','c','h','e','s','.','\n',
'\n',
'A',' ','b','r','a','n','c','h',' ','i','s',' ','z','e','r','o',' ','o','r',' ','m','o','r','e',' ','p','i','e','c','e','s',',',' ','c','o','n','c','a','t','e','n','a','t','e','d','.',' ',' ','I','t',' ','m','a','t','c','h','e','s',' ','a',' ','m','a','t','c','h',' ','f','o','r',' ',
't','h','e',' ','f','i','r','s','t',',',' ','f','o','l','l','o','w','e','d',' ','b','y',' ','a',' ','m','a','t','c','h',' ','f','o','r',' ','t','h','e',' ','s','e','c','o','n','d',',',' ','e','t','c','.','\n',
'\n',
'A',' ','p','i','e','c','e',' ','i','s',' ','a','n',' ','a','t','o','m',' ','p','o','s','s','i','b','l','y',' ','f','o','l','l','o','w','e','d',' ','b','y',' ','`','*',''',',',' ','`','+',''',',',' ','o','r',' ','`','?',''','.',' ',' ','A','n',' ','a','t','o','m',' ',
'f','o','l','l','o','w','e','d',' ','b','y',' ','`','*',''',' ','m','a','t','c','h','e','s',' ','a',' ','s','e','q','u','e','n','c','e',' ','o','f',' ','0',' ','o','r',' ','m','o','r','e',' ','m','a','t','c','h','e','s',' ','o','f',' ','t','h','e',' ','a','t','o','m','.',' ',' ','A','n',' ',
'a','t','o','m',' ','f','o','l','l','o','w','e','d',' ','b','y',' ','`','+',''',' ','m','a','t','c','h','e','s',' ','a',' ','s','e','q','u','e','n','c','e',' ','o','f',' ','1',' ','o','r',' ','m','o','r','e',' ','m','a','t','c','h','e','s',' ','o','f',' ','t','h','e',' ',
'a','t','o','m','.',' ',' ','A','n',' ','a','t','o','m',' ','f','o','l','l','o','w','e','d',' ','b','y',' ','`','?',''',' ','m','a','t','c','h','e','s',' ','a',' ','m','a','t','c','h',' ','o','f',' ','t','h','e',' ','a','t','o','m',',',' ','o','r',' ','t','h','e',' ','n','u','l','l',' ',
's','t','r','i','n','g','.','\n',
'\n',
'A','n',' ','a','t','o','m',' ','i','s',' ','a',' ','r','e','g','u','l','a','r',' ','e','x','p','r','e','s','s','i','o','n',' ','i','n',' ','p','a','r','e','n','t','h','e','s','e','s',' ','(','m','a','t','c','h','i','n','g',' ','a',' ','m','a','t','c','h',' ','f','o','r',' ','t','h','e',' ',
'r','e','g','u','l','a','r',' ','e','x','p','r','e','s','s','i','o','n',')',',',' ','a',' ','r','a','n','g','e',' ','(','s','e','e',' ','b','e','l','o','w',')',',',' ','`','.',''',' ','(','m','a','t','c','h','i','n','g',' ','a','n','y',' ','s','i','n','g','l','e',' ',
'c','h','a','r','a','c','t','e','r',')',',',' ','`','^',''',' ','(','m','a','t','c','h','i','n','g',' ','t','h','e',' ','n','u','l','l',' ','s','t','r','i','n','g',' ','a','t',' ','t','h','e',' ','b','e','g','i','n','n','i','n','g',' ','o','f',' ','a',' ','l','i','n','e',' ',
's','t','r','i','n','g',')',',',' ','`','$',''',' ','(','m','a','t','c','h','i','n','g',' ','t','h','e',' ','n','u','l','l',' ','s','t','r','i','n','g',' ','a','t',' ','t','h','e',' ','e','n','d',' ','o','f',' ','a',' ','l','i','n','e',')',',',' ','`','<',''',' ','o','r',' ','`','>',''',' ',
'(','m','a','t','c','h','i','n','g',' ','t','h','e',' ','n','u','l','l',' ','s','t','r','i','n','g',' ','a','t',' ','a',' ','w','o','r','d',' ','b','o','u','n','d','a','r','y',')',',',' ',
'a',' ','`','\\',''',' ','f','o','l','l','o','w','e','d',' ','b','y',' ','a',' ','s','i','n','g','l','e',' ','c','h','a','r','a','c','t','e','r',' ','(','m','a','t','c','h','i','n','g',' ','t','h','a','t',' ','c','h','a','r','a','c','t','e','r',')',',',' ','o','r',' ','a',' ',
's','i','n','g','l','e',' ','c','h','a','r','a','c','t','e','r',' ','w','i','t','h',' ','n','o',' ','o','t','h','e','r',' ','s','i','g','n','i','f','i','c','a','n','c','e',' ','(','m','a','t','c','h','i','n','g',' ','t','h','a','t',' ','c','h','a','r','a','c','t','e','r',')','.',' ',' ',
'\\','t',',',' ','\\','n',',',' ','\\','b',',',' ','\\','r',',',' ','a','n','d',' ','\\','f',' ','r','e','p','r','e','s','e','n','t',' ','t','h','e',' ','c','h','a','r','a','c','t','e','r','s',' ','t','a','b',' ','n','e','w','l','i','n','e',',',' ','b','a','c','k','s','p','a','c','e',',',' ',
'c','a','r','r','i','a','g','e',' ','r','e','t','u','r','n',',',' ','a','n','d',' ','f','o','r','m',' ','f','e','e','d','.','\n',
'\n',
'A',' ','r','a','n','g','e',' ','i','s',' ','a',' ','s','e','q','u','e','n','c','e',' ','o','f',' ','c','h','a','r','a','c','t','e','r','s',' ','e','n','c','l','o','s','e','d',' ','i','n',' ','`','[',']',''','.',' ',' ','I','t',' ','n','o','r','m','a','l','l','y',' ',
'm','a','t','c','h','e','s',' ','a','n','y',' ','s','i','n','g','l','e',' ','c','h','a','r','a','c','t','e','r',' ','f','r','o','m',' ','t','h','e',' ','s','e','q','u','e','n','c','e','.',' ',' ','I','f',' ','t','h','e',' ','s','e','q','u','e','n','c','e',' ','b','e','g','i','n','s',' ',
'w','i','t','h',' ','`','^',''',',',' ','i','t',' ','m','a','t','c','h','e','s',' ','a','n','y',' ','s','i','n','g','l','e',' ','c','h','a','r','a','c','t','e','r',' ','n','o','t',' ','f','r','o','m',' ','t','h','e',' ','r','e','s','t',' ','o','f',' ','t','h','e',' ',
's','e','q','u','e','n','c','e','.',' ',' ','I','f',' ','t','w','o',' ','c','h','a','r','a','c','t','e','r','s',' ','i','n',' ','t','h','e',' ','s','e','q','u','e','n','c','e',' ','a','r','e',' ','s','e','p','a','r','a','t','e','d',' ','b','y',' ','`','-',''',',',' ','t','h','i','s',' ',
'i','s',' ','s','h','o','r','t','h','a','n','d',' ','f','o','r',' ','t','h','e',' ','f','u','l','l',' ','l','i','s','t',' ','o','f',' ','A','S','C','I','I',' ','c','h','a','r','a','c','t','e','r','s',' ','b','e','t','w','e','e','n',' ','t','h','e','m',' ','(','e','.','g','.',' ',
'`','[','0','-','9',']',''',' ','m','a','t','c','h','e','s',' ','a','n','y',' ','d','e','c','i','m','a','l',' ','d','i','g','i','t',')','.',' ',' ','T','o',' ','i','n','c','l','u','d','e',' ','a',' ','l','i','t','e','r','a','l',' ','`',']',''',' ','i','n',' ','t','h','e',' ',
's','e','q','u','e','n','c','e',',',' ','m','a','k','e',' ','i','t',' ','t','h','e',' ','f','i','r','s','t',' ','c','h','a','r','a','c','t','e','r',' ','(','f','o','l','l','o','w','i','n','g',' ','a',' ','p','o','s','s','i','b','l','e',' ','`','^',''',')','.',' ',' ','T','o',' ',
'i','n','c','l','u','d','e',' ','a',' ','l','i','t','e','r','a','l',' ','`','-',''',',',' ','m','a','k','e',' ','i','t',' ','t','h','e',' ','f','i','r','s','t',' ','o','r',' ','l','a','s','t',' ','c','h','a','r','a','c','t','e','r','.',' ',' ','A',' ','b','a','c','k','s','l','a','s','h',' ',
'`','\\',''',' ','f','o','l','l','o','w','e','d',' ','b','y',' ','a',' ','s','i','n','g','l','e',' ','c','h','a','r','a','c','t','e','r',' ','i','n','c','l','u','d','e','s',' ','t','h','a','t',' ','c','h','a','r','a','c','t','e','r',',',' ','h','o','w','e','v','e','r',' ',
'b','a','c','k','s','l','a','s','h','e','s',' ','a','r','e',' ','n','o','t',' ','n','e','c','e','s','s','a','r','y',' ','f','o','r',' ','m','o','s','t',' ','s','p','e','c','i','a','l',' ','c','h','a','r','a','c','t','e','r','s',',',' ','s','i','n','c','e',' ','i','n','s','i','d','e',' ',
'a',' ','r','a','n','g','e',',',' ','o','n','l','y',' ','t','h','e',' ','`',']',''',',',' ','`','-',''',',',' ','a','n','d',' ',''','\\',''',' ','c','h','a','r','a','c','t','e','r','s',' ','a','r','e',' ','t','r','e','a','t','e','d',' ','s','p','e','c','i','a','l','l','y','.','\n',
'\n',
'S','u','b','s','t','i','t','u','t','i','o','n','\n',
'\n',
'W','h','e','r','e','v','e','r',' ','t','h','e',' ','s','u','b','s','t','i','t','u','t','i','o','n',' ','s','t','r','i','n','g',' ','c','o','n','t','a','i','n','s',' ','t','h','e',' ','c','h','a','r','a','c','t','e','r',' ','`','&',''',',',' ','N','E','d','i','t',' ','w','i','l','l',' ',
's','u','b','s','t','i','t','u','t','e',' ','t','h','e',' ','t','h','e',' ','e','n','t','i','r','e',' ','s','t','r','i','n','g',' ','t','h','a','t',' ','w','a','s',' ','m','a','t','c','h','e','d',' ','i','n',' ','t','h','e',' ','F','i','n','d',' ','o','p','e','r','a','t','i','o','n','.',' ',' ',
'U','p',' ','t','o',' ','n','i','n','e',' ','s','u','b','-','e','x','p','r','e','s','s','i','o','n','s',' ','o','f',' ','t','h','e',' ','m','a','t','c','h',' ','s','t','r','i','n','g',' ','c','a','n',' ','a','l','s','o',' ','b','e',' ','i','n','s','e','r','t','e','d',' ','i','n','t','o',' ',
't','h','e',' ','r','e','p','l','a','c','e','m','e','n','t',' ','s','t','r','i','n','g',',',' ','u','s','i','n','g',' ','`','\\',''',' ','f','o','l','l','o','w','e','d',' ','b','y',' ','a',' ','d','i','g','i','t','.',' ','\\','1',' ','t','h','r','o','u','g','h',' ','\\','9',' ',
'r','e','p','r','e','s','e','n','t',' ','t','h','e',' ','s','t','r','i','n','g','s',' ','t','h','a','t',' ','m','a','t','c','h','e','d',' ','p','a','r','e','n','t','h','e','s','i','z','e','d',' ','e','x','p','r','e','s','s','i','o','n','s',' ','w','i','t','h','i','n',' ','t','h','e',' ',
'r','e','g','u','l','a','r',' ','e','x','p','r','e','s','s','i','o','n',',',' ','n','u','m','b','e','r','e','d',' ','l','e','f','t','-','t','o','-','r','i','g','h','t',' ','i','n',' ','o','r','d','e','r',' ','o','f',' ','t','h','e','i','r',' ','o','p','e','n','i','n','g',' ',
'p','a','r','e','n','t','h','e','s','e','s','.',' ',' ','P','r','e','c','e','d','i','n','g',' ','&',' ','o','r',' ','\\','1','-','9',' ','w','i','t','h',' ','\\','U',',',' ','\\','u',',',' ','\\','L',',',' ','o','r',' ','\\','l',' ','a','d','j','u','s','t','s',' ','t','h','e',' ',
'c','a','s','e',' ',
'o','f',' ','t','h','e',' ','i','n','s','e','r','t','e','d',' ','t','e','x','t','.',' ',' ','\\','u',' ','a','n','d',' ','\\','l',' ','c','h','a','n','g','e',' ','o','n','l','y',' ','t','h','e',' ','f','i','r','s','t',' ','c','h','a','r','a','c','t','e','r',',',' ','w','h','i','l','e',' ',
'\\','U',' ','a','n','d',' ','\\','L',' ','c','h','a','n','g','e',' ','t','h','e',' ','e','n','t','i','r','e',' ','s','t','r','i','n','g',' ','t','o',' ','u','p','p','e','r',' ','o','r',' ','l','o','w','e','r',' ','c','a','s','e','.',' ',' ','\\','t',',',' ','\\','n',',',' ',
'\\','b',',',' ','\\','r',',',' ','a','n','d',' ','\\','f',' ','r','e','p','r','e','s','e','n','t',' ','t','h','e',' ','c','h','a','r','a','c','t','e','r','s',' ','t','a','b',' ','n','e','w','l','i','n','e',',',' ','b','a','c','k','s','p','a','c','e',',',' ',
'c','a','r','r','i','a','g','e',' ','r','e','t','u','r','n',',',' ','a','n','d',' ','f','o','r','m',' ','f','e','e','d',' ','i','n',' ','a',' ','s','u','b','s','t','i','t','u','t','i','o','n',' ','s','t','r','i','n','g',' ','r','e','p','r','e','s','e','n','t',' ','t','h','e',' ','t','a','b',' ','a','n','d',' ',
'n','e','w','l','i','n','e',' ','c','h','a','r','a','c','t','e','r','s',' ','a','s',' ','t','h','e','y',' ','d','o',' ','i','n',' ','m','a','t','c','h',' ','s','t','r','i','n','g','s','.','\n',
'\n',
'A','m','b','i','g','u','i','t','y','\n',
'\n',
'I','f',' ','a',' ','r','e','g','u','l','a','r',' ','e','x','p','r','e','s','s','i','o','n',' ','c','o','u','l','d',' ','m','a','t','c','h',' ','t','w','o',' ','d','i','f','f','e','r','e','n','t',' ','p','a','r','t','s',' ','o','f',' ','t','h','e',' ','t','e','x','t',',',' ',
'i','t',' ','w','i','l','l',' ','m','a','t','c','h',' ','t','h','e',' ','o','n','e',' ','w','h','i','c','h',' ','b','e','g','i','n','s',' ','e','a','r','l','i','e','s','t','.',' ',' ','I','f',' ','b','o','t','h',' ','b','e','g','i','n',' ','i','n',' ',
't','h','e',' ','s','a','m','e',' ','p','l','a','c','e',' ','b','u','t',' ','m','a','t','c','h',' ','d','i','f','f','e','r','e','n','t',' ','l','e','n','g','t','h','s',',',' ','o','r',' ','m','a','t','c','h',' ','t','h','e',' ','s','a','m','e',' ','l','e','n','g','t','h',' ',
'i','n',' ','d','i','f','f','e','r','e','n','t',' ','w','a','y','s',',',' ','l','i','f','e',' ','g','e','t','s',' ','m','e','s','s','i','e','r',',',' ','a','s',' ','f','o','l','l','o','w','s','.','\n',
'\n',
'I','n',' ','g','e','n','e','r','a','l',',',' ','t','h','e',' ','p','o','s','s','i','b','i','l','i','t','i','e','s',' ','i','n',' ','a',' ','l','i','s','t',' ','o','f',' ','b','r','a','n','c','h','e','s',' ','a','r','e',' ','c','o','n','s','i','d','e','r','e','d',' ','i','n',' ',
'l','e','f','t','-','t','o','-','r','i','g','h','t',' ','o','r','d','e','r',',',' ','t','h','e',' ','p','o','s','s','i','b','i','l','i','t','i','e','s',' ','f','o','r',' ','`','*',''',',',' ','`','+',''',',',' ','a','n','d',' ','`','?',''',' ','a','r','e',' ',
'c','o','n','s','i','d','e','r','e','d',' ','l','o','n','g','e','s','t','-','f','i','r','s','t',',',' ','n','e','s','t','e','d',' ','c','o','n','s','t','r','u','c','t','s',' ','a','r','e',' ','c','o','n','s','i','d','e','r','e','d',' ','f','r','o','m',' ','t','h','e',' ',
'o','u','t','e','r','m','o','s','t',' ','i','n',',',' ','a','n','d',' ','c','o','n','c','a','t','e','n','a','t','e','d',' ','c','o','n','s','t','r','u','c','t','s',' ','a','r','e',' ','c','o','n','s','i','d','e','r','e','d',' ','l','e','f','t','m','o','s','t','-','f','i','r','s','t','.',' ',' ','T','h','e',' ',
'm','a','t','c','h',' ','t','h','a','t',' ','w','i','l','l',' ','b','e',' ','c','h','o','s','e','n',' ','i','s',' ','t','h','e',' ','o','n','e',' ','t','h','a','t',' ','u','s','e','s',' ','t','h','e',' ','e','a','r','l','i','e','s','t',' ','p','o','s','s','i','b','i','l','i','t','y',' ',
'i','n',' ','t','h','e',' ','f','i','r','s','t',' ','c','h','o','i','c','e',' ','t','h','a','t',' ','h','a','s',' ','t','o',' ','b','e',' ','m','a','d','e','.',' ',' ','I','f',' ','t','h','e','r','e',' ','i','s',' ','m','o','r','e',' ','t','h','a','n',' ','o','n','e',' ',
'c','h','o','i','c','e',',',' ','t','h','e',' ','n','e','x','t',' ','w','i','l','l',' ','b','e',' ','m','a','d','e',' ','i','n',' ','t','h','e',' ','s','a','m','e',' ','m','a','n','n','e','r',' ','(','e','a','r','l','i','e','s','t',' ','p','o','s','s','i','b','i','l','i','t','y',')',' ',
's','u','b','j','e','c','t',' ','t','o',' ','t','h','e',' ','d','e','c','i','s','i','o','n',' ','o','n',' ','t','h','e',' ','f','i','r','s','t',' ','c','h','o','i','c','e','.',' ',' ','A','n','d',' ','s','o',' ','f','o','r','t','h','.','\n',
'\n',
'F','o','r',' ','e','x','a','m','p','l','e',',',' ','`','(','a','b','|','a',')','b','*','c',''',' ','c','o','u','l','d',' ','m','a','t','c','h',' ','`','a','b','c',''',' ','i','n',' ','o','n','e',' ','o','f',' ','t','w','o',' ','w','a','y','s','.',' ',' ','T','h','e',' ',
'f','i','r','s','t',' ','c','h','o','i','c','e',' ','i','s',' ','b','e','t','w','e','e','n',' ','`','a','b',''',' ','a','n','d',' ','`','a',''',';',' ','s','i','n','c','e',' ','`','a','b',''',' ','i','s',' ','e','a','r','l','i','e','r',',',' ','a','n','d',' ','d','o','e','s',' ',
'l','e','a','d',' ','t','o',' ','a',' ','s','u','c','c','e','s','s','f','u','l',' ','o','v','e','r','a','l','l',' ','m','a','t','c','h',',',' ','i','t',' ','i','s',' ','c','h','o','s','e','n','.',' ',' ','S','i','n','c','e',' ','t','h','e',' ','`','b',''',' ','i','s',' ',
'a','l','r','e','a','d','y',' ','s','p','o','k','e','n',' ','f','o','r',',',' ','t','h','e',' ','`','b','*',''',' ','m','u','s','t',' ','m','a','t','c','h',' ','i','t','s',' ','l','a','s','t',' ','p','o','s','s','i','b','i','l','i','t','y','-','t','h','e',' ','e','m','p','t','y',' ',
's','t','r','i','n','g','-','s','i','n','c','e',' ','i','t',' ','m','u','s','t',' ','r','e','s','p','e','c','t',' ','t','h','e',' ','e','a','r','l','i','e','r',' ','c','h','o','i','c','e','.','\n',
'\n',
'I','n',' ','t','h','e',' ','p','a','r','t','i','c','u','l','a','r',' ','c','a','s','e',' ','w','h','e','r','e',' ','n','o',' ','`','|',''','s',' ','a','r','e',' ','p','r','e','s','e','n','t',' ','a','n','d',' ','t','h','e','r','e',' ','i','s',' ','o','n','l','y',' ','o','n','e',' ',
'`','*',''',',',' ','`','+',''',',',' ','o','r',' ','`','?',''',',',' ','t','h','e',' ','n','e','t',' ','e','f','f','e','c','t',' ','i','s',' ','t','h','a','t',' ','t','h','e',' ','l','o','n','g','e','s','t',' ','p','o','s','s','i','b','l','e',' ','m','a','t','c','h',' ','w','i','l','l',' ',
'b','e',' ','c','h','o','s','e','n','.',' ',' ','S','o',' ','`','a','b','*',''',',',' ','p','r','e','s','e','n','t','e','d',' ','w','i','t','h',' ','`','x','a','b','b','b','b','y',''',',',' ','w','i','l','l',' ','m','a','t','c','h',' ','`','a','b','b','b','b',''','.',' ',' ',
'N','o','t','e',' ','t','h','a','t',' ','i','f',' ','`','a','b','*',''',' ','i','s',' ','t','r','i','e','d',' ','a','g','a','i','n','s','t',' ','`','x','a','b','y','a','b','b','b','z',''',',',' ','i','t',' ','w','i','l','l',' ','m','a','t','c','h',' ','`','a','b',''',' ','j','u','s','t',' ',
'a','f','t','e','r',' ','`','x',''',',',' ','d','u','e',' ','t','o',' ','t','h','e',' ','b','e','g','i','n','s','-','e','a','r','l','i','e','s','t',' ','r','u','l','e','.',' ',' ','(','I','n',' ','e','f','f','e','c','t',',',' ','t','h','e',' ','d','e','c','i','s','i','o','n',' ','o','n',' ',
'w','h','e','r','e',' ','t','o',' ','s','t','a','r','t',' ','t','h','e',' ','m','a','t','c','h',' ','i','s',' ','t','h','e',' ','f','i','r','s','t',' ','c','h','o','i','c','e',' ','t','o',' ','b','e',' ','m','a','d','e',',',' ','h','e','n','c','e',' ','s','u','b','s','e','q','u','e','n','t',' ',
'c','h','o','i','c','e','s',' ','m','u','s','t',' ','r','e','s','p','e','c','t',' ','i','t',' ','e','v','e','n',' ','i','f',' ','t','h','i','s',' ','l','e','a','d','s',' ','t','h','e','m',' ','t','o',' ','l','e','s','s','-','p','r','e','f','e','r','r','e','d',' ',
'a','l','t','e','r','n','a','t','i','v','e','s','.',')','\0'};

static char AuxString17[] = {'n','e','d','i','t',' ','[','-','r','e','a','d',']',' ','[','-','c','r','e','a','t','e',']',' ','[','-','l','i','n','e',' ','n',' ','|',' ','+','n',']',' ','[','-','s','e','r','v','e','r',']','\n',
' ',' ',' ',' ','[','-','d','o',' ','c','o','m','m','a','n','d',']',' ','[','-','t','a','g','s',' ','f','i','l','e',']',' ','[','-','t','a','b','s',' ','n',']',' ','[','-','w','r','a','p',']','\n',
' ',' ',' ',' ','[','-','n','o','w','r','a','p',']',' ','[','-','a','u','t','o','i','n','d','e','n','t',']',' ','[','-','n','o','a','u','t','o','i','n','d','e','n','t',']',' ','[','-','a','u','t','o','s','a','v','e',']','\n',
' ',' ',' ',' ','[','-','n','o','a','u','t','o','s','a','v','e',']',' ','[','-','r','o','w','s',' ','n',']',' ','[','-','c','o','l','u','m','n','s',' ','n',']',' ','[','-','f','o','n','t',' ','f','o','n','t',']','\n',
' ',' ',' ',' ','[','-','g','e','o','m','e','t','r','y',' ','g','e','o','m','e','t','r','y',']',' ','[','-','d','i','s','p','l','a','y',' ','[','h','o','s','t',']',':','s','e','r','v','e','r','[','.','s','c','r','e','e','n',']','\n',
' ',' ',' ',' ','[','-','x','r','m',' ','r','e','s','o','u','r','c','e','s','t','r','i','n','g',']',' ','[','-','s','v','r','n','a','m','e',' ','n','a','m','e',']',' ','[','-','i','m','p','o','r','t',' ','f','i','l','e',']','\n',
' ',' ',' ',' ','[','f','i','l','e','.','.','.',']','\n',
'\n',
' ',' ',' ',' ','-','r','e','a','d',' ','-','-',' ','O','p','e','n',' ','t','h','e',' ','f','i','l','e',' ','R','e','a','d',' ','O','n','l','y',' ','r','e','g','a','r','d','l','e','s','s',' ','o','f','\n',
' ',' ',' ',' ','	','t','h','e',' ','a','c','t','u','a','l',' ','f','i','l','e',' ','p','r','o','t','e','c','t','i','o','n','.','\n',
'\n',
' ',' ',' ',' ','-','c','r','e','a','t','e',' ','-','-',' ','D','o','n',''','t',' ','w','a','r','n',' ','a','b','o','u','t',' ','f','i','l','e',' ','c','r','e','a','t','i','o','n',' ','w','h','e','n','\n',
' ',' ',' ',' ','	','a',' ','f','i','l','e',' ','d','o','e','s','n',''','t',' ','e','x','i','s','t','.','\n',
'\n',
' ',' ',' ',' ','-','l','i','n','e',' ','n',' ','(','o','r',' ','+','n',')',' ','-','-',' ','G','o',' ','t','o',' ','l','i','n','e',' ','n','u','m','b','e','r',' ','n','\n',
'\n',
' ',' ',' ',' ','-','s','e','r','v','e','r',' ','-','-',' ','D','e','s','i','g','n','a','t','e',' ','t','h','i','s',' ','s','e','s','s','i','o','n',' ','a','s',' ','a','n',' ','N','E','d','i','t','\n',
' ',' ',' ',' ',' ',' ',' ',' ','s','e','r','v','e','r',',',' ','f','o','r',' ','p','r','o','c','e','s','s','i','n','g',' ','c','o','m','m','a','n','d','s',' ','f','r','o','m',' ','t','h','e',' ','n','c','\n',
' ',' ',' ',' ',' ',' ',' ',' ','p','r','o','g','r','a','m','.',' ',' ','n','c',' ','c','a','n',' ','b','e',' ','u','s','e','d',' ','t','o',' ','i','n','t','e','r','f','a','c','e',' ','N','E','d','i','t',' ','t','o','\n',
' ',' ',' ',' ',' ',' ',' ',' ','c','o','d','e',' ','d','e','v','e','l','o','p','m','e','n','t',' ','e','n','v','i','r','o','n','m','e','n','t','s',',',' ','m','a','i','l','e','r','s',',',' ','e','t','c','.',',','\n',
' ',' ',' ',' ',' ',' ',' ',' ','o','r',' ','j','u','s','t',' ','a','s',' ','a',' ','q','u','i','c','k',' ','w','a','y',' ','t','o',' ','o','p','e','n',' ','f','i','l','e','s',' ','f','r','o','m',' ','t','h','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','s','h','e','l','l',' ','c','o','m','m','a','n','d',' ','l','i','n','e',' ','w','i','t','h','o','u','t',' ','s','t','a','r','t','i','n','g',' ','a',' ','n','e','w',' ','N','E','d','i','t','\n',
' ',' ',' ',' ',' ',' ',' ',' ','s','e','s','s','i','o','n','.','\n',
'\n',
' ',' ',' ',' ','-','d','o',' ','c','o','m','m','a','n','d',' ','-','-',' ','E','x','e','c','u','t','e',' ','a','n',' ','N','E','d','i','t',' ','m','a','c','r','o',' ','o','r',' ','a','c','t','i','o','n','.','\n',
' ',' ',' ',' ',' ',' ',' ',' ','O','n',' ','e','a','c','h',' ','f','i','l','e',' ','f','o','l','l','o','w','i','n','g',' ','t','h','e',' ','-','d','o',' ','a','r','g','u','m','e','n','t',' ','o','n',' ','t','h','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','c','o','m','m','a','n','d',' ','l','i','n','e','.',' ',' ','-','d','o',' ','i','s',' ','p','a','r','t','i','c','u','l','a','r','l','y',' ','u','s','e','f','u','l',' ','f','r','o','m','\n',
' ',' ',' ',' ',' ',' ',' ',' ','t','h','e',' ','n','c',' ','p','r','o','g','r','a','m',',',' ','w','h','e','r','e',' ','n','c',' ','-','d','o',' ','c','a','n',' ','r','e','m','o','t','e','l','y','\n',
' ',' ',' ',' ',' ',' ',' ',' ','e','x','e','c','u','t','e',' ','c','o','m','m','a','n','d','s',' ','i','n',' ','a','n',' ','n','e','d','i','t',' ','-','s','e','r','v','e','r',' ','s','e','s','s','i','o','n','.','\n',
'\n',
' ',' ',' ',' ','-','t','a','g','s',' ','f','i','l','e',' ','-','-',' ','L','o','a','d',' ','a',' ','f','i','l','e',' ','o','f',' ','d','i','r','e','c','t','i','o','n','s',' ','f','o','r',' ','f','i','n','d','i','n','g','\n',
' ',' ',' ',' ',' ',' ',' ',' ','d','e','f','i','n','i','t','i','o','n','s',' ','o','f',' ','p','r','o','g','r','a','m',' ','s','u','b','r','o','u','t','i','n','e','s',' ','a','n','d',' ','d','a','t','a','\n',
' ',' ',' ',' ',' ',' ',' ',' ','o','b','j','e','c','t','s','.',' ',' ','T','h','e',' ','f','i','l','e',' ','m','u','s','t',' ','b','e',' ','o','f',' ','t','h','e',' ','f','o','r','m','a','t',' ','g','e','n','-','\n',
' ',' ',' ',' ',' ',' ',' ',' ','e','r','a','t','e','d',' ','b','y',' ','t','h','e',' ','U','n','i','x',' ','c','t','a','g','s',' ','c','o','m','m','a','n','d','.','\n',
'\n',
' ',' ',' ',' ','-','t','a','b','s',' ','n',' ','-','-',' ','S','e','t',' ','t','a','b',' ','s','t','o','p','s',' ','e','v','e','r','y',' ','n',' ','c','h','a','r','a','c','t','e','r','s','.','\n',
'\n',
' ',' ',' ',' ','-','w','r','a','p',',',' ','-','n','o','w','r','a','p',' ','-','-',' ','W','r','a','p',' ','l','o','n','g',' ','l','i','n','e','s',' ','a','t',' ','t','h','e',' ','r','i','g','h','t',' ','e','d','g','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','o','f',' ','t','h','e',' ','w','i','n','d','o','w',' ','r','a','t','h','e','r',' ','t','h','a','n',' ','c','o','n','t','i','n','u','i','n','g',' ','t','h','e','m',' ','p','a','s','t','\n',
' ',' ',' ',' ',' ',' ',' ',' ','i','t','.',' ',' ','(','C','o','n','t','i','n','u','o','u','s',' ','W','r','a','p',' ','m','o','d','e',')','\n',
'\n',
' ',' ',' ',' ','-','a','u','t','o','w','r','a','p',',',' ','-','n','o','a','u','t','o','w','r','a','p',' ','-','-',' ','W','r','a','p',' ','l','o','n','g',' ','l','i','n','e','s',' ','w','h','e','n',' ','t','h','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','c','u','r','s','o','r',' ','r','e','a','c','h','e','s',' ','t','h','e',' ','r','i','g','h','t',' ','e','d','g','e',' ','o','f',' ','t','h','e',' ','w','i','n','d','o','w',' ','b','y','\n',
' ',' ',' ',' ',' ',' ',' ',' ','i','n','s','e','r','t','i','n','g',' ','n','e','w','l','i','n','e','s',' ','a','t',' ','w','o','r','d',' ','b','o','u','n','d','a','r','i','e','s','.',' ',' ','(','A','u','t','o','\n',
' ',' ',' ',' ',' ',' ',' ',' ','N','e','w','l','i','n','e',' ','W','r','a','p',' ','m','o','d','e',')','\n',
'\n',
' ',' ',' ',' ','-','a','u','t','o','i','n','d','e','n','t',',',' ','n','o','a','u','t','o','i','n','d','e','n','t',' ','-','-',' ','M','a','i','n','t','a','i','n',' ','a',' ','r','u','n','n','i','n','g','\n',
' ',' ',' ',' ',' ',' ',' ',' ','i','n','d','e','n','t','.','\n',
'\n',
' ',' ',' ',' ','-','a','u','t','o','s','a','v','e',',',' ','-','n','o','a','u','t','o','s','a','v','e',' ','-','-',' ','M','a','i','n','t','a','i','n',' ','a',' ','b','a','c','k','u','p',' ','c','o','p','y',' ','o','f','\n',
' ',' ',' ',' ',' ',' ',' ',' ','t','h','e',' ','f','i','l','e',' ','b','e','i','n','g',' ','e','d','i','t','e','d',' ','u','n','d','e','r',' ','t','h','e',' ','n','a','m','e',' ','~','f','i','l','e','n','a','m','e',' ','\n',
' ',' ',' ',' ',' ',' ',' ',' ','(','o','n',' ','U','n','i','x',')',' ','o','r',' ','_','f','i','l','e','n','a','m','e',' ','(','o','n',' ','V','M','S',')','.','\n',
'\n',
' ',' ',' ',' ','-','r','o','w','s',' ','n',' ','-','-',' ','D','e','f','a','u','l','t',' ','h','e','i','g','h','t',' ','i','n',' ','c','h','a','r','a','c','t','e','r','s',' ','f','o','r',' ','a','n',' ','e','d','i','t','i','n','g','\n',
' ',' ',' ',' ',' ',' ',' ',' ','w','i','n','d','o','w','.','\n',
'\n',
' ',' ',' ',' ','-','c','o','l','u','m','n','s',' ','n',' ','-','-',' ','D','e','f','a','u','l','t',' ','w','i','d','t','h',' ','i','n',' ','c','h','a','r','a','c','t','e','r','s',' ','f','o','r',' ','a','n','\n',
' ',' ',' ',' ',' ',' ',' ',' ','e','d','i','t','i','n','g',' ','w','i','n','d','o','w','.','\n',
'\n',
' ',' ',' ',' ','-','f','o','n','t',' ','f','o','n','t',' ','(','o','r',' ','-','f','n',' ','f','o','n','t',')',' ','-','-',' ','F','o','n','t',' ','f','o','r',' ','t','e','x','t',' ','b','e','i','n','g','\n',
' ',' ',' ',' ',' ',' ',' ',' ','e','d','i','t','e','d',' ','(','F','o','n','t',' ','f','o','r',' ','m','e','n','u','s',' ','a','n','d',' ','d','i','a','l','o','g','s',' ','c','a','n',' ','b','e',' ','s','e','t','\n',
' ',' ',' ',' ',' ',' ',' ',' ','w','i','t','h',' ','-','x','r','m',' ','\"','*','f','o','n','t','L','i','s','t',':','f','o','n','t','\"',')','.','\n',
'\n',
' ',' ',' ',' ','-','d','i','s','p','l','a','y',' ','[','h','o','s','t',']',':','s','e','r','v','e','r','[','.','s','c','r','e','e','n',']',' ','-','-',' ','T','h','e',' ','n','a','m','e',' ','o','f',' ','t','h','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','X',' ','s','e','r','v','e','r',' ','t','o',' ','u','s','e','.',' ',' ','h','o','s','t',' ','s','p','e','c','i','f','i','e','s',' ','t','h','e',' ','m','a','c','h','i','n','e',',','\n',
' ',' ',' ',' ',' ',' ',' ',' ','s','e','r','v','e','r',' ','s','p','e','c','i','f','i','e','s',' ','t','h','e',' ','d','i','s','p','l','a','y',' ','s','e','r','v','e','r',' ','n','u','m','b','e','r',',',' ','a','n','d','\n',
' ',' ',' ',' ',' ',' ',' ',' ','s','c','r','e','e','n',' ','s','p','e','c','i','f','i','e','s',' ','t','h','e',' ','s','c','r','e','e','n',' ','n','u','m','b','e','r','.',' ',' ','h','o','s','t',' ','o','r','\n',
' ',' ',' ',' ',' ',' ',' ',' ','s','c','r','e','e','n',' ','c','a','n',' ','b','e',' ','o','m','i','t','t','e','d',' ','a','n','d',' ','d','e','f','a','u','l','t',' ','t','o',' ','t','h','e',' ','l','o','c','a','l','\n',
' ',' ',' ',' ',' ',' ',' ',' ','m','a','c','h','i','n','e',',',' ','a','n','d',' ','s','c','r','e','e','n',' ','0','.','\n',
'\n',
' ',' ',' ',' ','-','g','e','o','m','e','t','r','y',' ','g','e','o','m','e','t','r','y',' ','(','o','r',' ','-','g',' ','g','e','o','m','e','t','r','y',')',' ','-','-',' ','T','h','e',' ','i','n','i','t','i','a','l','\n',
' ',' ',' ',' ',' ',' ',' ',' ','s','i','z','e',' ','a','n','d','/','o','r',' ','l','o','c','a','t','i','o','n',' ','o','f',' ','e','d','i','t','o','r',' ','w','i','n','d','o','w','s','.',' ',' ','T','h','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','a','r','g','u','m','e','n','t',' ','g','e','o','m','e','t','r','y',' ','h','a','s',' ','t','h','e',' ','f','o','r','m',':','\n',
'\n',
' ',' ',' ',' ',' ',' ',' ',' ','[','<','w','i','d','t','h','>','x','<','h','e','i','g','h','t','>',']','[','+','|','-',']','[','<','x','o','f','f','s','e','t','>','[','+','|','-',']','<','y','o','f','f','s','e','t','>',']','\n',
'\n',
' ',' ',' ',' ',' ',' ',' ',' ','w','h','e','r','e',' ','<','w','i','d','t','h','>',' ','a','n','d',' ','<','h','e','i','g','h','t','>',' ','a','r','e',' ','t','h','e',' ','d','e','s','i','r','e','d',' ','w','i','d','t','h','\n',
' ',' ',' ',' ',' ',' ',' ',' ','a','n','d',' ','h','e','i','g','h','t',' ','o','f',' ','t','h','e',' ','w','i','n','d','o','w',',',' ','a','n','d',' ','<','x','o','f','f','s','e','t','>',' ','a','n','d','\n',
' ',' ',' ',' ',' ',' ',' ',' ','<','y','o','f','f','s','e','t','>',' ','a','r','e',' ','t','h','e',' ','d','i','s','t','a','n','c','e',' ','f','r','o','m',' ','t','h','e',' ','e','d','g','e',' ','o','f',' ','t','h','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','s','c','r','e','e','n',' ','t','o',' ','t','h','e',' ','w','i','n','d','o','w',',',' ','+',' ','f','o','r',' ','t','o','p',' ','o','r',' ','l','e','f','t',',',' ','-',' ','f','o','r','\n',
' ',' ',' ',' ',' ',' ',' ',' ','b','o','t','t','o','m',' ','o','r',' ','r','i','g','h','t','.','\n',
'\n',
' ',' ',' ',' ','-','b','a','c','k','g','r','o','u','n','d',' ','c','o','l','o','r',' ','(','o','r',' ','-','b','g',' ','c','o','l','o','r',')',' ','-','-',' ','B','a','c','k','g','r','o','u','n','d',' ','c','o','l','o','r','.','\n',
' ',' ',' ',' ',' ',' ',' ',' ','(','b','a','c','k','g','r','o','u','n','d',' ','c','o','l','o','r',' ','f','o','r',' ','t','e','x','t',' ','c','a','n',' ','b','e',' ','s','e','t',' ','s','e','p','a','r','a','t','e','l','y','\n',
' ',' ',' ',' ',' ',' ',' ',' ','w','i','t','h',' ','-','x','r','m',' ','\"','n','e','d','i','t','*','t','e','x','t',':','b','a','c','k','g','r','o','u','n','d',' ','c','o','l','o','r','\"',')','.','\n',
'\n',
' ',' ',' ',' ','-','f','o','r','e','g','r','o','u','n','d',' ','c','o','l','o','r',' ','(','o','r',' ','-','f','g',' ','c','o','l','o','r',')',' ','-','-',' ','F','o','r','e','g','r','o','u','n','d',' ','c','o','l','o','r','.','\n',
' ',' ',' ',' ',' ',' ',' ',' ','(','f','o','r','e','g','r','o','u','n','d',' ','c','o','l','o','r',' ','f','o','r',' ','t','e','x','t',' ','c','a','n',' ','b','e',' ','s','e','t',' ','s','e','p','a','r','a','t','e','l','y','\n',
' ',' ',' ',' ',' ',' ',' ',' ','w','i','t','h',' ','-','x','r','m',' ','\"','n','e','d','i','t','*','t','e','x','t',':','f','o','r','e','g','r','o','u','n','d',' ','c','o','l','o','r','\"',')','.','\n',
'\n',
' ',' ',' ',' ','-','x','r','m',' ','r','e','s','o','u','r','c','e','s','t','r','i','n','g',' ','-','-',' ','S','e','t',' ','t','h','e',' ','v','a','l','u','e',' ','o','f',' ','a','n',' ','X',' ','r','e','s','o','u','r','c','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','t','o',' ','o','v','e','r','r','i','d','e',' ','a',' ','d','e','f','a','u','l','t',' ','v','a','l','u','e',' ','(','s','e','e',' ','C','u','s','t','o','m','i','z','i','n','g',' ','N','E','d','i','t',')','.','\n',
'\n',
' ',' ',' ',' ','-','s','v','r','n','a','m','e',' ','n','a','m','e',' ','-','-',' ','W','h','e','n',' ','s','t','a','r','t','i','n','g',' ','n','e','d','i','t',' ','i','n',' ','s','e','r','v','e','r',' ','m','o','d','e',',','\n',
' ',' ',' ',' ',' ',' ',' ',' ','n','a','m','e',' ','t','h','e',' ','s','e','r','v','e','r',',',' ','s','u','c','h',' ','t','h','a','t',' ','i','t',' ','r','e','s','p','o','n','d','s',' ','t','o',' ','r','e','q','u','e','s','t','s','\n',
' ',' ',' ',' ',' ',' ',' ',' ','o','n','l','y',' ','w','h','e','n',' ','n','c',' ','i','s',' ','g','i','v','e','n',' ','a',' ','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','-','s','v','r','n','a','m','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','a','r','g','u','m','e','n','t','.',' ',' ','B','y',' ','n','a','m','i','n','g',' ','s','e','r','v','e','r','s',',',' ','y','o','u',' ','c','a','n',' ','r','u','n',' ','s','e','v','e','r','a','l','\n',
' ',' ',' ',' ',' ',' ',' ',' ','s','i','m','u','l','t','a','n','e','o','u','s','l','y',',',' ','a','n','d',' ','d','i','r','e','c','t',' ','f','i','l','e','s',' ','a','n','d',' ','c','o','m','m','a','n','d','s','\n',
' ',' ',' ',' ',' ',' ',' ',' ','s','p','e','c','i','f','i','c','a','l','l','y',' ','t','o',' ','a','n','y',' ','o','n','e','.','\n',
'\n',
' ',' ',' ',' ','-','i','m','p','o','r','t',' ','f','i','l','e','n','a','m','e',' ','-','-',' ','l','o','a','d','s',' ','a','n',' ','a','d','d','i','t','i','o','n','a','l',' ','p','r','e','f','e','r','e','n','c','e','s','\n',
' ',' ',' ',' ',' ',' ',' ',' ','f','i','l','e',' ','o','n',' ','t','o','p',' ','o','f',' ','t','h','e',' ','e','x','i','s','t','i','n','g',' ','d','e','f','a','u','l','t','s',' ','s','a','v','e','d',' ','i','n',' ','y','o','u','r','\n',
'	','.','n','e','d','i','t',' ','f','i','l','e','.',' ',' ','T','o',' ','i','n','c','o','r','p','o','r','a','t','e',' ','m','a','c','r','o','s',',',' ','l','a','n','g','u','a','g','e','\n',
'	','m','o','d','e','s',',',' ','a','n','d',' ','h','i','g','h','l','i','g','h','t',' ','p','a','t','t','e','r','n','s',' ','a','n','d',' ','s','t','y','l','e','s',' ','w','r','i','t','t','e','n','\n',
'	','b','y',' ','o','t','h','e','r',' ','u','s','e','r','s',',',' ','r','u','n',' ','n','e','d','i','t',' ','w','i','t','h',' ','-','i','m','p','o','r','t',' ','<','f','i','l','e','>',',',' ','t','h','e','n','\n',
'	','r','e','-','s','a','v','e',' ','y','o','u','r',' ','.','n','e','d','i','t',' ','f','i','l','e',' ','w','i','t','h',' ','P','r','e','f','e','r','e','n','c','e','s',' ','-','>',' ','S','a','v','e','\n',
'	','D','e','f','a','u','l','t','s','.','\0'};

static char AuxString18[] = {'N','E','d','i','t',' ','c','a','n',' ','b','e',' ','o','p','e','r','a','t','e','d',' ','o','n',' ','i','t','s',' ','o','w','n',',',' ','o','r',' ','a','s',' ','a',' ','t','w','o','-','p','a','r','t',' ','c','l','i','e','n','t','/','s','e','r','v','e','r',' ',
'a','p','p','l','i','c','a','t','i','o','n','.',' ',' ','C','l','i','e','n','t','/','s','e','r','v','e','r',' ','m','o','d','e',' ','i','s',' ','u','s','e','f','u','l',' ','f','o','r',' ',
'i','n','t','e','g','r','a','t','i','n','g',' ','N','E','d','i','t',' ','w','i','t','h',' ','s','o','f','t','w','a','r','e',' ',
'd','e','v','e','l','o','p','m','e','n','t',' ','e','n','v','i','r','o','n','m','e','n','t','s',',',' ','m','a','i','l','e','r','s',',',' ','a','n','d',' ','o','t','h','e','r',' ','p','r','o','g','r','a','m','s',';',' ','o','r',' ','j','u','s','t',' ','a','s',' ','a',' ',
'q','u','i','c','k',' ','w','a','y',' ','t','o',' ','o','p','e','n',' ','f','i','l','e','s',' ','f','r','o','m',' ','t','h','e',' ','s','h','e','l','l',' ','c','o','m','m','a','n','d',' ','l','i','n','e',' ','w','i','t','h','o','u','t',' ','s','t','a','r','t','i','n','g',' ',
'a',' ','n','e','w',' ','N','E','d','i','t',' ','s','e','s','s','i','o','n','.','\n',
'\n',
'T','o',' ','r','u','n',' ','N','E','d','i','t',' ','i','n',' ','s','e','r','v','e','r',' ','m','o','d','e',',',' ','t','y','p','e',':','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t',' ','-','s','e','r','v','e','r','\n',
'\n',
'N','E','d','i','t',' ','c','a','n',' ','a','l','s','o',' ','b','e',' ','s','t','a','r','t','e','d',' ','i','n',' ','s','e','r','v','e','r',' ','m','o','d','e',' ','v','i','a',' ','t','h','e',' ','n','c',' ','p','r','o','g','r','a','m',' ','w','h','e','n',' ',
'n','o',' ','s','e','r','v','e','r','s',' ','a','r','e',' ','a','v','a','i','l','a','b','l','e','.','\n',
'\n',
'T','h','e',' ','n','c',' ','(','f','o','r',' ','N','E','d','i','t',' ','C','l','i','e','n','t',')',' ','p','r','o','g','r','a','m',',',' ','w','h','i','c','h',' ','i','s',' ','d','i','s','t','r','i','b','u','t','e','d',' ','a','l','o','n','g',' ','w','i','t','h',' ','n','e','d','i','t',',',' ','s','e','n','d','s',' ',
'c','o','m','m','a','n','d','s',' ','t','o',' ','a','n',' ','n','e','d','i','t',' ','s','e','r','v','e','r',' ','t','o',' ','o','p','e','n',' ','f','i','l','e','s',',',' ','s','e','l','e','c','t',' ','l','i','n','e','s',',',' ','o','r',' ','e','x','e','c','u','t','e',' ','e','d','i','t','o','r',' ',
'a','c','t','i','o','n','s','.',' ',' ','I','t',' ','a','c','c','e','p','t','s',' ','a',' ','l','i','m','i','t','e','d',' ','s','e','t',' ','o','f',' ','t','h','e',' ','n','e','d','i','t',' ','c','o','m','m','a','n','d',' ','l','i','n','e',' ','o','p','t','i','o','n','s',':',' ','-','r','e','a','d',',',' ',
'-','c','r','e','a','t','e',',',' ','-','l','i','n','e',' ','(','o','r',' ','+','n',')',',',' ','-','d','o',',',' ','a','n','d',' ','a',' ','l','i','s','t',' ','o','f',' ','f','i','l','e',' ','n','a','m','e','s','.',' ',' ','L','i','s','t','i','n','g',' ','a',' ','f','i','l','e',' ','o','n',' ','t','h','e',' ',
'n','c',' ','c','o','m','m','a','n','d',' ','l','i','n','e',' ','m','e','a','n','s',',',' ','o','p','e','n',' ','i','t',' ','i','f',' ','i','t',' ','i','s',' ','n','o','t',' ','a','l','r','e','a','d','y',' ','o','p','e','n',' ','a','n','d',' ','b','r','i','n','g',' ','t','h','e',' ','w','i','n','d','o','w',' ',
't','o',' ','t','h','e',' ','f','r','o','n','t','.',' ',' ','-','r','e','a','d',' ','a','n','d',' ','-','c','r','e','a','t','e',' ','a','f','f','e','c','t',' ','o','n','l','y',' ','n','e','w','l','y',' ','o','p','e','n','e','d',' ','f','i','l','e','s',',',' ','b','u','t',' ','-','l','i','n','e',' ','a','n','d',' ',
'-','d','o',' ','c','a','n',' ','a','l','s','o',' ','b','e',' ','u','s','e','d',' ','o','n',' ','f','i','l','e','s',' ','w','h','i','c','h',' ','a','r','e',' ','a','l','r','e','a','d','y',' ','o','p','e','n',' ','(','S','e','e',' ',' ',
'\"','N','E','d','i','t',' ','C','o','m','m','a','n','d',' ','L','i','n','e','\"',' ','f','o','r',' ','m','o','r','e',' ','i','n','f','o','r','m','a','t','i','o','n',')','.','\n',
'\n',
'I','n',' ','t','y','p','i','c','a','l',' ','U','n','i','x',' ','s','t','y','l','e',',',' ','a','r','g','u','m','e','n','t','s',' ','a','f','f','e','c','t',' ','t','h','e',' ','f','i','l','e','s',' ','w','h','i','c','h',' ','f','o','l','l','o','w',' ','t','h','e','m',' ','o','n',' ','t','h','e',' ',
'c','o','m','m','a','n','d',' ','l','i','n','e',',',' ','f','o','r',' ','e','x','a','m','p','l','e',':','\n',
'\n',
' ',' ',' ',' ','i','n','c','o','r','r','e','c','t',':',' ',' ',' ','n','c',' ','f','i','l','e','.','c',' ','-','l','i','n','e',' ','2','5','\n',
' ',' ',' ',' ','c','o','r','r','e','c','t',':',' ',' ',' ',' ',' ','n','c',' ','-','l','i','n','e',' ','2','5',' ','f','i','l','e','.','c','\n',
'\n',
'-','r','e','a','d',',',' ','-','c','r','e','a','t','e',',',' ','a','n','d',' ','-','l','i','n','e',' ','a','f','f','e','c','t',' ','a','l','l',' ','o','f',' ','t','h','e',' ','f','i','l','e','s',' ','w','h','i','c','h',' ','f','o','l','l','o','w',' ','t','h','e','m',' ','o','n',' ',
't','h','e',' ','c','o','m','m','a','n','d',' ','l','i','n','e','.',' ',' ','T','h','e',' ','-','d','o',' ','m','a','c','r','o',' ','i','s',' ','e','x','e','c','u','t','e','d',' ','o','n','l','y',' ','o','n','c','e',',',' ','o','n',' ','t','h','e',' ','n','e','x','t',' ','f','i','l','e',' ','o','n',' ',
't','h','e',' ','l','i','n','e','.',' ',' ','-','d','o',' ','w','i','t','h','o','u','t',' ','a',' ','f','i','l','e',' ','f','o','l','l','o','w','i','n','g',' ','i','t',' ','o','n',' ','t','h','e',' ','c','o','m','m','a','n','d',' ','l','i','n','e',',',' ','e','x','e','c','u','t','e','s',' ',
't','h','e',' ','m','a','c','r','o',' ','o','n',' ','t','h','e',' ','f','i','r','s','t',' ','a','v','a','i','l','a','b','l','e',' ','w','i','n','d','o','w',' ','(','p','r','e','s','u','m','a','b','l','y',' ','w','h','e','n',' ','y','o','u',' ','g','i','v','e',' ','a',' ','-','d','o',' ',
'c','o','m','m','a','n','d',' ','w','i','t','h','o','u','t',' ','a',' ','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','f','i','l','e',' ','o','r',' ','w','i','n','d','o','w',',',' ','y','o','u',' ','i','n','t','e','n','d',' ','i','t',' ','t','o',' ','d','o',' ','s','o','m','e','t','h','i','n','g',' ',
'i','n','d','e','p','e','n','d','e','n','t',' ','o','f',' ','t','h','e',' ','w','i','n','d','o','w',' ','i','n',' ','w','h','i','c','h',' ','i','t',' ','h','a','p','p','e','n','s',' ','e','x','e','c','u','t','e',')','.','\n',
'\n',
'n','c',' ','a','l','s','o',' ','a','c','c','e','p','t','s',' ','o','n','e',' ','c','o','m','m','a','n','d',' ','l','i','n','e',' ','o','p','t','i','o','n',' ','o','f',' ','i','t','s',' ','o','w','n',',',' ','-','n','o','a','s','k',' ','(','o','r',' ','-','a','s','k',')',',',' ',
'w','h','i','c','h',' ','i','n','s','t','r','u','c','t','s',' ','i','t',' ','w','h','e','t','h','e','r',' ','t','o',' ','a','u','t','o','m','a','t','i','c','a','l','l','y',' ','s','t','a','r','t',' ','a',' ','s','e','r','v','e','r',' ','i','f',' ','o','n','e',' ','i','s',' ','n','o','t',' ',
'a','v','a','i','l','a','b','l','e','.',' ',' ','T','h','i','s',' ','i','s',' ','a','l','s','o',' ','s','e','t','t','a','b','l','e',' ','v','i','a',' ','t','h','e',' ','X',' ','r','e','s','o','u','r','c','e',',',' ','n','c','.','a','u','t','o','S','t','a','r','t',' ',
'(','S','e','e',' ','X',' ','R','e','s','o','u','r','c','e','s',')','.','\n',
'\n',
'S','o','m','e','t','i','m','e','s',' ','i','t',' ','i','s',' ','u','s','e','f','u','l',' ','t','o',' ','h','a','v','e',' ','m','o','r','e',' ','t','h','a','n',' ','o','n','e',' ','N','E','d','i','t',' ','s','e','r','v','e','r',' ','r','u','n','n','i','n','g',',',' ','f','o','r',' ',
'e','x','a','m','p','l','e',' ','t','o',' ','k','e','e','p',' ','m','a','i','l',' ','a','n','d',' ','p','r','o','g','r','a','m','m','i','n','g',' ','w','o','r','k',' ','s','e','p','a','r','a','t','e',',',' ','o','r',' ','m','o','r','e',' ','i','m','p','o','r','t','a','n','t','l','y',' ',
'f','o','r',' ','w','o','r','k','i','n','g',' ','w','i','t','h',' ','t','o','o','l','s',' ','l','i','k','e',' ','C','l','e','a','r','C','a','s','e',' ','w','h','i','c','h',' ','p','r','o','v','i','d','e',' ','d','i','f','f','e','r','e','n','t',' ','v','i','e','w','s',' ','o','f',' ',
't','h','e',' ','f','i','l','e',' ','s','y','s','t','e','m',' ','f','r','o','m',' ','d','i','f','f','e','r','e','n','t',' ','s','h','e','l','l','s','.',' ',' ','T','h','e',' ','o','p','t','i','o','n',',',' ','-','s','v','r','n','a','m','e',',',' ','t','o',' ','b','o','t','h',' ','n','e','d','i','t',' ',
'a','n','d',' ','n','c',',',' ','a','l','l','o','w',' ','y','o','u',' ','t','o',' ','s','t','a','r','t',',',' ','a','n','d',' ','c','o','m','m','u','n','i','c','a','t','e',' ','w','i','t','h',',',' ','s','e','p','a','r','a','t','e',' ','n','a','m','e','d',' ','s','e','r','v','e','r','s','.',' ',' ',
'A',' ','n','a','m','e','d',' ','s','e','r','v','e','r',' ','r','e','s','p','o','n','d','s',' ','o','n','l','y',' ','t','o',' ','r','e','q','u','e','s','t','s',' ','w','i','t','h',' ','t','h','e',' ','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','-','s','v','r','n','a','m','e',' ',
'a','r','g','u','m','e','n','t','.','\n',
'\n',
'C','o','m','m','u','n','i','c','a','t','i','o','n',' ','b','e','t','w','e','e','n',' ','n','c',' ','a','n','d',' ','n','e','d','i','t',' ','i','s',' ','t','h','r','o','u','g','h',' ','t','h','e',' ','X',' ','d','i','s','p','l','a','y','.',' ',' ','S','o',' ','a','s',' ','l','o','n','g',' ','a','s',' ','X',' ',
'w','i','n','d','o','w','s',' ','i','s',' ','s','e','t',' ','u','p',' ','a','n','d',' ','w','o','r','k','i','n','g',' ','p','r','o','p','e','r','l','y',',',' ','n','c',' ','w','i','l','l',' ','w','i','l','l',' ','w','o','r','k',' ',
'p','r','o','p','e','r','l','y',' ','a','s',' ','w','e','l','l','.',' ',' ','n','c',' ','u','s','e','s',' ','t','h','e',' ','D','I','S','P','L','A','Y',' ','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',',',' ','t','h','e',' ','m','a','c','h','i','n','e',' ','n','a','m','e',' ',
'a','n','d',' ','y','o','u','r',' ','u','s','e','r',' ','n','a','m','e',' ','t','o',' ','f','i','n','d',' ','t','h','e',' ','a','p','p','r','o','p','r','i','a','t','e',' ','s','e','r','v','e','r',',',' ','m','e','a','n','i','n','g',',',' ','i','f',' ','y','o','u',' ','h','a','v','e',' ','s','e','v','e','r','a','l',' ',
'm','a','c','h','i','n','e','s',' ','s','h','a','r','i','n','g',' ','a',' ','c','o','m','m','o','n',' ','f','i','l','e',' ','s','y','s','t','e','m',',',' ','n','c',' ','w','i','l','l',' ','n','o','t',' ','b','e',' ','a','b','l','e',' ','t','o',' ','f','i','n','d',' ','a',' ','s','e','r','v','e','r',' ',
't','h','a','t',' ','i','s',' ','r','u','n','n','i','n','g',' ','o','n',' ','a',' ','m','a','c','h','i','n','e',' ','w','i','t','h',' ','a',' ','d','i','f','f','e','r','e','n','t',' ','h','o','s','t',' ','n','a','m','e',',',' ','e','v','e','n',' ','t','h','o','u','g','h',' ','i','t',' ','m','a','y',' ','b','e',' ',
'p','e','r','f','e','c','t','l','y',' ','a','p','p','r','o','p','r','i','a','t','e',' ','f','o','r',' ','e','d','i','t','i','n','g',' ','a',' ','g','i','v','e','n',' ','f','i','l','e','.','\n',
'\n',
'T','h','e',' ','c','o','m','m','a','n','d',' ','w','h','i','c','h',' ','n','c',' ','u','s','e','s',' ','t','o',' ','s','t','a','r','t',' ','a','n',' ','n','e','d','i','t',' ','s','e','r','v','e','r',' ','i','s',' ','s','e','t','t','a','b','l','e',' ',
'v','i','a',' ','t','h','e',' ','X',' ','r','e','s','o','u','r','c','e',' ','n','c','.','s','e','r','v','e','r','C','o','m','m','a','n','d',',',' ','b','y',' ','d','e','f','a','u','l','t',',',' ',
'\"','n','e','d','i','t',' ','-','s','e','r','v','e','r','\"','.','\0'};

static char AuxString19[] = {'N','E','d','i','t',' ','c','a','n',' ','b','e',' ','c','u','s','t','o','m','i','z','e','d',' ','m','a','n','y',' ','d','i','f','f','e','r','e','n','t',' ','w','a','y','s','.',' ',' ','T','h','e',' ','m','o','s','t',' ','i','m','p','o','r','t','a','n','t',' ',
'u','s','e','r','-','s','e','t','t','a','b','l','e',' ','o','p','t','i','o','n','s',' ','a','r','e',' ','p','r','e','s','e','n','t','e','d',' ','i','n',' ','t','h','e',' ','P','r','e','f','e','r','e','n','c','e','s',' ','m','e','n','u',',',' ','i','n','c','l','u','d','i','n','g',' ',
'a','l','l',' ','o','p','t','i','o','n','s',' ','t','h','a','t',' ','u','s','e','r','s',' ','m','i','g','h','t',' ','n','e','e','d',' ','t','o',' ','c','h','a','n','g','e',' ','d','u','r','i','n','g',' ','a','n',' ','e','d','i','t','i','n','g',' ','s','e','s','s','i','o','n','.',' ',' ',
'O','p','t','i','o','n','s',' ','s','e','t',' ','i','n',' ','t','h','e',' ','D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s',' ','s','u','b','-','m','e','n','u',' ','o','f',' ','t','h','e',' ','P','r','e','f','e','r','e','n','c','e','s',' ','m','e','n','u',' ',
'c','a','n',' ','b','e',' ','p','r','e','s','e','r','v','e','d',' ','b','e','t','w','e','e','n',' ','s','e','s','s','i','o','n','s',' ','b','y',' ','s','e','l','e','c','t','i','n','g',' ','S','a','v','e',' ','D','e','f','a','u','l','t','s',',',' ',
'w','h','i','c','h',' ','w','r','i','t','e','s',' ','a',' ','f','i','l','e',' ','c','a','l','l','e','d',' ','.','n','e','d','i','t',' ','i','n',' ','t','h','e',' ','u','s','e','r',''','s',' ',
'h','o','m','e',' ','d','i','r','e','c','t','o','r','y','.',' ',' ','S','e','e',' ','t','h','e',' ','s','e','c','t','i','o','n',' ','t','i','t','l','e','d',' ','\"','P','r','e','f','e','r','e','n','c','e','s','\"',' ','f','o','r',' ','m','o','r','e',' ','d','e','t','a','i','l','s','.','\n',
'\n',
'U','s','e','r',' ','d','e','f','i','n','e','d',' ','c','o','m','m','a','n','d','s',' ','c','a','n',' ','b','e',' ','a','d','d','e','d',' ','t','o',' ','N','E','d','i','t',''','s',' ','S','h','e','l','l',',',' ','M','a','c','r','o',',',' ','a','n','d',' ','w','i','n','d','o','w',' ',
'b','a','c','k','g','r','o','u','n','d',' ','m','e','n','u','s','.',' ',' ','D','i','a','l','o','g','s',' ','f','o','r',' ','c','r','e','a','t','i','n','g',' ','i','t','e','m','s',' ','i','n',' ','t','h','e','s','e',' ','m','e','n','u','s',' ','c','a','n',' ','b','e',' ','f','o','u','n','d',' ',
'u','n','d','e','r',' ','C','u','s','t','o','m','i','z','e',' ','M','e','n','u','s',' ','i','n',' ','t','h','e',' ','D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s',' ','s','u','b',' ','m','e','n','u',' ','o','f',' ','t','h','e',' ','P','r','e','f','e','r','e','n','c','e','s',' ',
'm','e','n','u','.','\n',
'\n',
'F','o','r',' ','u','s','e','r','s',' ','w','h','o',' ','d','e','p','e','n','d',' ','o','n',' ','N','E','d','i','t',' ','e','v','e','r','y',' ','d','a','y',' ','a','n','d',' ','w','a','n','t',' ','t','o',' ','t','u','n','e',' ',
'e','v','e','r','y',' ','e','x','c','r','u','c','i','a','t','i','n','g',' ','d','e','t','a','i','l',',',' ','t','h','e','r','e',' ','a','r','e',' ','a','l','s','o',' ','X',' ','r','e','s','o','u','r','c','e','s',' ','f','o','r',' ','t','u','n','i','n','g',' ','a',' ','v','a','s','t',' ','n','u','m','b','e','r',' ',
'o','f',' ','s','u','c','h',' ','d','e','t','a','i','l','s',',',' ','d','o','w','n',' ','t','o',' ','t','h','e',' ','c','o','l','o','r',' ','o','f',' ','e','a','c','h',' ','i','n','d','i','v','i','d','u','a','l',' ','b','u','t','t','o','n','.',' ',' ','S','e','e',' ',
't','h','e',' ','s','e','c','t','i','o','n',' ','\"','X',' ','R','e','s','o','u','r','c','e','s','\"',' ','f','o','r',' ','m','o','r','e',' ','i','n','f','o','r','m','a','t','i','o','n',',',' ','a','s',' ','w','e','l','l',' ','a','s',' ','a',' ','l','i','s','t',' ','o','f',' ',
's','e','l','e','c','t','e','d',' ','r','e','s','o','u','r','c','e','s','.','\n',
'\n',
'T','h','e',' ','m','o','s','t',' ','c','o','m','m','o','n',' ','r','e','a','s','o','n',' ','c','u','s','t','o','m','i','z','i','n','g',' ','y','o','u','r',' ','X',' ','r','e','s','o','u','r','c','e','s',' ','f','o','r',' ','N','E','d','i','t',',',' ','h','o','w','e','v','e','r',',',' ',
'i','s',' ','k','e','y',' ','b','i','n','d','i','n','g','.',' ',' ','W','h','i','l','e',' ','l','i','m','i','t','e','d',' ','k','e','y',' ','b','i','n','d','i','n','g',' ','c','a','n',' ','b','e',' ','d','o','n','e',' ','t','h','r','o','u','g','h',' ','P','r','e','f','e','r','e','n','c','e','s',' ',
's','e','t','t','i','n','g','s',' ','(','P','r','e','f','e','r','e','n','c','e','s',' ','-','>',' ','D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s',' ','-','>',' ','C','u','s','t','o','m','i','z','e',' ','M','e','n','u','s',')',',',' ','y','o','u',' ','c','a','n',' ','r','e','a','l','l','y',' ',
'o','n','l','y',' ','a','d','d',' ','k','e','y','s',' ','t','h','i','s',' ','w','a','y',',',' ','a','n','d',' ','e','a','c','h',' ','k','e','y',' ','m','u','s','t',' ','h','a','v','e',' ','a',' ','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','m','e','n','u',' ','i','t','e','m','.',' ',' ',
'A','n','y',' ','s','i','g','n','i','f','i','c','a','n','t',' ','c','h','a','n','g','e','s',' ','t','o',' ','k','e','y',' ','b','i','n','d','i','n','g',' ','s','h','o','u','l','d',' ','b','e',' ','m','a','d','e',' ','v','i','a',' ','t','h','e',' ','T','r','a','n','s','l','a','t','i','o','n','s',' ',
'r','e','s','o','u','r','c','e',' ','a','n','d',' ','m','e','n','u',' ',
'a','c','c','e','l','e','r','a','t','o','r',' ','r','e','s','o','u','r','c','e','s','.',' ',' ','T','h','e',' ','s','e','c','t','i','o','n','s',' ','t','i','t','l','e','d',' ','\"','K','e','y',' ','B','i','n','d','i','n','g','\"',' ','a','n','d',' ',
'\"','X',' ','R','e','s','o','u','r','c','e','s','\"',' ','h','a','v','e',' ','m','o','r','e',' ','i','n','f','o','r','m','a','t','i','o','n','.','\0'};

static char AuxString20[] = {'N','E','d','i','t',' ','h','a','s',' ','a','d','d','i','t','i','o','n','a','l',' ','o','p','t','i','o','n','s',' ','t','o',' ','t','h','o','s','e',' ','p','r','o','v','i','d','e','d',' ','i','n',' ','t','h','e',' ','P','r','e','f','e','r','e','n','c','e','s',' ','m','e','n','u',' ',
'w','h','i','c','h',' ','a','r','e',' ','s','e','t',' ','u','s','i','n','g',' ','X',' ','r','e','s','o','u','r','c','e','s','.',' ',' ',
'L','i','k','e',' ','m','o','s','t',' ','o','t','h','e','r',' ','X',' ','p','r','o','g','r','a','m','s',',',' ','N','E','d','i','t',' ','c','a','n',' ','b','e',' ','c','u','s','t','o','m','i','z','e','d',' ','t','o',' ','v','a','s','t','l','y',' ','u','n','n','e','c','e','s','s','a','r','y',' ',
'p','r','o','p','o','r','t','i','o','n','s',',',' ','f','r','o','m',' ','i','n','i','t','i','a','l',' ','w','i','n','d','o','w',' ','p','o','s','i','t','i','o','n','s',' ','d','o','w','n',' ','t','o',' ','t','h','e',' ','f','o','n','t',' ','a','n','d',' ','s','h','a','d','o','w',' ',
'c','o','l','o','r','s',' ','o','f',' ','e','a','c','h',' ','i','n','d','i','v','i','d','u','a','l',' ','b','u','t','t','o','n',' ','(','A',' ','c','o','m','p','l','e','t','e',' ','d','i','s','c','u','s','s','i','o','n',' ','o','f',' ','h','o','w',' ','t','o',' ','d','o',' ',
't','h','i','s',' ','i','s',' ','l','e','f','t',' ','t','o',' ','b','o','o','k','s',' ','o','n',' ','t','h','e',' ','X',' ','W','i','n','d','o','w','s',' ','S','y','s','t','e','m',')','.',' ',' ','K','e','y',' ','b','i','n','d','i','n','g',' ','(','s','e','e',' ',
'\"','K','e','y',' ','B','i','n','d','i','n','g','\"',' ',
'i','s',' ','o','n','e',' ','o','f',' ','t','h','e',' ','m','o','s','t',' ','u','s','e','f','u','l',' ','o','f',' ','t','h','e','s','e',' ','r','e','s','o','u','r','c','e',' ','s','e','t','t','a','b','l','e',' ','o','p','t','i','o','n','s','.','\n',
'\n',
'X',' ','r','e','s','o','u','r','c','e','s',' ','a','r','e',' ','u','s','u','a','l','l','y',' ','s','p','e','c','i','f','i','e','d',' ','i','n',' ','a',' ','f','i','l','e',' ','c','a','l','l','e','d',' ','.','X','d','e','f','a','u','l','t','s',' ','o','r',' ',
'.','X','r','e','s','o','u','r','c','e','s',' ','i','n',' ','y','o','u','r',' ',
'h','o','m','e',' ','d','i','r','e','c','t','o','r','y',' ','(','o','n',' ','V','M','S',' ','t','h','i','s',' ','i','s',' ','s','y','s','$','l','o','g','i','n',':','d','e','c','w','$','x','d','e','f','a','u','l','t','s','.','d','a','t',')','.',' ',' ','O','n',' ','s','o','m','e',' ',
's','y','s','t','e','m','s',',',' ','t','h','i','s',' ','f','i','l','e',' ','i','s',' ','r','e','a','d',' ','a','n','d',' ','i','t','s',' ','i','n','f','o','r','m','a','t','i','o','n',' ',
'a','t','t','a','c','h','e','d',' ','t','o',' ','t','h','e',' ','X',' ','s','e','r','v','e','r',' ','(','y','o','u','r',' ','s','c','r','e','e','n',')',' ','w','h','e','n',' ','y','o','u',' ','s','t','a','r','t',' ','X','.',' ',' ','O','n',' ','o','t','h','e','r',' ',
's','y','s','t','e','m','s',',',' ','t','h','e',' ','.','X','d','e','f','a','u','l','t','s',' ','f','i','l','e',' ','i','s',' ','r','e','a','d',' ','e','a','c','h',' ','t','i','m','e',' ','y','o','u',' ','r','u','n',' ','a','n',' ','X',' ','p','r','o','g','r','a','m','.',' ',' ',
'W','h','e','n',' ','X',' ','r','e','s','o','u','r','c','e',' ','v','a','l','u','e','s',' ','a','r','e',' ','a','t','t','a','c','h','e','d',' ','t','o',' ','t','h','e',' ','X',' ','s','e','r','v','e','r',',',' ','c','h','a','n','g','e','s',' ','t','o',' ','t','h','e',' ',
'r','e','s','o','u','r','c','e',' ','f','i','l','e',' ','a','r','e',' ','n','o','t',' ','a','v','a','i','l','a','b','l','e',' ','t','o',' ','a','p','p','l','i','c','a','t','i','o','n',' ','p','r','o','g','r','a','m','s',' ','u','n','t','i','l',' ','y','o','u',' ','e','i','t','h','e','r',' ','r','u','n',' ',
't','h','e',' ','x','r','d','b',' ','p','r','o','g','r','a','m',' ','w','i','t','h',' ','t','h','e',' ','a','p','p','r','o','p','r','i','a','t','e',' ','f','i','l','e',' ','a','s',' ','i','n','p','u','t',',',' ','o','r',' ','r','e','-','s','t','a','r','t',' ',
't','h','e',' ','X',' ','s','e','r','v','e','r','.','\n',
'\n',
'T','h','e',' ','.','n','e','d','i','t',' ','F','i','l','e','\n',
'\n',
'T','h','e',' ','.','n','e','d','i','t',' ','(','s','a','v','e','d',' ','p','r','e','f','e','r','e','n','c','e','s',')',' ','f','i','l','e',' ','i','s',' ','i','n',' ','t','h','e',' ','s','a','m','e',' ','f','o','r','m','a','t',' ','a','s',' ','a','n',' ','X',' ','r','e','s','o','u','r','c','e',' ',
'f','i','l','e',',',' ','a','n','d',' ','i','t','s',' ','c','o','n','t','e','n','t','s',' ','c','a','n',' ','b','e',' ','m','o','v','e','d',' ','i','n','t','o',' ','y','o','u','r',' ','X',' ','r','e','s','o','u','r','c','e',' ','f','i','l','e','.',' ',' ','O','n','e',' ','r','e','a','s','o','n',' ',
'f','o','r',' ','d','o','i','n','g',' ','s','o',' ','w','o','u','l','d',' ','b','e',' ','t','o',' ','a','t','t','a','c','h',' ','s','e','r','v','e','r',' ','s','p','e','c','i','f','i','c',' ','p','r','e','f','e','r','e','n','c','e','s',',',' ','s','u','c','h',' ','a','s',' ',
'a',' ','d','e','f','a','u','l','t',' ','f','o','n','t',' ','t','o',' ','a',' ','p','a','r','t','i','c','u','l','a','r',' ','X',' ','s','e','r','v','e','r','.',' ',' ','A','n','o','t','h','e','r',' ','r','e','a','s','o','n',' ','f','o','r',' ','m','o','v','i','n','g',' ',
'p','r','e','f','e','r','e','n','c','e','s',' ','i','n','t','o',' ','t','h','e',' ','X',' ','r','e','s','o','u','r','c','e',' ','f','i','l','e',' ','w','o','u','l','d',' ','b','e',' ','t','o',' ','k','e','e','p',' ','p','r','e','f','e','r','e','n','c','e','s',' ','m','e','n','u',' ',
'o','p','t','i','o','n','s',' ','a','n','d',' ','r','e','s','o','u','r','c','e',' ','s','e','t','t','a','b','l','e',' ','o','p','t','i','o','n','s',' ','t','o','g','e','t','h','e','r',' ','i','n',' ','o','n','e',' ','p','l','a','c','e','.',' ','T','h','o','u','g','h',' ',
't','h','e',' ','f','i','l','e','s',' ','a','r','e',' ','t','h','e',' ','s','a','m','e',' ','f','o','r','m','a','t',',',' ','a','d','d','i','t','i','o','n','a','l',' ','r','e','s','o','u','r','c','e','s',' ','s','h','o','u','l','d',' ','n','o','t',' ','b','e',' ','a','d','d','e','d',' ',
't','o',' ','t','h','e',' ','.','n','e','d','i','t',' ','f','i','l','e',',',' ','t','h','e','y',' ','w','i','l','l',' ','n','o','t',' ','b','e',' ','r','e','a','d',',',' ','a','n','d',' ','N','E','d','i','t',' ','m','o','d','i','f','i','e','s',' ','t','h','i','s',' ','f','i','l','e',' ',
'b','y',' ','o','v','e','r','w','r','i','t','i','n','g',' ','i','t',' ','c','o','m','p','l','e','t','e','l','y','.',' ',' ','N','o','t','e',' ','a','l','s','o',' ','t','h','a','t',' ','t','h','e',' ','c','o','n','t','e','n','t','s',' ','o','f',' ','t','h','e',' ','.','n','e','d','i','t',' ',
'f','i','l','e',' ','t','a','k','e',' ','p','r','e','c','e','d','e','n','c','e',' ','o','v','e','r',' ','t','h','e',' ','v','a','l','u','e','s',' ','o','f',' ','X',' ','r','e','s','o','u','r','c','e','s','.',' ',' ','U','s','i','n','g',' ',
'S','a','v','e',' ','D','e','f','a','u','l','t','s',' ','a','f','t','e','r',' ','m','o','v','i','n','g',' ','t','h','e',' ','c','o','n','t','e','n','t','s',' ','o','f',' ','y','o','u','r',' ','.','n','e','d','i','t',' ','f','i','l','e',' ','t','o',' ','y','o','u','r',' ',
'.','X','d','e','f','a','u','l','t','s',' ','f','i','l','e',' ','w','i','l','l',' ','r','e','-','c','r','e','a','t','e',' ','t','h','e',' ','.','n','e','d','i','t',' ','f','i','l','e',',',' ','i','n','t','e','r','f','e','r','i','n','g',' ','w','i','t','h',' ',
't','h','e',' ','o','p','t','i','o','n','s',' ','t','h','a','t',' ','y','o','u',' ','h','a','v','e',' ','m','o','v','e','d','.','\n',
'\n',
'S','e','l','e','c','t','e','d',' ','X',' ','R','e','s','o','u','r','c','e',' ','N','a','m','e','s','\n',
'\n',
'T','h','e',' ','f','o','l','l','o','w','i','n','g',' ','a','r','e',' ','s','e','l','e','c','t','e','d',' ','N','E','d','i','t',' ','r','e','s','o','u','r','c','e',' ','n','a','m','e','s',' ','a','n','d',' ','d','e','f','a','u','l','t',' ','v','a','l','u','e','s',' ',
'f','o','r',' ','N','E','d','i','t',' ','o','p','t','i','o','n','s',' ','n','o','t',' ','s','e','t','t','a','b','l','e',' ','v','i','a',' ','t','h','e',' ','P','r','e','f','e','r','e','n','c','e','s',' ','m','e','n','u',' ','(','f','o','r',' ','p','r','e','f','e','r','e','n','c','e',' ',
'r','e','s','o','u','r','c','e',' ','n','a','m','e','s',',',' ','s','e','e',' ','y','o','u','r',' ','.','n','e','d','i','t',' ','f','i','l','e',')',':','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','.','t','a','g','F','i','l','e',':',' ','(','n','o','t',' ','d','e','f','i','n','e','d',')',' ','-','-',' ','T','h','e',' ','n','a','m','e',' ','o','f',' ','a',' ','f','i','l','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','o','f',' ','t','h','e',' ','t','y','p','e',' ','p','r','o','d','u','c','e','d',' ','b','y',' ','t','h','e',' ','U','n','i','x',' ','c','t','a','g','s',' ','c','o','m','m','a','n','d','\n',
' ',' ',' ',' ',' ',' ',' ',' ','w','h','i','c','h',' ','N','E','d','i','t',' ','w','i','l','l',' ','l','o','a','d',' ','a','t',' ','s','t','a','r','t','u','p',' ','t','i','m','e',' ','(','s','e','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','F','e','a','t','u','r','e','s',' ','f','o','r',' ','P','r','o','g','r','a','m','m','e','r','s',')','.',' ',' ','T','h','e',' ','t','a','g',' ','f','i','l','e',' ','p','r','o','v','i','d','e','s','\n',
' ',' ',' ',' ',' ',' ',' ',' ','a',' ','d','a','t','a','b','a','s','e',' ','f','r','o','m',' ','w','h','i','c','h',' ','N','E','d','i','t',' ','c','a','n',' ','a','u','t','o','m','a','t','i','c','a','l','l','y','\n',
' ',' ',' ',' ',' ',' ',' ',' ','o','p','e','n',' ','f','i','l','e','s',' ','c','o','n','t','a','i','n','i','n','g',' ','t','h','e',' ','d','e','f','i','n','i','t','i','o','n',' ','o','f',' ','a','\n',
' ',' ',' ',' ',' ',' ',' ',' ','p','a','r','t','i','c','u','l','a','r',' ','s','u','b','r','o','u','t','i','n','e',' ','o','r',' ','d','a','t','a',' ','t','y','p','e','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','.','s','h','e','l','l',':',' ','/','b','i','n','/','c','s','h',' ','-','-',' ','(','U','n','i','x',' ','s','y','s','t','e','m','s',' ','o','n','l','y',')',' ','T','h','e',' ','U','n','i','x','\n',
' ',' ',' ',' ',' ',' ',' ',' ','s','h','e','l','l',' ','(','c','o','m','m','a','n','d',' ','i','n','t','e','r','p','r','e','t','e','r',')',' ','t','o',' ','u','s','e',' ','f','o','r',' ','e','x','e','c','u','t','i','n','g','\n',
' ',' ',' ',' ',' ',' ',' ',' ','c','o','m','m','a','n','d','s',' ','f','r','o','m',' ','t','h','e',' ','S','h','e','l','l',' ','m','e','n','u','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','.','w','o','r','d','D','e','l','i','m','i','t','e','r','s',':',' ','.',',','/','\\','\\','`',''','!','@','#','%','^','&','*','(',')','-','=','+','{','}','[',']','\"',':',';','<','>','?','\n',
' ',' ',' ',' ',' ',' ',' ',' ','-','-',' ','T','h','e',' ','c','h','a','r','a','c','t','e','r','s',',',' ','i','n',' ','a','d','d','i','t','i','o','n',' ','t','o',' ','b','l','a','n','k','s',' ','a','n','d',' ','t','a','b','s',',','\n',
' ',' ',' ',' ',' ',' ',' ',' ','w','h','i','c','h',' ','m','a','r','k',' ','t','h','e',' ','b','o','u','n','d','a','r','i','e','s',' ','b','e','t','w','e','e','n',' ','w','o','r','d','s',' ','f','o','r',' ','t','h','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','m','o','v','e','-','b','y','-','w','o','r','d',' ','(','C','t','r','l','+','A','r','r','o','w',')',' ','a','n','d',' ','s','e','l','e','c','t','-','w','o','r','d',' ','(','d','o','u','b','l','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','c','l','i','c','k',')',' ','c','o','m','m','a','n','d','s','.',' ',' ','N','o','t','e',' ','t','h','a','t',' ','t','h','i','s',' ','d','e','f','a','u','l','t',' ','v','a','l','u','e',' ','m','a','y','\n',
'	','b','e',' ','o','v','e','r','r','i','d','d','e','n',' ','b','y',' ','t','h','e',' ','s','e','t','t','i','n','g',' ','i','n',' ','P','r','e','f','e','r','e','n','c','e','s',' ','-','>','\n',
'	','D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s',' ','-','>',' ','L','a','n','g','u','a','g','e',' ','M','o','d','e','s','.','.','.','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','.','r','e','m','a','p','D','e','l','e','t','e','K','e','y',':',' ','T','r','u','e',' ','-','-',' ','S','e','t','t','i','n','g',' ','t','h','i','s',' ','r','e','s','o','u','r','c','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','t','o',' ','F','a','l','s','e',' ','r','e','s','t','o','r','e','s',' ','t','h','e',' ','o','r','i','g','i','n','a','l',' ','M','o','t','i','f',' ','b','i','n','d','i','n','g',' ','o','f','\n',
' ',' ',' ',' ',' ',' ',' ',' ','t','h','e',' ','d','e','l','e','t','e',' ','k','e','y',' ','t','o',' ','f','o','r','w','a','r','d','-','d','e','l','e','t','e','.',' ',' ','T','h','i','s',' ','b','i','n','d','i','n','g','\n',
' ',' ',' ',' ',' ',' ',' ',' ','c','a','u','s','e','s',' ','p','r','o','b','l','e','m','s',' ','w','h','e','n',' ','X',' ','s','e','r','v','e','r','s',' ','w','i','t','h',' ','o','n','e',' ','d','e','l','e','t','e','/','\n',
' ',' ',' ',' ',' ',' ',' ',' ','b','a','c','k','s','p','a','c','e',' ','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','a','r','e',' ','c','o','n','n','e','c','t','e','d',' ','w','i','t','h',' ','X','\n',
' ',' ',' ',' ',' ',' ',' ',' ','c','l','i','e','n','t','s',' ','o','f',' ','t','h','e',' ','o','t','h','e','r','.',' ',' ','U','s','e','r','s',' ','w','i','t','h',' ','a',' ','b','a','c','k','s','p','a','c','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','k','e','y',' ','i','n',' ','t','h','e',' ','b','a','c','k','s','p','a','c','e','/','d','e','l','e','t','e',' ','p','o','s','i','t','i','o','n',' ','a','n','d',' ','w','h','o',' ','u','s','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','o','n','l','y',' ','m','a','c','h','i','n','e','s',' ','w','i','t','h',' ','t','h','a','t',' ','s','t','y','l','e',' ','o','f',' ','k','e','y','b','o','a','r','d',' ','c','a','n','\n',
' ',' ',' ',' ',' ',' ',' ',' ','s','e','t',' ','t','h','i','s',' ','r','e','s','o','u','r','c','e',' ','t','o',' ','F','a','l','s','e',' ','t','o',' ','g','e','t',' ','b','a','c','k',' ','t','h','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','f','o','r','w','a','r','d','-','d','e','l','e','t','e',' ','f','u','n','c','t','i','o','n',' ','o','f',' ','t','h','e',' ','d','e','l','e','t','e',' ','k','e','y','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','.','s','t','d','O','p','e','n','D','i','a','l','o','g',':',' ','F','a','l','s','e',' ','-','-',' ','S','e','t','t','i','n','g',' ','t','h','i','s',' ','r','e','s','o','u','r','c','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','t','o',' ','T','r','u','e',' ','r','e','s','t','o','r','e','s',' ','t','h','e',' ','s','t','a','n','d','a','r','d',' ','M','o','t','i','f',' ','s','t','y','l','e',' ','o','f','\n',
' ',' ',' ',' ',' ',' ',' ',' ','O','p','e','n',' ','d','i','a','l','o','g','.',' ',' ','N','E','d','i','t',' ','f','i','l','e',' ','o','p','e','n',' ','d','i','a','l','o','g','s',' ','a','r','e',' ','m','i','s','s','i','n','g','\n',
' ',' ',' ',' ',' ',' ',' ',' ','a',' ','t','e','x','t',' ','f','i','e','l','d',' ','a','t',' ','t','h','e',' ','b','o','t','t','o','m',' ','o','f',' ','t','h','e',' ','d','i','a','l','o','g',',',' ','w','h','e','r','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','t','h','e',' ','f','i','l','e',' ','n','a','m','e',' ','c','a','n',' ','b','e',' ','e','n','t','e','r','e','d',' ','a','s',' ','a',' ','s','t','r','i','n','g','.',' ',' ','T','h','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','f','i','e','l','d',' ','i','s',' ','r','e','m','o','v','e','d',' ','i','n',' ','N','E','d','i','t',' ','t','o',' ','e','n','c','o','u','r','a','g','e',' ','u','s','e','r','s',' ','t','o','\n',
' ',' ',' ',' ',' ',' ',' ',' ','t','y','p','e',' ','f','i','l','e',' ','n','a','m','e','s',' ','i','n',' ','t','h','e',' ','l','i','s','t',',',' ','a',' ','n','o','n','-','s','t','a','n','d','a','r','d',',',' ','b','u','t','\n',
' ',' ',' ',' ',' ',' ',' ',' ','m','u','c','h',' ','f','a','s','t','e','r',' ','m','e','t','h','o','d',' ','f','o','r',' ','f','i','n','d','i','n','g',' ','f','i','l','e','s','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','.','b','g','M','e','n','u','B','u','t','t','o','n',':',' ','~','S','h','i','f','t','~','C','t','r','l','~','M','e','t','a','~','A','l','t','<','B','t','n','3','D','o','w','n','>',' ','-','-','\n',
' ',' ',' ',' ',' ',' ',' ',' ','S','p','e','c','i','f','i','c','a','t','i','o','n',' ','f','o','r',' ','m','o','u','s','e',' ','b','u','t','t','o','n',' ','/',' ','k','e','y',' ','c','o','m','b','i','n','a','t','i','o','n','\n',
'	','t','o',' ','p','o','s','t',' ','t','h','e',' ','b','a','c','k','g','r','o','u','n','d',' ','m','e','n','u',' ','(','i','n',' ','t','h','e',' ','f','o','r','m',' ','o','f',' ','a','n',' ','X','\n',
'	','t','r','a','n','s','l','a','t','i','o','n',' ','t','a','b','l','e',' ','e','v','e','n','t',' ','s','p','e','c','i','f','i','c','a','t','i','o','n',')','.',' ',' ','T','h','e',' ','e','v','e','n','t','\n',
'	','s','p','e','c','i','f','i','c','a','t','i','o','n',' ','s','h','o','u','l','d',' ','b','e',' ','a','s',' ','s','p','e','c','i','f','i','c',' ','a','s',' ','p','o','s','s','i','b','l','e',',','\n',
'	','s','i','n','c','e',' ','i','t',' ','w','i','l','l',' ','o','v','e','r','r','i','d','e',' ','l','e','s','s',' ','s','p','e','c','i','f','i','c',' ','t','r','a','n','s','l','a','t','i','o','n','\n',
' ',' ',' ',' ','	','t','a','b','l','e',' ','e','n','t','r','i','e','s','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','.','m','a','x','P','r','e','v','O','p','e','n','F','i','l','e','s',':',' ','3','0',' ','-','-',' ','N','u','m','b','e','r',' ','o','f',' ','f','i','l','e','s',' ','l','i','s','t','e','d','\n',
' ',' ',' ',' ',' ',' ',' ',' ','i','n',' ','t','h','e',' ','O','p','e','n',' ','P','r','e','v','i','o','u','s',' ','s','u','b','-','m','e','n','u',' ','o','f',' ','t','h','e',' ','F','i','l','e',' ','m','e','n','u','.','\n',
' ',' ',' ',' ',' ',' ',' ',' ','S','e','t','t','i','n','g',' ','t','h','i','s',' ','t','o',' ','z','e','r','o',' ','d','i','s','a','b','l','e','s',' ','t','h','e',' ','O','p','e','n',' ','P','r','e','v','i','o','u','s','\n',
' ',' ',' ',' ',' ',' ',' ',' ','m','e','n','u',' ','i','t','e','m',' ','a','n','d',' ','m','a','i','n','t','e','n','a','n','c','e',' ','o','f',' ','t','h','e',' ','.','n','e','d','i','t','d','b',' ','f','i','l','e','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','.','p','r','i','n','t','C','o','m','m','a','n','d',':',' ','(','s','y','s','t','e','m',' ','s','p','e','c','i','f','i','c',')',' ','-','-',' ','C','o','m','m','a','n','d',' ','u','s','e','d','\n',
' ',' ',' ',' ',' ',' ',' ',' ','b','y',' ','t','h','e',' ','p','r','i','n','t',' ','d','i','a','l','o','g',' ','t','o',' ','p','r','i','n','t',' ','a',' ','f','i','l','e',',',' ','i','.','e','.',' ','l','p',',','\n',
' ',' ',' ',' ',' ',' ',' ',' ','l','p','r',',',' ','e','t','c','.','.',' ',' ','T','h','e',' ','c','o','m','m','a','n','d',' ','m','u','s','t',' ','b','e',' ','c','a','p','a','b','l','e',' ','o','f','\n',
' ',' ',' ',' ',' ',' ',' ',' ','a','c','c','e','p','t','i','n','g',' ','i','n','p','u','t',' ','v','i','a',' ','s','t','d','i','n',' ','(','s','t','a','n','d','a','r','d',' ','i','n','p','u','t',')','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','.','p','r','i','n','t','C','o','p','i','e','s','O','p','t','i','o','n',':',' ','(','s','y','s','t','e','m',' ','s','p','e','c','i','f','i','c',')',' ','-','-',' ','O','p','t','i','o','n','\n',
' ',' ',' ',' ',' ',' ',' ',' ','n','a','m','e',' ','u','s','e','d',' ','t','o',' ','s','p','e','c','i','f','y',' ','m','u','l','t','i','p','l','e',' ','c','o','p','i','e','s',' ','t','o',' ','t','h','e',' ','p','r','i','n','t','\n',
' ',' ',' ',' ',' ',' ',' ',' ','c','o','m','m','a','n','d','.',' ',' ','I','f',' ','t','h','e',' ','o','p','t','i','o','n',' ','s','h','o','u','l','d',' ','b','e',' ','s','e','p','a','r','a','t','e','d',' ','f','r','o','m','\n',
' ',' ',' ',' ',' ',' ',' ',' ','i','t','s',' ','a','r','g','u','m','e','n','t',' ','b','y',' ','a',' ','s','p','a','c','e',',',' ','l','e','a','v','e',' ','a',' ','t','r','a','i','l','i','n','g',' ','s','p','a','c','e','.','\n',
' ',' ',' ',' ',' ',' ',' ',' ','I','f',' ','b','l','a','n','k',',',' ','n','o',' ','\"','N','u','m','b','e','r',' ','o','f',' ','C','o','p','i','e','s','\"',' ','i','t','e','m',' ','w','i','l','l','\n',
' ',' ',' ',' ',' ',' ',' ',' ','a','p','p','e','a','r',' ','i','n',' ','t','h','e',' ','p','r','i','n','t',' ','d','i','a','l','o','g','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','.','p','r','i','n','t','Q','u','e','u','e','O','p','t','i','o','n',':',' ','(','s','y','s','t','e','m',' ','s','p','e','c','i','f','i','c',')',' ','-','-',' ','O','p','t','i','o','n','\n',
' ',' ',' ',' ',' ',' ',' ',' ','n','a','m','e',' ','u','s','e','d',' ','t','o',' ','s','p','e','c','i','f','y',' ','a',' ','p','r','i','n','t',' ','q','u','e','u','e',' ','t','o',' ','t','h','e',' ','p','r','i','n','t','\n',
' ',' ',' ',' ',' ',' ',' ',' ','c','o','m','m','a','n','d','.',' ',' ','I','f',' ','t','h','e',' ','o','p','t','i','o','n',' ','s','h','o','u','l','d',' ','b','e',' ','s','e','p','a','r','a','t','e','d',' ','f','r','o','m','\n',
' ',' ',' ',' ',' ',' ',' ',' ','i','t','s',' ','a','r','g','u','m','e','n','t',' ','b','y',' ','a',' ','s','p','a','c','e',',',' ','l','e','a','v','e',' ','a',' ','t','r','a','i','l','i','n','g',' ','s','p','a','c','e','.','\n',
' ',' ',' ',' ',' ',' ',' ',' ','I','f',' ','b','l','a','n','k',',',' ','n','o',' ','\"','Q','u','e','u','e','\"',' ','i','t','e','m',' ','w','i','l','l',' ','a','p','p','e','a','r',' ','i','n',' ','t','h','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','p','r','i','n','t',' ','d','i','a','l','o','g','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','.','p','r','i','n','t','N','a','m','e','O','p','t','i','o','n',':',' ','(','s','y','s','t','e','m',' ','s','p','e','c','i','f','i','c',')',' ','-','-',' ','O','p','t','i','o','n','\n',
' ',' ',' ',' ',' ',' ',' ',' ','n','a','m','e',' ','u','s','e','d',' ','t','o',' ','s','p','e','c','i','f','y',' ','a',' ','j','o','b',' ','n','a','m','e',' ','t','o',' ','t','h','e',' ','p','r','i','n','t','\n',
' ',' ',' ',' ',' ',' ',' ',' ','c','o','m','m','a','n','d','.',' ',' ','I','f',' ','t','h','e',' ','o','p','t','i','o','n',' ','s','h','o','u','l','d',' ','b','e',' ','s','e','p','a','r','a','t','e','d',' ','f','r','o','m','\n',
' ',' ',' ',' ',' ',' ',' ',' ','i','t','s',' ','a','r','g','u','m','e','n','t',' ','b','y',' ','a',' ','s','p','a','c','e',',',' ','l','e','a','v','e',' ','a',' ','t','r','a','i','l','i','n','g',' ','s','p','a','c','e','.','\n',
' ',' ',' ',' ',' ',' ',' ',' ','I','f',' ','b','l','a','n','k',',',' ','n','o',' ','j','o','b',' ','o','r',' ','f','i','l','e',' ','n','a','m','e',' ','w','i','l','l',' ','b','e',' ','a','t','t','a','c','h','e','d','\n',
' ',' ',' ',' ',' ',' ',' ',' ','t','o',' ','t','h','e',' ','p','r','i','n','t',' ','j','o','b',' ','o','r',' ','b','a','n','n','e','r',' ','p','a','g','e','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','.','p','r','i','n','t','H','o','s','t','O','p','t','i','o','n',':',' ','(','s','y','s','t','e','m',' ','s','p','e','c','i','f','i','c',')',' ','-','-',' ','O','p','t','i','o','n','\n',
' ',' ',' ',' ',' ',' ',' ',' ','n','a','m','e',' ','u','s','e','d',' ','t','o',' ','s','p','e','c','i','f','y',' ','a',' ','h','o','s','t',' ','n','a','m','e',' ','t','o',' ','t','h','e',' ','p','r','i','n','t','\n',
' ',' ',' ',' ',' ',' ',' ',' ','c','o','m','m','a','n','d','.',' ',' ','I','f',' ','t','h','e',' ','o','p','t','i','o','n',' ','s','h','o','u','l','d',' ','b','e',' ','s','e','p','a','r','a','t','e','d',' ','f','r','o','m','\n',
' ',' ',' ',' ',' ',' ',' ',' ','i','t','s',' ','a','r','g','u','m','e','n','t',' ','b','y',' ','a',' ','s','p','a','c','e',',',' ','l','e','a','v','e',' ','a',' ','t','r','a','i','l','i','n','g',' ','s','p','a','c','e','.','\n',
' ',' ',' ',' ',' ',' ',' ',' ','I','f',' ','b','l','a','n','k',',',' ','n','o',' ','\"','H','o','s','t','\"',' ','i','t','e','m',' ','w','i','l','l',' ','a','p','p','e','a','r',' ','i','n',' ','t','h','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','p','r','i','n','t',' ','d','i','a','l','o','g','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','.','p','r','i','n','t','D','e','f','a','u','l','t','Q','u','e','u','e',':',' ','(','s','y','s','t','e','m',' ','s','p','e','c','i','f','i','c',')',' ','-','-',' ','T','h','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','n','a','m','e',' ','o','f',' ','t','h','e',' ','d','e','f','a','u','l','t',' ','p','r','i','n','t',' ','q','u','e','u','e','.',' ',' ','U','s','e','d',' ','o','n','l','y',' ','t','o','\n',
' ',' ',' ',' ',' ',' ',' ',' ','d','i','s','p','l','a','y',' ','i','n',' ','t','h','e',' ','p','r','i','n','t',' ','d','i','a','l','o','g',',',' ','a','n','d',' ','h','a','s',' ','n','o',' ','e','f','f','e','c','t',' ','o','n','\n',
' ',' ',' ',' ',' ',' ',' ',' ','p','r','i','n','t','i','n','g','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','.','p','r','i','n','t','D','e','f','a','u','l','t','H','o','s','t',':',' ','(','s','y','s','t','e','m',' ','s','p','e','c','i','f','i','c',')',' ','-','-',' ','T','h','e','\n',
' ',' ',' ',' ',' ',' ',' ',' ','n','o','d','e',' ','n','a','m','e',' ','o','f',' ','t','h','e',' ','d','e','f','a','u','l','t',' ','p','r','i','n','t',' ','h','o','s','t','.',' ',' ','U','s','e','d',' ','o','n','l','y','\n',
' ',' ',' ',' ',' ',' ',' ',' ','t','o',' ','d','i','s','p','l','a','y',' ','i','n',' ','t','h','e',' ','p','r','i','n','t',' ','d','i','a','l','o','g',',',' ','a','n','d',' ','h','a','s',' ','n','o',' ','e','f','f','e','c','t','\n',
' ',' ',' ',' ',' ',' ',' ',' ','o','n',' ','p','r','i','n','t','i','n','g','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','.','m','u','l','t','i','C','l','i','c','k','T','i','m','e',':',' ','(','s','y','s','t','e','m',' ','s','p','e','c','i','f','i','c',')',' ','-','-',' ','M','a','x','i','m','u','m','\n',
' ',' ',' ',' ',' ',' ',' ',' ','t','i','m','e',' ','i','n',' ','m','i','l','l','i','s','e','c','o','n','d','s',' ','a','l','l','o','w','e','d',' ','b','e','t','w','e','e','n',' ','m','o','u','s','e',' ','c','l','i','c','k','s','\n',
' ',' ',' ',' ',' ',' ',' ',' ','w','i','t','h','i','n',' ','d','o','u','b','l','e',' ','a','n','d',' ','t','r','i','p','l','e',' ','c','l','i','c','k',' ','a','c','t','i','o','n','s','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','*','s','c','r','o','l','l','B','a','r','P','l','a','c','e','m','e','n','t',':',' ','B','O','T','T','O','M','_','L','E','F','T',' ','-','-',' ','H','o','w',' ','s','c','r','o','l','l','\n',
' ',' ',' ',' ',' ',' ',' ',' ','b','a','r','s',' ','a','r','e',' ','p','l','a','c','e','d',' ','i','n',' ','N','E','d','i','t',' ','w','i','n','d','o','w','s',',',' ','a','s',' ','w','e','l','l',' ','a','s','\n',
' ',' ',' ',' ',' ',' ',' ',' ','v','a','r','i','o','u','s',' ','l','i','s','t','s',' ','a','n','d',' ','t','e','x','t',' ','f','i','e','l','d','s',' ','i','n',' ','t','h','e',' ','p','r','o','g','r','a','m','.','\n',
' ',' ',' ',' ',' ',' ',' ',' ','O','t','h','e','r',' ','c','h','o','i','c','e','s',' ','a','r','e',':',' ','B','O','T','T','O','M','_','R','I','G','H','T',',',' ','T','O','P','_','L','E','F','T',',',' ','o','r','\n',
' ',' ',' ',' ',' ',' ',' ',' ','T','O','P','_','R','I','G','H','T','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','*','t','e','x','t','.','a','u','t','o','W','r','a','p','P','a','s','t','e','d','T','e','x','t',':',' ','F','a','l','s','e',' ','-','-',' ','W','h','e','n',' ','A','u','t','o','-','\n',
' ',' ',' ',' ',' ',' ',' ',' ','N','e','w','l','i','n','e',' ','W','r','a','p',' ','i','s',' ','t','u','r','n','e','d',' ','o','n',',',' ','a','p','p','l','y',' ','a','u','t','o','m','a','t','i','c','\n',
'	','w','r','a','p','p','i','n','g',' ','(','w','h','i','c','h',' ','n','o','r','m','a','l','l','y',' ','o','n','l','y',' ','a','p','p','l','i','e','s',' ','t','o',' ','t','y','p','e','d','\n',
'	','t','e','x','t',')',' ','t','o',' ','p','a','s','t','e','d',' ','t','e','x','t',' ','a','s',' ','w','e','l','l','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','*','t','e','x','t','.','h','e','a','v','y','C','u','r','s','o','r',':',' ','F','a','l','s','e',' ','-','-',' ','F','o','r',' ','m','o','n','i','t','o','r','s',' ','w','i','t','h','\n',
' ',' ',' ',' ',' ',' ',' ',' ','p','o','o','r',' ','r','e','s','o','l','u','t','i','o','n',' ','o','r',' ','u','s','e','r','s',' ','w','h','o',' ','h','a','v','e',' ','d','i','f','f','i','c','u','l','t','y','\n',
' ',' ',' ',' ',' ',' ',' ',' ','s','e','e','i','n','g',' ','t','h','e',' ','c','u','r','s','o','r',',',' ','m','a','k','e','s',' ','t','h','e',' ','c','u','r','s','o','r',' ','i','n',' ','t','h','e',' ','t','e','x','t','\n',
' ',' ',' ',' ',' ',' ',' ',' ','e','d','i','t','i','n','g',' ','a','r','e','a',' ','o','f',' ','t','h','e',' ','w','i','n','d','o','w',' ','h','e','a','v','i','e','r',' ','a','n','d',' ','d','a','r','k','e','r','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','*','t','e','x','t','.','f','o','r','e','g','r','o','u','n','d',':',' ','b','l','a','c','k',' ','-','-',' ','F','o','r','e','g','r','o','u','n','d',' ','c','o','l','o','r',' ','o','f','\n',
' ',' ',' ',' ',' ',' ',' ',' ','t','h','e',' ','t','e','x','t',' ','e','d','i','t','i','n','g',' ','a','r','e','a',' ','o','f',' ','t','h','e',' ','N','E','d','i','t',' ','w','i','n','d','o','w','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','*','t','e','x','t','.','b','a','c','k','g','r','o','u','n','d',':',' ','w','h','i','t','e',' ','-','-',' ','B','a','c','k','g','r','o','u','n','d',' ','c','o','l','o','r',' ','o','f','\n',
' ',' ',' ',' ',' ',' ',' ',' ','t','h','e',' ','t','e','x','t',' ','e','d','i','t','i','n','g',' ','a','r','e','a',' ','o','f',' ','t','h','e',' ','N','E','d','i','t',' ','w','i','n','d','o','w','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','*','t','e','x','t','.','s','e','l','e','c','t','F','o','r','e','g','r','o','u','n','d',':',' ','b','l','a','c','k',' ','-','-',' ','F','o','r','e','g','r','o','u','n','d','\n',
' ',' ',' ',' ','	','(','t','e','x','t',')',' ','c','o','l','o','r',' ','f','o','r',' ','s','e','l','e','c','t','i','o','n','s',' ','i','n',' ','t','h','e',' ','t','e','x','t',' ','e','d','i','t','i','n','g','\n',
' ',' ',' ',' ','	','a','r','e','a',' ','o','f',' ','t','h','e',' ','N','E','d','i','t',' ','w','i','n','d','o','w','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','*','t','e','x','t','.','s','e','l','e','c','t','B','a','c','k','g','r','o','u','n','d',':',' ','g','r','a','y','8','0',' ','-','-',' ','C','o','l','o','r',' ','f','o','r','\n',
' ',' ',' ',' ','	','s','e','l','e','c','t','i','o','n','s',' ','i','n',' ','t','h','e',' ','t','e','x','t',' ','e','d','i','t','i','n','g',' ','a','r','e','a',' ','o','f',' ','t','h','e',' ','N','E','d','i','t','\n',
' ',' ',' ',' ','	','w','i','n','d','o','w','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','*','t','e','x','t','.','h','i','g','h','l','i','g','h','t','F','o','r','e','g','r','o','u','n','d',':',' ','w','h','i','t','e',' ','-','-',' ','F','o','r','e','g','r','o','u','n','d','\n',
' ',' ',' ',' ','	','(','t','e','x','t',')',' ','c','o','l','o','r',' ','f','o','r',' ','h','i','g','h','l','i','g','h','t','s',' ','(','p','a','r','e','n','t','h','e','s','i','s','\n',
' ',' ',' ',' ','	','f','l','a','s','h','i','n','g',')',' ','i','n',' ','t','h','e',' ','t','e','x','t',' ','e','d','i','t','i','n','g',' ','a','r','e','a',' ','o','f',' ','t','h','e',' ','N','E','d','i','t','\n',
' ',' ',' ',' ','	','w','i','n','d','o','w','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','*','t','e','x','t','.','h','i','g','h','l','i','g','h','t','B','a','c','k','g','r','o','u','n','d',':',' ','r','e','d',' ','-','-',' ','C','o','l','o','r',' ','f','o','r','\n',
' ',' ',' ',' ','	','h','i','g','h','l','i','g','h','t','s',' ','(','p','a','r','e','n','t','h','e','s','i','s',' ','f','l','a','s','h','i','n','g',')',' ','i','n',' ','t','h','e',' ','t','e','x','t','\n',
' ',' ',' ',' ','	','e','d','i','t','i','n','g',' ','a','r','e','a',' ','o','f',' ','t','h','e',' ','N','E','d','i','t',' ','w','i','n','d','o','w','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','*','t','e','x','t','.','c','u','r','s','o','r','F','o','r','e','g','r','o','u','n','d',':',' ','b','l','a','c','k',' ','-','-',' ','C','o','l','o','r',' ','f','o','r','\n',
' ',' ',' ',' ','	','t','e','x','t',' ','c','u','r','s','o','r',' ','i','n',' ','t','h','e',' ','t','e','x','t',' ','e','d','i','t','i','n','g',' ','a','r','e','a',' ','o','f',' ','t','h','e','\n',
' ',' ',' ',' ','	','N','E','d','i','t',' ','w','i','n','d','o','w','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','*','t','e','x','t','.','b','l','i','n','k','R','a','t','e',':',' ','6','0','0',' ','-','-',' ','B','l','i','n','k',' ','r','a','t','e',' ','o','f',' ','t','h','e',' ','t','e','x','t','\n',
' ',' ',' ',' ',' ',' ',' ',' ','i','n','s','e','r','t','i','o','n',' ','c','u','r','s','o','r',' ','i','n',' ','m','i','l','l','i','s','e','c','o','n','d','s','.',' ',' ','S','e','t',' ','t','o',' ','z','e','r','o','\n',
' ',' ',' ',' ',' ',' ',' ',' ','t','o',' ','s','t','o','p',' ','b','l','i','n','k','i','n','g','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','*','t','e','x','t','.','T','r','a','n','s','l','a','t','i','o','n','s',':',' ','-','-',' ','M','o','d','i','f','i','e','s',' ','k','e','y',' ','b','i','n','d','i','n','g','s','\n',
' ',' ',' ',' ',' ',' ',' ',' ','(','s','e','e',' ','b','e','l','o','w',')','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','*','f','o','r','e','g','r','o','u','n','d',':',' ','b','l','a','c','k',' ','-','-',' ','D','e','f','a','u','l','t',' ','f','o','r','e','g','r','o','u','n','d',' ','c','o','l','o','r','\n',
' ',' ',' ',' ',' ',' ',' ',' ','f','o','r',' ','m','e','n','u','s',',',' ','d','i','a','l','o','g','s',',',' ','s','c','r','o','l','l',' ','b','a','r','s',',',' ','e','t','c','.','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','*','b','a','c','k','g','r','o','u','n','d',':',' ','g','r','a','y','7','0',' ','-','-',' ','D','e','f','a','u','l','t',' ','b','a','c','k','g','r','o','u','n','d',' ','c','o','l','o','r','\n',
' ',' ',' ',' ',' ',' ',' ',' ','f','o','r',' ','m','e','n','u','s',',',' ','d','i','a','l','o','g','s',',',' ','s','c','r','o','l','l',' ','b','a','r','s',',',' ','e','t','c','.','.','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','*','f','o','n','t','L','i','s','t',':',' ','h','e','l','v','e','t','i','c','a','-','b','o','l','d','-','1','4',' ','-','-',' ','D','e','f','a','u','l','t',' ','f','o','n','t','\n',
' ',' ',' ',' ',' ',' ',' ',' ','f','o','r',' ','m','e','n','u','s',',',' ','d','i','a','l','o','g','s',',',' ','s','c','r','o','l','l',' ','b','a','r','s',',',' ','e','t','c','.','.','\n',
'\n',
' ',' ',' ',' ','n','c','.','a','u','t','o','S','t','a','r','t',':',' ','F','a','l','s','e',' ','-','-',' ','W','h','e','t','h','e','r',' ','t','h','e',' ','n','c',' ','p','r','o','g','r','a','m',' ','s','h','o','u','l','d','\n',
' ',' ',' ',' ',' ',' ',' ',' ','a','u','t','o','m','a','t','i','c','a','l','l','y',' ','s','t','a','r','t',' ','a','n',' ','N','E','d','i','t',' ','s','e','r','v','e','r',' ','(','w','i','t','h','o','u','t','\n',
' ',' ',' ',' ',' ',' ',' ',' ','p','r','o','m','p','t','i','n','g',' ','t','h','e',' ','u','s','e','r',')',' ','i','f',' ','a','n',' ','a','p','p','r','o','p','r','i','a','t','e',' ','s','e','r','v','e','r',' ','i','s','\n',
' ',' ',' ',' ',' ',' ',' ',' ','n','o','t',' ','f','o','u','n','d','.','\n',
'\n',
' ',' ',' ',' ','n','c','.','s','e','r','v','e','r','C','o','m','m','a','n','d',':',' ','n','e','d','i','t',' ','-','s','e','r','v','e','r',' ','-','-',' ','C','o','m','m','a','n','d',' ','u','s','e','d',' ','b','y','\n',
' ',' ',' ',' ',' ',' ',' ',' ','t','h','e',' ','n','c',' ','p','r','o','g','r','a','m',' ','t','o',' ','s','t','a','r','t',' ','a','n',' ','N','E','d','i','t',' ','s','e','r','v','e','r','.','\n',
'\n',
'S','e','l','e','c','t','e','d',' ','w','i','d','g','e','t',' ','n','a','m','e','s',' ','(','t','o',' ','w','h','i','c','h',' ','y','o','u',' ','m','a','y',' ','a','p','p','e','n','d',' ','.','b','a','c','k','g','r','o','u','n','d',' ','.','f','o','r','e','g','r','o','u','n','d',',',' ',
'.','f','o','n','t','L','i','s','t',',',' ','e','t','c','.',',',' ','t','o',' ','c','h','a','n','g','e',' ','c','o','l','o','r','s',',',' ','f','o','n','t','s',' ','a','n','d',' ','o','t','h','e','r',' ','c','h','a','r','a','c','t','e','r','i','s','t','i','c','s',')',':','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','*','s','t','a','t','s','L','i','n','e',' ','-','-',' ','S','t','a','t','i','s','t','i','c','s',' ','l','i','n','e','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','*','m','e','n','u','B','a','r',' ','-','-',' ','T','o','p','-','o','f','-','w','i','n','d','o','w',' ','m','e','n','u','-','b','a','r','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','*','t','e','x','t','H','o','r','S','c','r','o','l','l','B','a','r',' ','-','-',' ','H','o','r','i','z','o','n','t','a','l',' ','s','c','r','o','l','l',' ','b','a','r','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','*','t','e','x','t','V','e','r','t','S','c','r','o','l','l','B','a','r',' ','-','-',' ','V','e','r','t','i','c','a','l',' ','s','c','r','o','l','l',' ','b','a','r','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','*','h','e','l','p','T','e','x','t',' ','-','-',' ','H','e','l','p',' ','w','i','n','d','o','w',' ','t','e','x','t','\0'};
	
static char AuxString21[] = {'T','h','e','r','e',' ','a','r','e',' ','s','e','v','e','r','a','l',' ','w','a','y','s',' ','t','o',' ','c','h','a','n','g','e',' ','k','e','y',' ','b','i','n','d','i','n','g','s',' ','i','n',' ','N','E','d','i','t','.',' ',' ','T','h','e',' ','e','a','s','i','e','s','t',' ',
'w','a','y',' ','t','o',' ','a','d','d',' ','a',' ','n','e','w',' ','k','e','y',' ','b','i','n','d','i','n','g',' ','i','n',' ','N','E','d','i','t',' ','i','s',' ','t','o',' ','d','e','f','i','n','e',' ','a',' ','m','a','c','r','o',' ','i','n',' ','P','r','e','f','e','r','e','n','c','e','s',' ','-','>',' ',
'D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s',' ','-','>',' ','C','u','s','t','o','m','i','z','e',' ','M','e','n','u','s',' ','-','>',' ','M','a','c','r','o',' ','M','e','n','u','.',' ',' ',
'H','o','w','e','v','e','r',',',' ','i','f',' ','y','o','u',' ','w','a','n','t',' ','t','o',' ','c','h','a','n','g','e',' ','e','x','i','s','t','i','n','g',' ','b','i','n','d','i','n','g','s',' ','o','r',' ','a','d','d',' ','a',' ','s','i','g','n','i','f','i','c','a','n','t',' ',
'n','u','m','b','e','r',' ','o','f',' ','n','e','w',' ','k','e','y',' ','b','i','n','d','i','n','g','s',' ','y','o','u',' ','w','i','l','l',' ','n','e','e','d',' ','t','o',' ','d','o',' ','s','o',' ','v','i','a',' ','X',' ','r','e','s','o','u','r','c','e','s','.','\n',
'\n',
'B','e','f','o','r','e',' ','r','e','a','d','i','n','g',' ','t','h','i','s',' ','s','e','c','t','i','o','n',',',' ',
'y','o','u',' ','m','u','s','t',' ','u','n','d','e','r','s','t','a','n','d',' ','h','o','w',' ','t','o',' ','s','e','t',' ','X',' ','r','e','s','o','u','r','c','e','s',' ','(','s','e','e',' ','t','h','e',' ','h','e','l','p',' ','s','e','c','t','i','o','n',' ','\"','X',' ',
'R','e','s','o','u','r','c','e','s','\"',')','.',' ',' ','S','i','n','c','e',' ','s','e','t','t','i','n','g',' ','X',' ','r','e','s','o','u','r','c','e','s',' ','i','s',' ','t','r','i','c','k','y',',',' ','i','t',' ','i','s',' ','a','l','s','o',' ','h','e','l','p','f','u','l',' ',
'w','h','e','n',' ','w','o','r','k','i','n','g',' ','o','n',' ','k','e','y','-','b','i','n','d','i','n','g',',',' ','t','o',' ','s','e','t',' ','s','o','m','e',' ','e','a','s','i','e','r','-','t','o','-','v','e','r','i','f','y',' ','r','e','s','o','u','r','c','e',' ','a','t',' ','t','h','e',' ',
's','a','m','e',' ','t','i','m','e',',',' ',
'a','s',' ','a',' ','s','i','m','p','l','e',' ','c','h','e','c','k',' ','t','h','a','t',' ','t','h','e',' ','N','E','d','i','t',' ','p','r','o','g','r','a','m',' ','i','s',' ','a','c','t','u','a','l','l','y',' ','s','e','e','i','n','g',' ','y','o','u','r',' ','c','h','a','n','g','e','s','.',' ',' ',
'T','h','e',' ','a','p','p','r','e','s',' ','p','r','o','g','r','a','m',' ','i','s',' ','a','l','s','o',' ','v','e','r','y',' ','h','e','l','p','f','u','l',' ','i','n',' ','c','h','e','c','k','i','n','g',' ','t','h','a','t',' ','t','h','e',' ','r','e','s','o','u','r','c','e',' ',
's','e','t','t','i','n','g','s',' ','t','h','a','t',' ','y','o','u',' ','m','a','k','e',',',' ','a','c','t','u','a','l','l','y',' ','r','e','a','c','h',' ','t','h','e',' ','p','r','o','g','r','a','m',' ','f','o','r',' ','w','h','i','c','h',' ','t','h','e','y',' ','a','r','e',' ',
'i','n','t','e','n','d','e','d',' ','i','n',' ','t','h','e',' ','c','o','r','r','e','c','t',' ','f','o','r','m','.','\n',
'\n',
'K','e','y',' ','B','i','n','d','i','n','g',' ','i','n',' ','G','e','n','e','r','a','l','\n',
'\n',
'K','e','y','b','o','a','r','d',' ','c','o','m','m','a','n','d','s',' ','a','r','e',' ','a','s','s','o','c','i','a','t','e','d',' ','w','i','t','h',' ','e','d','i','t','o','r',' ','a','c','t','i','o','n',' ','r','o','u','t','i','n','e','s',' ','t','h','r','o','u','g','h',' ',
't','w','o',' ','s','e','p','a','r','a','t','e',' ','m','e','c','h','a','n','i','s','m','s',' ','i','n',' ','N','E','d','i','t','.',' ',' ','C','o','m','m','a','n','d','s',' ','w','h','i','c','h',' ','a','p','p','e','a','r',' ','i','n',' ','p','u','l','l','-','d','o','w','n',' ',
'm','e','n','u','s',' ','h','a','v','e',' ','i','n','d','i','v','i','d','u','a','l',' ','r','e','s','o','u','r','c','e','s',' ','d','e','s','i','g','n','a','t','i','n','g',' ','a',' ','k','e','y','b','o','a','r','d',' ','e','q','u','i','v','a','l','e','n','t',' ','t','o',' ',
't','h','e',' ','m','e','n','u',' ','c','o','m','m','a','n','d',',',' ','c','a','l','l','e','d',' ','a','n',' ','a','c','c','e','l','e','r','a','t','o','r',' ','k','e','y','.',' ',' ','C','o','m','m','a','n','d','s',' ','w','h','i','c','h',' ','d','o',' ','n','o','t',' ','h','a','v','e',' ',
'a','n',' ','a','s','s','o','c','i','a','t','e','d',' ','m','e','n','u',' ','i','t','e','m',' ','a','r','e',' ','b','o','u','n','d',' ','t','o',' ','k','e','y','s',' ','v','i','a',' ','t','h','e',' ','X',' ','t','o','o','l','k','i','t',' ','t','r','a','n','s','l','a','t','i','o','n',' ',
'm','e','c','h','a','n','i','s','m','.',' ',' ','T','h','e',' ','m','e','t','h','o','d','s',' ','f','o','r',' ','c','h','a','n','g','i','n','g',' ','t','h','e','s','e',' ','t','w','o',' ','k','i','n','d','s',' ','o','f',' ','b','i','n','d','i','n','g','s',' ','a','r','e',' ',
'q','u','i','t','e',' ','d','i','f','f','e','r','e','n','t','.','\n',
'\n',
'K','e','y',' ','B','i','n','d','i','n','g',' ','V','i','a',' ','T','r','a','n','s','l','a','t','i','o','n','s','\n',
'\n',
'T','h','e',' ','m','o','s','t',' ','g','e','n','e','r','a','l',' ','w','a','y',' ','t','o',' ','b','i','n','d',' ','a','c','t','i','o','n','s',' ','t','o',' ','k','e','y','s',' ','i','n',' ','N','E','d','i','t',' ','i','s',' ','t','o',' ','u','s','e',' ','t','h','e',' ',
't','r','a','n','s','l','a','t','i','o','n',' ','t','a','b','l','e',' ','a','s','s','o','c','i','a','t','e','d',' ','w','i','t','h',' ','t','h','e',' ','t','e','x','t',' ','w','i','d','g','e','t','.',' ',' ','T','o',' ','a','d','d',' ','a',' ','b','i','n','d','i','n','g',' ','t','o',' ',
'A','l','t','+','Y',' ','t','o',' ','i','n','s','e','r','t',' ','t','h','e',' ','s','t','r','i','n','g',' ','\"','H','i','!','\"',',',' ','f','o','r',' ','e','x','a','m','p','l','e',',',' ','a','d','d',' ','l','i','n','e','s',' ','s','i','m','i','l','a','r',' ','t','o',' ','t','h','e',' ',
'f','o','l','l','o','w','i','n','g',' ','t','o',' ','y','o','u','r',' ','X',' ','r','e','s','o','u','r','c','e',' ','f','i','l','e',':','\n',
'\n',
' ',' ','N','E','d','i','t','*','t','e','x','t','.','T','r','a','n','s','l','a','t','i','o','n','s',':',' ','#','o','v','e','r','r','i','d','e',' ','\\','n','\\','\n',
' ',' ',' ',' ','A','l','t','<','K','e','y','>','y',':',' ','i','n','s','e','r','t','_','s','t','r','i','n','g','(','\"','H','i','!','\"',')',' ','\\','n','\n',
'\n',
'T','h','e',' ','H','e','l','p',' ','t','o','p','i','c',' ','\"','A','c','t','i','o','n',' ',
'R','o','u','t','i','n','e','s','\"',' ','l','i','s','t','s',' ','t','h','e',' ','a','c','t','i','o','n','s',' ','a','v','a','i','l','a','b','l','e',' ','t','o',' ','b','e',' ','b','o','u','n','d','.','\n',
'\n',
'T','r','a','n','s','l','a','t','i','o','n',' ','t','a','b','l','e','s',' ','m','a','p',' ','k','e','y',' ','a','n','d',' ','m','o','u','s','e',' ','p','r','e','s','s','e','s',',',' ',
'w','i','n','d','o','w',' ','o','p','e','r','a','t','i','o','n','s',',',' ','a','n','d',' ','o','t','h','e','r',' ','k','i','n','d','s',' ','o','f',' ','e','v','e','n','t','s',',',' ','t','o',' ','a','c','t','i','o','n','s','.',' ',' ',' ',
'T','h','e',' ','s','y','n','t','a','x',' ','f','o','r',' ','t','r','a','n','s','l','a','t','i','o','n',' ','t','a','b','l','e','s',' ','i','s',' ','s','i','m','p','l','i','f','i','e','d',' ','h','e','r','e',',',' ','a','n','d',' ','y','o','u','.',' ',' ',
'm','a','y',' ','n','e','e','d',' ','t','o',' ','r','e','f','e','r',' ','t','o',' ','a',' ','b','o','o','k',' ','o','n',' ','t','h','e',' ','X',' ','w','i','n','d','o','w',' ','s','y','s','t','e','m',' ','f','o','r',' ','m','o','r','e',' ','d','e','t','a','i','l','e','d',' ',
'i','n','f','o','r','m','a','t','i','o','n','.','\n',
'\n',
'N','o','t','e',' ','t','h','a','t',' ','a','c','c','e','l','e','r','a','t','o','r',' ','r','e','s','o','u','r','c','e','s',' ','(','d','i','s','c','u','s','s','e','d',' ','b','e','l','o','w',')',' ','o','v','e','r','r','i','d','e',' ',
't','r','a','n','s','l','a','t','i','o','n','s',',',' ','a','n','d',' ','t','h','a','t',' ','m','o','s','t',' ','C','t','r','l','+','l','e','t','t','e','r',' ','a','n','d',' ','A','l','t','+','l','e','t','t','e','r',' ','c','o','m','b','i','n','a','t','i','o','n','s',' ','a','r','e',' ',
'a','l','r','e','a','d','y',' ','b','o','u','n','d',' ','t','o',' ','a','n',' ','a','c','c','e','l','e','r','a','t','o','r',' ','k','e','y','.',' ',' ','T','o',' ','u','s','e',' ','o','n','e',' ','o','f',' ','t','h','e','s','e',' ','c','o','m','b','i','n','a','t','i','o','n','s',' ','f','r','o','m',' ',
'a',' ','t','r','a','n','s','l','a','t','i','o','n',' ','t','a','b','l','e',',',' ','t','h','e','r','e','f','o','r','e',',',' ','y','o','u',' ','m','u','s','t',' ','f','i','r','s','t',' ','u','n','-','b','i','n','d',' ','t','h','e',' ','o','r','i','g','i','n','a','l',' ','m','e','n','u',' ',
'a','c','c','e','l','e','r','a','t','o','r','.','\n',
'\n',
'A',' ','r','e','s','o','u','r','c','e',' ','f','o','r',' ','c','h','a','n','g','i','n','g',' ','a',' ','t','r','a','n','s','l','a','t','i','o','n',' ','t','a','b','l','e',' ',
'c','o','n','s','i','s','t','s',' ','o','f',' ','a',' ','k','e','y','w','o','r','d',';',' ','#','o','v','e','r','r','i','d','e',',',' ','#','a','u','g','m','e','n','t',',',' ','o','r',' ','#','r','e','p','l','a','c','e',';',' ',
'f','o','l','l','o','w','e','d',' ','b','y',' ','l','i','n','e','s',' ','(','s','e','p','a','r','a','t','e','d',' ','b','y',' ','n','e','w','l','i','n','e',' ','c','h','a','r','a','c','t','e','r','s',')',' ','p','a','i','r','i','n','g',' ','e','v','e','n','t','s',' ','w','i','t','h',' ',
'a','c','t','i','o','n','s','.',' ',' ','E','v','e','n','t','s',' ','b','e','g','i','n',' ','w','i','t','h',' ','m','o','d','i','f','i','e','r','s',',',' ','l','i','k','e',' ','C','t','r','l',',',' ','S','h','i','f','t',',',' ','o','r',' ','A','l','t',',',' ',
'f','o','l','l','o','w','e','d',' ','b','y',' ','t','h','e',' ','e','v','e','n','t',' ','t','y','p','e',' ','i','n',' ','<','>','.',' ',' ','B','t','n','D','o','w','n',',',' ','B','t','n','1','D','o','w','n',',',' ','B','t','n','2','D','o','w','n',',',' ','B','t','n','1','U','p',',',' ',
'K','e','y',',',' ','K','e','y','U','p',' ','a','r','e',' ','v','a','l','i','d',' ','e','v','e','n','t',' ','t','y','p','e','s','.',' ',' ','F','o','r',' ','k','e','y',' ','p','r','e','s','s','e','s',',',' ','t','h','e',' ',
'e','v','e','n','t',' ','t','y','p','e',' ','i','s',' ','f','o','l','l','o','w','e','d',' ','b','y',' ','t','h','e',' ','n','a','m','e',' ','o','f',' ','t','h','e',' ','k','e','y','.',' ',' ','Y','o','u',' ','c','a','n',' ','s','p','e','c','i','f','y',' ','a',' ',
'c','o','m','b','i','n','a','t','i','o','n',' ','o','f',' ','e','v','e','n','t','s',',',' ','s','u','c','h',' ','a','s',' ','a',' ','s','e','q','u','e','n','c','e',' ','o','f',' ','k','e','y',' ','p','r','e','s','s','e','s',',',' ','b','y',' ','s','e','p','a','r','a','t','i','n','g',' ',
't','h','e','m',' ','w','i','t','h',' ','c','o','m','m','a','s','.',' ',' ','T','h','e',' ','o','t','h','e','r',' ','h','a','l','f',' ','o','f',' ','t','h','e',' ','e','v','e','n','t','/','a','c','t','i','o','n',' ','p','a','i','r',' ','i','s',' ','a',' ','s','e','t',' ',
'o','f',' ','a','c','t','i','o','n','s','.',' ',' ','T','h','e','s','e',' ','a','r','e',' ','s','e','p','a','r','a','t','e','d',' ','f','r','o','m',' ','t','h','e',' ','e','v','e','n','t',' ','s','p','e','c','i','f','i','c','a','t','i','o','n',' ','b','y',' ','a',' ','c','o','l','o','n',' ',
'a','n','d',' ','f','r','o','m',' ','e','a','c','h',' ','o','t','h','e','r',' ','b','y',' ','s','p','a','c','e','s','.',' ',' ','A','c','t','i','o','n','s',' ',
'a','r','e',' ','n','a','m','e','s',' ','f','o','l','l','o','w','e','d',' ','b','y',' ','p','a','r','e','n','t','h','e','s','e','s',',',' ','o','p','t','i','o','n','a','l','l','y',' ',
'c','o','n','t','a','i','n','i','n','g',' ','o','n','e',' ','o','r',' ','m','o','r','e',' ','p','a','r','a','m','e','t','e','r','s',' ','s','e','p','a','r','a','t','e','d',' ','b','y',' ','c','o','m','a','s','.','\n',
'\n',
'C','h','a','n','g','i','n','g',' ','M','e','n','u',' ','A','c','c','e','l','e','r','a','t','o','r',' ','K','e','y','s','\n',
'\n',
'T','h','e',' ','m','e','n','u',' ','s','h','o','r','t','c','u','t',' ','k','e','y','s',' ','s','h','o','w','n',' ','a','t',' ','t','h','e',' ','r','i','g','h','t',' ','o','f',' ','N','E','d','i','t',' ','m','e','n','u',' ','i','t','e','m','s',' ','c','a','n',' ','a','l','s','o',' ',
'b','e',' ','c','h','a','n','g','e','d',' ','v','i','a',' ','X',' ','r','e','s','o','u','r','c','e','s','.',' ',' ','E','a','c','h',' ','m','e','n','u',' ','i','t','e','m',' ','h','a','s',' ','t','w','o',' ',
'r','e','s','o','u','r','c','e','s',' ','a','s','s','o','c','i','a','t','e','d',' ','w','i','t','h',' ','i','t',',',' ','a','c','c','e','l','e','r','a','t','o','r',',',' ','t','h','e',' ',
'e','v','e','n','t',' ','t','o',' ','t','r','i','g','g','e','r',' ','t','h','e',' ','m','e','n','u',' ','i','t','e','m',';',' ','a','n','d',' ','a','c','c','e','l','e','r','a','t','o','r','T','e','x','t',',',' ','t','h','e',' ','s','t','r','i','n','g',' ',
's','h','o','w','n',' ','i','n',' ','t','h','e',' ','m','e','n','u','.',' ',' ',
'T','h','e',' ','f','o','r','m',' ','o','f',' ','t','h','e',' ','a','c','c','e','l','e','r','a','t','o','r',' ','r','e','s','o','u','r','c','e',' ','i','s',' ','t','h','e',' ','s','a','m','e',' ','a','s',' ','e','v','e','n','t','s',' ','f','o','r',' ','t','r','a','n','s','l','a','t','i','o','n',' ',
't','a','b','l','e',' ','e','n','t','r','i','e','s',' ','d','i','s','c','u','s','s','e','d',' ','a','b','o','v','e',',',' ','t','h','o','u','g','h',' ','m','u','l','t','i','p','l','e',' ','k','e','y','s',' ','a','n','d',' ','o','t','h','e','r',' ','s','u','b','t','l','e','t','i','e','s',' ',
'a','r','e',' ','n','o','t',' ','a','l','l','o','w','e','d','.',' ',' ',
'T','h','e',' ','r','e','s','o','u','r','c','e',' ','n','a','m','e',' ','f','o','r',' ','a',' ','m','e','n','u',' ','i','s',' ','t','h','e',' ','t','i','t','l','e',' ','i','n',' ','l','o','w','e','r',' ','c','a','s','e',',',' ','f','o','l','l','o','w','e','d',' ','b','y',' ',
'\"','M','e','n','u','\"',',',' ','t','h','e',' ','r','e','s','o','u','r','c','e',' ','n','a','m','e',' ','o','f',' ','m','e','n','u',' ','i','t','e','m',' ','i','s',' ','t','h','e',' ','n','a','m','e',' ','i','n',' ','l','o','w','e','r',' ','c','a','s','e',',',' ','r','u','n',' ',
't','o','g','e','t','h','e','r',',',' ','w','i','t','h',' ','w','o','r','d','s',' ','s','e','p','a','r','a','t','e','d',' ','b','y',' ','c','a','p','s',',',' ','a','n','d',' ','a','l','l',' ','p','u','n','c','t','u','a','t','i','o','n',' ','r','e','m','o','v','e','d','.',' ',' ',
'F','o','r',' ','e','x','a','m','p','l','e',',',' ','t','o',' ','c','h','a','n','g','e',' ','C','u','t',' ','t','o',' ','C','t','r','l','+','X',',',' ',
'y','o','u',' ','w','o','u','l','d',' ','a','d','d',' ','t','h','e',' ','f','o','l','l','o','w','i','n','g',' ','t','o',' ','y','o','u','r',' ','.','X','d','e','f','a','u','l','t','s',' ','f','i','l','e',':','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','*','e','d','i','t','M','e','n','u','.','c','u','t','.','a','c','c','e','l','e','r','a','t','o','r',':',' ','C','t','r','l','<','K','e','y','>','x','\n',
' ',' ',' ',' ','n','e','d','i','t','*','e','d','i','t','M','e','n','u','.','c','u','t','.','a','c','c','e','l','e','r','a','t','o','r','T','e','x','t',':',' ','C','t','r','l','+','X','\n',
'\n',
'A','c','c','e','l','e','r','a','t','o','r',' ','k','e','y','s',' ','w','i','t','h',' ','o','p','t','i','o','n','a','l',' ','s','h','i','f','t',' ','k','e','y',' ','m','o','d','i','f','i','e','r','s',',',' ','l','i','k','e',' ','F','i','n','d','.','.','.',',',' ','h','a','v','e',' ','a','n',' ',
'a','d','d','i','t','i','o','n','a','l',' ','a','c','c','e','l','e','r','a','t','o','r',' ','r','e','s','o','u','r','c','e',' ','w','i','t','h',' ','S','h','i','f','t',' ','a','p','p','e','n','d','e','d',' ','t','o',' ','t','h','e',' ','n','a','m','e','.',' ',' ','F','o','r',' ',
'e','x','a','m','p','l','e',':','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','*','s','e','a','r','c','h','M','e','n','u','.','f','i','n','d','.','a','c','c','e','l','e','r','a','t','o','r','T','e','x','t',':',' ','[','S','h','i','f','t',']','A','l','t','+','F','\n',
' ',' ',' ',' ','n','e','d','i','t','*','s','e','a','r','c','h','M','e','n','u','.','f','i','n','d','.','a','c','c','e','l','e','r','a','t','o','r',':',' ','A','l','t','<','K','e','y','>','f','\n',
' ',' ',' ',' ','n','e','d','i','t','*','s','e','a','r','c','h','M','e','n','u','.','f','i','n','d','S','h','i','f','t','.','a','c','c','e','l','e','r','a','t','o','r',':',' ','S','h','i','f','t',' ','A','l','t','<','K','e','y','>','f','\0'};

static char AuxString22[] = {'L','e','a','r','n','/','R','e','p','l','a','y','\n',
'\n',
'S','e','l','e','c','t','i','n','g',' ','L','e','a','r','n',' ','K','e','y','s','t','r','o','k','e','s',' ','f','r','o','m',' ','t','h','e',' ','M','a','c','r','o',' ','m','e','n','u',' ','p','u','t','s',' ','N','E','d','i','t',' ','i','n',' ','l','e','a','r','n',' ','m','o','d','e','.',' ',' ',
'I','n',' ','l','e','a','r','n',' ','m','o','d','e',',',' ','k','e','y','s','t','r','o','k','e','s',' ','a','n','d',' ','m','e','n','u',' ','c','o','m','m','a','n','d','s',' ','a','r','e',' ','r','e','c','o','r','d','e','d',',',' ','t','o',' ','b','e',' ','p','l','a','y','e','d',' ',
'b','a','c','k',' ','l','a','t','e','r',',',' ','u','s','i','n','g',' ','t','h','e',' ','R','e','p','l','a','y',' ','K','e','y','s','t','r','o','k','e','s',' ','c','o','m','m','a','n','d',',',' ','o','r',' ','p','a','s','t','e','d',' ','i','n','t','o',' ','a',' ',
'm','a','c','r','o',' ','i','n',' ','t','h','e',' ','M','a','c','r','o',' ','C','o','m','m','a','n','d','s',' ','d','i','a','l','o','g',' ','o','f',' ','t','h','e',' ','D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s',' ','m','e','n','u',' ','i','n',' ',
'P','r','e','f','e','r','e','n','c','e','s','.','\n',
'\n',
'N','o','t','e',' ','t','h','a','t',' ','o','n','l','y',' ','k','e','y','b','o','a','r','d',' ','a','n','d',' ','m','e','n','u',' ','c','o','m','m','a','n','d','s',' ','a','r','e',' ','r','e','c','o','r','d','e','d',',',' ','n','o','t',' ','m','o','u','s','e',' ','c','l','i','c','k','s',' ',
'o','r',' ','m','o','u','s','e',' ','m','o','v','e','m','e','n','t','s',' ','s','i','n','c','e',' ','t','h','e','s','e',' ','h','a','v','e',' ','n','o',' ','a','b','s','o','l','u','t','e',' ','p','o','i','n','t',' ','o','f',' ','r','e','f','e','r','e','n','c','e',',',' ','s','u','c','h',' ',
'a','s',' ','c','u','r','s','o','r',' ','o','r',' ','s','e','l','e','c','t','i','o','n',' ','p','o','s','i','t','i','o','n','.',' ',' ','W','h','e','n',' ','y','o','u',' ','d','o',' ','a',' ','m','o','u','s','e','-','b','a','s','e','d',' ','o','p','e','r','a','t','i','o','n',' ','i','n',' ',
'l','e','a','r','n',' ','m','o','d','e',',',' ','N','E','d','i','t',' ','w','i','l','l',' ','b','e','e','p',' ','(','r','e','p','e','a','t','e','d','l','y',')',' ','t','o',' ','r','e','m','i','n','d',' ','y','o','u',' ','t','h','a','t',' ','t','h','e',' ','o','p','e','r','a','t','i','o','n',' ',
'w','a','s',' ','n','o','t',' ','r','e','c','o','r','d','e','d','.','\n',
'\n',
'L','e','a','r','n',' ','m','o','d','e',' ','i','s',' ','a','l','s','o',' ','t','h','e',' ','q','u','i','c','k','e','s','t',' ','a','n','d',' ','e','a','s','i','e','s','t',' ','m','e','t','h','o','d',' ','f','o','r',' ','w','r','i','t','i','n','g',' ','m','a','c','r','o','s','.',' ',' ','T','h','e',' ',
'd','i','a','l','o','g',' ','f','o','r',' ','c','r','e','a','t','i','n','g',' ','m','a','c','r','o',' ','c','o','m','m','a','n','d','s',' ','c','o','n','t','a','i','n','s',' ','a',' ','b','u','t','t','o','n',' ','l','a','b','e','l','e','d',' ','\"','P','a','s','t','e',' ','L','e','a','r','n',' ','/',' ',
'R','e','p','l','a','y',' ','M','a','c','r','o','\"',',',' ','w','h','i','c','h',' ','w','i','l','l',' ','d','e','p','o','s','i','t',' ','t','h','e',' ','l','a','s','t',' ','s','e','q','u','e','n','c','e',' ','l','e','a','r','n','e','d',' ','i','n','t','o',' ','t','h','e',' ','b','o','d','y',' ',
'o','f',' ','t','h','e',' ','m','a','c','r','o','.','\n',
'\n',
'R','e','p','e','a','t','i','n','g',' ','A','c','t','i','o','n','s',' ','a','n','d',' ','L','e','a','r','n','/','R','e','p','l','a','y',' ','S','e','q','u','e','n','c','e','s','\n',
'\n',
'Y','o','u',' ','c','a','n',' ','r','e','p','e','a','t',' ','t','h','e',' ','l','a','s','t',' ','(','k','e','y','b','o','a','r','d','-','b','a','s','e','d',')',' ','c','o','m','m','a','n','d',',',' ','o','r',' ','l','e','a','r','n','/','r','e','p','l','a','y',' ','s','e','q','u','e','n','c','e',' ',
'w','i','t','h',' ','t','h','e',' ','R','e','p','e','a','t','.','.','.',' ','c','o','m','m','a','n','d',' ','i','n',' ','t','h','e',' ','M','a','c','r','o',' ','m','e','n','u','.',' ',' ','T','o',' ','r','e','p','e','a','t',' ','a','n',' ','a','c','t','i','o','n',',',' ','f','i','r','s','t',' ',
'd','o',' ','t','h','e',' ','a','c','t','i','o','n',' ','(','i','.','e','.',' ','i','n','s','e','r','t',' ','a',' ','c','h','a','r','a','c','t','e','r',',',' ','d','o',' ','a',' ',
's','e','a','r','c','h',',',' ','m','o','v','e',' ','t','h','e',' ','c','u','r','s','o','r',')',',',' ','t','h','e','n',' ','s','e','l','e','c','t',' ','R','e','p','e','a','t','.','.','.',',',' ',
'd','e','c','i','d','e',' ','h','o','w',' ','o','r',' ','h','o','w',' ','m','a','n','y',' ','t','i','m','e','s',' ','y','o','u',' ','w','a','n','t',' ','i','t',' ','r','e','p','e','a','t','e','d',',',' ','a','n','d',' ','c','l','i','c','k',' ','O','K','.',' ',' ','F','o','r',' ',
'e','x','a','m','p','l','e',',',' ','t','o',' ','m','o','v','e',' ','d','o','w','n',' ','3','0',' ','l','i','n','e','s',' ','t','h','r','o','u','g','h',' ','a',' ','f','i','l','e',',',' ','y','o','u',' ','c','o','u','l','d',' ','t','y','p','e',':',' ','<','D','o','w','n',' ','A','r','r','o','w','>',' ',
'C','t','r','l','+',',',' ','2','9',' ','<','R','e','t','u','r','n','>','.',' ',' ','T','o',' ','r','e','p','e','a','t',' ','a',' ',
'l','e','a','r','n','/','r','e','p','l','a','y',' ','s','e','q','u','e','n','c','e',',',' ','f','i','r','s','t',' ','l','e','a','r','n',' ','i','t',',',' ','t','h','e','n',' ','s','e','l','e','c','t',' ','R','e','p','e','a','t','.','.','.',',',' ','c','l','i','c','k',' ','o','n',' ',
'L','e','a','r','n','/','R','e','p','l','a','y',' ','a','n','d',' ','h','o','w',' ','y','o','u',' ','w','a','n','t',' ','i','t',' ','r','e','p','e','a','t','e','d',',',' ','t','h','e','n',' ','c','l','i','c','k',' ','O','K','.','\n',
'\n',
'I','f',' ','t','h','e',' ','c','o','m','m','a','n','d','s',' ',
'y','o','u',' ','a','r','e',' ','r','e','p','e','a','t','i','n','g',' ','a','d','v','a','n','c','e',' ','t','h','e',' ','c','u','r','s','o','r',' ','t','h','r','o','u','g','h',' ','t','h','e',' ','f','i','l','e',',',' ','y','o','u',' ','c','a','n',' ','a','l','s','o',' ','r','e','p','e','a','t',' ',
't','h','e','m',' ','w','i','t','h','i','n',' ','a',' ','r','a','n','g','e',' ','o','f',' ','c','h','a','r','a','c','t','e','r','s',',',' ','o','r',' ',
'f','r','o','m',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','c','u','r','s','o','r',' ','p','o','s','i','t','i','o','n',' ','t','o',' ','t','h','e',' ','e','n','d',' ','o','f',' ','t','h','e',' ','f','i','l','e','.',' ',' ','T','o',' ','i','t','e','r','a','t','e',' ','o','v','e','r',' ',
'a',' ','r','a','n','g','e',' ','o','f',' ','c','h','a','r','a','c','t','e','r','s',',',' ','u','s','e',' ','t','h','e',' ','p','r','i','m','a','r','y',' ',
's','e','l','e','c','t','i','o','n',' ','(','d','r','a','g',' ','t','h','e',' ','l','e','f','t',' ','m','o','u','s','e',' ','b','u','t','t','o','n',' ','o','v','e','r',' ','t','h','e',' ','t','e','x','t',')',' ','t','o',' ','m','a','r','k',' ','t','h','e',' ','r','a','n','g','e',' ',
'y','o','u',' ','w','a','n','t',' ','t','o',' ','o','p','e','r','a','t','e',' ','o','n',',',' ',
'a','n','d',' ','s','e','l','e','c','t',' ','\"','I','n',' ','S','e','l','e','c','t','i','o','n','\"',' ','i','n',' ','t','h','e',' ','R','e','p','e','a','t',' ','d','i','a','l','o','g','.','\n',
'\n',
'W','h','e','n',' ','u','s','i','n','g',' ','I','n',' ','\"','S','e','l','e','c','t','i','o','n','\"',' ','o','r',' ','\"','T','o',' ','E','n','d','\"',' ','w','i','t','h',' ','a',' ','l','e','a','r','n','e','d',' ','s','e','q','u','e','n','c','e',',',' ','t','r','y',' ',
't','o',' ','d','o',' ','c','u','r','s','o','r',' ','m','o','v','e','m','e','n','t',' ','a','s',' ','t','h','e',' ','l','a','s','t',' ','s','t','e','p',' ','i','n',' ','t','h','e',' ','s','e','q','u','e','n','c','e',',',' ','s','i','n','c','e',' ','t','e','s','t','i','n','g',' ','o','f',' ',
't','h','e',' ','c','u','r','s','o','r',' ','p','o','s','i','t','i','o','n',' ','i','s',' ','o','n','l','y',' ','d','o','n','e',' ','a','t',' ','t','h','e',' ','e','n','d',' ','o','f',' ','t','h','e',' ','s','e','q','u','e','n','c','e',' ','e','x','e','c','u','t','i','o','n','.',' ',' ',
'I','f',' ','y','o','u',' ','d','o',' ','c','u','r','s','o','r',' ','m','o','v','e','m','e','n','t',' ','f','i','r','s','t',',',' ','f','o','r',' ','e','x','a','m','p','l','e',' ','s','e','a','r','c','h','i','n','g',' ','f','o','r',' ','a',' ','p','a','r','t','i','c','u','l','a','r',' ',
'w','o','r','d',' ','t','h','e','n',' ','d','o','i','n','g',' ','a',' ','m','o','d','i','f','i','c','a','t','i','o','n',',',' ','t','h','e',' ','p','o','s','i','t','i','o','n',' ','o','f',' ','t','h','e',' ','c','u','r','s','o','r',' ','w','o','n',''','t',' ','b','e',' ',
'c','h','e','c','k','e','d',' ','u','n','t','i','l',' ','t','h','e',' ','s','e','q','u','e','n','c','e',' ','h','a','s',' ','p','o','t','e','n','t','i','a','l','l','y',' ','g','o','n','e',' ','f','a','r',' ','b','e','y','o','n','d',' ','t','h','e',' ','e','n','d',' ','o','f',' ',
'y','o','u','r',' ','d','e','s','i','r','e','d',' ','r','a','n','g','e','.','\n',
'\n',
'I','t',''','s',' ','e','a','s','y',' ','f','o','r',' ','a',' ','r','e','p','e','a','t','e','d',' ','c','o','m','m','a','n','d',' ','t','o',' ','g','e','t',' ','o','u','t',' ','o','f',' ','h','a','n','d',',',' ','a','n','d',' ','y','o','u',' ','c','a','n',' ','e','a','s','i','l','y',' ',
'g','e','n','e','r','a','t','e',' ','a','n',' ','i','n','f','i','n','i','t','e',' ','l','o','o','p',' ','b','y',' ','u','s','i','n','g',' ','r','a','n','g','e',' ','i','t','e','r','a','t','i','o','n',' ','o','n',' ','a',' ','c','o','m','m','a','n','d',' ','w','h','i','c','h',' ',
'd','o','e','s','n',''','t',' ','p','r','o','g','r','e','s','s','.',' ',' ','T','o',' ','c','a','n','c','e','l',' ','a',' ','r','e','p','e','a','t','i','n','g',' ','c','o','m','m','a','n','d',' ','i','n',' ','p','r','o','g','r','e','s','s',',',' ','t','y','p','e',' ','C','t','r','l','+','.',' ',
'(','p','e','r','i','o','d',')',',',' ','o','r',' ','s','e','l','e','c','t',' ','C','a','n','c','e','l',' ','M','a','c','r','o',' ','f','r','o','m',' ','t','h','e',' ','M','a','c','r','o',' ','m','e','n','u','.','\0'};

static char AuxString23[] = {'M','a','c','r','o','s',' ','c','a','n',' ','b','e',' ','c','a','l','l','e','d',' ','f','r','o','m',' ','M','a','c','r','o',' ','m','e','n','u',' ','c','o','m','m','a','n','d','s',',',' ','w','i','n','d','o','w',' ','b','a','c','k','g','r','o','u','n','d',' ','m','e','n','u',' ',
'c','o','m','m','a','n','d','s',',',' ','w','i','t','h','i','n',' ','t','h','e',' ','s','m','a','r','t','-','i','n','d','e','n','t',' ',
'f','r','a','m','e','w','o','r','k',',',' ','a','n','d',' ','f','r','o','m',' ','t','h','e',' ','.','n','e','d','i','t','m','a','c','r','o',' ','f','i','l','e','.',' ',' ','M','a','c','r','o',' ','m','e','n','u',' ','a','n','d',' ','w','i','n','d','o','w',' ',
'b','a','c','k','g','r','o','u','n','d',' ','m','e','n','u',' ','c','o','m','m','a','n','d','s',' ','a','r','e',' ','d','e','f','i','n','e','d',' ','u','n','d','e','r',' ','P','r','e','f','e','r','e','n','c','e','s',' ','-','>',' ',
'D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s',' ','-','>',' ','C','u','s','t','o','m','i','z','e',' ','M','e','n','u','s','.',' ',' ','H','e','l','p',' ','o','n',' ','c','r','e','a','t','i','n','g',' ','i','t','e','m','s',' ','i','n',' ','t','h','e','s','e',' ','m','e','n','u','s',' ',
'c','a','n',' ','b','e',' ','f','o','u','n','d',' ','i','n',' ','t','h','e',' ','s','e','c','t','i','o','n',',',' ','H','e','l','p',' ','-','>',' ','C','u','s','t','o','m','i','z','i','n','g',' ','-','>',' ','P','r','e','f','e','r','e','n','c','e','s','.',' ',' ',
'T','h','e',' ','.','n','e','d','i','t','m','a','c','r','o',' ','f','i','l','e',' ','i','s',' ','a',' ','f','i','l','e',' ','o','f',' ','m','a','c','r','o',' ','c','o','m','m','a','n','d','s',' ','a','n','d',' ','d','e','f','i','n','i','t','i','o','n','s',' ','w','h','i','c','h',' ','y','o','u',' ',
'c','a','n',' ','c','r','e','a','t','e',' ','i','n',' ','y','o','u','r',' ','h','o','m','e',' ','d','i','r','e','c','t','o','r','y',',',' ','a','n','d',' ',
'w','h','i','c','h',' ','N','E','d','i','t',' ','w','i','l','l',' ','a','u','t','o','m','a','t','i','c','a','l','l','y',' ','l','o','a','d',' ','w','h','e','n',' ','i','t',' ','i','s',' ','f','i','r','s','t',' ','s','t','a','r','t','e','d','.','\n',
'\n',
'N','E','d','i','t',''','s',' ','m','a','c','r','o',' ','l','a','n','g','u','a','g','e',' ','i','s',' ','a',' ','s','i','m','p','l','e',' ','i','n','t','e','r','p','r','e','t','e','r',' ','w','i','t','h',' ','i','n','t','e','g','e','r',' ',
'a','r','i','t','h','m','e','t','i','c',',',' ','d','y','n','a','m','i','c',' ','s','t','r','i','n','g','s',',',' ','a','n','d',' ','C','-','s','t','y','l','e',' ','l','o','o','p','i','n','g',' ','c','o','n','s','t','r','u','c','t','s',' ',
'(','v','e','r','y',' ','s','i','m','i','l','a','r',' ','t','o',' ','t','h','e',' ','p','r','o','c','e','d','u','r','a','l',' ','p','o','r','t','i','o','n',' ','o','f',' ','t','h','e',' ','U','n','i','x',' ','a','w','k',' ','p','r','o','g','r','a','m',')','.',' ',' ',
'F','r','o','m',' ','t','h','e',' ','m','a','c','r','o',' ','l','a','n','g','u','a','g','e',',',' ','y','o','u',' ','c','a','n',' ','c','a','l','l',' ','t','h','e',' ','s','a','m','e',' ','a','c','t','i','o','n',' ','r','o','u','t','i','n','e','s',' ',
'w','h','i','c','h',' ','a','r','e',' ','b','o','u','n','d',' ','t','o',' ','k','e','y','b','o','a','r','d',' ','k','e','y','s',' ','a','n','d',' ','m','e','n','u',' ','i','t','e','m','s',',',' ','a','s',' ','w','e','l','l',' ',
'a','d','d','i','t','i','o','n','a','l',' ','s','u','b','r','o','u','t','i','n','e','s',' ','f','o','r',' ','a','c','c','e','s','s','i','n','g',' ','a','n','d',' ','m','a','n','i','p','u','l','a','t','i','n','g',' ','e','d','i','t','o','r',' ','d','a','t','a',',',' ',
'w','h','i','c','h',' ','a','r','e',' ','s','p','e','c','i','f','i','c',' ','t','o',' ','t','h','e',' ','m','a','c','r','o',' ','l','a','n','g','u','a','g','e',' ','(','t','h','e','s','e',' ','a','r','e',' ','l','i','s','t','e','d',' ','i','n',' ','t','h','e',' ',
's','e','c','t','i','o','n','s',' ','t','i','t','l','e','d',' ','M','a','c','r','o',' ','S','u','b','r','o','u','t','i','n','e','s',',',' ','a','n','d',' ','A','c','t','i','o','n','s',')','.','\n',
'\n',
'\n',
'S','Y','N','T','A','X','\n',
'\n',
'A','n',' ','N','E','d','i','t',' ','m','a','c','r','o',' ','l','a','n','g','u','a','g','e',' ','p','r','o','g','r','a','m',' ','c','o','n','s','i','s','t','s',' ','o','f',' ','a',' ','l','i','s','t',' ','o','f',' ','s','t','a','t','e','m','e','n','t','s',',',' ',
'e','a','c','h',' ','t','e','r','m','i','n','a','t','e','d',' ','b','y',' ','a',' ','n','e','w','l','i','n','e','.',' ',' ','G','r','o','u','p','s',' ','o','f',' ','s','t','a','t','e','m','e','n','t','s',' ','w','h','i','c','h',' ','a','r','e',' ',
'e','x','e','c','u','t','e','d',' ','t','o','g','e','t','h','e','r',' ','c','o','n','d','i','t','i','o','n','a','l','l','y',',',' ','s','u','c','h',' ','a','s',' ','t','h','e',' ','b','o','d','y',' ','o','f',' ','a',' ','l','o','o','p',',',' ','a','r','e',' ',
's','u','r','r','o','u','n','d','e','d',' ','b','y',' ','c','u','r','l','y',' ','b','r','a','c','e','s',' ','\"','{','}','\"','.','\n',
'\n',
'B','l','a','n','k',' ','l','i','n','e','s',' ','a','n','d',' ','c','o','m','m','e','n','t','s',' ','a','r','e',' ','a','l','s','o',' ','a','l','l','o','w','e','d','.',' ',' ','C','o','m','m','e','n','t','s',' ','b','e','g','i','n',' ','w','i','t','h',' ','a',' ',
'\"','#','\"',' ','a','n','d',' ','e','n','d',' ','w','i','t','h',' ','a',' ','n','e','w','l','i','n','e',',',' ','a','n','d',' ','c','a','n',' ','a','p','p','e','a','r',' ','e','i','t','h','e','r',' ','o','n',' ','a',' ','l','i','n','e',' ','b','y',' ',
't','h','e','m','s','e','l','v','e','s',',',' ','o','r',' ','a','t',' ','t','h','e',' ','e','n','d',' ','o','f',' ','a',' ','s','t','a','t','e','m','e','n','t','.','\n',
'\n',
'S','t','a','t','e','m','e','n','t','s',' ','w','h','i','c','h',' ','a','r','e',' ','t','o','o',' ','l','o','n','g',' ','t','o',' ','f','i','t',' ','o','n',' ','a',' ','s','i','n','g','l','e',' ','l','i','n','e',' ','m','a','y',' ','b','e',' ',
's','p','l','i','t',' ','a','c','r','o','s','s',' ','s','e','v','e','r','a','l',' ','l','i','n','e','s',',',' ','b','y',' ','p','l','a','c','i','n','g',' ','a',' ','b','a','c','k','s','l','a','s','h',' ','\"','\\','\"',' ','c','h','a','r','a','c','t','e','r',' ',
'a','t',' ','t','h','e',' ','e','n','d',' ','o','f',' ','e','a','c','h',' ','l','i','n','e',' ','t','o',' ','b','e',' ','c','o','n','t','i','n','u','e','d','.','\n',
'\n',
'\n',
'D','A','T','A',' ','T','Y','P','E','S','\n',
'\n',
'T','h','e',' ','N','E','d','i','t',' ','m','a','c','r','o',' ','l','a','n','g','u','a','g','e',' ','r','e','c','o','g','n','i','z','e','s',' ','o','n','l','y',' ','t','w','o',' ','d','a','t','a',' ','t','y','p','e','s',',',' ','d','y','n','a','m','i','c',' ',
'c','h','a','r','a','c','t','e','r',' ','s','t','r','i','n','g','s',',',' ','a','n','d',' ','i','n','t','e','g','e','r',' ','v','a','l','u','e','s','.',' ',' ','I','n',' ','g','e','n','e','r','a','l',' ','s','t','r','i','n','g','s',' ','a','n','d',' ',
'i','n','t','e','g','e','r','s',' ','c','a','n',' ','b','e',' ','u','s','e','d',' ','i','n','t','e','r','c','h','a','n','g','e','a','b','l','y','.',' ',' ','I','f',' ','a',' ','s','t','r','i','n','g',' ','r','e','p','r','e','s','e','n','t','s',' ','a','n',' ',
'i','n','t','e','g','e','r',' ','v','a','l','u','e',',',' ','i','t',' ','c','a','n',' ','b','e',' ','u','s','e','d',' ','a','s',' ','a','n',' ','i','n','t','e','g','e','r','.',' ',' ','I','n','t','e','g','e','r','s',' ','c','a','n',' ','b','e',' ',
'c','o','m','p','a','r','e','d',' ','a','n','d',' ','c','o','n','c','a','t','e','n','a','t','e','d',' ','w','i','t','h',' ','s','t','r','i','n','g','s','.','\n',
'\n',
'I','n','t','e','g','e','r',' ','C','o','n','s','t','a','n','t','s','\n',
'\n',
'I','n','t','e','g','e','r','s',' ','a','r','e',' ','n','o','n','-','f','r','a','c','t','i','o','n','a','l',' ','n','u','m','b','e','r','s',' ','i','n',' ','t','h','e',' ','r','a','n','g','e',' ','o','f',' ','-','2','1','4','7','4','8','3','6','4','7',' ','t','o',' ',
'2','1','4','7','4','8','3','6','4','7','.',' ',' ','I','n','t','e','g','e','r',' ','c','o','n','s','t','a','n','t','s',' ','m','u','s','t',' ','b','e',' ','i','n',' ','d','e','c','i','m','a','l','.',' ',' ','F','o','r',' ','e','x','a','m','p','l','e',':','\n',
'\n',
' ',' ','a',' ','=',' ','-','1','\n',
' ',' ','b',' ','=',' ','1','0','0','0','\n',
'\n',
'C','h','a','r','a','c','t','e','r',' ','S','t','r','i','n','g',' ','C','o','n','s','t','a','n','t','s','\n',
'\n',
'C','h','a','r','a','c','t','e','r',' ','s','t','r','i','n','g',' ','c','o','n','s','t','a','n','t','s',' ','a','r','e',' ','e','n','c','l','o','s','e','d',' ','i','n',' ',
'd','o','u','b','l','e',' ','q','u','o','t','e','s','.',' ',' ','F','o','r',' ','e','x','a','m','p','l','e',':','\n',
'\n',
' ',' ',' ','a',' ','=',' ','\"','a',' ','s','t','r','i','n','g','\"','\n',
' ',' ',' ','d','i','a','l','o','g','(','\"','H','i',' ','t','h','e','r','e','!','\"',',',' ','\"','D','i','s','m','i','s','s','\"',')','\n',
'\n',
'S','t','r','i','n','g','s',' ','m','a','y',' ','a','l','s','o',' ','i','n','c','l','u','d','e',' ','C','-','l','a','n','g','u','a','g','e',' ','s','t','y','l','e',' ','e','s','c','a','p','e',' ','s','e','q','u','e','n','c','e','s',':','\n',
'\n',
' ',' ',' ','\\','\\',' ','B','a','c','k','s','l','a','s','h',' ',' ',' ',' ',' ',' ','\\','t',' ','T','a','b','	','	',' ',' ','\\','f',' ','F','o','r','m',' ','f','e','e','d','\n',
' ',' ',' ','\\','\"',' ','D','o','u','b','l','e',' ','q','u','o','t','e',' ',' ',' ','\\','b',' ','B','a','c','k','s','p','a','c','e','	',' ',' ','\\','a',' ','A','l','e','r','t','\n',
' ',' ',' ','\\','n',' ','N','e','w','l','i','n','e','	',' ',' ',' ',' ',' ','\\','r',' ','C','a','r','r','i','a','g','e',' ','r','e','t','u','r','n',' ',' ',' ','\\','v',' ','V','e','r','t','i','c','a','l',' ','t','a','b','\n',
'\n',
'F','o','r',' ','e','x','a','m','p','l','e',',',' ','t','o',' ','s','e','n','d',' ','o','u','t','p','u','t',' ','t','o',' ','t','h','e',' ','t','e','r','m','i','n','a','l',' ',
'f','r','o','m',' ','w','h','i','c','h',' ','n','e','d','i','t',' ','w','a','s',' ','s','t','a','r','t','e','d',',',' ','a',' ','n','e','w','l','i','n','e',' ','c','h','a','r','a','c','t','e','r',' ','i','s',' ','n','e','c','c','e','s','s','a','r','y',' ',
'b','e','c','a','u','s','e',',',' ','l','i','k','e',' ','p','r','i','n','t','f',',',' ','t','_','p','r','i','n','t',' ','r','e','q','u','i','r','e','s',' ','e','x','p','l','i','c','i','t',' ','n','e','w','l','i','n','e','s',',',' ','a','n','d',' ',
'a','l','s','o',' ','b','u','f','f','e','r','s',' ','i','t','s',' ','o','u','t','p','u','t',' ','o','n',' ','a',' ','p','e','r','-','l','i','n','e',' ','b','a','s','i','s',':','\n',
'\n',
' ',' ',' ','t','_','p','r','i','n','t','(','\"','a',' ','=',' ','\"',' ','a',' ','\"','\\','n','\"',')','\n',
'\n',
'\n',
'V','A','R','I','A','B','L','E','S','\n',
'\n',
'V','a','r','i','a','b','l','e',' ','n','a','m','e','s',' ','m','u','s','t',' ','b','e','g','i','n',' ','e','i','t','h','e','r',' ','w','i','t','h',' ','a',' ','l','e','t','t','e','r',' ','(','l','o','c','a','l',' ','v','a','r','i','a','b','l','e','s',')',',',' ','o','r',' ',
'a',' ','$',' ','(','g','l','o','b','a','l',' ','v','a','r','i','a','b','l','e','s',')','.',' ',' ','B','e','y','o','n','d',' ','t','h','e',' ','f','i','r','s','t',' ','c','h','a','r','a','c','t','e','r',',',' ','v','a','r','i','a','b','l','e','s',' ','m','a','y',' ',
'a','l','s','o',' ','c','o','n','t','a','i','n',' ','n','u','m','b','e','r','s',' ','a','n','d',' ','u','n','d','e','r','s','c','o','r','e','s',' ','`','_',''','.',' ',' ','V','a','r','i','a','b','l','e','s',' ','a','r','e',' ','c','a','l','l','e','d',' ','i','n',' ','t','o',' ',
'e','x','i','s','t','e','n','c','e',' ','j','u','s','t',' ','b','y',' ','s','e','t','t','i','n','g',' ','t','h','e','m',' ','(','n','o',' ','e','x','p','l','i','c','i','t',' ','d','e','c','l','a','r','a','t','i','o','n','s',' ','a','r','e',' ','n','e','c','e','s','s','a','r','y',')','.','\n',
'\n',
'L','o','c','a','l',' ','v','a','r','i','a','b','l','e','s',' ','a','r','e',' ','l','i','m','i','t','e','d',' ','i','n',' ','s','c','o','p','e',' ','t','o',' ',
't','h','e',' ','s','u','b','r','o','u','t','i','n','e',' ','(','o','r',' ','m','e','n','u',' ','i','t','e','m',' ','d','e','f','i','n','i','t','i','o','n',')',' ','i','n',' ','w','h','i','c','h',' ','t','h','e','y',' ','a','p','p','e','a','r','.',' ',' ',
'G','l','o','b','a','l',' ','v','a','r','i','a','b','l','e','s',' ','a','r','e',' ','a','c','c','e','s','s','i','b','l','e',' ','f','r','o','m',' ','a','l','l',' ','r','o','u','t','i','n','e','s',',',' ','a','n','d',' ','t','h','e','i','r',' ','v','a','l','u','e','s',' ',
'p','e','r','s','i','s','t',' ','b','e','y','o','n','d',' ','t','h','e',' ','c','a','l','l',' ','w','h','i','c','h',' ','c','r','e','a','t','e','d',' ','t','h','e','m',',',' ','u','n','t','i','l',' ','r','e','s','e','t','.','\n',
'\n',
'B','u','i','l','t','-','i','n',' ','V','a','r','i','a','b','l','e','s','\n',
'\n',
'N','E','d','i','t',' ','h','a','s',' ','a',' ','n','u','m','b','e','r',' ','o','f',' ','p','e','r','m','a','n','e','n','t','l','y',' ','d','e','f','i','n','e','d',' ','v','a','r','i','a','b','l','e','s',',',' ','w','h','i','c','h',' ','a','r','e',' ','u','s','e','d',' ',
't','o',' ','a','c','c','e','s','s',' ','g','l','o','b','a','l',' ','e','d','i','t','o','r',' ','i','n','f','o','r','m','a','t','i','o','n',' ','a','n','d',' ','i','n','f','o','r','m','a','t','i','o','n',' ','a','b','o','u','t',' ','t','h','e',' ','t','h','e',' ',
'w','i','n','d','o','w',' ','i','n',' ','w','h','i','c','h',' ','t','h','e',' ','m','a','c','r','o',' ','i','s',' ','e','x','e','c','u','t','i','n','g','.',' ',' ','T','h','e','s','e',' ','a','r','e',' ','l','i','s','t','e','d',' ','a','l','o','n','g',' ','w','i','t','h',' ',
't','h','e',' ','b','u','i','l','t',' ','i','n',' ','f','u','n','c','t','i','o','n','s',' ','i','n',' ','t','h','e',' ','s','e','c','t','i','o','n',' ','t','i','t','l','e','d',' ','M','a','c','r','o',' ','S','u','b','r','o','u','t','i','n','e','s','.','\n',
'\n',
'\n',
'F','U','N','C','T','I','O','N','S',' ','a','n','d',' ','S','U','B','R','O','U','T','I','N','E','S','\n',
'\n',
'T','h','e',' ','s','y','n','t','a','x',' ','o','f',' ','a',' ','f','u','n','c','t','i','o','n',' ','o','r',' ','s','u','b','r','o','u','t','i','n','e',' ','c','a','l','l',' ','i','s',':','\n',
'\n',
' ',' ',' ','f','u','n','c','t','i','o','n','_','n','a','m','e','(','a','r','g','1',',',' ','a','r','g','2',',',' ','.','.','.',')','\n',
'\n',
'w','h','e','r','e',' ','a','r','g','1',',',' ','a','r','g','2',',',' ','e','t','c','.',' ','r','e','p','r','e','s','e','n','t',' ','u','p',' ','t','o',' ','9',' ','a','r','g','u','m','e','n','t',' ','v','a','l','u','e','s',' ','w','h','i','c','h',' ','a','r','e',' ',
'p','a','s','s','e','d',' ','t','o',' ','t','h','e',' ','r','o','u','t','i','n','e',' ','b','e','i','n','g',' ','c','a','l','l','e','d','.',' ',' ','A',' ','f','u','n','c','t','i','o','n',' ','o','r',' ','s','u','b','r','o','u','t','i','n','e',' ','c','a','l','l',' ',
'c','a','n',' ','b','e',' ','o','n',' ','a',' ','l','i','n','e',' ','b','y',' ','i','t','s','e','l','f',',',' ','a','s',' ','a','b','o','v','e',',',' ','o','r',' ','i','f',' ','i','t',' ',
'r','e','t','u','r','n','s',' ','a',' ','v','a','l','u','e',',',' ','c','a','n',' ','b','e',' ','i','n','v','o','k','e','d',' ','w','i','t','h','i','n',' ','a',' ','c','h','a','r','a','c','t','e','r',' ','o','r',' ','n','u','m','e','r','i','c',' ',
'e','x','p','r','e','s','s','i','o','n',':','\n',
'\n',
' ',' ',' ','a',' ','=',' ','f','n','1','(','b',',',' ','c',')',' ','+',' ','f','n','2','(','d',')','\n',
' ',' ',' ','d','i','a','l','o','g','(','\"','f','n','3',' ','s','a','y','s',':',' ','\"',' ','f','n','3','(',')',')','\n',
'\n',
'A','r','g','u','m','e','n','t','s',' ','a','r','e',' ','p','a','s','s','e','d',' ','b','y',' ','v','a','l','u','e','.',' ',' ','T','h','i','s',' ','m','e','a','n','s',' ','t','h','a','t',' ','y','o','u',' ','c','a','n',' ','n','o','t',' ','r','e','t','u','r','n',' ',
'v','a','l','u','e','s',' ','v','i','a',' ','t','h','e',' ','a','r','g','u','m','e','n','t',' ','l','i','s','t',',',' ','o','n','l','y',' ','t','h','r','o','u','g','h',' ','t','h','e',' ','f','u','n','c','t','i','o','n',' ','v','a','l','u','e',' ','o','r',' ',
'i','n','d','i','r','e','c','t','l','y',' ','t','h','r','o','u','g','h',' ','a','g','r','e','e','d','-','u','p','o','n',' ','g','l','o','b','a','l',' ','v','a','r','i','a','b','l','e','s','.','\n',
'\n',
'B','u','i','l','t','-','i','n',' ','F','u','n','c','t','i','o','n','s','\n',
'\n',
'N','E','d','i','t',' ','h','a','s',' ','a',' ','w','i','d','e',' ','r','a','n','g','e',' ','o','f',' ','b','u','i','l','t',' ','i','n',' ','f','u','n','c','t','i','o','n','s',' ','w','h','i','c','h',' ','c','a','n',' ','b','e',' ','c','a','l','l','e','d',' ','f','r','o','m',' ',
't','h','e',' ','m','a','c','r','o',' ','l','a','n','g','u','a','g','e','.',' ',' ','T','h','e','s','e',' ','r','o','u','t','i','n','e','s',' ','a','r','e',' ','d','i','v','i','d','e','d',' ','i','n','t','o',' ','t','w','o',' ','c','l','a','s','s','e','s',',',' ',
'm','a','c','r','o','-','l','a','n','g','u','a','g','e',' ','f','u','n','c','t','i','o','n','s',',',' ','a','n','d',' ','e','d','i','t','o','r',' ','a','c','t','i','o','n',' ','r','o','u','t','i','n','e','s','.',' ',' ','E','d','i','t','o','r',' ','a','c','t','i','o','n',' ',
'r','o','u','t','i','n','e','s',' ','a','r','e',' ','m','o','r','e',' ','f','l','e','x','i','b','l','e',',',' ','i','n',' ','t','h','a','t',' ','t','h','e','y',' ','m','a','y',' ','b','e',' ','c','a','l','l','e','d',' ','e','i','t','h','e','r',' ','f','r','o','m',' ',
't','h','e',' ','m','a','c','r','o',' ','l','a','n','g','u','a','g','e',',',' ','o','r',' ','b','o','u','n','d',' ','d','i','r','e','c','t','l','y',' ','t','o',' ','k','e','y','s',' ','v','i','a',' ','t','r','a','n','s','l','a','t','i','o','n',' ','t','a','b','l','e','s','.',' ',' ',
'T','h','e','y',' ','a','r','e',' ','a','l','s','o',' ','l','i','m','i','t','e','d',',',' ','h','o','w','e','v','e','r',',',' ','i','n',' ','t','h','a','t',' ','t','h','e','y',' ','c','a','n',' ','n','o','t',' ','r','e','t','u','r','n',' ','v','a','l','u','e','s','.',' ',' ',
'M','a','c','r','o',' ','l','a','n','g','u','a','g','e',' ','r','o','u','t','i','n','e','s',' ','c','a','n',' ','r','e','t','u','r','n',' ','v','a','l','u','e','s',',',' ','b','u','t',' ','c','a','n',' ','n','o','t',' ','b','e',' ','b','o','u','n','d',' ','t','o',' ',
'k','e','y','s',' ','i','n',' ','t','r','a','n','s','l','a','t','i','o','n',' ','t','a','b','l','e','s','.','\n',
'\n',
'N','e','a','r','l','y',' ','a','l','l',' ','o','f',' ','t','h','e',' ','b','u','i','l','t','-','i','n',' ','s','u','b','r','o','u','t','i','n','e','s',' ','o','p','e','r','a','t','e',' ','o','n',' ','a','n',' ','i','m','p','l','i','e','d',' ','w','i','n','d','o','w',',',' ',
'w','h','i','c','h',' ','i','s',' ','i','n','i','t','i','a','l','l','y',' ','t','h','e',' ','w','i','n','d','o','w',' ','f','r','o','m',' ','w','h','i','c','h',' ','t','h','e',' ','m','a','c','r','o',' ','w','a','s',' ','s','t','a','r','t','e','d','.',' ',' ','T','o',' ',
'm','a','n','i','p','u','l','a','t','e',' ','t','h','e',' ','c','o','n','t','e','n','t','s',' ','o','f',' ','o','t','h','e','r',' ','w','i','n','d','o','w','s',',',' ','u','s','e',' ','t','h','e',' ','f','o','c','u','s','_','w','i','n','d','o','w',' ',
's','u','b','r','o','u','t','i','n','e',' ','t','o',' ','c','h','a','n','g','e',' ','t','h','e',' ','f','o','c','u','s',' ','t','o',' ','t','h','e',' ','o','n','e','s',' ','y','o','u',' ','w','i','s','h',' ','t','o',' ','m','o','d','i','f','y','.',' ',' ',
'f','o','c','u','s','_','w','i','n','d','o','w',' ','c','a','n',' ','a','l','s','o',' ','b','e',' ','u','s','e','d',' ','t','o',' ','i','t','e','r','a','t','e',' ','o','v','e','r',' ','a','l','l',' ','o','f',' ','t','h','e',' ','c','u','r','r','e','n','t','l','y',' ','o','p','e','n',' ',
'w','i','n','d','o','w','s',',',' ','u','s','i','n','g',' ','t','h','e',' ','s','p','e','c','i','a','l',' ','k','e','y','w','o','r','d',' ','n','a','m','e','s',',',' ','\"','l','a','s','t','\"',' ','a','n','d',' ','\"','n','e','x','t','\"','.','\n',
'\n',
'F','o','r',' ','b','a','c','k','w','a','r','d','s',' ','c','o','m','p','a','t','i','b','i','l','i','t','y',',',' ','h','y','p','h','e','n','a','t','e','d',' ','a','c','t','i','o','n',' ','r','o','u','t','i','n','e',' ','n','a','m','e','s',' ','a','r','e',' ',
'a','l','l','o','w','e','d',',',' ','a','n','d',' ','m','o','s','t',' ','o','f',' ','t','h','e',' ','e','x','i','s','t','i','n','g',' ','a','c','t','i','o','n',' ','r','o','u','t','i','n','e','s',' ','n','a','m','e','s',' ','w','h','i','c','h',' ','c','o','n','t','a','i','n',' ',
'u','n','d','e','r','s','c','o','r','e','s',' ','h','a','v','e',' ','a','n',' ','e','q','u','i','v','a','l','e','n','t',' ','v','e','r','s','i','o','n',' ','c','o','n','t','a','i','n','i','n','g',' ','h','y','p','h','e','n','s',' ','(',''','-',''',')',' ',
'i','n','s','t','e','a','d',' ','o','f',' ','u','n','d','e','r','s','c','o','r','e','s','.',' ',' ','U','s','e',' ','o','f',' ','t','h','e','s','e',' ','n','a','m','e','s',' ','i','s',' ','d','i','s','c','o','u','r','a','g','e','d','.',' ',' ','T','h','e',' ','m','a','c','r','o',' ',
'p','a','r','s','e','r',' ','r','e','s','o','l','v','e','s',' ','t','h','e',' ','a','m','b','i','g','u','i','t','y',' ','b','e','t','w','e','e','n',' ',''','-',''',' ','a','s',' ','t','h','e',' ','s','u','b','t','r','a','c','t','i','o','n','/','n','e','g','a','t','i','o','n',' ',
'o','p','e','r','a','t','o','r',',',' ','a','n','d',' ','-',' ','a','s',' ','p','a','r','t',' ','o','f',' ','a','n',' ','a','c','t','i','o','n',' ','r','o','u','t','i','n','e',' ','n','a','m','e',' ','b','y',' ','a','s','s','u','m','i','n','g',' ',
's','u','b','t','r','a','c','t','i','o','n',' ','u','n','l','e','s','s',' ','t','h','e',' ','s','y','m','b','o','l',' ','s','p','e','c','i','f','i','c','a','l','l','y',' ','m','a','t','c','h','e','s',' ','a','n',' ','a','c','t','i','o','n',' ','r','o','u','t','i','n','e',' ',
'n','a','m','e','.','\n',
'\n',
'U','s','e','r',' ','D','e','f','i','n','e','d',' ','F','u','n','c','t','i','o','n','s','\n',
'\n',
'U','s','e','r','s',' ','c','a','n',' ','d','e','f','i','n','e',' ','t','h','e','i','r',' ','o','w','n',' ','m','a','c','r','o',' ','s','u','b','r','o','u','t','i','n','e','s',',',' ','u','s','i','n','g',' ','t','h','e',' ','d','e','f','i','n','e',' ',
'k','e','y','w','o','r','d',':','\n',
'\n',
' ',' ',' ','d','e','f','i','n','e',' ','s','u','b','r','o','u','t','i','n','e','_','n','a','m','e',' ','{','\n',
' ',' ',' ',' ',' ',' ','<',' ','b','o','d','y',' ','o','f',' ','s','u','b','r','o','u','t','i','n','e',' ','>','\n',
' ',' ',' ','}','\n',
'\n',
'M','a','c','r','o',' ','d','e','f','i','n','i','t','i','o','n','s',' ','c','a','n',' ','n','o','t',' ','a','p','p','e','a','r',' ','w','i','t','h','i','n',' ','o','t','h','e','r',' ','d','e','f','i','n','i','t','i','o','n','s',',',' ','o','r',' ','w','i','t','h','i','n',' ','m','a','c','r','o',' ',
'm','e','n','u',' ','i','t','e','m',' ','d','e','f','i','n','i','t','i','o','n','s',' ','(','u','s','u','a','l','l','y',' ','t','h','e','y',' ','a','r','e',' ','f','o','u','n','d',' ','i','n',' ','t','h','e',' ','.','n','e','d','i','t','m','a','c','r','o',' ','f','i','l','e',')','.','\n',
'\n',
'T','h','e',' ','a','r','g','u','m','e','n','t','s',' ','w','i','t','h',' ','w','h','i','c','h',' ','a',' ','u','s','e','r','-','d','e','f','i','n','e','d',' ','s','u','b','r','o','u','t','i','n','e',' ','o','r',' ','f','u','n','c','t','i','o','n',' ','w','a','s',' ',
'i','n','v','o','k','e','d',',',' ','a','r','e',' ','p','r','e','s','e','n','t','e','d',' ','a','s',' ','$','1',',',' ','$','2',',',' ','.','.','.',' ',',',' ','$','9','.',' ',' ','T','h','e',' ','n','u','m','b','e','r',' ','o','f',' ','a','r','g','u','m','e','n','t','s',' ',
'c','a','n',' ','b','e',' ','r','e','a','d',' ','f','r','o','m',' ','$','n','_','a','r','g','s','.','\n',
'\n',
'\n',
'O','P','E','R','A','T','O','R','S',' ','A','N','D',' ','E','X','P','R','E','S','S','I','O','N','S','\n',
'\n',
'O','p','e','r','a','t','o','r','s',' ','h','a','v','e',' ','t','h','e',' ','s','a','m','e',' ','m','e','a','n','i','n','g',' ','a','n','d',' ','p','r','e','c','e','d','e','n','c','e',' ','t','h','a','t',' ','t','h','e','y',' ','d','o',' ','i','n',' ','C',',',' ',
'e','x','c','e','p','t',' ','f','o','r',' ','^',',',' ','w','h','i','c','h',' ','r','a','i','s','e','s',' ','a',' ','n','u','m','b','e','r',' ','t','o',' ','a',' ','p','o','w','e','r',' ','(','y','^','x',' ','m','e','a','n','s',' ','y',' ','t','o',' ','t','h','e',' ','x',' ',
'p','o','w','e','r',')',',',' ','r','a','t','h','e','r',' ','t','h','a','n',' ','b','i','t','w','i','s','e',' ','e','x','c','l','u','s','i','v','e',' ','O','R','.',' ',' ','T','h','e',' ','t','a','b','l','e',' ','b','e','l','o','w',' ','l','i','s','t','s',' ',
'o','p','e','r','a','t','o','r','s',' ','i','n',' ','d','e','c','r','e','a','s','i','n','g',' ','o','r','d','e','r',' ','o','f',' ','p','r','e','c','e','d','e','n','c','e','.','\n',
'\n',
' ',' ',' ','O','p','e','r','a','t','o','r','s','	','	',' ',' ',' ',' ','A','s','s','o','c','i','a','t','i','v','i','t','y','\n',
' ',' ',' ','(',')','\n',
' ',' ',' ','^','	','	','	',' ',' ',' ',' ','r','i','g','h','t',' ','t','o',' ','l','e','f','t','\n',
' ',' ',' ','-',' ','!',' ','+','+',' ','-','-','	','	',' ',' ',' ',' ','(','u','n','a','r','y',')','\n',
' ',' ',' ','*',' ','/',' ','%','	','	',' ',' ',' ',' ','l','e','f','t',' ','t','o',' ','r','i','g','h','t','\n',
' ',' ',' ','+',' ','-',' ',' ','	','	',' ',' ',' ',' ','l','e','f','t',' ','t','o',' ','r','i','g','h','t','\n',
' ',' ',' ','>',' ','>','=',' ','<',' ','<','=',' ','=','=',' ','!','=','	',' ',' ',' ',' ','l','e','f','t',' ','t','o',' ','r','i','g','h','t','\n',
' ',' ',' ','&','	','	','	',' ',' ',' ',' ','l','e','f','t',' ','t','o',' ','r','i','g','h','t','\n',
' ',' ',' ','|','	','	','	',' ',' ',' ',' ','l','e','f','t',' ','t','o',' ','r','i','g','h','t','\n',
' ',' ',' ','&','&','	','	','	',' ',' ',' ',' ','l','e','f','t',' ','t','o',' ','r','i','g','h','t','\n',
' ',' ',' ','|','|','	','	','	',' ',' ',' ',' ','l','e','f','t',' ','t','o',' ','r','i','g','h','t','\n',
' ',' ',' ','(','c','o','n','c','a','t','e','n','a','t','i','o','n',')','	',' ',' ',' ',' ','l','e','f','t',' ','t','o',' ','r','i','g','h','t','\n',
' ',' ',' ','=',' ','+','=',' ','-','=',' ','*','=',' ','/','=',' ','%','=',',',' ','&','=',' ','|','=',' ',' ','r','i','g','h','t',' ','t','o',' ','l','e','f','t','\n',
'\n',
'T','h','e',' ','o','r','d','e','r',' ','i','n',' ','w','h','i','c','h',' ','o','p','e','r','a','n','d','s',' ','a','r','e',' ','e','v','a','l','u','a','t','e','d',' ','i','n',' ','a','n',' ','e','x','p','r','e','s','s','i','o','n',' ','i','s',' ',
'u','n','d','e','f','i','n','e','d',',',' ','e','x','c','e','p','t',' ','f','o','r',' ','&','&',' ','a','n','d',' ','|','|',',',' ','w','h','i','c','h',' ','l','i','k','e',' ','C',',',' ','e','v','a','l','u','a','t','e',' ','o','p','e','r','a','n','d','s',' ','l','e','f','t',' ',
't','o',' ','r','i','g','h','t',',',' ','b','u','t',' ','s','t','o','p',' ','w','h','e','n',' ','f','u','r','t','h','e','r',' ','e','v','a','l','u','a','t','i','o','n',' ','w','o','u','l','d',' ','n','o',' ','l','o','n','g','e','r',' ','c','h','a','n','g','e',' ','t','h','e',' ',
'r','e','s','u','l','t','.','\n',
'\n',
'N','u','m','e','r','i','c','a','l',' ','O','p','e','r','a','t','o','r','s','\n',
'\n',
'T','h','e',' ','n','u','m','e','r','i','c',' ','o','p','e','r','a','t','o','r','s',' ','s','u','p','p','o','r','t','e','d',' ','b','y',' ','t','h','e',' ','N','E','d','i','t',' ','m','a','c','r','o',' ','l','a','n','g','u','a','g','e',' ','a','r','e',' ','l','i','s','t','e','d',' ',
'b','e','l','o','w',':','\n',
'\n',
' ',' ',' ','+',' ','a','d','d','i','t','i','o','n','\n',
' ',' ',' ','-',' ','s','u','b','t','r','a','c','t','i','o','n',' ','o','r',' ','n','e','g','a','t','i','o','n','\n',
' ',' ',' ','*',' ','m','u','l','t','i','p','l','i','c','a','t','i','o','n','\n',
' ',' ',' ','/',' ','d','i','v','i','s','i','o','n','\n',
' ',' ',' ','%',' ','m','o','d','u','l','o','\n',
' ',' ',' ','^',' ','p','o','w','e','r','\n',
' ',' ',' ','&',' ','b','i','t','w','i','s','e',' ','a','n','d','\n',
' ',' ',' ','|',' ','b','i','t','w','i','s','e',' ','o','r','\n',
'\n',
'I','n','c','r','e','m','e','n','t',' ','(','+','+',')',' ','a','n','d',' ','d','e','c','r','e','m','e','n','t',' ','(','-','-',')',' ','o','p','e','r','a','t','o','r','s',' ','c','a','n',' ','a','l','s','o',' ','b','e',' ','a','p','p','e','n','d','e','d',' ','o','r',' ',
'p','r','e','p','e','n','d','e','d',' ','t','o',' ','v','a','r','i','a','b','l','e','s',' ','w','i','t','h','i','n',' ','a','n',' ','e','x','p','r','e','s','s','i','o','n','.',' ',' ','P','r','e','p','e','n','d','e','d',' ','i','n','c','r','e','m','e','n','t','/','d','e','c','r','e','m','e','n','t',' ',
'o','p','e','r','a','t','o','r','s',' ','a','c','t',' ','b','e','f','o','r','e',' ','t','h','e',' ','v','a','r','i','a','b','l','e',' ','i','s',' ','e','v','a','u','l','a','t','e','d','.',' ',' ','A','p','p','e','n','d','e','d',' ','i','n','c','r','e','m','e','n','t','/','d','e','c','r','e','m','e','n','t',' ',
'o','p','e','r','a','t','o','r','s',' ','a','c','t',' ','a','f','t','e','r',' ','t','h','e',' ','v','a','r','i','a','b','l','e',' ','i','s',' ','e','v','a','l','u','a','t','e','d','.','\n',
'\n',
'L','o','g','i','c','a','l',' ','a','n','d',' ','C','o','m','p','a','r','i','s','o','n',' ','O','p','e','r','a','t','o','r','s','\n',
'\n',
'L','o','g','i','c','a','l',' ','o','p','e','r','a','t','i','o','n','s',' ','p','r','o','d','u','c','e',' ','a',' ','r','e','s','u','l','t',' ','o','f',' ','0',' ','(','f','o','r',' ','f','a','l','s','e',')',' ','o','r',' ','1',' ','(','f','o','r',' ','t','r','u','e',')','.',' ',' ',
'I','n',' ','a',' ','l','o','g','i','c','a','l',' ','o','p','e','r','a','t','i','o','n',',',' ','a','n','y',' ','n','o','n','-','z','e','r','o',' ','v','a','l','u','e',' ','i','s',' ','r','e','c','o','g','n','i','z','e','d',' ','t','o',' ','m','e','a','n',' ','t','r','u','e','.',' ',' ',
'T','h','e',' ','l','o','g','i','c','a','l',' ','a','n','d',' ','c','o','m','p','a','r','i','s','o','n',' ','o','p','e','r','a','t','o','r','s',' ','a','l','l','o','w','e','d',' ','i','n',' ','t','h','e',' ','N','E','d','i','t',' ','m','a','c','r','o',' ',
'l','a','n','g','u','a','g','e',' ','a','r','e',' ','l','i','s','t','e','d',' ','b','e','l','o','w',':','\n',
'\n',
' ',' ',' ','&','&',' ','l','o','g','i','c','a','l',' ','a','n','d','\n',
' ',' ',' ','|','|',' ','l','o','g','i','c','a','l',' ','o','r','\n',
' ',' ',' ','!',' ',' ','n','o','t','\n',
' ',' ',' ','>',' ',' ','g','r','e','a','t','e','r','\n',
' ',' ',' ','<',' ',' ','l','e','s','s','\n',
' ',' ',' ','>','=',' ','g','r','e','a','t','e','r',' ','o','r',' ','e','q','u','a','l','\n',
' ',' ',' ','<','=',' ','l','e','s','s',' ','o','r',' ','e','q','u','a','l','\n',
' ',' ',' ','=','=',' ','e','q','u','a','l',' ','(','i','n','t','e','g','e','r','s',' ','a','n','d','/','o','r',' ','s','t','r','i','n','g','s',')','\n',
' ',' ',' ','!','=',' ','n','o','t',' ','e','q','u','a','l',' ','(','i','n','t','e','g','e','r','s',' ','a','n','d','/','o','r',' ','s','t','r','i','n','g','s',')','\n',
'\n',
'C','h','a','r','a','c','t','e','r',' ','S','t','r','i','n','g',' ','O','p','e','r','a','t','o','r','s','\n',
'\n',
'T','h','e',' ','\"','o','p','e','r','a','t','o','r','\"',' ','f','o','r',' ','c','o','n','c','a','t','e','n','a','t','i','n','g',' ','t','w','o',' ','s','t','r','i','n','g','s',' ','i','s',' ','t','h','e',' ','a','b','s','e','n','c','e',' ','o','f',' ','a','n',' ',
'o','p','e','r','a','t','o','r','.',' ',' ','A','d','j','o','i','n','i','n','g',' ','c','h','a','r','a','c','t','e','r',' ','s','t','r','i','n','g','s',' ','w','i','t','h',' ','n','o',' ','o','p','e','r','a','t','o','r',' ','i','n',' ','b','e','t','w','e','e','n',' ',
'm','e','a','n','s',' ','c','o','n','c','a','t','e','n','a','t','i','o','n',':','\n',
'\n',
' ',' ',' ','d',' ','=',' ','a',' ','b',' ','\"','s','t','r','i','n','g','\"',' ','c','\n',
' ',' ',' ','t','_','p','r','i','n','t','(','\"','t','h','e',' ','v','a','l','u','e',' ','o','f',' ','a',' ','i','s',':',' ','\"',' ','a',')','\n',
'\n',
'C','o','m','p','a','r','i','s','o','n',' ','b','e','t','w','e','e','n',' ','c','h','a','r','a','c','t','e','r',' ','s','t','r','i','n','g','s',' ','i','s',' ','d','o','n','e',' ','w','i','t','h',' ','t','h','e',' ','=','=',' ','a','n','d',' ','!','=',' ',
'o','p','e','r','a','t','o','r','s',',',' ','(','a','s',' ','w','i','t','h',' ','i','n','t','e','g','e','r','s',')','.',' ',' ','T','h','e','r','e',' ','a','r','e',' ','a',' ','n','u','m','b','e','r',' ','o','f',' ','u','s','e','f','u','l',' ',
'b','u','i','l','t','-','i','n',' ','r','o','u','t','i','n','e','s',' ','f','o','r',' ','w','o','r','k','i','n','g',' ','w','i','t','h',' ','c','h','a','r','a','c','t','e','r',' ','s','t','r','i','n','g','s',',',' ','w','h','i','c','h',' ','a','r','e',' ',
'l','i','s','t','e','d',' ','i','n',' ','t','h','e',' ','s','e','c','t','i','o','n',' ','c','a','l','l','e','d',' ','M','a','c','r','o',' ','S','u','b','r','o','u','t','i','n','e','s','.','\n',
'\n',
'\n',
'L','O','O','P','I','N','G',' ','A','N','D',' ','C','O','N','D','I','T','I','O','N','A','L','S','\n',
'\n',
'N','E','d','i','t',' ','s','u','p','p','o','r','t','s',' ','l','o','o','p','i','n','g',' ','c','o','n','s','t','r','u','c','t','s',':',' ','f','o','r',' ','a','n','d',' ','w','h','i','l','e',',',' ','a','n','d',' ','c','o','n','d','i','t','i','o','n','a','l',' ',
's','t','a','t','e','m','e','n','t','s',':',' ','i','f',' ','a','n','d',' ','e','l','s','e',',',' ','w','i','t','h',' ','e','s','s','e','n','t','i','a','l','l','y',' ','t','h','e',' ','s','a','m','e',' ','s','y','n','t','a','x',' ','a','s',' ','C',':','\n',
'\n',
' ',' ',' ','f','o','r',' ','(','<','i','n','i','t','>',',',' ','.','.','.',';',' ','<','c','o','n','d','i','t','i','o','n','>',';',' ','<','i','n','c','r','e','m','e','n','t','>',',',' ','.','.','.',')',' ','<','b','o','d','y','>','\n',
'\n',
' ',' ',' ','w','h','i','l','e',' ','(','<','c','o','n','d','i','t','i','o','n','>',')',' ','<','b','o','d','y','>','\n',
'\n',
' ',' ',' ','i','f',' ','(','<','c','o','n','d','i','t','i','o','n','>',')',' ','<','b','o','d','y','>','\n',
'\n',
' ',' ',' ','i','f',' ','(','<','c','o','n','d','i','t','i','o','n','>',')',' ','<','b','o','d','y','>',' ','e','l','s','e',' ','<','b','o','d','y','>','\n',
'\n',
'<','b','o','d','y','>',',',' ','a','s',' ','i','n',' ','C',',',' ','c','a','n',' ','b','e',' ','a',' ','s','i','n','g','l','e',' ','s','t','a','t','e','m','e','n','t',',',' ','o','r',' ','a',' ','l','i','s','t',' ','o','f',' ','s','t','a','t','e','m','e','n','t','s',' ',
'e','n','c','l','o','s','e','d',' ','i','n',' ','c','u','r','l','y',' ','b','r','a','c','e','s',' ','(','{','}',')','.',' ',' ','<','c','o','n','d','i','t','i','o','n','>',' ','i','s',' ','a','n',' ','e','x','p','r','e','s','s','i','o','n',' ','w','h','i','c','h',' ',
'm','u','s','t',' ','e','v','a','l','u','a','t','e',' ','t','o',' ','t','r','u','e',' ','f','o','r',' ','t','h','e',' ','s','t','a','t','e','m','e','n','t','s',' ','i','n',' ','<','b','o','d','y','>',' ','t','o',' ','b','e',' ','e','x','e','c','u','t','e','d','.',' ',' ',
'f','o','r',' ','l','o','o','p','s',' ','m','a','y',' ','a','l','s','o',' ','c','o','n','t','a','i','n',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','s','t','a','t','e','m','e','n','t','s',',',' ','<','i','n','i','t','>',',',' ',
'e','x','e','c','u','t','e','d',' ','o','n','c','e',' ','a','t',' ','t','h','e',' ','b','e','g','i','n','n','i','n','g',' ','o','f',' ','t','h','e',' ','l','o','o','p',',',' ','a','n','d',' ','i','n','c','r','e','m','e','n','t','/','d','e','c','r','e','m','e','n','t',' ',
's','t','a','t','e','m','e','n','t','s',' ','(','o','r',' ','a','n','y',' ','a','r','b','i','t','r','a','r','y',' ','s','t','a','t','e','m','e','n','t',')',',',' ','w','h','i','c','h',' ','a','r','e',' ','e','x','e','c','u','t','e','d',' ','a','t',' ','t','h','e',' ','e','n','d',' ',
'o','f',' ','t','h','e',' ','l','o','o','p',',',' ','b','e','f','o','r','e',' ','t','h','e',' ','c','o','n','d','i','t','i','o','n',' ','i','s',' ','e','v','a','l','u','a','t','e','d',' ','a','g','a','i','n','.','\n',
'\n',
'E','x','a','m','p','l','e','s',':','\n',
'\n',
' ',' ','f','o','r',' ','(','i','=','0',';',' ','i','<','1','0','0',';',' ','i','+','+',')','\n',
' ',' ',' ',' ',' ','j',' ','=',' ','i',' ','*',' ','2','\n',
'\n',
' ',' ','f','o','r',' ','(','i','=','0',',',' ','j','=','2','0',';',' ','i','<','2','0',';',' ','i','+','+',',',' ','j','-','-',')',' ','{','\n',
' ',' ',' ',' ',' ','k',' ','=',' ','i',' ','*',' ','j','\n',
' ',' ',' ',' ',' ','t','_','p','r','i','n','t','(','i',',',' ','j',',',' ','k',')','\n',
' ',' ','}','\n',
'\n',
' ',' ','w','h','i','l','e',' ','(','k',' ','>',' ','0',')','\n',
' ',' ','{','\n',
' ',' ',' ',' ',' ','k',' ','=',' ','k',' ','-',' ','1','\n',
' ',' ',' ',' ',' ','t','_','p','r','i','n','t','(','k',')','\n',
' ',' ','}','\n',
'\n',
' ',' ','f','o','r',' ','(',';',';',')',' ','{','\n',
' ',' ',' ',' ',' ','i','f',' ','(','i','-','-',' ','<',' ','1',')','\n',
' ',' ',' ',' ',' ',' ',' ',' ',' ','b','r','e','a','k','\n',
' ',' ','}','\n',
'\n',
'L','o','o','p','s',' ','m','a','y',' ','c','o','n','t','a','i','n',' ','b','r','e','a','k',' ','a','n','d',' ','c','o','n','t','i','n','u','e',' ','s','t','a','t','e','m','e','n','t','s','.',' ',' ','A',' ','b','r','e','a','k',' ','s','t','a','t','e','m','e','n','t',' ',
'c','a','u','s','e','s',' ','a','n',' ','e','x','i','t',' ','f','r','o','m',' ','t','h','e',' ','i','n','n','e','r','m','o','s','t',' ','l','o','o','p',',',' ','a',' ','c','o','n','t','i','n','u','e',' ','s','t','a','t','e','m','e','n','t',' ','t','r','a','n','s','f','e','r','s',' ',
'c','o','n','t','r','o','l',' ','t','o',' ','t','h','e',' ','e','n','d',' ','o','f',' ','t','h','e',' ','l','o','o','p','.','\0'};

static char AuxString24[] = {'B','u','i','l','t',' ','i','n',' ','V','a','r','i','a','b','l','e','s','\n',
'\n',
'$','c','u','r','s','o','r',' ','-','-',' ','P','o','s','i','t','i','o','n',' ','o','f',' ','t','h','e',' ','c','u','r','s','o','r',' ','i','n',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','w','i','n','d','o','w','.','\n',
'\n',
'$','c','o','l','u','m','n',' ','-','-',' ','C','o','l','u','m','n',' ','n','u','m','b','e','r',' ','o','f',' ','t','h','e',' ','c','u','r','s','o','r',' ','p','o','s','i','t','i','o','n',' ','i','n',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','w','i','n','d','o','w','.','\n',
'\n',
'$','e','m','_','t','a','b','_','d','i','s','t',' ','-','-',' ','I','f',' ','t','a','b',' ','e','m','u','l','a','t','i','o','n',' ','i','s',' ','t','u','r','n','e','d',' ','o','n',' ','i','n',' ','t','h','e',' ','T','a','b','s','.','.','.',' ','d','i','a','l','o','g',' ','o','f',' ',
't','h','e',' ','P','r','e','f','e','r','e','n','c','e','s',' ','m','e','n','u',',',' ','v','a','l','u','e',' ','i','s',' ','t','h','e',' ','d','i','s','t','a','n','c','e',' ','b','e','t','w','e','e','n',' ','e','m','u','l','a','t','e','d',' ','t','a','b',' ','s','t','o','p','s','.',' ',' ','I','f',' ',
't','a','b',' ','e','m','u','l','a','t','i','o','n',' ','i','s',' ','t','u','r','n','e','d',' ','o','f','f',',',' ','v','a','l','u','e',' ','i','s',' ','-','1','.','\n',
'\n',
'$','f','i','l','e','_','n','a','m','e',' ','-','-',' ','N','a','m','e',' ','o','f',' ','t','h','e',' ','f','i','l','e',' ','b','e','i','n','g',' ','e','d','i','t','e','d',' ','i','n',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','w','i','n','d','o','w',',',' ',
's','t','r','i','p','p','e','d',' ','o','f',' ','d','i','r','e','c','t','o','r','y',' ','c','o','m','p','o','n','e','n','t','.','\n',
'\n',
'$','f','i','l','e','_','p','a','t','h',' ','-','-',' ','D','i','r','e','c','t','o','r','y',' ','c','o','m','p','o','n','e','n','t',' ','o','f',' ','f','i','l','e',' ','b','e','i','n','g',' ','e','d','i','t','e','d',' ','i','n',' ','t','h','e',' ',
'c','u','r','r','e','n','t',' ','w','i','n','d','o','w','.','\n',
'\n',
'$','l','a','n','g','u','a','g','e','_','m','o','d','e',' ','-','-',' ','N','a','m','e',' ','o','f',' ','l','a','n','g','u','a','g','e',' ','m','o','d','e',' ','s','e','t',' ','i','n',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','w','i','n','d','o','w','.','\n',
'\n',
'$','l','i','n','e',' ','-','-',' ','L','i','n','e',' ','n','u','m','b','e','r',' ','o','f',' ','t','h','e',' ','c','u','r','s','o','r',' ','p','o','s','i','t','i','o','n',' ','i','n',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','w','i','n','d','o','w','.','\n',
'\n',
'$','m','o','d','i','f','i','e','d',' ','-','-',' ','T','r','u','e',' ','i','f',' ','t','h','e',' ','f','i','l','e',' ','i','n',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','w','i','n','d','o','w',' ','h','a','s',' ','b','e','e','n',' ','m','o','d','i','f','i','e','d',' ',
'a','n','d',' ','t','h','e',' ','m','o','d','i','f','i','c','a','t','i','o','n','s',' ','h','a','v','e',' ','n','o','t',' ','y','e','t',' ','b','e','e','n',' ','s','a','v','e','d','.','\n',
'\n',
'$','s','e','l','e','c','t','i','o','n','_','s','t','a','r','t',',',' ','$','s','e','l','e','c','t','i','o','n','_','e','n','d',' ','-','-',' ','B','e','g','i','n','n','i','n','g',' ','a','n','d',' ','e','n','d','i','n','g',' ','p','o','s','i','t','i','o','n','s',' ','o','f',' ',
't','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','i','n',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','w','i','n','d','o','w',',',' ','o','r',' ','-','1',' ','i','f',' ','t','h','e','r','e',' ','i','s',' ','n','o',' ',
't','e','x','t',' ','s','e','l','e','c','t','e','d',' ','i','n',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','w','i','n','d','o','w','.','\n',
'\n',
'$','s','e','l','e','c','t','i','o','n','_','l','e','f','t',',',' ','$','s','e','l','e','c','t','i','o','n','_','r','i','g','h','t',' ','-','-',' ','L','e','f','t',' ','a','n','d',' ','r','i','g','h','t',' ','c','h','a','r','a','c','t','e','r',' ','o','f','f','s','e','t','s',' ','o','f',' ',
't','h','e',' ','r','e','c','t','a','n','g','u','l','a','r',' ','(','p','r','i','m','a','r','y',')',' ','s','e','l','e','c','t','i','o','n',' ','i','n',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','w','i','n','d','o','w',',',' ','o','r',' ','-','1',' ','i','f',' ',
't','h','e','r','e',' ','i','s',' ','n','o',' ','s','e','l','e','c','t','i','o','n',' ','o','r',' ','i','t',' ','i','s',' ','n','o','t',' ','r','e','c','t','a','n','g','u','l','a','r','.','\n',
'\n',
'$','t','a','b','_','d','i','s','t',' ','-','-',' ','T','h','e',' ','d','i','s','t','a','n','c','e',' ','b','e','t','w','e','e','n',' ','t','a','b',' ','s','t','o','p','s',' ','f','o','r',' ','a',' ','h','a','r','d','w','a','r','e',' ','t','a','b',' ',
'c','h','a','r','a','c','t','e','r',',',' ','a','s',' ','s','e','t',' ','i','n',' ','t','h','e',' ','T','a','b','s','.','.','.',' ','d','i','a','l','o','g',' ','o','f',' ','t','h','e',' ','P','r','e','f','e','r','e','n','c','e','s',' ','m','e','n','u','.','\n',
'\n',
'$','t','e','x','t','_','l','e','n','g','t','h',' ','-','-',' ','T','h','e',' ','l','e','n','g','t','h',' ','o','f',' ','t','h','e',' ','t','e','x','t',' ','i','n',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','w','i','n','d','o','w','.','\n',
'\n',
'$','u','s','e','_','t','a','b','s',' ','-','-',' ','W','h','e','t','h','e','r',' ','t','h','e',' ','u','s','e','r',' ','i','s',' ','a','l','l','o','w','i','n','g',' ','t','h','e',' ','N','E','d','i','t',' ','t','o',' ','i','n','s','e','r','t',' ','t','a','b',' ',
'c','h','a','r','a','c','t','e','r','s',' ','t','o',' ','m','a','i','n','t','a','i','n',' ','s','p','a','c','i','n','g',' ','i','n',' ','t','a','b',' ','e','m','u','l','a','t','i','o','n',' ','a','n','d',' ','r','e','c','t','a','n','g','u','l','a','r',' ',
'd','r','a','g','g','i','n','g',' ','o','p','e','r','a','t','i','o','n','s','.',' ','(','T','h','e',' ','s','e','t','t','i','n','g',' ','o','f',' ','t','h','e',' ','\"','U','s','e',' ','t','a','b',' ','c','h','a','r','a','c','t','e','r','s',' ','i','n',' ',
'p','a','d','d','i','n','g',' ','a','n','d',' ','e','m','u','l','a','t','e','d',' ','t','a','b','s','\"',' ','b','u','t','t','o','n',' ','i','n',' ','t','h','e',' ','T','a','b','s','.','.','.',' ','d','i','a','l','o','g',' ','o','f',' ','t','h','e',' ',
'P','r','e','f','e','r','e','n','c','e','s',' ','m','e','n','u','.',')','\n',
'\n',
'$','w','r','a','p','_','m','a','r','g','i','n',' ','-','-',' ','T','h','e',' ','r','i','g','h','t',' ','m','a','r','g','i','n',' ','i','n',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','w','i','n','d','o','w',' ','f','o','r',' ','t','e','x','t',' ',
'w','r','a','p','p','i','n','g',' ','a','n','d',' ','f','i','l','l','i','n','g','.','\n',
'\n',
'\n',
'B','u','i','l','t','-','i','n',' ','S','u','b','r','o','u','t','i','n','e','s','\n',
'\n',
'a','p','p','e','n','d','_','f','i','l','e','(','s','t','r','i','n','g',',',' ','f','i','l','e','n','a','m','e',')',' ','-','-',' ','A','p','p','e','n','d','s',' ','a',' ','s','t','r','i','n','g',' ','t','o',' ',
'a',' ','n','a','m','e','d',' ','f','i','l','e','.',' ',' ','R','e','t','u','r','n','s',' ','1',' ','o','n',' ','s','u','c','c','e','s','s','f','u','l',' ','w','r','i','t','e',',',' ','o','r',' ','0',' ',
'i','f',' ','u','n','s','u','c','c','e','s','s','f','u','l','.','\n',
'\n',
'b','e','e','p','(',')',' ','-','-',' ','R','i','n','g',' ','t','h','e',' ','b','e','l','l','\n',
'\n',
'c','l','i','p','b','o','a','r','d','_','t','o','_','s','t','r','i','n','g','(',')',' ','-','-',' ','R','e','t','u','r','n','s',' ','t','h','e',' ','c','o','n','t','e','n','t','s',' ','o','f',' ','t','h','e',' ','c','l','i','p','b','o','a','r','d',' ',
'a','s',' ','a',' ','m','a','c','r','o',' ','s','t','r','i','n','g','.',' ',' ','R','e','t','u','r','n','s',' ','e','m','p','t','y',' ','s','t','r','i','n','g',' ','o','n',' ','e','r','r','o','r','.','\n',
'\n',
'd','i','a','l','o','g','(','m','e','s','s','a','g','e',',',' ','b','t','n','_','1','_','l','a','b','e','l',',',' ','b','t','n','_','2','_','l','a','b','e','l',',',' ','.','.','.',')',' ','-','-',' ','P','o','p',' ','u','p',' ','a',' ','d','i','a','l','o','g',' ',
'f','o','r',' ','q','u','e','r','y','i','n','g',' ','a','n','d',' ','p','r','e','s','e','n','t','i','n','g',' ','i','n','f','o','r','m','a','t','i','o','n',' ','t','o',' ','t','h','e',' ','u','s','e','r','.',' ',' ','F','i','r','s','t',' ',
'a','r','g','u','m','e','n','t',' ','i','s',' ','a',' ','s','t','r','i','n','g',' ','t','o',' ','s','h','o','w',' ','i','n',' ','t','h','e',' ','m','e','s','s','a','g','e',' ','a','r','e','a',' ','o','f',' ','t','h','e',' ','d','i','a','l','o','g','.',' ',' ','U','p',' ',
't','o',' ','n','i','n','e',' ','a','d','d','i','t','i','o','n','a','l',' ','o','p','t','i','o','n','a','l',' ','a','r','g','u','m','e','n','t','s',' ','r','e','p','r','e','s','e','n','t',' ','l','a','b','e','l','s',' ','f','o','r',' ','b','u','t','t','o','n','s',' ',
't','o',' ','a','p','p','e','a','r',' ','a','l','o','n','g',' ','t','h','e',' ','b','o','t','t','o','m',' ','o','f',' ','t','h','e',' ','d','i','a','l','o','g','.',' ',' ','R','e','t','u','r','n','s',' ','t','h','e',' ','n','u','m','b','e','r',' ','o','f',' ',
't','h','e',' ','b','u','t','t','o','n',' ','p','r','e','s','s','e','d',' ','(','t','h','e',' ','f','i','r','s','t',' ','b','u','t','t','o','n',' ','i','s',' ','n','u','m','b','e','r',' ','1',')',',',' ','o','r',' ','0',' ','i','f',' ','t','h','e',' ',
'u','s','e','r',' ','c','l','o','s','e','d',' ','t','h','e',' ','d','i','a','l','o','g',' ','v','i','a',' ','t','h','e',' ','w','i','n','d','o','w',' ','c','l','o','s','e',' ','b','o','x','.','\n',
'\n',
'f','o','c','u','s','_','w','i','n','d','o','w','(','w','i','n','d','o','w','_','n','a','m','e',')',' ','-','-',' ','S','e','t','s',' ','t','h','e',' ','w','i','n','d','o','w',' ','o','n',' ','w','h','i','c','h',' ','s','u','b','s','e','q','u','e','n','t',' ',
'm','a','c','r','o',' ','c','o','m','m','a','n','d','s',' ','o','p','e','r','a','t','e','.',' ',' ','w','i','n','d','o','w','_','n','a','m','e',' ','c','a','n',' ','b','e',' ','e','i','t','h','e','r',' ','a',' ','f','u','l','l','y',' ','q','u','a','l','i','f','i','e','d',' ',
'f','i','l','e',' ','n','a','m','e',',',' ','o','r',' ','o','n','e',' ','o','f',' ','\"','l','a','s','t','\"',' ','f','o','r',' ','t','h','e',' ','l','a','s','t',' ','w','i','n','d','o','w',' ','c','r','e','a','t','e','d',',',' ','o','r',' ','\"','n','e','x','t','\"',' ',
'f','o','r',' ','t','h','e',' ','n','e','x','t',' ','w','i','n','d','o','w',' ','i','n',' ','t','h','e',' ','c','h','a','i','n',' ','f','r','o','m',' ','t','h','e',' ','c','u','r','r','e','n','t','l','y',' ','f','o','c','u','s','e','d',' ','w','i','n','d','o','w',' ','(','t','h','e',' ',
'f','i','r','s','t',' ','w','i','n','d','o','w',' ','b','e','i','n','g',' ','t','h','e',' ','o','n','e',' ','r','e','t','u','r','n','e','d',' ','f','r','o','m',' ','c','a','l','l','i','n','g',' ','f','o','c','u','s','_','w','i','n','d','o','w','(','\"','l','a','s','t','\"',')','.',' ',' ',
'R','e','t','u','r','n','s',' ','t','h','e',' ','n','a','m','e',' ','o','f',' ','t','h','e',' ','n','e','w','l','y','-','f','o','c','u','s','e','d',' ','w','i','n','d','o','w',',',' ','o','r',' ','a','n',' ','e','m','p','t','y',' ','s','t','r','i','n','g',' ',
'i','f',' ','t','h','e',' ','r','e','q','u','e','s','t','e','d',' ','w','i','n','d','o','w',' ','w','a','s',' ','n','o','t',' ','f','o','u','n','d','.','\n',
'\n',
'g','e','t','_','c','h','a','r','a','c','t','e','r','(','p','o','s','i','t','i','o','n',')',' ','-','-',' ','R','e','t','u','r','n','s',' ','t','h','e',' ','s','i','n','g','l','e',' ','c','h','a','r','a','c','t','e','r',' ','a','t',' ','t','h','e',' ',
'p','o','s','i','t','i','o','n',' ','i','n','d','i','c','a','t','e','d',' ','b','y',' ','t','h','e',' ','f','i','r','s','t',' ','a','r','g','u','m','e','n','t',' ','t','o',' ','t','h','e',' ','r','o','u','t','i','n','e',' ','f','r','o','m',' ','t','h','e',' ',
'c','u','r','r','e','n','t',' ','w','i','n','d','o','w','.','\n',
'\n',
'g','e','t','_','r','a','n','g','e','(','s','t','a','r','t',',',' ','e','n','d',')',' ','-','-',' ','R','e','t','u','r','n','s',' ','t','h','e',' ','t','e','x','t',' ','b','e','t','w','e','e','n',' ','a',' ','s','t','a','r','t','i','n','g',' ','a','n','d',' ',
'e','n','d','i','n','g',' ','p','o','s','i','t','i','o','n',' ','f','r','o','m',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','w','i','n','d','o','w','.','\n',
'\n',
'g','e','t','_','s','e','l','e','c','t','i','o','n','(',')',' ','-','-',' ','R','e','t','u','r','n','s',' ','a',' ','s','t','r','i','n','g',' ','c','o','n','t','a','i','n','i','n','g',' ','t','h','e',' ','t','e','x','t',' ','c','u','r','r','e','n','t','l','y',' ',
's','e','l','e','c','t','e','d',' ','b','y',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','e','i','t','h','e','r',' ','f','r','o','m',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','w','i','n','d','o','w',' ','(','n','o',' ',
'k','e','y','w','o','r','d',')',',',' ','o','r',' ','f','r','o','m',' ','a','n','y','w','h','e','r','e',' ','o','n',' ','t','h','e',' ','s','c','r','e','e','n',' ','(','k','e','y','w','o','r','d',' ','\"','a','n','y','\"',')','.','\n',
'\n',
'l','e','n','g','t','h','(','s','t','r','i','n','g',')',' ','-','-',' ','R','e','t','u','r','n','s',' ','t','h','e',' ','l','e','n','g','t','h',' ','o','f',' ','a',' ','s','t','r','i','n','g','\n',
'\n',
'm','a','x','(','n','1',',',' ','n','2',',',' ','.','.','.',')',' ','-','-',' ','R','e','t','u','r','n','s',' ','t','h','e',' ','m','a','x','i','m','u','m',' ','v','a','l','u','e',' ','o','f',' ','a','l','l',' ','o','f',' ','i','t','s',' ',
'a','r','g','u','m','e','n','t','s','\n',
'\n',
'm','i','n','(','n','1',',',' ','n','2',',',' ','.','.','.',')',' ','-','-',' ','R','e','t','u','r','n','s',' ','t','h','e',' ','m','i','n','i','m','u','m',' ','v','a','l','u','e',' ','o','f',' ','a','l','l',' ','o','f',' ','i','t','s',' ',
'a','r','g','u','m','e','n','t','s','\n',
'\n',
'r','e','a','d','_','f','i','l','e','(','f','i','l','e','n','a','m','e',')',' ','-','-',' ','R','e','a','d','s',' ','t','h','e',' ','c','o','n','t','e','n','t','s',' ','o','f',' ','a',' ','t','e','x','t',' ','f','i','l','e',' ','i','n','t','o',' ','a',' ',
's','t','r','i','n','g','.',' ',' ','O','n',' ','s','u','c','c','e','s','s',',',' ','r','e','t','u','r','n','s',' ','1',' ','i','n',' ','$','r','e','a','d','_','s','t','a','t','u','s',',',' ','a','n','d',' ','t','h','e',' ','c','o','n','t','e','n','t','s',' ','o','f',' ',
't','h','e',' ','f','i','l','e',' ','a','s',' ','a',' ','s','t','r','i','n','g',' ','i','n',' ','t','h','e',' ','s','u','b','r','o','u','t','i','n','e',' ','r','e','t','u','r','n',' ','v','a','l','u','e','.',' ',' ','O','n',' ','f','a','i','l','u','r','e',',',' ',
'r','e','t','u','r','n','s',' ','t','h','e',' ','e','m','p','t','y',' ','s','t','r','i','n','g',' ','\"','\"',' ','a','n','d',' ','a','n',' ','0',' ','$','r','e','a','d','_','s','t','a','t','u','s','.','\n',
'\n',
'r','e','p','l','a','c','e','_','i','n','_','s','t','r','i','n','g','(','s','t','r','i','n','g',',',' ','s','e','a','r','c','h','_','f','o','r',',',' ','r','e','p','l','a','c','e','_','w','i','t','h',',',' ','[','t','y','p','e',']',')',' ','-','-',' ',
'R','e','p','l','a','c','e','s',' ','a','l','l',' ','o','c','c','u','r','r','e','n','c','e','s',' ','o','f',' ','a',' ','s','e','a','r','c','h',' ','s','t','r','i','n','g',' ','i','n',' ','a',' ','s','t','r','i','n','g',' ','w','i','t','h',' ','a',' ',
'r','e','p','l','a','c','e','m','e','n','t',' ','s','t','r','i','n','g','.',' ',' ','A','r','g','u','m','e','n','t','s',' ','a','r','e',' ','1',':',' ','s','t','r','i','n','g',' ','t','o',' ','s','e','a','r','c','h',' ','i','n',',',' ','2',':',' ',
's','t','r','i','n','g',' ','t','o',' ','s','e','a','r','c','h',' ','f','o','r',',',' ','3',':',' ','r','e','p','l','a','c','e','m','e','n','t',' ','s','t','r','i','n','g','.',' ',' ','A','r','g','u','m','e','n','t',' ','4',' ','i','s',' ','a','n',' ',
'o','p','t','i','o','n','a','l',' ','s','e','a','r','c','h',' ','t','y','p','e',',',' ','o','n','e',' ','o','f',' ','\"','l','i','t','e','r','a','l','\"',',',' ','\"','c','a','s','e','\"',' ','o','r',' ','\"','r','e','g','e','x','\"','.',' ',' ','T','h','e',' ',
'd','e','f','a','u','l','t',' ','s','e','a','r','c','h',' ','t','y','p','e',' ','i','s',' ','\"','l','i','t','e','r','a','l','\"','.',' ',' ','R','e','t','u','r','n','s',' ','a',' ','n','e','w',' ','s','t','r','i','n','g',' ','w','i','t','h',' ','a','l','l',' ','o','f',' ',
't','h','e',' ','r','e','p','l','a','c','e','m','e','n','t','s',' ','d','o','n','e',',',' ','o','r',' ','a','n',' ','e','m','p','t','y',' ','s','t','r','i','n','g',' ','(','\"','\"',')',' ','i','f',' ','n','o',' ','o','c','c','u','r','r','e','n','c','e','s',' ',
'w','e','r','e',' ','f','o','u','n','d','.','\n',
'\n',
'r','e','p','l','a','c','e','_','r','a','n','g','e','(','s','t','a','r','t',',',' ','e','n','d',',',' ','s','t','r','i','n','g',')',' ','-','-',' ','R','e','p','l','a','c','e','s',' ','a','l','l',' ','o','f',' ','t','h','e',' ','t','e','x','t',' ','i','n',' ','t','h','e',' ',
'c','u','r','r','e','n','t',' ','w','i','n','d','o','w',' ','b','e','t','w','e','e','n',' ','t','w','o',' ','p','o','s','i','t','i','o','n','s','\n',
'\n',
'r','e','p','l','a','c','e','_','s','e','l','e','c','t','i','o','n','(','s','t','r','i','n','g',')',' ','-','-',' ','R','e','p','l','a','c','e','s',' ','t','h','e',' ','p','r','i','m','a','r','y','-','s','e','l','e','c','t','i','o','n',' ',
's','e','l','e','c','t','e','d',' ','t','e','x','t',' ','i','n',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','w','i','n','d','o','w','.','\n',
'\n',
'r','e','p','l','a','c','e','_','s','u','b','s','t','r','i','n','g','(','s','t','r','i','n','g',',',' ','s','t','a','r','t',',',' ','e','n','d',',',' ','r','e','p','l','a','c','e','_','w','i','t','h',')',' ','-','-',' ','R','e','p','l','a','c','i','n','g',' ','a',' ',
's','u','b','s','t','r','i','n','g',' ','b','e','t','w','e','e','n',' ','t','w','o',' ','p','o','s','i','t','i','o','n','s',' ','i','n',' ','a',' ','s','t','r','i','n','g',' ','w','i','t','h','i','n',' ','a','n','o','t','h','e','r',' ','s','t','r','i','n','g','.','\n',
'\n',
's','e','a','r','c','h','(','s','e','a','r','c','h','_','f','o','r',',',' ','s','t','a','r','t',',',' ','[','s','e','a','r','c','h','_','t','y','p','e',',',' ','w','r','a','p',',',' ','d','i','r','e','c','t','i','o','n',']',')',' ','-','-',' ',
'S','e','a','r','c','h','e','s',' ','s','i','l','e','n','t','l','y',' ','i','n',' ','a',' ','w','i','n','d','o','w',' ','w','i','t','h','o','u','t',' ','d','i','a','l','o','g','s',',',' ','b','e','e','p','s',',',' ','o','r',' ','c','h','a','n','g','e','s',' ','t','o',' ',
't','h','e',' ','s','e','l','e','c','t','i','o','n','.',' ',' ','A','r','g','u','m','e','n','t','s',' ','a','r','e',':',' ','1',':',' ','s','t','r','i','n','g',' ','t','o',' ','s','e','a','r','c','h',' ','f','o','r',',',' ','2',':',' ','s','t','a','r','t','i','n','g',' ',
'p','o','s','i','t','i','o','n','.',' ','O','p','t','i','o','n','a','l',' ','a','r','g','u','m','e','n','t','s',' ','m','a','y',' ','i','n','c','l','u','d','e',' ','t','h','e',' ','s','t','r','i','n','g','s',':',' ','\"','w','r','a','p','\"',' ','t','o',' ',
'm','a','k','e',' ','t','h','e',' ','s','e','a','r','c','h',' ','w','r','a','p',' ','a','r','o','u','n','d',' ','t','h','e',' ','b','e','g','i','n','n','i','n','g',' ','o','r',' ','e','n','d',' ','o','f',' ','t','h','e',' ','s','t','r','i','n','g',',',' ',
'\"','b','a','c','k','w','a','r','d','\"',' ','o','r',' ','\"','f','o','r','w','a','r','d','\"',' ','t','o',' ','c','h','a','n','g','e',' ','t','h','e',' ','s','e','a','r','c','h',' ','d','i','r','e','c','t','i','o','n',' ','(','\"','f','o','r','w','a','r','d','\"',' ',
'i','s',' ','t','h','e',' ','d','e','f','a','u','l','t',')',',',' ','\"','l','i','t','e','r','a','l','\"',',',' ','\"','c','a','s','e','\"',' ','o','r',' ','\"','r','e','g','e','x','\"',' ','t','o',' ','c','h','a','n','g','e',' ','t','h','e',' ','s','e','a','r','c','h',' ',
't','y','p','e',' ','(','d','e','f','a','u','l','t',' ','i','s',' ','\"','l','i','t','e','r','a','l','\"',')','.',' ',' ','R','e','t','u','r','n','s',' ','t','h','e',' ','s','t','a','r','t','i','n','g',' ','p','o','s','i','t','i','o','n',' ','o','f',' ','t','h','e',' ',
'm','a','t','c','h',',',' ','o','r',' ','-','1',' ','i','f',' ','n','o','t','h','i','n','g',' ','m','a','t','c','h','e','d','.',' ','a','l','s','o',' ','r','e','t','u','r','n','s',' ','t','h','e',' ','e','n','d','i','n','g',' ','p','o','s','i','t','i','o','n',' ',
'o','f',' ','t','h','e',' ','m','a','t','c','h',' ','i','n',' ','s','e','a','r','c','h','_','e','n','d','\n',
'\n',
's','e','a','r','c','h','_','s','t','r','i','n','g','(','s','t','r','i','n','g',',',' ','s','e','a','r','c','h','_','f','o','r',',',' ','s','t','a','r','t',',',' ','[','s','e','a','r','c','h','_','t','y','p','e',',',' ','d','i','r','e','c','t','i','o','n',']',')',' ',
'-','-',' ','B','u','i','l','t','-','i','n',' ','m','a','c','r','o',' ','s','u','b','r','o','u','t','i','n','e',' ','f','o','r',' ','s','e','a','r','c','h','i','n','g',' ','a',' ','s','t','r','i','n','g','.',' ',' ','A','r','g','u','m','e','n','t','s',' ','a','r','e',' ',
'1',':',' ','s','t','r','i','n','g',' ','t','o',' ','s','e','a','r','c','h',' ','i','n',',',' ','2',':',' ','s','t','r','i','n','g',' ','t','o',' ','s','e','a','r','c','h',' ','f','o','r',',',' ','3',':',' ','s','t','a','r','t','i','n','g',' ',
'p','o','s','i','t','i','o','n','.',' ',' ','O','p','t','i','o','n','a','l',' ','a','r','g','u','m','e','n','t','s',' ','m','a','y',' ','i','n','c','l','u','d','e',' ','t','h','e',' ','s','t','r','i','n','g','s',':',' ','\"','w','r','a','p','\"',' ','t','o',' ',
'm','a','k','e',' ','t','h','e',' ','s','e','a','r','c','h',' ','w','r','a','p',' ','a','r','o','u','n','d',' ','t','h','e',' ','b','e','g','i','n','n','i','n','g',' ','o','r',' ','e','n','d',' ','o','f',' ','t','h','e',' ','s','t','r','i','n','g',',',' ',
'\"','b','a','c','k','w','a','r','d','\"',' ','o','r',' ','\"','f','o','r','w','a','r','d','\"',' ','t','o',' ','c','h','a','n','g','e',' ','t','h','e',' ','s','e','a','r','c','h',' ','d','i','r','e','c','t','i','o','n',' ','(','\"','f','o','r','w','a','r','d','\"',' ',
'i','s',' ','t','h','e',' ','d','e','f','a','u','l','t',')',',',' ','\"','l','i','t','e','r','a','l','\"',',',' ','\"','c','a','s','e','\"',' ','o','r',' ','\"','r','e','g','e','x','\"',' ','t','o',' ','c','h','a','n','g','e',' ','t','h','e',' ','s','e','a','r','c','h',' ',
't','y','p','e',' ','(','d','e','f','a','u','l','t',' ','i','s',' ','\"','l','i','t','e','r','a','l','\"',')','.',' ',' ','R','e','t','u','r','n','s',' ','t','h','e',' ','s','t','a','r','t','i','n','g',' ','p','o','s','i','t','i','o','n',' ','o','f',' ','t','h','e',' ',
'm','a','t','c','h',',',' ','o','r',' ','-','1',' ','i','f',' ','n','o','t','h','i','n','g',' ','m','a','t','c','h','e','d','.',' ',' ','A','l','s','o',' ','r','e','t','u','r','n','s',' ','t','h','e',' ','e','n','d','i','n','g',' ','p','o','s','i','t','i','o','n',' ',
'o','f',' ','t','h','e',' ','m','a','t','c','h',' ','i','n',' ','$','s','e','a','r','c','h','_','e','n','d','\n',
'\n',
's','e','l','e','c','t','(','s','t','a','r','t',',',' ','e','n','d',')',' ','-','-',' ','S','e','l','e','c','t','s',' ','(','w','i','t','h',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',')',' ','t','e','x','t',' ','i','n',' ',
't','h','e',' ','c','u','r','r','e','n','t',' ','b','u','f','f','e','r',' ','b','e','t','w','e','e','n',' ','a',' ','s','t','a','r','t','i','n','g',' ','a','n','d',' ','e','n','d','i','n','g',' ','p','o','s','i','t','i','o','n','.','\n',
'\n',
's','e','l','e','c','t','_','r','e','c','t','a','n','g','l','e','(','s','t','a','r','t',',',' ','e','n','d',',',' ','l','e','f','t',',',' ','r','i','g','h','t',')',' ','-','-',' ','S','e','l','e','c','t','s',' ','a',' ','r','e','c','t','a','n','g','u','l','a','r',' ',
'a','r','e','a',' ','o','f',' ','t','e','x','t',' ','b','e','t','w','e','e','n',' ','a',' ','s','t','a','r','t','i','n','g',' ','a','n','d',' ','e','n','d','i','n','g',' ','p','o','s','i','t','i','o','n',',',' ','a','n','d',' ','c','o','n','f','i','n','e','d',' ',
'h','o','r','i','z','o','n','t','a','l','l','y',' ','t','o',' ','c','h','a','r','a','c','t','e','r','s',' ','d','i','s','p','l','a','y','e','d',' ','b','e','t','w','e','e','n',' ','p','o','s','i','t','i','o','n','s',' ','\"','l','e','f','t','\"',',',' ','a','n','d',' ',
'\"','r','i','g','h','t','\"','.','\n',
'\n',
's','e','t','_','c','u','r','s','o','r','_','p','o','s','(','p','o','s',')',' ','-','-',' ','S','e','t',' ','t','h','e',' ','c','u','r','s','o','r',' ','p','o','s','i','t','i','o','n',' ','f','o','r',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','w','i','n','d','o','w','.','\n',
'\n',
's','h','e','l','l','_','c','o','m','m','a','n','d','(','c','o','m','m','a','n','d',',',' ','i','n','p','u','t','_','s','t','r','i','n','g',')',' ','-','-',' ','e','x','e','c','u','t','e','s',' ','a',' ','s','h','e','l','l',' ','c','o','m','m','a','n','d',',',' ','f','e','e','d','i','n','g',' ',
'i','t',' ','i','n','p','u','t',' ','f','r','o','m',' ','i','n','p','u','t','_','s','t','r','i','n','g','.',' ',' ','O','n',' ','c','o','m','p','l','e','t','i','o','n',',',' ','o','u','t','p','u','t',' ','f','r','o','m',' ','t','h','e',' ','c','o','m','m','a','n','d',' ',
'i','s',' ','r','e','t','u','r','n','e','d',' ','a','s',' ','t','h','e',' ','f','u','n','c','t','i','o','n',' ','v','a','l','u','e',',',' ','a','n','d',' ','t','h','e',' ','c','o','m','m','a','n','d',''','s',' ','e','x','i','t',' ','s','t','a','t','u','s',' ','i','s',' ',
'r','e','t','u','r','n','e','d',' ','i','n',' ','t','h','e',' ','g','l','o','b','a','l',' ','v','a','r','i','a','b','l','e',' ','$','s','h','e','l','l','_','c','m','d','_','s','t','a','t','u','s','.','\n',
'\n',
's','t','r','i','n','g','_','d','i','a','l','o','g','(','m','e','s','s','a','g','e',',',' ','b','t','n','_','1','_','l','a','b','e','l',',',' ','b','t','n','_','2','_','l','a','b','e','l',',',' ','.','.','.',')',' ','-','-',' ','P','o','p',' ','u','p',' ','a',' ',
'd','i','a','l','o','g',' ','f','o','r',' ','p','r','o','m','p','t','i','n','g',' ','t','h','e',' ','u','s','e','r',' ','t','o',' ','e','n','t','e','r',' ','i','n','f','o','r','m','a','t','i','o','n','.',' ',' ','T','h','e',' ','f','i','r','s','t',' ',
'a','r','g','u','m','e','n','t',' ','i','s',' ','a',' ','s','t','r','i','n','g',' ','t','o',' ','s','h','o','w',' ','i','n',' ','t','h','e',' ','m','e','s','s','a','g','e',' ','a','r','e','a',' ','o','f',' ','t','h','e',' ','d','i','a','l','o','g','.',' ',' ','U','p',' ',
't','o',' ','n','i','n','e',' ','a','d','d','i','t','i','o','n','a','l',' ','o','p','t','i','o','n','a','l',' ','a','r','g','u','m','e','n','t','s',' ','r','e','p','r','e','s','e','n','t',' ','l','a','b','e','l','s',' ','f','o','r',' ','b','u','t','t','o','n','s',' ',
't','o',' ','a','p','p','e','a','r',' ','a','l','o','n','g',' ','t','h','e',' ','b','o','t','t','o','m',' ','o','f',' ','t','h','e',' ','d','i','a','l','o','g','.',' ',' ','R','e','t','u','r','n','s',' ','t','h','e',' ','s','t','r','i','n','g',' ',
'e','n','t','e','r','e','d',' ','b','y',' ','t','h','e',' ','u','s','e','r',' ','a','s',' ','t','h','e',' ','f','u','n','c','t','i','o','n',' ','v','a','l','u','e',',',' ','a','n','d',' ','n','u','m','b','e','r',' ','o','f',' ','t','h','e',' ','b','u','t','t','o','n',' ',
'p','r','e','s','s','e','d',' ','(','t','h','e',' ','f','i','r','s','t',' ','b','u','t','t','o','n',' ','i','s',' ','n','u','m','b','e','r',' ','1',')',',',' ','i','n',' ','$','s','t','r','i','n','g','_','d','i','a','l','o','g','_','b','u','t','t','o','n','.',' ',' ',
'I','f',' ','t','h','e',' ','u','s','e','r',' ','c','l','o','s','e','s',' ','t','h','e',' ','d','i','a','l','o','g',' ','v','i','a',' ','t','h','e',' ','w','i','n','d','o','w',' ','c','l','o','s','e',' ','b','o','x',',',' ','t','h','e',' ','f','u','n','c','t','i','o','n',' ',
'r','e','t','u','r','n','s',' ','t','h','e',' ','e','m','p','t','y',' ','s','t','r','i','n','g',',',' ','a','n','d',' ','$','s','t','r','i','n','g','_','d','i','a','l','o','g','_','b','u','t','t','o','n',' ','r','e','t','u','r','n','s',' ','0','.','\n',
'\n',
's','t','r','i','n','g','_','t','o','_','c','l','i','p','b','o','a','r','d','(','s','t','r','i','n','g',')',' ','-','-',' ','C','o','p','y',' ','t','h','e',' ','c','o','n','t','e','n','t','s',' ','o','f',' ','a',' ','m','a','c','r','o',' ','s','t','r','i','n','g',' ',
't','o',' ','t','h','e',' ','c','l','i','p','b','o','a','r','d','.','\n',
'\n',
's','u','b','s','t','r','i','n','g','(','s','t','r','i','n','g',',',' ','s','t','a','r','t',',',' ','e','n','d',')',' ','-','-',' ','R','e','t','u','r','n','s',' ','t','h','e',' ','p','o','r','t','i','o','n',' ','o','f',' ','a',' ','s','t','r','i','n','g',' ',
'b','e','t','w','e','e','n',' ','a',' ','s','t','a','r','t','i','n','g',' ','a','n','d',' ','e','n','d','i','n','g',' ','p','o','s','i','t','i','o','n','.','\n',
'\n',
't','_','p','r','i','n','t','(','s','t','r','i','n','g','1',',',' ','s','t','r','i','n','g','2',',',' ','.','.','.',')',' ','-','-',' ','W','r','i','t','e','s',' ','s','t','r','i','n','g','s',' ','t','o',' ','t','h','e',' ','t','e','r','m','i','n','a','l',' ',
'(','s','t','d','o','u','t',')',' ','f','r','o','m',' ','w','h','i','c','h',' ','N','E','d','i','t',' ','w','a','s',' ','s','t','a','r','t','e','d','.','\n',
'\n',
't','o','l','o','w','e','r','(','s','t','r','i','n','g',')',' ','-','-',' ','R','e','t','u','r','n',' ','a','n',' ','a','l','l',' ','l','o','w','e','r','-','c','a','s','e',' ','v','e','r','s','i','o','n',' ','o','f',' ','s','t','r','i','n','g','.','\n',
'\n',
't','o','u','p','p','e','r','(','s','t','r','i','n','g',')',' ','-','-',' ','R','e','t','u','r','n',' ','a','n',' ','a','l','l',' ','u','p','p','e','r','-','c','a','s','e',' ','v','e','r','s','i','o','n',' ','o','f',' ','s','t','r','i','n','g','.','\n',
'\n',
'w','r','i','t','e','_','f','i','l','e','(','s','t','r','i','n','g',',',' ','f','i','l','e','n','a','m','e',')',' ','-','-',' ','W','r','i','t','e','s',' ','a',' ','s','t','r','i','n','g',' ','(','p','a','r','a','m','e','t','e','r',' ','1',')',' ','t','o',' ','a',' ',
'f','i','l','e',' ','n','a','m','e','d',' ','i','n',' ','p','a','r','a','m','e','t','e','r',' ','2','.',' ',' ','R','e','t','u','r','n','s',' ','1',' ','o','n',' ','s','u','c','c','e','s','s','f','u','l',' ','w','r','i','t','e',',',' ','o','r',' ','0',' ','i','f',' ',
'u','n','s','u','c','c','e','s','s','f','u','l','.','\0'};

static char AuxString25[] = {'A','l','l',' ','o','f',' ','t','h','e',' ','e','d','i','t','i','n','g',' ','c','a','p','a','b','i','l','i','t','i','e','s',' ','o','f',' ','N','E','d','i','t',' ','a','r','e',' ','r','e','p','r','e','s','e','n','t','e','d',' ','a','s',' ','a',' ','s','p','e','c','i','a','l',' ','t','y','p','e',' ','o','f',' ',
's','u','b','r','o','u','t','i','n','e',',',' ','c','a','l','l','e','d',' ','a','n',' ','a','c','t','i','o','n',' ','r','o','u','t','i','n','e',',',' ','w','h','i','c','h',' ','c','a','n',' ','b','e',' ','i','n','v','o','k','e','d',' ','f','r','o','m',' ','b','o','t','h',' ',
'm','a','c','r','o','s',' ','a','n','d',' ','t','r','a','n','s','l','a','t','i','o','n',' ','t','a','b','l','e',' ','e','n','t','r','i','e','s',' ','(','s','e','e',' ','\"','B','i','n','d','i','n','g',' ','K','e','y','s',' ','t','o',' ','A','c','t','i','o','n','s','\"',' ',
'i','n',' ','t','h','e',' ','X',' ','R','e','s','o','u','r','c','e','s',' ','s','e','c','t','i','o','n',' ','o','f',' ','t','h','e',' ','H','e','l','p',' ','m','e','n','u',')','.','\n',
'\n',
'\n',
'A','c','t','i','o','n','s',' ','R','e','p','r','e','s','e','n','t','i','n','g',' ','M','e','n','u',' ','C','o','m','m','a','n','d','s',':','\n',
'\n',
' ',' ',' ',' ','F','i','l','e',' ','M','e','n','u','	','	',' ',' ',' ',' ',' ',' ','S','e','a','r','c','h',' ','M','e','n','u','\n',
' ',' ',' ',' ','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',' ',' ',' ',' ',' ','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','\n',
' ',' ',' ',' ','n','e','w','(',')','	','	',' ',' ',' ',' ',' ',' ','f','i','n','d','(',')','\n',
' ',' ',' ',' ','o','p','e','n','(',')','	','	',' ',' ',' ',' ',' ',' ','f','i','n','d','_','d','i','a','l','o','g','(',')','\n',
' ',' ',' ',' ','o','p','e','n','_','d','i','a','l','o','g','(',')','	',' ',' ',' ',' ',' ',' ','f','i','n','d','_','a','g','a','i','n','(',')','\n',
' ',' ',' ',' ','o','p','e','n','_','s','e','l','e','c','t','e','d','(',')','	',' ',' ',' ',' ',' ',' ','f','i','n','d','_','s','e','l','e','c','t','i','o','n','(',')','\n',
' ',' ',' ',' ','c','l','o','s','e','(',')','	','	',' ',' ',' ',' ',' ',' ','r','e','p','l','a','c','e','(',')','\n',
' ',' ',' ',' ','s','a','v','e','(',')','	','	',' ',' ',' ',' ',' ',' ','r','e','p','l','a','c','e','_','d','i','a','l','o','g','(',')','\n',
' ',' ',' ',' ','s','a','v','e','_','a','s','(',')','	','	',' ',' ',' ',' ',' ',' ','r','e','p','l','a','c','e','_','a','l','l','(',')','\n',
' ',' ',' ',' ','s','a','v','e','_','a','s','_','d','i','a','l','o','g','(',')','	',' ',' ',' ',' ',' ',' ','r','e','p','l','a','c','e','_','i','n','_','s','e','l','e','c','t','i','o','n','(',')','\n',
' ',' ',' ',' ','r','e','v','e','r','t','_','t','o','_','s','a','v','e','d','(',')','	',' ',' ',' ',' ',' ',' ','r','e','p','l','a','c','e','_','a','g','a','i','n','(',')','\n',
' ',' ',' ',' ','i','n','c','l','u','d','e','_','f','i','l','e','(',')','	',' ',' ',' ',' ',' ',' ','g','o','t','o','_','l','i','n','e','_','n','u','m','b','e','r','(',')','\n',
' ',' ',' ',' ','i','n','c','l','u','d','e','_','f','i','l','e','_','d','i','a','l','o','g',' ','(',')',' ',' ',' ',' ','g','o','t','o','_','l','i','n','e','_','n','u','m','b','e','r','_','d','i','a','l','o','g','(',')','\n',
' ',' ',' ',' ','l','o','a','d','_','t','a','g','s','_','f','i','l','e','(',')','	',' ',' ',' ',' ',' ',' ','g','o','t','o','_','s','e','l','e','c','t','e','d','(',')','\n',
' ',' ',' ',' ','l','o','a','d','_','t','a','g','s','_','f','i','l','e','_','d','i','a','l','o','g','(',')',' ',' ',' ','m','a','r','k','(',')','\n',
' ',' ',' ',' ','l','o','a','d','_','m','a','c','r','o','_','f','i','l','e','(',')',' ',' ',' ',' ',' ',' ',' ',' ',' ','m','a','r','k','_','d','i','a','l','o','g','(',')','\n',
' ',' ',' ',' ','l','o','a','d','_','m','a','c','r','o','_','f','i','l','e','_','d','i','a','l','o','g','(',')',' ',' ','g','o','t','o','_','m','a','r','k','(',')','\n',
' ',' ',' ',' ','p','r','i','n','t','(',')','	','	',' ',' ',' ',' ',' ',' ','g','o','t','o','_','m','a','r','k','_','d','i','a','l','o','g','(',')','\n',
' ',' ',' ',' ','p','r','i','n','t','_','s','e','l','e','c','t','i','o','n','(',')','	',' ',' ',' ',' ',' ',' ','m','a','t','c','h','(',')','\n',
' ',' ',' ',' ','e','x','i','t','(',')','	',' ',' ',' ',' ',' ','	',' ',' ',' ',' ',' ',' ','f','i','n','d','_','d','e','f','i','n','i','t','i','o','n','(',')','\n',
' ',' ',' ',' ','	','	','	',' ',' ',' ',' ',' ',' ','s','p','l','i','t','_','w','i','n','d','o','w','(',')','\n',
' ',' ',' ',' ','	','	','	',' ',' ',' ',' ',' ',' ','c','l','o','s','e','_','p','a','n','e','(',')','\n',
' ',' ',' ',' ','E','d','i','t',' ','M','e','n','u','	','	',' ',' ',' ',' ',' ',' ','\n',
' ',' ',' ',' ','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-',' ',' ',' ',' ',' ','S','h','e','l','l',' ','M','e','n','u','\n',
' ',' ',' ',' ','u','n','d','o','(',')','	','	',' ',' ',' ',' ',' ',' ','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','\n',
' ',' ',' ',' ','r','e','d','o','(',')','	','	',' ',' ',' ',' ',' ',' ','f','i','l','t','e','r','_','s','e','l','e','c','t','i','o','n','_','d','i','a','l','o','g','(',')','\n',
' ',' ',' ',' ','d','e','l','e','t','e','(',')','	','	',' ',' ',' ',' ',' ',' ','f','i','l','t','e','r','_','s','e','l','e','c','t','i','o','n','(',')','\n',
' ',' ',' ',' ','s','e','l','e','c','t','_','a','l','l','(',')','	',' ',' ',' ',' ',' ',' ','e','x','e','c','u','t','e','_','c','o','m','m','a','n','d','(',')','\n',
' ',' ',' ',' ','s','h','i','f','t','_','l','e','f','t','(',')','	',' ',' ',' ',' ',' ',' ','e','x','e','c','u','t','e','_','c','o','m','m','a','n','d','_','d','i','a','l','o','g','(',')','\n',
' ',' ',' ',' ','s','h','i','f','t','_','l','e','f','t','_','b','y','_','t','a','b','(',')',' ',' ',' ',' ',' ',' ',' ','e','x','e','c','u','t','e','_','c','o','m','m','a','n','d','_','l','i','n','e','(',')','\n',
' ',' ',' ',' ','s','h','i','f','t','_','r','i','g','h','t','(',')','	',' ',' ',' ',' ',' ',' ','s','h','e','l','l','_','m','e','n','u','_','c','o','m','m','a','n','d','(',')','\n',
' ',' ',' ',' ','s','h','i','f','t','_','r','i','g','h','t','_','b','y','_','t','a','b','(',')',' ',' ',' ',' ',' ',' ','\n',
' ',' ',' ',' ','u','p','p','e','r','c','a','s','e','(',')',' ','	',' ',' ',' ',' ',' ',' ','M','a','c','r','o',' ','M','e','n','u','\n',
' ',' ',' ',' ','l','o','w','e','r','c','a','s','e','(',')',' ','	',' ',' ',' ',' ',' ',' ','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','-','\n',
' ',' ',' ',' ','f','i','l','l','_','p','a','r','a','g','r','a','p','h','(',')','	',' ',' ',' ',' ',' ',' ','m','a','c','r','o','_','m','e','n','u','_','c','o','m','m','a','n','d','(',')','\n',
' ',' ',' ',' ','c','o','n','t','r','o','l','_','c','o','d','e','_','d','i','a','l','o','g','(',')',' ',' ',' ',' ',' ','r','e','p','e','a','t','_','m','a','c','r','o','(',')','\n',
' ',' ',' ',' ','	','	','	',' ',' ',' ',' ',' ',' ','r','e','p','e','a','t','_','d','i','a','l','o','g','(',')','\n',
'\n',
'T','h','e',' ','a','c','t','i','o','n','s',' ','r','e','p','r','e','s','e','n','t','i','n','g',' ','m','e','n','u',' ','c','o','m','m','a','n','d','s',' ','a','r','e',' ','n','a','m','e','d',' ','t','h','e',' ','s','a','m','e',' ','a','s',' ','t','h','e',' ','m','e','n','u',' ','i','t','e','m',' ',
'w','i','t','h',' ','p','u','n','c','t','u','a','t','i','o','n',' ','r','e','m','o','v','e','d',',',' ','a','l','l',' ','l','o','w','e','r',' ','c','a','s','e',',',' ','a','n','d',' ','u','n','d','e','r','s','c','o','r','e','s',' ',
'r','e','p','l','a','c','i','n','g',' ','s','p','a','c','e','s','.',' ',' ','W','i','t','h','o','u','t',' ','t','h','e',' ',
'_','d','i','a','l','o','g',' ','s','u','f','f','i','x',',',' ','c','o','m','m','a','n','d','s',' ','w','h','i','c','h',' ','n','o','r','m','a','l','l','y',' ','p','r','o','m','p','t',' ','t','h','e',' ','u','s','e','r',' ','f','o','r',' ','i','n','f','o','r','m','a','t','i','o','n',',',' ',
'i','n','s','t','e','a','d',' ','t','a','k','e',' ','t','h','e',' ','i','n','f','o','r','m','a','t','i','o','n',' ','f','r','o','m',' ','t','h','e',' ','r','o','u','t','i','n','e',''','s',' ','a','r','g','u','m','e','n','t','s',' ','(','s','e','e',' ','b','e','l','o','w',')','.',' ',' ','T','o',' ',
'p','r','e','s','e','n','t',' ','a',' ','d','i','a','l','o','g',' ','a','n','d',' ','a','s','k',' ','t','h','e',' ','u','s','e','r',' ','f','o','r',' ','i','n','p','u','t',',',' ','r','a','t','h','e','r',' ','t','h','a','n',' ','s','u','p','p','l','y','i','n','g',' ','i','t',' ','i','n',' ','v','i','a',' ',
'a','r','g','u','m','e','n','t','s',',',' ','u','s','e',' ','t','h','e',' ','a','c','t','i','o','n','s',' ','w','i','t','h',' ','t','h','e',' ','_','d','i','a','l','o','g',' ','s','u','f','f','i','x','.','\n',
'\n',
'M','e','n','u',' ','A','c','t','i','o','n',' ','R','o','u','t','i','n','e',' ','A','r','g','u','m','e','n','t','s',':','\n',
'\n',
'A','r','g','u','m','e','n','t','s',' ','a','r','e',' ','t','e','x','t',' ','s','t','r','i','n','g','s',' ','e','n','c','l','o','s','e','d',' ','i','n',' ','q','u','o','t','e','s','.',' ',' ','B','e','l','o','w',' ','a','r','e',' ','t','h','e',' ','m','e','n','u',' ','a','c','t','i','o','n',' ',
'r','o','u','t','i','n','e','s',' ','w','h','i','c','h',' ','t','a','k','e',' ','a','r','g','u','m','e','n','t','s','.',' ',' ','O','p','t','i','o','n','a','l',' ','a','r','g','u','m','e','n','t','s',' ','a','r','e',' ','i','n','c','l','o','s','e','d',' ','i','n',' ','[',']','.','\n',
'\n',
' ',' ','o','p','e','n','(','f','i','l','e','n','a','m','e',')','\n',
'\n',
' ',' ','s','a','v','e','_','a','s','(','f','i','l','e','n','a','m','e',')','\n',
'\n',
' ',' ','i','n','c','l','u','d','e','(','f','i','l','e','n','a','m','e',')','\n',
'\n',
' ',' ','l','o','a','d','_','t','a','g','s','_','f','i','l','e','(','f','i','l','e','n','a','m','e',')','\n',
'\n',
' ',' ','f','i','n','d','_','d','i','a','l','o','g','(','[','s','e','a','r','c','h','_','d','i','r','e','c','t','i','o','n',']',')','\n',
'\n',
' ',' ','f','i','n','d','(','s','e','a','r','c','h','_','s','t','r','i','n','g',' ','[',',',' ','s','e','a','r','c','h','-','d','i','r','e','c','t','i','o','n',']',',',' ','[','s','e','a','r','c','h','-','t','y','p','e',']',')','\n',
'\n',
' ',' ','f','i','n','d','_','a','g','a','i','n','(','[','s','e','a','r','c','h','-','d','i','r','e','c','t','i','o','n',']',')','\n',
'\n',
' ',' ','f','i','n','d','_','s','e','l','e','c','t','i','o','n','(','[','s','e','a','r','c','h','-','d','i','r','e','c','t','i','o','n',']',')','\n',
'\n',
' ',' ','r','e','p','l','a','c','e','_','d','i','a','l','o','g','(','[','s','e','a','r','c','h','-','d','i','r','e','c','t','i','o','n',']',')','\n',
'\n',
' ',' ','r','e','p','l','a','c','e','(','s','e','a','r','c','h','-','s','t','r','i','n','g',',',' ','r','e','p','l','a','c','e','-','s','t','r','i','n','g',',','\n',
'	',' ',' ','[',',',' ','s','e','a','r','c','h','-','d','i','r','e','c','t','i','o','n',']',' ','[',',',' ','s','e','a','r','c','h','-','t','y','p','e',']',')','\n',
'\n',
' ',' ','r','e','p','l','a','c','e','_','i','n','_','s','e','l','e','c','t','i','o','n','(','s','e','a','r','c','h','-','s','t','r','i','n','g',',',' ','r','e','p','l','a','c','e','-','s','t','r','i','n','g','\n',
'	',' ',' ','[',',',' ','s','e','a','r','c','h','-','t','y','p','e',']',')','\n',
'\n',
' ',' ','r','e','p','l','a','c','e','_','a','g','a','i','n','(','[','s','e','a','r','c','h','-','d','i','r','e','c','t','i','o','n',']',')','\n',
'\n',
' ',' ','g','o','t','o','_','l','i','n','e','_','n','u','m','b','e','r','(','[','l','i','n','e','-','n','u','m','b','e','r',']',')','\n',
'\n',
' ',' ','m','a','r','k','(','m','a','r','k','-','l','e','t','t','e','r',')','\n',
'\n',
' ',' ','g','o','t','o','_','m','a','r','k','(','m','a','r','k','-','l','e','t','t','e','r',')','\n',
'\n',
' ',' ','f','i','l','t','e','r','_','s','e','l','e','c','t','i','o','n','(','s','h','e','l','l','-','c','o','m','m','a','n','d',')','\n',
'\n',
' ',' ','e','x','e','c','u','t','e','_','c','o','m','m','a','n','d','(','s','h','e','l','l','-','c','o','m','m','a','n','d',')','\n',
'\n',
' ',' ','s','h','e','l','l','_','m','e','n','u','_','c','o','m','m','a','n','d','(','s','h','e','l','l','-','m','e','n','u','-','i','t','e','m','-','n','a','m','e',')','\n',
'\n',
' ',' ','m','a','c','r','o','_','m','e','n','u','_','c','o','m','m','a','n','d','(','m','a','c','r','o','-','m','e','n','u','-','i','t','e','m','-','n','a','m','e',')','\n',
'\n',
'S','o','m','e',' ','n','o','t','e','s',' ','o','n',' ','a','r','g','u','m','e','n','t',' ','t','y','p','e','s',' ','a','b','o','v','e',':','\n',
'\n',
' ',' ','f','i','l','e','n','a','m','e','	',' ',' ',' ',' ','P','a','t','h',' ','n','a','m','e','s',' ','a','r','e',' ','i','n','t','e','r','p','r','e','t','e','d',' ','r','e','l','a','t','i','v','e','\n',
' ','	','	',' ',' ',' ',' ','t','o',' ','t','h','e',' ','d','i','r','e','c','t','o','r','y',' ','f','r','o','m',' ','w','h','i','c','h',' ','N','E','d','i','t',' ','w','a','s','\n',
' ','	','	',' ',' ',' ',' ','s','t','a','r','t','e','d',',',' ','w','i','l','d','c','a','r','d','s',' ','a','n','d',' ','~',' ','a','r','e',' ','n','o','t','\n',
' ','	','	',' ',' ',' ',' ','e','x','p','a','n','d','e','d','.','\n',
' ','	','	',' ',' ',' ',' ','\n',
' ',' ','s','e','a','r','c','h','-','d','i','r','e','c','t','i','o','n',' ',' ','E','i','t','h','e','r',' ','\"','f','o','r','w','a','r','d','\"',' ','o','r',' ','\"','b','a','c','k','w','a','r','d','\"','\n',
'\n',
' ',' ','s','e','a','r','c','h','-','t','y','p','e','	',' ',' ',' ',' ','E','i','t','h','e','r',' ','\"','l','i','t','e','r','a','l','\"',',',' ','\"','c','a','s','e','\"',',',' ','o','r',' ','\"','r','e','g','e','x','\"','\n',
'\n',
' ',' ','m','a','r','k','-','l','e','t','t','e','r','	',' ',' ',' ',' ','T','h','e',' ','m','a','r','k',' ','c','o','m','m','a','n','d',' ','l','i','m','i','t','s',' ','u','s','e','r','s',' ','t','o','\n',
' ','	','	',' ',' ',' ',' ','s','i','n','g','l','e',' ','l','e','t','t','e','r','s','.',' ',' ','I','n','s','i','d','e',' ','o','f',' ','m','a','c','r','o','s',',','\n',
' ','	','	',' ',' ',' ',' ','n','u','m','e','r','i','c',' ','m','a','r','k','s',' ','a','r','e',' ','a','l','l','o','w','e','d',',',' ','w','h','i','c','h',' ','w','o','n',''','t','\n',
' ','	','	',' ',' ',' ',' ','i','n','t','e','r','f','e','r','e',' ','w','i','t','h',' ','m','a','r','k','s',' ','s','e','t',' ','b','y',' ','t','h','e',' ','u','s','e','r','.','\n',
'\n',
' ',' ','(','m','a','c','r','o',' ','o','r',' ','s','h','e','l','l',')',' ',' ','N','a','m','e',' ','o','f',' ','t','h','e',' ','c','o','m','m','a','n','d',' ','e','x','a','c','t','l','y',' ','a','s','\n',
' ',' ','-','m','e','n','u','-','i','t','e','m','-','n','a','m','e',' ',' ',' ','s','p','e','c','i','f','i','e','d',' ','i','n',' ','t','h','e',' ','S','h','e','l','l',' ','M','e','n','u',' ','o','r','\n',
' ','	','	',' ',' ',' ',' ','M','a','c','r','o',' ','M','e','n','u',' ','d','i','a','l','o','g','s','\n',
'\n',
'\n',
'K','e','y','b','o','a','r','d','-','O','n','l','y',' ','A','c','t','i','o','n','s','\n',
'\n',
'b','a','c','k','w','a','r','d','_','c','h','a','r','a','c','t','e','r','(',')','\n',
'M','o','v','e','s',' ','t','h','e',' ','c','u','r','s','o','r',' ','o','n','e',' ','c','h','a','r','a','c','t','e','r',' ','t','o',' ','t','h','e',' ','l','e','f','t','.','\n',
'\n',
'b','a','c','k','w','a','r','d','_','p','a','r','a','g','r','a','p','h','(',')','\n',
'M','o','v','e','s',' ','t','h','e',' ','c','u','r','s','o','r',' ','t','o',' ','t','h','e',' ','b','e','g','i','n','n','i','n','g',' ','o','f',' ','t','h','e',' ','p','a','r','a','g','r','a','p','h',',',' ','o','r',' ','i','f',' ','t','h','e',' ',
'c','u','r','s','o','r',' ','i','s',' ','a','l','r','e','a','d','y',' ','a','t',' ','t','h','e',' ','b','e','g','i','n','n','i','n','g',' ','o','f',' ','a',' ','p','a','r','a','g','r','a','p','h',',',' ','m','o','v','e','s',' ','t','h','e',' ','c','u','r','s','o','r',' ',
't','o',' ','t','h','e',' ','b','e','g','i','n','n','i','n','g',' ','o','f',' ','t','h','e',' ','p','r','e','v','i','o','u','s',' ','p','a','r','a','g','r','a','p','h','.',' ',' ','P','a','r','a','g','r','a','p','h','s',' ','a','r','e',' ',
'd','e','f','i','n','e','d',' ','a','s',' ','r','e','g','i','o','n','s',' ','o','f',' ','t','e','x','t',' ','d','e','l','i','m','i','t','e','d',' ','b','y',' ','o','n','e',' ','o','r',' ','m','o','r','e',' ','b','l','a','n','k',' ','l','i','n','e','s','.','\n',
'\n',
'b','a','c','k','w','a','r','d','_','w','o','r','d','(',')','\n',
'M','o','v','e','s',' ','t','h','e',' ','c','u','r','s','o','r',' ','t','o',' ','t','h','e',' ','b','e','g','i','n','n','i','n','g',' ','o','f',' ','a',' ','w','o','r','d',',',' ','o','r',',',' ','i','f',' ','t','h','e',' ',
'c','u','r','s','o','r',' ','i','s',' ','a','l','r','e','a','d','y',' ','a','t',' ','t','h','e',' ','b','e','g','i','n','n','i','n','g',' ','o','f',' ','a',' ','w','o','r','d',',',' ','m','o','v','e','s',' ','t','h','e',' ',
'c','u','r','s','o','r',' ','t','o',' ','t','h','e',' ','b','e','g','i','n','n','i','n','g',' ','o','f',' ','t','h','e',' ','p','r','e','v','i','o','u','s',' ','w','o','r','d','.',' ',' ','W','o','r','d',' ','d','e','l','i','m','i','t','e','r','s',' ',
'a','r','e',' ','u','s','e','r','-','s','e','t','t','a','b','l','e',',',' ','a','n','d',' ','d','e','f','i','n','e','d',' ','b','y',' ','t','h','e',' ','X',' ','r','e','s','o','u','r','c','e',' ','w','o','r','d','D','e','l','i','m','i','t','e','r','s','.','\n',
'\n',
'b','e','g','i','n','n','i','n','g','_','o','f','_','f','i','l','e','(',')','\n',
'M','o','v','e','s',' ','t','h','e',' ','c','u','r','s','o','r',' ','t','o',' ','t','h','e',' ','b','e','g','i','n','n','i','n','g',' ','o','f',' ','t','h','e',' ','f','i','l','e','.','\n',
'\n',
'b','e','g','i','n','n','i','n','g','_','o','f','_','l','i','n','e','(',')','\n',
'M','o','v','e','s',' ','t','h','e',' ','c','u','r','s','o','r',' ','t','o',' ','t','h','e',' ','b','e','g','i','n','n','i','n','g',' ','o','f',' ','t','h','e',' ','l','i','n','e','.','\n',
'\n',
'b','e','g','i','n','n','i','n','g','_','o','f','_','s','e','l','e','c','t','i','o','n','(',')','\n',
'M','o','v','e','s',' ','t','h','e',' ','c','u','r','s','o','r',' ','t','o',' ','t','h','e',' ','b','e','g','i','n','n','i','n','g',' ','o','f',' ','t','h','e',' ','s','e','l','e','c','t','i','o','n',' ',
'w','i','t','h','o','u','t',' ','d','i','s','t','u','r','b','i','n','g',' ','t','h','e',' ','s','e','l','e','c','t','i','o','n','.','\n',
'\n',
'c','o','p','y','_','c','l','i','p','b','o','a','r','d','(',')','\n',
'C','o','p','i','e','s',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','s','e','l','e','c','t','i','o','n',' ','t','o',' ','t','h','e',' ','c','l','i','p','b','o','a','r','d','.','\n',
'\n',
'c','o','p','y','_','p','r','i','m','a','r','y','(',')','\n',
'C','o','p','i','e','s',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','t','o',' ','t','h','e',' ','c','u','r','s','o','r','.','\n',
'\n',
'c','o','p','y','_','t','o','(',')','\n',
'I','f',' ','a',' ','s','e','c','o','n','d','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','e','x','i','s','t','s',',',' ','c','o','p','i','e','s',' ','t','h','e',' ','s','e','c','o','n','d','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','t','o',' ','t','h','e',' ',
'c','u','r','s','o','r','.',' ',' ','I','f',' ','n','o',' ','s','e','c','o','n','d','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','e','x','i','s','t','s',',',' ','c','o','p','i','e','s',' ','t','h','e',' ','p','r','i','m','a','r','y',' ',
's','e','l','e','c','t','i','o','n',' ','t','o',' ','t','h','e',' ',
'p','o','i','n','t','e','r',' ','l','o','c','a','t','i','o','n','.','\n',
'\n',
'c','o','p','y','_','t','o','_','o','r','_','e','n','d','_','d','r','a','g','(',')','\n',
'C','o','m','p','l','e','t','e','s',' ','e','i','t','h','e','r',' ','a',' ','s','e','c','o','n','d','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','o','p','e','r','a','t','i','o','n',',',' ','o','r',' ','a',' ','p','r','i','m','a','r','y',' ',
'd','r','a','g','.',' ',' ','I','f',' ','t','h','e',' ','u','s','e','r',' ','i','s',' ','d','r','a','g','g','i','n','g',' ','t','h','e',' ','m','o','u','s','e',' ','t','o',' ','a','d','j','u','s','t',' ','a',' ','s','e','c','o','n','d','a','r','y',' ','s','e','l','e','c','t','i','o','n',',',' ',
't','h','e',' ','s','e','l','e','c','t','i','o','n',' ','i','s',' ','c','o','p','i','e','d',' ','a','n','d',' ','e','i','t','h','e','r',' ','i','n','s','e','r','t','e','d',' ','a','t',' ','t','h','e',' ','c','u','r','s','o','r',' ','l','o','c','a','t','i','o','n',',',' ',
'o','r',',',' ','i','f',' ','p','e','n','d','i','n','g','-','d','e','l','e','t','e',' ','i','s',' ','o','n',' ','a','n','d',' ','a',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','e','x','i','s','t','s',' ','i','n',' ','t','h','e',' ','w','i','n','d','o','w',',',' ',
'r','e','p','l','a','c','e','s',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n','.',' ',' ','I','f',' ','t','h','e',' ','u','s','e','r',' ','i','s',' ','d','r','a','g','g','i','n','g',' ','a',' ','b','l','o','c','k',' ','o','f',' ',
't','e','x','t',' ','(','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',')',',',' ','c','o','m','p','l','e','t','e','s',' ','t','h','e',' ','d','r','a','g',' ','o','p','e','r','a','t','i','o','n',' ','a','n','d',' ','l','e','a','v','e','s',' ','t','h','e',' ',
't','e','x','t',' ','a','t',' ','i','t',''','s',' ','c','u','r','r','e','n','t',' ','l','o','c','a','t','i','o','n','.','\n',
'\n',
'c','u','t','_','c','l','i','p','b','o','a','r','d','(',')','\n',
'D','e','l','e','t','e','s',' ','t','h','e',' ','t','e','x','t',' ','i','n',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','a','n','d',' ','p','l','a','c','e','s',' ','i','t',' ','i','n',' ','t','h','e',' ','c','l','i','p','b','o','a','r','d','.','\n',
'\n',
'c','u','t','_','p','r','i','m','a','r','y','(',')','\n',
'C','o','p','i','e','s',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','t','o',' ','t','h','e',' ','c','u','r','s','o','r',' ','a','n','d',' ','d','e','l','e','t','e','s',' ','i','t',' ',
'a','t',' ','i','t','s',' ','o','r','i','g','i','n','a','l',' ','l','o','c','a','t','i','o','n','.','\n',
'\n',
'd','e','l','e','t','e','_','s','e','l','e','c','t','i','o','n','(',')','\n',
'D','e','l','e','t','e','s',' ','t','h','e',' ','c','o','n','t','e','n','t','s',' ','o','f',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n','.','\n',
'\n',
'd','e','l','e','t','e','_','n','e','x','t','_','c','h','a','r','a','c','t','e','r','(',')','\n',
'I','f',' ','a',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','e','x','i','s','t','s',',',' ','d','e','l','e','t','e','s',' ','i','t','s',' ','c','o','n','t','e','n','t','s','.',' ',' ','O','t','h','e','r','w','i','s','e',',',' ',
'd','e','l','e','t','e','s',' ','t','h','e',' ','c','h','a','r','a','c','t','e','r',' ','f','o','l','l','o','w','i','n','g',' ','t','h','e',' ','c','u','r','s','o','r','.','\n',
'\n',
'd','e','l','e','t','e','_','p','r','e','v','i','o','u','s','_','c','h','a','r','a','c','t','e','r','(',')','\n',
'I','f',' ','a',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','e','x','i','s','t','s',',',' ','d','e','l','e','t','e','s',' ','i','t','s',' ','c','o','n','t','e','n','t','s','.',' ',' ','O','t','h','e','r','w','i','s','e',',',' ',
'd','e','l','e','t','e','s',' ','t','h','e',' ','c','h','a','r','a','c','t','e','r',' ','b','e','f','o','r','e',' ','t','h','e',' ','c','u','r','s','o','r','.','\n',
'\n',
'd','e','l','e','t','e','_','n','e','x','t','_','w','o','r','d','(',')','\n',
'I','f',' ','a',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','e','x','i','s','t','s',',',' ','d','e','l','e','t','e','s',' ','i','t','s',' ','c','o','n','t','e','n','t','s','.',' ',' ','O','t','h','e','r','w','i','s','e',',',' ',
'd','e','l','e','t','e','s',' ','t','h','e',' ','w','o','r','d',' ','f','o','l','l','o','w','i','n','g',' ','t','h','e',' ','c','u','r','s','o','r','.','\n',
'\n',
'd','e','l','e','t','e','_','p','r','e','v','i','o','u','s','_','w','o','r','d','(',')','\n',
'I','f',' ','a',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','e','x','i','s','t','s',',',' ','d','e','l','e','t','e','s',' ','i','t','s',' ','c','o','n','t','e','n','t','s','.',' ',' ','O','t','h','e','r','w','i','s','e',',',' ',
'd','e','l','e','t','e','s',' ','t','h','e',' ','w','o','r','d',' ','b','e','f','o','r','e',' ','t','h','e',' ','c','u','r','s','o','r','.','\n',
'\n',
'd','e','l','e','t','e','_','t','o','_','s','t','a','r','t','_','o','f','_','l','i','n','e','(',')','\n',
'I','f',' ','a',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','e','x','i','s','t','s',',',' ','d','e','l','e','t','e','s',' ','i','t','s',' ','c','o','n','t','e','n','t','s','.',' ',' ','O','t','h','e','r','w','i','s','e',',',' ',
'd','e','l','e','t','e','s',' ','t','h','e',' ','c','h','a','r','a','c','t','e','r','s',' ','b','e','t','w','e','e','n',' ','t','h','e',' ','c','u','r','s','o','r',' ',
'a','n','d',' ','t','h','e',' ','s','t','a','r','t',' ','o','f',' ','t','h','e',' ','l','i','n','e','.','\n',
'\n',
'd','e','l','e','t','e','_','t','o','_','e','n','d','_','o','f','_','l','i','n','e','(',')','\n',
'I','f',' ','a',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','e','x','i','s','t','s',',',' ','d','e','l','e','t','e','s',' ','i','t','s',' ','c','o','n','t','e','n','t','s','.',' ',' ','O','t','h','e','r','w','i','s','e',',',' ',
'd','e','l','e','t','e','s',' ','t','h','e',' ','c','h','a','r','a','c','t','e','r','s',' ','b','e','t','w','e','e','n',' ','t','h','e',' ','c','u','r','s','o','r',' ',
'a','n','d',' ','t','h','e',' ','e','n','d',' ','o','f',' ','t','h','e',' ','l','i','n','e','.','\n',
'\n',
'd','e','s','e','l','e','c','t','_','a','l','l','(',')','\n',
'D','e','-','s','e','l','e','c','t','s',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n','.','\n',
'\n',
'e','n','d','_','o','f','_','f','i','l','e','(',')','\n',
'M','o','v','e','s',' ','t','h','e',' ','c','u','r','s','o','r',' ','t','o',' ','t','h','e',' ','e','n','d',' ','o','f',' ','t','h','e',' ','f','i','l','e','.','\n',
'\n',
'e','n','d','_','o','f','_','l','i','n','e','(',')','\n',
'M','o','v','e','s',' ','t','h','e',' ','c','u','r','s','o','r',' ','t','o',' ','t','h','e',' ','e','n','d',' ','o','f',' ','t','h','e',' ','l','i','n','e','.','\n',
'\n',
'e','n','d','_','o','f','_','s','e','l','e','c','t','i','o','n','(',')','\n',
'M','o','v','e','s',' ','t','h','e',' ','c','u','r','s','o','r',' ','t','o',' ','t','h','e',' ','e','n','d',' ','o','f',' ','t','h','e',' ','s','e','l','e','c','t','i','o','n',' ',
'w','i','t','h','o','u','t',' ','d','i','s','t','u','r','b','i','n','g',' ','t','h','e',' ','s','e','l','e','c','t','i','o','n','.','\n',
'\n',
'e','x','c','h','a','n','g','e','(',')','\n',
'E','x','c','h','a','n','g','e',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','a','n','d',' ','s','e','c','o','n','d','a','r','y',' ','s','e','l','e','c','t','i','o','n','s','.','\n',
'\n',
'e','x','t','e','n','d','_','a','d','j','u','s','t','(',')','\n',
'A','t','t','a','c','h','e','d',' ','m','o','u','s','e','-','m','o','v','e','m','e','n','t',' ','e','v','e','n','t','s',' ','t','o',' ','b','e','g','i','n',' ','a',' ','s','e','l','e','c','t','i','o','n',' ','b','e','t','w','e','e','n',' ','t','h','e',' ',
'c','u','r','s','o','r',' ','a','n','d',' ','t','h','e',' ','m','o','u','s','e',',',' ','o','r',' ','e','x','t','e','n','d',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','t','o',' ','t','h','e',' ',
'm','o','u','s','e',' ','p','o','s','i','t','i','o','n','.','\n',
'\n',
'e','x','t','e','n','d','_','e','n','d','(',')','\n',
'C','o','m','p','l','e','t','e','s',' ','a',' ','p','r','i','m','a','r','y',' ','d','r','a','g','-','s','e','l','e','c','t','i','o','n',' ','o','p','e','r','a','t','i','o','n','.','\n',
'\n',
'e','x','t','e','n','d','_','s','t','a','r','t','(',')','\n',
'B','e','g','i','n','s',' ','a',' ','s','e','l','e','c','t','i','o','n',' ','b','e','t','w','e','e','n',' ','t','h','e',' ',
'c','u','r','s','o','r',' ','a','n','d',' ','t','h','e',' ','m','o','u','s','e','.',' ',' ','A',' ','d','r','a','g','-','s','e','l','e','c','t','i','o','n',' ','o','p','e','r','a','t','i','o','n',' ','c','a','n',' ','b','e',' ','s','t','a','r','t','e','d',' ','w','i','t','h',' ',
'e','i','t','h','e','r',' ','e','x','t','e','n','d','_','s','t','a','r','t',' ','o','r',' ','g','r','a','b','_','f','o','c','u','s','.','\n',
'\n',
'f','o','r','w','a','r','d','_','c','h','a','r','a','c','t','e','r','(',')','\n',
'M','o','v','e','s',' ','t','h','e',' ','c','u','r','s','o','r',' ','o','n','e',' ','c','h','a','r','a','c','t','e','r',' ','t','o',' ','t','h','e',' ','r','i','g','h','t','.','\n',
'\n',
'f','o','r','w','a','r','d','_','p','a','r','a','g','r','a','p','h','(',')','\n',
'M','o','v','e','s',' ','t','h','e',' ','c','u','r','s','o','r',' ','t','o',' ','t','h','e',' ','b','e','g','i','n','n','i','n','g',' ','o','f',' ','t','h','e',' ','n','e','x','t',' ','p','a','r','a','g','r','a','p','h','.',' ',' ','P','a','r','a','g','r','a','p','h','s',' ','a','r','e',' ',
'd','e','f','i','n','e','d',' ','a','s',' ','r','e','g','i','o','n','s',' ','o','f',' ','t','e','x','t',' ','d','e','l','i','m','i','t','e','d',' ','b','y',' ','o','n','e',' ','o','r',' ','m','o','r','e',' ','b','l','a','n','k',' ','l','i','n','e','s','.','\n',
'\n',
'f','o','r','w','a','r','d','_','w','o','r','d','(',')','\n',
'M','o','v','e','s',' ','t','h','e',' ','c','u','r','s','o','r',' ','t','o',' ','t','h','e',' ','b','e','g','i','n','n','i','n','g',' ','o','f',' ','t','h','e',' ','n','e','x','t',' ','w','o','r','d','.',' ',' ','W','o','r','d',' ','d','e','l','i','m','i','t','e','r','s',' ',
'a','r','e',' ','u','s','e','r','-','s','e','t','t','a','b','l','e',',',' ','a','n','d',' ','d','e','f','i','n','e','d',' ','b','y',' ','t','h','e',' ','X',' ','r','e','s','o','u','r','c','e',' ','w','o','r','d','D','e','l','i','m','i','t','e','r','s','.','\n',
'\n',
'g','r','a','b','_','f','o','c','u','s','(',')','\n',
'M','o','v','e','s',' ','t','h','e',' ','c','u','r','s','o','r',' ','t','o',' ','t','h','e',' ','m','o','u','s','e',' ','p','o','i','n','t','e','r',' ','l','o','c','a','t','i','o','n',',',' ','a','n','d',' ','p','r','e','p','a','r','e','s',' ','f','o','r',' ',
'a',' ','p','o','s','s','i','b','l','e',' ','d','r','a','g','-','s','e','l','e','c','t','i','o','n',' ','o','p','e','r','a','t','i','o','n',' ','(','b','o','u','n','d',' ','t','o',' ','e','x','t','e','n','d','_','a','d','j','u','s','t',')',',',' ','o','r',' ',
'm','u','l','t','i','-','c','l','i','c','k',' ','o','p','e','r','a','t','i','o','n',' ','(','a',' ','f','u','r','t','h','e','r',' ','g','r','a','b','_','f','o','c','u','s',' ','a','c','t','i','o','n',')','.',' ',' ','I','f',' ','a',' ','s','e','c','o','n','d',' ',
'i','n','v','o','c','a','t','i','o','n',' ','o','f',' ','g','r','a','b',' ','f','o','c','u','s',' ','f','o','l','l','o','w','s',' ','i','m','m','e','d','i','a','t','e','l','y',',',' ','i','t',' ','s','e','l','e','c','t','s',' ','a',' ','w','h','o','l','e',' ','w','o','r','d',',',' ',
'o','r',' ','a',' ','t','h','i','r','d',',',' ','a',' ','w','h','o','l','e',' ','l','i','n','e','.','\n',
'\n',
'i','n','s','e','r','t','_','s','t','r','i','n','g','(','\"','s','t','r','i','n','g','\"',')',' ','\n',
'I','f',' ','p','e','n','d','i','n','g',' ','d','e','l','e','t','e',' ','i','s',' ','o','n',' ','a','n','d',' ','t','h','e',' ','c','u','r','s','o','r',' ','i','s',' ','i','n','s','i','d','e',' ','t','h','e',' ','s','e','l','e','c','t','i','o','n',',',' ','r','e','p','l','a','c','e','s',' ',
't','h','e',' ','s','e','l','e','c','t','i','o','n',' ','w','i','t','h',' ','\"','s','t','r','i','n','g','\"','.',' ',' ','O','t','h','e','r','w','i','s','e',',',' ','i','n','s','e','r','t','s',' ','\"','s','t','r','i','n','g','\"',' ','a','t',' ','t','h','e',' ',
'c','u','r','s','o','r',' ','l','o','c','a','t','i','o','n','.','\n',
'\n',
'k','e','y','_','s','e','l','e','c','t','(','\"','d','i','r','e','c','t','i','o','n','\"',')','\n',
'M','o','v','e','s',' ','t','h','e',' ','c','u','r','s','o','r',' ','o','n','e',' ','c','h','a','r','a','c','t','e','r',' ','i','n',' ',
'\"','d','i','r','e','c','t','i','o','n','\"',' ','(','\"','l','e','f','t','\"',',',' ','\"','r','i','g','h','t','\"',',',' ','\"','u','p','\"',',',' ','o','r',' ','\"','d','o','w','n','\"',')',' ','a','n','d',' ','e','x','t','e','n','d','s',' ','t','h','e',' ',
's','e','l','e','c','t','i','o','n','.',' ',' ','S','a','m','e',' ','a','s',' ','f','o','r','w','a','r','d','/','b','a','c','k','w','a','r','d','-','c','h','a','r','a','c','t','e','r','(','\"','e','x','t','e','n','d','\"',')',',',' ','o','r',' ',
'p','r','o','c','e','s','s','-','u','p','/','d','o','w','n','(','\"','e','x','t','e','n','d','\"',')',',',' ','f','o','r',' ','c','o','m','p','a','t','i','b','i','l','i','t','y',' ','w','i','t','h',' ','p','r','e','v','i','o','u','s',' ','v','e','r','s','i','o','n','s','.','\n',
'\n',
'm','o','v','e','-','d','e','s','t','i','n','a','t','i','o','n','(',')','\n',
'M','o','v','e','s',' ','t','h','e',' ','c','u','r','s','o','r',' ','t','o',' ','t','h','e',' ','p','o','i','n','t','e','r',' ','l','o','c','a','t','i','o','n',' ','w','i','t','h','o','u','t',' ','d','i','s','t','u','r','b','i','n','g',' ','t','h','e',' ','s','e','l','e','c','t','i','o','n','.',' ',' ',
'(','T','h','i','s',' ','i','s',' ','a','n',' ','u','n','u','s','u','a','l',' ','w','a','y',' ','o','f',' ','w','o','r','k','i','n','g','.',' ',' ','W','e',' ','l','e','f','t',' ','i','t',' ','i','n',' ','f','o','r',' ','c','o','m','p','a','t','i','b','i','l','i','t','y',' ','w','i','t','h',' ',
'p','r','e','v','i','o','u','s',' ','v','e','r','s','i','o','n','s',',',' ','b','u','t',' ','i','f',' ','y','o','u',' ','a','c','t','u','a','l','l','y',' ','u','s','e',' ','t','h','i','s',' ','c','a','p','a','b','i','l','i','t','y',',',' ','p','l','e','a','s','e',' ','s','e','n','d',' ','u','s',' ','s','o','m','e',' ',
'm','a','i','l',',',' ','o','t','h','e','r','w','i','s','e',' ','i','t',' ','i','s',' ','l','i','k','e','l','y',' ','t','o',' ','d','i','s','a','p','p','e','a','r',' ','i','n',' ','t','h','e',' ','f','u','t','u','r','e','.','\n',
'\n',
'm','o','v','e','_','t','o','(',')','\n',
'I','f',' ','a',' ','s','e','c','o','n','d','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','e','x','i','s','t','s',',',' ','d','e','l','e','t','e','s',' ','t','h','e',' ','c','o','n','t','e','n','t','s',' ','o','f',' ','t','h','e',' ','s','e','c','o','n','d','a','r','y',' ',
's','e','l','e','c','t','i','o','n',' ','a','n','d',' ','i','n','s','e','r','t','s',' ','i','t',' ','a','t',' ','t','h','e',' ','c','u','r','s','o','r',',',' ','o','r',' ','i','f',' ','p','e','n','d','i','n','g','-','d','e','l','e','t','e',' ','i','s',' ','o','n',' ','a','n','d',' ','t','h','e','r','e',' ','i','s',' ',
'a',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',',',' ','r','e','p','l','a','c','e','s',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n','.',' ',' ','I','f',' ','n','o',' ','s','e','c','o','n','d','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ',
'e','x','i','s','t','s',',',' ','m','o','v','e','s',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','t','o',' ','t','h','e',' ','p','o','i','n','t','e','r',' ','l','o','c','a','t','i','o','n',',',' ','d','e','l','e','t','i','n','g',' ','i','t',' ',
'f','r','o','m',' ','i','t','s',' ','o','r','i','g','i','n','a','l',' ','p','o','s','i','t','i','o','n','.','\n',
'\n',
'm','o','v','e','_','t','o','_','o','r','_','e','n','d','_','d','r','a','g','(',')','\n',
'C','o','m','p','l','e','t','e','s',' ','e','i','t','h','e','r',' ','a',' ','s','e','c','o','n','d','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','o','p','e','r','a','t','i','o','n',',',' ','o','r',' ','a',' ','p','r','i','m','a','r','y',' ',
'd','r','a','g','.',' ',' ','I','f',' ','t','h','e',' ','u','s','e','r',' ','i','s',' ','d','r','a','g','g','i','n','g',' ','t','h','e',' ','m','o','u','s','e',' ','t','o',' ','a','d','j','u','s','t',' ','a',' ','s','e','c','o','n','d','a','r','y',' ','s','e','l','e','c','t','i','o','n',',',' ',
't','h','e',' ','s','e','l','e','c','t','i','o','n',' ','i','s',' ','d','e','l','e','t','e','d',' ','a','n','d',' ','e','i','t','h','e','r',' ','i','n','s','e','r','t','e','d',' ','a','t',' ','t','h','e',' ','c','u','r','s','o','r',' ','l','o','c','a','t','i','o','n',',',' ',
'o','r',',',' ','i','f',' ','p','e','n','d','i','n','g','-','d','e','l','e','t','e',' ','i','s',' ','o','n',' ','a','n','d',' ','a',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','e','x','i','s','t','s',' ','i','n',' ','t','h','e',' ','w','i','n','d','o','w',',',' ',
'r','e','p','l','a','c','e','s',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n','.',' ',' ','I','f',' ','t','h','e',' ','u','s','e','r',' ','i','s',' ','d','r','a','g','g','i','n','g',' ','a',' ','b','l','o','c','k',' ','o','f',' ',
't','e','x','t',' ','(','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',')',',',' ','c','o','m','p','l','e','t','e','s',' ','t','h','e',' ','d','r','a','g',' ','o','p','e','r','a','t','i','o','n',' ','a','n','d',' ','d','e','l','e','t','e','s',' ','t','h','e',' ',
't','e','x','t',' ','f','r','o','m',' ','i','t',''','s',' ','c','u','r','r','e','n','t',' ','l','o','c','a','t','i','o','n','.','\n',
'\n',
'n','e','w','l','i','n','e','(',')','\n',
'I','n','s','e','r','t','s',' ','a',' ','n','e','w','l','i','n','e',' ','c','h','a','r','a','c','t','e','r','.',' ',' ','I','f',' ','A','u','t','o',' ','I','n','d','e','n','t',' ','i','s',' ','o','n',',',' ','l','i','n','e','s',' ','u','p',' ','t','h','e',' ','i','n','d','e','n','t','a','t','i','o','n',' ',
'o','f',' ','t','h','e',' ','c','u','r','s','o','r',' ','w','i','t','h',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','l','i','n','e','.','\n',
'\n',
'n','e','w','l','i','n','e','_','a','n','d','_','i','n','d','e','n','t','(',')','\n',
'I','n','s','e','r','t','s',' ','a',' ','n','e','w','l','i','n','e',' ','c','h','a','r','a','c','t','e','r',' ','a','n','d',' ','l','i','n','e','s',' ','u','p',' ','t','h','e',' ','i','n','d','e','n','t','a','t','i','o','n',' ',
'o','f',' ','t','h','e',' ','c','u','r','s','o','r',' ','w','i','t','h',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','l','i','n','e',',',' ','r','e','g','a','r','d','l','e','s','s',' ','o','f',' ','t','h','e',' ','s','e','t','t','i','n','g',' ','o','f',' ','A','u','t','o',' ','I','n','d','e','n','t','.','\n',
'\n',
'n','e','w','l','i','n','e','_','n','o','_','i','n','d','e','n','t','(',')','\n',
'I','n','s','e','r','t','s',' ','a',' ','n','e','w','l','i','n','e',' ','c','h','a','r','a','c','t','e','r',',',' ','w','i','t','h','o','u','t',' ','a','u','t','o','m','a','t','i','c',' ','i','n','d','e','n','t','a','t','i','o','n',',',' ','r','e','g','a','r','d','l','e','s','s',' ','o','f',' ',
't','h','e',' ','s','e','t','t','i','n','g',' ','o','f',' ','A','u','t','o',' ','I','n','d','e','n','t','.','\n',
'\n',
'n','e','x','t','_','p','a','g','e','(',')','\n',
'M','o','v','e','s',' ','t','h','e',' ','c','u','r','s','o','r',' ','a','n','d',' ','s','c','r','o','l','l',' ','f','o','r','w','a','r','d',' ','o','n','e',' ','p','a','g','e','.','\n',
'\n',
'p','a','g','e','_','l','e','f','t','(',')','\n',
'M','o','v','e',' ','t','h','e',' ','c','u','r','s','o','r',' ','a','n','d',' ','s','c','r','o','l','l',' ','l','e','f','t',' ','o','n','e',' ','p','a','g','e','.','\n',
'\n',
'p','a','g','e','_','r','i','g','h','t','(',')','\n',
'M','o','v','e',' ','t','h','e',' ','c','u','r','s','o','r',' ','a','n','d',' ','s','c','r','o','l','l',' ','r','i','g','h','t',' ','o','n','e',' ','p','a','g','e','.','\n',
'\n',
'p','a','s','t','e','_','c','l','i','p','b','o','a','r','d','(',')','\n',
'I','n','s','e','r','t',' ','t','h','e',' ','c','o','n','t','e','n','t','s',' ','o','f',' ','t','h','e',' ','c','l','i','p','b','o','a','r','d',' ','a','t',' ','t','h','e',' ','c','u','r','s','o','r',',',' ','o','r',' ','i','f',' ','p','e','n','d','i','n','g',' ','d','e','l','e','t','e',' ',
'i','s',' ','o','n',',',' ','r','e','p','l','a','c','e',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','w','i','t','h',' ','t','h','e',' ','c','o','n','t','e','n','t','s',' ','o','f',' ','t','h','e',' ','c','l','i','p','b','o','a','r','d','.','\n',
'\n',
'p','r','e','v','i','o','u','s','_','p','a','g','e','(',')','\n',
'M','o','v','e','s',' ','t','h','e',' ','c','u','r','s','o','r',' ','a','n','d',' ','s','c','r','o','l','l',' ','b','a','c','k','w','a','r','d',' ','o','n','e',' ','p','a','g','e','.','\n',
'\n',
'p','r','o','c','e','s','s','_','b','d','r','a','g','(',')','\n',
'S','a','m','e',' ','a','s',' ','s','e','c','o','n','d','a','r','y','_','o','r','_','d','r','a','g','_','s','t','a','r','t',' ','f','o','r',' ','c','o','m','p','a','t','i','b','i','l','i','t','y',' ','w','i','t','h',' ','p','r','e','v','i','o','u','s',' ','v','e','r','s','i','o','n','s','.','\n',
'\n',
'p','r','o','c','e','s','s','_','c','a','n','c','e','l','(',')','\n',
'C','a','n','c','e','l','s',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','e','x','t','e','n','d','_','a','d','j','u','s','t',',',' ','s','e','c','o','n','d','a','r','y','_','a','d','j','u','s','t',',',' ','o','r',' ',
's','e','c','o','n','d','a','r','y','_','o','r','_','d','r','a','g','_','a','d','j','u','s','t',' ','i','n',' ','p','r','o','g','r','e','s','s','.','\n',
'\n',
'p','r','o','c','e','s','s','_','d','o','w','n','(',')','\n',
'M','o','v','e','s',' ','t','h','e',' ','c','u','r','s','o','r',' ','d','o','w','n',' ','o','n','e',' ','l','i','n','e','.','\n',
'\n',
'p','r','o','c','e','s','s','_','r','e','t','u','r','n','(',')','\n',
'S','a','m','e',' ','a','s',' ','n','e','w','l','i','n','e',' ','f','o','r',' ','c','o','m','p','a','t','i','b','i','l','i','t','y',' ','w','i','t','h',' ','p','r','e','v','i','o','u','s',' ','v','e','r','s','i','o','n','s','.','\n',
'\n',
'p','r','o','c','e','s','s','_','s','h','i','f','t','_','d','o','w','n','(',')','\n',
'S','a','m','e',' ','a','s',' ','p','r','o','c','e','s','s','_','d','o','w','n','(','\"','e','x','t','e','n','d','\"',')',' ','f','o','r',' ','c','o','m','p','a','t','i','b','i','l','i','t','y',' ','w','i','t','h',' ','p','r','e','v','i','o','u','s',' ','v','e','r','s','i','o','n','s','.','\n',
'\n',
'p','r','o','c','e','s','s','_','s','h','i','f','t','_','u','p','(',')','\n',
'S','a','m','e',' ','a','s',' ','p','r','o','c','e','s','s','_','u','p','(','\"','e','x','t','e','n','d','\"',')',' ','f','o','r',' ','c','o','m','p','a','t','i','b','i','l','i','t','y',' ','w','i','t','h',' ','p','r','e','v','i','o','u','s',' ','v','e','r','s','i','o','n','s','.','\n',
'\n',
'p','r','o','c','e','s','s','_','t','a','b','(',')','\n',
'I','f',' ','t','a','b',' ','e','m','u','l','a','t','i','o','n',' ','i','s',' ','t','u','r','n','e','d',' ','o','n',',',' ','i','n','s','e','r','t','s',' ','a','n',' ','e','m','u','l','a','t','e','d',' ','t','a','b',',',' ','o','t','h','e','r','w','i','s','e',' ','i','n','s','e','r','t','s',' ',
'a',' ','t','a','b',' ','c','h','a','r','a','c','t','e','r','.','\n',
'\n',
'p','r','o','c','e','s','s','_','u','p','(',')','\n',
'M','o','v','e','s',' ','t','h','e',' ','c','u','r','s','o','r',' ','u','p',' ','o','n','e',' ','l','i','n','e','.','\n',
'\n',
's','c','r','o','l','l','_','d','o','w','n','(','n','L','i','n','e','s',')','\n',
'S','c','r','o','l','l',' ','t','h','e',' ','d','i','s','p','l','a','y',' ','d','o','w','n',' ','(','t','o','w','a','r','d','s',' ','t','h','e',' ','e','n','d',' ','o','f',' ','t','h','e',' ','f','i','l','e',')',' ','b','y',' ','n','L','i','n','e','s','.','\n',
'\n',
's','c','r','o','l','l','_','u','p','(','n','L','i','n','e','s',')','\n',
'S','c','r','o','l','l',' ','t','h','e',' ','d','i','s','p','l','a','y',' ','u','p',' ','(','t','o','w','a','r','d','s',' ','t','h','e',' ','b','e','g','i','n','n','i','n','g',' ','o','f',' ','t','h','e',' ','f','i','l','e',')',' ','b','y',' ','n','L','i','n','e','s','.','\n',
'\n',
's','c','r','o','l','l','_','t','o','_','l','i','n','e','(','l','i','n','e','N','u','m',')','\n',
'S','c','r','o','l','l',' ','t','o',' ','p','o','s','i','t','i','o','n',' ','l','i','n','e',' ','n','u','m','b','e','r',' ','l','i','n','e','N','u','m',' ','a','t',' ','t','h','e',' ','t','o','p',' ','o','f',' ','t','h','e',' ',
'p','a','n','e','.',' ',' ','T','h','e',' ','f','i','r','s','t',' ','l','i','n','e',' ','o','f',' ','a',' ','f','i','l','e',' ','i','s',' ','l','i','n','e',' ','1','.','\n',
'\n',
's','e','c','o','n','d','a','r','y','_','a','d','j','u','s','t','(',')','\n',
'A','t','t','a','c','h','e','d',' ','m','o','u','s','e','-','m','o','v','e','m','e','n','t',' ','e','v','e','n','t','s',' ','t','o',' ','e','x','t','e','n','d',' ','t','h','e',' ','s','e','c','o','n','d','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','t','o',' ','t','h','e',' ',
'm','o','u','s','e',' ','p','o','s','i','t','i','o','n','.','\n',
'\n',
's','e','c','o','n','d','a','r','y','_','o','r','_','d','r','a','g','_','a','d','j','u','s','t','(',')','\n',
'A','t','t','a','c','h','e','d',' ','m','o','u','s','e','-','m','o','v','e','m','e','n','t',' ','e','v','e','n','t','s',' ','t','o',' ','e','x','t','e','n','d',' ','t','h','e',' ','s','e','c','o','n','d','a','r','y',' ','s','e','l','e','c','t','i','o','n',',',' ','o','r',' ',
'r','e','p','o','s','i','t','i','o','n',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','t','e','x','t',' ','b','e','i','n','g',' ','d','r','a','g','g','e','d','.',' ',' ','T','a','k','e','s',' ','t','w','o',' ','o','p','t','i','o','n','a','l',' ','a','r','g','u','m','e','n','t','s',',',' ',
'\"','c','o','p','y','\"',',',' ','a','n','d',' ','\"','o','v','e','r','l','a','y','\"','.',' ',' ','\"','c','o','p','y','\"',' ','l','e','a','v','e','s',' ','a',' ','c','o','p','y',' ','o','f',' ','t','h','e',' ','d','r','a','g','g','e','d',' ','t','e','x','t',' ',
'a','t',' ','t','h','e',' ','s','i','t','e',' ','a','t',' ','w','h','i','c','h',' ','t','h','e',' ','d','r','a','g',' ','b','e','g','a','n','.',' ',' ','\"','o','v','e','r','l','a','y','\"',' ','d','o','e','s',' ','t','h','e',' ','d','r','a','g',' ','i','n',' ','o','v','e','r','l','a','y',' ',
'm','o','d','e',',',' ','m','e','a','n','i','n','g',' ','t','h','e',' ','d','r','a','g','g','e','d',' ','t','e','x','t',' ','i','s',' ','l','a','i','d',' ','o','n',' ','t','o','p',' ','o','f',' ','t','h','e',' ','e','x','i','s','t','i','n','g',' ','t','e','x','t',',',' ',
'o','b','s','c','u','r','i','n','g',' ','a','n','d',' ','u','l','t','i','m','a','t','e','l','y',' ','d','e','l','e','t','i','n','g',' ','i','t',' ','w','h','e','n',' ','t','h','e',' ','d','r','a','g',' ','i','s',' ','c','o','m','p','l','e','t','e','.','\n',
'\n',
's','e','c','o','n','d','a','r','y','_','o','r','_','d','r','a','g','_','s','t','a','r','t','(',')','\n',
'T','o',' ','b','e',' ','a','t','t','a','c','h','e','d',' ','t','o',' ','a',' ','m','o','u','s','e',' ','d','o','w','n',' ','e','v','e','n','t','.',' ',' ','B','e','g','i','n','s',' ','d','r','a','g',' ','s','e','l','e','c','t','i','n','g',' ','a',' ','s','e','c','o','n','d','a','r','y',' ',
's','e','l','e','c','t','i','o','n',',',' ','o','r',' ','d','r','a','g','g','i','n','g',' ','t','h','e',' ','c','o','n','t','e','n','t','s',' ','o','f',' ','t','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',',',' ','d','e','p','e','n','d','i','n','g',' ','o','n',' ',
'w','h','e','t','h','e','r',' ','t','h','e',' ','m','o','u','s','e',' ','i','s',' ','p','r','e','s','s','e','d',' ','i','n','s','i','d','e',' ','o','f',' ','a','n',' ','e','x','i','s','t','i','n','g',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n','.','\n',
'\n',
's','e','c','o','n','d','a','r','y','_','s','t','a','r','t','(',')','\n',
'T','o',' ','b','e',' ','a','t','t','a','c','h','e','d',' ','t','o',' ','a',' ','m','o','u','s','e',' ','d','o','w','n',' ','e','v','e','n','t','.',' ',' ','B','e','g','i','n',' ','d','r','a','g',' ','s','e','l','e','c','t','i','n','g',' ','a',' ','s','e','c','o','n','d','a','r','y',' ',
's','e','l','e','c','t','i','o','n','.','\n',
'\n',
's','e','l','e','c','t','_','a','l','l','(',')','\n',
'S','e','l','e','c','t',' ','t','h','e',' ','e','n','t','i','r','e',' ','f','i','l','e','.','\n',
'\n',
's','e','l','f','_','i','n','s','e','r','t','(',')','\n',
'T','o',' ','b','e',' ','a','t','t','a','c','h','e','d',' ','t','o',' ','a',' ','k','e','y','-','p','r','e','s','s',' ','e','v','e','n','t',',',' ','i','n','s','e','r','t','s',' ','t','h','e',' ','c','h','a','r','a','c','t','e','r',' ','e','q','u','i','v','a','l','e','n','t',' ',
'o','f',' ','t','h','e',' ','k','e','y',' ','p','r','e','s','s','e','d','.','\n',
'\n',
'A','r','g','u','m','e','n','t','s',' ','t','o',' ','K','e','y','b','o','a','r','d',' ','A','c','t','i','o','n',' ','R','o','u','t','i','n','e','s',' ','\n',
'\n',
'I','n',' ','a','d','d','i','t','i','o','n',' ','t','o',' ','t','h','e',' ','a','r','g','u','m','e','n','t','s',' ','l','i','s','t','e','d',' ','i','n',' ','t','h','e',' ','c','a','l','l',' ','d','e','s','c','r','i','p','t','i','o','n','s',',',' ','a','n','y',' ','r','o','u','t','i','n','e',' ',
'i','n','v','o','l','v','i','n','g',' ','c','u','r','s','o','r',' ','m','o','v','e','m','e','n','t',' ','c','a','n',' ','t','a','k','e',' ','t','h','e',' ','a','r','g','u','m','e','n','t',' ','\"','e','x','t','e','n','d','\"',',',' ','m','e','a','n','i','n','g',',',' ','a','d','j','u','s','t',' ',
't','h','e',' ','p','r','i','m','a','r','y',' ','s','e','l','e','c','t','i','o','n',' ','t','o',' ','t','h','e',' ','n','e','w',' ','c','u','r','s','o','r',' ','p','o','s','i','t','i','o','n','.',' ',' ','R','o','u','t','i','n','e','s',' ','w','h','i','c','h',' ','t','a','k','e',' ',
't','h','e',' ','\"','e','x','t','e','n','d','\"',' ','a','r','g','u','m','e','n','t',' ','a','s',' ','w','e','l','l',' ','a','s',' ','m','o','u','s','e',' ','d','r','a','g','g','i','n','g',' ','o','p','e','r','a','t','i','o','n','s',' ','f','o','r',' ','b','o','t','h',' ',
'p','r','i','m','a','r','y',' ','a','n','d',' ','s','e','c','o','n','d','a','r','y',' ','s','e','l','e','c','t','i','o','n','s',' ','c','a','n',' ','t','a','k','e',' ','t','h','e',' ','o','p','t','i','o','n','a','l',' ','k','e','y','w','o','r','d',' ','\"','r','e','c','t','\"',',',' ',
'm','e','a','n','i','n','g',',',' ','m','a','k','e',' ','t','h','e',' ','s','e','l','e','c','t','i','o','n',' ','r','e','c','t','a','n','g','u','l','a','r','.','\0'};

static char AuxString26[] = {'W','R','I','T','I','N','G',' ','S','Y','N','T','A','X',' ','H','I','G','H','L','I','G','H','T','I','N','G',' ','P','A','T','T','E','R','N','S','\n',
'\n',
'P','a','t','t','e','r','n','s',' ','a','r','e',' ','t','h','e',' ','m','e','c','h','a','n','i','s','m',' ','b','y',' ','w','h','i','c','h',' ','s','y','n','t','a','x',' ','h','i','g','h','l','i','g','h','t','i','n','g',' ','(','s','e','e',' ','S','y','n','t','a','x',' ',
'H','i','g','h','l','i','g','h','t','i','n','g',' ','u','n','d','e','r',' ','t','h','e',' ','h','e','a','d','i','n','g',' ','o','f',' ','F','e','a','t','u','r','e','s',' ','f','o','r',' ','P','r','o','g','r','a','m','m','i','n','g',')',' ',
'i','s',' ','p','r','o','g','r','a','m','m','e','d',' ','i','n',' ','N','E','d','i','t',',',' ','t','h','a','t',' ','i','s',',',' ','h','o','w',' ','i','t',' ','d','e','c','i','d','e','s',' ','w','h','a','t',' ','t','o',' ','h','i','g','h','l','i','g','h','t',' ','i','n',' ','a',' ','g','i','v','e','n',' ',
'l','a','n','g','u','a','g','e','.',' ',' ',
'T','o',' ','c','r','e','a','t','e',' ','s','y','n','t','a','x',' ','h','i','g','h','l','i','g','h','t','i','n','g',' ','p','a','t','t','e','r','n','s',' ','f','o','r',' ','a',' ','n','e','w',' ','l','a','n','g','u','a','g','e',',',' ','o','r',' ','t','o',' ',
'm','o','d','i','f','y',' ','e','x','i','s','t','i','n','g',' ','p','a','t','t','e','r','n','s',',',' ','s','e','l','e','c','t',' ','\"','P','a','t','t','e','r','n','s',' ','f','o','r',' ','H','i','g','h','l','i','g','h','t','i','n','g','\"',' ','f','r','o','m',' ',
'\"','S','y','n','t','a','x',' ','H','i','g','h','l','i','g','h','t','i','n','g','\"',' ','s','u','b','-','s','e','c','t','i','o','n',' ','o','f',' ','t','h','e',' ','\"','D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s','\"',' ','s','u','b','-','m','e','n','u',' ',
'o','f',' ','t','h','e',' ','\"','P','r','e','f','e','r','e','n','c','e','s','\"',' ','m','e','n','u','.','\n',
'\n',
'F','i','r','s','t',',',' ','a',' ','w','o','r','d',' ','o','f',' ','c','a','u','t','i','o','n','.',' ',' ','A','s',' ','w','i','t','h',' ','r','e','g','u','l','a','r',' ','e','x','p','r','e','s','s','i','o','n',' ','m','a','t','c','h','i','n','g',' ','i','n',' ',
'g','e','n','e','r','a','l',',',' ','i','t',' ','i','s',' ','q','u','i','t','e',' ','p','o','s','s','i','b','l','e',' ','t','o',' ','w','r','i','t','e',' ','p','a','t','t','e','r','n','s',' ','w','h','i','c','h',' ','a','r','e',' ','s','o',' ',
'i','n','e','f','f','i','c','i','e','n','t',' ','t','h','a','t',' ','t','h','e','y',' ','e','s','s','e','n','t','i','a','l','l','y',' ','l','o','c','k',' ','u','p',' ','t','h','e',' ','e','d','i','t','o','r',' ','a','s',' ','t','h','e','y',' ',
'r','e','c','u','r','s','i','v','e','l','y',' ','r','e','-','e','x','a','m','i','n','e',' ','t','h','e',' ','e','n','t','i','r','e',' ','c','o','n','t','e','n','t','s',' ','o','f',' ','t','h','e',' ','f','i','l','e',' ','t','h','o','u','s','a','n','d','s',' ','o','f',' ',
't','i','m','e','s','.',' ',' ','W','i','t','h',' ','t','h','e',' ','m','u','l','t','i','p','l','i','c','i','t','y',' ','o','f',' ','p','a','t','t','e','r','n','s',',',' ','t','h','e',' ','p','o','s','s','i','b','i','l','i','t','y',' ','o','f',' ','a',' ','l','o','c','k','-','u','p',' ',
'i','s',' ','s','i','g','n','i','f','i','c','a','n','t','l','y',' ','i','n','c','r','e','a','s','e','d',' ','i','n',' ','s','y','n','t','a','x',' ','h','i','g','h','l','i','g','h','t','i','n','g','.',' ',' ','W','h','e','n',' ','w','o','r','k','i','n','g',' ',
'o','n',' ','h','i','g','h','l','i','g','h','t','i','n','g',' ','p','a','t','t','e','r','n','s',',',' ','b','e',' ','s','u','r','e',' ','t','o',' ','s','a','v','e',' ','y','o','u','r',' ','w','o','r','k',' ','f','r','e','q','u','e','n','t','l','y','.','\n',
'\n',
'N','E','d','i','t',''','s',' ','s','y','n','t','a','x',' ','h','i','g','h','l','i','g','h','t','i','n','g',' ','i','s',' ','u','n','u','s','u','a','l',' ','i','n',' ','t','h','a','t',' ','i','t',' ','w','o','r','k','s',' ','i','n',' ','r','e','a','l','-','t','i','m','e',' ',
'(','a','s',' ','y','o','u',' ','t','y','p','e',')',',',' ','a','n','d',' ','y','e','t',' ','i','s',' ','c','o','m','p','l','e','t','e','l','y',' ','p','r','o','g','r','a','m','m','a','b','l','e',' ','u','s','i','n','g',' ','s','t','a','n','d','a','r','d',' ',
'r','e','g','u','l','a','r',' ','e','x','p','r','e','s','s','i','o','n',' ','n','o','t','a','t','i','o','n','.',' ',' ','O','t','h','e','r',' ','s','y','n','t','a','x',' ','h','i','g','h','l','i','g','h','t','i','n','g',' ','e','d','i','t','o','r','s',' ','u','s','u','a','l','l','y',' ','f','a','l','l',' ',
'e','i','t','h','e','r',' ','i','n','t','o',' ','t','h','e',' ','c','a','t','e','g','o','r','y',' ','o','f',' ','f','u','l','l','y',' ','p','r','o','g','r','a','m','m','a','b','l','e',' ','b','u','t',' ','u','n','a','b','l','e',' ','t','o',' ','k','e','e','p',' ','u','p',' ','i','n',' ',
'r','e','a','l','-','t','i','m','e',',',' ','o','r',' ','r','e','a','l','-','t','i','m','e',' ','b','u','t',' ','l','i','m','i','t','e','d',' ','p','r','o','g','r','a','m','m','a','b','i','l','i','t','y','.',' ',' ','T','h','e',' ','a','d','d','i','t','i','o','n','a','l',' ',
'b','u','r','d','e','n',' ','t','h','a','t',' ','N','E','d','i','t',' ','p','l','a','c','e','s',' ','o','n',' ','p','a','t','t','e','r','n',' ','w','r','i','t','e','r','s',' ','i','n',' ','o','r','d','e','r',' ','t','o',' ','a','c','h','i','e','v','e',' ','t','h','i','s',' ',
's','p','e','e','d','/','f','l','e','x','i','b','i','l','i','t','y',' ','m','i','x',',',' ','i','s',' ','t','o',' ','f','o','r','c','e',' ','t','h','e','m',' ','t','o',' ','s','t','a','t','e',' ','s','e','l','f','-','i','m','p','o','s','e','d',' ',
'l','i','m','i','t','a','t','i','o','n','s',' ','o','n',' ','t','h','e',' ','a','m','o','u','n','t',' ','o','f',' ','c','o','n','t','e','x','t',' ','t','h','a','t',' ','p','a','t','t','e','r','n','s',' ','m','a','y',' ','e','x','a','m','i','n','e',' ','w','h','e','n',' ',
'r','e','-','p','a','r','s','i','n','g',' ','a','f','t','e','r',' ','a',' ','c','h','a','n','g','e','.',' ',' ','W','h','i','l','e',' ','t','h','e',' ','\"','P','a','t','t','e','r','n',' ','C','o','n','t','e','x','t',' ','R','e','q','u','i','r','e','m','e','n','t','s','\"',' ',
'h','e','a','d','i','n','g',' ','i','s',' ','n','e','a','r',' ','t','h','e',' ','e','n','d',' ','o','f',' ','t','h','i','s',' ','s','e','c','t','i','o','n',',',' ','i','t',' ','i','s',' ','n','o','t',' ','o','p','t','i','o','n','a','l',',',' ','a','n','d',' ','m','u','s','t',' ','b','e',' ',
'u','n','d','e','r','s','t','o','o','d',' ','b','e','f','o','r','e',' ','m','a','k','i','n','g',' ','a','n','y',' ','a','n','y',' ','s','e','r','i','o','u','s',' ','e','f','f','o','r','t',' ','a','t',' ','p','a','t','t','e','r','n',' ','w','r','i','t','i','n','g','.','\n',
'\n',
'I','n',' ','i','t','s',' ','s','i','m','p','l','e','s','t',' ','f','o','r','m',',',' ','a',' ','h','i','g','h','l','i','g','h','t',' ','p','a','t','t','e','r','n',' ','c','o','n','s','i','s','t','s',' ','o','f',' ','a',' ','r','e','g','u','l','a','r',' ',
'e','x','p','r','e','s','s','i','o','n',' ','t','o',' ','m','a','t','c','h',',',' ','a','l','o','n','g',' ','w','i','t','h',' ','a',' ','s','t','y','l','e',' ','r','e','p','r','e','s','e','n','t','i','n','g',' ','t','h','e',' ','f','o','n','t',' ','a','n',' ','c','o','l','o','r',' ',
'f','o','r',' ','d','i','s','p','l','a','y','i','n','g',' ','a','n','y',' ','t','e','x','t',' ','w','h','i','c','h',' ','m','a','t','c','h','e','s',' ','t','h','a','t',' ','e','x','p','r','e','s','s','i','o','n','.',' ',' ','T','o',' ','b','o','l','d',' ','t','h','e',' ',
'w','o','r','d',',',' ','\"','h','i','g','h','l','i','g','h','t','\"',',',' ','w','h','e','r','e','v','e','r',' ','i','t',' ','a','p','p','e','a','r','s',' ','t','h','e',' ','t','e','x','t',',',' ','t','h','e',' ','r','e','g','u','l','a','r',' ','e','x','p','r','e','s','s','i','o','n',' ',
's','i','m','p','l','y',' ','w','o','u','l','d',' ','b','e',' ','t','h','e',' ','w','o','r','d',' ','\"','h','i','g','h','l','i','g','h','t','\"','.',' ',' ','T','h','e',' ','s','t','y','l','e',' ','(','s','e','l','e','c','t','e','d',' ','f','r','o','m',' ','t','h','e',' ','m','e','n','u',' ',
'u','n','d','e','r',' ','t','h','e',' ','h','e','a','d','i','n','g',' ','o','f',' ','\"','H','i','g','h','l','i','g','h','t',' ','S','t','y','l','e','\"',')',' ','d','e','t','e','r','m','i','n','e','s',' ','h','o','w',' ','t','h','e',' ','t','e','x','t',' ','w','i','l','l',' ','b','e',' ',
'd','r','a','w','n','.',' ',' ','T','o',' ','b','o','l','d',' ','t','h','e',' ','t','e','x','t',',',' ','e','i','t','h','e','r',' ','s','e','l','e','c','t',' ','a','n',' ','e','x','i','s','t','i','n','g',' ','s','t','y','l','e',',',' ','s','u','c','h',' ','a','s',' ',
'\"','K','e','y','w','o','r','d','\"',',',' ','w','h','i','c','h',' ','b','o','l','d','s',' ','t','e','x','t',',',' ','o','r',' ','c','r','e','a','t','e',' ','a',' ','n','e','w',' ','s','t','y','l','e',' ','a','n','d',' ','s','e','l','e','c','t',' ','i','t',' ',
'u','n','d','e','r',' ','H','i','g','h','l','i','g','h','t',' ','S','t','y','l','e','.','\n',
'\n',
'T','h','e',' ','f','u','l','l',' ','r','a','n','g','e',' ','o','f',' ','r','e','g','u','l','a','r',' ','e','x','p','r','e','s','s','i','o','n',' ','c','a','p','a','b','i','l','i','t','i','e','s',' ','c','a','n',' ','b','e',' ','a','p','p','l','i','e','d',' ','i','n',' ',
's','u','c','h',' ','a',' ','p','a','t','t','e','r','n',',',' ','w','i','t','h',' ','t','h','e',' ','s','i','n','g','l','e',' ','c','a','v','e','a','t',' ','t','h','a','t',' ','t','h','e',' ','e','x','p','r','e','s','s','i','o','n',' ','m','u','s','t',' ',
'c','o','n','c','l','u','s','i','v','e','l','y',' ','m','a','t','c','h',' ','o','r',' ','n','o','t',' ','m','a','t','c','h',',',' ','w','i','t','h','i','n',' ','t','h','e',' ','p','r','e','-','d','e','f','i','n','e','d',' ','c','o','n','t','e','x','t',' ',
'd','i','s','t','a','n','c','e',' ','(','a','s',' ','d','i','s','c','u','s','s','e','d',' ','b','e','l','o','w',' ','u','n','d','e','r',' ','P','a','t','t','e','r','n',' ','C','o','n','t','e','x','t',' ','R','e','q','u','i','r','e','m','e','n','t','s',')','.','\n',
'\n',
'T','o',' ','m','a','t','c','h',' ','l','o','n','g','e','r',' ','r','a','n','g','e','s',' ','o','f',' ','t','e','x','t',',',' ','p','a','r','t','i','c','u','l','a','r','l','y',' ','a','n','y',' ','c','o','n','s','t','r','u','c','t','s',' ','w','h','i','c','h',' ',
'e','x','c','e','e','d',' ','t','h','e',' ','r','e','q','u','e','s','t','e','d',' ','c','o','n','t','e','x','t',',',' ','y','o','u',' ','m','u','s','t',' ','u','s','e',' ','a',' ','p','a','t','t','e','r','n',' ','w','h','i','c','h',' ','h','i','g','h','l','i','g','h','t','s',' ',
't','e','x','t',' ','b','e','t','w','e','e','n',' ','a',' ','s','t','a','r','t','i','n','g',' ','a','n','d',' ','e','n','d','i','n','g',' ','r','e','g','u','l','a','r',' ','e','x','p','r','e','s','s','i','o','n',' ','m','a','t','c','h','.',' ',' ','T','o',' ','d','o',' ','s','o',',',' ',
's','e','l','e','c','t',' ','\"','H','i','g','h','l','i','g','h','t',' ','t','e','x','t',' ','b','e','t','w','e','e','n',' ','s','t','a','r','t','i','n','g',' ','a','n','d',' ','e','n','d','i','n','g',' ','R','E','s','\"',' ','u','n','d','e','r',' ',
'\"','M','a','t','c','h','i','n','g','\"',',',' ','a','n','d',' ','e','n','t','e','r',' ','b','o','t','h',' ','a',' ','s','t','a','r','t','i','n','g',' ','a','n','d',' ','e','n','d','i','n','g',' ','r','e','g','u','l','a','r',' ','e','x','p','r','e','s','s','i','o','n','.',' ',' ',
'F','o','r',' ','e','x','a','m','p','l','e',',',' ','t','o',' ','h','i','g','h','l','i','g','h','t',' ','e','v','e','r','y','t','h','i','n','g',' ','b','e','t','w','e','e','n',' ','d','o','u','b','l','e',' ','q','u','o','t','e','s',',',' ','y','o','u',' ','w','o','u','l','d',' ',
'e','n','t','e','r',' ','a',' ','d','o','u','b','l','e',' ','q','u','o','t','e',' ','c','h','a','r','a','c','t','e','r',' ','i','n',' ','b','o','t','h',' ','t','h','e',' ','s','t','a','r','t','i','n','g',' ','a','n','d',' ','e','n','d','i','n','g',' ','r','e','g','u','l','a','r',' ',
'e','x','p','r','e','s','s','i','o','n',' ','f','i','e','l','d','s','.',' ',' ','P','a','t','t','e','r','n','s',' ','w','i','t','h',' ','b','o','t','h',' ','a',' ','b','e','g','i','n','n','i','n','g',' ','a','n','d',' ','e','n','d','i','n','g',' ','e','x','p','r','e','s','s','i','o','n',' ','s','p','a','n',' ',
'a','l','l',' ','c','h','a','r','a','c','t','e','r','s',' ','b','e','t','w','e','e','n',' ','t','h','e',' ','t','w','o',' ','e','x','p','r','e','s','s','i','o','n','s',',',' ','i','n','c','l','u','d','i','n','g',' ','n','e','w','l','i','n','e','s','.','\n',
'\n',
'A','g','a','i','n',',',' ','t','h','e',' ','l','i','m','i','t','a','t','i','o','n',' ','f','o','r',' ','a','u','t','o','m','a','t','i','c',' ','p','a','r','s','i','n','g',' ','t','o',' ','o','p','e','r','a','t','e',' ','p','r','o','p','e','r','l','y',' ','i','s',' ','t','h','a','t',' ',
'b','o','t','h',' ','e','x','p','r','e','s','s','i','o','n','s',' ','m','u','s','t',' ','m','a','t','c','h',' ','w','i','t','h','i','n',' ','t','h','e',' ','c','o','n','t','e','x','t',' ','d','i','s','t','a','n','c','e',' ','s','t','a','t','e','d',' ','f','o','r',' ','t','h','e',' ',
'p','a','t','t','e','r','n',' ','s','e','t','.','\n',
'\n',
'W','i','t','h',' ','t','h','e',' ','a','b','i','l','i','t','y',' ','t','o',' ','s','p','a','n',' ','l','a','r','g','e',' ','d','i','s','t','a','n','c','e','s',',',' ','c','o','m','e','s',' ','t','h','e',' ','r','e','s','p','o','n','s','i','b','i','l','i','t','y',' ','t','o',' ',
'r','e','c','o','v','e','r',' ','w','h','e','n',' ','t','h','i','n','g','s',' ','g','o',' ','w','r','o','n','g','.',' ',' ','R','e','m','e','m','b','e','r',' ','t','h','a','t',' ','s','y','n','t','a','x',' ','h','i','g','h','l','i','g','h','t','i','n','g',' ','i','s',' ',
'c','a','l','l','e','d',' ','u','p','o','n',' ','t','o',' ','p','a','r','s','e',' ','i','n','c','o','r','r','e','c','t',' ','o','r',' ','i','n','c','o','m','p','l','e','t','e',' ','s','y','n','t','a','x',' ','a','s',' ','o','f','t','e','n',' ','a','s',' ','c','o','r','r','e','c','t',' ',
's','y','n','t','a','x','.',' ',' ','T','o',' ','s','t','o','p',' ','a',' ','p','a','t','t','e','r','n',' ','s','h','o','r','t',' ','o','f',' ','m','a','t','c','h','i','n','g',' ','i','t','s',' ','e','n','d',' ','e','x','p','r','e','s','s','i','o','n',',',' ','y','o','u',' ','c','a','n',' ',
's','p','e','c','i','f','y',' ','a','n',' ','e','r','r','o','r',' ','e','x','p','r','e','s','s','i','o','n',',',' ','w','h','i','c','h',' ','s','t','o','p','s',' ','t','h','e',' ','p','a','t','t','e','r','n',' ','f','r','o','m',' ','g','o','b','b','l','i','n','g',' ','u','p',' ',
'm','o','r','e',' ','t','h','a','n',' ','i','t',' ','s','h','o','u','l','d','.',' ',' ','F','o','r',' ','e','x','a','m','p','l','e',',',' ','i','f',' ','t','h','e',' ','t','e','x','t',' ','b','e','t','w','e','e','n',' ','d','o','u','b','l','e',' ','q','u','o','t','e','s',' ',
's','h','o','u','l','d','n',''','t',' ','c','o','n','t','a','i','n',' ','n','e','w','l','i','n','e','s',',',' ','t','h','e',' ','e','r','r','o','r',' ','e','x','p','r','e','s','s','i','o','n',' ','m','i','g','h','t',' ','b','e',' ','\"','$','\"','.',' ',' ','A','s',' ','w','i','t','h',' ',
'b','o','t','h',' ','s','t','a','r','t','i','n','g',' ','a','n','d',' ','e','n','d','i','n','g',' ','e','x','p','r','e','s','s','i','o','n','s',',',' ','e','r','r','o','r',' ','e','x','p','r','e','s','s','i','o','n','s',' ','m','u','s','t',' ','a','l','s','o',' ','m','a','t','c','h',' ',
'w','i','t','h','i','n',' ','t','h','e',' ','r','e','q','u','e','s','t','e','d',' ','c','o','n','t','e','x','t',' ','d','i','s','t','a','n','c','e','.','\n',
'\n',
'C','o','l','o','r','i','n','g',' ','S','u','b','-','E','x','p','r','e','s','s','i','o','n','s','\n',
'\n',
'I','t',' ','i','s',' ','a','l','s','o',' ','p','o','s','s','i','b','l','e',' ','t','o',' ','c','o','l','o','r',' ','a','r','e','a','s',' ','o','f',' ','t','e','x','t',' ','w','i','t','h','i','n',' ','a',' ','r','e','g','u','l','a','r',' ',
'e','x','p','r','e','s','s','i','o','n',' ','m','a','t','c','h','.',' ',' ','A',' ','p','a','t','t','e','r','n',' ','o','f',' ','t','h','i','s',' ','t','y','p','e',' ','a','s','s','o','c','i','a','t','e','s',' ','a',' ','s','t','y','l','e',' ','w','i','t','h',' ',
's','u','b','-','e','x','p','r','e','s','s','i','o','n','s',' ','r','e','f','e','r','e','n','c','e','s',' ','o','f',' ','t','h','e',' ','p','a','r','e','n','t',' ','p','a','t','t','e','r','n',' ','(','a','s',' ','u','s','e','d',' ','i','n',' ','r','e','g','u','l','a','r',' ',
'e','x','p','r','e','s','s','i','o','n',' ','s','u','b','s','t','i','t','u','t','i','o','n',' ','p','a','t','t','e','r','n','s',',',' ','s','e','e',' ','t','h','e',' ','N','E','d','i','t',' ','H','e','l','p',' ','m','e','n','u',' ','i','t','e','m',' ','o','n',' ',
'R','e','g','u','l','a','r',' ','E','x','p','r','e','s','s','i','o','n','s',')','.',' ',' ','S','u','b','-','e','x','p','r','e','s','s','i','o','n','s',' ','o','f',' ','b','o','t','h',' ','t','h','e',' ','s','t','a','r','t','i','n','g',' ','a','n','d',' ','e','n','d','i','n','g',' ',
'p','a','t','t','e','r','n','s',' ','m','a','y',' ','b','e',' ','c','o','l','o','r','e','d','.',' ',' ','F','o','r',' ','e','x','a','m','p','l','e',',',' ','i','f',' ','t','h','e',' ','p','a','r','e','n','t',' ','p','a','t','t','e','r','n',' ','h','a','s',' ','a',' ',
's','t','a','r','t','i','n','g',' ','e','x','p','r','e','s','s','i','o','n',' ','\"','\\','<','\"',',',' ','a','n','d',' ','e','n','d',' ','e','x','p','r','e','s','s','i','o','n',' ','\"','\\','>','\"',',',' ','(','f','o','r',' ','h','i','g','h','l','i','g','h','t','i','n','g',' ',
'a','l','l',' ','o','f',' ','t','h','e',' ','t','e','x','t',' ','c','o','n','t','a','i','n','e','d',' ','w','i','t','h','i','n',' ','a','n','g','l','e',' ','b','r','a','c','k','e','t','s',')',',',' ','a',' ','s','u','b','-','p','a','t','t','e','r','n',' ','u','s','i','n','g',' ',
'\"','\\','0','\"',' ','i','n',' ','b','o','t','h',' ','t','h','e',' ','s','t','a','r','t','i','n','g',' ','a','n','d',' ','e','n','d','i','n','g',' ','e','x','p','r','e','s','s','i','o','n',' ','f','i','e','l','d','s',' ','c','o','u','l','d',' ','c','o','l','o','r',' ','t','h','e',' ',
'b','r','a','c','k','e','t','s',' ','d','i','f','f','e','r','e','n','t','l','y',' ','f','r','o','m',' ','t','h','e',' ','i','n','t','e','r','v','e','n','i','n','g',' ','t','e','x','t','.',' ',' ','A',' ','q','u','i','c','k',' ','s','h','o','r','t','c','u','t',' ','t','o',' ',
't','y','p','i','n','g',' ','i','n',' ','p','a','t','t','e','r','n',' ','n','a','m','e','s',' ','i','n',' ','t','h','e',' ','P','a','r','e','n','t',' ','P','a','t','t','e','r','n',' ','f','i','e','l','d',' ','i','s',' ','t','o',' ','u','s','e',' ','t','h','e',' ',
'm','i','d','d','l','e',' ','m','o','u','s','e',' ','b','u','t','t','o','n',' ','t','o',' ','d','r','a','g',' ','t','h','e','m',' ','f','r','o','m',' ','t','h','e',' ','P','a','t','t','e','r','n','s',' ','l','i','s','t','.','\n',
'\n',
'H','i','e','r','a','r','c','h','i','c','a','l',' ','P','a','t','t','e','r','n','s','\n',
'\n',
'A',' ','h','i','e','r','a','r','c','h','i','c','a','l',' ','s','u','b','-','p','a','t','t','e','r','n',',',' ','i','s',' ','i','d','e','n','t','i','c','a','l',' ','t','o',' ','a',' ','t','o','p',' ','l','e','v','e','l',' ','p','a','t','t','e','r','n',',',' ','b','u','t',' ','i','s',' ',
'i','n','v','o','k','e','d',' ','o','n','l','y',' ','b','e','t','w','e','e','n',' ','t','h','e',' ','b','e','g','i','n','n','i','n','g',' ','a','n','d',' ','e','n','d','i','n','g',' ','e','x','p','r','e','s','s','i','o','n',' ','m','a','t','c','h','e','s',' ','o','f',' ','i','t','s',' ',
'p','a','r','e','n','t',' ','p','a','t','t','e','r','n','.',' ',' ','L','i','k','e',' ','t','h','e',' ','s','u','b','-','e','x','p','r','e','s','s','i','o','n',' ','c','o','l','o','r','i','n','g',' ','p','a','t','t','e','r','n','s',' ','d','i','s','c','u','s','s','e','d',' ',
'a','b','o','v','e',',',' ','i','t',' ','i','s',' ','a','s','s','o','c','i','a','t','e','d',' ','w','i','t','h',' ','a',' ','p','a','r','e','n','t',' ','p','a','t','t','e','r','n',' ','u','s','i','n','g',' ','t','h','e',' ','P','a','r','e','n','t',' ','P','a','t','t','e','r','n',' ',
'f','i','e','l','d',' ','i','n',' ','t','h','e',' ','p','a','t','t','e','r','n',' ','s','p','e','c','i','f','i','c','a','t','i','o','n','.',' ',' ','P','a','t','t','e','r','n',' ','n','a','m','e','s',' ','c','a','n',' ','b','e',' ','d','r','a','g','g','e','d',' ','f','r','o','m',' ',
't','h','e',' ','p','a','t','t','e','r','n',' ','l','i','s','t',' ','w','i','t','h',' ','t','h','e',' ','m','i','d','d','l','e',' ','m','o','u','s','e',' ','b','u','t','t','o','n',' ','t','o',' ','t','h','e',' ','P','a','r','e','n','t',' ','P','a','t','t','e','r','n',' ',
'f','i','e','l','d','.','\n',
'\n',
'A','f','t','e','r',' ','t','h','e',' ','s','t','a','r','t',' ','e','x','p','r','e','s','s','i','o','n',' ','o','f',' ','t','h','e',' ','p','a','r','e','n','t',' ','p','a','t','t','e','r','n',' ','m','a','t','c','h','e','s',',',' ','t','h','e',' ','s','y','n','t','a','x',' ',
'h','i','g','h','l','i','g','h','t','i','n','g',' ','p','a','r','s','e','r',' ','s','e','a','r','c','h','e','s',' ','f','o','r',' ','e','i','t','h','e','r',' ','t','h','e',' ','p','a','r','e','n','t',''','s',' ','e','n','d',' ','p','a','t','t','e','r','n',' ','o','r',' ','a',' ',
'm','a','t','c','h','i','n','g',' ','s','u','b','-','p','a','t','t','e','r','n','.',' ',' ','W','h','e','n',' ','a',' ','s','u','b','-','p','a','t','t','e','r','n',' ','m','a','t','c','h','e','s',',',' ','c','o','n','t','r','o','l',' ','i','s',' ','n','o','t',' ',
'r','e','t','u','r','n','e','d',' ','t','o',' ','t','h','e',' ','p','a','r','e','n','t',' ','p','a','t','t','e','r','n',' ','u','n','t','i','l',' ','t','h','e',' ','e','n','t','i','r','e',' ','s','u','b','-','p','a','t','t','e','r','n',' ','h','a','s',' ','b','e','e','n',' ',
'p','a','r','s','e','d',',',' ','r','e','g','a','r','d','l','e','s','s',' ','o','f',' ','w','h','e','t','h','e','r',' ','t','h','e',' ','p','a','r','e','n','t',''','s',' ','e','n','d',' ','p','a','t','t','e','r','n',' ','a','p','p','e','a','r','s',' ','i','n',' ','t','h','e',' ',
't','e','x','t',' ','m','a','t','c','h','e','d',' ','b','y',' ','t','h','e',' ','s','u','b','-','p','a','t','t','e','r','n','.','\n',
'\n',
'T','h','e',' ','m','o','s','t',' ','c','o','m','m','o','n',' ','u','s','e',' ','f','o','r',' ','t','h','i','s',' ','c','a','p','a','b','i','l','i','t','y',' ','i','s',' ','f','o','r',' ','c','o','l','o','r','i','n','g',' ','s','u','b','-','s','t','r','u','c','t','u','r','e',' ',
'o','f',' ','l','a','n','g','u','a','g','e',' ','c','o','n','s','t','r','u','c','t','s',' ','(','s','m','a','l','l','e','r',' ','p','a','t','t','e','r','n','s',' ','e','m','b','e','d','d','e','d',' ','i','n',' ','l','a','r','g','e','r',' ','p','a','t','t','e','r','n','s',')','.',' ',' ',
'H','i','e','r','a','r','c','h','i','c','a','l',' ','p','a','t','t','e','r','n','s',' ','c','a','n',' ','a','l','s','o',' ','s','i','m','p','l','i','f','y',' ','p','a','r','s','i','n','g',' ','b','y',' ','h','a','v','i','n','g',' ','s','u','b','-','p','a','t','t','e','r','n','s',' ',
'\"','h','i','d','e','\"',' ','s','p','e','c','i','a','l',' ','s','y','n','t','a','x',' ','f','r','o','m',' ','p','a','r','e','n','t',' ','p','a','t','t','e','r','n','s',',',' ','s','u','c','h',' ','a','s',' ','s','p','e','c','i','a','l',' ','e','s','c','a','p','e',' ',
's','e','q','u','e','n','c','e','s',' ','o','r',' ','i','n','t','e','r','n','a','l',' ','c','o','m','m','e','n','t','s','.','\n',
'\n',
'T','h','e','r','e',' ','i','s',' ','n','o',' ','d','e','p','t','h',' ','l','i','m','i','t',' ','i','n',' ','n','e','s','t','i','n','g',' ','h','i','e','r','a','r','c','h','i','c','a','l',' ','s','u','b','-','p','a','t','t','e','r','n','s',',',' ','b','u','t',' ',
'b','e','y','o','n','d',' ','t','h','e',' ','t','h','i','r','d',' ','l','e','v','e','l',' ','o','f',' ','n','e','s','t','i','n','g',',',' ','a','u','t','o','m','a','t','i','c',' ','r','e','-','p','a','r','s','i','n','g',' ','w','i','l','l',' ','s','o','m','e','t','i','m','e','s',' ',
'h','a','v','e',' ','t','o',' ','r','e','-','p','a','r','s','e',' ','m','o','r','e',' ','t','h','a','n',' ','t','h','e',' ','r','e','q','u','e','s','t','e','d',' ','c','o','n','t','e','x','t',' ','d','i','s','t','a','n','c','e',' ','t','o',' ','g','u','a','r','a','n','t','y',' ',
'a',' ','c','o','r','r','e','c','t',' ','p','a','r','s','e',' ','(','w','h','i','c','h',' ','c','a','n',' ','s','l','o','w',' ','d','o','w','n',' ','t','h','e',' ','m','a','x','i','m','u','m',' ','r','a','t','e',' ','a','t',' ','w','h','i','c','h',' ','t','h','e',' ','u','s','e','r',' ',
'c','a','n',' ','t','y','p','e',' ','i','f',' ','l','a','r','g','e',' ','s','e','c','t','i','o','n','s',' ','o','f',' ','t','e','x','t',' ','a','r','e',' ','m','a','t','c','h','e','d',' ','o','n','l','y',' ','b','y',' ','d','e','e','p','l','y',' ','n','e','s','t','e','d',' ',
'p','a','t','t','e','r','n','s',')','.','\n',
'\n',
'W','h','i','l','e',' ','t','h','i','s',' ','i','s',' ','o','b','v','i','o','u','s','l','y',' ','n','o','t',' ','a',' ','c','o','m','p','l','e','t','e',' ','h','i','e','r','a','r','c','h','i','c','a','l',' ','l','a','n','g','u','a','g','e',' ','p','a','r','s','e','r',' ','i','t',' ',
'i','s',' ','s','t','i','l','l',' ','u','s','e','f','u','l',' ','i','n',' ','m','a','n','y',' ','t','e','x','t',' ','c','o','l','o','r','i','n','g',' ','s','i','t','u','a','t','i','o','n','s','.',' ',' ','A','s',' ','a',' ','p','a','t','t','e','r','n',' ','w','r','i','t','e','r',',',' ',
'y','o','u','r',' ','g','o','a','l',' ','i','s',' ','n','o','t',' ','t','o',' ','c','o','m','p','l','e','t','e','l','y',' ','c','o','v','e','r',' ','t','h','e',' ','l','a','n','g','u','a','g','e',' ','s','y','n','t','a','x',',',' ','b','u','t',' ','t','o',' ',
'g','e','n','e','r','a','t','e',' ','c','o','l','o','r','i','n','g','s',' ','t','h','a','t',' ','a','r','e',' ','u','s','e','f','u','l',' ','t','o',' ','t','h','e',' ','p','r','o','g','r','a','m','m','e','r','.',' ',' ','S','i','m','p','l','e','r',' ','p','a','t','t','e','r','n','s',' ',
'a','r','e',' ','u','s','u','a','l','l','y',' ','m','o','r','e',' ','e','f','f','i','c','i','e','n','t',' ','a','n','d',' ','a','l','s','o',' ','m','o','r','e',' ','r','o','b','u','s','t',' ','w','h','e','n',' ','a','p','p','l','i','e','d',' ','t','o',' ',
'i','n','c','o','r','r','e','c','t',' ','c','o','d','e','.','\n',
'\n',
'D','e','f','e','r','r','e','d',' ','(','P','a','s','s','-','2',')',' ','P','a','r','s','i','n','g','\n',
'\n',
'N','E','d','i','t',' ','d','o','e','s',' ','p','a','t','t','e','r','n',' ','m','a','t','c','h','i','n','g',' ','f','o','r',' ','s','y','n','t','a','x',' ','h','i','g','h','l','i','g','h','t','i','n','g',' ','i','n',' ','t','w','o',' ','p','a','s','s','e','s','.',' ',' ','T','h','e',' ',
'f','i','r','s','t',' ','p','a','s','s',' ','i','s',' ','a','p','p','l','i','e','d',' ','t','o',' ','t','h','e',' ','e','n','t','i','r','e',' ','f','i','l','e',' ','w','h','e','n',' ','s','y','n','t','a','x',' ','h','i','g','h','l','i','g','h','t','i','n','g',' ','i','s',' ',
'f','i','r','s','t',' ','t','u','r','n','e','d',' ','o','n',',',' ','a','n','d',' ','t','o',' ','n','e','w',' ','r','a','n','g','e','s',' ','o','f',' ','t','e','x','t',' ','w','h','e','n',' ','t','h','e','y',' ','a','r','e',' ','i','n','i','t','i','a','l','l','y',' ','r','e','a','d',' ',
'o','r',' ','p','a','s','t','e','d',' ','i','n','.',' ',' ','T','h','e',' ','s','e','c','o','n','d',' ','p','a','s','s',' ','i','s',' ','a','p','p','l','i','e','d',' ','o','n','l','y',' ','a','s',' ','n','e','e','d','e','d',' ','w','h','e','n',' ','t','e','x','t',' ','i','s',' ',
'e','x','p','o','s','e','d',' ','(','s','c','r','o','l','l','e','d',' ','i','n',' ','t','o',' ','v','i','e','w',')','.','\n',
'\n',
'I','f',' ','y','o','u',' ','h','a','v','e',' ','a',' ','p','a','r','t','i','c','u','l','a','r','l','y',' ','c','o','m','p','l','e','x',' ','s','e','t',' ','o','f',' ','p','a','t','t','e','r','n','s',',',' ','a','n','d',' ','p','a','r','s','i','n','g',' ','i','s',' ',
'b','e','g','i','n','n','i','n','g',' ','t','o',' ','a','d','d',' ','a',' ','n','o','t','i','c','e','a','b','l','e',' ','d','e','l','a','y',' ','t','o',' ','o','p','e','n','i','n','g',' ','f','i','l','e','s',' ','o','r',' ','o','p','e','r','a','t','i','o','n','s',' ',
'w','h','i','c','h',' ','c','h','a','n','g','e',' ','l','a','r','g','e',' ','r','e','g','i','o','n','s',' ','o','f',' ','t','e','x','t',',',' ','y','o','u',' ','c','a','n',' ','d','e','f','e','r',' ','s','o','m','e',' ','o','f',' ','t','h','a','t',' ','p','a','r','s','i','n','g',' ',
'f','r','o','m',' ','s','t','a','r','t','u','p',' ','t','i','m','e',',',' ','t','o',' ','w','h','e','n',' ','i','t',' ','i','s',' ','a','c','t','u','a','l','l','y',' ','n','e','e','d','e','d',' ','f','o','r',' ','v','i','e','w','i','n','g',' ','t','h','e',' ','t','e','x','t','.',' ',' ',
'D','e','f','e','r','r','e','d',' ','p','a','r','s','i','n','g',' ','c','a','n',' ','o','n','l','y',' ','b','e',' ','u','s','e','d',' ','w','i','t','h',' ','s','i','n','g','l','e',' ','e','x','p','r','e','s','s','i','o','n',' ','p','a','t','t','e','r','n','s',',',' ','o','r',' ',
'b','e','g','i','n','/','e','n','d',' ','p','a','t','t','e','r','n','s',' ','w','h','i','c','h',' ','m','a','t','c','h',' ','e','n','t','i','r','e','l','y',' ','w','i','t','h','i','n',' ','t','h','e',' ','r','e','q','u','e','s','t','e','d',' ','c','o','n','t','e','x','t',' ',
'd','i','s','t','a','n','c','e','.',' ',' ','T','o',' ','d','e','f','e','r',' ','t','h','e',' ','p','a','r','s','i','n','g',' ','o','f',' ','a',' ','p','a','t','t','e','r','n',' ','t','o',' ','w','h','e','n',' ',
't','h','e',' ','t','e','x','t',' ','i','s',' ','e','x','p','o','s','e','d',',',' ','c','l','i','c','k',' ','o','n',' ','t','h','e',' ','P','a','s','s','-','2',' ','p','a','t','t','e','r','n',' ','t','y','p','e',' ','b','u','t','t','o','n',' ','i','n',' ','t','h','e',' ',
'h','i','g','h','l','i','g','h','t',' ','p','a','t','t','e','r','n','s',' ','d','i','a','l','o','g','.','\n',
'\n',
'S','o','m','e','t','i','m','e','s',' ','a',' ','p','a','t','t','e','r','n',' ','c','a','n',''','t',' ','b','e',' ','d','e','f','e','r','r','e','d',',',' ','n','o','t',' ','b','e','c','a','u','s','e',' ','o','f',' ','c','o','n','t','e','x','t',' ',
'r','e','q','u','i','r','e','m','e','n','t','s',',',' ','b','u','t',' ','b','e','c','a','u','s','e',' ','i','t',' ','m','u','s','t',' ','r','u','n',' ','c','o','n','c','u','r','r','e','n','t','l','y',' ','w','i','t','h',' ','p','a','s','s','-','1',' ',
'(','n','o','n','-','d','e','f','e','r','r','e','d',')',' ','p','a','t','t','e','r','n','s','.',' ',' ','I','f',' ','t','h','e','y',' ','d','i','d','n',''','t',' ','r','u','n',' ','c','o','n','c','u','r','r','e','n','t','l','y',',',' ','a',' ','p','a','s','s','-','1',' ',
'p','a','t','t','e','r','n',' ','m','i','g','h','t',' ','i','n','c','o','r','r','e','c','t','l','y',' ','m','a','t','c','h',' ','s','o','m','e',' ','o','f',' ','t','h','e',' ','c','h','a','r','a','c','t','e','r','s',' ','w','h','i','c','h',' ','w','o','u','l','d',' ',
'n','o','r','m','a','l','l','y',' ','b','e',' ','h','i','d','d','e','n',' ','i','n','s','i','d','e',' ','o','f',' ','a',' ','s','e','q','u','e','n','c','e',' ','m','a','t','c','h','e','d',' ','b','y',' ','t','h','e',' ','d','e','f','e','r','r','e','d',' ',
'p','a','t','t','e','r','n','.',' ',' ','F','o','r',' ','e','x','a','m','p','l','e',',',' ','C',' ','h','a','s',' ','c','h','a','r','a','c','t','e','r',' ','c','o','n','s','t','a','n','t','s',' ','e','n','c','l','o','s','e','d',' ','i','n',' ','s','i','n','g','l','e',' ',
'q','u','o','t','e','s','.',' ',' ','T','h','e','s','e',' ','t','y','p','i','c','a','l','l','y',' ','d','o',' ','n','o','t',' ','c','r','o','s','s',' ','l','i','n','e',' ','b','o','u','n','d','a','r','i','e','s',',',' ','m','e','a','n','i','n','g',' ','t','h','e','y',' ','c','a','n',' ',
'b','e',' ','p','a','r','s','e','d',' ','e','n','t','i','r','e','l','y',' ','w','i','t','h','i','n',' ','t','h','e',' ','c','o','n','t','e','x','t',' ','d','i','s','t','a','n','c','e',' ','o','f',' ','t','h','e',' ','C',' ','p','a','t','t','e','r','n',' ','s','e','t',' ','a','n','d',' ',
's','h','o','u','l','d',' ','b','e',' ','g','o','o','d',' ','c','a','n','d','i','d','a','t','e','s',' ','f','o','r',' ','d','e','f','e','r','r','e','d',' ','p','a','r','s','i','n','g','.',' ',' ','H','o','w','e','v','e','r',',',' ','t','h','e','y',' ','c','a','n',''','t',' ','b','e',' ',
'd','e','f','e','r','r','e','d',' ','b','e','c','a','u','s','e',' ','t','h','e','y',' ','c','a','n',' ','c','o','n','t','a','i','n',' ','s','e','q','u','e','n','c','e','s',' ','o','f',' ','c','h','a','r','a','c','t','e','r','s',' ','w','h','i','c','h',' ','c','a','n',' ',
't','r','i','g','g','e','r',' ','p','a','s','s','-','o','n','e',' ','p','a','t','t','e','r','n','s','.',' ','S','p','e','c','i','f','i','c','a','l','l','y',',',' ','t','h','e',' ','s','e','q','u','e','n','c','e',',',' ',''','\\','\"',''',',',' ','c','o','n','t','a','i','n','s',' ',
'a',' ','d','o','u','b','l','e',' ','q','u','o','t','e',' ','c','h','a','r','a','c','t','e','r',',',' ','w','h','i','c','h',' ','w','o','u','l','d',' ','b','e',' ','m','a','t','c','h','e','d',' ','b','y',' ','t','h','e',' ','s','t','r','i','n','g',' ','p','a','t','t','e','r','n',' ',
'a','n','d',' ','i','n','t','e','r','p','r','e','t','e','d',' ','a','s',' ','i','n','t','r','o','d','u','c','i','n','g',' ','a',' ','s','t','r','i','n','g','.','\n',
'\n',
'P','a','t','t','e','r','n',' ','C','o','n','t','e','x','t',' ','R','e','q','u','i','r','e','m','e','n','t','s','\n',
'\n',
'T','h','e',' ','c','o','n','t','e','x','t',' ','r','e','q','u','i','r','e','m','e','n','t','s',' ','o','f',' ','a',' ','p','a','t','t','e','r','n',' ','s','e','t',' ','s','t','a','t','e',' ','h','o','w',' ','m','u','c','h',' ','a','d','d','i','t','i','o','n','a','l',' ',
't','e','x','t',' ','a','r','o','u','n','d',' ','a','n','y',' ','c','h','a','n','g','e',' ','m','u','s','t',' ','b','e',' ','e','x','a','m','i','n','e','d',' ','t','o',' ','g','u','a','r','a','n','t','y',' ','t','h','a','t',' ',
't','h','e',' ','p','a','t','t','e','r','n','s',' ','w','i','l','l',' ','m','a','t','c','h',' ','w','h','a','t',' ','t','h','e','y',' ','a','r','e',' ','i','n','t','e','n','d','e','d',' ','t','o',' ','m','a','t','c','h','.',' ',' ','C','o','n','t','e','x','t',' ',
'r','e','q','u','i','r','e','m','e','n','t','s',' ','a','r','e',' ','a',' ','p','r','o','m','i','s','e',' ','b','y',' ','N','E','d','i','t',' ','t','o',' ','t','h','e',' ','p','a','t','t','e','r','n',' ','w','r','i','t','e','r',',',' ','t','h','a','t',' ','t','h','e',' ',
'r','e','g','u','l','a','r',' ','e','x','p','r','e','s','s','i','o','n','s',' ','i','n',' ','h','i','s','/','h','e','r',' ','p','a','t','t','e','r','n','s',' ','w','i','l','l',' ','b','e',' ','m','a','t','c','h','e','d',' ','a','g','a','i','n','s','t',' ','a','t',' ',
'l','e','a','s','t',' ','<','l','i','n','e',' ','c','o','n','t','e','x','t','>',' ','l','i','n','e','s',' ','a','n','d',' ','<','c','h','a','r','a','c','t','e','r',' ','c','o','n','t','e','x','t','>',' ','c','h','a','r','a','c','t','e','r','s',',',' ','a','r','o','u','n','d',' ',
'a','n','y',' ','m','o','d','i','f','i','e','d',' ','t','e','x','t','.',' ',' ','C','o','m','b','i','n','i','n','g',' ','l','i','n','e',' ','a','n','d',' ','c','h','a','r','a','c','t','e','r',' ','r','e','q','u','i','r','e','m','e','n','t','s',' ','g','u','a','r','a','n','t','y',' ',
't','h','a','t',' ','b','o','t','h',' ','w','i','l','l',' ','b','e',' ','m','e','t','.','\n',
'\n',
'A','u','t','o','m','a','t','i','c',' ','r','e','-','p','a','r','s','i','n','g',' ','h','a','p','p','e','n','s',' ','o','n',' ','E','V','E','R','Y',' ','K','E','Y','S','T','R','O','K','E',',',' ','s','o',' ','t','h','e',' ','a','m','o','u','n','t',' ','o','f',' ',
'c','o','n','t','e','x','t',' ','w','h','i','c','h',' ','m','u','s','t',' ','b','e',' ','e','x','a','m','i','n','e','d',' ','i','s',' ','v','e','r','y',' ','c','r','i','t','i','c','a','l',' ','t','o',' ','t','y','p','i','n','g',' ','e','f','f','i','c','i','e','n','c','y','.',' ',' ',
'T','h','e',' ','m','o','r','e',' ','c','o','m','p','l','i','c','a','t','e','d',' ','y','o','u','r',' ','p','a','t','t','e','r','n','s',',',' ','t','h','e',' ','m','o','r','e',' ','c','r','i','t','i','c','a','l',' ','t','h','e',' ','c','o','n','t','e','x','t',' ',
'b','e','c','o','m','e','s','.',' ',' ','T','o',' ','c','o','v','e','r',' ','a','l','l',' ','o','f',' ','t','h','e',' ','k','e','y','w','o','r','d','s',' ','i','n',' ','a',' ','t','y','p','i','c','a','l',' ','l','a','n','g','u','a','g','e',',',' ','w','i','t','h','o','u','t',' ',
'a','f','f','e','c','t','i','n','g',' ','t','h','e',' ','m','a','x','i','m','u','m',' ','r','a','t','e',' ','a','t',' ','w','h','i','c','h',' ','u','s','e','r','s',' ','c','a','n',' ','e','n','t','e','r',' ','t','e','x','t',',',' ','y','o','u',' ','m','a','y',' ','b','e',' ',
'l','i','m','i','t','e','d',' ','t','o',' ','j','u','s','t',' ','a',' ','f','e','w',' ','l','i','n','e','s',' ','a','n','d','/','o','r',' ','a',' ','f','e','w',' ','h','u','n','d','r','e','d',' ','c','h','a','r','a','c','t','e','r','s',' ','o','f',' ','c','o','n','t','e','x','t','.','\n',
'\n',
'T','h','e',' ','d','e','f','a','u','l','t',' ','c','o','n','t','e','x','t',' ','d','i','s','t','a','n','c','e',' ','i','s',' ','1',' ','l','i','n','e',',',' ','w','i','t','h',' ','n','o',' ','m','i','n','i','m','u','m',' ','c','h','a','r','a','c','t','e','r',' ',
'r','e','q','u','i','r','e','m','e','n','t','.',' ',' ','T','h','e','r','e',' ','a','r','e',' ','s','e','v','e','r','a','l',' ','b','e','n','e','f','i','t','s',' ','t','o',' ','s','t','i','c','k','i','n','g',' ','w','i','t','h',' ','t','h','i','s',' ',
'd','e','f','a','u','l','t','.',' ',' ','O','n','e',' ','i','s',' ','s','i','m','p','l','y',' ','t','h','a','t',' ','i','t',' ','i','s',' ','e','a','s','y',' ','t','o',' ','u','n','d','e','r','s','t','a','n','d',' ','a','n','d',' ','t','o',' ','c','o','m','p','l','y',' ',
'w','i','t','h','.',' ',' ','R','e','g','u','l','a','r',' ','e','x','p','r','e','s','s','i','o','n',' ','n','o','t','a','t','i','o','n',' ','i','s',' ','d','e','s','i','g','n','e','d',' ','a','r','o','u','n','d',' ','s','i','n','g','l','e',' ','l','i','n','e',' ',
'm','a','t','c','h','i','n','g','.',' ',' ','T','o',' ','s','p','a','n',' ','l','i','n','e','s',' ','i','n',' ','a',' ','r','e','g','u','l','a','r',' ','e','x','p','r','e','s','s','i','o','n',',',' ','y','o','u',' ','m','u','s','t',' ','e','x','p','l','i','c','i','t','l','y',' ',
'm','e','n','t','i','o','n',' ','t','h','e',' ','n','e','w','l','i','n','e',' ','c','h','a','r','a','c','t','e','r',' ','\"','\\','n','\"',',',' ','a','n','d',' ','m','a','t','c','h','e','s',' ','w','h','i','c','h',' ','a','r','e',' ','r','e','s','t','r','i','c','t','e','d',' ','t','o',' ',
'a',' ','s','i','n','g','l','e',' ','l','i','n','e',' ','a','r','e',' ','v','i','r','t','u','a','l','l','y',' ','i','m','m','u','n','e',' ','t','o',' ','l','o','c','k','-','u','p','s','.',' ',' ','A','l','s','o',',',' ','i','f',' ','y','o','u',' ','c','a','n',' ','c','o','d','e',' ',
'y','o','u','r',' ','p','a','t','t','e','r','n','s',' ','t','o',' ','w','o','r','k',' ','w','i','t','h','i','n',' ','a',' ','s','i','n','g','l','e',' ','l','i','n','e',' ','o','f',' ','c','o','n','t','e','x','t',',',' ','w','i','t','h','o','u','t',' ','a','n',' ',
'a','d','d','i','t','i','o','n','a','l',' ','c','h','a','r','a','c','t','e','r','-','r','a','n','g','e',' ','c','o','n','t','e','x','t',' ','r','e','q','u','i','r','e','m','e','n','t',',',' ','t','h','e',' ','p','a','r','s','e','r',' ','c','a','n',' ','t','a','k','e',' ',
'a','d','v','a','n','t','a','g','e',' ','t','h','e',' ','f','a','c','t',' ','t','h','a','t',' ','p','a','t','t','e','r','n','s',' ','d','o','n',''','t',' ','c','r','o','s','s',' ','l','i','n','e',' ','b','o','u','n','d','a','r','i','e','s',',',' ','a','n','d',' ',
'n','e','a','r','l','y',' ','d','o','u','b','l','e',' ','i','t','s',' ','e','f','f','i','c','i','e','n','c','y',' ','o','v','e','r',' ','a',' ','o','n','e','-','l','i','n','e',' ','a','n','d',' ','1','-','c','h','a','r','a','c','t','e','r',' ','c','o','n','t','e','x','t',' ',
'r','e','q','u','i','r','e','m','e','n','t','.',' ',' ','(','I','n',' ','a',' ','s','i','n','g','l','e',' ','l','i','n','e',' ','c','o','n','t','e','x','t',',',' ','y','o','u',' ','a','r','e',' ','a','l','l','o','w','e','d',' ','t','o',' ','m','a','t','c','h',' ',
'n','e','w','l','i','n','e','s',',',' ','b','u','t',' ','o','n','l','y',' ','a','s',' ','t','h','e',' ','f','i','r','s','t',' ','a','n','d','/','o','r',' ','l','a','s','t',' ','c','h','a','r','a','c','t','e','r','.',')','\0'};

static char AuxString27[] = {'S','m','a','r','t',' ','i','n','d','e','n','t',' ','m','a','c','r','o','s',' ','c','a','n',' ','b','e',' ','w','r','i','t','t','e','n',' ','f','o','r',' ','a','n','y',' ','l','a','n','g','u','a','g','e',',',' ','b','u','t',' ','a','r','e',' ','u','s','u','a','l','l','y',' ',
'm','o','r','e',' ','d','i','f','f','i','c','u','l','t',' ','t','o',' ','w','r','i','t','e',' ','t','h','a','n',' ','h','i','g','h','l','i','g','h','t','i','n','g',' ','p','a','t','t','e','r','n','s','.',' ',' ','A',' ','g','o','o','d',' ','p','l','a','c','e',' ','t','o',' ','s','t','a','r','t',',',' ',
'o','f',' ','c','o','u','r','s','e',',',' ','i','s',' ','t','o',' ','l','o','o','k',' ','a','t',' ','t','h','e',' ','e','x','i','s','t','i','n','g',' ','m','a','c','r','o','s',' ','f','o','r',' ','C',' ','a','n','d',' ','C','+','+','.','\n',
'\n',
'S','m','a','r','t',' ','i','n','d','e','n','t',' ','m','a','c','r','o','s',' ','f','o','r',' ','a',' ','l','a','n','g','u','a','g','e',' ','m','o','d','e',' ','c','o','n','s','i','s','t',' ','o','f',' ','s','t','a','n','d','a','r','d',' ','N','E','d','i','t',' ','m','a','c','r','o',' ',
'l','a','n','g','u','a','g','e',' ','c','o','d','e',' ','a','t','t','a','c','h','e','d',' ','t','o',' ','a','n','y',' ','o','r',' ','a','l','l',' ','o','f',' ','t','h','e',' ','f','o','l','l','o','w','i','n','g',' ','t','h','r','e','e',' ','a','c','t','i','v','a','t','i','o','n',' ',
'c','o','n','d','i','t','i','o','n','s',':',' ',
'1',')',' ','W','h','e','n',' ','s','m','a','r','t',' ','i','n','d','e','n','t',' ','i','s',' ','f','i','r','s','t',' ','t','u','r','n','e','d',' ','o','n',' ','f','o','r',' ','a',' ','t','e','x','t',' ','w','i','n','d','o','w',' ','c','o','n','t','a','i','n','i','n','g',' ','c','o','d','e',' ',
'o','f',' ','t','h','e',' ','l','a','n','g','u','a','g','e',',',' ','2',')',' ','W','h','e','n',' ','a',' ','n','e','w','l','i','n','e',' ','i','s',' ','t','y','p','e','d',' ','a','n','d',' ','s','m','a','r','t',' ','i','n','d','e','n','t',' ','i','s',' ','e','x','p','e','c','t','e','d',',',' ','3',')',' ',
'a','f','t','e','r',' ','a','n','y',' ','c','h','a','r','a','c','t','e','r',' ','i','s',' ','t','y','p','e','d','.',' ',' ','T','o',' ','a','t','t','a','c','h',' ','m','a','c','r','o',' ','c','o','d','e',' ','t','o',' ','a','n','y',' ','o','f',' ','t','h','e','s','e',' ','c','o','d','e',' ',
'\"','h','o','o','k','s','\"',',',' ','e','n','t','e','r',' ','i','t',' ','i','n',' ','t','h','e',' ','a','p','p','r','o','p','r','i','a','t','e',' ','s','e','c','t','i','o','n',' ','i','n',' ','t','h','e',' ','P','r','e','f','e','r','e','n','c','e','s',' ','-','>',' ',
'D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s',' ','-','>',' ','A','u','t','o',' ','I','n','d','e','n','t',' ','-','>',' ','P','r','o','g','r','a','m',' ','S','m','a','r','t',' ','I','n','d','e','n','t',' ','d','i','a','l','o','g','.','\n',
'\n',
'T','y','p','i','c','a','l','l','y',' ','m','o','s','t',' ','o','f',' ','t','h','e',' ','c','o','d','e',' ','s','h','o','u','l','d',' ','g','o',' ','i','n',' ','t','h','e',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','s','e','c','t','i','o','n',',',' ','b','e','c','a','u','s','e',' ',
't','h','a','t',' ','i','s',' ','t','h','e',' ','a','p','p','r','o','p','r','i','a','t','e',' ','p','l','a','c','e',' ','f','o','r',' ','s','u','b','r','o','u','t','i','n','e',' ','d','e','f','i','n','i','t','i','o','n','s',',',' ','a','n','d',' ','s','m','a','r','t',' ','i','n','d','e','n','t',' ',
'm','a','c','r','o','s',' ','a','r','e',' ','c','o','m','p','l','i','c','a','t','e','d',' ','e','n','o','u','g','h',' ','t','h','a','t',' ','y','o','u',' ','a','r','e',' ','n','o','t',' ','l','i','k','e','l','y',' ','t','o',' ','w','a','n','t',' ','t','o',' ','w','r','i','t','e',' ','t','h','e','m',' ',
'a','s',' ','o','n','e',' ','m','o','n','o','l','i','t','h','i','c',' ','r','u','n',' ','o','f',' ','c','o','d','e','.',' ',' ','Y','o','u',' ','m','a','y',' ','a','l','s','o',' ','p','u','t',' ','c','o','d','e',' ','i','n',' ','t','h','e',' ','C','o','m','m','o','n','/','S','h','a','r','e','d',' ',
'I','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','s','e','c','t','i','o','n',' ','(','a','c','c','e','s','s','i','b','l','e',' ','t','h','r','o','u','g','h',' ','t','h','e',' ','b','u','t','t','o','n',' ','i','n',' ','t','h','e',' ','u','p','p','e','r',' ','l','e','f','t',' ',
'c','o','r','n','e','r',' ','o','f',' ','t','h','e',' ','d','i','a','l','o','g',')','.',' ',' ','U','n','f','o','r','t','u','n','a','t','e','l','y',',',' ','s','i','n','c','e',' ','t','h','e',' ','C','/','C','+','+',' ','m','a','c','r','o','s',' ','a','l','s','o',' ','r','e','s','i','d','e',' ',
'i','n',' ','t','h','e',' ','c','o','m','m','o','n','/','s','h','a','r','e','d',' ','s','e','c','t','i','o','n',',',' ','w','h','e','n',' ','y','o','u',' ','a','d','d',' ','c','o','d','e',' ','t','h','e','r','e',',',' ','y','o','u',' ','r','u','n',' ','s','o','m','e',' ','r','i','s','k',' ','o','f',' ',
'm','i','s','s','i','n','g',' ','o','u','t',' ','o','n',' ','f','u','t','u','r','e',' ',
'u','p','g','r','a','d','e','s',' ','t','o',' ','t','h','e','s','e',' ','m','a','c','r','o','s',',',' ','b','e','c','a','u','s','e',' ','y','o','u','r',' ','c','h','a','n','g','e','s',' ','w','i','l','l',' ','o','v','e','r','r','i','d','e',' ','t','h','e',' ','b','u','i','l','t','-','i','n',' ',
'd','e','f','a','u','l','t','s','.','\n',
'\n',
'T','h','e',' ','n','e','w','l','i','n','e',' ','m','a','c','r','o',' ','i','s',' ','i','n','v','o','k','e','d',' ','a','f','t','e','r',' ','t','h','e',' ','u','s','e','r',' ','t','y','p','e','s',' ','a',' ','n','e','w','l','i','n','e',',',' ','b','u','t',' ','b','e','f','o','r','e',' ','t','h','e',' ',
'n','e','w','l','i','n','e',' ','i','s',' ','e','n','t','e','r','e','d',' ','i','n',' ','t','h','e',' ','b','u','f','f','e','r','.',' ',' ','I','t',' ','t','a','k','e','s',' ','a',' ','s','i','n','g','l','e',' ','a','r','g','u','m','e','n','t',' ','(','$','1',')',' ','w','h','i','c','h',' ','i','s',' ',
't','h','e',' ','p','o','s','i','t','i','o','n',' ','a','t',' ','w','h','i','c','h',' ','t','h','e',' ','n','e','w','l','i','n','e',' ','w','i','l','l',' ','b','e',' ','i','n','s','e','r','t','e','d','.',' ',' ','I','t',' ','m','u','s','t',' ','r','e','t','u','r','n',' ','t','h','e',' ',
'n','u','m','b','e','r',' ','o','f',' ','c','h','a','r','a','c','t','e','r','s',' ','o','f',' ','i','n','d','e','n','t','a','t','i','o','n',' ','t','h','e',' ','l','i','n','e',' ','s','h','o','u','l','d',' ','h','a','v','e',',',' ','o','r',' ','-','1','.',' ',' ','A',' ',
'r','e','t','u','r','n',' ','v','a','l','u','e',' ','o','f',' ','-','1',' ','m','e','a','n','s',' ','t','o',' ','d','o',' ','a',' ','s','t','a','n','d','a','r','d',' ','a','u','t','o','-','i','n','d','e','n','t','.',' ',' ','Y','o','u',' ','m','u','s','t',' ','s','u','p','p','l','y',' ',
'a',' ','n','e','w','l','i','n','e',' ','m','a','c','r','o',',',' ','b','u','t',' ','t','h','e',' ','c','o','d','e',':',' ','\"','r','e','t','u','r','n',' ','-','1','\"',' ','(','a','u','t','o','-','i','n','d','e','n','t',')',',',' ','o','r',' ','\"','r','e','t','u','r','n',' ','0','\"',' ',
'(','n','o',' ','i','n','d','e','n','t',')',' ','i','s',' ','s','u','f','f','i','c','i','e','n','t','.','\n',
'\n',
'T','h','e',' ','t','y','p','e','-','i','n',' ','m','a','c','r','o',' ','t','a','k','e','s',' ','t','w','o',' ','a','r','g','u','m','e','n','t','s','.',' ',' ','$','1',' ','i','s',' ','t','h','e',' ','i','n','s','e','r','t',' ','p','o','s','i','t','i','o','n',',',' ','a','n','d',' ','$','2',' ','i','s',' ',
't','h','e',' ','c','h','a','r','a','c','t','e','r',' ','j','u','s','t',' ','i','n','s','e','r','t','e','d',',',' ','a','n','d',' ','d','o','e','s',' ','n','o','t',' ','r','e','t','u','r','n',' ','a',' ','v','a','l','u','e','.',' ',' ','Y','o','u',' ','c','a','n',' ','d','o',' ','j','u','s','t',' ',
'a','b','o','u','t',' ','a','n','y','t','h','i','n','g',' ','h','e','r','e',',',' ','b','u','t',' ','k','e','e','p',' ','i','n',' ','m','i','n','d',' ','t','h','a','t',' ','t','h','i','s',' ','m','a','c','r','o',' ','i','s',' ','e','x','e','c','u','t','e','d',' ','f','o','r',' ','e','v','e','r','y',' ',
'k','e','y','s','t','r','o','k','e',' ','t','y','p','e','d',',',' ','s','o',' ','i','f',' ','y','o','u',' ','t','r','y',' ','t','o',' ','g','e','t',' ','t','o','o',' ','f','a','n','c','y',',',' ','y','o','u',' ','m','a','y',' ','d','e','g','r','a','d','e',' ','p','e','r','f','o','r','m','a','n','c','e','.','\0'};

static char AuxString28[] = {'S','O','L','U','T','I','O','N','S',' ','T','O',' ','C','O','M','M','O','N',' ','P','R','O','B','L','E','M','S','\n',
'\n',
'P',':',' ','N','o',' ','f','i','l','e','s',' ','a','r','e',' ','s','h','o','w','n',' ','i','n',' ','t','h','e',' ','\"','F','i','l','e','s','\"',' ','l','i','s','t',' ','i','n',' ','t','h','e',' ','O','p','e','n','.','.','.',' ','d','i','a','l','o','g','.','\n',
'S',':',' ','W','h','e','n',' ','y','o','u',' ','u','s','e',' ','t','h','e',' ','\"','F','i','l','t','e','r','\"',' ','f','i','e','l','d',',',' ','i','n','c','l','u','d','e',' ','t','h','e',' ','f','i','l','e',' ','s','p','e','c','i','f','i','c','a','t','i','o','n',' ','o','r',' ','a',' ',
'c','o','m','p','l','e','t','e',' ','d','i','r','e','c','t','o','r','y',' ','s','p','e','c','i','f','i','c','a','t','i','o','n',',',' ','i','n','c','l','u','d','i','n','g',' ','t','h','e',' ','t','r','a','i','l','i','n','g',' ','\"','/','\"',' ','o','n',' ','U','n','i','x','.',' ',' ',
'(','S','e','e',' ','H','e','l','p',' ','i','n',' ','t','h','e',' ','O','p','e','n','.','.','.',' ','d','i','a','l','o','g',')','.','\n',
'\n',
'P',':',' ','K','e','y','b','o','a','r','d',' ','s','h','o','r','t','c','u','t','s',' ','f','o','r',' ','m','e','n','u',' ','i','t','e','m','s',' ','d','o','n',''','t',' ','w','o','r','k','.','\n',
'S',':',' ','B','e',' ','s','u','r','e',' ','t','h','e',' ','C','a','p','s',' ','L','o','c','k',' ','a','n','d',' ','N','u','m',' ','L','o','c','k',' ','k','e','y','s',' ','a','r','e',' ','b','o','t','h',' ','u','n','l','o','c','k','e','d','.',' ',' ','I','n',' ','M','o','t','i','f',' ',
'p','r','o','g','r','a','m','s',',',' ','t','h','e','s','e',' ','k','e','y','s',' ','p','r','e','v','e','n','t',' ','t','h','e',' ','m','e','n','u',' ','a','c','c','e','l','e','r','a','t','o','r','s',' ','f','r','o','m',' ','w','o','r','k','i','n','g','.','\n',
'\n',
'P',':',' ','F','i','n','d',' ','A','g','a','i','n',' ','a','n','d',' ','R','e','p','l','a','c','e',' ','A','g','a','i','n',' ','d','o','n',''','t',' ','c','o','n','t','i','n','u','e',' ','i','n',' ','t','h','e',' ','s','a','m','e',' ','d','i','r','e','c','t','i','o','n',' ',
'a','s',' ','t','h','e',' ','o','r','i','g','i','n','a','l',' ','F','i','n','d',' ','o','r',' ','R','e','p','l','a','c','e','.','\n',
'S',':',' ','F','i','n','d',' ','A','g','a','i','n',' ','a','n','d',' ','R','e','p','l','a','c','e',' ','A','g','a','i','n',' ','d','o','n',''','t',' ','u','s','e',' ','t','h','e',' ','d','i','r','e','c','t','i','o','n',' ','o','f',' ','t','h','e',' ','o','r','i','g','i','n','a','l',' ',
's','e','a','r','c','h','.',' ',' ','T','h','e',' ','S','h','i','f','t',' ','k','e','y',' ','c','o','n','t','r','o','l','s',' ','t','h','e',' ','d','i','r','e','c','t','i','o','n',':',' ','C','t','r','l','+','G',' ','m','e','a','n','s',' ',
'f','o','r','w','a','r','d',',',' ','S','h','i','f','t','+','C','t','r','l','+','G',' ','m','e','a','n','s',' ','b','a','c','k','w','a','r','d','.','\n',
'\n',
'P',':',' ','P','r','e','f','e','r','e','n','c','e','s',' ','s','p','e','c','i','f','i','e','d',' ','i','n',' ','t','h','e',' ','P','r','e','f','e','r','e','n','c','e','s',' ','m','e','n','u',' ','d','o','n',''','t',' ','s','e','e','m',' ','t','o',' ','g','e','t',' ','s','a','v','e','d',' ',
'w','h','e','n',' ','I',' ','s','e','l','e','c','t',' ','S','a','v','e',' ','D','e','f','a','u','l','t','s','.','\n',
'S',':',' ','N','E','d','i','t',' ','h','a','s',' ','t','w','o',' ','k','i','n','d','s',' ','o','f',' ','p','r','e','f','e','r','e','n','c','e','s',':',' ','1',')',' ','p','e','r','-','w','i','n','d','o','w',' ','p','r','e','f','e','r','e','n','c','e','s',',',' ','i','n',' ','t','h','e',' ',
'P','r','e','f','e','r','e','n','c','e','s',' ','m','e','n','u',',',' ','a','n','d',' ','2',')',' ','d','e','f','a','u','l','t',' ','s','e','t','t','i','n','g','s',' ','f','o','r',' ','p','r','e','f','e','r','e','n','c','e','s',' ','i','n',' ','n','e','w','l','y',' ','c','r','e','a','t','e','d',' ',
'w','i','n','d','o','w','s',',',' ','i','n',' ','t','h','e',' ','D','e','f','a','u','l','t',' ',
'S','e','t','t','i','n','g','s',' ','s','u','b','-','m','e','n','u',' ','o','f',' ','t','h','e',' ','P','r','e','f','e','r','e','n','c','e','s',' ','m','e','n','u','.',' ',' ','P','e','r','-','w','i','n','d','o','w',' ','p','r','e','f','e','r','e','n','c','e','s',' ','a','r','e',' ','n','o','t',' ',
's','a','v','e','d',' ','b','y',' ','S','a','v','e',' ','D','e','f','a','u','l','t','s',',',' ','o','n','l','y',' ','D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s','.','\n',
'\n',
'P',':',' ','C','o','l','u','m','n','s',' ','a','n','d',' ','i','n','d','e','n','t','a','t','i','o','n',' ','d','o','n',''','t',' ','l','i','n','e',' ','u','p','.','\n',
'S',':',' ','N','E','d','i','t',' ','i','s',' ','u','s','i','n','g',' ','a',' ','p','r','o','p','o','r','t','i','o','n','a','l',' ','w','i','d','t','h',' ','f','o','n','t','.',' ',' ','S','e','t',' ','t','h','e',' ','f','o','n','t',' ','t','o',' ','a',' ','f','i','x','e','d',' ','s','t','y','l','e',' ',
'(','s','e','e',' ','P','r','e','f','e','r','e','n','c','e','s',')','.','\n',
'\n',
'P',':',' ','N','E','d','i','t',' ','p','e','r','f','o','r','m','s',' ','p','o','o','r','l','y',' ','o','n',' ','v','e','r','y',' ','l','a','r','g','e',' ','f','i','l','e','s','.','\n',
'S',':',' ','T','u','r','n',' ','o','f','f',' ','I','n','c','r','e','m','e','n','t','a','l',' ','B','a','c','k','u','p','.',' ',' ','W','i','t','h',' ','I','n','c','r','e','m','e','n','t','a','l',' ','B','a','c','k','u','p',' ','o','n',',',' ','N','E','d','i','t',' ',
'p','e','r','i','o','d','i','c','a','l','l','y',' ','w','r','i','t','e','s',' ','a',' ','f','u','l','l',' ','c','o','p','y',' ','o','f',' ','t','h','e',' ','f','i','l','e',' ','t','o',' ','d','i','s','k','.','\n',
'\n',
'P',':',' ','C','o','m','m','a','n','d','s',' ','a','d','d','e','d',' ','t','o',' ','t','h','e',' ','S','h','e','l','l',' ','C','o','m','m','a','n','d','s',' ','m','e','n','u',' ','(','U','n','i','x',' ','o','n','l','y',')',' ','d','o','n',''','t',' ','o','u','t','p','u','t',' ',
'a','n','y','t','h','i','n','g',' ','u','n','t','i','l',' ','t','h','e','y',' ','a','r','e',' ','f','i','n','i','s','h','e','d',' ','e','x','e','c','u','t','i','n','g','.','\n',
'S',':',' ','I','f',' ','t','h','e',' ','c','o','m','m','a','n','d',' ','o','u','t','p','u','t',' ','i','s',' ',
'd','i','r','e','c','t','e','d',' ','t','o',' ','a',' ','d','i','a','l','o','g',',',' ','o','r',' ','t','h','e',' ','i','n','p','u','t',' ','i','s',' ','f','r','o','m',' ','a',' ','s','e','l','e','c','t','i','o','n',',',' ','o','u','t','p','u','t',' ','i','s',' ','c','o','l','l','e','c','t','e','d',' ',
't','o','g','e','t','h','e','r',' ','a','n','d',' ','h','e','l','d',' ','u','n','t','i','l',' ','t','h','e',' ','c','o','m','m','a','n','d',' ','c','o','m','p','l','e','t','e','s','.',' ',' ','D','e','-','s','e','l','e','c','t',' ','b','o','t','h',' ','o','f',' ','t','h','e',' ','o','p','t','i','o','n','s',' ',
'a','n','d',' ','t','h','e',' ','o','u','t','p','u','t',' ','w','i','l','l',' ','b','e',' ','s','h','o','w','n',' ','i','n','c','r','e','m','e','n','t','a','l','l','y',' ','a','s',' ','t','h','e',' ','c','o','m','m','a','n','d',' ','e','x','e','c','u','t','e','s','.','\n',
'\n',
'P',':',' ','D','i','a','l','o','g','s',' ','d','o','n',''','t',' ','a','u','t','o','m','a','t','i','c','a','l','l','y',' ','g','e','t',' ','k','e','y','b','o','a','r','d',' ','f','o','c','u','s',' ','w','h','e','n',' ','t','h','e','y',' ','p','o','p',' ','u','p','.','\n',
'S',':',' ','M','o','s','t',' ','X',' ','W','i','n','d','o','w',' ','m','a','n','a','g','e','r','s',' ','a','l','l','o','w',' ','y','o','u',' ','t','o',' ','c','h','o','o','s','e',' ','b','e','t','w','e','e','n',' ','t','w','o',' ','c','a','t','e','g','o','r','i','e','s',' ','o','f',' ',
'k','e','y','b','o','a','r','d',' ','f','o','c','u','s',' ','m','o','d','e','l','s',':',' ','p','o','i','n','t','e','r',' ','f','o','c','u','s',',',' ','a','n','d',' ','e','x','p','l','i','c','i','t',' ','f','o','c','u','s','.',' ',' ',
'P','o','i','n','t','e','r',' ','f','o','c','u','s',' ','m','e','a','n','s',' ','t','h','a','t',' ','a','s',' ','y','o','u',' ','m','o','v','e',' ','t','h','e',' ','m','o','u','s','e',' ','a','r','o','u','n','d',' ','t','h','e',' ','s','c','r','e','e','n',',',' ','t','h','e',' ','w','i','n','d','o','w',' ',
'u','n','d','e','r',' ','t','h','e',' ','m','o','u','s','e',' ','a','u','t','o','m','a','t','i','c','a','l','l','y',' ','g','e','t','s',' ','t','h','e',' ','k','e','y','b','o','a','r','d',' ','f','o','c','u','s','.',' ',' ','N','E','d','i','t',' ','u','s','e','r','s',' ','w','h','o',' ','u','s','e',' ',
't','h','i','s',' ','f','o','c','u','s',' ','m','o','d','e','l',' ','s','h','o','u','l','d',' ','s','e','t',' ','\"','P','o','p','u','p','s',' ','U','n','d','e','r',' ','P','o','i','n','t','e','r','\"',' ','i','n',' ','t','h','e',' ','D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s',' ',
's','u','b',' ','m','e','n','u',' ','o','f',' ','t','h','e',' ','p','r','e','f','e','r','e','n','c','e','s',' ','m','e','n','u',' ','i','n',' ','N','E','d','i','t','.',' ',' ','U','s','e','r','s',' ','w','i','t','h',' ','t','h','e',' ','e','x','p','l','i','c','i','t',' ',
'f','o','c','u','s',' ','m','o','d','e','l',',',' ','i','n',' ','s','o','m','e',' ','c','a','s','e','s',',',' ','m','a','y',' ','h','a','v','e',' ','p','r','o','b','l','e','m','s',' ','w','i','t','h',' ','c','e','r','t','a','i','n',' ','d','i','a','l','o','g','s',',',' ','s','u','c','h',' ','a','s',' ',
'F','i','n','d',' ','a','n','d',' ','R','e','p','l','a','c','e','.',' ',' ','I','n',' ','M','W','M',' ','t','h','i','s',' ','i','s',' ','c','a','u','s','e','d',' ','b','y',' ','t','h','e',' ','m','w','m',' ','r','e','s','o','u','r','c','e',' ','s','t','a','r','t','u','p','K','e','y','F','o','c','u','s',' ',
'b','e','i','n','g',' ','s','e','t',' ','t','o',' ','F','a','l','s','e',' ','(','g','e','n','e','r','a','l','l','y',' ','a',' ','b','a','d',' ','c','h','o','i','c','e',' ','f','o','r',' ','e','x','p','l','i','c','i','t',' ','f','o','c','u','s',' ','u','s','e','r','s',')','.',' ',' ',
'N','C','D','w','m',' ','u','s','e','r','s',' ','s','h','o','u','l','d',' ','u','s','e',' ','t','h','e',' ','f','o','c','u','s',' ','m','o','d','e','l',' ','\"','c','l','i','c','k','\"',' ',
'i','n','s','t','e','a','d',' ','o','f',' ','\"','e','x','p','l','i','c','i','t','\"',',',' ','a','g','a','i','n',',',' ','u','n','l','e','s','s',' ','y','o','u',' ','h','a','v','e',' ','s','e','t',' ','i','t',' ','t','h','a','t',' ','w','a','y',' ','t','o',' ','c','o','r','r','e','c','t',' ',
's','p','e','c','i','f','i','c',' ','p','r','o','b','l','e','m','s',',',' ','t','h','i','s',' ','i','s',' ','t','h','e',' ','a','p','p','r','o','p','r','i','a','t','e',' ','s','e','t','t','i','n','g',' ','f','o','r',' ','m','o','s','t',' ',
'e','x','p','l','i','c','i','t',' ','f','o','c','u','s',' ','u','s','e','r','s','.','\n',
'\n',
'P',':',' ','T','h','e',' ','D','e','l','e','t','e',' ','k','e','y',' ','d','o','e','s','n',''','t',' ','f','o','r','w','a','r','d','-','d','e','l','e','t','e','.','\n',
'S',':',' ','S','e','e',' ','t','h','e',' ','X',' ','R','e','s','o','u','r','c','e','s',' ','s','e','c','t','i','o','n',' ','o','n',' ','n','e','d','i','t','.','r','e','m','a','p','D','e','l','e','t','e','K','e','y','.','\n',
'\n',
'P',':',' ','N','E','d','i','t',' ','c','r','a','s','h','e','s',' ','w','h','e','n',' ','I',' ','t','r','y',' ','t','o',' ','p','a','s','t','e',' ','t','e','x','t',' ','i','n',' ','t','o',' ','a',' ','t','e','x','t',' ','f','i','e','l','d',' ','i','n',' ','a',' ','d','i','a','l','o','g',' ',
'(','l','i','k','e',' ','F','i','n','d',' ','o','r',' ','R','e','p','l','a','c','e',')',' ','o','n',' ','m','y',' ','S','u','n','O','S',' ','s','y','s','t','e','m','.','\n',
'S',':',' ','O','n',' ','m','a','n','y',' ','S','u','n','O','S',' ','s','y','s','t','e','m','s',',',' ','y','o','u',' ','h','a','v','e',' ','t','o',' ','s','e','t',' ','u','p',' ','a','n',' ','n','l','s',' ','d','i','r','e','c','t','o','r','y',' ','b','e','f','o','r','e',' ',
'v','a','r','i','o','u','s',' ','i','n','t','e','r','-','c','l','i','e','n','t',' ','c','o','m','m','u','n','i','c','a','t','i','o','n',' ','f','e','a','t','u','r','e','s',' ','o','f',' ','M','o','t','i','f',' ','w','i','l','l',' ','f','u','n','c','t','i','o','n',' ',
'p','r','o','p','e','r','l','y','.',' ',' ','T','h','e','r','e',' ','a','r','e',' ','i','n','s','t','r','u','c','t','i','o','n','s',' ','i','n',' ','R','E','A','D','M','E','.','s','u','n',' ','i','n',' ','/','p','u','b','/','n','e','d','i','t','/','v','4','_','0','_','1',' ','o','n',' ',
'f','t','p','.','f','n','a','l','.','g','o','v',',',' ','a','s',' ','w','e','l','l',' ','a','s',' ','a',' ','t','a','r',' ','f','i','l','e',' ','c','o','n','t','a','i','n','g',' ','a',' ','c','o','m','p','l','e','t','e',' ','n','l','s',' ',
'd','i','r','e','c','t','o','r','y',':',' ','f','t','p',':','/','/','f','t','p','.','f','n','a','l','.','g','o','v','/','p','u','b','/','n','e','d','i','t','/','v','4','_','0','_','2','/','i','n','d','i','v','i','d','u','a','l','/','R','E','A','D','M','E','.','s','u','n','.',' ',
'T','h','i','s',' ','c','o','n','t','a','i','n','s',' ','d','i','r','e','c','t','i','o','n','s',' ','f','o','r',' ','s','e','t','t','i','n','g',' ','u','p',' ','a','n',' ','n','l','s',' ','d','i','r','e','c','t','o','r','y',',',' ','w','h','i','c','h',' ','i','s',' ',
'r','e','q','u','i','r','e','d',' ','b','y',' ','M','o','t','i','f',' ','f','o','r',' ','h','a','n','d','l','i','n','g',' ','c','o','p','y',' ','a','n','d',' ','p','a','s','t','e',' ','t','o',' ','M','o','t','i','f',' ','t','e','x','t',' ','f','i','e','l','d','s','.',' ',
'\n',
'\n',
'K','N','O','W','N',' ','B','U','G','S','\n',
'\n',
'B','e','l','o','w',' ','i','s',' ','t','h','e',' ','l','i','s','t',' ','o','f',' ','k','n','o','w','n',' ','b','u','g','s',' ','w','h','i','c','h',' ','a','f','f','e','c','t',' ','N','E','d','i','t','.',' ',' ','T','h','e',' ','b','u','g','s',' ','y','o','u','r',' ','c','o','p','y',' ',
'o','f',' ','N','E','d','i','t',' ','w','i','l','l',' ','e','x','h','i','b','i','t',' ','d','e','p','e','n','d',' ','o','n',' ','w','h','i','c','h',' ','s','y','s','t','e','m',' ','y','o','u',' ','a','r','e',' ','r','u','n','n','i','n','g',' ','a','n','d',' ','w','i','t','h',' ','w','h','i','c','h',' ',
'M','o','t','i','f',' ','l','i','b','r','a','r','i','e','s',' ','i','t',' ','w','a','s',' ','b','u','i','l','t','.',' ','N','o','t','e',' ','t','h','a','t',' ','t','h','e','r','e',' ','a','r','e',' ','n','o','w',' ','M','o','t','i','f',' ','1','.','2',' ','a','n','d','/','o','r',' ','2','.','0',' ',
'l','i','b','r','a','r','i','e','s',' ','a','v','a','i','l','a','b','l','e',' ','o','n',' ','A','L','L',' ','s','u','p','p','o','r','t','e','d',' ','p','l','a','t','f','o','r','m','s',',',' ','a','n','d',' ','a','s',' ','y','o','u',' ','c','a','n',' ','s','e','e',' ','b','e','l','o','w',' ',
't','h','e','r','e',' ','a','r','e',' ','f','a','r',' ','f','e','w','e','r',' ','b','u','g','s',' ','i','n',' ','M','o','t','i','f',' ','1','.','2',',',' ','s','o',' ','i','t',' ','i','s',' ','i','n',' ','y','o','u','r',' ','b','e','s','t',' ','i','n','t','e','r','e','s','t',' ','t','o',' ',
'u','p','g','r','a','d','e',' ','y','o','u','r',' ','s','y','s','t','e','m','.','\n',
'\n',
'A','l','l',' ','V','e','r','s','i','o','n','s','\n',
'\n',
'B','U','G',':',' ','O','p','e','r','a','t','i','o','n','s',' ','b','e','t','w','e','e','n',' ','r','e','c','t','a','n','g','u','l','a','r',' ','s','e','l','e','c','t','i','o','n','s',' ','o','n',' ','o','v','e','r','l','a','p','p','i','n','g',' ','l','i','n','e','s',' ',
'd','o',' ','n','o','t','h','i','n','g','.','\n',
'W','O','R','K','A','R','O','U','N','D',':',' ','N','o','n','e','.',' ',' ','T','h','e','s','e',' ','o','p','e','r','a','t','i','o','n','s',' ','a','r','e',' ',
'v','e','r','y',' ','c','o','m','p','l','i','c','a','t','e','d',' ','a','n','d',' ','r','a','r','e','l','y',' ','u','s','e','d','.','\n',
'\n',
'B','U','G',':',' ','C','u','t',' ','a','n','d',' ','P','a','s','t','e',' ','m','e','n','u',' ','i','t','e','m','s',' ','f','a','i','l',',',' ','o','r',' ','p','o','s','s','i','b','l','y',' ','c','r','a','s','h',',',' ','f','o','r',' ','v','e','r','y',' ','l','a','r','g','e',' ',
'(','m','u','l','t','i','-','m','e','g','a','b','y','t','e',')',' ','s','e','l','e','c','t','i','o','n','s','.','\n',
'W','O','R','K','A','R','O','U','N','D',':',' ','U','s','e',' ','s','e','l','e','c','t','i','o','n',' ','c','o','p','y',' ','(','m','i','d','d','l','e',' ','m','o','u','s','e',' ','b','u','t','t','o','n',' ','c','l','i','c','k',')',' ','f','o','r',' ','t','r','a','n','s','f','e','r','r','i','n','g',' ',
'l','a','r','g','e','r',' ','q','u','a','n','t','i','t','i','e','s',' ','o','f',' ','d','a','t','a','.',' ',' ','C','u','t',' ','a','n','d',' ','P','a','s','t','e',' ','s','a','v','e',' ','t','h','e',' ','c','o','p','i','e','d',' ','t','e','x','t',' ','i','n',' ','s','e','r','v','e','r',' ',
'm','e','m','o','r','y',',',' ','w','h','i','c','h',' ','i','s',' ','u','s','u','a','l','l','y',' ','l','i','m','i','t','e','d','.','\n',
'\n',
'M','o','t','i','f',' ','1','.','1',' ','V','e','r','s','i','o','n','s','\n',
'\n',
'B','U','G',':',' ','T','h','e',' ','s','h','o','r','t','c','u','t',' ','m','e','t','h','o','d',' ','f','o','r',' ','e','n','t','e','r','i','n','g',' ','c','o','n','t','r','o','l',' ','c','h','a','r','a','c','t','e','r','s',' ','(','A','l','t','+','C','t','r','l','+','c','h','a','r',')',' ','i','s',' ',
'n','o','t',' ','a','v','a','i','l','a','b','l','e','.','\n',
'W','O','R','K','A','R','O','U','N','D',':',' ','U','s','e',' ','t','h','e',' ','I','n','s','.',' ','C','o','n','t','r','o','l',' ','C','h','a','r',' ','c','o','m','m','a','n','d','.','\n',
'\n',
'B','U','G',':',' ','P','o','p','-','u','p',' ','d','i','a','l','o','g','s',' ','\"','j','u','m','p','\"',' ','(','a','p','p','e','a','r',' ','b','r','i','e','f','l','y',' ','i','n',' ','a',' ','d','i','f','f','e','r','e','n','t',' ','l','o','c','a','t','i','o','n',')',' ','w','h','e','n',' ',
't','h','e','y',' ','a','r','e',' ','f','i','r','s','t',' ','i','n','v','o','k','e','d','.','\n',
'W','O','R','K','A','R','O','U','N','D',':',' ','T','u','r','n',' ','o','f','f',' ','\"','P','o','p','u','p','s',' ','U','n','d','e','r',' ','P','o','i','n','t','e','r','\"',' ','i','f',' ','t','h','i','s',' ','g','i','v','e','s',' ','y','o','u',' ','a',' ','h','e','a','d','a','c','h','e','.','\n',
'\n',
'I','B','M',' ','V','e','r','s','i','o','n','s',' ','b','u','i','l','t',' ','w','i','t','h',' ','M','o','t','i','f',' ','1','.','1','\n',
'\n',
'B','U','G',':',' ','T','h','e',' ','C','o','m','m','a','n','d',' ','t','o',' ','s','e','t',' ','t','h','e',' ','f','o','n','t',' ','f','o','r',' ','t','h','e',' ','c','u','r','r','e','n','t',' ','w','i','n','d','o','w',' ','i','s',' ','n','o','t',' ',
'a','v','a','i','l','a','b','l','e','.','\n',
'W','O','R','K','A','R','O','U','N','D',':',' ','U','s','e',' ','t','h','e',' ','D','e','f','a','u','l','t',' ','S','e','t','t','i','n','g','s',' ','s','u','b','-','m','e','n','u',' ','t','o',' ','s','e','t',' ','t','h','e',' ','d','e','f','a','u','l','t',' ',
'f','o','n','t',' ','a','n','d',' ','t','h','e','n',' ','c','r','e','a','t','e',' ','a',' ','n','e','w',' ','w','i','n','d','o','w','.','\n',
'\n',
'B','U','G',':',' ','N','E','d','i','t',' ','c','a','n',' ','o','c','c','a','s','i','o','n','a','l','l','y',' ','c','r','a','s','h',' ','o','n',' ','w','i','n','d','o','w',' ','c','l','o','s','i','n','g','.','\n',
'W','O','R','K','A','R','O','U','N','D',':',' ','S','a','v','e',' ','f','i','l','e','s',' ','f','r','e','q','u','e','n','t','l','y',',',' ','s','e','e',' ','C','r','a','s','h',' ','R','e','c','o','v','e','r','y','.','\n',
'\n',
'V','M','S',' ','V','e','r','s','i','o','n','s','\n',
'\n',
'B','U','G','S',':',' ','1','.',' ','A','b','b','r','e','v','i','a','t','i','o','n',' ','o','f',' ','c','o','m','m','a','n','d',' ','l','i','n','e',' ','q','u','a','l','i','f','i','e','r','s',' ','i','s',' ','n','o','t',' ','a','l','l','o','w','e','d','.',' ',' ','2','.',' ',
'E','r','r','o','r',' ','m','e','s','s','a','g','e','s',' ','f','o','r',' ','m','i','s','t','a','k','e','s',' ','o','n',' ','t','h','e',' ','c','o','m','m','a','n','d',' ','l','i','n','e',' ','d','o','n',''','t',' ','m','a','k','e',' ','s','e','n','s','e','.','\n',
'W','O','R','K','A','R','O','U','N','D',':',' ','N','E','d','i','t',' ','d','o','e','s',' ','n','o','t',' ','p','a','r','s','e',' ','i','t','s',' ','c','o','m','m','a','n','d',' ','l','i','n','e',' ','w','i','t','h',' ','t','h','e',' ','s','t','a','n','d','a','r','d',' ','D','C','L',' ',
'c','o','m','m','a','n','d',' ','p','a','r','s','e','r',',',' ','i','n','s','t','e','a','d',',',' ','i','t',' ','s','u','p','e','r','f','i','c','i','a','l','l','y',' ','c','o','n','v','e','r','t','s',' ','t','h','e',' ','c','o','m','m','a','n','d',' ','l','i','n','e',' ','t','o',' ',
'a',' ','U','n','i','x','-','s','t','y','l','e',' ','c','o','m','m','a','n','d',' ','l','i','n','e',' ','b','e','f','o','r','e',' ','p','r','o','c','e','s','s','i','n','g',' ','i','t','.',' ',' ','B','e','c','a','u','s','e',' ','i','n','f','o','r','m','a','t','i','o','n',' ',
'i','s',' ','l','o','s','t',',',' ','N','E','d','i','t',' ','m','a','y',' ','n','o','t',' ','a','l','w','a','y','s',' ','b','e',' ','a','b','l','e',' ','t','o',' ',
'd','i','s','t','i','n','g','u','i','s','h',' ','b','e','t','w','e','e','n',' ','i','t','e','m','s',' ','t','h','a','t',' ','a','r','e',' ','s','u','p','p','o','s','e','d',' ','t','o',' ','b','e',' ','q','u','a','l','i','f','i','e','r','s',' ','a','n','d',' ','t','h','o','s','e',' ',
'w','h','i','c','h',' ','a','r','e',' ','s','u','p','p','o','s','e','d',' ','t','o',' ','b','e',' ','f','i','l','e','s',' ','a','n','d',' ','a','r','g','u','m','e','n','t','s',' ','t','o',' ','t','h','e',' ','q','u','a','l','i','f','i','e','r','s','.',' ',' ',
'H','o','w','e','v','e','r',',',' ','c','o','r','r','e','c','t',' ','V','M','S',' ','c','o','m','m','a','n','d',' ','l','i','n','e','s',' ','a','r','e',' ','a','l','w','a','y','s',' ','p','r','o','c','e','s','s','e','d',' ','c','o','r','r','e','c','t','l','y',',',' ','a','n','d',' ','o','n','l','y',' ',
'c','e','r','t','a','i','n',' ','t','y','p','e','s',' ','o','f',' ','e','r','r','o','r','s',' ','w','i','l','l',' ','a','p','p','e','a','r',' ','t','o',' ','g','i','v','e',' ','s','t','r','a','n','g','e',' ','r','e','s','u','l','t','s','.','\n',
'\n',
'B','U','G',':',' ','P','r','o','t','e','c','t','i','o','n',' ','s','e','t','t','i','n','g','s',' ','f','o','r',' ','n','e','w',' ','v','e','r','s','i','o','n','s',' ','o','f',' ','f','i','l','e','s',' ','p','r','o','d','u','c','e','d',' ','b','y',' ','N','E','d','i','t',' ','o','v','e','r',' ',
'D','E','C','N','E','T',' ','c','o','n','n','e','c','t','i','o','n','s',' ','m','a','y',' ','r','e','v','e','r','t',' ','t','o',' ','d','e','f','a','u','l','t','s','.','\n',
'W','O','R','K','A','R','O','U','N','D',':',' ','C','h','e','c','k',' ','a','n','d',' ','r','e','s','e','t',' ','p','r','o','t','e','c','t','i','o','n','s',' ','w','h','e','n',' ','a','c','c','e','s','s','i','n','g',' ','f','i','l','e','s',' ','v','i','a',' ','D','E','C','N','E','T','.','\n',
'\n',
'\n',
'S','e','n','d',' ','q','u','e','s','t','i','o','n','s',' ','a','n','d',' ','c','o','m','m','e','n','t','s',' ','t','o',':',' ','n','e','d','i','t','_','s','u','p','p','o','r','t','@','f','n','a','l','.','g','o','v','.','\0'};

static char AuxString29[] = {'T','h','e','r','e',' ','a','r','e',' ','t','w','o',' ','s','e','p','a','r','a','t','e',' ','m','a','i','l','i','n','g',' ','l','i','s','t','s',' ','f','o','r',' ','N','E','d','i','t',' ','u','s','e','r','s','.',' ',' ',
'n','e','d','i','t','_','d','i','s','c','u','s','s',',',' ','a','s',' ','t','h','e',' ','n','a','m','e',' ','i','m','p','l','i','e','s',',',' ','i','s',' ','f','o','r',' ','o','p','e','n',' ','d','i','s','c','u','s','s','i','o','n',' ',
'a','m','o','n','g',' ','N','E','d','i','t',' ','u','s','e','r','s','.',' ',' ','n','e','d','i','t','_','a','n','n','o','u','n','c','e','s',' ','i','n','t','e','n','d','e','d',' ','t','o',' ','b','e',' ',
'a',' ','v','e','r','y',' ','l','o','w',' ','v','o','l','u','m','e',' ','m','a','i','l','i','n','g',' ','l','i','s','t',' ','f','o','r',' ','a','n','n','o','u','n','c','e','m','e','n','t',' ','o','f',' ','n','e','w',' ','v','e','r','s','i','o','n','s',',',' ','n','e','w',' ',
'e','x','e','c','u','t','a','b','l','e','s',',',' ','a','n','d',' ','s','i','g','n','i','f','i','c','a','n','t',' ','c','o','n','t','r','i','b','u','t','e','d',' ','s','o','f','t','w','a','r','e','.','\n',
'\n',
'T','o',' ','s','u','b','s','c','r','i','b','e',' ','t','o',' ','n','e','d','i','t','_','d','i','s','c','u','s','s',',',' ','s','e','n','d',' ','a',' ','m','e','s','s','a','g','e',' ','c','o','n','t','a','i','n','i','n','g',' ','t','h','e',' ','f','o','l','l','o','w','i','n','g',' ',
'l','i','n','e',' ','i','n',' ','t','h','e',' ','b','o','d','y',' ','o','f',' ','t','h','e',' ','m','e','s','s','a','g','e',' ','(','n','o','t',' ','t','h','e',' ','s','u','b','j','e','c','t',')',' ','t','o',' ','m','a','i','l','s','e','r','v','@','f','n','a','l','.','g','o','v',':','\n',
'\n',
' ',' ',' ',' ','s','u','b','s','c','r','i','b','e',' ','n','e','d','i','t','_','d','i','s','c','u','s','s','\n',
'\n',
'T','o',' ','s','u','b','s','c','r','i','b','e',' ','t','o',' ','n','e','d','i','t','_','a','n','n','o','u','n','c','e',',',' ','s','e','n','d',' ','a',' ','s','e','p','a','r','a','t','e',' ','m','e','s','s','a','g','e',' ','t','o',' ',
'm','a','i','l','s','e','r','v','@','f','n','a','l','.','g','o','v',' ','c','o','n','t','a','i','n','i','n','g',' ','t','h','e',' ','l','i','n','e',':','\n',
'\n',
' ',' ',' ',' ','s','u','b','s','c','r','i','b','e',' ','n','e','d','i','t','_','a','n','n','o','u','n','c','e','\n',
'\n',
'T','o',' ','u','n','s','u','b','s','c','r','i','b','e',',',' ','s','e','n','d',':','\n',
'\n',
' ',' ',' ',' ','u','n','s','u','b','s','c','r','i','b','e',' ','n','e','d','i','t','_','d','i','s','c','u','s','s',' ','(','o','r',' ','n','e','d','i','t','_','a','n','n','o','u','n','c','e',')','\n',
'\n',
'A','f','t','e','r',' ','s','u','b','s','c','r','i','b','i','n','g',',',' ','y','o','u',' ','w','i','l','l',' ','r','e','c','e','i','v','e',' ','c','o','p','i','e','s',' ','o','f',' ','a','l','l',' ','o','f',' ','t','h','e',' ','e','m','a','i','l',' ','s','u','b','m','i','t','t','e','d',' ',
't','o',' ','t','h','e',' ','l','i','s','t','.',' ',' ','Y','o','u',' ','m','a','y',' ','s','u','b','m','i','t',' ','m','a','i','l',' ','t','o',' ','t','h','e',' ','d','i','s','c','u','s','s','i','o','n',' ','l','i','s','t',' ','b','y',' ','s','e','n','d','i','n','g',' ','i','t',' ','t','o',':','\n',
'\n',
' ',' ',' ',' ','n','e','d','i','t','_','d','i','s','c','u','s','s','@','f','n','a','l','.','g','o','v','\n',
'\n',
'U','s','e','r','s',' ','a','r','e',' ','a','l','l','o','w','e','d',' ','t','o',' ','p','o','s','t',' ','t','o',' ','n','e','d','i','t','_','a','n','n','o','u','n','c','e',' ','a','s',' ','w','e','l','l',' ','(','j','u','s','t',' ','m','a','k','e',' ','s','u','r','e',' ','t','h','a','t',' ',
't','h','e',' ','c','o','n','t','e','n','t',' ','i','s',' ','a','p','p','r','o','p','r','i','a','t','e',')','.','\0'};

static char AuxString30[] = {'I','N','F','O','R','M','A','T','I','O','N','/','L','I','C','E','N','S','E',' ','A','G','R','E','E','M','E','N','T',' ','F','O','R',' ','N','E','D','I','T','.','\n',
'\n',
'F','e','r','m','i','T','o','o','l','s',' ','S','o','f','t','w','a','r','e',' ','L','e','g','a','l',' ','I','n','f','o','r','m','a','t','i','o','n',' ','-',' ','N','o','v','e','m','b','e','r',' ','1',',',' ','1','9','9','6','\n',
'\n',
'C','O','P','Y','R','I','G','H','T',' ','S','T','A','T','U','S',':',' ',' ','F','e','r','m','i',' ','N','a','t','i','o','n','a','l',' ','A','c','c','e','l','e','r','a','t','o','r',' ','L','a','b','o','r','a','t','o','r','y',' ',
'(','F','N','A','L',')',' ','d','o','c','u','m','e','n','t','s',' ','a','r','e',' ','s','p','o','n','s','o','r','e','d',' ','b','y',' ','t','h','e',' ','U','.','S','.',' ','D','e','p','a','r','t','m','e','n','t',' ','o','f',' ',
'E','n','e','r','g','y',' ','u','n','d','e','r',' ','C','o','n','t','r','a','c','t',' ','N','o','.',' ','D','E','-','A','C','0','2','-','7','6','C','H','0','3','0','0','0','.',' ',' ','T','h','e','r','e','f','o','r','e',',',' ','t','h','e',' ',
'U','.','S','.',' ','G','o','v','e','r','n','m','e','n','t',' ','r','e','t','a','i','n','s',' ','a',' ','n','o','n','-','e','x','c','l','u','s','i','v','e',',',' ','r','o','y','a','l','t','y','-','f','r','e','e',' ','l','i','c','e','n','s','e',' ',
't','o',' ','p','u','b','l','i','s','h',' ','o','r',' ','r','e','p','r','o','d','u','c','e',' ','t','h','e','s','e',' ','d','o','c','u','m','e','n','t','s',' ','o','r',' ','s','o','f','t','w','a','r','e',' ','f','o','r',' ','U','.','S','.',' ',
'G','o','v','e','r','n','m','e','n','t',' ','p','u','r','p','o','s','e','s','.',' ',' ','A','l','l',' ','d','o','c','u','m','e','n','t','s',' ','a','n','d',' ','s','o','f','t','w','a','r','e',' ','a','v','a','i','l','a','b','l','e',' ',
'f','r','o','m',' ','F','N','A','L',' ','a','r','e',' ','p','r','o','t','e','c','t','e','d',' ','u','n','d','e','r',' ','t','h','e',' ','U','.','S','.',' ','a','n','d',' ','F','o','r','e','i','g','n',' ','C','o','p','y','r','i','g','h','t',' ',
'L','a','w','s',',',' ','a','n','d',' ','F','N','A','L',' ','r','e','s','e','r','v','e','s',' ','a','l','l',' ','r','i','g','h','t','s','.','\n',
'\n',
'T','e','r','m','s',' ','a','n','d',' ','C','o','n','d','i','t','i','o','n','s','\n',
'\n',
'W','h','e','n',' ','a',' ','U','s','e','r',' ','d','i','s','t','r','i','b','u','t','e','s',' ','o','r',' ','o','t','h','e','r','w','i','s','e',' ','o','b','t','a','i','n','s',' ','a',' ','s','o','f','t','w','a','r','e',' ',
'p','a','c','k','a','g','e',' ','i','n','c','l','u','d','e','d',' ','i','n',' ','t','h','e',' ','F','e','r','m','i','l','a','b',' ','S','o','f','t','w','a','r','e',' ','T','o','o','l','s',' ','P','r','o','g','r','a','m',',',' ','t','h','e',' ',
'u','s','e','r',' ','a','g','r','e','e','s',' ','t','o',' ','a','b','i','d','e',' ','b','y',' ','t','h','e',' ','T','e','r','m','s',' ','a','n','d',' ','C','o','n','d','i','t','i','o','n','s',' ','o','f',' ','t','h','e',' ',
'P','r','o','g','r','a','m',' ','b','e','l','o','w',':','\n',
'\n',
'',' ',' ',' ',' ',' ',' ',' ','A','n','y',' ','r','e','d','i','s','t','r','i','b','u','t','i','o','n',' ','o','f',' ','t','h','e',' ','s','o','f','t','w','a','r','e',' ','s','h','a','l','l',' ','b','e',' ','a','c','c','o','m','p','a','n','i','e','d',' ',
'b','y',' ','t','h','i','s',' ','I','N','F','O','R','M','A','T','I','O','N','/','L','I','C','E','N','S','E',' ','A','G','R','E','E','M','E','N','T',' ','a','n','d',' ','t','h','e',' ','p','r','o','d','u','c','t',''','s',' ',
'O','R','I','G','I','N',' ','S','T','A','T','E','M','E','N','T',' ','(','b','e','l','o','w',')','.','\n',
'\n',
'',' ',' ',' ',' ',' ',' ',' ','T','h','e',' ','U','s','e','r',' ','s','h','a','l','l',' ','a','c','k','n','o','w','l','e','d','g','e',' ','t','h','e',' ','o','r','i','g','i','n',' ','o','f',' ','t','h','e',' ','s','o','f','t','w','a','r','e',' ','a','s',' ',
's','e','t',' ','f','o','r','t','h',' ','b','e','l','o','w',':','\n',
'\n',
' ',' ',' ',' ',' ',' ',' ',' ','\"','T','h','i','s',' ','w','o','r','k',' ','w','a','s',' ','p','e','r','f','o','r','m','e','d',' ','a','t',' ','F','e','r','m','i',' ','N','a','t','i','o','n','a','l',' ','A','c','c','e','l','e','r','a','t','o','r',' ',
'L','a','b','o','r','a','t','o','r','y',',',' ','o','p','e','r','a','t','e','d',' ','b','y',' ','U','n','i','v','e','r','s','i','t','i','e','s',' ','R','e','s','e','a','r','c','h',' ','A','s','s','o','c','i','a','t','i','o','n',',',' ',
'I','n','c','.',',',' ','u','n','d','e','r',' ','c','o','n','t','r','a','c','t',' ','D','E','-','A','C','0','2','-','7','6','C','H','0','3','0','0','0',' ','w','i','t','h',' ','t','h','e',' ','U','.','S','.',' ',
'D','e','p','a','r','t','m','e','n','t',' ','o','f',' ','E','n','e','r','g','y','.','\"','\n',
'\n',
'',' ',' ',' ',' ',' ',' ',' ','T','h','e',' ','u','s','e','r',' ','i','s',' ','a','s','k','e','d',' ','t','o',' ','f','e','e','d',' ','b','a','c','k',' ','p','r','o','b','l','e','m','s',',',' ','b','e','n','e','f','i','t','s',',',' ',
'a','n','d','/','o','r',' ','s','u','g','g','e','s','t','i','o','n','s',' ','a','b','o','u','t',' ','t','h','e',' ','s','o','f','t','w','a','r','e',' ','t','o',' ','t','h','e',' ','F','e','r','m','i','l','a','b',' ',
'S','o','f','t','w','a','r','e',' ','P','r','o','v','i','d','e','r','s',' ','a','n','d','/','o','r',' ','F','e','r','m','i','T','o','o','l','s',' ','m','a','n','a','g','e','m','e','n','t','.','\n',
'\n',
'',' ',' ',' ',' ',' ',' ',' ','A','n','y',' ','d','i','s','t','r','i','b','u','t','i','o','n',' ','o','f',' ','t','h','i','s',' ','s','o','f','t','w','a','r','e',' ','s','h','a','l','l',' ','b','e',' ','a','t',' ','n','o',' ','c','h','a','r','g','e','.',' ',
'T','o',' ','o','b','t','a','i','n',' ','a',' ','l','i','c','e','n','s','e',' ','t','o',' ','c','o','m','m','e','r','c','i','a','l','i','z','e',' ','a','n','y',' ','o','f',' ','t','h','e',' ','s','o','f','t','w','a','r','e',' ',
'p','r','o','g','r','a','m','s',' ','a','v','a','i','l','a','b','l','e',' ','f','r','o','m',' ','F','e','r','m','i','l','a','b',' ','i','n','c','l','u','d','i','n','g',' ','t','h','i','s',' ','s','o','f','t','w','a','r','e',',',' ',
'c','o','n','t','a','c','t',' ','F','N','A','L',''','s',' ','O','f','f','i','c','e',' ','o','f',' ','R','e','s','e','a','r','c','h',' ','a','n','d',' ','T','e','c','h','n','o','l','o','g','y',' ',
'A','p','p','l','i','c','a','t','i','o','n','s',',',' ','P','.','O','.',' ','B','o','x',' ','5','0','0',',',' ','M','S','-','2','0','0',',',' ','B','a','t','a','v','i','a',',',' ','I','L',' ','6','0','5','1','0','-','0','5','0','0','.','\n',
'\n',
'\n',
'I','N','D','E','M','N','I','F','I','C','A','T','I','O','N',' ','B','Y',' ','U','S','E','R',' ','O','F',' ','T','H','I','R','D',' ','P','A','R','T','Y',' ','C','L','A','I','M','S',' ','A','N','D',' ',
'D','I','S','C','L','O','S','U','R','E',' ','O','F',' ','L','I','A','B','I','L','I','T','Y','\n',
'\n',
'T','h','e',' ','U','s','e','r',',',' ','h','i','s','/','h','e','r',' ','d','i','r','e','c','t','o','r','s',',',' ','o','f','f','i','c','e','r','s',',',' ','e','m','p','l','o','y','e','e','s',',',' ','a','n','d',' ',
'a','g','e','n','t','s',' ','h','e','r','e','b','y',' ','r','e','l','e','a','s','e',' ','a','n','d',' ','w','a','i','v','e',' ','a','l','l',' ','c','l','a','i','m','s',' ','a','g','a','i','n','s','t',' ',
'U','n','i','v','e','r','s','i','t','i','e','s',' ','R','e','s','e','a','r','c','h',' ','A','s','s','o','c','i','a','t','i','o','n',',',' ','I','n','c','.',' ','(','U','R','A',')',' ','o','p','e','r','a','t','o','r',' ',
'o','f',' ','F','e','r','m','i',' ','N','a','t','i','o','n','a','l',' ','A','c','c','e','l','e','r','a','t','o','r',' ','L','a','b','o','r','a','t','o','r','y',',',' ','i','t','s',' ',
't','r','u','s','t','e','e','s',',',' ','o','v','e','r','s','e','e','r','s',',',' ','d','i','r','e','c','t','o','r','s',',',' ','o','f','f','i','c','e','r','s',',',' ','e','m','p','l','o','y','e','e','s',',',' ',
'a','g','e','n','t','s',',',' ','s','u','b','c','o','n','t','r','a','c','t','o','r','s',',',' ','s','u','c','c','e','s','s','o','r','s',' ','a','n','d',' ','a','s','s','i','g','n','s',',',' ','f','o','r',' ',
'a','n','y',' ','a','n','d',' ','a','l','l',' ','l','i','a','b','i','l','i','t','y',' ','a','n','d',' ','d','a','m','a','g','e','s',' ','a','r','i','s','i','n','g',' ','f','r','o','m',' ','t','h','e',' ',
'r','e','p','r','o','d','u','c','t','i','o','n',',',' ','u','s','e',' ','o','r',' ','o','t','h','e','r',' ','d','i','s','p','o','s','i','t','i','o','n',' ','o','f',' ','t','h','e',' ',
's','o','f','t','w','a','r','e','.',' ',' ','T','h','e',' ','U','s','e','r',' ','s','h','a','l','l',' ','i','n','d','e','m','n','i','f','y',' ','U','R','A',' ','a','n','d',' ','t','h','e',' ','U','.','S','.',' ',
'G','o','v','e','r','n','m','e','n','t',' ','f','o','r',' ','a','l','l',' ','d','a','m','a','g','e','s',',',' ','c','o','s','t','s',' ','o','r',' ','e','x','p','e','n','s','e','s',',',' ',
'i','n','c','l','u','d','i','n','g',' ','a','t','t','o','r','n','e','y',''','s',' ','f','e','e','s',',',' ','a','r','i','s','i','n','g',' ','f','r','o','m',' ','t','h','e',' ',
'u','t','i','l','i','z','a','t','i','o','n',' ','o','f',' ','t','h','e',' ','s','o','f','t','w','a','r','e',',',' ','i','n','c','l','u','d','i','n','g',',',' ','b','u','t',' ','n','o','t',' ',
'l','i','m','i','t','e','d',' ','t','o',',',' ','t','h','e',' ','m','a','k','i','n','g',',',' ','u','s','i','n','g',',',' ','s','e','l','l','i','n','g',' ','o','r',' ','e','x','p','o','r','t','i','n','g',' ','o','f',' ',
'p','r','o','d','u','c','t','s',',',' ','p','r','o','c','e','s','s','e','s',' ','o','r',' ','s','e','r','v','i','c','e','s',' ','d','e','r','i','v','e','d',' ','f','r','o','m',' ','t','h','e',' ',
'S','o','f','t','w','a','r','e','.',' ',' ','T','h','e',' ','U','s','e','r',' ','a','g','r','e','e','s',' ','t','o',' ','i','n','d','e','m','n','i','f','y',',',' ','h','o','l','d',' ','h','a','r','m','l','e','s','s',' ',
'a','n','d',' ','d','e','f','e','n','d',' ','U','R','A',',',' ','i','t','s',' ','t','r','u','s','t','e','e','s',',',' ','o','v','e','r','s','e','e','r','s',',',' ','d','i','r','e','c','t','o','r','s',',',' ',
'o','f','f','i','c','e','r','s',',',' ','e','m','p','l','o','y','e','e','s',',',' ','a','g','e','n','t','s',',',' ','s','u','b','c','o','n','t','r','a','c','t','o','r','s',',',' ',
's','u','c','c','e','s','s','o','r','s',' ','a','n','d',' ','a','s','s','i','g','n','s',',',' ','a','g','a','i','n','s','t',' ','a','n','y',' ','a','n','d',' ','a','l','l',' ','l','i','a','b','i','l','i','t','y',',',' ',
'd','a','m','a','g','e',',',' ','l','o','s','s',',',' ','c','o','s','t',',',' ','c','h','a','r','g','e',',',' ','c','l','a','i','m',',',' ','d','e','m','a','n','d',',',' ','f','e','e',' ','o','r',' ',
'e','x','p','e','n','s','e',' ','o','f',' ','e','v','e','r','y',' ','n','a','t','u','r','e',' ','a','n','d',' ','k','i','n','d',' ','w','h','i','c','h',' ','m','a','y',' ','a','t',' ','a','n','y',' ','t','i','m','e',' ',
'h','e','r','e','a','f','t','e','r',',',' ','b','e',' ','s','u','s','t','a','i','n','e','d',' ','b','y',' ','U','R','A',' ','b','y',' ','r','e','a','s','o','n',' ','o','f',' ','c','l','a','i','m','s',' ','o','f',' ',
't','h','i','r','d',' ','p','a','r','t','i','e','s',' ','a','r','i','s','i','n','g',' ','o','u','t',' ','o','f',' ','a','l','l','e','g','e','d',' ','a','c','t','s',' ','o','r',' ','o','m','i','s','s','i','o','n','s',' ',
'o','f',' ','t','h','e',' ','U','s','e','r',' ','i','n',' ','t','h','e',' ','r','e','p','r','o','d','u','c','t','i','o','n',',',' ','u','s','e',' ','o','r',' ','o','t','h','e','r',' ',
'd','i','s','p','o','s','i','t','i','o','n',' ','o','f',' ','t','h','e',' ','S','o','f','t','w','a','r','e','.','\n',
'\n',
'T','h','e',' ','U','s','e','r',' ','a','g','r','e','e','s',' ','t','h','a','t',' ','U','R','A',',',' ','i','t','s',' ','t','r','u','s','t','e','e','s',',',' ','o','v','e','r','s','e','e','r','s',',',' ',
'd','i','r','e','c','t','o','r','s',',',' ','o','f','f','i','c','e','r','s',',',' ','e','m','p','l','o','y','e','e','s',',',' ','a','g','e','n','t','s',',',' ',
's','u','b','c','o','n','t','r','a','c','t','o','r','s',',',' ','s','u','c','c','e','s','s','o','r','s',' ','a','n','d',' ','a','s','s','i','g','n','s',' ','s','h','a','l','l',' ','n','o','t',' ','b','e',' ',
'l','i','a','b','l','e',' ','u','n','d','e','r',' ','a','n','y',' ','c','l','a','i','m',',',' ','c','h','a','r','g','e',',',' ','o','r',' ','d','e','m','a','n','d',',',' ','w','h','e','t','h','e','r',' ','i','n',' ',
'c','o','n','t','r','a','c','t',',',' ','t','o','r','t',',',' ','c','r','i','m','i','n','a','l',' ','l','a','w',',',' ','o','r',' ','o','t','h','e','r','w','i','s','e',',',' ','f','o','r',' ','a','n','y',' ',
'a','n','d',' ','a','l','l',' ','l','o','s','s',',',' ','c','o','s','t',',',' ','c','h','a','r','g','e',',',' ','c','l','a','i','m',',',' ','d','e','m','a','n','d',',',' ','f','e','e',',',' ',
'e','x','p','e','n','s','e',',',' ','o','r',' ','d','a','m','a','g','e',' ','o','f',' ','e','v','e','r','y',' ','n','a','t','u','r','e',' ','a','n','d',' ','k','i','n','d',' ','a','r','i','s','i','n','g',' ',
'o','u','t',' ','o','f',',',' ','c','o','n','n','e','c','t','e','d',' ','w','i','t','h',',',' ','r','e','s','u','l','t','i','n','g',' ','f','r','o','m',' ','o','r',' ','s','u','s','t','a','i','n','e','d',' ','a','s',' ',
'a',' ','r','e','s','u','l','t',' ','o','f',' ','t','h','e',' ','u','s','e',' ','o','f',' ','t','h','i','s',' ','s','o','f','t','w','a','r','e',' ','p','r','o','g','r','a','m','.',' ',' ','I','n',' ','n','o',' ',
'e','v','e','n','t',' ','s','h','a','l','l',' ','U','R','A',' ','b','e',' ','l','i','a','b','l','e',' ','f','o','r',' ','s','p','e','c','i','a','l',',',' ','d','i','r','e','c','t',',',' ',
'i','n','d','i','r','e','c','t',' ','o','r',' ','c','o','n','s','e','q','u','e','n','t','i','a','l',' ','d','a','m','a','g','e','s',',',' ','l','o','s','s','e','s',',',' ','c','o','s','t','s',',',' ',
'c','h','a','r','g','e','s',',',' ','c','l','a','i','m','s',',',' ','d','e','m','a','n','d','s',',',' ','f','e','e','s',' ','o','r',' ','e','x','p','e','n','s','e','s',' ','o','f',' ','a','n','y',' ',
'n','a','t','u','r','e',' ','o','r',' ','k','i','n','d','.','\n',
'\n',
'D','I','S','C','L','A','I','M','E','R',' ','O','F',' ','W','A','R','R','A','N','T','I','E','S','\n',
'\n',
'T','h','e',' ','s','o','f','t','w','a','r','e',' ','i','s',' ','p','r','o','v','i','d','e','d',' ','o','n',' ','a','n',' ','\"','a','s',' ','i','s','\"',' ','b','a','s','i','s',' ','o','n','l','y','.',' ',
'U','R','A',' ','m','a','k','e','s',' ','n','o',' ','r','e','p','r','e','s','e','n','t','a','t','i','o','n','s',',',' ','e','x','p','r','e','s','s',' ','o','r',' ','i','m','p','l','i','e','d','.',' ',' ','U','R','A',' ',
'M','A','K','E','S',' ','N','O',' ','R','E','P','R','E','S','E','N','T','A','T','I','O','N','S',' ','O','R',' ','W','A','R','R','A','N','T','I','E','S',' ','O','F',' ',
'M','E','R','C','H','A','N','T','A','B','I','L','I','T','Y',' ','O','R',' ','F','I','T','N','E','S','S',' ','F','O','R',' ','A','N','Y',' ','P','A','R','T','I','C','U','L','A','R',' ','P','U','R','P','O','S','E',',',' ',
'o','r',' ','a','s','s','u','m','e','s',' ','a','n','y',' ','l','e','g','a','l',' ','l','i','a','b','i','l','i','t','y',' ','o','r',' ','r','e','s','p','o','n','s','i','b','i','l','i','t','y',' ','f','o','r',' ',
't','h','e',' ','a','c','c','u','r','a','c','y',',',' ','c','o','m','p','l','e','t','e','n','e','s','s',',',' ','o','r',' ','u','s','e','f','u','l','n','e','s','s',' ','o','f',' ','a','n','y',' ',
'i','n','f','o','r','m','a','t','i','o','n',',',' ','a','p','p','a','r','a','t','u','s',',',' ','p','r','o','d','u','c','t',' ','o','r',' ','p','r','o','c','e','s','s',' ','d','i','s','c','l','o','s','e','d',',',' ',
'o','r',' ','r','e','p','r','e','s','e','n','t','s',' ','t','h','a','t',' ','t','h','e',' ','S','o','f','t','w','a','r','e',' ','w','i','l','l',' ','n','o','t',' ','i','n','f','r','i','n','g','e',' ','a','n','y',' ',
'p','r','i','v','a','t','e','l','y',' ','h','e','l','d',' ','p','a','t','e','n','t',',',' ','c','o','p','y','r','i','g','h','t',',',' ','o','r',' ','t','r','a','d','e','m','a','r','k','.',' ',' ','T','h','e',' ',
'e','n','t','i','r','e',' ','r','i','s','k',' ','a','s',' ','t','o',' ','t','h','e',' ','r','e','s','u','l','t','s',' ','a','n','d',' ','t','h','e',' ','p','e','r','f','o','r','m','a','n','c','e',' ','o','f',' ',
't','h','i','s',' ','s','o','f','t','w','a','r','e',' ','i','s',' ','a','s','s','u','m','e','d',' ','b','y',' ','t','h','e',' ','U','s','e','r','.','\n',
'\n',
'D','I','S','C','L','A','I','M','E','R',' ','O','F',' ','E','N','D','O','R','S','E','M','E','N','T','\n',
'\n',
'R','e','f','e','r','e','n','c','e',' ','h','e','r','e','i','n',' ','t','o',' ','a','n','y',' ','s','p','e','c','i','f','i','c',' ','c','o','m','m','e','r','c','i','a','l',' ','p','r','o','d','u','c','t','s',',',' ',
'p','r','o','c','e','s','s',',',' ','o','r',' ','s','e','r','v','i','c','e',' ','b','y',' ','t','r','a','d','e','n','a','m','e',',',' ','t','r','a','d','e','m','a','r','k',',',' ',
'm','a','n','u','f','a','c','t','u','r','e','r',' ','o','r',' ','o','t','h','e','r','w','i','s','e',',',' ','d','o','e','s',' ','n','o','t',' ','c','o','n','s','t','i','t','u','t','e',' ','o','r',' ',
'i','m','p','l','y',' ','i','t','s',' ','e','n','d','o','r','s','e','m','e','n','t',',',' ','r','e','c','o','m','m','e','n','d','a','t','i','o','n',',',' ','o','r',' ','f','a','v','o','r','i','n','g',' ','b','y',' ',
't','h','e',' ','U','n','i','t','e','d',' ','S','t','a','t','e','s',' ','G','o','v','e','r','n','m','e','n','t',',',' ','U','.','S','.',' ','D','e','p','a','r','t','m','e','n','t',' ','o','f',' ',
'E','n','e','r','g','y',' ','o','r',' ','U','R','A','.',' ',' ','T','h','e',' ','v','i','e','w','s',' ','a','n','d',' ','o','p','i','n','i','o','n','s',' ','o','f',' ','i','n','d','i','v','i','d','u','a','l','s',' ',
'e','x','p','r','e','s','s','e','d',' ','h','e','r','e','i','n',' ','d','o',' ','n','o','t',' ','n','e','c','e','s','s','a','r','i','l','y',' ','s','t','a','t','e',' ','o','r',' ','r','e','f','l','e','c','t',' ',
't','h','o','s','e',' ','o','f',' ','t','h','e',' ','U','n','i','t','e','d',' ','S','t','a','t','e','s',' ','G','o','v','e','r','n','m','e','n','t',',',' ','U','.','S','.',' ','D','e','p','a','r','t','m','e','n','t',' ',
'o','f',' ','E','n','e','r','g','y',' ','o','r',' ','U','R','A',' ','a','n','d',' ','s','h','a','l','l',' ','n','o','t',' ','b','e',' ','u','s','e','d',' ','f','o','r',' ','a','d','v','e','r','t','i','s','i','n','g',' ',
'o','r',' ','p','r','o','d','u','c','t',' ','e','n','d','o','r','s','e','m','e','n','t',' ','p','u','r','p','o','s','e','s','.','\n',
'\n',
'L','I','A','B','I','L','I','T','I','E','S',' ','O','F',' ','T','H','E',' ','G','O','V','E','R','N','M','E','N','T','\n',
'\n',
'T','h','i','s',' ','s','o','f','t','w','a','r','e',' ','i','s',' ','p','r','o','v','i','d','e','d',' ','b','y',' ','U','R','A',',',' ','i','n','d','e','p','e','n','d','e','n','t',' ','f','r','o','m',' ','i','t','s',' ',
'P','r','i','m','e',' ','C','o','n','t','r','a','c','t',' ','w','i','t','h',' ','t','h','e',' ','U','.','S','.',' ','D','e','p','a','r','t','m','e','n','t',' ','o','f',' ','E','n','e','r','g','y','.',' ',
'U','R','A',' ','i','s',' ','a','c','t','i','n','g',' ','i','n','d','e','p','e','n','d','e','n','t','l','y',' ','f','r','o','m',' ','t','h','e',' ','G','o','v','e','r','n','m','e','n','t',' ','a','n','d',' ','i','n',' ',
'i','t','s',' ','o','w','n',' ','p','r','i','v','a','t','e',' ','c','a','p','a','c','i','t','y',' ','a','n','d',' ','i','s',' ','n','o','t',' ','a','c','t','i','n','g',' ','o','n',' ','b','e','h','a','l','f',' ',
'o','f',' ','t','h','e',' ','U','.','S','.',' ','G','o','v','e','r','n','m','e','n','t',',',' ','n','o','r',' ','a','s',' ','i','t','s',' ','c','o','n','t','r','a','c','t','o','r',' ','n','o','r',' ','i','t','s',' ',
'a','g','e','n','t','.',' ',' ','C','o','r','r','e','s','p','o','n','d','i','n','g','l','y',',',' ','i','t',' ','i','s',' ','u','n','d','e','r','s','t','o','o','d',' ','a','n','d',' ','a','g','r','e','e','d',' ',
't','h','a','t',' ','t','h','e',' ','U','.','S','.',' ','G','o','v','e','r','n','m','e','n','t',' ','h','a','s',' ','n','o',' ','c','o','n','n','e','c','t','i','o','n',' ','t','o',' ','t','h','i','s',' ',
's','o','f','t','w','a','r','e',' ','a','n','d',' ','i','n',' ','n','o',' ','m','a','n','n','e','r',' ','w','h','a','t','s','o','e','v','e','r',' ','s','h','a','l','l',' ','b','e',' ','l','i','a','b','l','e',' ',
'f','o','r',' ','n','o','r',' ','a','s','s','u','m','e',' ','a','n','y',' ','r','e','s','p','o','n','s','i','b','i','l','i','t','y',' ','o','r',' ','o','b','l','i','g','a','t','i','o','n',' ','f','o','r',' ',
'a','n','y',' ','c','l','a','i','m',',',' ','c','o','s','t',',',' ','o','r',' ','d','a','m','a','g','e','s',' ','a','r','i','s','i','n','g',' ','o','u','t',' ','o','f',' ','o','r',' ',
'r','e','s','u','l','t','i','n','g',' ','f','r','o','m',' ','t','h','e',' ','u','s','e',' ','o','f',' ','t','h','i','s',' ','s','o','f','t','w','a','r','e','.','\n',
'\n',
'\n',
'O','R','I','G','I','N',' ','S','T','A','T','E','M','E','N','T','\n',
'\n',
'A','u','t','h','o','r','s','\n',
'\n',
'M','a','r','k',' ','E','d','e','l',',',' ','J','o','y',' ','K','y','r','i','a','k','o','p','u','l','o','s',',',' ','A','r','n','u','l','f','o',' ','Z','e','p','e','d','a','-','N','a','v','r','a','t','i','l',',',' ',
'S','u','r','e','s','h',' ','R','a','v','o','o','r',',',' ','D','o','n','n','a',' ','R','e','i','d',',',' ','J','e','f','f',' ','K','a','l','l','e','n','b','a','c','h','\n',
'\n',
'F','e','r','m','i',' ','N','a','t','i','o','n','a','l',' ','A','c','c','e','l','e','r','a','t','o','r',' ','L','a','b','o','r','a','t','o','r','y','\n',
'M','S',' ','2','3','4','\n',
'P','.','O','.','B','o','x',' ','5','0','0','\n',
'B','a','t','a','v','i','a',',',' ','I','L',' ','6','0','5','1','0','\n',
'\n',
'E','M','A','I','L',':',' ','e','d','e','l','@','f','n','a','l','.','g','o','v','\n',
'\n',
'A','c','k','n','o','w','l','e','d','g','e','m','e','n','t','s',':','\n',
'\n',
'S','y','n','t','a','x',' ','h','i','g','h','l','i','g','h','t','i','n','g',' ','p','a','t','t','e','r','n','s',' ','w','e','r','e',' ','c','o','n','t','r','i','b','u','t','e','d',' ','b','y',':',' ',
'S','i','m','o','n',' ','T','.',' ','M','a','c','D','o','n','a','l','d',',',' ',' ','M','a','u','r','i','c','e',' ','L','e','y','s','e','n','s',',',' ','M','a','t','t',' ','M','a','j','k','a',',',' ','A','l','f','r','e','d',' ','S','m','e','e','n','k',',',' ',
'A','l','a','i','n',' ','F','a','r','g','u','e','s',',',' ','C','h','r','i','s','t','o','p','h','e','r',' ','C','o','n','r','a','d',',',' ','S','c','o','t','t',' ','M','a','r','k','i','n','s','o','n',',',' ','a','n','d',' ','K','o','n','r','a','d',' ','B','e','r','n','l','o','e','h','r','.','\n',
'\n',
'R','e','g','u','l','a','r',' ','e','x','p','r','e','s','s','i','o','n',' ','c','o','d','e',' ','b','y',' ','H','e','n','r','y',' ','S','p','e','n','c','e','r','\n',
'\n',
'N','e','d','i','t',' ','i','n','c','o','r','p','o','r','a','t','e','s',' ','a','n',' ','a','l','t','e','r','e','d',' ','v','e','r','s','i','o','n',' ','o','f',' ','H','e','n','r','y',' ',
'S','p','e','n','c','e','r',''','s',' ','r','e','g','c','o','m','p',' ','a','n','d',' ','r','e','g','e','x','e','c',' ','c','o','d','e',' ','a','d','a','p','t','e','d',' ','f','o','r',' ','N','E','d','i','t','.',' ',
'O','r','i','g','i','n','a','l',' ','c','o','p','y','r','i','g','h','t',' ','n','o','t','i','c','e',':','\n',
'\n',
'C','o','p','y','r','i','g','h','t',' ','(','c',')',' ','1','9','8','6',' ','b','y',' ','U','n','i','v','e','r','s','i','t','y',' ','o','f',' ','T','o','r','o','n','t','o','.',' ',' ',
'W','r','i','t','t','e','n',' ','b','y',' ','H','e','n','r','y',' ','S','p','e','n','c','e','r','.',' ',' ','N','o','t',' ','d','e','r','i','v','e','d',' ','f','r','o','m',' ','l','i','c','e','n','s','e','d',' ',
's','o','f','t','w','a','r','e','.','\n',
'\n',
'P','e','r','m','i','s','s','i','o','n',' ','i','s',' ','g','r','a','n','t','e','d',' ','t','o',' ','a','n','y','o','n','e',' ','t','o',' ','u','s','e',' ','t','h','i','s',' ','s','o','f','t','w','a','r','e',' ',
'f','o','r',' ','a','n','y',' ','p','u','r','p','o','s','e',' ','o','n',' ','a','n','y',' ','c','o','m','p','u','t','e','r',' ','s','y','s','t','e','m',',',' ','a','n','d',' ','t','o',' ',
'r','e','d','i','s','t','r','i','b','u','t','e',' ','i','t',' ','f','r','e','e','l','y',',',' ','s','u','b','j','e','c','t',' ','t','o',' ','t','h','e',' ','f','o','l','l','o','w','i','n','g',' ',
'r','e','s','t','r','i','c','t','i','o','n','s',':','\n',
'\n',
'1','.',' ','T','h','e',' ','a','u','t','h','o','r',' ','i','s',' ','n','o','t',' ','r','e','s','p','o','n','s','i','b','l','e',' ','f','o','r',' ','t','h','e',' ','c','o','n','s','e','q','u','e','n','c','e','s',' ',
'o','f',' ','u','s','e',' ','o','f',' ','t','h','i','s',' ','s','o','f','t','w','a','r','e',',',' ','n','o',' ','m','a','t','t','e','r',' ','h','o','w',' ','a','w','f','u','l',',',' ','e','v','e','n',' ','i','f',' ',
't','h','e','y',' ','a','r','i','s','e',' ','f','r','o','m',' ','d','e','f','e','c','t','s',' ','i','n',' ','i','t','.','\n',
'\n',
'2','.',' ','T','h','e',' ','o','r','i','g','i','n',' ','o','f',' ','t','h','i','s',' ','s','o','f','t','w','a','r','e',' ','m','u','s','t',' ','n','o','t',' ','b','e',' ',
'm','i','s','r','e','p','r','e','s','e','n','t','e','d',',',' ','e','i','t','h','e','r',' ','b','y',' ','e','x','p','l','i','c','i','t',' ','c','l','a','i','m',' ','o','r',' ','b','y',' ',
'o','m','i','s','s','i','o','n','.','\n',
'\n',
'3','.',' ','A','l','t','e','r','e','d',' ','v','e','r','s','i','o','n','s',' ','m','u','s','t',' ','b','e',' ','p','l','a','i','n','l','y',' ','m','a','r','k','e','d',' ','a','s',' ','s','u','c','h',',',' ',
'a','n','d',' ','m','u','s','t',' ','n','o','t',' ','b','e',' ','m','i','s','r','e','p','r','e','s','e','n','t','e','d',' ','a','s',' ','b','e','i','n','g',' ','t','h','e',' ','o','r','i','g','i','n','a','l',' ',
's','o','f','t','w','a','r','e','.','\n',
'\n',
'E','n','d',' ','o','f',' ','I','N','F','O','R','M','A','T','I','O','N','/','L','I','C','E','N','S','E',' ','A','G','R','E','E','M','E','N','T',' ','F','O','R',' ','N','E','D','I','T','.','\0'};

static char AuxString31[] = {'T','h','e',' ','T','a','b','s',' ','d','i','a','l','o','g',' ','c','o','n','t','r','o','l','s',' ','b','o','t','h',' ','t','h','e',' ','o','p','e','r','a','t','i','o','n',' ','o','f',' ','t','h','e',' ','T','a','b',' ',
'k','e','y',',',' ','a','n','d',' ','t','h','e',' ','i','n','t','e','r','p','r','e','t','a','t','i','o','n',' ','o','f',' ','t','a','b',' ','c','h','a','r','a','c','t','e','r','s',' ',
'w','i','t','h','i','n',' ','a',' ','f','i','l','e','.','\n',
'\n',
'T','h','e',' ','f','i','r','s','t',' ','f','i','e','l','d',',',' ','T','a','b',' ','S','p','a','c','i','n','g',',',' ','c','o','n','t','r','o','l','s',' ','h','o','w',' ',' ','N','E','d','i','t',' ',
'r','e','s','p','o','n','d','s',' ','t','o',' ','t','a','b',' ','c','h','a','r','a','c','t','e','r','s',' ','i','n',' ','a',' ','f','i','l','e','.',' ',' ','O','n',' ','m','o','s','t',' ','U','n','i','x',' ','a','n','d',' ',
'V','M','S',' ','s','y','s','t','e','m','s',' ','t','h','e',' ','c','o','n','v','e','n','t','i','o','n','a','l',' ','i','n','t','e','r','p','r','e','t','a','t','i','o','n',' ','o','f',' ','a',' ','t','a','b',' ',
'c','h','a','r','a','c','t','e','r',' ','i','s',' ','t','o',' ','a','d','v','a','n','c','e',' ','t','h','e',' ','t','e','x','t',' ','p','o','s','i','t','i','o','n',' ','t','o',' ','t','h','e',' ','n','e','a','r','e','s','t',' ',
'm','u','l','t','i','p','l','e',' ','o','f',' ','e','i','g','h','t',' ','c','h','a','r','a','c','t','e','r','s',' ','(','a',' ','t','a','b',' ','s','p','a','c','i','n','g',' ','o','f',' ','8',')','.',' ',' ',
'H','o','w','e','v','e','r',',',' ','m','a','n','y',' ','p','r','o','g','r','a','m','m','e','r','s',' ','o','f',' ','C',' ','a','n','d',' ','o','t','h','e','r',' ','s','t','r','u','c','t','u','r','e','d',' ',
'l','a','n','g','u','a','g','e','s',',',' ','w','h','e','n',' ','g','i','v','e','n',' ','t','h','e',' ','c','h','o','i','c','e',',',' ','p','r','e','f','e','r',' ','a',' ','t','a','b',' ','s','p','a','c','i','n','g',' ',
'o','f',' ','3',' ','o','r',' ','4',' ','c','h','a','r','a','c','t','e','r','s','.',' ',' ','S','e','t','t','i','n','g',' ','a',' ','t','h','r','e','e',' ','o','r',' ','f','o','u','r',' ','c','h','a','r','a','c','t','e','r',' ',
'h','a','r','d','w','a','r','e',' ','t','a','b',' ','s','p','a','c','i','n','g',' ','i','s',' ','u','s','e','f','u','l',' ','a','n','d',' ','c','o','n','v','e','n','i','e','n','t',' ','a','s',' ','l','o','n','g',' ','a','s',' ',
'y','o','u','r',' ','o','t','h','e','r',' ','s','o','f','t','w','a','r','e',' ','t','o','o','l','s',' ','s','u','p','p','o','r','t',' ','i','t','.',' ',' ','U','n','f','o','r','t','u','n','a','t','e','l','y',',',' ','o','n',' ',
'U','n','i','x',' ','a','n','d',' ','V','M','S',' ','s','y','s','t','e','m','s',',',' ','s','y','s','t','e','m',' ','u','t','i','l','i','t','i','e','s',',',' ','s','u','c','h',' ','a','s',' ','m','o','r','e',',',' ',
'a','n','d',' ','p','r','i','n','t','i','n','g',' ','s','o','f','t','w','a','r','e',' ','c','a','n',''','t',' ','a','l','w','a','y','s',' ','p','r','o','p','e','r','l','y',' ','d','i','s','p','l','a','y',' ',
'f','i','l','e','s',' ','w','i','t','h',' ','o','t','h','e','r',' ','t','h','a','n',' ','e','i','g','h','t',' ','c','h','a','r','a','c','t','e','r',' ','t','a','b','s','.','\n',
'\n',
'S','e','l','e','c','t','i','n','g',' ','\"','E','m','u','l','a','t','e',' ','T','a','b','s','\"',' ','w','i','l','l',' ','c','a','u','s','e',' ','t','h','e',' ','T','a','b',' ','k','e','y',' ','t','o',' ',
'i','n','s','e','r','t',' ','t','h','e',' ','c','o','r','r','e','c','t',' ','n','u','m','b','e','r',' ','o','f',' ','s','p','a','c','e','s',' ','o','r',' ','t','a','b','s',' ','t','o',' ','r','e','a','c','h',' ','t','h','e',' ',
'n','e','x','t',' ','t','a','b',' ','s','t','o','p',',',' ','a','s',' ','i','f',' ','t','h','e',' ','t','a','b',' ','s','p','a','c','i','n','g',' ','w','e','r','e',' ','s','e','t',' ','a','t',' ','t','h','e',' ',
'v','a','l','u','e',' ','i','n',' ','t','h','e',' ','\"','E','m','u','l','a','t','e','d',' ','t','a','b',' ','s','p','a','c','i','n','g','\"',' ','f','i','e','l','d','.',' ',' ',
'B','a','c','k','s','p','a','c','i','n','g',' ','i','m','m','e','d','i','a','t','e','l','y',' ','a','f','t','e','r',' ','e','n','t','e','r','i','n','g',' ','a','n',' ','e','m','u','l','a','t','e','d',' ','t','a','b',' ',
'w','i','l','l',' ','d','e','l','e','t','e',' ','i','t',' ','a','s',' ','a',' ','u','n','i','t',',',' ','b','u','t',' ','a','s',' ','s','o','o','n',' ','a','s',' ','y','o','u',' ','m','o','v','e',' ','t','h','e',' ',
'c','u','r','s','o','r',' ','a','w','a','y',' ','f','r','o','m',' ','t','h','e',' ','s','p','o','t',',',' ','N','E','d','i','t',' ','w','i','l','l',' ','f','o','r','g','e','t',' ','t','h','a','t',' ','t','h','e',' ',
'c','o','l','l','e','c','t','i','o','n',' ','o','f',' ','s','p','a','c','e','s',' ','a','n','d',' ','t','a','b','s',' ','i','s',' ','a',' ','t','a','b',',',' ','a','n','d',' ','w','i','l','l',' ','t','r','e','a','t',' ',
'i','t',' ','a','s',' ','s','e','p','a','r','a','t','e',' ','c','h','a','r','a','c','t','e','r','s','.',' ',' ','T','o',' ','e','n','t','e','r',' ','a',' ','r','e','a','l',' ','t','a','b',' ',
'c','h','a','r','a','c','t','e','r',' ','w','i','t','h',' ','\"','E','m','u','l','a','t','e',' ','T','a','b','s','\"',' ','t','u','r','n','e','d',' ','o','n',',',' ','u','s','e',' ','C','t','r','l','+','T','a','b','.','\n',
'\n',
'I','n',' ','g','e','n','e','r','a','t','i','n','g',' ','e','m','u','l','a','t','e','d',' ','t','a','b','s',',',' ','a','n','d',' ','i','n',' ','S','h','i','f','t',' ','L','e','f','t',',',' ','P','a','s','t','e',' ',
'C','o','l','u','m','n',',',' ','a','n','d',' ','s','o','m','e',' ','r','e','c','t','a','n','g','u','l','a','r',' ','s','e','l','e','c','t','i','o','n',' ','o','p','e','r','a','t','i','o','n','s',',',' ','N','E','d','i','t',' ',
'i','n','s','e','r','t','s',' ','b','l','a','n','k',' ','c','h','a','r','a','c','t','e','r','s',' ','(','s','p','a','c','e','s',' ','o','r',' ','t','a','b','s',')',' ','t','o',' ','p','r','e','s','e','r','v','e',' ',
't','h','e',' ','a','l','i','g','n','m','e','n','t',' ','o','f',' ','n','o','n','-','b','l','a','n','k',' ','c','h','a','r','a','c','t','e','r','s','.',' ',' ','T','h','e',' ','b','o','t','t','o','m',' ',
't','o','g','g','l','e',' ','b','u','t','t','o','n',' ','i','n',' ','t','h','e',' ','T','a','b','s',' ','d','i','a','l','o','g',' ','i','n','s','t','r','u','c','t','s',' ','N','E','d','i','t',' ','w','h','e','t','h','e','r',' ',
't','o',' ','i','n','s','e','r','t',' ','t','a','b',' ','c','h','a','r','a','c','t','e','r','s',' ','a','s',' ','p','a','d','d','i','n','g',' ','i','n',' ','s','u','c','h',' ','s','i','t','u','a','t','i','o','n','s','.',' ',' ',
'T','u','r','n','i','n','g',' ','t','h','i','s',' ','o','f','f',',',' ','w','i','l','l',' ','k','e','e','p',' ','N','E','d','i','t',' ','f','r','o','m',' ','a','u','t','o','m','a','t','i','c','a','l','l','y',' ',
'i','n','s','e','r','t','i','n','g',' ','t','a','b','s','.',' ',' ','S','o','m','e',' ','s','o','f','t','w','a','r','e',' ','d','e','v','e','l','o','p','e','r','s',' ','p','r','e','f','e','r',' ','t','o',' ','k','e','e','p',' ',
't','h','e','i','r',' ','s','o','u','r','c','e',' ','c','o','d','e',' ','f','r','e','e',' ','o','f',' ','t','a','b','s',' ','t','o',' ','a','v','o','i','d',' ','i','t','s',' ',
'm','i','s','i','n','t','e','r','p','r','e','t','a','t','i','o','n',' ','o','n',' ','s','y','s','t','e','m','s',' ','w','i','t','h',' ','d','i','f','f','e','r','e','n','t',' ','t','a','b',' ',
'c','h','a','r','a','c','t','e','r',' ','c','o','n','v','e','n','t','i','o','n','s','.','\0'};

static char *HelpText[NUM_TOPICS] = {
    AuxString0,
    AuxString1,
    AuxString2,
    AuxString3,
    AuxString4,
    AuxString5,
    AuxString6,
    AuxString7,
    AuxString8,
    AuxString9,
    AuxString10,
    AuxString11,
    AuxString12,
    AuxString13,
    AuxString14,
    AuxString15,
    AuxString16,
    AuxString17,
    AuxString18,
    AuxString19,
    AuxString20,
    AuxString21,
    AuxString22,
    AuxString23,
    AuxString24,
    AuxString25,
    AuxString26,
    AuxString27,
    AuxString28,
    AuxString29,
    AuxString30,
    AuxString31
};

static Widget HelpWindows[NUM_TOPICS] = {NULL}; 
static Widget HelpTextPanes[NUM_TOPICS] = {NULL};

/* Information on the last search for search-again */
static char LastSearchString[DF_MAX_PROMPT_LENGTH] = "";
static int LastSearchTopic = -1;
static int LastSearchPos = 0;
static int LastSearchWasAllTopics = False;

static Widget createHelpPanel(Widget parent, int topic);
static void dismissCB(Widget w, XtPointer clientData, XtPointer callData);
static void searchHelpCB(Widget w, XtPointer clientData, XtPointer callData);
static void searchHelpAgainCB(Widget w, XtPointer clientData,
	XtPointer callData);
static void printCB(Widget w, XtPointer clientData, XtPointer callData);
static void searchHelpText(Widget parent, int parentTopic, char *searchFor,
	int allSections, int startPos, int startTopic);
static int findTopicFromShellWidget(Widget shellWidget);

void Help(Widget parent, enum HelpTopic topic)
{
    if (HelpWindows[topic] != NULL)
    	RaiseShellWindow(HelpWindows[topic]);
    else
    	HelpWindows[topic] = createHelpPanel(parent, topic);
}

static Widget createHelpPanel(Widget parent, int topic)
{
    Arg al[50];
    int ac;
    Widget appShell, form, btn, dismissBtn;
    Widget sw, hScrollBar, vScrollBar;
    XmString st1;
    
    ac = 0;
    XtSetArg(al[ac], XmNtitle, HelpTitles[topic]); ac++;
    XtSetArg(al[ac], XmNdeleteResponse, XmDO_NOTHING); ac++;
    XtSetArg(al[ac], XmNiconName, HelpTitles[topic]); ac++;
    appShell = XtAppCreateShell(APP_NAME, APP_CLASS,
	    applicationShellWidgetClass, TheDisplay, al, ac);
    AddSmallIcon(appShell);
    form = XtVaCreateManagedWidget("helpForm", xmFormWidgetClass, appShell, 0);
    XtVaSetValues(form, XmNshadowThickness, 0, 0);
    
    btn = XtVaCreateManagedWidget("find", xmPushButtonWidgetClass, form,
    	    XmNlabelString, st1=XmStringCreateSimple("Find..."),
    	    XmNmnemonic, 'F',
    	    XmNhighlightThickness, 0,
    	    XmNbottomAttachment, XmATTACH_FORM,
	    XmNleftAttachment, XmATTACH_POSITION,
	    XmNleftPosition, 3,
	    XmNrightAttachment, XmATTACH_POSITION,
	    XmNrightPosition, 25, 0);
    XtAddCallback(btn, XmNactivateCallback, searchHelpCB, appShell);
    XmStringFree(st1);

    btn = XtVaCreateManagedWidget("findAgain", xmPushButtonWidgetClass, form,
    	    XmNlabelString, st1=XmStringCreateSimple("Find Again"),
    	    XmNmnemonic, 'A',
    	    XmNhighlightThickness, 0,
    	    XmNbottomAttachment, XmATTACH_FORM,
	    XmNleftAttachment, XmATTACH_POSITION,
	    XmNleftPosition, 27,
	    XmNrightAttachment, XmATTACH_POSITION,
	    XmNrightPosition, 49, 0);
    XtAddCallback(btn, XmNactivateCallback, searchHelpAgainCB, appShell);
    XmStringFree(st1);

    btn = XtVaCreateManagedWidget("print", xmPushButtonWidgetClass, form,
    	    XmNlabelString, st1=XmStringCreateSimple("Print..."),
    	    XmNmnemonic, 'P',
    	    XmNhighlightThickness, 0,
    	    XmNbottomAttachment, XmATTACH_FORM,
	    XmNleftAttachment, XmATTACH_POSITION,
	    XmNleftPosition, 51,
	    XmNrightAttachment, XmATTACH_POSITION,
	    XmNrightPosition, 73, 0);
    XtAddCallback(btn, XmNactivateCallback, printCB, appShell);
    XmStringFree(st1);

    dismissBtn = XtVaCreateManagedWidget("dismiss", xmPushButtonWidgetClass,
	    form, XmNlabelString, st1=XmStringCreateSimple("Dismiss"),
    	    XmNhighlightThickness, 0,
    	    XmNbottomAttachment, XmATTACH_FORM,
	    XmNleftAttachment, XmATTACH_POSITION,
	    XmNleftPosition, 75,
	    XmNrightAttachment, XmATTACH_POSITION,
	    XmNrightPosition, 97, 0);
    XtAddCallback(dismissBtn, XmNactivateCallback, dismissCB, appShell);
    XmStringFree(st1);
            
    /* Create a text widget inside of a scrolled window widget */
    sw = XtVaCreateManagedWidget("sw", xmScrolledWindowWidgetClass,
    	    form, XmNspacing, 0, XmNhighlightThickness, 0,
	    XmNshadowThickness, 2,
	    XmNtopAttachment, XmATTACH_FORM,
	    XmNleftAttachment, XmATTACH_FORM,
    	    XmNrightAttachment, XmATTACH_FORM,
	    XmNbottomAttachment, XmATTACH_WIDGET,
	    XmNbottomWidget, dismissBtn, 0);
    hScrollBar = XtVaCreateManagedWidget("hScrollBar",
    	    xmScrollBarWidgetClass, sw, XmNorientation, XmHORIZONTAL, 
    	    XmNrepeatDelay, 10, 0);
    vScrollBar = XtVaCreateManagedWidget("vScrollBar",
    	    xmScrollBarWidgetClass, sw, XmNorientation, XmVERTICAL,
    	    XmNrepeatDelay, 10, 0);
    HelpTextPanes[topic] = XtVaCreateManagedWidget("helpText",
	    textWidgetClass, sw, textNrows, 30, textNcolumns, 60,
    	    textNhScrollBar, hScrollBar, textNvScrollBar, vScrollBar,
	    textNreadOnly, True, textNcontinuousWrap, True,
	    textNautoShowInsertPos, True, 0);
    XtVaSetValues(sw, XmNworkWindow, HelpTextPanes[topic],
	    XmNhorizontalScrollBar, hScrollBar,
    	    XmNverticalScrollBar, vScrollBar, 0);
    BufSetAll(TextGetBuffer(HelpTextPanes[topic]), HelpText[topic]);
    
    /* This shouldn't be necessary (what's wrong in text.c?) */
    HandleXSelections(HelpTextPanes[topic]);
    
    /* Process dialog mnemonic keys */
    AddDialogMnemonicHandler(form);
    
    /* Set the default button */
    XtVaSetValues(form, XmNdefaultButton, dismissBtn, 0);
    XtVaSetValues(form, XmNcancelButton, dismissBtn, 0);
    
    /* realize all of the widgets in the new window */
    XtRealizeWidget(appShell);

    /* Make close command in window menu gracefully prompt for close */
    AddMotifCloseCallback(appShell, (XtCallbackProc)dismissCB, appShell);
    
    return appShell;
}

static void dismissCB(Widget w, XtPointer clientData, XtPointer callData)
{
    int topic;
    
    if ((topic = findTopicFromShellWidget((Widget)clientData)) == -1)
    	return;
    
    /* I don't understand the mechanism by which this can be called with
       HelpWindows[topic] as NULL, but it has happened */
    XtDestroyWidget(HelpWindows[topic]);
    HelpWindows[topic] = NULL;
}

static void searchHelpCB(Widget w, XtPointer clientData, XtPointer callData)
{
    char promptText[DF_MAX_PROMPT_LENGTH];
    int response, topic;
    static char **searchHistory = NULL;
    static int nHistoryStrings = 0;
    
    if ((topic = findTopicFromShellWidget((Widget)clientData)) == -1)
    	return; /* shouldn't happen */
    SetDialogFPromptHistory(searchHistory, nHistoryStrings);
    response = DialogF(DF_PROMPT, HelpWindows[topic], 3,
	    "Search for:    (use up arrow key to recall previous)",
    	    promptText, "This Section", "All Sections", "Cancel");
    if (response == 3)
    	return;
    AddToHistoryList(promptText, &searchHistory, &nHistoryStrings);
    searchHelpText(HelpWindows[topic], topic, promptText, response == 2, 0, 0);
}

static void searchHelpAgainCB(Widget w, XtPointer clientData,
	XtPointer callData)
{
    int topic;
    
    if ((topic = findTopicFromShellWidget((Widget)clientData)) == -1)
    	return; /* shouldn't happen */
    searchHelpText(HelpWindows[topic], topic, LastSearchString,
	    LastSearchWasAllTopics, LastSearchPos, LastSearchTopic);
}

static void printCB(Widget w, XtPointer clientData, XtPointer callData)
{
    int topic, helpStringLen;
    char *helpString;
    
    if ((topic = findTopicFromShellWidget((Widget)clientData)) == -1)
    	return; /* shouldn't happen */
    helpString = TextGetWrapped(HelpTextPanes[topic], 0,
	    TextGetBuffer(HelpTextPanes[topic])->length, &helpStringLen);
    PrintString(helpString, helpStringLen, HelpWindows[topic],
	    HelpTitles[topic]);
}

static void searchHelpText(Widget parent, int parentTopic, char *searchFor,
	int allSections, int startPos, int startTopic)
{    
    int topic, beginMatch, endMatch;
    int found = False;
    
    /* Search for the string */
    for (topic=startTopic; topic<NUM_TOPICS; topic++) {
	if (!allSections && topic != parentTopic)
	    continue;
	if (SearchString(HelpText[topic], searchFor, SEARCH_FORWARD,
		SEARCH_LITERAL, False, topic == startTopic ? startPos : 0,
		&beginMatch, &endMatch, GetPrefDelimiters())) {
	    found = True;
	    break;
	}
    }
    if (!found) {
	if (startPos != 0 || allSections && startTopic != 0) { /* Wrap search */
	    searchHelpText(parent, parentTopic, searchFor, allSections, 0, 0);
	    return;
    	}
	DialogF(DF_INF, parent, 1, "String Not Found", "Dismiss");
	return;
    }
    
    /* If the appropriate window is already up, bring it to the top, if not,
       make the parent window become this topic */
    if (HelpWindows[topic] == NULL) {
	XtVaSetValues(HelpWindows[parentTopic], XmNtitle, HelpTitles[topic], 0);
	BufSetAll(TextGetBuffer(HelpTextPanes[parentTopic]), HelpText[topic]);
	HelpWindows[topic] = HelpWindows[parentTopic];
	HelpTextPanes[topic] = HelpTextPanes[parentTopic];
	HelpWindows[parentTopic] = NULL;
	HelpTextPanes[parentTopic] = NULL;
    } else if (topic != parentTopic)
	RaiseShellWindow(HelpWindows[topic]);
    BufSelect(TextGetBuffer(HelpTextPanes[topic]), beginMatch, endMatch);
    TextSetCursorPos(HelpTextPanes[topic], endMatch);
    
    /* Save the search information for search-again */
    strcpy(LastSearchString, searchFor);
    LastSearchTopic = topic;
    LastSearchPos = endMatch;
    LastSearchWasAllTopics = allSections;
}

static int findTopicFromShellWidget(Widget shellWidget)
{
    int i;
    
    for (i=0; i<NUM_TOPICS; i++)
	if (shellWidget == HelpWindows[i])
	    return i;
    return -1;
}
