/*******************************************************************************
*									       *
* highlightData.c -- Maintain, and allow user to edit, highlight pattern list  *
*		     used for syntax highlighting			       *
*									       *
* Copyright (c) 1997 Universities Research Association, Inc.		       *
* All rights reserved.							       *
* 									       *
* This material resulted from work developed under a Government Contract and   *
* is subject to the following license:  The Government retains a paid-up,      *
* nonexclusive, irrevocable worldwide license to reproduce, prepare derivative *
* works, perform publicly and display publicly by or for the Government,       *
* including the right to distribute to other Government contractors.  Neither  *
* the United States nor the United States Department of Energy, nor any of     *
* their employees, makes any warrenty, express or implied, or assumes any      *
* legal liability or responsibility for the accuracy, completeness, or         *
* usefulness of any information, apparatus, product, or process disclosed, or  *
* represents that its use would not infringe privately owned rights.           *
*                                        				       *
* Fermilab Nirvana GUI Library						       *
* April, 1997								       *
*									       *
* Written by Mark Edel							       *
*									       *
*******************************************************************************/
#include <stdio.h>
#include <limits.h>
#ifdef VMS
#include "../util/VMSparam.h"
#else
#include <sys/param.h>
#endif /*VMS*/
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Text.h>
#include <Xm/LabelG.h>
#include <Xm/PushB.h>
#include <Xm/ToggleB.h>
#include <Xm/RowColumn.h>
#include <Xm/SeparatoG.h>
#include "../util/misc.h"
#include "../util/DialogF.h"
#include "../util/managedList.h"
#include "textBuf.h"
#include "nedit.h"
#include "highlight.h"
#include "regularExp.h"
#include "preferences.h"
#include "help.h"
#include "window.h"
#include "highlightData.h"

/* Maximum allowed number of styles (also limited by representation of
   styles as a byte - 'b') */
#define MAX_HIGHLIGHT_STYLES 128

/* Maximum number of patterns allowed in a pattern set (regular expression
   limitations are probably much more restrictive).  */
#define MAX_PATTERNS 127

/* maximum number of pattern sets allowed (we wish) */
#define MAX_PATTERN_SETS 50

/* Names for the fonts that can be used for syntax highlighting */
#define N_FONT_TYPES 4
enum fontTypes {PLAIN_FONT, ITALIC_FONT, BOLD_FONT, BOLD_ITALIC_FONT};
char *FontTypeNames[N_FONT_TYPES] = {"Plain", "Italic", "Bold", "Bold Italic"};

typedef struct {
    char *name;
    char *color;
    int font;
} highlightStyleRec;

static int styleError(char *stringStart, char *stoppedAt, char *message);
static int lookupNamedStyle(char *styleName);
static highlightPattern *readHighlightPatterns(char **inPtr, int withBraces,
    	char **errMsg, int *nPatterns);
static int readHighlightPattern(char **inPtr, char **errMsg,
    	highlightPattern *pattern);
static patternSet *readDefaultPatternSet(char *langModeName);
static int isDefaultPatternSet(patternSet *patSet);
static patternSet *readPatternSet(char **inPtr);
static patternSet *highlightError(char *stringStart, char *stoppedAt,
    	char *message);
static char *intToStr(int i);
static char *createPatternsString(patternSet *patSet, char *indentStr);
static void setStyleByName(char *style);
static void hsDestroyCB(Widget w, XtPointer clientData, XtPointer callData);
static void hsOkCB(Widget w, XtPointer clientData, XtPointer callData);
static void hsApplyCB(Widget w, XtPointer clientData, XtPointer callData);
static void hsDismissCB(Widget w, XtPointer clientData, XtPointer callData);
static highlightStyleRec *copyHighlightStyleRec(highlightStyleRec *hs);
static void *hsGetDisplayedCB(void *oldItem, int explicitRequest, int *abort,
    	void *cbArg);
static void hsSetDisplayedCB(void *item, void *cbArg);
static highlightStyleRec *readHSDialogFields(int silent);
static void hsFreeItemCB(void *item);
static void freeHighlightStyleRec(highlightStyleRec *hs);
static int hsDialogEmpty(void);
static int updateHSList(void);
static void updateHighlightStyleMenu(void);
static Widget createHighlightStylesMenu(Widget parent);
static void destroyCB(Widget w, XtPointer clientData, XtPointer callData);
static void langModeCB(Widget w, XtPointer clientData, XtPointer callData);
static void lmDialogCB(Widget w, XtPointer clientData, XtPointer callData);
static void styleDialogCB(Widget w, XtPointer clientData, XtPointer callData);
static void patTypeCB(Widget w, XtPointer clientData, XtPointer callData);
static void matchTypeCB(Widget w, XtPointer clientData, XtPointer callData);
static int checkHighlightDialogData(void);
static void updateLabels(void);
static void okCB(Widget w, XtPointer clientData, XtPointer callData);
static void applyCB(Widget w, XtPointer clientData, XtPointer callData);
static void checkCB(Widget w, XtPointer clientData, XtPointer callData);
static void restoreCB(Widget w, XtPointer clientData, XtPointer callData);
static void deleteCB(Widget w, XtPointer clientData, XtPointer callData);
static void dismissCB(Widget w, XtPointer clientData, XtPointer callData);
static void helpCB(Widget w, XtPointer clientData, XtPointer callData);
static void *getDisplayedCB(void *oldItem, int explicitRequest, int *abort,
    	void *cbArg);
static void setDisplayedCB(void *item, void *cbArg);
static void setStyleMenu(char *styleName);
static highlightPattern *readDialogFields(int silent);
static int dialogEmpty(void);
static int updatePatternSet(void);
static patternSet *getDialogPatternSet(void);
static int patternSetsDiffer(patternSet *patSet1, patternSet *patSet2);
static highlightPattern *copyPatternSrc(highlightPattern *pat,
    	highlightPattern *copyTo);
static void freeNonNull(void *ptr);
static void freeItemCB(void *item);
static void freePatternSrc(highlightPattern *pat, int freeStruct);
static void freePatternSet(patternSet *p);

/* list of available highlight styles */
static int NHighlightStyles = 0;
static highlightStyleRec *HighlightStyles[MAX_HIGHLIGHT_STYLES];

/* Highlight styles dialog information */
static struct {
    Widget shell;
    Widget nameW;
    Widget colorW;
    Widget recogW;
    Widget plainW, boldW, italicW, boldItalicW;
    Widget managedListW;
    highlightStyleRec **highlightStyleList;
    int nHighlightStyles;
} HSDialog = {NULL};

/* Highlight dialog information */
static struct {
    Widget shell;
    Widget lmOptMenu;
    Widget lmPulldown;
    Widget styleOptMenu;
    Widget stylePulldown;
    Widget nameW;
    Widget topLevelW;
    Widget deferredW;
    Widget subPatW;
    Widget colorPatW;
    Widget simpleW;
    Widget rangeW;
    Widget parentW;
    Widget startW;
    Widget endW;
    Widget errorW;
    Widget lineContextW;
    Widget charContextW;
    Widget managedListW;
    Widget parentLbl;
    Widget startLbl;
    Widget endLbl;
    Widget errorLbl;
    Widget matchLbl;
    char *langModeName;
    int nPatterns;
    highlightPattern **patterns;
} HighlightDialog = {NULL, NULL, NULL};

/* Pattern sources loaded from the .nedit file or set by the user */
static int NPatternSets = 0;
static patternSet *PatternSets[MAX_PATTERN_SETS];

#ifdef VMS
#define N_DEFAULT_PATTERN_SETS 20
#else
#define N_DEFAULT_PATTERN_SETS 21
#endif /*VMS*/

static char AuxString0[] = {'C',':','1',':','0',' ','{','\n',
' ',' ',' ',' ','	','c','o','m','m','e','n','t',':','\"','/','\\','*','\"',':','\"','\\','*','/','\"',':',':','C','o','m','m','e','n','t',':',':','\n',
' ',' ',' ',' ','	','s','t','r','i','n','g',':','\"','\"','\"','\"',':','\"','\"','\"','\"',':','\"','\\','n','\"',':','S','t','r','i','n','g',':',':','\n',
' ',' ',' ',' ','	','p','r','e','p','r','o','c','e','s','s','o','r',' ','l','i','n','e',':','\"','^','[',' ','\t',']','*','#','\"',':','\"','$','\"',':',':','P','r','e','p','r','o','c','e','s','s','o','r',':',':','\n',
' ',' ',' ',' ','	','s','t','r','i','n','g',' ','e','s','c','a','p','e',' ','c','h','a','r','s',':','\"','\\','\\','(','.','|','\\','n',')','\"',':',':',':','S','t','r','i','n','g','1',':','s','t','r','i','n','g',':','\n',
' ',' ',' ',' ','	','p','r','e','p','r','o','c','e','s','s','o','r',' ','e','s','c',' ','c','h','a','r','s',':','\"','\\','\\','(','.','|','\\','n',')','\"',':',':',':','P','r','e','p','r','o','c','e','s','s','o','r','1',':','p','r','e','p','r','o','c','e','s','s','o','r',' ','l','i','n','e',':','\n',
' ',' ',' ',' ','	','p','r','e','p','r','o','c','e','s','s','o','r',' ','c','o','m','m','e','n','t',':','\"','/','\\','*','\"',':','\"','\\','*','/','\"',':',':','C','o','m','m','e','n','t',':','p','r','e','p','r','o','c','e','s','s','o','r',' ','l','i','n','e',':','\n',
' ',' ',' ',' ','	','c','h','a','r','a','c','t','e','r',' ','c','o','n','s','t','a','n','t',':','\"',''','\"',':','\"',''','\"',':','\"','[','^','\\','\\',']','[','^',''',']','\"',':','C','h','a','r','a','c','t','e','r',' ','C','o','n','s','t',':',':','\n',
'	','n','u','m','e','r','i','c',' ','c','o','n','s','t','a','n','t',':','\"','<','(','(','0','(','x','|','X',')','[','0','-','9','a','-','f','A','-','F',']','*',')','|','(','(','[','0','-','9',']','+','\\','.','?','[','0','-','9',']','*',')','|','(','\\','.','[','0','-','9',']','+',')',')','(','(','e','|','E',')','(','\\','+','|','-',')','?','[','0','-','9',']','+',')','?',')','(','L','|','l','|','U','L','|','u','l','|','u','|','U','|','F','|','f',')','?','>','\"',':',':',':','N','u','m','e','r','i','c',' ','C','o','n','s','t',':',':','D','\n',
' ',' ',' ',' ','	','s','t','o','r','a','g','e',' ','k','e','y','w','o','r','d',':','\"','<','(','c','o','n','s','t','|','e','x','t','e','r','n','|','a','u','t','o','|','r','e','g','i','s','t','e','r','|','s','t','a','t','i','c','|','u','n','s','i','g','n','e','d','|','s','i','g','n','e','d','|','v','o','l','a','t','i','l','e','|','c','h','a','r','|','d','o','u','b','l','e','|','f','l','o','a','t','|','i','n','t','|','l','o','n','g','|','s','h','o','r','t','|','v','o','i','d','|','t','y','p','e','d','e','f','|','s','t','r','u','c','t','|','u','n','i','o','n','|','e','n','u','m',')','>','\"',':',':',':','S','t','o','r','a','g','e',' ','T','y','p','e',':',':','D','\n',
' ',' ',' ',' ','	','k','e','y','w','o','r','d',':','\"','<','(','r','e','t','u','r','n','|','g','o','t','o','|','i','f','|','e','l','s','e','|','c','a','s','e','|','d','e','f','a','u','l','t','|','s','w','i','t','c','h','|','b','r','e','a','k','|','c','o','n','t','i','n','u','e','|','w','h','i','l','e','|','d','o','|','f','o','r','|','s','i','z','e','o','f',')','>','\"',':',':',':','K','e','y','w','o','r','d',':',':','D','\n',
' ',' ',' ',' ','	','b','r','a','c','e','s',':','\"','[','{','}',']','\"',':',':',':','K','e','y','w','o','r','d',':',':','D','}','\0'};
static char AuxString1[] = {'C','+','+',':','1',':','0',' ','{','\n',
' ',' ',' ',' ','	','c','o','m','m','e','n','t',':','\"','/','\\','*','\"',':','\"','\\','*','/','\"',':',':','C','o','m','m','e','n','t',':',':','\n',
' ',' ',' ',' ','	','c','p','l','u','s',' ','c','o','m','m','e','n','t',':','\"','/','/','\"',':','\"','$','\"',':',':','C','o','m','m','e','n','t',':',':','\n',
' ',' ',' ',' ','	','s','t','r','i','n','g',':','\"','\"','\"','\"',':','\"','\"','\"','\"',':','\"','\\','n','\"',':','S','t','r','i','n','g',':',':','\n',
' ',' ',' ',' ','	','p','r','e','p','r','o','c','e','s','s','o','r',' ','l','i','n','e',':','\"','^','[',' ','\t',']','*','#','\"',':','\"','$','\"',':',':','P','r','e','p','r','o','c','e','s','s','o','r',':',':','\n',
' ',' ',' ',' ','	','s','t','r','i','n','g',' ','e','s','c','a','p','e',' ','c','h','a','r','s',':','\"','\\','\\','(','.','|','\\','n',')','\"',':',':',':','S','t','r','i','n','g','1',':','s','t','r','i','n','g',':','\n',
' ',' ',' ',' ','	','p','r','e','p','r','o','c','e','s','s','o','r',' ','e','s','c',' ','c','h','a','r','s',':','\"','\\','\\','(','.','|','\\','n',')','\"',':',':',':','P','r','e','p','r','o','c','e','s','s','o','r','1',':','p','r','e','p','r','o','c','e','s','s','o','r',' ','l','i','n','e',':','\n',
' ',' ',' ',' ','	','p','r','e','p','r','o','c','e','s','s','o','r',' ','c','o','m','m','e','n','t',':','\"','/','\\','*','\"',':','\"','\\','*','/','\"',':',':','C','o','m','m','e','n','t',':','p','r','e','p','r','o','c','e','s','s','o','r',' ','l','i','n','e',':','\n',
' ',' ',' ',' ','	','p','r','e','p','r','o','c',' ','c','p','l','u','s',' ','c','o','m','m','e','n','t',':','\"','/','/','\"',':','\"','$','\"',':',':','C','o','m','m','e','n','t',':','p','r','e','p','r','o','c','e','s','s','o','r',' ','l','i','n','e',':','\n',
' ',' ',' ',' ','	','c','h','a','r','a','c','t','e','r',' ','c','o','n','s','t','a','n','t',':','\"',''','\"',':','\"',''','\"',':','\"','[','^','\\','\\',']','[','^',''',']','\"',':','C','h','a','r','a','c','t','e','r',' ','C','o','n','s','t',':',':','\n',
'	','n','u','m','e','r','i','c',' ','c','o','n','s','t','a','n','t',':','\"','<','(','(','0','(','x','|','X',')','[','0','-','9','a','-','f','A','-','F',']','*',')','|','(','(','[','0','-','9',']','+','\\','.','?','[','0','-','9',']','*',')','|','(','\\','.','[','0','-','9',']','+',')',')','(','(','e','|','E',')','(','\\','+','|','-',')','?','[','0','-','9',']','+',')','?',')','(','L','|','l','|','U','L','|','u','l','|','u','|','U','|','F','|','f',')','?','>','\"',':',':',':','N','u','m','e','r','i','c',' ','C','o','n','s','t',':',':','D','\n',
' ',' ',' ',' ','	','s','t','o','r','a','g','e',' ','k','e','y','w','o','r','d',':','\"','<','(','c','l','a','s','s','|','t','y','p','e','n','a','m','e','|','t','y','p','e','i','d','|','t','e','m','p','l','a','t','e','|','f','r','i','e','n','d','|','v','i','r','t','u','a','l','|','i','n','l','i','n','e','|','e','x','p','l','i','c','i','t','|','o','p','e','r','a','t','o','r','|','o','v','e','r','l','o','a','d','|','p','u','b','l','i','c','|','p','r','i','v','a','t','e','|','p','r','o','t','e','c','t','e','d','|','c','o','n','s','t','|','e','x','t','e','r','n','|','a','u','t','o','|','r','e','g','i','s','t','e','r','|','s','t','a','t','i','c','|','m','u','t','a','b','l','e','|','u','n','s','i','g','n','e','d','|','s','i','g','n','e','d','|','v','o','l','a','t','i','l','e','|','c','h','a','r','|','d','o','u','b','l','e','|','f','l','o','a','t','|','i','n','t','|','l','o','n','g','|','s','h','o','r','t','|','b','o','o','l','|','w','c','h','a','r','_','t','|','v','o','i','d','|','t','y','p','e','d','e','f','|','s','t','r','u','c','t','|','u','n','i','o','n','|','e','n','u','m',')','>','\"',':',':',':','S','t','o','r','a','g','e',' ','T','y','p','e',':',':','D','\n',
' ',' ',' ',' ','	','k','e','y','w','o','r','d',':','\"','<','(','n','e','w','|','d','e','l','e','t','e','|','t','h','i','s','|','r','e','t','u','r','n','|','g','o','t','o','|','i','f','|','e','l','s','e','|','c','a','s','e','|','d','e','f','a','u','l','t','|','s','w','i','t','c','h','|','b','r','e','a','k','|','c','o','n','t','i','n','u','e','|','w','h','i','l','e','|','d','o','|','f','o','r','|','c','a','t','c','h','|','t','h','r','o','w','|','s','i','z','e','o','f','|','t','r','u','e','|','f','a','l','s','e','|','n','a','m','e','s','p','a','c','e','|','u','s','i','n','g','|','d','y','n','a','m','i','c','_','c','a','s','t','|','s','t','a','t','i','c','_','c','a','s','t','|','r','e','i','n','t','e','r','p','r','e','t','_','c','a','s','t',')','>','\"',':',':',':','K','e','y','w','o','r','d',':',':','D','\n',
' ',' ',' ',' ','	','b','r','a','c','e','s',':','\"','[','{','}',']','\"',':',':',':','K','e','y','w','o','r','d',':',':','D','}','\0'};
static char AuxString2[] = {'H','T','M','L',':','1',':','0',' ','{','\n',
'	','s','p','e','c','i','a','l',' ','c','h','a','r','s',':','\"','\\','&','[','-','.','a','-','z','A','-','Z','0','-','9','#',']','*',';','?','\"',':',':',':','T','e','x','t',' ','E','s','c','a','p','e',':',':','\n',
'	','c','o','m','m','e','n','t',':','\"','\\','<','!','-','-','\"',':','\"','-','-','\\','>','\"',':',':','T','e','x','t',' ','C','o','m','m','e','n','t',':',':','\n',
'	','e','l','e','m','e','n','t',':','\"','(','\\','<',')','(','/','|','!',')','?','[','-','.','a','-','z','A','-','Z','0','-','9',']','*','\"',':','\"','\\','>','\"',':','\"','[','^','-','.','a','-','z','A','-','Z','0','-','9',' ','\\','t','\\','n','=','\"','\"',''','%',']','\"',':','T','e','x','t',' ','K','e','y',':',':','\n',
'	','d','o','u','b','l','e',' ','q','u','o','t','e',' ','s','t','r','i','n','g',':','\"','\"','\"','\"',':','\"','\"','\"','\"',':','\"','[','<','>',']','\"',':','T','e','x','t',' ','A','r','g','1',':','e','l','e','m','e','n','t',':','\n',
'	','s','i','n','g','l','e',' ','q','u','o','t','e',' ','s','t','r','i','n','g',':','\"',''','\"',':','\"',''','\"',':','\"','[','<','>',']','\"',':','T','e','x','t',' ','A','r','g','1',':','e','l','e','m','e','n','t',':','\n',
'	','a','t','t','r','i','b','u','t','e',':','\"','[','^',''','\"','\"',']','|','\\','n','\"',':',':',':','T','e','x','t',' ','A','r','g',':','e','l','e','m','e','n','t',':','\n',
'	','b','r','a','c','k','e','t','s',':','\"','\\','1','\"',':','\"','\\','0','\"',':',':','T','e','x','t',' ','A','r','g',':','e','l','e','m','e','n','t',':','C','}','\0'};
static char AuxString3[] = {'J','a','v','a',':','1',':','0',' ','{','\n',
'	','c','o','m','m','e','n','t',':','\"','/','\\','*','\"',':','\"','\\','*','/','\"',':',':','C','o','m','m','e','n','t',':',':','\n',
'	','c','p','l','u','s',' ','c','o','m','m','e','n','t',':','\"','/','/','\"',':','\"','$','\"',':',':','C','o','m','m','e','n','t',':',':','\n',
'	','s','t','r','i','n','g',':','\"','\"','\"','\"',':','\"','\"','\"','\"',':','\"','\\','n','\"',':','S','t','r','i','n','g',':',':','\n',
'	','s','i','n','g','l','e',' ','q','u','o','t','e','d',':','\"',''','\"',':','\"',''','\"',':','\"','[','^','\\','\\',']','[','^',''',']','\"',':','S','t','r','i','n','g',':',':','\n',
'	','n','u','m','e','r','i','c',' ','c','o','n','s','t',':','\"','<','(','(','0','(','x','|','X',')','[','0','-','9','a','-','f','A','-','F',']','*',')','|','[','0','-','9','.',']','+','(','(','e','|','E',')','(','\\','+','|','-',')','?',')','?','[','0','-','9',']','*',')','(','L','|','l','|','U','L','|','u','l','|','u','|','U','|','F','|','f',')','?','>','\"',':',':',':','N','u','m','e','r','i','c',' ','C','o','n','s','t',':',':','\n',
'	','i','n','c','l','u','d','e',':','\"','<','(','i','m','p','o','r','t','|','p','a','c','k','a','g','e',')','>','\"',':','\"','$','\"',':',':','P','r','e','p','r','o','c','e','s','s','o','r',':',':','\n',
'	','s','t','o','r','a','g','e',' ','k','e','y','w','o','r','d',':','\"','<','(','a','b','s','t','r','a','c','t','|','b','o','o','l','e','a','n','|','b','y','t','e','|','c','h','a','r','|','c','l','a','s','s','|','d','o','u','b','l','e','|','e','x','t','e','n','d','s','|','f','i','n','a','l','|','f','l','o','a','t','|','i','n','t','|','i','n','t','e','r','f','a','c','e','|','l','o','n','g','|','n','a','t','i','v','e','|','p','r','i','v','a','t','e','|','p','r','o','t','e','c','t','e','d','|','p','u','b','l','i','c','|','s','h','o','r','t','|','s','t','a','t','i','c','|','t','r','a','n','s','i','e','n','t','|','s','y','n','c','h','r','o','n','i','z','e','d','|','v','o','i','d','|','v','o','l','a','t','i','l','e','|','i','m','p','l','e','m','e','n','t','s',')','>','\"',':',':',':','S','t','o','r','a','g','e',' ','T','y','p','e',':',':','\n',
'	','k','e','y','w','o','r','d',':','\"','<','(','b','r','e','a','k','|','c','a','s','e','|','c','a','t','c','h','|','c','o','n','t','i','n','u','e','|','d','e','f','a','u','l','t','|','d','o','|','e','l','s','e','|','f','a','l','s','e','|','f','i','n','a','l','l','y','|','f','o','r','|','i','f','|','i','n','s','t','a','n','c','e','o','f','|','n','e','w','|','n','u','l','l','|','r','e','t','u','r','n','|','s','u','p','e','r','|','s','w','i','t','c','h','|','t','h','i','s','|','t','h','r','o','w','|','t','h','r','o','w','s','|','t','r','u','e','|','t','r','y','|','w','h','i','l','e',')','>','\"',':',':',':','K','e','y','w','o','r','d',':',':','\n',
'	','b','r','a','c','e','s',' ','a','n','d',' ','p','a','r','e','n','s',':','\"','[','{','(',')','}',']','\"',':',':',':','K','e','y','w','o','r','d',':',':','\n',
'	','s','t','r','i','n','g',' ','e','s','c','a','p','e',' ','c','h','a','r','s',':','\"','\\','\\','(','.','|','\\','n',')','\"',':',':',':','S','t','r','i','n','g','1',':','s','t','r','i','n','g',':','\n',
'	','i','n','c','l','u','d','e',' ','e','s','c',' ','c','h','a','r','s',':','\"','\\','\\','(','.','|','\\','n',')','\"',':',':',':','P','r','e','p','r','o','c','e','s','s','o','r','1',':','i','n','c','l','u','d','e',':','\n',
'	','i','n','c','l','u','d','e',' ','c','o','m','m','e','n','t',':','\"','/','\\','*','\"',':','\"','\\','*','/','\"',':',':','C','o','m','m','e','n','t',':','i','n','c','l','u','d','e',':','}','\0'};
#ifndef VMS
static char AuxString4[] = {'J','a','v','a','S','c','r','i','p','t',':','1',':','0','{','\n',
' ',' ',' ',' ',' ',' ',' ',' ','D','S','C','o','m','m','e','n','t',':','\"','/','/','\"',':','\"','$','\"',':',':','C','o','m','m','e','n','t',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','M','L','C','o','m','m','e','n','t',':','\"','/','\\','*','\"',':','\"','\\','*','/','\"',':',':','C','o','m','m','e','n','t',':',':','\n',
'	','D','Q','C','o','l','o','r','s',':','\"','a','l','i','c','e','b','l','u','e','|','a','n','t','i','q','u','e','w','h','i','t','e','|','a','q','u','a','|','a','q','u','a','m','a','r','i','n','e','|','a','z','u','r','e','|','b','e','i','g','e','|','b','i','s','q','u','e','|','b','l','a','c','k','|','b','l','a','n','c','h','e','d','a','l','m','o','n','d','|','b','l','u','e','|','b','l','u','e','v','i','o','l','e','t','|','b','r','o','w','n','|','b','u','r','l','y','w','o','o','d','|','c','a','d','e','t','b','l','u','e','|','c','h','a','r','t','r','e','u','s','e','|','c','h','o','c','o','l','a','t','e','|','c','o','r','a','l','|','c','o','r','n','f','l','o','w','e','r','b','l','u','e','|','c','o','r','n','s','i','l','k','|','c','r','i','m','s','o','n','|','c','y','a','n','|','d','a','r','k','b','l','u','e','|','d','a','r','k','c','y','a','n','|','d','a','r','k','g','o','l','d','e','n','r','o','d','|','d','a','r','k','g','r','a','y','|','d','a','r','k','g','r','e','e','n','|','d','a','r','k','k','h','a','k','i','|','d','a','r','k','m','a','g','e','n','t','a','|','d','a','r','k','o','l','i','v','e','g','r','e','e','n','|','d','a','r','k','o','r','a','n','g','e','|','d','a','r','k','o','r','c','h','i','d','|','d','a','r','k','r','e','d','|','d','a','r','k','s','a','l','m','o','n','|','d','a','r','k','s','e','a','g','r','e','e','n','|','d','a','r','k','s','l','a','t','e','b','l','u','e','|','d','a','r','k','s','l','a','t','e','g','r','a','y','|','d','a','r','k','t','u','r','q','u','o','i','s','e','|','d','a','r','k','v','i','o','l','e','t','|','d','e','e','p','p','i','n','k','|','d','e','e','p','s','k','y','b','l','u','e','|','d','i','m','g','r','a','y','|','d','o','d','g','e','r','b','l','u','e','|','f','i','r','e','b','r','i','c','k','|','f','l','o','r','a','l','w','h','i','t','e','|','f','o','r','e','s','t','g','r','e','e','n','|','f','u','c','h','s','i','a','|','g','a','i','n','s','b','o','r','o','|','g','h','o','s','t','w','h','i','t','e','|','g','o','l','d','|','g','o','l','d','e','n','r','o','d','|','g','r','a','y','|','g','r','e','e','n','|','g','r','e','e','n','y','e','l','l','o','w','|','h','o','n','e','y','d','e','w','|','h','o','t','p','i','n','k','|','i','n','d','i','a','n','r','e','d','|','i','n','d','i','g','o','|','i','v','o','r','y','|','k','h','a','k','i','|','l','a','v','e','n','d','e','r','|','l','a','v','e','n','d','e','r','b','l','u','s','h','|','l','a','w','n','g','r','e','e','n','|','l','e','m','o','n','c','h','i','f','f','o','n','|','l','i','g','h','t','b','l','u','e','|','l','i','g','h','t','c','o','r','a','l','|','l','i','g','h','t','c','y','a','n','|','l','i','g','h','t','g','o','l','d','e','n','r','o','d','y','e','l','l','o','w','|','l','i','g','h','t','g','r','e','e','n','|','l','i','g','h','t','g','r','e','y','|','l','i','g','h','t','p','i','n','k','|','l','i','g','h','t','s','a','l','m','o','n','|','l','i','g','h','t','s','e','a','g','r','e','e','n','|','l','i','g','h','t','s','k','y','b','l','u','e','|','l','i','g','h','t','s','l','a','t','e','g','r','a','y','|','l','i','g','h','t','s','t','e','e','l','b','l','u','e','|','l','i','g','h','t','y','e','l','l','o','w','|','l','i','m','e','|','l','i','m','e','g','r','e','e','n','|','l','i','n','e','n','|','m','a','g','e','n','t','a','|','m','a','r','o','o','n','|','m','e','d','i','u','m','a','q','u','a','m','a','r','i','n','e','|','m','e','d','i','u','m','b','l','u','e','|','m','e','d','i','u','m','o','r','c','h','i','d','|','m','e','d','i','u','m','p','u','r','p','l','e','|','m','e','d','i','u','m','s','e','a','g','r','e','e','n','|','m','e','d','i','u','m','s','l','a','t','e','b','l','u','e','|','m','e','d','i','u','m','s','p','r','i','n','g','g','r','e','e','n','|','m','e','d','i','u','m','t','u','r','q','u','o','i','s','e','|','m','e','d','i','u','m','v','i','o','l','e','t','r','e','d','|','m','i','d','n','i','g','h','t','b','l','u','e','|','m','i','n','t','c','r','e','a','m','|','m','i','s','t','y','r','o','s','e','|','m','o','c','c','a','s','i','n','|','n','a','v','a','j','o','w','h','i','t','e','|','n','a','v','y','|','o','l','d','l','a','c','e','|','o','l','i','v','e','|','o','l','i','v','e','d','r','a','b','|','o','r','a','n','g','e','|','o','r','a','n','g','e','r','e','d','|','o','r','c','h','i','d','|','p','a','l','e','g','o','l','d','e','n','r','o','d','|','p','a','l','e','g','r','e','e','n','|','p','a','l','e','t','u','r','q','u','o','i','s','e','|','p','a','l','e','v','i','o','l','e','t','r','e','d','|','p','a','p','a','y','a','w','h','i','p','|','p','e','a','c','h','p','u','f','f','|','p','e','r','u','|','p','i','n','k','|','p','l','u','m','|','p','o','w','d','e','r','b','l','u','e','|','p','u','r','p','l','e','|','r','e','d','|','r','o','s','y','b','r','o','w','n','|','r','o','y','a','l','b','l','u','e','|','s','a','d','d','l','e','b','r','o','w','n','|','s','a','l','m','o','n','|','s','a','n','d','y','b','r','o','w','n','|','s','e','a','g','r','e','e','n','|','s','e','a','s','h','e','l','l','|','s','i','e','n','n','a','|','s','i','l','v','e','r','|','s','k','y','b','l','u','e','|','s','l','a','t','e','b','l','u','e','|','s','l','a','t','e','g','r','a','y','|','s','n','o','w','|','s','p','r','i','n','g','g','r','e','e','n','|','s','t','e','e','l','b','l','u','e','|','t','a','n','|','t','e','a','l','|','t','h','i','s','t','l','e','|','t','o','m','a','t','o','|','t','u','r','q','u','o','i','s','e','|','v','i','o','l','e','t','|','w','h','e','a','t','|','w','h','i','t','e','|','w','h','i','t','e','s','m','o','k','e','|','y','e','l','l','o','w','|','y','e','l','l','o','w','g','r','e','e','n','|','#','[','A','-','F','a','-','f','0','-','9',']','[','A','-','F','a','-','f','0','-','9',']','[','A','-','F','a','-','f','0','-','9',']','[','A','-','F','a','-','f','0','-','9',']','[','A','-','F','a','-','f','0','-','9',']','[','A','-','F','a','-','f','0','-','9',']','\"',':',':',':','T','e','x','t',' ','A','r','g','1',':','D','Q','S','t','r','i','n','g','s',':','\n',
'	','S','Q','C','o','l','o','r','s',':','\"','a','l','i','c','e','b','l','u','e','|','a','n','t','i','q','u','e','w','h','i','t','e','|','a','q','u','a','|','a','q','u','a','m','a','r','i','n','e','|','a','z','u','r','e','|','b','e','i','g','e','|','b','i','s','q','u','e','|','b','l','a','c','k','|','b','l','a','n','c','h','e','d','a','l','m','o','n','d','|','b','l','u','e','|','b','l','u','e','v','i','o','l','e','t','|','b','r','o','w','n','|','b','u','r','l','y','w','o','o','d','|','c','a','d','e','t','b','l','u','e','|','c','h','a','r','t','r','e','u','s','e','|','c','h','o','c','o','l','a','t','e','|','c','o','r','a','l','|','c','o','r','n','f','l','o','w','e','r','b','l','u','e','|','c','o','r','n','s','i','l','k','|','c','r','i','m','s','o','n','|','c','y','a','n','|','d','a','r','k','b','l','u','e','|','d','a','r','k','c','y','a','n','|','d','a','r','k','g','o','l','d','e','n','r','o','d','|','d','a','r','k','g','r','a','y','|','d','a','r','k','g','r','e','e','n','|','d','a','r','k','k','h','a','k','i','|','d','a','r','k','m','a','g','e','n','t','a','|','d','a','r','k','o','l','i','v','e','g','r','e','e','n','|','d','a','r','k','o','r','a','n','g','e','|','d','a','r','k','o','r','c','h','i','d','|','d','a','r','k','r','e','d','|','d','a','r','k','s','a','l','m','o','n','|','d','a','r','k','s','e','a','g','r','e','e','n','|','d','a','r','k','s','l','a','t','e','b','l','u','e','|','d','a','r','k','s','l','a','t','e','g','r','a','y','|','d','a','r','k','t','u','r','q','u','o','i','s','e','|','d','a','r','k','v','i','o','l','e','t','|','d','e','e','p','p','i','n','k','|','d','e','e','p','s','k','y','b','l','u','e','|','d','i','m','g','r','a','y','|','d','o','d','g','e','r','b','l','u','e','|','f','i','r','e','b','r','i','c','k','|','f','l','o','r','a','l','w','h','i','t','e','|','f','o','r','e','s','t','g','r','e','e','n','|','f','u','c','h','s','i','a','|','g','a','i','n','s','b','o','r','o','|','g','h','o','s','t','w','h','i','t','e','|','g','o','l','d','|','g','o','l','d','e','n','r','o','d','|','g','r','a','y','|','g','r','e','e','n','|','g','r','e','e','n','y','e','l','l','o','w','|','h','o','n','e','y','d','e','w','|','h','o','t','p','i','n','k','|','i','n','d','i','a','n','r','e','d','|','i','n','d','i','g','o','|','i','v','o','r','y','|','k','h','a','k','i','|','l','a','v','e','n','d','e','r','|','l','a','v','e','n','d','e','r','b','l','u','s','h','|','l','a','w','n','g','r','e','e','n','|','l','e','m','o','n','c','h','i','f','f','o','n','|','l','i','g','h','t','b','l','u','e','|','l','i','g','h','t','c','o','r','a','l','|','l','i','g','h','t','c','y','a','n','|','l','i','g','h','t','g','o','l','d','e','n','r','o','d','y','e','l','l','o','w','|','l','i','g','h','t','g','r','e','e','n','|','l','i','g','h','t','g','r','e','y','|','l','i','g','h','t','p','i','n','k','|','l','i','g','h','t','s','a','l','m','o','n','|','l','i','g','h','t','s','e','a','g','r','e','e','n','|','l','i','g','h','t','s','k','y','b','l','u','e','|','l','i','g','h','t','s','l','a','t','e','g','r','a','y','|','l','i','g','h','t','s','t','e','e','l','b','l','u','e','|','l','i','g','h','t','y','e','l','l','o','w','|','l','i','m','e','|','l','i','m','e','g','r','e','e','n','|','l','i','n','e','n','|','m','a','g','e','n','t','a','|','m','a','r','o','o','n','|','m','e','d','i','u','m','a','q','u','a','m','a','r','i','n','e','|','m','e','d','i','u','m','b','l','u','e','|','m','e','d','i','u','m','o','r','c','h','i','d','|','m','e','d','i','u','m','p','u','r','p','l','e','|','m','e','d','i','u','m','s','e','a','g','r','e','e','n','|','m','e','d','i','u','m','s','l','a','t','e','b','l','u','e','|','m','e','d','i','u','m','s','p','r','i','n','g','g','r','e','e','n','|','m','e','d','i','u','m','t','u','r','q','u','o','i','s','e','|','m','e','d','i','u','m','v','i','o','l','e','t','r','e','d','|','m','i','d','n','i','g','h','t','b','l','u','e','|','m','i','n','t','c','r','e','a','m','|','m','i','s','t','y','r','o','s','e','|','m','o','c','c','a','s','i','n','|','n','a','v','a','j','o','w','h','i','t','e','|','n','a','v','y','|','o','l','d','l','a','c','e','|','o','l','i','v','e','|','o','l','i','v','e','d','r','a','b','|','o','r','a','n','g','e','|','o','r','a','n','g','e','r','e','d','|','o','r','c','h','i','d','|','p','a','l','e','g','o','l','d','e','n','r','o','d','|','p','a','l','e','g','r','e','e','n','|','p','a','l','e','t','u','r','q','u','o','i','s','e','|','p','a','l','e','v','i','o','l','e','t','r','e','d','|','p','a','p','a','y','a','w','h','i','p','|','p','e','a','c','h','p','u','f','f','|','p','e','r','u','|','p','i','n','k','|','p','l','u','m','|','p','o','w','d','e','r','b','l','u','e','|','p','u','r','p','l','e','|','r','e','d','|','r','o','s','y','b','r','o','w','n','|','r','o','y','a','l','b','l','u','e','|','s','a','d','d','l','e','b','r','o','w','n','|','s','a','l','m','o','n','|','s','a','n','d','y','b','r','o','w','n','|','s','e','a','g','r','e','e','n','|','s','e','a','s','h','e','l','l','|','s','i','e','n','n','a','|','s','i','l','v','e','r','|','s','k','y','b','l','u','e','|','s','l','a','t','e','b','l','u','e','|','s','l','a','t','e','g','r','a','y','|','s','n','o','w','|','s','p','r','i','n','g','g','r','e','e','n','|','s','t','e','e','l','b','l','u','e','|','t','a','n','|','t','e','a','l','|','t','h','i','s','t','l','e','|','t','o','m','a','t','o','|','t','u','r','q','u','o','i','s','e','|','v','i','o','l','e','t','|','w','h','e','a','t','|','w','h','i','t','e','|','w','h','i','t','e','s','m','o','k','e','|','y','e','l','l','o','w','|','y','e','l','l','o','w','g','r','e','e','n','|','(','#',')','[','A','-','F','a','-','f','0','-','9',']','[','A','-','F','a','-','f','0','-','9',']','[','A','-','F','a','-','f','0','-','9',']','[','A','-','F','a','-','f','0','-','9',']','[','A','-','F','a','-','f','0','-','9',']','[','A','-','F','-','a','f','0','-','9',']','\"',':',':',':','T','e','x','t',' ','A','r','g','1',':','S','Q','S','t','r','i','n','g','s',':','\n',
'	','N','u','m','e','r','i','c',':','\"','<','(','(','0','(','x','|','X',')','[','0','-','9','a','-','f','A','-','F',']','*',')','|','[','0','-','9','.',']','+','(','(','e','|','E',')','(','\\','+','|','-',')','?',')','?','[','0','-','9',']','*',')','(','L','|','l','|','U','L','|','u','l','|','u','|','U','|','F','|','f',')','?','>','\"',':',':',':','N','u','m','e','r','i','c',' ','C','o','n','s','t',':',':','\n',
'	','E','v','e','n','t','s',':','\"','<','(','o','n','A','b','o','r','t','|','o','n','B','l','u','r','|','o','n','C','l','i','c','k','|','o','n','C','h','a','n','g','e','|','o','n','D','b','l','C','l','i','c','k','|','o','n','D','r','a','g','D','r','o','p','|','o','n','E','r','r','o','r','|','o','n','F','o','c','u','s','|','o','n','K','e','y','D','o','w','n','|','o','n','K','e','y','P','r','e','s','s','|','o','n','L','o','a','d','|','o','n','M','o','u','s','e','D','o','w','n','|','o','n','M','o','u','s','e','M','o','v','e','|','o','n','M','o','u','s','e','O','u','t','|','o','n','M','o','u','s','e','O','v','e','r','|','o','n','M','o','u','s','e','U','p','|','o','n','M','o','v','e','|','o','n','R','e','s','i','z','e','|','o','n','S','e','l','e','c','t','|','o','n','S','u','b','m','i','t','|','o','n','U','n','l','o','a','d',')','>','\"',':',':',':','K','e','y','w','o','r','d',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','B','r','a','c','e','s',':','\"','[','{','}',']','\"',':',':',':','K','e','y','w','o','r','d',':',':','\n',
'	','S','t','a','t','e','m','e','n','t','s',':','\"','<','(','b','r','e','a','k','|','c','o','n','t','i','n','u','e','|','e','l','s','e','|','f','o','r','|','i','f','|','i','n','|','n','e','w','|','r','e','t','u','r','n','|','t','h','i','s','|','t','y','p','e','o','f','|','v','a','r','|','w','h','i','l','e','|','w','i','t','h',')','>','\"',':',':',':','K','e','y','w','o','r','d',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','F','u','n','c','t','i','o','n',':','\"','f','u','n','c','t','i','o','n','[','\\','t',' ',']','+','(','[','a','-','z','A','-','Z','0','-','9','_',']','+',')','[','\\','t',' ','\\','(',']','+','\"',':','\"','[','\\','n','{',']','\"',':',':','K','e','y','w','o','r','d',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','F','u','n','c','t','i','o','n','N','a','m','e',':','\"','\\','1','\"',':','\"','\"',':',':','S','t','o','r','a','g','e',' ','T','y','p','e',':','F','u','n','c','t','i','o','n',':','C','\n',
' ',' ',' ',' ',' ',' ',' ',' ','F','u','n','c','t','i','o','n','A','r','g','s',':','\"','\\','(','\"',':','\"','\\',')','\"',':',':','T','e','x','t',' ','A','r','g',':','F','u','n','c','t','i','o','n',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','P','a','r','e','n','t','h','e','s','e','s',':','\"','[','\\','(','\\',')',']','\"',':',':',':','P','l','a','i','n',':',':','\n',
'	','B','u','i','l','t','I','n','O','b','j','e','c','t','T','y','p','e',':','\"','<','(','a','n','c','h','o','r','|','A','p','p','l','e','t','|','A','r','e','a','|','A','r','r','a','y','|','b','u','t','t','o','n','|','c','h','e','c','k','b','o','x','|','D','a','t','e','|','d','o','c','u','m','e','n','t','|','e','l','e','m','e','n','t','s','|','F','i','l','e','U','p','l','o','a','d','|','f','o','r','m','|','f','r','a','m','e','|','F','u','n','c','t','i','o','n','|','h','i','d','d','e','n','|','h','i','s','t','o','r','y','|','I','m','a','g','e','|','l','i','n','k','|','l','o','c','a','t','i','o','n','|','M','a','t','h','|','n','a','v','i','g','a','t','o','r','|','O','p','t','i','o','n','|','p','a','s','s','w','o','r','d','|','P','l','u','g','i','n','|','r','a','d','i','o','|','r','e','s','e','t','|','s','e','l','e','c','t','|','s','t','r','i','n','g','|','s','u','b','m','i','t','|','t','e','x','t','|','t','e','x','t','a','r','e','a','|','w','i','n','d','o','w',')','>','\"',':',':',':','S','t','o','r','a','g','e',' ','T','y','p','e',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','S','Q','S','t','r','i','n','g','s',':','\"',''','\"',':','\"',''','\"',':','\"','\\','n','\"',':','S','t','r','i','n','g',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','D','Q','S','t','r','i','n','g','s',':','\"','\"','\"','\"',':','\"','\"','\"','\"',':','\"','\\','n','\"',':','S','t','r','i','n','g',':',':','\n',
'	','E','v','e','n','t','C','a','p','t','u','r','i','n','g',':','\"','c','a','p','t','u','r','e','E','v','e','n','t','s','|','r','e','l','e','a','s','e','E','v','e','n','t','s','|','r','o','u','t','e','E','v','e','n','t','|','h','a','n','d','l','e','E','v','e','n','t','\"',':','\"','\\',')','\"',':','\"','\\','n','\"',':','K','e','y','w','o','r','d',':',':','\n',
'	','P','r','e','d','e','f','i','n','e','d','M','e','t','h','o','d','s',':','\"','<','(','a','b','s','|','a','c','o','s','|','a','l','e','r','t','|','a','n','c','h','o','r','|','a','s','i','n','|','a','t','a','n','|','a','t','a','n','2','|','b','a','c','k','|','b','i','g','|','b','l','i','n','k','|','b','l','u','r','|','b','o','l','d','|','c','e','i','l','|','c','h','a','r','A','t','|','c','l','e','a','r','|','c','l','e','a','r','T','i','m','e','o','u','t','|','c','l','i','c','k','|','c','l','o','s','e','|','c','o','n','f','i','r','m','|','c','o','s','|','e','s','c','a','p','e','|','e','v','a','l','|','e','x','p','|','f','i','x','e','d','|','f','l','o','o','r','|','f','o','c','u','s','|','f','o','n','t','c','o','l','o','r','|','f','o','n','t','s','i','z','e','|','f','o','r','w','a','r','d','|','g','e','t','D','a','t','e','|','g','e','t','D','a','y','|','g','e','t','H','o','u','r','s','|','g','e','t','M','i','n','u','t','e','s','|','g','e','t','M','o','n','t','h','|','g','e','t','S','e','c','o','n','d','s','|','g','e','t','T','i','m','e','|','g','e','t','T','i','m','e','z','o','n','e','O','f','f','s','e','t','|','g','e','t','Y','e','a','r','|','g','o','|','i','n','d','e','x','O','f','|','i','s','N','a','N','|','i','t','a','l','i','c','s','|','j','a','v','a','E','n','a','b','l','e','d','|','j','o','i','n','|','l','a','s','t','I','n','d','e','x','O','f','|','l','i','n','k','|','l','o','g','|','m','a','x','|','m','i','n','|','o','p','e','n','|','p','a','r','s','e','|','p','a','r','s','e','F','l','o','a','t','|','p','a','r','s','e','I','n','t','|','p','o','w','|','p','r','o','m','p','t','|','r','a','n','d','o','m','|','r','e','l','o','a','d','|','r','e','p','l','a','c','e','|','r','e','s','e','t','|','r','e','v','e','r','s','e','|','r','o','u','n','d','|','s','c','r','o','l','l','|','s','e','l','e','c','t','|','s','e','t','D','a','t','e','|','s','e','t','H','o','u','r','s','|','s','e','t','M','i','n','u','t','e','s','|','s','e','t','M','o','n','t','h','|','s','e','t','S','e','c','o','n','d','s','|','s','e','t','T','i','m','e','o','u','t','|','s','e','t','T','i','m','e','|','s','e','t','Y','e','a','r','|','s','i','n','|','s','m','a','l','l','|','s','o','r','t','|','s','p','l','i','t','|','s','q','r','t','|','s','t','r','i','k','e','|','s','u','b','|','s','u','b','m','i','t','|','s','u','b','s','t','r','i','n','g','|','s','u','p','|','t','a','i','n','t','|','t','a','n','|','t','o','G','M','T','S','t','r','i','n','g','|','t','o','L','o','c','a','l','e','S','t','r','i','n','g','|','t','o','L','o','w','e','r','C','a','s','e','|','t','o','S','t','r','i','n','g','|','t','o','U','p','p','e','r','C','a','s','e','|','u','n','e','s','c','a','p','e','|','u','n','t','a','i','n','t','|','U','T','C','|','w','r','i','t','e','|','w','r','i','t','e','l','n',')','>','\"',':',':',':','K','e','y','w','o','r','d',':',':','\n',
'	','P','r','o','p','e','r','t','i','e','s',':','\"','<','(','a','c','t','i','o','n','|','a','l','i','n','k','C','o','l','o','r','|','a','n','c','h','o','r','s','|','a','p','p','C','o','d','e','N','a','m','e','|','a','p','p','N','a','m','e','|','a','p','p','V','e','r','s','i','o','n','|','b','g','C','o','l','o','r','|','b','o','r','d','e','r','|','c','h','e','c','k','e','d','|','c','o','m','p','l','e','t','e','|','c','o','o','k','i','e','|','d','e','f','a','u','l','t','C','h','e','c','k','e','d','|','d','e','f','a','u','l','t','S','e','l','e','c','t','e','d','|','d','e','f','a','u','l','t','S','t','a','t','u','s','|','d','e','f','a','u','l','t','V','a','l','u','e','|','d','e','s','c','r','i','p','t','i','o','n','|','E','|','e','l','e','m','e','n','t','s','|','e','n','a','b','l','e','d','P','l','u','g','i','n','|','e','n','c','o','d','i','n','g','|','f','g','C','o','l','o','r','|','f','i','l','e','n','a','m','e','|','f','o','r','m','s','|','f','r','a','m','e','s','|','h','a','s','h','|','h','e','i','g','h','t','|','h','o','s','t','|','h','o','s','t','n','a','m','e','|','h','r','e','f','|','h','s','p','a','c','e','|','i','n','d','e','x','|','l','a','s','t','M','o','d','i','f','i','e','d','|','l','e','n','g','t','h','|','l','i','n','k','C','o','l','o','r','|','l','i','n','k','s','|','L','N','2','|','L','N','1','0','|','L','O','G','2','E','|','L','O','G','1','0','E','|','l','o','w','s','r','c','|','m','e','t','h','o','d','|','n','a','m','e','|','o','p','e','n','e','r','|','o','p','t','i','o','n','s','|','p','a','r','e','n','t','|','p','a','t','h','n','a','m','e','|','P','I','|','p','o','r','t','|','p','r','o','t','o','c','o','l','|','p','r','o','t','o','t','y','p','e','|','r','e','f','e','r','r','e','r','|','s','e','a','r','c','h','|','s','e','l','e','c','t','e','d','|','s','e','l','e','c','t','e','d','I','n','d','e','x','|','s','e','l','f','|','S','Q','R','T','1','_','2','|','S','Q','R','T','2','|','s','r','c','|','s','t','a','t','u','s','|','t','a','r','g','e','t','|','t','e','x','t','|','t','i','t','l','e','|','t','o','p','|','t','y','p','e','|','U','R','L','|','u','s','e','r','A','g','e','n','t','|','v','a','l','u','e','|','v','l','i','n','k','C','o','l','o','r','|','v','s','p','a','c','e','|','w','i','d','t','h','|','w','i','n','d','o','w',')','>','\"',':',':',':','S','t','o','r','a','g','e',' ','T','y','p','e',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','O','p','e','r','a','t','o','r','s',':','\"','[','=',' ',';',' ','-','>',']','|','[','/',']','|','&','|','\\','|','\"',':',':',':','P','r','e','p','r','o','c','e','s','s','o','r',':',':','}','\0'};
#endif /*VMS*/
static char AuxString5[] = {'P','e','r','l',':','1',':','0',' ','{','\n',
'	','c','o','m','m','e','n','t','s',':','\"','#','\"',':','\"','$','\"',':',':','C','o','m','m','e','n','t',':',':','\n',
'	','d','o','u','b','l','e',' ','q','u','o','t','e',' ','s','t','r','i','n','g','s',':','\"','\"','\"','\"',':','\"','\"','\"','\"',':',':','S','t','r','i','n','g',':',':','\n',
'	','d','q',' ','s','t','r','i','n','g',' ','e','s','c',' ','c','h','a','r','s',':','\"','\\','\\','(','.','|','\\','n',')','\"',':',':',':','S','t','r','i','n','g','1',':','d','o','u','b','l','e',' ','q','u','o','t','e',' ','s','t','r','i','n','g','s',':','\n',
'	','s','i','n','g','l','e',' ','q','u','o','t','e',' ','s','t','r','i','n','g','s',':','\"',''','\"',':','\"',''','\"',':',':','S','t','r','i','n','g',':',':','\n',
'	','s','q',' ','s','t','r','i','n','g',' ','e','s','c',' ','c','h','a','r','s',':','\"','\\','\\','(','.','|','\\','n',')','\"',':',':',':','S','t','r','i','n','g','1',':','s','i','n','g','l','e',' ','q','u','o','t','e',' ','s','t','r','i','n','g','s',':','\n',
'	','s','u','b','r','o','u','t','i','n','e',' ','h','e','a','d','e','r',':','\"','s','u','b','[','\\','t',' ',']','+','(','[','a','-','z','A','-','Z','0','-','9','_',']','+',')','[','\\','t',' ',']','+','{','\"',':',':',':','K','e','y','w','o','r','d',':',':','\n',
'	','s','u','b','r',' ','h','e','a','d','e','r',' ','c','o','l','o','r','i','n','g',':','\"','\\','1','\"',':',':',':','F','l','a','g',':','s','u','b','r','o','u','t','i','n','e',' ','h','e','a','d','e','r',':','C','\n',
'	','i','g','n','o','r','e',' ','e','s','c','a','p','e','d',' ','c','h','a','r','s',':','\"','\\','\\','[','#','\"','\"',''','\\','$','m','s','y','t','q',']','\"',':',':',':','P','l','a','i','n',':',':','\n',
'	','r','e',' ','m','a','t','c','h','i','n','g',':','\"','<','(','(','m','|','q','|','q','q',')','?','/',')','(','\\','\\','/','|','[','^','/',']',')','*','(','/','[','g','i','m','s','o','x',']','?',')','>','\"',':',':',':','S','t','r','i','n','g',':',':','\n',
'	','r','e',' ','m','a','t','c','h',' ','c','o','l','o','r','i','n','g',':','\"','\\','1','\\','4','\"',':',':',':','S','t','r','i','n','g','2',':','r','e',' ','m','a','t','c','h','i','n','g',':','C','\n',
'	','r','e',' ','s','u','b','s','t','i','t','u','t','i','o','n',':','\"','<','(','(','s','|','y','|','t','r',')','/',')','(','\\','\\','/','|','[','^','/',']',')','*','(','/',')','[','^','/',']','*','(','/','[','g','i','m','s','o','x',']','?',')','\"',':',':',':','S','t','r','i','n','g',':',':','\n',
'	','r','e',' ','s','u','b','s',' ','c','o','l','o','r','i','n','g',':','\"','\\','1','\\','4','\\','5','\"',':',':',':','S','t','r','i','n','g','2',':','r','e',' ','s','u','b','s','t','i','t','u','t','i','o','n',':','C','\n',
'	','k','e','y','w','o','r','d','s',':','\"','<','(','m','y','|','l','o','c','a','l','|','n','e','w','|','i','f','|','u','n','t','i','l','|','w','h','i','l','e','|','e','l','s','i','f','|','e','l','s','e','|','e','v','a','l','|','u','n','l','e','s','s','|','f','o','r','|','f','o','r','e','a','c','h','|','c','o','n','t','i','n','u','e','|','e','x','i','t','|','d','i','e','|','l','a','s','t','|','g','o','t','o','|','n','e','x','t','|','r','e','d','o','|','r','e','t','u','r','n','|','l','o','c','a','l','|','e','x','e','c','|','d','o','|','u','s','e','|','r','e','q','u','i','r','e','|','p','a','c','k','a','g','e','|','e','v','a','l','|','B','E','G','I','N','|','E','N','D','|','e','q','|','n','e','|','n','o','t','|','\\','|','\\','|','|','\\','&','\\','&','|','a','n','d','|','o','r',')','>','\"',':',':',':','K','e','y','w','o','r','d',':',':','D','\n',
'	','l','i','b','r','a','r','y',' ','f','n','s',':','\"','<','(','a','b','s','|','a','c','c','e','p','t','|','a','l','a','r','m','|','a','t','a','n','2','|','b','i','n','d','|','b','i','n','m','o','d','e','|','b','l','e','s','s','|','c','a','l','l','e','r','|','c','h','d','i','r','|','c','h','m','o','d','|','c','h','o','m','p','|','c','h','o','p','|','c','h','r','|','c','h','r','o','o','t','|','c','h','o','w','n','|','c','l','o','s','e','d','i','r','|','c','l','o','s','e','|','c','o','n','n','e','c','t','|','c','o','s','|','c','r','y','p','t','|','d','b','m','c','l','o','s','e','|','d','b','m','o','p','e','n','|','d','e','f','i','n','e','d','|','d','e','l','e','t','e','|','d','i','e','|','d','u','m','p','|','e','a','c','h','|','e','n','d','g','r','e','n','t','|','e','n','d','h','o','s','t','e','n','t','|','e','n','d','n','e','t','e','n','t','|','e','n','d','p','r','o','t','o','e','n','t','|','e','n','d','p','w','e','n','t','|','e','n','d','s','e','r','v','e','n','t','|','e','o','f','|','e','x','e','c','|','e','x','i','s','t','s','|','e','x','p','|','f','c','t','n','l','|','f','i','l','e','n','o','|','f','l','o','c','k','|','f','o','r','k','|','f','o','r','m','a','t','|','f','o','r','m','l','i','n','e','|','g','e','t','c','|','g','e','t','g','r','e','n','t','|','g','e','t','g','r','g','i','d','|','g','e','t','g','r','n','a','m','|','g','e','t','h','o','s','t','b','y','a','d','d','r','|','g','e','t','h','o','s','t','b','y','n','a','m','e','|','g','e','t','h','o','s','t','e','n','t','|','g','e','t','l','o','g','i','n','|','g','e','t','n','e','t','b','y','a','d','d','r','|','g','e','t','n','e','t','b','y','n','a','m','e','|','g','e','t','n','e','t','e','n','t','|','g','e','t','p','e','e','r','n','a','m','e','|','g','e','t','p','g','r','p','|','g','e','t','p','p','i','d','|','g','e','t','p','r','i','o','r','i','t','y','|','g','e','t','p','r','o','t','o','b','y','n','a','m','e','|','g','e','t','p','r','o','t','o','b','y','n','u','m','b','e','r','|','g','e','t','p','r','o','t','o','e','n','t','|','g','e','t','p','w','e','n','t','|','g','e','t','p','w','n','a','m','|','g','e','t','p','w','u','i','d','|','g','e','t','s','e','r','v','b','y','n','a','m','e','|','g','e','t','s','e','r','v','b','y','p','o','r','t','|','g','e','t','s','e','r','v','e','n','t','|','g','e','t','s','o','c','k','n','a','m','e','|','g','e','t','s','o','c','k','o','p','t','|','g','l','o','b','|','g','m','t','i','m','e','|','g','r','e','p','|','h','e','x','|','i','m','p','o','r','t','|','i','n','d','e','x','|','i','n','t','|','i','o','c','t','l','|','j','o','i','n','|','k','e','y','s','|','k','i','l','l','|','l','c','f','i','r','s','t','|','l','c','|','l','e','n','g','t','h','|','l','i','n','k','|','l','i','s','t','e','n','|','l','o','g','|','l','o','c','a','l','t','i','m','e','|','l','s','t','a','t','|','m','a','p','|','m','k','d','i','r','|','m','s','g','c','t','l','|','m','s','g','g','e','t','|','m','s','g','r','c','v','|','n','o','|','o','c','t','|','o','p','e','n','d','i','r','|','o','p','e','n','|','o','r','d','|','p','a','c','k','|','p','i','p','e','|','p','o','p','|','p','o','s','|','p','r','i','n','t','f','|','p','r','i','n','t','|','p','u','s','h','|','q','u','o','t','e','m','e','t','a','|','r','a','n','d','|','r','e','a','d','d','i','r','|','r','e','a','d','|','r','e','a','d','l','i','n','k','|','r','e','c','v','|','r','e','f','|','r','e','n','a','m','e','|','r','e','s','e','t','|','r','e','v','e','r','s','e','|','r','e','w','i','n','d','d','i','r','|','r','i','n','d','e','x','|','r','m','d','i','r','|','s','c','a','l','a','r','|','s','e','e','k','d','i','r','|','s','e','e','k','|','s','e','l','e','c','t','|','s','e','m','c','t','l','|','s','e','m','g','e','t','|','s','e','m','o','p','|','s','e','n','d','|','s','e','t','g','r','e','n','t','|','s','e','t','h','o','s','t','e','n','t','|','s','e','t','n','e','t','e','n','t','|','s','e','t','p','g','r','p','|','s','e','t','p','r','i','o','r','i','t','y','|','s','e','t','p','r','o','t','o','e','n','t','|','s','e','t','p','w','e','n','t','|','s','e','t','s','o','c','k','o','p','t','|','s','h','i','f','t','|','s','h','m','c','t','l','|','s','h','m','g','e','t','|','s','h','m','r','e','a','d','|','s','h','m','w','r','i','t','e','|','s','h','u','t','d','o','w','n','|','s','i','n','|','s','l','e','e','p','|','s','o','c','k','e','t','|','s','o','c','k','e','t','p','a','i','r','|','s','o','r','t','|','s','p','l','i','c','e','|','s','p','l','i','t','|','s','p','r','i','n','t','f','|','s','q','r','t','|','s','r','a','n','d','|','s','t','a','t','|','s','t','u','d','y','|','s','u','b','s','t','r','|','s','y','m','l','i','n','k','|','s','y','s','c','a','l','l','|','s','y','s','o','p','e','n','|','s','y','s','r','e','a','d','|','s','y','s','t','e','m','|','s','y','s','w','r','i','t','e','|','t','e','l','l','d','i','r','|','t','e','l','l','|','t','i','e','|','t','i','e','d','|','t','i','m','e','|','t','i','m','e','s','|','t','r','u','n','c','a','t','e','|','u','c','|','u','c','f','i','r','s','t','|','u','m','a','s','k','|','u','n','d','e','f','|','u','n','l','i','n','k','|','u','n','p','a','c','k','|','u','n','s','h','i','f','t','|','u','n','t','i','e','|','u','t','i','m','e','|','v','a','l','u','e','s','|','v','e','c','|','w','a','i','t','|','w','a','i','t','p','i','d','|','w','a','n','t','a','r','r','a','y','|','w','a','r','n','|','w','r','i','t','e','|','q','w','|','-','[','r','w','x','o','R','W','X','O','e','z','s','f','d','l','p','S','b','c','t','u','g','k','T','B','M','A','C',']',')','>','\"',':',':',':','S','u','b','r','o','u','t','i','n','e',':',':','D','\n',
'	','v','a','r','i','a','b','l','e','s',':','\"','[','$','@','%',']','(','{','[','^','}',']','*','}','|','[','^','a','-','z','A','-','Z','0','-','9','_',' ','/','\\','t','\\','n','\\','.',',','\\','\\','[','\\','\\','{','\\','\\','(',']','|','[','0','-','9',']','+','|','[','a','-','z','A','-','Z','_',']','[','a','-','z','A','-','Z','0','-','9','_',']','*',')','?','\"',':',':',':','I','d','e','n','t','i','f','i','e','r','1',':',':','\n',
'	','v','a','r','i','a','b','l','e','s',' ','i','n',' ','s','t','r','i','n','g','s',':','\"','[','$','@','%','&',']','(','{','[','^','}',']','*','}','|','[','^','a','-','z','A','-','Z','0','-','9','_',' ','/','\\','t','\\','n','\\','.',',','\\','\\','[','\\','\\','{','\\','\\','(',']','|','[','0','-','9',']','+','|','[','a','-','z','A','-','Z','_',']','[','a','-','z','A','-','Z','0','-','9','_',']','*',')','?','\"',':',':',':','I','d','e','n','t','i','f','i','e','r','1',':','d','o','u','b','l','e',' ','q','u','o','t','e',' ','s','t','r','i','n','g','s',':','\n',
'	','s','u','b','r','o','u','t','i','n','e',' ','c','a','l','l',':','\"','&','[','a','-','z','A','-','Z','0','-','9','_',']','+','\"',':',':',':','S','u','b','r','o','u','t','i','n','e',':',':','\n',
'	','b','r','a','c','e','s',' ','a','n','d',' ','p','a','r','e','n','s',':','\"','[','\\','[','\\',']','{','}','\\','(','\\',')',']','\"',':',':',':','K','e','y','w','o','r','d',':',':','}','\0'};
static char AuxString6[] = {'A','d','a',':','1',':','0','{','\n',
' ',' ',' ',' ',' ',' ',' ',' ','C','o','m','m','e','n','t','s',':','\"','-','-','\"',':','\"','$','\"',':',':','C','o','m','m','e','n','t',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','S','t','r','i','n','g',' ','L','i','t','e','r','a','l','s',':','\"','\"','\"','\"',':','\"','\"','\"','\"',':','\"','\\','n','\"',':','S','t','r','i','n','g',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','C','h','a','r','a','c','t','e','r',' ','L','i','t','e','r','a','l','s',':','\"',''','\"',':','\"',''','\"',':','\"','[','^','\\','\\',']','[','^',''',']','\"',':','C','h','a','r','a','c','t','e','r',' ','C','o','n','s','t',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','A','d','a',' ','A','t','t','r','i','b','u','t','e','s',':','\"',''','[','a','-','z','A','-','Z',']','[','a','-','z','A','-','Z','_',']','+','\"',':',':',':','A','d','a',' ','A','t','t','r','i','b','u','t','e','s',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','N','u','m','e','r','i','c',' ','L','i','t','e','r','a','l','s',':','\"','<','(','(','(','2','|','8','|','1','0','|','1','6',')','#','[','_','0','-','9','a','-','f','A','-','F',']','*','#',')','|','[','0','-','9','.',']','+',')','>','\"',':',':',':','N','u','m','e','r','i','c',' ','C','o','n','s','t',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','W','i','t','h','s',' ','P','r','a','g','m','a','s',' ','U','s','e',':','\"','(','(','[','w','W',']','i','t','h','|','W','I','T','H','|','[','p','P',']','r','a','g','m','a','|','P','R','A','G','M','A','|','[','u','U',']','s','e','|','U','S','E',')','[',' ','\\','t','\\','n','\\','f','\\','r',']','+','[','a','-','z','A','-','Z','0','-','9','_','.',']','+',';',')','+','\"',':',':',':','P','r','e','p','r','o','c','e','s','s','o','r',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','P','r','e','d','e','f','i','n','e','d',' ','T','y','p','e','s',':','\"','<','(','[','b','B',']','o','o','l','e','a','n','|','B','O','O','L','E','A','N','|','[','c','C',']','h','a','r','a','c','t','e','r','|','C','H','A','R','A','C','T','E','R','|','[','c','C',']','o','u','n','t','|','C','O','U','N','T','|','[','d','D',']','u','r','a','t','i','o','n','|','D','U','R','A','T','I','O','N','|','[','f','F',']','l','o','a','t','|','F','L','O','A','T','|','[','i','I',']','n','t','e','g','e','r','|','I','N','T','E','G','E','R','|','[','l','L',']','o','n','g','_','[','f','F',']','l','o','a','t','|','L','O','N','G','_','F','L','O','A','T','|','[','l','L',']','o','n','g','_','[','i','I',']','n','t','e','g','e','r','|','L','O','N','G','_','I','N','T','E','G','E','R','|','[','p','P',']','r','i','o','r','i','t','y','|','P','R','I','O','R','I','T','Y','|','[','s','S',']','h','o','r','t','_','[','f','F',']','l','o','a','t','|','S','H','O','R','T','_','F','L','O','A','T','|','[','s','S',']','h','o','r','t','_','[','i','I',']','n','t','e','g','e','r','|','S','H','O','R','T','_','I','N','T','E','G','E','R','|','[','s','S',']','t','r','i','n','g','|','S','T','R','I','N','G',')','>','\"',':',':',':','S','t','o','r','a','g','e',' ','T','y','p','e',':',':','D','\n',
' ',' ',' ',' ',' ',' ',' ',' ','P','r','e','d','e','f','i','n','e','d',' ','S','u','b','t','y','p','e','s',':','\"','<','(','[','f','F',']','i','e','l','d','|','F','I','E','L','D','|','[','n','N',']','a','t','u','r','a','l','|','N','A','T','U','R','A','L','|','[','n','N',']','u','m','b','e','r','_','[','b','B',']','a','s','e','|','N','U','M','B','E','R','_','B','A','S','E','|','[','p','P',']','o','s','i','t','i','v','e','|','P','O','S','I','T','I','V','E','|','[','p','P',']','r','i','o','r','i','t','y','|','P','R','I','O','R','I','T','Y',')','>','\"',':',':',':','S','t','o','r','a','g','e',' ','T','y','p','e',':',':','D','\n',
' ',' ',' ',' ',' ',' ',' ',' ','R','e','s','e','r','v','e','d',' ','W','o','r','d','s',':','\"','<','(','[','a','A',']','b','o','r','t','|','A','B','O','R','T','|','[','a','A',']','b','s','|','A','B','S','|','[','a','A',']','c','c','e','p','t','|','A','C','C','E','P','T','|','[','a','A',']','c','c','e','s','s','|','A','C','C','E','S','S','|','[','a','A',']','n','d','|','A','N','D','|','[','a','A',']','r','r','a','y','|','A','R','R','A','Y','|','[','a','A',']','[','t','T',']','|','[','b','B',']','e','g','i','n','|','B','E','G','I','N','|','[','b','B',']','o','d','y','|','B','O','D','Y','|','[','c','C',']','a','s','e','|','C','A','S','E','|','[','c','C',']','o','n','s','t','a','n','t','|','C','O','N','S','T','A','N','T','|','[','d','D',']','e','c','l','a','r','e','|','D','E','C','L','A','R','E','|','[','d','D',']','e','l','a','y','|','D','E','L','A','Y','|','[','d','D',']','e','l','t','a','|','D','E','L','T','A','|','[','d','D',']','i','g','i','t','s','|','D','I','G','I','T','S','|','[','d','D',']','[','o','O',']','|','[','e','E',']','l','s','e','|','E','L','S','E','|','[','e','E',']','l','s','i','f','|','E','L','S','I','F','|','[','e','E',']','n','d','|','E','N','D','|','[','e','E',']','n','t','r','y','|','E','N','T','R','Y','|','[','e','E',']','x','c','e','p','t','i','o','n','|','E','X','C','E','P','T','I','O','N','|','[','e','E',']','x','i','t','|','E','X','I','T','|','[','f','F',']','o','r','|','F','O','R','|','[','f','F',']','u','n','c','t','i','o','n','|','F','U','N','C','T','I','O','N','|','[','g','G',']','e','n','e','r','i','c','|','G','E','N','E','R','I','C','|','[','g','G',']','o','t','o','|','G','O','T','O','|','[','i','I',']','[','f','F',']','|','[','i','I',']','[','n','N',']','|','[','i','I',']','[','s','S',']','|','[','l','L',']','i','m','i','t','e','d','|','L','I','M','I','T','E','D','|','[','l','L',']','o','o','p','|','L','O','O','P','|','[','m','M',']','o','d','|','M','O','D','|','[','n','N',']','e','w','|','N','E','W','|','[','n','N',']','o','t','|','N','O','T','|','[','n','N',']','u','l','l','|','N','U','L','L','|','[','o','O',']','[','f','F',']','|','[','o','O',']','[','r','R',']','|','[','o','O',']','t','h','e','r','s','|','O','T','H','E','R','S','|','[','o','O',']','u','t','|','O','U','T','|','[','p','P',']','a','c','k','a','g','e','|','P','A','C','K','A','G','E','|','[','p','P',']','r','a','g','m','a','|','P','R','A','G','M','A','|','[','p','P',']','r','i','v','a','t','e','|','P','R','I','V','A','T','E','|','[','p','P',']','r','o','c','e','d','u','r','e','|','P','R','O','C','E','D','U','R','E','|','[','r','R',']','a','i','s','e','|','R','A','I','S','E','|','[','r','R',']','a','n','g','e','|','R','A','N','G','E','|','[','r','R',']','e','c','o','r','d','|','R','E','C','O','R','D','|','[','r','R',']','e','m','|','R','E','M','|','[','r','R',']','e','n','a','m','e','s','|','R','E','N','A','M','E','S','|','[','r','R',']','e','t','u','r','n','|','R','E','T','U','R','N','|','[','r','R',']','e','v','e','r','s','e','|','R','E','V','E','R','S','E','|','[','s','S',']','e','l','e','c','t','|','S','E','L','E','C','T','|','[','s','S',']','e','p','a','r','a','t','e','|','S','E','P','A','R','A','T','E','|','[','s','S',']','u','b','t','y','p','e','|','S','U','B','T','Y','P','E','|','[','t','T',']','a','s','k','|','T','A','S','K','|','[','t','T',']','e','r','m','i','n','a','t','e','|','T','E','R','M','I','N','A','T','E','|','[','t','T',']','h','e','n','|','T','H','E','N','|','[','t','T',']','y','p','e','|','T','Y','P','E','|','[','u','U',']','s','e','|','U','S','E','|','[','w','W',']','h','e','n','|','W','H','E','N','|','[','w','W',']','h','i','l','e','|','W','H','I','L','E','|','[','w','W',']','i','t','h','|','W','I','T','H','|','[','x','X',']','o','r','|','X','O','R',')','>','\"',':',':',':','K','e','y','w','o','r','d',':',':','D','\n',
' ',' ',' ',' ',' ',' ',' ',' ','A','d','a',' ','9','5',' ','O','n','l','y',':','\"','<','(','[','a','A',']','b','s','t','r','a','c','t','|','A','B','S','T','R','A','C','T','|','[','t','T',']','a','g','g','e','d','|','T','A','G','G','E','D','|','[','a','A',']','l','l','|','A','L','L','|','[','p','P',']','r','o','t','e','c','t','e','d','|','P','R','O','T','E','C','T','E','D','|','[','a','A',']','l','i','a','s','e','d','|','A','L','I','A','S','E','D','|','[','r','R',']','e','q','u','e','u','e','|','R','E','Q','U','E','U','E','|','[','u','U',']','n','t','i','l','|','U','N','T','I','L',')','>','\"',':',':',':','K','e','y','w','o','r','d',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','I','d','e','n','t','i','f','i','e','r','s',':','\"','<','(','[','a','-','z','A','-','Z',']','[','a','-','z','A','-','Z','0','-','9','_',']','*',')','>','\"',':',':',':','I','d','e','n','t','i','f','i','e','r',':',':','D','\n',
' ',' ',' ',' ',' ',' ',' ',' ','D','o','t',' ','A','l','l',':','\"','\\','\\','.','[','a','A',']','[','l','L',']','[','l','L',']','>','\"',':',':',':','S','t','o','r','a','g','e',' ','T','y','p','e',':',':','D','}','\0'};
static char AuxString7[] = {'F','o','r','t','r','a','n',':','2',':','0',' ','{','\n',
' ',' ',' ',' ',' ',' ',' ',' ','C','o','m','m','e','n','t',':','\"','^','[','C','c','*','!',']','\"',':','\"','$','\"',':',':','C','o','m','m','e','n','t',':',':','\n',
'	','B','a','n','g',' ','C','o','m','m','e','n','t',':','\"','!','\"',':','\"','$','\"',':',':','C','o','m','m','e','n','t',':',':','\n',
'	','D','e','b','u','g',' ','L','i','n','e',':','\"','^','D','\"',':','\"','$','\"',':',':','P','r','e','p','r','o','c','e','s','s','o','r',':',':','\n',
'	','S','t','r','i','n','g',':','\"',''','\"',':','\"',''','\"',':','\"','\\','n','(','[','^',' ','\\','t',']','|',' ','[','^',' ','\\','t',']','|',' ',' ','[','^',' ','\\','t',']','|',' ',' ',' ','[','^',' ','\\','t',']','|',' ',' ',' ',' ','[','^',' ','\\','t',']','|',' ',' ',' ',' ',' ','[',' ','\\','t','0',']','|',' ','*','\\','t','[','^','1','-','9',']',')','\"',':','S','t','r','i','n','g',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','K','e','y','w','o','r','d','s',':','\"','<','(','A','C','C','E','P','T','|','[','A','a',']','c','c','e','p','t','|','A','U','T','O','M','A','T','I','C','|','[','A','a',']','u','t','o','m','a','t','i','c','|','B','A','C','K','S','P','A','C','E','|','[','B','b',']','a','c','k','s','p','a','c','e','|','B','L','O','C','K','|','[','B','b',']','l','o','c','k','|','C','A','L','L','|','[','C','c',']','a','l','l','|','C','L','O','S','E','|','[','C','c',']','l','o','s','e','|','C','O','M','M','O','N','|','[','C','c',']','o','m','m','o','n','|','C','O','N','T','I','N','U','E','|','[','C','c',']','o','n','t','i','n','u','e','|','D','A','T','A','|','[','D','d',']','a','t','a','|','D','E','C','O','D','E','|','[','D','d',']','e','c','o','d','e','|','D','E','L','E','T','E','|','[','D','d',']','e','l','e','t','e','|','D','I','M','E','N','S','I','O','N','|','[','D','d',']','i','m','e','n','s','i','o','n','|','D','O','|','[','D','d',']','o','|','E','L','S','E','|','[','E','e',']','l','s','e','|','E','L','S','E','I','F','|','[','E','e',']','l','s','e','i','f','|','E','N','C','O','D','E','|','[','E','e',']','n','c','o','d','e','|','E','N','D','D','O','|','[','E','e',']','n','d','[','D','d',']','o','|','E','N','D',' ','?','F','I','L','E','|','[','E','e',']','n','d',' ','*','[','f','F',']','i','l','e','|','E','N','D','I','F','|','[','E','e',']','n','d','[','i','I',']','f','|','E','N','D','|','[','E','e',']','n','d','|','E','N','T','R','Y','|','[','E','e',']','n','t','r','y','|','E','Q','U','I','V','A','L','E','N','C','E','|','[','E','e',']','q','u','i','v','a','l','e','n','c','e','|','E','X','I','T','|','[','E','e',']','x','i','t','|','E','X','T','E','R','N','A','L','|','[','E','e',']','x','t','e','r','n','a','l','|','F','O','R','M','A','T','|','[','F','f',']','o','r','m','a','t','|','F','U','N','C','T','I','O','N','|','[','F','f',']','u','n','c','t','i','o','n','|','G','O',' ','*','T','O','|','[','G','g',']','o',' ','*','[','t','T',']','o','|','I','F','|','[','I','i',']','f','|','I','M','P','L','I','C','I','T','|','[','I','i',']','m','p','l','i','c','i','t','|','I','N','C','L','U','D','E','|','[','I','i',']','n','c','l','u','d','e','|','I','N','Q','U','I','R','E','|','[','I','i',']','n','q','u','i','r','e','|','I','N','T','R','I','N','S','I','C','|','[','I','i',']','n','t','r','i','n','s','i','c','|','L','O','G','I','C','A','L','|','[','L','l',']','o','g','i','c','a','l','|','M','A','P','|','[','M','m',']','a','p','|','N','O','N','E','|','[','N','n',']','o','n','e','|','O','N','|','[','O','o',']','n','|','O','P','E','N','|','[','O','o',']','p','e','n','|','P','A','R','A','M','E','T','E','R','|','[','P','p',']','a','r','a','m','e','t','e','r','|','P','A','U','S','E','|','[','P','p',']','a','u','s','e','|','P','O','I','N','T','E','R','|','[','P','p',']','o','i','n','t','e','r','|','P','R','I','N','T','|','[','P','p',']','r','i','n','t','|','P','R','O','G','R','A','M','|','[','P','p',']','r','o','g','r','a','m','|','R','E','A','D','|','[','R','r',']','e','a','d','|','R','E','C','O','R','D','|','[','R','r',']','e','c','o','r','d','|','R','E','T','U','R','N','|','[','R','r',']','e','t','u','r','n','|','R','E','W','I','N','D','|','[','R','r',']','e','w','i','n','d','|','S','A','V','E','|','[','S','s',']','a','v','e','|','S','T','A','T','I','C','|','[','S','s',']','t','a','t','i','c','|','S','T','O','P','|','[','S','s',']','t','o','p','|','S','T','R','U','C','T','U','R','E','|','[','S','s',']','t','r','u','c','t','u','r','e','|','S','U','B','R','O','U','T','I','N','E','|','[','S','s',']','u','b','r','o','u','t','i','n','e','|','S','Y','S','T','E','M','|','[','S','s',']','y','s','t','e','m','|','T','H','E','N','|','[','T','t',']','h','e','n','|','T','Y','P','E','|','[','T','t',']','y','p','e','|','U','N','I','O','N','|','[','U','u',']','n','i','o','n','|','U','N','L','O','C','K','|','[','U','u',']','n','l','o','c','k','|','V','I','R','T','U','A','L','|','[','V','v',']','i','r','t','u','a','l','|','V','O','L','A','T','I','L','E','|','[','V','v',']','o','l','a','t','i','l','e','|','W','H','I','L','E','|','[','W','w',']','h','i','l','e','|','W','R','I','T','E','|','[','W','w',']','r','i','t','e',')','>','\"',':',':',':','K','e','y','w','o','r','d',':',':','D','\n',
' ',' ',' ',' ',' ',' ','	','D','a','t','a',' ','T','y','p','e','s',':','\"','<','(','B','Y','T','E','|','[','B','b',']','y','t','e','|','C','H','A','R','A','C','T','E','R','|','[','C','c',']','h','a','r','a','c','t','e','r','|','C','O','M','P','L','E','X','|','[','C','c',']','o','m','p','l','e','x','|','D','O','U','B','L','E',' ','*','C','O','M','P','L','E','X','|','[','D','d',']','o','u','b','l','e',' ','*','[','C','c',']','o','m','p','l','e','x','|','D','O','U','B','L','E',' ','*','P','R','E','C','I','S','I','O','N','|','[','D','d',']','o','u','b','l','e',' ','*','[','P','p',']','r','e','c','i','s','i','o','n','|','D','O','U','B','L','E','|','[','D','d',']','o','u','b','l','e','|','I','N','T','E','G','E','R','|','[','I','i',']','n','t','e','g','e','r','|','R','E','A','L','|','[','R','r',']','e','a','l',')','(','\\','*','[','0','-','9',']','+',')','?','>','\"',':',':',':','K','e','y','w','o','r','d',':',':','D','\n',
' ',' ',' ',' ',' ',' ','	','F','9','0',' ','K','e','y','w','o','r','d','s',':','\"','<','(','A','L','L','O','C','A','T','A','B','L','E','|','[','A','a',']','l','l','o','c','a','t','a','b','l','e','|','A','L','L','O','C','A','T','E','|','[','A','a',']','l','l','o','c','a','t','e','|','C','A','S','E','|','[','C','c',']','a','s','e','|','C','A','S','E','|','[','C','c',']','a','s','e','|','C','Y','C','L','E','|','[','C','c',']','y','c','l','e','|','D','E','A','L','L','O','C','A','T','E','|','[','D','d',']','e','a','l','l','o','c','a','t','e','|','E','L','S','E','W','H','E','R','E','|','[','E','e',']','l','s','e','w','h','e','r','e','|','N','A','M','E','L','I','S','T','|','[','N','n',']','a','m','e','l','i','s','t','|','R','E','W','R','I','T','E','|','[','R','r',']','e','w','r','i','t','e','|','S','E','L','E','C','T','|','[','S','s',']','e','l','e','c','t','|','W','H','E','R','E','|','[','W','w',']','h','e','r','e','|','I','N','T','E','N','T','|','[','I','i',']','n','t','e','n','t','|','O','P','T','I','O','N','A','L','|','[','O','o',']','p','t','i','o','n','a','l',')','>','\"',':',':',':','K','e','y','w','o','r','d',':',':','D','\n',
' ',' ',' ',' ',' ',' ','	','C','o','n','t','i','n','u','a','t','i','o','n',':','\"','^','(',' ',' ',' ',' ',' ','[','^',' ','\\','t','0',']','|','(',' ','|',' ',' ','|',' ',' ',' ','|',' ',' ',' ',' ',')','?','\\','t','[','1','-','9',']',')','\"',':',':',':','F','l','a','g',':',':','\n',
' ',' ',' ',' ',' ',' ','	','C','o','n','t','i','n','u','a','t','i','o','n',' ','i','n',' ','S','t','r','i','n','g',':','\"','\\','n','(',' ',' ',' ',' ',' ','[','^',' ','\\','t','0',']','|','(',' ','|',' ',' ','|',' ',' ',' ','|',' ',' ',' ',' ',')','?','\\','t','[','1','-','9',']',')','\"',':',':',':','F','l','a','g',':','S','t','r','i','n','g',':','}','\0'};
static char AuxString8[] = {'T','c','l',':','1',':','0',' ','{','\n',
'	','C','o','m','m','e','n','t',':','\"','#','\"',':','\"','$','\"',':',':','C','o','m','m','e','n','t',':',':','\n',
'	','D','o','u','b','l','e',' ','Q','u','o','t','e',' ','S','t','r','i','n','g',':','\"','\"','\"','\"',':','\"','\"','\"','\"',':','\"','\\','n','\"',':','S','t','r','i','n','g',':',':','\n',
'	','S','i','n','g','l','e',' ','Q','u','o','t','e',' ','S','t','r','i','n','g',':','\"',''','\"',':','\"',''','\"',':','\"','[','^','\\','\\',']','[','^',''',']','\"',':','S','t','r','i','n','g',':',':','\n',
'	','I','g','n','o','r','e',' ','E','s','c','a','p','e','d',' ','C','h','a','r','s',':','\"','\\','\\','(','.','|','\\','n',')','\"',':',':',':','P','l','a','i','n',':',':','\n',
'	','K','e','y','w','o','r','d','s',':','\"','<','(','i','f','|','e','l','s','e','|','e','l','s','e','i','f','|','s','e','t','|','u','n','s','e','t','|','i','n','c','r','|','a','p','p','e','n','d','|','g','l','o','b','a','l','|','g','l','o','b','|','u','p','v','a','r','|','u','p','l','e','v','e','l','|','p','r','o','c','|','c','a','t','c','h','|','e','r','r','o','r','|','w','h','i','l','e','|','e','o','f','|','f','o','r','e','a','c','h','|','f','o','r','|','r','e','t','u','r','n','|','b','r','e','a','k','|','c','o','n','t','i','n','u','e','|','e','v','a','l','|','s','o','u','r','c','e','|','s','w','i','t','c','h','|','l','i','s','t','|','l','i','n','d','e','x','|','r','e','g','e','x','p','|','r','e','g','s','u','b','|','p','w','d','|','g','e','t','s','|','p','u','t','s','|','e','o','f','|','p','i','d','|','e','x','i','t','|','o','p','e','n','|','c','l','o','s','e','|','e','x','p','r','|','e','x','e','c','|','c','o','n','c','a','t','|','j','o','i','n','|','l','a','p','p','e','n','d','|','l','i','n','s','e','r','t','|','l','l','e','n','g','t','h','|','l','r','a','n','g','e','|','l','r','e','p','l','a','c','e','|','l','s','e','a','r','c','h','|','l','s','o','r','t','|','s','p','l','i','t','|','f','o','r','m','a','t','|','s','c','a','n','|','t','r','a','c','e','|','c','d','|','f','l','u','s','h','|','r','e','a','d','|','s','e','e','k','|','t','e','l','l','|','s','t','r','i','n','g',' ','*','(','c','o','m','p','a','r','e','|','f','i','r','s','t','|','i','n','d','e','x','|','l','a','s','t','|','l','e','n','g','t','h','|','m','a','t','c','h','|','r','a','n','g','e','|','t','o','l','o','w','e','r','|','t','o','u','p','p','e','r','|','t','r','i','m','|','t','r','i','m','l','e','f','t','|','t','r','i','m','r','i','g','h','t',')','|','f','i','l','e','[',' ','\\','t',']','+','(','a','t','i','m','e','|','d','i','r','n','a','m','e','|','e','x','e','c','u','t','a','b','l','e','|','e','x','i','s','t','s','|','e','x','t','e','n','s','i','o','n','|','i','s','d','i','r','e','c','t','o','r','y','|','i','s','f','i','l','e','|','l','s','t','a','t','|','m','t','i','m','e','|','o','w','n','e','d','|','r','e','a','d','a','b','l','e','|','r','e','a','d','l','i','n','k','|','r','o','o','t','n','a','m','e','|','s','i','z','e','|','s','t','a','t','|','t','a','i','l','|','t','y','p','e','|','w','r','i','t','a','b','l','e',')','|','a','r','r','a','y','[',' ','\\','t',']','+','(','a','n','y','m','o','r','e','|','d','o','n','e','s','e','a','r','c','h','|','n','a','m','e','s','|','n','e','x','t','e','l','e','m','e','n','t','|','s','i','z','e','|','s','t','a','r','t','s','e','a','r','c','h',')','|','a','u','t','o','_','m','k','i','n','d','e','x','|','i','n','f','o','[',' ','\\','t',']','+','(','a','r','g','s','|','b','o','d','y','|','c','m','d','c','o','u','n','t','|','c','o','m','m','a','n','d','s','|','d','e','f','a','u','l','t','|','e','x','i','s','t','s','|','g','l','o','b','a','l','s','|','l','e','v','e','l','|','l','i','b','r','a','r','y','|','l','o','c','a','l','s','|','p','r','o','c','s','|','s','c','r','i','p','t','|','t','c','l','v','e','r','s','i','o','n','|','v','a','r','s',')','|','r','e','n','a','m','e','|','t','i','m','e','|','t','r','a','c','e','[',' ','\\','t',']','+','(','v','a','r','i','a','b','l','e','|','v','d','e','l','e','t','e','|','v','i','n','f','o',')','|','u','n','k','n','o','w','n','|','h','i','s','t','o','r','y','|','h','i','s','t','o','r','y','[',' ','\\','t',']','+','(','k','e','e','p','|','n','e','x','t','i','d','|','r','e','d','o','|','s','u','b','s','t','i','t','u','t','e',')',')','>','\"',':',':',':','K','e','y','w','o','r','d',':',':','D','\n',
'	','V','a','r','i','a','b','l','e',' ','R','e','f',':','\"','\\','$','[','0','-','9','a','-','z','A','-','Z','_',']','+','|','\\','$','{','[','^','}',']','*','}','|','\\','$','\"',':',':',':','I','d','e','n','t','i','f','i','e','r','1',':',':','\n',
'	','B','r','a','c','e','s',' ','a','n','d',' ','B','r','a','c','k','e','t','s',':','\"','[','\\','[','\\',']','{','}',']','\"',':',':',':','K','e','y','w','o','r','d',':',':','D','\n',
'	','D','Q',' ','S','t','r','i','n','g',' ','E','s','c',' ','C','h','a','r','s',':','\"','\\','\\','(','.','|','\\','n',')','\"',':',':',':','S','t','r','i','n','g','1',':','D','o','u','b','l','e',' ','Q','u','o','t','e',' ','S','t','r','i','n','g',':','\n',
'	','S','Q',' ','S','t','r','i','n','g',' ','E','s','c',' ','C','h','a','r','s',':','\"','\\','\\','(','.','|','\\','n',')','\"',':',':',':','S','t','r','i','n','g','1',':','S','i','n','g','l','e',' ','Q','u','o','t','e',' ','S','t','r','i','n','g',':','\n',
'	','V','a','r','i','a','b','l','e',' ','i','n',' ','S','t','r','i','n','g',':','\"','\\','$','[','0','-','9','a','-','z','A','-','Z','_',']','+','|','\\','$','{','[','^','}',']','*','}','|','\\','$','\"',':',':',':','I','d','e','n','t','i','f','i','e','r','1',':','D','o','u','b','l','e',' ','Q','u','o','t','e',' ','S','t','r','i','n','g',':','}','\0'};
static char AuxString9[] = {'P','a','s','c','a','l',':','1',':','0',' ','{','\n',
'	','C','o','m','m','e','n','t',' ','1',':','\"','<','(','/','\\','*','|','\\','(','\\','*',')','>','\"',':','\"','<','(','\\','*','/','|','\\','*','\\',')',')','>','\"',':',':','C','o','m','m','e','n','t',':',':','\n',
'	','C','o','m','m','e','n','t',' ','2',':','\"','{','\"',':','\"','}','\"',':',':','C','o','m','m','e','n','t',':',':','\n',
'	','S','t','r','i','n','g',':','\"',''','\"',':','\"',''','\"',':','\"','\\','n','\"',':','S','t','r','i','n','g',':',':','\n',
'	','P','r','e','p','r','o','c','e','s','s','o','r',' ','L','i','n','e',':','\"','^','[',' ','\\','t',']','*','#','\"',':','\"','$','\"',':',':','P','r','e','p','r','o','c','e','s','s','o','r',':',':','\n',
'	','S','t','r','i','n','g',' ','E','s','c',' ','C','h','a','r',':','\"','\\','\\','(','.','|','\\','n',')','\"',':',':',':','S','t','r','i','n','g','1',':','S','t','r','i','n','g',':','\n',
'	','P','r','e','p','r','o','c','e','s','s','o','r',' ','E','s','c',' ','C','h','a','r',':','\"','\\','\\','(','.','|','\\','n',')','\"',':',':',':','P','r','e','p','r','o','c','e','s','s','o','r','1',':','P','r','e','p','r','o','c','e','s','s','o','r',' ','L','i','n','e',':','\n',
'	','P','r','e','p','r','o','c','e','s','s','o','r',' ','C','o','m','m','e','n','t',' ','1',':','\"','<','(','/','\\','*','|','\\','(','\\','*',')','>','\"',':','\"','<','(','\\','*','/','|','\\','*','\\',')',')','>','\"',':',':','C','o','m','m','e','n','t',':','P','r','e','p','r','o','c','e','s','s','o','r',' ','L','i','n','e',':','\n',
'	','P','r','e','p','r','o','c','e','s','s','o','r',' ','C','o','m','m','e','n','t',' ','2',':','\"','{','\"',':','\"','}','\"',':',':','C','o','m','m','e','n','t',':','P','r','e','p','r','o','c','e','s','s','o','r',' ','L','i','n','e',':','\n',
'	','N','u','m','e','r','i','c',' ','C','o','n','s','t',':','\"','<','(','(','0','(','x','|','X',')','[','0','-','9','a','-','f','A','-','F',']','*',')','|','[','0','-','9','.',']','+','(','(','e','|','E',')','(','\\','+','|','-',')','?',')','?','[','0','-','9',']','*',')','(','L','|','l','|','U','L','|','u','l','|','u','|','U','|','F','|','f',')','?','>','\"',':',':',':','N','u','m','e','r','i','c',' ','C','o','n','s','t',':',':','D','\n',
'	','S','t','o','r','a','g','e',' ','a','n','d',' ','O','p','s',':','\"','<','(','a','n','d','|','A','N','D','|','a','r','r','a','y','|','c','o','n','s','t','|','d','i','v','|','e','x','p','o','r','t','|','f','i','l','e','|','f','u','n','c','t','i','o','n','|','i','m','p','o','r','t','|','i','n','|','I','N','|','l','a','b','e','l','|','m','o','d','|','m','o','d','u','l','e','|','n','i','l','|','n','o','t','|','N','O','T','|','o','n','l','y','|','o','r','|','O','R','|','p','a','c','k','e','d','|','p','o','w','|','p','r','a','g','m','a','|','p','r','o','c','e','d','u','r','e','|','p','r','o','g','r','a','m','|','p','r','o','t','e','c','t','e','d','|','q','u','a','l','i','f','i','e','d','|','r','e','c','o','r','d','|','r','e','s','t','r','i','c','t','e','d','|','s','e','t','|','t','y','p','e','|','v','a','r',')','>','\"',':',':',':','S','t','o','r','a','g','e',' ','T','y','p','e',':',':','D','\n',
'	','K','e','y','w','o','r','d','s',':','\"','<','(','b','e','g','i','n','|','c','a','s','e','|','d','o','|','d','o','w','n','t','o','|','e','l','s','e','|','e','n','d','|','f','o','r','|','g','o','t','o','|','i','f','|','o','f','|','o','t','h','e','r','w','i','s','e','|','t','h','e','n','|','t','o','|','u','n','t','i','l','|','w','h','i','l','e','|','w','i','t','h',')','>','\"',':',':',':','K','e','y','w','o','r','d',':',':','D','}','\0'};
static char AuxString10[] = {'Y','a','c','c',':','1',':','0','{','\n',
' ',' ',' ',' ','	','c','o','m','m','e','n','t',':','\"','/','\\','*','\"',':','\"','\\','*','/','\"',':',':','C','o','m','m','e','n','t',':',':','\n',
' ',' ',' ',' ','	','s','t','r','i','n','g',':','\"','\"','\"','\"',':','\"','\"','\"','\"',':','\"','\\','n','\"',':','S','t','r','i','n','g',':',':','\n',
' ',' ',' ',' ','	','p','r','e','p','r','o','c','e','s','s','o','r',' ','l','i','n','e',':','\"','^','[',' ','\t',']','*','#','\"',':','\"','$','\"',':',':','P','r','e','p','r','o','c','e','s','s','o','r',':',':','\n',
' ',' ',' ',' ','	','s','t','r','i','n','g',' ','e','s','c','a','p','e',' ','c','h','a','r','s',':','\"','\\','\\','(','.','|','\\','n',')','\"',':',':',':','S','t','r','i','n','g','1',':','s','t','r','i','n','g',':','\n',
' ',' ',' ',' ','	','p','r','e','p','r','o','c','e','s','s','o','r',' ','e','s','c',' ','c','h','a','r','s',':','\"','\\','\\','(','.','|','\\','n',')','\"',':',':',':','P','r','e','p','r','o','c','e','s','s','o','r','1',':','p','r','e','p','r','o','c','e','s','s','o','r',' ','l','i','n','e',':','\n',
' ',' ',' ',' ','	','p','r','e','p','r','o','c','e','s','s','o','r',' ','c','o','m','m','e','n','t',':','\"','/','\\','*','\"',':','\"','\\','*','/','\"',':',':','C','o','m','m','e','n','t',':','p','r','e','p','r','o','c','e','s','s','o','r',' ','l','i','n','e',':','\n',
' ',' ',' ',' ','	','c','h','a','r','a','c','t','e','r',' ','c','o','n','s','t','a','n','t',':','\"',''','\"',':','\"',''','\"',':','\"','[','^','\\','\\',']','[','^',''',']','\"',':','C','h','a','r','a','c','t','e','r',' ','C','o','n','s','t',':',':','\n',
'	','n','u','m','e','r','i','c',' ','c','o','n','s','t','a','n','t',':','\"','<','(','(','0','(','x','|','X',')','[','0','-','9','a','-','f','A','-','F',']','*',')','|','(','(','[','0','-','9',']','+','\\','.','?','[','0','-','9',']','*',')','|','(','\\','.','[','0','-','9',']','+',')',')','(','(','e','|','E',')','(','\\','+','|','-',')','?','[','0','-','9',']','+',')','?',')','(','L','|','l','|','U','L','|','u','l','|','u','|','U','|','F','|','f',')','?','>','\"',':',':',':','N','u','m','e','r','i','c',' ','C','o','n','s','t',':',':','D','\n',
' ',' ',' ',' ','	','s','t','o','r','a','g','e',' ','k','e','y','w','o','r','d',':','\"','<','(','c','o','n','s','t','|','e','x','t','e','r','n','|','a','u','t','o','|','r','e','g','i','s','t','e','r','|','s','t','a','t','i','c','|','u','n','s','i','g','n','e','d','|','s','i','g','n','e','d','|','v','o','l','a','t','i','l','e','|','c','h','a','r','|','d','o','u','b','l','e','|','f','l','o','a','t','|','i','n','t','|','l','o','n','g','|','s','h','o','r','t','|','v','o','i','d','|','t','y','p','e','d','e','f','|','s','t','r','u','c','t','|','u','n','i','o','n','|','e','n','u','m',')','>','\"',':',':',':','S','t','o','r','a','g','e',' ','T','y','p','e',':',':','D','\n',
'	','r','u','l','e',':','\"','^','[',' ','\\','t',']','*','[','A','-','Z','a','-','z','_',']','[','A','-','Z','a','-','z','0','-','9','_',']','*','[',' ','\\','t',']','*',':','\"',':',':',':','P','r','e','p','r','o','c','e','s','s','o','r','1',':',':','D','\n',
' ',' ',' ',' ','	','k','e','y','w','o','r','d',':','\"','<','(','r','e','t','u','r','n','|','g','o','t','o','|','i','f','|','e','l','s','e','|','c','a','s','e','|','d','e','f','a','u','l','t','|','s','w','i','t','c','h','|','b','r','e','a','k','|','c','o','n','t','i','n','u','e','|','w','h','i','l','e','|','d','o','|','f','o','r','|','s','i','z','e','o','f',')','>','\"',':',':',':','K','e','y','w','o','r','d',':',':','D','\n',
'	','y','a','c','c',' ','k','e','y','w','o','r','d',':','\"','<','(','e','r','r','o','r','|','Y','Y','A','B','O','R','T','|','Y','Y','A','C','C','E','P','T','|','Y','Y','B','A','C','K','U','P','|','Y','Y','E','R','R','O','R','|','Y','Y','I','N','I','T','D','E','P','T','H','|','Y','Y','L','T','Y','P','E','|','Y','Y','M','A','X','D','E','P','T','H','|','Y','Y','R','E','C','O','V','E','R','I','N','G','|','Y','Y','S','T','Y','P','E','|','y','y','c','h','a','r','|','y','y','c','l','e','a','r','i','n','|','y','y','d','e','b','u','g','|','y','y','e','r','r','o','k','|','y','y','e','r','r','o','r','|','y','y','l','e','x','|','y','y','l','v','a','l','|','y','y','l','l','o','c','|','y','y','n','e','r','r','s','|','y','y','p','a','r','s','e',')','>','\"',':',':',':','T','e','x','t',' ','A','r','g',':',':','D','\n',
'	','p','e','r','c','e','n','t',' ','k','e','y','w','o','r','d',':','\"','<','(','%','l','e','f','t','|','%','n','o','n','a','s','s','o','c','|','%','p','r','e','c','|','%','r','i','g','h','t','|','%','s','t','a','r','t','|','%','t','o','k','e','n','|','%','t','y','p','e','|','%','u','n','i','o','n',')','>','(','[',' ','\\','t',']','*','\\','<','.','*','\\','>',')','?','\"',':',':',':','T','e','x','t',' ','A','r','g',':',':','D','\n',
' ',' ',' ',' ','	','b','r','a','c','e','s',':','\"','[','{','}',']','\"',':',':',':','K','e','y','w','o','r','d',':',':','D','\n',
'	','m','a','r','k','e','r','s',':','\"','<','(','%','{','|','%','}','|','%','%',')','>','\"',':',':',':','F','l','a','g',':',':','D','\n',
'	','p','e','r','c','e','n','t',' ','s','u','b','-','e','x','p','r',':','\"','\\','2','\"',':',':',':','T','e','x','t',' ','A','r','g','2',':','p','e','r','c','e','n','t',' ','k','e','y','w','o','r','d',':','D','C','}','\0'};
static char AuxString11[] = {'M','a','k','e','f','i','l','e',':','8',':','0','{','\n',
'	','C','o','m','m','e','n','t',':','\"','#','\"',':','\"','$','\"',':',':','C','o','m','m','e','n','t',':',':','\n',
'	','A','s','s','i','g','n','m','e','n','t',':','\"','^','(',' ','*','|',' ','[',' ','\\','t',']','*',')','[','A','-','Z','a','-','z','0','-','9','_','+',']','*','[',' ','\\','t',']','*','(','\\','+','|',':',')','?','=','\"',':',':',':','P','r','e','p','r','o','c','e','s','s','o','r',':',':','\n',
'	','D','e','p','e','n','d','e','n','c','y',' ','L','i','n','e',':','\"','^',' ','*','(','[','A','-','Z','a','-','z','0','-','9','.','/','$','(',')','{','}',' ','_','%','+','-',']','*',')',':',':','?','\"',':','\"','$','|',';','\"',':',':','T','e','x','t',' ','K','e','y','1',':',':','\n',
'	','D','e','p',' ','T','a','r','g','e','t',':','\"','\\','1','\"',':','\"','\"',':',':','T','e','x','t',' ','K','e','y',':','D','e','p','e','n','d','e','n','c','y',' ','L','i','n','e',':','C','\n',
'	','D','e','p',' ','C','o','n','t','i','n','u','a','t','i','o','n',':','\"','\\','\\','\\','n','\"',':',':',':','K','e','y','w','o','r','d',':','D','e','p','e','n','d','e','n','c','y',' ','L','i','n','e',':','\n',
'	','D','e','p',' ','C','o','m','m','e','n','t',':','\"','#','\"',':','\"','$','\"',':',':','C','o','m','m','e','n','t',':','D','e','p','e','n','d','e','n','c','y',' ','L','i','n','e',':','\n',
'	','D','e','p',' ','M','a','c','r','o',':','\"','\\','$','(','[','A','-','Z','a','-','z','0','-','9','_',']','|','\\','(','[','^',')',']','*','\\',')','|','{','[','^','}',']','*','}',')','\"',':',':',':','P','r','e','p','r','o','c','e','s','s','o','r',':','D','e','p','e','n','d','e','n','c','y',' ','L','i','n','e',':','\n',
'	','D','e','p',' ','I','n','t','e','r','n','a','l',' ','M','a','c','r','o',':','\"','\\','$','(','[','<','@','*','?','%',']','|','\\','$','@',')','\"',':',':',':','P','r','e','p','r','o','c','e','s','s','o','r','1',':','D','e','p','e','n','d','e','n','c','y',' ','L','i','n','e',':','\n',
'	','C','o','n','t','i','n','u','a','t','i','o','n',':','\"','\\','\\','$','\"',':',':',':','K','e','y','w','o','r','d',':',':','\n',
'	','M','a','c','r','o',':','\"','\\','$','(','[','A','-','Z','a','-','z','0','-','9','_',']','|','\\','(','[','^',')',']','*','\\',')','|','{','[','^','}',']','*','}',')','\"',':',':',':','P','r','e','p','r','o','c','e','s','s','o','r',':',':','\n',
'	','I','n','t','e','r','n','a','l',' ','M','a','c','r','o',':','\"','\\','$','(','[','<','@','*','?','%',']','|','\\','$','@',')','\"',':',':',':','P','r','e','p','r','o','c','e','s','s','o','r','1',':',':','\n',
'	','E','s','c','a','p','e','d',' ','D','o','l','l','a','r',':','\"','\\','$','\\','$','\"',':',':',':','C','o','m','m','e','n','t',':',':','\n',
'	','I','n','c','l','u','d','e',':','\"','^','i','n','c','l','u','d','e','[',' ','\\','t',']','\"',':',':',':','K','e','y','w','o','r','d',':',':','}','\0'};
static char AuxString12[] = {'S','h',' ','K','s','h',' ','B','a','s','h',':','1',':','0','{','\n',
' ',' ',' ',' ',' ',' ',' ',' ','e','s','c','a','p','e','d',' ','s','p','e','c','i','a','l',' ','c','h','a','r','a','c','t','e','r','s',':','\"','\\','\\','[','\\','\\','\"','\"','$','`',''',']','\"',':',':',':','K','e','y','w','o','r','d',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','s','i','n','g','l','e',' ','q','u','o','t','e','d',' ','s','t','r','i','n','g',':','\"',''','\"',':','\"',''','\"',':',':','S','t','r','i','n','g','1',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','d','o','u','b','l','e',' ','q','u','o','t','e','d',' ','s','t','r','i','n','g',':','\"','\"','\"','\"',':','\"','\"','\"','\"',':',':','S','t','r','i','n','g',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','d','o','u','b','l','e',' ','q','u','o','t','e','d',' ','e','s','c','a','p','e',':','\"','\\','\\','[','\\','\\','\"','\"','$','`',']','\"',':',':',':','S','t','r','i','n','g','2',':','d','o','u','b','l','e',' ','q','u','o','t','e','d',' ','s','t','r','i','n','g',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','d','q',' ','c','o','m','m','a','n','d',' ','s','u','b',':','\"','`','\"',':','\"','`','\"',':','\"','\"','\"','\"',':','S','u','b','r','o','u','t','i','n','e',':','d','o','u','b','l','e',' ','q','u','o','t','e','d',' ','s','t','r','i','n','g',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','d','q',' ','a','r','i','t','h','m','e','t','i','c',' ','e','x','p','a','n','s','i','o','n',':','\"','\\','$','\\','(','\\','(','\"',':','\"','\\',')','\\',')','\"',':','\"','\"','\"','\"',':','S','t','r','i','n','g',':','d','o','u','b','l','e',' ','q','u','o','t','e','d',' ','s','t','r','i','n','g',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','d','q',' ','n','e','w',' ','c','o','m','m','a','n','d',' ','s','u','b',':','\"','\\','$','\\','(','\"',':','\"','\\',')','\"',':','\"','\"','\"','\"',':','S','u','b','r','o','u','t','i','n','e',':','d','o','u','b','l','e',' ','q','u','o','t','e','d',' ','s','t','r','i','n','g',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','d','q',' ','v','a','r','i','a','b','l','e','s',':','\"','\\','$','(','[','-','*','@','#','?','$','!','0','-','9',']','|','[','a','-','z','A','-','Z','_',']','[','0','-','9','a','-','z','A','-','Z','_',']','*',')','\"',':',':',':','I','d','e','n','t','i','f','i','e','r','1',':','d','o','u','b','l','e',' ','q','u','o','t','e','d',' ','s','t','r','i','n','g',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','d','q',' ','v','a','r','i','a','b','l','e','s','2',':','\"','\\','$','{','\"',':','\"','}','\"',':','\"','\\','n','\"',':','I','d','e','n','t','i','f','i','e','r','1',':','d','o','u','b','l','e',' ','q','u','o','t','e','d',' ','s','t','r','i','n','g',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','a','r','i','t','h','m','e','t','i','c',' ','e','x','p','a','n','s','i','o','n',':','\"','\\','$','\\','(','\\','(','\"',':','\"','\\',')','\\',')','\"',':',':','S','t','r','i','n','g',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','a','e',' ','e','s','c','a','p','e','s',':','\"','\\','\\','[','\\','\\','$','`','\"','\"',''',']','\"',':',':',':','S','t','r','i','n','g','2',':','a','r','i','t','h','m','e','t','i','c',' ','e','x','p','a','n','s','i','o','n',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','a','e',' ','s','i','n','g','l','e',' ','q','u','o','t','e','d',' ','s','t','r','i','n','g',':','\"',''','\"',':','\"',''','\"',':','\"','\\',')','\\',')','\"',':','S','t','r','i','n','g','1',':','a','r','i','t','h','m','e','t','i','c',' ','e','x','p','a','n','s','i','o','n',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','a','e',' ','c','o','m','m','a','n','d',' ','s','u','b',':','\"','`','\"',':','\"','`','\"',':','\"','\\',')','\\',')','\"',':','S','u','b','r','o','u','t','i','n','e',':','a','r','i','t','h','m','e','t','i','c',' ','e','x','p','a','n','s','i','o','n',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','a','e',' ','a','r','i','t','h','m','e','t','i','c',' ','e','x','p','a','n','s','i','o','n',':','\"','\\','$','\\','(','\\','(','\"',':','\"','\\',')','\\',')','\"',':',':','S','t','r','i','n','g',':','a','r','i','t','h','m','e','t','i','c',' ','e','x','p','a','n','s','i','o','n',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','a','e',' ','n','e','w',' ','c','o','m','m','a','n','d',' ','s','u','b',':','\"','\\','$','\\','(','\"',':','\"','\\',')','\"',':','\"','\\',')','\\',')','\"',':','S','u','b','r','o','u','t','i','n','e',':','a','r','i','t','h','m','e','t','i','c',' ','e','x','p','a','n','s','i','o','n',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','a','e',' ','v','a','r','i','a','b','l','e','s',':','\"','\\','$','(','[','-','*','@','#','?','$','!','0','-','9',']','|','[','a','-','z','A','-','Z','_',']','[','0','-','9','a','-','z','A','-','Z','_',']','*',')','\"',':',':',':','I','d','e','n','t','i','f','i','e','r','1',':','a','r','i','t','h','m','e','t','i','c',' ','e','x','p','a','n','s','i','o','n',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','a','e',' ','v','a','r','i','a','b','l','e','s','2',':','\"','\\','$','{','\"',':','\"','}','\"',':','\"','\\',')','\\',')','\"',':','I','d','e','n','t','i','f','i','e','r','1',':','a','r','i','t','h','m','e','t','i','c',' ','e','x','p','a','n','s','i','o','n',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','c','o','m','m','e','n','t','s',':','\"','^','[',' ','\\','t',']','*','#','\"',':','\"','$','\"',':',':','C','o','m','m','e','n','t',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','c','o','m','m','a','n','d',' ','s','u','b','s','t','i','t','u','t','i','o','n',':','\"','`','\"',':','\"','`','\"',':',':','S','u','b','r','o','u','t','i','n','e',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','c','s',' ','e','s','c','a','p','e','s',':','\"','\\','\\','[','\\','\\','$','`','\"','\"',''',']','\"',':',':',':','S','u','b','r','o','u','t','i','n','e','1',':','c','o','m','m','a','n','d',' ','s','u','b','s','t','i','t','u','t','i','o','n',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','c','s',' ','s','i','n','g','l','e',' ','q','u','o','t','e','d',' ','s','t','r','i','n','g',':','\"',''','\"',':','\"',''','\"',':','\"','`','\"',':','S','t','r','i','n','g','1',':','c','o','m','m','a','n','d',' ','s','u','b','s','t','i','t','u','t','i','o','n',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','c','s',' ','v','a','r','i','a','b','l','e','s',':','\"','\\','$','(','[','-','*','@','#','?','$','!','0','-','9',']','|','[','a','-','z','A','-','Z','_',']','[','0','-','9','a','-','z','A','-','Z','_',']','*',')','\"',':',':',':','I','d','e','n','t','i','f','i','e','r','1',':','c','o','m','m','a','n','d',' ','s','u','b','s','t','i','t','u','t','i','o','n',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','c','s',' ','v','a','r','i','a','b','l','e','s','2',':','\"','\\','$','{','\"',':','\"','}','\"',':','\"','`','\"',':','I','d','e','n','t','i','f','i','e','r','1',':','c','o','m','m','a','n','d',' ','s','u','b','s','t','i','t','u','t','i','o','n',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','n','e','w',' ','c','o','m','m','a','n','d',' ','s','u','b','s','t','i','t','u','t','i','o','n',':','\"','\\','$','\\','(','\"',':','\"','\\',')','\"',':',':','S','u','b','r','o','u','t','i','n','e',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','n','c','s',' ','e','s','c','a','p','e','s',':','\"','\\','\\','[','\\','\\','$','`','\"','\"',''',']','\"',':',':',':','S','u','b','r','o','u','t','i','n','e','1',':','n','e','w',' ','c','o','m','m','a','n','d',' ','s','u','b','s','t','i','t','u','t','i','o','n',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','n','c','s',' ','s','i','n','g','l','e',' ','q','u','o','t','e','d',' ','s','t','r','i','n','g',':','\"',''','\"',':','\"',''','\"',':',':','S','t','r','i','n','g','1',':','n','e','w',' ','c','o','m','m','a','n','d',' ','s','u','b','s','t','i','t','u','t','i','o','n',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','n','c','s',' ','v','a','r','i','a','b','l','e','s',':','\"','\\','$','(','[','-','*','@','#','?','$','!','0','-','9',']','|','[','a','-','z','A','-','Z','_',']','[','0','-','9','a','-','z','A','-','Z','_',']','*',')','\"',':',':',':','I','d','e','n','t','i','f','i','e','r','1',':','n','e','w',' ','c','o','m','m','a','n','d',' ','s','u','b','s','t','i','t','u','t','i','o','n',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','n','c','s',' ','v','a','r','i','a','b','l','e','s','2',':','\"','\\','$','{','\"',':','\"','}','\"',':','\"','\\',')','\"',':','I','d','e','n','t','i','f','i','e','r','1',':','n','e','w',' ','c','o','m','m','a','n','d',' ','s','u','b','s','t','i','t','u','t','i','o','n',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','a','s','s','i','g','n','m','e','n','t',':','\"','[','a','-','z','A','-','Z','_',']','[','0','-','9','a','-','z','A','-','Z','_',']','*','[',' ','\\','t',']','*','=','\"',':',':',':','I','d','e','n','t','i','f','i','e','r','1',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','v','a','r','i','a','b','l','e','s',':','\"','\\','$','(','[','-','*','@','#','?','$','!','0','-','9','_',']','|','[','a','-','z','A','-','Z','_',']','[','0','-','9','a','-','z','A','-','Z','_',']','*',')','\"',':',':',':','I','d','e','n','t','i','f','i','e','r','1',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','v','a','r','i','a','b','l','e','s','2',':','\"','\\','$','{','\"',':','\"','}','\"',':',':','I','d','e','n','t','i','f','i','e','r','1',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','c','o','m','m','e','n','t','s',' ','i','n',' ','l','i','n','e',':','\"','#','\"',':','\"','$','\"',':',':','C','o','m','m','e','n','t',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','n','u','m','b','e','r','s',':','\"','<','(','(','0','(','x','|','X',')','[','0','-','9','a','-','f','A','-','F',']','*',')','|','[','0','-','9','.',']','+','(','(','e','|','E',')','(','\\','+','|','-',')','?',')','?','[','0','-','9',']','*',')','(','L','|','l','|','U','L','|','u','l','|','u','|','U','|','F','|','f',')','?','>','\"',':',':',':','N','u','m','e','r','i','c',' ','C','o','n','s','t',':',':','D','\n',
' ',' ',' ',' ',' ',' ',' ',' ','k','e','y','w','o','r','d','s',':','\"','<','(','i','f','|','f','i','|','t','h','e','n','|','e','l','s','e','|','e','l','i','f','|','c','a','s','e','|','e','s','a','c','|','w','h','i','l','e','|','f','o','r','|','d','o','|','d','o','n','e','|','i','n','|','s','e','l','e','c','t','|','u','n','t','i','l','|','f','u','n','c','t','i','o','n','|','c','o','n','t','i','n','u','e','|','b','r','e','a','k','|','r','e','t','u','r','n','|','e','x','i','t',')','>','\"',':',':',':','K','e','y','w','o','r','d',':',':','D','\n',
' ',' ',' ',' ',' ',' ',' ',' ','c','o','m','m','a','n','d',' ','o','p','t','i','o','n','s',':','\"','[',' ','\\','t',']','-','[','^',' ','\\','t','{','}','[','\\',']',',','.','(',')',''','\"','\"','~','!','@','#','$','%','^','&','*','|','\\','\\','<','>','?',']','+','\"',':',':',':','I','d','e','n','t','i','f','i','e','r',':',':','D','\n',
' ',' ',' ',' ',' ',' ',' ',' ','d','e','l','i','m','i','t','e','r','s',':','\"','<','[','.',']','>','|','[','{','}',';','<','>','&','~','=','!','|','^','%','[','\\',']','+','*','|',']','\"',':',':',':','T','e','x','t',' ','K','e','y',':',':','D','\n',
' ',' ',' ',' ',' ',' ',' ',' ','b','u','i','l','t',' ','i','n','s',':','\"','<','(',':','|','\\','\\','.','|','\\','\\','[','\\','\\','[','|',']',']','|','s','o','u','r','c','e','|','a','l','i','a','s','|','b','g','|','b','i','n','d','|','b','u','i','l','t','i','n','|','c','d','|','c','h','d','i','r','|','c','o','m','m','a','n','d','|','d','e','c','l','a','r','e','|','d','i','r','s','|','e','c','h','o','|','e','n','a','b','l','e','|','e','v','a','l','|','e','x','e','c','|','e','x','p','o','r','t','|','f','c','|','f','g','|','g','e','t','o','p','t','s','|','h','a','s','h','|','h','e','l','p','|','h','i','s','t','o','r','y','|','j','o','b','s','|','k','i','l','l','|','l','e','t','|','l','o','c','a','l','|','l','o','g','o','u','t','|','p','o','p','d','|','p','r','i','n','t','|','p','u','s','h','d','|','p','w','d','|','r','e','a','d','|','r','e','a','d','o','n','l','y','|','s','e','t','|','s','h','i','f','t','|','s','t','o','p','|','s','u','s','p','e','n','d','|','t','e','s','t','|','t','i','m','e','s','|','t','r','a','p','|','t','y','p','e','|','t','y','p','e','s','e','t','|','u','l','i','m','i','t','|','u','m','a','s','k','|','u','n','a','l','i','a','s','|','u','n','s','e','t','|','w','a','i','t','|','w','h','e','n','c','e',')','>','\"',':',':',':','S','u','b','r','o','u','t','i','n','e','1',':',':','D','}','\0'};
static char AuxString13[] = {'C','s','h',':','1',':','0',' ','{','\n',
'	','C','o','m','m','e','n','t',':','\"','#','\"',':','\"','$','\"',':',':','C','o','m','m','e','n','t',':',':','\n',
'	','S','i','n','g','l','e',' ','Q','u','o','t','e',' ','S','t','r','i','n','g',':','\"',''','\"',':','\"','(','[','^','\\','\\',']',''','|','^',''',')','\"',':','\"','\\','n','\"',':','S','t','r','i','n','g',':',':','\n',
'	','S','Q',' ','S','t','r','i','n','g',' ','E','s','c',' ','C','h','a','r',':','\"','\\','\\','(','[','b','c','f','n','r','t','$','\\','n','\\','\\',']','|','[','0','-','9',']','[','0','-','9',']','?','[','0','-','9',']','?',')','\"',':',':',':','S','t','r','i','n','g','1',':','S','i','n','g','l','e',' ','Q','u','o','t','e',' ','S','t','r','i','n','g',':','\n',
'	','D','o','u','b','l','e',' ','Q','u','o','t','e',' ','S','t','r','i','n','g',':','\"','\"','\"','\"',':','\"','\"','\"','\"',':','\"','\\','n','\"',':','S','t','r','i','n','g',':',':','\n',
'	','D','Q',' ','S','t','r','i','n','g',' ','E','s','c',' ','C','h','a','r',':','\"','\\','\\','(','[','b','c','f','n','r','t','\\','n','\\','\\',']','|','[','0','-','9',']','[','0','-','9',']','?','[','0','-','9',']','?',')','\"',':',':',':','S','t','r','i','n','g','1',':','D','o','u','b','l','e',' ','Q','u','o','t','e',' ','S','t','r','i','n','g',':','\n',
'	','K','e','y','w','o','r','d','s',':','\"','(','^','|','[','`',';','(',')',']',')','[',' ','\t',']','*','(','r','e','t','u','r','n','|','i','f','|','e','n','d','i','f','|','t','h','e','n','|','e','l','s','e','|','s','w','i','t','c','h','|','e','n','d','s','w','|','w','h','i','l','e','|','e','n','d','|','f','o','r','e','a','c','h','|','d','o','|','d','o','n','e',')','>','\"',':',':',':','K','e','y','w','o','r','d',':',':','D','\n',
'	','V','a','r','i','a','b','l','e',' ','R','e','f',':','\"','\\','$','(','[','<','$','0','-','9','\\','*',']','|','[','#','a','-','z','A','-','Z','_','?',']','[','0','-','9','a','-','z','A','-','Z','_','[','\\',']',']','*','(',':','(','[','e','h','q','r','t','x',']','|','g','h','|','g','t','|','g','r',')',')','?','|','{','[','#','0','-','9','a','-','z','A','-','Z','_','?',']','[','a','-','z','A','-','Z','0','-','9','_','[','\\',']',']','*','(',':','(','[','e','h','q','r','t','x',']','|','g','h','|','g','t','|','g','r',')',')','?','}',')','\"',':',':',':','I','d','e','n','t','i','f','i','e','r','1',':',':','\n',
'	','V','a','r','i','a','b','l','e',' ','i','n',' ','S','t','r','i','n','g',':','\"','\\','$','(','[','<','$','0','-','9','\\','*',']','|','[','#','a','-','z','A','-','Z','_','?',']','[','0','-','9','a','-','z','A','-','Z','_','[','\\',']',']','*','(',':','(','[','e','h','q','r','t','x',']','|','g','h','|','g','t','|','g','r',')',')','?','|','{','[','#','0','-','9','a','-','z','A','-','Z','_','?',']','[','a','-','z','A','-','Z','0','-','9','_','[','\\',']',']','*','(',':','(','[','e','h','q','r','t','x',']','|','g','h','|','g','t','|','g','r',')',')','?','}',')','\"',':',':',':','I','d','e','n','t','i','f','i','e','r','1',':','D','o','u','b','l','e',' ','Q','u','o','t','e',' ','S','t','r','i','n','g',':','\n',
'	','N','a','k','e','d',' ','V','a','r','i','a','b','l','e',' ','C','m','d','s',':','\"','<','(','u','n','s','e','t','|','s','e','t','|','s','e','t','e','n','v','|','s','h','i','f','t',')','[',' ','\\','t',']','+','[','0','-','9','a','-','z','A','-','Z','_',']','*','(','\\','[','.','+','\\',']',')','?','\"',':',':',':','I','d','e','n','t','i','f','i','e','r','1',':',':','\n',
'	','R','e','c','o','l','o','r',' ','N','a','k','e','d',' ','C','m','d',':','\"','\\','1','\"',':',':',':','K','e','y','w','o','r','d',':','N','a','k','e','d',' ','V','a','r','i','a','b','l','e',' ','C','m','d','s',':','C','\n',
'	','B','u','i','l','t',' ','I','n',' ','C','m','d','s',':','\"','(','^','|','\\','|','&','|','[','\\','|','`',';','(',')',']',')','[',' ','\t',']','*','(','a','l','i','a','s','|','b','g','|','b','r','e','a','k','|','b','r','e','a','k','s','w','|','c','a','s','e','|','c','d','|','c','h','d','i','r','|','c','o','n','t','i','n','u','e','|','d','e','f','a','u','l','t','|','e','c','h','o','|','e','v','a','l','|','e','x','e','c','|','e','x','i','t','|','f','g','|','g','o','t','o','|','g','l','o','b','|','h','a','s','h','s','t','a','t','|','h','i','s','t','o','r','y','|','j','o','b','s','|','k','i','l','l','|','l','i','m','i','t','|','l','o','g','i','n','|','l','o','g','o','u','t','|','n','o','h','u','p','|','n','o','t','i','f','y','|','n','i','c','e','|','o','n','i','n','t','r','|','p','o','p','d','|','p','u','s','h','d','|','p','r','i','n','t','e','n','v','|','r','e','a','d','|','r','e','h','a','s','h','|','r','e','p','e','a','t','|','s','e','t','|','s','e','t','e','n','v','|','s','h','i','f','t','|','s','o','u','r','c','e','|','s','u','s','p','e','n','d','|','t','i','m','e','|','u','m','a','s','k','|','u','n','a','l','i','a','s','|','u','n','h','a','s','h','|','u','n','l','i','m','i','t','|','u','n','s','e','t','|','u','n','s','e','t','e','n','v','|','w','a','i','t',')','>','\"',':',':',':','K','e','y','w','o','r','d',':',':','D','\n',
' ',' ',' ',' ',' ',' ',' ',' ','T','c','s','h',' ','B','u','i','l','t',' ','I','n',' ','C','m','d','s',':','\"','(','^','|','\\','|','&','|','[','\\','|','`',';','(',')',']',')','[',' ','\t',']','*','(','a','l','l','o','c','|','b','i','n','d','k','e','y','|','b','u','i','l','t','i','n','s','|','c','o','m','p','l','e','t','e','|','e','c','h','o','t','c','|','f','i','l','e','t','e','s','t','|','h','u','p','|','l','o','g','|','s','c','h','e','d','|','s','e','t','t','c','|','s','e','t','t','y','|','s','t','o','p','|','t','e','l','l','t','c','|','u','n','c','o','m','p','l','e','t','e','|','w','h','e','r','e','|','w','h','i','c','h','|','d','i','r','s','|','l','s','-','F',')','>','\"',':',':',':','K','e','y','w','o','r','d',':',':','D','\n',
'	','S','p','e','c','i','a','l',' ','C','h','a','r','s',':','\"','(','[','-','{','}',';','.',',','<','>','&','~','=','!','|','^','%','[','\\',']','\\','+','\\','*','\\','|','(',')',']',')','\"',':',':',':','K','e','y','w','o','r','d',':',':','D','}','\0'};
static char AuxString14[] = {'P','y','t','h','o','n',':','1',':','0','{','\n',
' ',' ',' ',' ',' ',' ',' ',' ','C','o','m','m','e','n','t',':','\"','#','\"',':','\"','$','\"',':',':','C','o','m','m','e','n','t',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','S','t','r','i','n','g','3',':','\"','\"','\"','\"','\"','\"','\"','\"',':','\"','\"','\"','\"','\"','\"','\"','\"',':',':','S','t','r','i','n','g','1',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','S','t','r','i','n','g',':','\"','\"','\"','\"',':','\"','\"','\"','\"',':','\"','\\','n','\"',':','S','t','r','i','n','g','1',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','S','t','r','i','n','g','2',':','\"',''','\"',':','\"',''','\"',':','\"','\\','n','\"',':','S','t','r','i','n','g','1',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','N','u','m','e','r','i','c',' ','c','o','n','s','t',':','\"','<','(','(','0','(','x','|','X',')','[','0','-','9','a','-','f','A','-','F',']','*',')','|','[','0','-','9','.',']','+','(','(','e','|','E',')','(','\\','+','|','-',')','?',')','?','[','0','-','9',']','*',')','>','\"',':',':',':','N','u','m','e','r','i','c',' ','C','o','n','s','t',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','i','n','c','l','u','d','e',':','\"','<','(','i','m','p','o','r','t','|','f','r','o','m',')','>','\"',':','\"','$','\"',':',':','P','r','e','p','r','o','c','e','s','s','o','r',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','S','t','o','r','a','g','e',' ','k','e','y','w','o','r','d',':','\"','<','(','c','l','a','s','s','|','g','l','o','b','a','l','|','l','a','m','b','d','a',')','>','\"',':',':',':','S','t','o','r','a','g','e',' ','T','y','p','e',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','K','e','y','w','o','r','d',':','\"','<','(','a','c','c','e','s','s','|','d','e','l','|','r','e','t','u','r','n','|','a','n','d','|','e','l','i','f','|','n','o','t','|','t','r','y','|','b','r','e','a','k','|','e','l','s','e','|','i','f','|','o','r','|','w','h','i','l','e','|','e','x','c','e','p','t','|','p','a','s','s','|','c','o','n','t','i','n','u','e','|','f','i','n','a','l','l','y','|','i','n','|','p','r','i','n','t','|','d','e','f','|','f','o','r','|','i','s','|','r','a','i','s','e',')','>','\"',':',':',':','K','e','y','w','o','r','d',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','B','r','a','c','e','s',' ','a','n','d',' ','p','a','r','e','n','s',':','\"','[','{','(',')','}',']','\"',':',':',':','K','e','y','w','o','r','d',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','S','t','r','i','n','g',' ','e','s','c','a','p','e',' ','c','h','a','r','s',':','\"','\\','\\','(','.','|','\\','n','|','\\','r','|','\\','b',')','\"',':',':',':','S','t','r','i','n','g','1',':',':','}','\0'};
static char AuxString15[] = {'A','w','k',':','2',':','0','{','\n',
' ',' ',' ',' ',' ',' ',' ',' ','C','o','m','m','e','n','t',':','\"','#','\"',':','\"','$','\"',':',':','C','o','m','m','e','n','t',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','P','a','t','t','e','r','n',':','\"','/','(','\\','\\','.','|','(','[','[',']','[',']',']','?','[','^',']',']','+','[',']',']',')','|','[','^','/',']',')','+','/','\"',':',':',':','P','r','e','p','r','o','c','e','s','s','o','r',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','K','e','y','w','o','r','d',':','\"','<','(','r','e','t','u','r','n','|','p','r','i','n','t','|','p','r','i','n','t','f','|','i','f','|','e','l','s','e','|','w','h','i','l','e','|','f','o','r','|','i','n','|','d','o','|','b','r','e','a','k','|','c','o','n','t','i','n','u','e','|','n','e','x','t','|','e','x','i','t','|','c','l','o','s','e','|','s','y','s','t','e','m','|','g','e','t','l','i','n','e',')','>','\"',':',':',':','K','e','y','w','o','r','d',':',':','D','\n',
' ',' ',' ',' ',' ',' ',' ',' ','S','t','r','i','n','g',':','\"','\"','\"','\"',':','\"','\"','\"','\"',':','\"','\\','n','\"',':','S','t','r','i','n','g','1',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','S','t','r','i','n','g',' ','e','s','c','a','p','e',':','\"','\\','\\','(','.','|','\\','n',')','\"',':',':',':','S','t','r','i','n','g','1',':','S','t','r','i','n','g',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','B','u','i','l','t','i','n',' ','f','u','n','c','t','i','o','n','s',':','\"','<','(','a','t','a','n','2','|','c','o','s','|','e','x','p','|','i','n','t','|','l','o','g','|','r','a','n','d','|','s','i','n','|','s','q','r','t','|','s','r','a','n','d','|','g','s','u','b','|','i','n','d','e','x','|','l','e','n','g','t','h','|','m','a','t','c','h','|','s','p','l','i','t','|','s','p','r','i','n','t','f','|','s','u','b','|','s','u','b','s','t','r',')','>','\"',':',':',':','K','e','y','w','o','r','d',':',':','D','\n',
' ',' ',' ',' ',' ',' ',' ',' ','G','a','w','k',' ','b','u','i','l','t','i','n',' ','f','u','n','c','t','i','o','n','s',':','\"','<','(','f','f','l','u','s','h','|','g','e','n','s','u','b','|','t','o','l','o','w','e','r','|','t','o','u','p','p','e','r','|','s','y','s','t','i','m','e','|','s','t','r','f','t','i','m','e',')','>','\"',':',':',':','T','e','x','t',' ','K','e','y','1',':',':','D','\n',
' ',' ',' ',' ',' ',' ',' ',' ','B','u','i','l','t','i','n',' ','v','a','r','i','a','b','l','e','s',':','\"','<','(','A','R','G','C','|','A','R','G','V','|','F','I','L','E','N','A','M','E','|','F','N','R','|','F','S','|','N','F','|','N','R','|','O','F','M','T','|','O','F','S','|','O','R','S','|','R','L','E','N','G','T','H','|','R','S','|','R','S','T','A','R','T','|','S','U','B','S','E','P',')','>','\"',':',':',':','S','t','o','r','a','g','e',' ','T','y','p','e',':',':','D','\n',
' ',' ',' ',' ',' ',' ',' ',' ','G','a','w','k',' ','b','u','i','l','t','i','n',' ','v','a','r','i','a','b','l','e','s',':','\"','\"','\"','<','(','A','R','G','I','N','D','|','E','R','R','N','O','|','R','T','|','I','G','N','O','R','E','C','A','S','E','|','F','I','E','L','D','W','I','D','T','H','S',')','>','\"','\"','\"',':',':',':','S','t','o','r','a','g','e',' ','T','y','p','e',':',':','D','\n',
' ',' ',' ',' ',' ',' ',' ',' ','F','i','e','l','d',':','\"','\\','$','[','0','-','9','a','-','z','A','-','Z','_',']','+','|','\\','$','[',' ','\\','t',']','*','\\','(','[','^',',',';',']','*','\\',')','\"',':',':',':','S','t','o','r','a','g','e',' ','T','y','p','e',':',':','D','\n',
' ',' ',' ',' ',' ',' ',' ',' ','B','e','g','i','n','E','n','d',':','\"','<','(','B','E','G','I','N','|','E','N','D',')','>','\"',':',':',':','P','r','e','p','r','o','c','e','s','s','o','r','1',':',':','D','\n',
' ',' ',' ',' ',' ',' ',' ',' ','N','u','m','e','r','i','c',' ','c','o','n','s','t','a','n','t',':','\"','<','(','(','0','(','x','|','X',')','[','0','-','9','a','-','f','A','-','F',']','*',')','|','[','0','-','9','.',']','+','(','(','e','|','E',')','(','\\','+','|','-',')','?',')','?','[','0','-','9',']','*',')','(','L','|','l','|','U','L','|','u','l','|','u','|','U','|','F','|','f',')','?','>','\"',':',':',':','N','u','m','e','r','i','c',' ','C','o','n','s','t',':',':','D','\n',
' ',' ',' ',' ',' ',' ',' ',' ','S','t','r','i','n','g',' ','p','a','t','t','e','r','n',':','\"','~','[',' ','\\','t',']','*','\"','\"','\"',':','\"','\"','\"','\"',':','\"','\\','n','\"',':','P','r','e','p','r','o','c','e','s','s','o','r',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','S','t','r','i','n','g',' ','p','a','t','t','e','r','n',' ','e','s','c','a','p','e',':','\"','\\','\\','(','.','|','\\','n',')','\"',':',':',':','P','r','e','p','r','o','c','e','s','s','o','r',':','S','t','r','i','n','g',' ','p','a','t','t','e','r','n',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','n','e','w','l','i','n','e',' ','e','s','c','a','p','e',':','\"','\\','\\','$','\"',':',':',':','P','r','e','p','r','o','c','e','s','s','o','r','1',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','F','u','n','c','t','i','o','n',':','\"','f','u','n','c','t','i','o','n','\"',':',':',':','P','r','e','p','r','o','c','e','s','s','o','r','1',':',':','D','}','\0'};
static char AuxString16[] = {'L','a','T','e','X',':','1',':','0','{','\n',
'	','C','o','m','m','e','n','t',':','\"','%','\"',':','\"','$','\"',':',':','T','e','x','t',' ','C','o','m','m','e','n','t',':',':','\n',
'	','P','a','r','a','m','e','t','e','r',':','\"','#','[','0','-','9',']','*','\"',':',':',':','T','e','x','t',' ','A','r','g',':',':','\n',
'	','S','p','e','c','i','a','l',' ','C','h','a','r','s',':','\"','[','{','}','&',']','\"',':',':',':','K','e','y','w','o','r','d',':',':','\n',
'	','E','s','c','a','p','e',' ','C','h','a','r','s',':','\"','\\','\\','[','$','&','%','#','_','{','}',']','\"',':',':',':','T','e','x','t',' ','E','s','c','a','p','e',':',':','\n',
'	','S','u','p','e','r',' ','S','u','b',' ','1',' ','C','h','a','r',':','\"','(','\\','^','|','_',')','[','^','{',']','\"',':',':',':','T','e','x','t',' ','A','r','g','2',':',':','\n',
'	','V','e','r','b','a','t','i','m',' ','B','e','g','i','n',' ','E','n','d',':','\"','\\','\\','b','e','g','i','n','{','v','e','r','b','a','t','i','m','\\','*','?','}','\"',':','\"','\\','\\','e','n','d','{','v','e','r','b','a','t','i','m','\\','*','?','}','\"',':',':','P','l','a','i','n',':',':','\n',
'	','V','e','r','b','a','t','i','m',' ','C','o','l','o','r',':','\"','\\','0','\"',':','\"','\\','0','\"',':',':','K','e','y','w','o','r','d',':','V','e','r','b','a','t','i','m',' ','B','e','g','i','n',' ','E','n','d',':','C','\n',
'	','V','e','r','b','a','t','i','m',' ','1',':','\"','\\','\\','v','e','r','b','\\','*','?','`','\"',':','\"','`','\"',':',':','P','l','a','i','n',':',':','\n',
'	','V','e','r','b','a','t','i','m',' ','1',' ','C','o','l','o','r',':','\"','\\','0','\"',':','\"','\\','0','\"',':',':','K','e','y','w','o','r','d',':','V','e','r','b','a','t','i','m',' ','1',':','C','\n',
'	','V','e','r','b','a','t','i','m',' ','2',':','\"','\\','\\','v','e','r','b','\\','*','?','#','\"',':','\"','#','\"',':',':','P','l','a','i','n',':',':','\n',
'	','V','e','r','b','a','t','i','m',' ','2',' ','C','o','l','o','r',':','\"','\\','0','\"',':','\"','\\','0','\"',':',':','K','e','y','w','o','r','d',':','V','e','r','b','a','t','i','m',' ','2',':','C','\n',
'	','V','e','r','b','a','t','i','m',' ','3',' ','C','o','l','o','r',':','\"','\\','0','\"',':','\"','\\','0','\"',':',':','K','e','y','w','o','r','d',':','V','e','r','b','a','t','i','m',' ','3',':','C','\n',
'	','V','e','r','b','a','t','i','m',' ','3',':','\"','\\','\\','v','e','r','b','\\','*','?','/','\"',':','\"','/','\"',':',':','P','l','a','i','n',':',':','\n',
'	','I','n','l','i','n','e',' ','M','a','t','h',':','\"','\\','$','\"',':','\"','\\','$','\"',':','\"','\\','n','\\','n','\"',':','L','a','T','e','X',' ','M','a','t','h',':',':','\n',
'	','M','a','t','h',' ','C','o','l','o','r',':','\"','\\','0','\"',':','\"','\\','0','\"',':',':','K','e','y','w','o','r','d',':','I','n','l','i','n','e',' ','M','a','t','h',':','C','\n',
'	','I','n','l','i','n','e',' ','M','a','t','h','1',':','\"','\\','\\','\\','(','\"',':','\"','\\','\\','\\',')','\"',':',':','L','a','T','e','X',' ','M','a','t','h',':',':','\n',
'	','M','a','t','h','1',' ','C','o','l','o','r',':','\"','\\','0','\"',':','\"','\\','0','\"',':',':','K','e','y','w','o','r','d',':','I','n','l','i','n','e',' ','M','a','t','h','1',':','C','\n',
'	','M','a','t','h',' ','E','s','c','a','p','e',' ','C','h','a','r','s',':','\"','\\','\\','\\','$','\"',':',':',':','T','e','x','t',' ','E','s','c','a','p','e',':','I','n','l','i','n','e',' ','M','a','t','h',':','\n',
'	','N','o',' ','A','r','g',' ','C','o','m','m','a','n','d',':','\"','\\','\\','(','l','e','f','t','|','r','i','g','h','t',')','[','\\','[','\\',']','{','}','(',')',']','\"',':',':',':','T','e','x','t',' ','K','e','y',':',':','\n',
'	','C','o','m','m','a','n','d',':','\"','[','_','^',']','|','[','\\','\\','@',']','(','a',''','|','a','`','|','a','=','|','[','A','-','Z','a','-','z',']','+','\\','*','?','|','\\','\\','\\','*','|','[','-','@','_','=',''','`','^','\"','\"','|','\\','[','\\',']','*',':','!','+','<','>','/','~','.',',','\\','\\',' ',']',')','\"',':','\"','n','e','v','e','r','m','a','t','c','h','\"',':','\"','[','^','{','[','(',']','\"',':','T','e','x','t',' ','K','e','y',':',':','\n',
'	','C','m','d',' ','B','r','a','c','e',' ','A','r','g','s',':','\"','{','\"',':','\"','}','\"',':',':','T','e','x','t',' ','A','r','g','2',':','C','o','m','m','a','n','d',':','\n',
'	','B','r','a','c','e',' ','C','o','l','o','r',':','\"','\\','0','\"',':','\"','\\','0','\"',':',':','T','e','x','t',' ','A','r','g',':','C','m','d',' ','B','r','a','c','e',' ','A','r','g','s',':','C','\n',
'	','C','m','d',' ','P','a','r','e','n',' ','A','r','g','s',':','\"','\\','(','\"',':','\"','\\',')','\"',':','\"','$','\"',':','T','e','x','t',' ','A','r','g','2',':','C','o','m','m','a','n','d',':','\n',
'	','P','a','r','e','n',' ','C','o','l','o','r',':','\"','\\','0','\"',':','\"','\\','0','\"',':',':','T','e','x','t',' ','A','r','g',':','C','m','d',' ','P','a','r','e','n',' ','A','r','g','s',':','C','\n',
'	','C','m','d',' ','B','r','a','c','k','e','t',' ','A','r','g','s',':','\"','\\','[','\"',':','\"','\\',']','\"',':','\"','$','\"',':','T','e','x','t',' ','A','r','g','2',':','C','o','m','m','a','n','d',':','\n',
'	','B','r','a','c','k','e','t',' ','C','o','l','o','r',':','\"','\\','0','\"',':','\"','\\','0','\"',':',':','T','e','x','t',' ','A','r','g',':','C','m','d',' ','B','r','a','c','k','e','t',' ','A','r','g','s',':','C','\n',
'	','S','u','b',' ','C','o','m','m','a','n','d',':','\"','(','[','_','^',']','|','(','[','\\','\\','@',']','(','[','A','-','Z','a','-','z',']','+','\\','*','?','|','[','^','A','-','Z','a','-','z','$','&','%','#','{','}','~','\\','\\',' ','\\','t',']',')',')',')','\"',':',':',':','T','e','x','t',' ','K','e','y','1',':','C','m','d',' ','B','r','a','c','e',' ','A','r','g','s',':','\n',
'	','S','u','b',' ','B','r','a','c','e',':','\"','{','\"',':','\"','}','\"',':',':','T','e','x','t',' ','A','r','g','2',':','C','m','d',' ','B','r','a','c','e',' ','A','r','g','s',':','\n',
'	','S','u','b',' ','S','u','b',' ','B','r','a','c','e',':','\"','{','\"',':','\"','}','\"',':',':','T','e','x','t',' ','A','r','g','2',':','S','u','b',' ','B','r','a','c','e',':','\n',
'	','S','u','b',' ','S','u','b',' ','S','u','b',' ','B','r','a','c','e',':','\"','{','\"',':','\"','}','\"',':',':','T','e','x','t',' ','A','r','g','2',':','S','u','b',' ','S','u','b',' ','B','r','a','c','e',':','\n',
'	','S','u','b',' ','S','u','b',' ','S','u','b',' ','S','u','b',' ','B','r','a','c','e',':','\"','{','\"',':','\"','}','\"',':',':','T','e','x','t',' ','A','r','g','2',':','S','u','b',' ','S','u','b',' ','S','u','b',' ','B','r','a','c','e',':','\n',
'	','S','u','b',' ','P','a','r','e','n',':','\"','\\','(','\"',':','\"','\\',')','\"',':','\"','$','\"',':','T','e','x','t',' ','A','r','g','2',':','C','m','d',' ','P','a','r','e','n',' ','A','r','g','s',':','\n',
'	','S','u','b',' ','S','u','b',' ','P','a','r','e','n',':','\"','\\','(','\"',':','\"','\\',')','\"',':','\"','$','\"',':','T','e','x','t',' ','A','r','g','2',':','S','u','b',' ','P','a','r','e','n',':','\n',
'	','S','u','b',' ','S','u','b',' ','S','u','b',' ','P','a','r','e','n',':','\"','\\','(','\"',':','\"','\\',')','\"',':','\"','$','\"',':','T','e','x','t',' ','A','r','g','2',':','S','u','b',' ','S','u','b',' ','P','a','r','e','n',':','\n',
'	','S','u','b',' ','P','a','r','a','m','e','t','e','r',':','\"','#','[','0','-','9',']','*','\"',':',':',':','T','e','x','t',' ','A','r','g',':','C','m','d',' ','B','r','a','c','e',' ','A','r','g','s',':','\n',
'	','S','u','b',' ','S','p','e','c',' ','C','h','a','r','s',':','\"','[','{','}','$','&',']','\"',':',':',':','T','e','x','t',' ','A','r','g',':','C','m','d',' ','B','r','a','c','e',' ','A','r','g','s',':','\n',
'	','S','u','b',' ','E','s','c',' ','C','h','a','r','s',':','\"','\\','\\','[','$','&','%','#','_','{','}','~','^','\\','\\',']','\"',':',':',':','T','e','x','t',' ','A','r','g','1',':','C','m','d',' ','B','r','a','c','e',' ','A','r','g','s',':','}','\0'};
static char AuxString17[] = {'V','H','D','L',':','1',':','0','{','\n',
' ',' ',' ',' ',' ',' ',' ',' ','C','o','m','m','e','n','t','s',':','\"','-','-','\"',':','\"','$','\"',':',':','C','o','m','m','e','n','t',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','S','t','r','i','n','g',' ','L','i','t','e','r','a','l','s',':','\"','\"','\"','\"',':','\"','\"','\"','\"',':','\"','\\','n','\"',':','S','t','r','i','n','g',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','V','h','d','l',' ','A','t','t','r','i','b','u','t','e','s',':','\"',''','[','a','-','z','A','-','Z',']','[','a','-','z','A','-','Z','_',']','+','\"',':',':',':','A','d','a',' ','A','t','t','r','i','b','u','t','e','s',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','C','h','a','r','a','c','t','e','r',' ','L','i','t','e','r','a','l','s',':','\"',''','\"',':','\"',''','\"',':','\"','[','^','\\','\\',']','[','^',''',']','\"',':','C','h','a','r','a','c','t','e','r',' ','C','o','n','s','t',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','N','u','m','e','r','i','c',' ','L','i','t','e','r','a','l','s',':','\"','<','(','(','(','2','#','|','8','#','|','1','0','#','|','1','6','#',')','[','_','0','-','9','a','-','f','A','-','F',']','*','#',')','|','[','0','-','9','.',']','+',')','>','\"',':',':',':','N','u','m','e','r','i','c',' ','C','o','n','s','t',':',':','\n',
'	','P','r','e','d','e','f','i','n','e','d',' ','T','y','p','e','s',':','\"','<','(','[','a','A',']','l','i','a','s','|','A','L','I','A','S','|','[','c','C',']','o','n','s','t','a','n','t','|','C','O','N','S','T','A','N','T','|','[','s','S',']','i','g','n','a','l','|','S','I','G','N','A','L','|','[','v','V',']','a','r','i','a','b','l','e','|','V','A','R','I','A','B','L','E','|','[','s','S',']','u','b','t','y','p','e','|','S','U','B','T','Y','P','E','|','[','t','T',']','y','p','e','|','T','Y','P','E','|','[','r','R',']','e','s','o','l','v','e','d','|','R','E','S','O','L','V','E','D','|','[','b','B',']','o','o','l','e','a','n','|','B','O','O','L','E','A','N','|','[','s','S',']','t','r','i','n','g','|','S','T','R','I','N','G','|','[','i','I',']','n','t','e','g','e','r','|','I','N','T','E','G','E','R','|','[','n','N',']','a','t','u','r','a','l','|','N','A','T','U','R','A','L','|','[','t','T',']','i','m','e','|','T','I','M','E',')','>','\"',':',':',':','S','t','o','r','a','g','e',' ','T','y','p','e',':',':','D','\n',
'	','P','r','e','d','e','f','i','n','e','d',' ','S','u','b','T','y','p','e','s',':','\"','<','(','[','s','S',']','t','d','_','[','l','L',']','o','g','i','c','|','S','T','D','_','L','O','G','I','C','|','[','s','S',']','t','d','_','[','l','L',']','o','g','i','c','_','[','v','V',']','e','c','t','o','r','|','S','T','D','_','L','O','G','I','C','_','V','E','C','T','O','R','|','[','s','S',']','t','d','_','[','u','U',']','[','l','L',']','o','g','i','c','|','S','T','D','_','U','L','O','G','I','C','|','[','s','S',']','t','d','_','[','u','U',']','[','l','L',']','o','g','i','c','_','[','v','V',']','e','c','t','o','r','|','S','T','D','_','U','L','O','G','I','C','_','V','E','C','T','O','R','|','[','b','B',']','i','t','|','B','I','T','|','[','b','B',']','i','t','_','[','v','V',']','e','c','t','o','r','|','B','I','T','_','V','E','C','T','O','R',')','>','\"',':',':',':','S','t','o','r','a','g','e',' ','T','y','p','e',':',':','D','\n',
' ',' ',' ',' ',' ',' ',' ',' ','R','e','s','e','r','v','e','d',' ','W','o','r','d','s','A',':','\"','<','(','[','a','A',']','b','s','|','[','a','A',']','c','c','e','s','s','|','[','a','A',']','f','t','e','r','|','[','a','A',']','l','l','|','[','a','A',']','n','d','|','[','a','A',']','r','c','h','i','t','e','c','t','u','r','e','|','[','a','A',']','r','r','a','y','|','[','a','A',']','s','s','e','r','t','|','[','a','A',']','t','t','r','i','b','u','t','e','|','[','b','B',']','e','g','i','n','|','[','b','B',']','l','o','c','k','|','[','b','B',']','o','d','y','|','[','b','B',']','u','f','f','e','r','|','[','b','B',']','u','s','|','[','c','C',']','a','s','e','|','[','c','C',']','o','m','p','o','n','e','n','t','|','[','c','C',']','o','n','f','i','g','u','r','a','t','i','o','n','|','[','d','D',']','i','s','c','o','n','n','e','c','t','|','[','d','D',']','o','w','n','t','o','|','[','e','E',']','l','s','e','|','[','e','E',']','l','s','i','f','|','[','e','E',']','n','d','|','[','e','E',']','n','t','i','t','y','|','[','e','E',']','r','r','o','r','|','[','e','E',']','x','i','t','|','[','f','F',']','a','i','l','u','r','e','|','[','f','F',']','i','l','e','|','[','f','F',']','o','r','|','[','f','F',']','u','n','c','t','i','o','n','|','[','g','G',']','e','n','e','r','a','t','e','|','[','g','G',']','e','n','e','r','i','c','|','[','g','G',']','u','a','r','d','e','d','|','[','i','I',']','f','|','[','i','I',']','n','|','[','i','I',']','n','o','u','t','|','[','i','I',']','s','|','[','l','L',']','a','b','e','l','|','[','l','L',']','i','b','r','a','r','y','|','[','l','L',']','i','n','k','a','g','e','|','[','l','L',']','o','o','p','|','[','m','M',']','a','p','|','[','m','M',']','o','d','|','[','n','N',']','a','n','d','|','[','n','N',']','e','w','|','[','n','N',']','e','x','t','|','[','n','N',']','o','r','|','[','n','N',']','o','t','|','[','n','N',']','o','t','e','|','[','n','N',']','u','l','l','|','[','o','O',']','f','|','[','o','O',']','n','|','[','o','O',']','p','e','n','|','[','o','O',']','r','|','[','o','O',']','t','h','e','r','s','|','[','o','O',']','u','t','|','[','p','P',']','a','c','k','a','g','e','|','[','p','P',']','o','r','t','|','[','p','P',']','r','o','c','e','d','u','r','e','|','[','p','P',']','r','o','c','e','s','s','|','[','r','R',']','a','n','g','e','|','[','r','R',']','e','c','o','r','d','|','[','r','R',']','e','g','i','s','t','e','r','|','[','r','R',']','e','m','|','[','r','R',']','e','p','o','r','t','|','[','r','R',']','e','t','u','r','n','|','[','s','S',']','e','l','e','c','t','|','[','s','S',']','e','v','e','r','i','t','y','|','[','t','T',']','h','e','n','|','[','t','T',']','o','|','[','t','T',']','r','a','n','s','p','o','r','t','|','[','u','U',']','n','i','t','s','|','[','u','U',']','n','t','i','l','|','[','u','U',']','s','e','|','[','w','W',']','a','i','t','|','[','w','W',']','a','r','n','i','n','g','|','[','w','W',']','h','e','n','|','[','w','W',']','h','i','l','e','|','[','w','W',']','i','t','h','|','[','x','X',']','o','r','|','[','g','G',']','r','o','u','p','|','[','i','I',']','m','p','u','r','e','|','[','i','I',']','n','e','r','t','i','a','l','|','[','l','L',']','i','t','e','r','a','l','|','[','p','P',']','o','s','t','p','o','n','e','d','|','[','p','P',']','u','r','e','|','[','r','R',']','e','j','e','c','t','|','[','r','R',']','o','l','|','[','r','R',']','o','r','|','[','s','S',']','h','a','r','e','d','|','[','s','S',']','l','a','|','[','s','S',']','l','l','|','[','s','S',']','r','a','|','[','s','S',']','r','l','|','[','u','U',']','n','a','f','f','e','c','t','e','d','|','[','x','X',']','n','o','r',')','>','\"',':',':',':','K','e','y','w','o','r','d',':',':','D','\n',
' ',' ',' ',' ',' ',' ',' ',' ','R','e','s','e','r','v','e','d',' ','W','o','r','d','s','B',':','\"','<','(','A','B','S','|','A','C','C','E','S','S','|','A','F','T','E','R','|','A','L','L','|','A','N','D','|','A','R','C','H','I','T','E','C','T','U','R','E','|','A','R','R','A','Y','|','A','S','S','E','R','T','|','A','T','T','R','I','B','U','T','E','|','B','E','G','I','N','|','B','L','O','C','K','|','B','O','D','Y','|','B','U','F','F','E','R','|','B','U','S','|','C','A','S','E','|','C','O','M','P','O','N','E','N','T','|','C','O','N','F','I','G','U','R','A','T','I','O','N','|','D','I','S','C','O','N','N','E','C','T','|','D','O','W','N','T','O','|','E','L','S','E','|','E','L','S','I','F','|','E','N','D','|','E','N','T','I','T','Y','|','E','R','R','O','R','|','E','X','I','T','|','F','A','I','L','U','R','E','|','F','I','L','E','|','F','O','R','|','F','U','N','C','T','I','O','N','|','G','E','N','E','R','A','T','E','|','G','E','N','E','R','I','C','|','G','U','A','R','D','E','D','|','I','F','|','I','N','|','I','N','O','U','T','|','I','S','|','L','A','B','E','L','|','L','I','B','R','A','R','Y','|','L','I','N','K','A','G','E','|','L','O','O','P','|','M','A','P','|','M','O','D','|','N','A','N','D','|','N','E','W','|','N','E','X','T','|','N','O','R','|','N','O','T','|','N','O','T','E','|','N','U','L','L','|','O','F','|','O','N','|','O','P','E','N','|','O','R','|','O','T','H','E','R','S','|','O','U','T','|','P','A','C','K','A','G','E','|','P','O','R','T','|','P','R','O','C','E','D','U','R','E','|','P','R','O','C','E','S','S','|','R','A','N','G','E','|','R','E','C','O','R','D','|','R','E','G','I','S','T','E','R','|','R','E','M','|','R','E','P','O','R','T','|','R','E','T','U','R','N','|','S','E','L','E','C','T','|','S','E','V','E','R','I','T','Y','|','T','H','E','N','|','T','O','|','T','R','A','N','S','P','O','R','T','|','U','N','I','T','S','|','U','N','T','I','L','|','U','S','E','|','W','A','I','T','|','W','A','R','N','I','N','G','|','W','H','E','N','|','W','H','I','L','E','|','W','I','T','H','|','X','O','R','|','G','R','O','U','P','|','I','M','P','U','R','E','|','I','N','E','R','T','I','A','L','|','L','I','T','E','R','A','L','|','P','O','S','T','P','O','N','E','D','|','P','U','R','E','|','R','E','J','E','C','T','|','R','O','L','|','R','O','R','|','S','H','A','R','E','D','|','S','L','A','|','S','L','L','|','S','R','A','|','S','R','L','|','U','N','A','F','F','E','C','T','E','D','|','X','N','O','R',')','>','\"',':',':',':','K','e','y','w','o','r','d',':',':','D','\n',
' ',' ',' ',' ',' ',' ',' ',' ','I','d','e','n','t','i','f','i','e','r','s',':','\"','<','(','[','a','-','z','A','-','Z',']','[','a','-','z','A','-','Z','0','-','9','_',']','*',')','>','\"',':',':',':','I','d','e','n','t','i','f','i','e','r',':',':','D','\n',
' ',' ',' ',' ',' ',' ',' ',' ','F','l','a','g',' ','S','p','e','c','i','a','l',' ','C','o','m','m','e','n','t','s',':','\"','-','-','\\','<','[','^','a','-','z','A','-','Z','0','-','9',']','+','\\','>','\"',':',':',':','F','l','a','g',':','C','o','m','m','e','n','t','s',':','}','\0'};
static char AuxString18[] = {'V','e','r','i','l','o','g',':','1',':','0','{','\n',
' ',' ',' ',' ',' ',' ',' ',' ','C','o','m','m','e','n','t',':',' ','\"','/','\\','*','\"',':','\"','\\','*','/','\"',':',':','C','o','m','m','e','n','t',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','c','p','l','u','s',' ','c','o','m','m','e','n','t',':',' ','\"','/','/','\"',':','\"','$','\"',':',':','C','o','m','m','e','n','t',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','S','t','r','i','n','g',' ','L','i','t','e','r','a','l','s',':',' ','\"','\"','\"','\"',':','\"','\"','\"','\"',':','\"','\\','n','\"',':','S','t','r','i','n','g',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','p','r','e','p','r','o','c','e','s','s','o','r',' ','l','i','n','e',':',' ','\"','^','[',' ',' ',']','*','`','\"',':','\"','$','\"',':',':','P','r','e','p','r','o','c','e','s','s','o','r',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','R','e','s','e','r','v','e','d',' ','W','o','r','d','s','A',':',' ','\"','<','(','m','o','d','u','l','e','|','e','n','d','m','o','d','u','l','e','|','p','a','r','a','m','e','t','e','r','|','s','p','e','c','i','f','y','|','e','n','d','s','p','e','c','i','f','y','|','b','e','g','i','n','|','e','n','d','|','i','n','i','t','i','a','l','|','a','l','w','a','y','s','|','i','f','|','e','l','s','e','|','t','a','s','k','|','e','n','d','t','a','s','k','|','f','o','r','c','e','|','r','e','l','e','a','s','e','|','a','t','t','r','i','b','u','t','e','|','c','a','s','e','|','c','a','s','e','[','x','z',']','|','d','e','f','a','u','l','t','|','e','n','d','a','t','t','r','i','b','u','t','e','|','e','n','d','c','a','s','e','|','e','n','d','f','u','n','c','t','i','o','n','|','e','n','d','p','r','i','m','i','t','i','v','e','|','e','n','d','t','a','b','l','e','|','f','o','r','|','f','o','r','e','v','e','r','|','f','u','n','c','t','i','o','n','|','p','r','i','m','i','t','i','v','e','|','t','a','b','l','e','|','w','h','i','l','e',')','>','\"',':',':',':','K','e','y','w','o','r','d',':',':','D','\n',
' ',' ',' ',' ',' ',' ',' ',' ','P','r','e','d','e','f','i','n','e','d',' ','T','y','p','e','s',':',' ','\"','<','(','a','n','d','|','a','s','s','i','g','n','|','b','u','f','|','b','u','f','i','f','[','0','1',']','|','c','m','o','s','|','d','e','a','s','s','i','g','n','|','d','e','f','p','a','r','a','m','|','d','i','s','a','b','l','e','|','e','d','g','e','|','e','v','e','n','t','|','f','o','r','c','e','|','f','o','r','k','|','h','i','g','h','z','[','0','1',']','|','i','n','i','t','i','a','l','|','i','n','o','u','t','|','i','n','p','u','t','|','i','n','t','e','g','e','r','|','j','o','i','n','|','l','a','r','g','e','|','m','a','c','r','o','m','o','d','u','l','e','|','m','e','d','i','u','m','|','n','a','n','d','|','n','e','g','e','d','g','e','|','n','m','o','s','|','n','o','r','|','n','o','t','|','n','o','t','i','f','[','0','1',']','|','o','r','|','o','u','t','p','u','t','|','p','a','r','a','m','e','t','e','r','|','p','m','o','s','|','p','o','s','e','d','g','e','|','p','u','l','l','u','p','|','r','c','m','o','s','|','r','e','a','l','|','r','e','a','l','t','i','m','e','|','r','e','g','|','r','e','l','e','a','s','e','|','r','e','p','e','a','t','|','r','n','m','o','s','|','r','p','m','o','s','|','r','t','r','a','n','|','r','t','r','a','n','i','f','[','0','1',']','|','s','c','a','l','e','r','e','d','|','s','i','g','n','e','d','|','s','m','a','l','l','|','s','p','e','c','p','a','r','a','m','|','s','t','r','e','n','g','t','h','|','s','t','r','o','n','g','[','0','1',']','|','s','u','p','p','l','y','[','0','1',']','|','t','i','m','e','|','t','r','a','n','|','t','r','a','n','i','f','[','0','1',']','|','t','r','i','[','0','1',']','?','|','t','r','i','a','n','d','|','t','r','i','o','r','|','t','r','i','r','e','g','|','u','n','s','i','g','n','e','d','|','v','e','c','t','o','r','e','d','|','w','a','i','t','|','w','a','n','d','|','w','e','a','k','[','0','1',']','|','w','i','r','e','|','w','o','r','|','x','n','o','r','|','x','o','r',')','>','\"',':',':',':','S','t','o','r','a','g','e',' ','T','y','p','e',':',':','D','\n',
' ',' ',' ',' ',' ',' ',' ',' ','S','y','s','t','e','m',' ','F','u','n','c','t','i','o','n','s',':','\"','<','(','\\','$','[','a','-','z','_',']','+',')','>','\"',':',':',':','S','u','b','r','o','u','t','i','n','e',':',':','D','\n',
' ',' ',' ',' ',' ',' ',' ',' ','N','u','m','e','r','i','c',' ','L','i','t','e','r','a','l','s',':',' ','\"','<','(','[','0','-','9',']','*',''','[','d','D',']','[','0','-','9','x','z','\\','\\','?','_',']','+','|','[','0','-','9',']','*',''','[','h','H',']','[','0','-','9','a','-','f','x','z','\\','\\','?','_',']','+','|','[','0','-','9',']','*',''','[','o','O',']','[','0','-','7','x','z','\\','\\','?','_',']','+','|','[','0','-','9',']','*',''','[','b','B',']','[','0','1','x','z','\\','\\','?','_',']','+','|','[','0','-','9','.',']','+','(','(','e','|','E',')','(','\\','\\','+','|','-',')','?',')','?','[','0','-','9',']','*','|','[','0','-','9',']','+',')','>','\"',':',':',':','N','u','m','e','r','i','c',' ','C','o','n','s','t',':',':','\n',
' ',' ',' ',' ',' ',' ',' ',' ','D','e','l','a','y',' ','w','o','r','d',':',' ','\"','<','(','(','#','\\','(','.','*','\\',')',')','|','(','#','[','0','-','9',']','*',')',')','>','\"',':',':',':','A','d','a',' ','A','t','t','r','i','b','u','t','e','s',':',':','D','\n',
' ',' ',' ',' ',' ',' ',' ',' ','I','d','e','n','t','i','f','i','e','r','s',':',' ','\"','<','(','[','a','-','z','A','-','Z',']','[','a','-','z','A','-','Z','0','-','9','_',']','*',')','>','\"',':',':',':','I','d','e','n','t','i','f','i','e','r',':',':','D','}','\0'};
static char AuxString19[] = {'X',' ','R','e','s','o','u','r','c','e','s',':','1',':','0','{','\n',
'	','P','r','e','p','r','o','c','e','s','s','o','r',':','\"','^','[',' ','\\','t',']','*','#','\"',':','\"','$','\"',':',':','P','r','e','p','r','o','c','e','s','s','o','r',':',':','\n',
'	','P','r','e','p','r','o','c','e','s','s','o','r',' ','W','r','a','p',':','\"','\\','\\','\\','n','\"',':',':',':','P','r','e','p','r','o','c','e','s','s','o','r','1',':','P','r','e','p','r','o','c','e','s','s','o','r',':','\n',
'	','C','o','m','m','e','n','t',':','\"','^','[',' ','\\','t',']','*','!','\"',':','\"','$','\"',':',':','C','o','m','m','e','n','t',':',':','\n',
'	','C','o','m','m','e','n','t',' ','W','r','a','p',':','\"','\\','\\','\\','n','\"',':',':',':','C','o','m','m','e','n','t',':','C','o','m','m','e','n','t',':','\n',
'	','R','e','s','o','u','r','c','e',':','\"','^','[',' ','\\','t',']','*','[','^',':',' ','\t',']','+','[',' ','\\','t',']','*',':','\"',':','\"','$','\"',':',':','P','l','a','i','n',':',':','\n',
'	','R','e','s','o','u','r','c','e',' ','E','s','c',' ','C','h','a','r','s',':','\"','\\','\\','.','\"',':',':',':','T','e','x','t',' ','A','r','g','2',':','R','e','s','o','u','r','c','e',':','\n',
'	','R','e','s','o','u','r','c','e',' ','S','p','a','c','e',' ','W','a','r','n','i','n','g',':','\"','[','^',' ','\\','t',']','+','[',' ','\\','t',']','+','$','\"',':',':',':','F','l','a','g',':','R','e','s','o','u','r','c','e',':','\n',
'	','R','e','s','o','u','r','c','e',' ','N','a','m','e',':','\"','\\','0','\"',':','\"','\"',':',':','S','t','o','r','a','g','e',' ','T','y','p','e',':','R','e','s','o','u','r','c','e',':','C','\n',
'	','R','e','s','o','u','r','c','e',' ','W','r','a','p',':','\"','\\','\\','\\','n','\"',':',':',':','T','e','x','t',' ','A','r','g','1',':','R','e','s','o','u','r','c','e',':','\n',
'	','F','r','e','e',' ','T','e','x','t',':','\"','^','.','*','$','\"',':',':',':','F','l','a','g',':',':','}','\0'};
static char AuxString20[] = {'N','E','d','i','t',' ','M','a','c','r','o',':','1',':','0','{','\n',
'	','C','o','m','m','e','n','t',':','\"','#','\"',':','\"','$','\"',':',':','C','o','m','m','e','n','t',':',':','\n',
'	','B','u','i','l','t','-','i','n',' ','V','a','r','s',':','\"','<','\\','$','(','[','1','-','9',']','|','n','_','a','r','g','s','|','c','u','r','s','o','r','|','f','i','l','e','_','n','a','m','e','|','f','i','l','e','_','p','a','t','h','|','t','e','x','t','_','l','e','n','g','t','h','|','s','e','l','e','c','t','i','o','n','_','s','t','a','r','t','|','s','e','l','e','c','t','i','o','n','_','e','n','d','|','s','e','l','e','c','t','i','o','n','_','l','e','f','t','|','s','e','l','e','c','t','i','o','n','_','r','i','g','h','t','|','w','r','a','p','_','m','a','r','g','i','n','|','t','a','b','_','d','i','s','t','|','e','m','_','t','a','b','_','d','i','s','t','|','u','s','e','_','t','a','b','s','|','l','a','n','g','u','a','g','e','_','m','o','d','e','|','s','t','r','i','n','g','_','d','i','a','l','o','g','_','b','u','t','t','o','n','|','s','e','a','r','c','h','_','e','n','d','|','r','e','a','d','_','s','t','a','t','u','s','|','s','h','e','l','l','_','c','m','d','_','s','t','a','t','u','s',')','>','\"',':',':',':','S','u','b','r','o','u','t','i','n','e','1',':',':','\n',
'	','B','u','i','l','t','-','i','n',' ','S','u','b','r','s',':','\"','<','(','f','o','c','u','s','_','w','i','n','d','o','w','|','s','h','e','l','l','_','c','o','m','m','a','n','d','|','l','e','n','g','t','h','|','g','e','t','_','r','a','n','g','e','|','t','_','p','r','i','n','t','|','d','i','a','l','o','g','|','s','t','r','i','n','g','_','d','i','a','l','o','g','|','r','e','p','l','a','c','e','_','r','a','n','g','e','|','r','e','p','l','a','c','e','_','s','e','l','e','c','t','i','o','n','|','s','e','t','_','c','u','r','s','o','r','_','p','o','s','|','g','e','t','_','c','h','a','r','a','c','t','e','r','|','m','i','n','|','m','a','x','|','s','e','a','r','c','h','|','s','e','a','r','c','h','_','s','t','r','i','n','g','|','s','u','b','s','t','r','i','n','g','|','r','e','p','l','a','c','e','_','s','u','b','s','t','r','i','n','g','|','r','e','a','d','_','f','i','l','e','|','w','r','i','t','e','_','f','i','l','e','|','a','p','p','e','n','d','_','f','i','l','e','|','b','e','e','p','|','g','e','t','_','s','e','l','e','c','t','i','o','n','|','r','e','p','l','a','c','e','_','i','n','_','s','t','r','i','n','g','|','s','e','l','e','c','t','|','s','e','l','e','c','t','_','r','e','c','t','a','n','g','l','e','|','t','o','u','p','p','e','r','|','t','o','l','o','w','e','r','|','s','t','r','i','n','g','_','t','o','_','c','l','i','p','b','o','a','r','d','|','c','l','i','p','b','o','a','r','d','_','t','o','_','s','t','r','i','n','g',')','>','\"',':',':',':','S','u','b','r','o','u','t','i','n','e',':',':','D','\n',
'	','M','e','n','u',' ','A','c','t','i','o','n','s',':','\"','<','(','n','e','w','|','o','p','e','n','|','o','p','e','n','-','d','i','a','l','o','g','|','o','p','e','n','_','d','i','a','l','o','g','|','o','p','e','n','-','s','e','l','e','c','t','e','d','|','o','p','e','n','_','s','e','l','e','c','t','e','d','|','c','l','o','s','e','|','s','a','v','e','|','s','a','v','e','-','a','s','|','s','a','v','e','_','a','s','|','s','a','v','e','-','a','s','-','d','i','a','l','o','g','|','s','a','v','e','_','a','s','_','d','i','a','l','o','g','|','r','e','v','e','r','t','-','t','o','-','s','a','v','e','d','|','r','e','v','e','r','t','_','t','o','_','s','a','v','e','d','|','r','e','v','e','r','t','_','t','o','_','s','a','v','e','d','_','d','i','a','l','o','g','|','i','n','c','l','u','d','e','-','f','i','l','e','|','i','n','c','l','u','d','e','_','f','i','l','e','|','i','n','c','l','u','d','e','-','f','i','l','e','-','d','i','a','l','o','g','|','i','n','c','l','u','d','e','_','f','i','l','e','_','d','i','a','l','o','g','|','l','o','a','d','-','m','a','c','r','o','-','f','i','l','e','|','l','o','a','d','_','m','a','c','r','o','_','f','i','l','e','|','l','o','a','d','-','m','a','c','r','o','-','f','i','l','e','-','d','i','a','l','o','g','|','l','o','a','d','_','m','a','c','r','o','_','f','i','l','e','_','d','i','a','l','o','g','|','l','o','a','d','-','t','a','g','s','-','f','i','l','e','|','l','o','a','d','_','t','a','g','s','_','f','i','l','e','|','l','o','a','d','-','t','a','g','s','-','f','i','l','e','-','d','i','a','l','o','g','|','l','o','a','d','_','t','a','g','s','_','f','i','l','e','_','d','i','a','l','o','g','|','p','r','i','n','t','|','p','r','i','n','t','-','s','e','l','e','c','t','i','o','n','|','p','r','i','n','t','_','s','e','l','e','c','t','i','o','n','|','e','x','i','t','|','u','n','d','o','|','r','e','d','o','|','d','e','l','e','t','e','|','s','e','l','e','c','t','-','a','l','l','|','s','e','l','e','c','t','_','a','l','l','|','s','h','i','f','t','-','l','e','f','t','|','s','h','i','f','t','_','l','e','f','t','|','s','h','i','f','t','-','l','e','f','t','-','b','y','-','t','a','b','|','s','h','i','f','t','_','l','e','f','t','_','b','y','_','t','a','b','|','s','h','i','f','t','-','r','i','g','h','t','|','s','h','i','f','t','_','r','i','g','h','t','|','s','h','i','f','t','-','r','i','g','h','t','-','b','y','-','t','a','b','|','s','h','i','f','t','_','r','i','g','h','t','_','b','y','_','t','a','b','|','f','i','n','d','|','f','i','n','d','-','d','i','a','l','o','g','|','f','i','n','d','_','d','i','a','l','o','g','|','f','i','n','d','-','a','g','a','i','n','|','f','i','n','d','_','a','g','a','i','n','|','f','i','n','d','-','s','e','l','e','c','t','i','o','n','|','f','i','n','d','_','s','e','l','e','c','t','i','o','n','|','r','e','p','l','a','c','e','|','r','e','p','l','a','c','e','-','d','i','a','l','o','g','|','r','e','p','l','a','c','e','_','d','i','a','l','o','g','|','r','e','p','l','a','c','e','-','a','l','l','|','r','e','p','l','a','c','e','_','a','l','l','|','r','e','p','l','a','c','e','-','i','n','-','s','e','l','e','c','t','i','o','n','|','r','e','p','l','a','c','e','_','i','n','_','s','e','l','e','c','t','i','o','n','|','r','e','p','l','a','c','e','-','a','g','a','i','n','|','r','e','p','l','a','c','e','_','a','g','a','i','n','|','g','o','t','o','-','l','i','n','e','-','n','u','m','b','e','r','|','g','o','t','o','_','l','i','n','e','_','n','u','m','b','e','r','|','g','o','t','o','-','l','i','n','e','-','n','u','m','b','e','r','-','d','i','a','l','o','g','|','g','o','t','o','_','l','i','n','e','_','n','u','m','b','e','r','_','d','i','a','l','o','g','|','g','o','t','o','-','s','e','l','e','c','t','e','d','|','g','o','t','o','_','s','e','l','e','c','t','e','d','|','m','a','r','k','|','m','a','r','k','-','d','i','a','l','o','g','|','m','a','r','k','_','d','i','a','l','o','g','|','g','o','t','o','-','m','a','r','k','|','g','o','t','o','_','m','a','r','k','|','g','o','t','o','-','m','a','r','k','-','d','i','a','l','o','g','|','g','o','t','o','_','m','a','r','k','_','d','i','a','l','o','g','|','m','a','t','c','h','|','f','i','n','d','-','d','e','f','i','n','i','t','i','o','n','|','f','i','n','d','_','d','e','f','i','n','i','t','i','o','n','|','s','p','l','i','t','-','w','i','n','d','o','w','|','s','p','l','i','t','_','w','i','n','d','o','w','|','c','l','o','s','e','-','p','a','n','e','|','c','l','o','s','e','_','p','a','n','e','|','u','p','p','e','r','c','a','s','e','|','l','o','w','e','r','c','a','s','e','|','f','i','l','l','-','p','a','r','a','g','r','a','p','h','|','f','i','l','l','_','p','a','r','a','g','r','a','p','h','|','c','o','n','t','r','o','l','-','c','o','d','e','-','d','i','a','l','o','g','|','c','o','n','t','r','o','l','_','c','o','d','e','_','d','i','a','l','o','g','|','f','i','l','t','e','r','-','s','e','l','e','c','t','i','o','n','-','d','i','a','l','o','g','|','f','i','l','t','e','r','_','s','e','l','e','c','t','i','o','n','_','d','i','a','l','o','g','|','f','i','l','t','e','r','-','s','e','l','e','c','t','i','o','n','|','f','i','l','t','e','r','_','s','e','l','e','c','t','i','o','n','|','e','x','e','c','u','t','e','-','c','o','m','m','a','n','d','|','e','x','e','c','u','t','e','_','c','o','m','m','a','n','d','|','e','x','e','c','u','t','e','-','c','o','m','m','a','n','d','-','d','i','a','l','o','g','|','e','x','e','c','u','t','e','_','c','o','m','m','a','n','d','_','d','i','a','l','o','g','|','e','x','e','c','u','t','e','-','c','o','m','m','a','n','d','-','l','i','n','e','|','e','x','e','c','u','t','e','_','c','o','m','m','a','n','d','_','l','i','n','e','|','s','h','e','l','l','-','m','e','n','u','-','c','o','m','m','a','n','d','|','s','h','e','l','l','_','m','e','n','u','_','c','o','m','m','a','n','d','|','m','a','c','r','o','-','m','e','n','u','-','c','o','m','m','a','n','d','|','m','a','c','r','o','_','m','e','n','u','_','c','o','m','m','a','n','d','|','b','g','_','m','e','n','u','_','c','o','m','m','a','n','d','|','p','o','s','t','_','w','i','n','d','o','w','_','b','g','_','m','e','n','u','|','b','e','g','i','n','n','i','n','g','-','o','f','-','s','e','l','e','c','t','i','o','n','|','b','e','g','i','n','n','i','n','g','_','o','f','_','s','e','l','e','c','t','i','o','n','|','e','n','d','-','o','f','-','s','e','l','e','c','t','i','o','n','|','e','n','d','_','o','f','_','s','e','l','e','c','t','i','o','n','|','r','e','p','e','a','t','_','m','a','c','r','o','|','r','e','p','e','a','t','_','d','i','a','l','o','g',')','>','\"',':',':',':','S','u','b','r','o','u','t','i','n','e',':',':','D','\n',
'	','T','e','x','t',' ','A','c','t','i','o','n','s',':','\"','<','(','s','e','l','f','-','i','n','s','e','r','t','|','s','e','l','f','_','i','n','s','e','r','t','|','g','r','a','b','-','f','o','c','u','s','|','g','r','a','b','_','f','o','c','u','s','|','e','x','t','e','n','d','-','a','d','j','u','s','t','|','e','x','t','e','n','d','_','a','d','j','u','s','t','|','e','x','t','e','n','d','-','s','t','a','r','t','|','e','x','t','e','n','d','_','s','t','a','r','t','|','e','x','t','e','n','d','-','e','n','d','|','e','x','t','e','n','d','_','e','n','d','|','s','e','c','o','n','d','a','r','y','-','a','d','j','u','s','t','|','s','e','c','o','n','d','a','r','y','_','a','d','j','u','s','t','|','s','e','c','o','n','d','a','r','y','-','o','r','-','d','r','a','g','-','a','d','j','u','s','t','|','s','e','c','o','n','d','a','r','y','_','o','r','_','d','r','a','g','_','a','d','j','u','s','t','|','s','e','c','o','n','d','a','r','y','-','s','t','a','r','t','|','s','e','c','o','n','d','a','r','y','_','s','t','a','r','t','|','s','e','c','o','n','d','a','r','y','-','o','r','-','d','r','a','g','-','s','t','a','r','t','|','s','e','c','o','n','d','a','r','y','_','o','r','_','d','r','a','g','_','s','t','a','r','t','|','p','r','o','c','e','s','s','-','b','d','r','a','g','|','p','r','o','c','e','s','s','_','b','d','r','a','g','|','m','o','v','e','-','d','e','s','t','i','n','a','t','i','o','n','|','m','o','v','e','_','d','e','s','t','i','n','a','t','i','o','n','|','m','o','v','e','-','t','o','|','m','o','v','e','_','t','o','|','m','o','v','e','-','t','o','-','o','r','-','e','n','d','-','d','r','a','g','|','m','o','v','e','_','t','o','_','o','r','_','e','n','d','_','d','r','a','g','|','e','n','d','_','d','r','a','g','|','c','o','p','y','-','t','o','|','c','o','p','y','_','t','o','|','c','o','p','y','-','t','o','-','o','r','-','e','n','d','-','d','r','a','g','|','c','o','p','y','_','t','o','_','o','r','_','e','n','d','_','d','r','a','g','|','e','x','c','h','a','n','g','e','|','p','r','o','c','e','s','s','-','c','a','n','c','e','l','|','p','r','o','c','e','s','s','_','c','a','n','c','e','l','|','p','a','s','t','e','-','c','l','i','p','b','o','a','r','d','|','p','a','s','t','e','_','c','l','i','p','b','o','a','r','d','|','c','o','p','y','-','c','l','i','p','b','o','a','r','d','|','c','o','p','y','_','c','l','i','p','b','o','a','r','d','|','c','u','t','-','c','l','i','p','b','o','a','r','d','|','c','u','t','_','c','l','i','p','b','o','a','r','d','|','c','o','p','y','-','p','r','i','m','a','r','y','|','c','o','p','y','_','p','r','i','m','a','r','y','|','c','u','t','-','p','r','i','m','a','r','y','|','c','u','t','_','p','r','i','m','a','r','y','|','n','e','w','l','i','n','e','|','n','e','w','l','i','n','e','-','a','n','d','-','i','n','d','e','n','t','|','n','e','w','l','i','n','e','_','a','n','d','_','i','n','d','e','n','t','|','n','e','w','l','i','n','e','-','n','o','-','i','n','d','e','n','t','|','n','e','w','l','i','n','e','_','n','o','_','i','n','d','e','n','t','|','d','e','l','e','t','e','-','s','e','l','e','c','t','i','o','n','|','d','e','l','e','t','e','_','s','e','l','e','c','t','i','o','n','|','d','e','l','e','t','e','-','p','r','e','v','i','o','u','s','-','c','h','a','r','a','c','t','e','r','|','d','e','l','e','t','e','_','p','r','e','v','i','o','u','s','_','c','h','a','r','a','c','t','e','r','|','d','e','l','e','t','e','-','n','e','x','t','-','c','h','a','r','a','c','t','e','r','|','d','e','l','e','t','e','_','n','e','x','t','_','c','h','a','r','a','c','t','e','r','|','d','e','l','e','t','e','-','p','r','e','v','i','o','u','s','-','w','o','r','d','|','d','e','l','e','t','e','_','p','r','e','v','i','o','u','s','_','w','o','r','d','|','d','e','l','e','t','e','-','n','e','x','t','-','w','o','r','d','|','d','e','l','e','t','e','_','n','e','x','t','_','w','o','r','d','|','d','e','l','e','t','e','-','t','o','-','s','t','a','r','t','-','o','f','-','l','i','n','e','|','d','e','l','e','t','e','_','t','o','_','s','t','a','r','t','_','o','f','_','l','i','n','e','|','d','e','l','e','t','e','-','t','o','-','e','n','d','-','o','f','-','l','i','n','e','|','d','e','l','e','t','e','_','t','o','_','e','n','d','_','o','f','_','l','i','n','e','|','f','o','r','w','a','r','d','-','c','h','a','r','a','c','t','e','r','|','f','o','r','w','a','r','d','_','c','h','a','r','a','c','t','e','r','|','b','a','c','k','w','a','r','d','-','c','h','a','r','a','c','t','e','r','|','b','a','c','k','w','a','r','d','_','c','h','a','r','a','c','t','e','r','|','k','e','y','-','s','e','l','e','c','t','|','k','e','y','_','s','e','l','e','c','t','|','p','r','o','c','e','s','s','-','u','p','|','p','r','o','c','e','s','s','_','u','p','|','p','r','o','c','e','s','s','-','d','o','w','n','|','p','r','o','c','e','s','s','_','d','o','w','n','|','p','r','o','c','e','s','s','-','s','h','i','f','t','-','u','p','|','p','r','o','c','e','s','s','_','s','h','i','f','t','_','u','p','|','p','r','o','c','e','s','s','-','s','h','i','f','t','-','d','o','w','n','|','p','r','o','c','e','s','s','_','s','h','i','f','t','_','d','o','w','n','|','p','r','o','c','e','s','s','-','h','o','m','e','|','p','r','o','c','e','s','s','_','h','o','m','e','|','f','o','r','w','a','r','d','-','w','o','r','d','|','f','o','r','w','a','r','d','_','w','o','r','d','|','b','a','c','k','w','a','r','d','-','w','o','r','d','|','b','a','c','k','w','a','r','d','_','w','o','r','d','|','f','o','r','w','a','r','d','-','p','a','r','a','g','r','a','p','h','|','f','o','r','w','a','r','d','_','p','a','r','a','g','r','a','p','h','|','b','a','c','k','w','a','r','d','-','p','a','r','a','g','r','a','p','h','|','b','a','c','k','w','a','r','d','_','p','a','r','a','g','r','a','p','h','|','b','e','g','i','n','n','i','n','g','-','o','f','-','l','i','n','e','|','b','e','g','i','n','n','i','n','g','_','o','f','_','l','i','n','e','|','e','n','d','-','o','f','-','l','i','n','e','|','e','n','d','_','o','f','_','l','i','n','e','|','b','e','g','i','n','n','i','n','g','-','o','f','-','f','i','l','e','|','b','e','g','i','n','n','i','n','g','_','o','f','_','f','i','l','e','|','e','n','d','-','o','f','-','f','i','l','e','|','e','n','d','_','o','f','_','f','i','l','e','|','n','e','x','t','-','p','a','g','e','|','n','e','x','t','_','p','a','g','e','|','p','r','e','v','i','o','u','s','-','p','a','g','e','|','p','r','e','v','i','o','u','s','_','p','a','g','e','|','p','a','g','e','-','l','e','f','t','|','p','a','g','e','_','l','e','f','t','|','p','a','g','e','-','r','i','g','h','t','|','p','a','g','e','_','r','i','g','h','t','|','t','o','g','g','l','e','-','o','v','e','r','s','t','r','i','k','e','|','t','o','g','g','l','e','_','o','v','e','r','s','t','r','i','k','e','|','s','c','r','o','l','l','-','u','p','|','s','c','r','o','l','l','_','u','p','|','s','c','r','o','l','l','-','d','o','w','n','|','s','c','r','o','l','l','_','d','o','w','n','|','s','c','r','o','l','l','-','t','o','-','l','i','n','e','|','s','c','r','o','l','l','_','t','o','_','l','i','n','e','|','s','e','l','e','c','t','-','a','l','l','|','s','e','l','e','c','t','_','a','l','l','|','d','e','s','e','l','e','c','t','-','a','l','l','|','d','e','s','e','l','e','c','t','_','a','l','l','|','f','o','c','u','s','I','n','|','f','o','c','u','s','O','u','t','|','p','r','o','c','e','s','s','-','r','e','t','u','r','n','|','p','r','o','c','e','s','s','_','r','e','t','u','r','n','|','p','r','o','c','e','s','s','-','t','a','b','|','p','r','o','c','e','s','s','_','t','a','b','|','i','n','s','e','r','t','-','s','t','r','i','n','g','|','i','n','s','e','r','t','_','s','t','r','i','n','g','|','m','o','u','s','e','_','p','a','n',')','>','\"',':',':',':','S','u','b','r','o','u','t','i','n','e',':',':','D','\n',
'	','K','e','y','w','o','r','d',':','\"','<','(','w','h','i','l','e','|','i','f','|','e','l','s','e','|','f','o','r','|','b','r','e','a','k','|','c','o','n','t','i','n','u','e','|','r','e','t','u','r','n','|','d','e','f','i','n','e',')','>','\"',':',':',':','K','e','y','w','o','r','d',':',':','D','\n',
'	','B','r','a','c','e','s',':','\"','[','{','}',']','\"',':',':',':','K','e','y','w','o','r','d',':',':','\n',
'	','G','l','o','b','a','l',' ','V','a','r','i','a','b','l','e',':','\"','\\','$','[','A','-','Z','a','-','z','0','-','9','_',']','*','\"',':',':',':','I','d','e','n','t','i','f','i','e','r','1',':',':','\n',
'	','S','t','r','i','n','g',':','\"','\"','\"','\"',':','\"','\"','\"','\"',':','\"','\\','n','\"',':','S','t','r','i','n','g',':',':','\n',
'	','S','t','r','i','n','g',' ','E','s','c','a','p','e',' ','C','h','a','r',':','\"','\\','\\','(','.','|','\\','n',')','\"',':',':',':','S','t','r','i','n','g','1',':','S','t','r','i','n','g',':','\n',
'	','N','u','m','e','r','i','c',' ','C','o','n','s','t',':','\"','<','-','?','[','0','-','9',']','+','>','\"',':',':',':','N','u','m','e','r','i','c',' ','C','o','n','s','t',':',':','}','\0'};

static char *DefaultPatternSets[N_DEFAULT_PATTERN_SETS] = {
    AuxString0,
    AuxString1,
    AuxString2,
    AuxString3,
    AuxString4,
    AuxString5,
    AuxString6,
    AuxString7,
    AuxString8,
    AuxString9,
    AuxString10,
    AuxString11,
    AuxString12,
    AuxString13,
    AuxString14,
    AuxString15,
    AuxString16,
    AuxString17,
    AuxString18,
    AuxString19,
    AuxString20
    };

/*
** Read a string (from the  value of the styles resource) containing highlight
** styles information, parse it, and load it into the stored highlight style
** list (HighlightStyles) for this NEdit session.
*/
int LoadStylesString(char *inString)
{    
    char *errMsg, *fontStr, *inPtr = inString;
    highlightStyleRec *hs;
    int i;

    for (;;) {
   	
	/* skip over blank space */
	inPtr += strspn(inPtr, " \t");

	/* Allocate a language mode structure in which to store the info. */
	hs = (highlightStyleRec *)XtMalloc(sizeof(highlightStyleRec));

	/* read style name */
	hs->name = ReadSymbolicField(&inPtr);
	if (hs->name == NULL)
    	    return styleError(inString,inPtr, "style name required");
	if (!SkipDelimiter(&inPtr, &errMsg)) {
	    XtFree(hs->name);
	    XtFree((char *)hs);
    	    return styleError(inString,inPtr, errMsg);
    	}
    	
    	/* read color */
	hs->color = ReadSymbolicField(&inPtr);
	if (hs->color == NULL) {
	    XtFree(hs->name);
	    XtFree((char *)hs);
    	    return styleError(inString,inPtr, "color name required");
	}
	if (!SkipDelimiter(&inPtr, &errMsg)) {
	    freeHighlightStyleRec(hs);
    	    return styleError(inString,inPtr, errMsg);
    	}
    	
	/* read the font type */
	fontStr = ReadSymbolicField(&inPtr);
	for (i=0; i<N_FONT_TYPES; i++) {
	    if (!strcmp(FontTypeNames[i], fontStr)) {
	    	hs->font = i;
	    	break;
	    }
	}
	if (i == N_FONT_TYPES) {
	    XtFree(fontStr);
	    freeHighlightStyleRec(hs);
	    return styleError(inString, inPtr, "unrecognized font type");
	}
	XtFree(fontStr);

   	/* pattern set was read correctly, add/change it in the list */
   	for (i=0; i<NHighlightStyles; i++) {
	    if (!strcmp(HighlightStyles[i]->name, hs->name)) {
		freeHighlightStyleRec(HighlightStyles[i]);
		HighlightStyles[i] = hs;
		break;
	    }
	}
	if (i == NHighlightStyles) {
	    HighlightStyles[NHighlightStyles++] = hs;
   	    if (NHighlightStyles > MAX_HIGHLIGHT_STYLES)
   		return styleError(inString, inPtr,
   	    		"maximum allowable number of styles exceeded");
	}
	
    	/* if the string ends here, we're done */
   	inPtr += strspn(inPtr, " \t\n");
    	if (*inPtr == '\0')
    	    return True;
    }
}

/*
** Create a string in the correct format for the styles resource, containing
** all of the highlight styles information from the stored highlight style
** list (HighlightStyles) for this NEdit session.
*/
char *WriteStylesString(void)
{
    int i;
    char *outStr;
    textBuffer *outBuf;
    highlightStyleRec *style;
    
    outBuf = BufCreate();
    for (i=0; i<NHighlightStyles; i++) {
    	style = HighlightStyles[i];
    	BufInsert(outBuf, outBuf->length, "\t");
    	BufInsert(outBuf, outBuf->length, style->name);
    	BufInsert(outBuf, outBuf->length, ":");
    	BufInsert(outBuf, outBuf->length, style->color);
    	BufInsert(outBuf, outBuf->length, ":");
    	BufInsert(outBuf, outBuf->length, FontTypeNames[style->font]);
    	BufInsert(outBuf, outBuf->length, "\\n\\\n");
    }
    
    /* Get the output, and lop off the trailing newlines */
    outStr = BufGetRange(outBuf, 0, outBuf->length - (i==1?0:4));
    BufFree(outBuf);
    return outStr;
}

/*
** Read a string representing highlight pattern sets and add them
** to the PatternSets list of loaded highlight patterns.  Note that the
** patterns themselves are not parsed until they are actually used.
*/
int LoadHighlightString(char *inString)
{
    char *inPtr = inString;
    patternSet *patSet;
    int i;
    
    for (;;) {
   	
   	/* Read each pattern set, abort on error */
   	patSet = readPatternSet(&inPtr);
   	if (patSet == NULL)
   	    return False;
   	
	/* Add/change the pattern set in the list */
	for (i=0; i<NPatternSets; i++) {
	    if (!strcmp(PatternSets[i]->languageMode, patSet->languageMode)) {
		freePatternSet(PatternSets[i]);
		PatternSets[i] = patSet;
		break;
	    }
	}
	if (i == NPatternSets) {
	    PatternSets[NPatternSets++] = patSet;
   	    if (NPatternSets > MAX_PATTERN_SETS)
   		return False;
	}
	
    	/* if the string ends here, we're done */
   	inPtr += strspn(inPtr, " \t\n");
    	if (*inPtr == '\0')
    	    return True;
    }
}

/*
** Create a string in the correct format for the highlightPatterns resource,
** containing all of the highlight pattern information from the stored
** highlight pattern list (PatternSets) for this NEdit session.
*/
char *WriteHighlightString(void)
{
    char *outStr, *str, *escapedStr;
    textBuffer *outBuf;
    int psn, written = False;
    patternSet *patSet;
    
    outBuf = BufCreate();
    for (psn=0; psn<NPatternSets; psn++) {
    	patSet = PatternSets[psn];
    	if (patSet->nPatterns == 0)
    	    continue;
    	written = True;
    	BufInsert(outBuf, outBuf->length, patSet->languageMode);
    	BufInsert(outBuf, outBuf->length, ":");
    	if (isDefaultPatternSet(patSet))
    	    BufInsert(outBuf, outBuf->length, "Default\n\t");
    	else {
    	    BufInsert(outBuf, outBuf->length, intToStr(patSet->lineContext));
    	    BufInsert(outBuf, outBuf->length, ":");
    	    BufInsert(outBuf, outBuf->length, intToStr(patSet->charContext));
    	    BufInsert(outBuf, outBuf->length, "{\n");
    	    BufInsert(outBuf, outBuf->length,
    	    	    str = createPatternsString(patSet, "\t\t"));
    	    XtFree(str);
    	    BufInsert(outBuf, outBuf->length, "\t}\n\t");
    	}
    }
    
    /* Get the output string, and lop off the trailing newline and tab */
    outStr = BufGetRange(outBuf, 0, outBuf->length - (written?2:0));
    BufFree(outBuf);
    
    /* Protect newlines and backslashes from translation by the resource
       reader */
    escapedStr = EscapeSensitiveChars(outStr);
    XtFree(outStr);
    return escapedStr;
}

/*
** Find the font (font struct) associated with a named style.
** This routine must only be called with a valid styleName (call
** NamedStyleExists to find out whether styleName is valid).
*/
XFontStruct *FontOfNamedStyle(WindowInfo *window, char *styleName)
{
    int fontNum = HighlightStyles[lookupNamedStyle(styleName)]->font;
    XFontStruct *font;
    
    if (fontNum == BOLD_FONT)
    	font = window->boldFontStruct;
    else if (fontNum == ITALIC_FONT)
    	font = window->italicFontStruct;
    else if (fontNum == BOLD_ITALIC_FONT)
    	font = window->boldItalicFontStruct;
    else /* fontNum == PLAIN_FONT */
    	font = GetDefaultFontStruct(window->fontList);
    
    /* If font isn't loaded, silently substitute primary font */
    return font == NULL ? GetDefaultFontStruct(window->fontList) : font;
}

/*
** Find the color associated with a named style.  This routine must only be
** called with a valid styleName (call NamedStyleExists to find out whether
** styleName is valid).
*/
char *ColorOfNamedStyle(char *styleName)
{
    return HighlightStyles[lookupNamedStyle(styleName)]->color;
}

/*
** Determine whether a named style exists
*/
int NamedStyleExists(char *styleName)
{
    return lookupNamedStyle(styleName) != -1;
}

/*
** Look through the list of pattern sets, and find the one for a particular
** language.  Returns NULL if not found.
*/
patternSet *FindPatternSet(char *langModeName)
{
    int i;
    
    if (langModeName == NULL)
    	return NULL;
	
    for (i=0; i<NPatternSets; i++)
    	if (!strcmp(langModeName, PatternSets[i]->languageMode))
    	    return PatternSets[i];
    return NULL;
    
}

/*
** Returns True if there are highlight patterns, or potential patterns
** not yet committed in the syntax highlighting dialog for a language mode,
*/
int LMHasHighlightPatterns(char *languageMode)
{
    if (FindPatternSet(languageMode) != NULL)
    	return True;
    return HighlightDialog.shell!=NULL && !strcmp(HighlightDialog.langModeName,
    	    languageMode) && HighlightDialog.nPatterns != 0;
}

/*
** Change the language mode name of pattern sets for language "oldName" to
** "newName" in both the stored patterns, and the pattern set currently being
** edited in the dialog.
*/
void RenameHighlightPattern(char *oldName, char *newName)
{
    int i;
    
    for (i=0; i<NPatternSets; i++) {
    	if (!strcmp(oldName, PatternSets[i]->languageMode)) {
    	    XtFree(PatternSets[i]->languageMode);
    	    PatternSets[i]->languageMode = CopyAllocatedString(newName);
    	}
    }
    if (HighlightDialog.shell != NULL) {
    	if (!strcmp(HighlightDialog.langModeName, oldName)) {
    	    XtFree(HighlightDialog.langModeName);
    	    HighlightDialog.langModeName = CopyAllocatedString(newName);
    	}
    }
}

/*
** Create a pulldown menu pane with the names of the current highlight styles.
** XmNuserData for each item contains a pointer to the name.
*/
static Widget createHighlightStylesMenu(Widget parent)
{
    Widget menu;
    int i;
    XmString s1;

    menu = XmCreatePulldownMenu(parent, "highlightStyles", NULL, 0);
    for (i=0; i<NHighlightStyles; i++) {
        XtVaCreateManagedWidget("highlightStyles", xmPushButtonWidgetClass,menu,
    	      XmNlabelString, s1=XmStringCreateSimple(HighlightStyles[i]->name),
    	      XmNuserData, (void *)HighlightStyles[i]->name, 0);
        XmStringFree(s1);
    }
    return menu;
}

static char *createPatternsString(patternSet *patSet, char *indentStr)
{
    char *outStr, *str;
    textBuffer *outBuf;
    int pn;
    highlightPattern *pat;
    
    outBuf = BufCreate();
    for (pn=0; pn<patSet->nPatterns; pn++) {
    	pat = &patSet->patterns[pn];
    	BufInsert(outBuf, outBuf->length, indentStr);
    	BufInsert(outBuf, outBuf->length, pat->name);
    	BufInsert(outBuf, outBuf->length, ":");
    	if (pat->startRE != NULL) {
    	    BufInsert(outBuf, outBuf->length,
    	    	    str=MakeQuotedString(pat->startRE));
    	    XtFree(str);
    	}
    	BufInsert(outBuf, outBuf->length, ":");
    	if (pat->endRE != NULL) {
    	    BufInsert(outBuf, outBuf->length, str=MakeQuotedString(pat->endRE));
    	    XtFree(str);
    	}
    	BufInsert(outBuf, outBuf->length, ":");
    	if (pat->errorRE != NULL) {
    	    BufInsert(outBuf, outBuf->length,
    	    	    str=MakeQuotedString(pat->errorRE));
    	    XtFree(str);
    	}
    	BufInsert(outBuf, outBuf->length, ":");
    	BufInsert(outBuf, outBuf->length, pat->style);
    	BufInsert(outBuf, outBuf->length, ":");
    	if (pat->subPatternOf != NULL)
    	    BufInsert(outBuf, outBuf->length, pat->subPatternOf);
    	BufInsert(outBuf, outBuf->length, ":");
    	if (pat->flags & DEFER_PARSING)
    	    BufInsert(outBuf, outBuf->length, "D");
    	if (pat->flags & PARSE_SUBPATS_FROM_START)
    	    BufInsert(outBuf, outBuf->length, "R");
    	if (pat->flags & COLOR_ONLY)
    	    BufInsert(outBuf, outBuf->length, "C");
    	BufInsert(outBuf, outBuf->length, "\n");
    }
    outStr = BufGetAll(outBuf);
    BufFree(outBuf);
    return outStr;
}

/*
** Read in a pattern set character string, and advance *inPtr beyond it.
** Returns NULL and outputs an error to stderr on failure.
*/
static patternSet *readPatternSet(char **inPtr)
{
    char *errMsg, *stringStart = *inPtr;
    patternSet patSet, *retPatSet;

    /* remove leading whitespace */
    *inPtr += strspn(*inPtr, " \t\n");

    /* read language mode field */
    patSet.languageMode = ReadSymbolicField(inPtr);
    if (patSet.languageMode == NULL)
    	return highlightError(stringStart, *inPtr,
    	    	"language mode must be specified");
    if (!SkipDelimiter(inPtr, &errMsg))
    	return highlightError(stringStart, *inPtr, errMsg);

    /* look for "Default" keyword, and if it's there, return the default
       pattern set */
    if (!strncmp(*inPtr, "Default", 7)) {
    	*inPtr += 7;
    	retPatSet = readDefaultPatternSet(patSet.languageMode);
    	XtFree(patSet.languageMode);
    	if (retPatSet == NULL)
    	    return highlightError(stringStart, *inPtr,
    	    	    "No default pattern set");
    	return retPatSet;
    }
    	
    /* read line context field */
    if (!ReadNumericField(inPtr, &patSet.lineContext))
	return highlightError(stringStart, *inPtr,
	    	"unreadable line context field");
    if (!SkipDelimiter(inPtr, &errMsg))
    	return highlightError(stringStart, *inPtr, errMsg);

    /* read character context field */
    if (!ReadNumericField(inPtr, &patSet.charContext))
	return highlightError(stringStart, *inPtr,
	    	"unreadable character context field");

    /* read pattern list */
    patSet.patterns = readHighlightPatterns(inPtr,
   	    True, &errMsg, &patSet.nPatterns);
    if (patSet.patterns == NULL)
	return highlightError(stringStart, *inPtr, errMsg);

    /* pattern set was read correctly, make an allocated copy and return */
    retPatSet = (patternSet *)XtMalloc(sizeof(patternSet));
    memcpy(retPatSet, &patSet, sizeof(patternSet));
    return retPatSet;
}

/*
** Parse a set of highlight patterns into an array of highlightPattern
** structures, and a language mode name.  If unsuccessful, returns NULL with
** (statically allocated) message in "errMsg".
*/
static highlightPattern *readHighlightPatterns(char **inPtr, int withBraces,
    	char **errMsg, int *nPatterns)
{    
    highlightPattern *pat, *returnedList, patternList[MAX_PATTERNS];
   
    /* skip over blank space */
    *inPtr += strspn(*inPtr, " \t\n");
    
    /* look for initial brace */
    if (withBraces) {
	if (**inPtr != '{') {
    	    *errMsg = "pattern list must begin with \"{\"";
    	    return False;
	}
	(*inPtr)++;
    }
    
    /*
    ** parse each pattern in the list
    */
    pat = patternList;
    while (True) {
    	*inPtr += strspn(*inPtr, " \t\n");
    	if (**inPtr == '\0') {
    	    if (withBraces) {
    		*errMsg = "end of pattern list not found";
    		return NULL;
    	    } else
    	    	break;
	} else if (**inPtr == '}') {
	    (*inPtr)++;
    	    break;
    	}
    	if (!readHighlightPattern(inPtr, errMsg, pat++))
    	    return NULL;
    	if (pat - patternList > MAX_PATTERNS) {
    	    *errMsg = "max number of patterns exceeded\n";
    	    return NULL;
    	}
    }
    
    /* allocate a more appropriately sized list to return patterns */
    *nPatterns = pat - patternList;
    returnedList = (highlightPattern *)XtMalloc(
    	    sizeof(highlightPattern) * *nPatterns);
    memcpy(returnedList, patternList, sizeof(highlightPattern) * *nPatterns);
    return returnedList;
}

static int readHighlightPattern(char **inPtr, char **errMsg,
    	highlightPattern *pattern)
{
    /* read the name field */
    pattern->name = ReadSymbolicField(inPtr);
    if (pattern->name == NULL) {
    	*errMsg = "pattern name is required";
    	return False;
    }
    if (!SkipDelimiter(inPtr, errMsg))
    	return False;
    
    /* read the start pattern */
    if (!ReadQuotedString(inPtr, errMsg, &pattern->startRE))
    	return False;
    if (!SkipDelimiter(inPtr, errMsg))
    	return False;
    
    /* read the end pattern */
    if (**inPtr == ':')
    	pattern->endRE = NULL;
    else if (!ReadQuotedString(inPtr, errMsg, &pattern->endRE))
    	return False;
    if (!SkipDelimiter(inPtr, errMsg))
    	return False;
    
    /* read the error pattern */
    if (**inPtr == ':')
    	pattern->errorRE = NULL;
    else if (!ReadQuotedString(inPtr, errMsg, &pattern->errorRE))
    	return False;
    if (!SkipDelimiter(inPtr, errMsg))
    	return False;
    
    /* read the style field */
    pattern->style = ReadSymbolicField(inPtr);
    if (pattern->style == NULL) {
    	*errMsg = "style field required in pattern";
    	return False;
    }
    if (!SkipDelimiter(inPtr, errMsg))
    	return False;
    
    /* read the sub-pattern-of field */
    pattern->subPatternOf = ReadSymbolicField(inPtr);
    if (!SkipDelimiter(inPtr, errMsg))
    	return False;
    	
    /* read flags field */
    pattern->flags = 0;
    for (; **inPtr != '\n' && **inPtr != '}'; (*inPtr)++) {
	if (**inPtr == 'D')
	    pattern->flags |= DEFER_PARSING;
	else if (**inPtr == 'R')
	    pattern->flags |= PARSE_SUBPATS_FROM_START;
	else if (**inPtr == 'C')
	    pattern->flags |= COLOR_ONLY;
	else if (**inPtr != ' ' && **inPtr != '\t') {
	    *errMsg = "unreadable flag field";
	    return False;
	}
    }
    return True;
}

/*
** Given a language mode name, determine if there is a default (built-in)
** pattern set available for that language mode, and if so, read it and
** return a new allocated copy of it.  The returned pattern set should be
** freed by the caller with freePatternSet()
*/
static patternSet *readDefaultPatternSet(char *langModeName)
{
    int i, modeNameLen;
    char *strPtr;
    
    modeNameLen = strlen(langModeName);
    for (i=0; i<N_DEFAULT_PATTERN_SETS; i++) {
    	if (!strncmp(langModeName, DefaultPatternSets[i], modeNameLen) &&
    	    	DefaultPatternSets[i][modeNameLen] == ':') {
    	    strPtr = DefaultPatternSets[i];
    	    return readPatternSet(&strPtr);
    	}
    }
    return NULL;
}

/*
** Return True if patSet exactly matches one of the default pattern sets
*/
static int isDefaultPatternSet(patternSet *patSet)
{
    patternSet *defaultPatSet;
    int retVal;
    
    defaultPatSet = readDefaultPatternSet(patSet->languageMode);
    if (defaultPatSet == NULL)
    	return False;
    retVal = !patternSetsDiffer(patSet, defaultPatSet);
    freePatternSet(defaultPatSet);
    return retVal;
}

/*
** Short-hand functions for formating and outputing errors for
*/
static patternSet *highlightError(char *stringStart, char *stoppedAt,
    	char *message)
{
    ParseError(NULL, stringStart, stoppedAt, "highlight pattern", message);
    return NULL;
}
static int styleError(char *stringStart, char *stoppedAt, char *message)
{
    ParseError(NULL, stringStart, stoppedAt, "style specification", message);
    return False;
}

/*
** Present a dialog for editing highlight style information
*/
void EditHighlightStyles(Widget parent, char *initialStyle)
{
#define HS_LIST_RIGHT 60
#define HS_LEFT_MARGIN_POS 1
#define HS_RIGHT_MARGIN_POS 99
#define HS_H_MARGIN 10
    Widget form, nameLbl, topLbl, colorLbl, fontLbl;
    Widget fontBox, sep1, okBtn, applyBtn, dismissBtn;
    XmString s1;
    int i, ac;
    Arg args[20];

    /* if the dialog is already displayed, just pop it to the top and return */
    if (HSDialog.shell != NULL) {
	if (initialStyle != NULL)
	    setStyleByName(initialStyle);
    	RaiseShellWindow(HSDialog.shell);
    	return;
    }
    
    /* Copy the list of highlight style information to one that the user
       can freely edit (via the dialog and managed-list code) */
    HSDialog.highlightStyleList = (highlightStyleRec **)XtMalloc(
    	    sizeof(highlightStyleRec *) * MAX_HIGHLIGHT_STYLES);
    for (i=0; i<NHighlightStyles; i++)
    	HSDialog.highlightStyleList[i] =
    	copyHighlightStyleRec(HighlightStyles[i]);
    HSDialog.nHighlightStyles = NHighlightStyles;
    
    /* Create a form widget in an application shell */
    ac = 0;
    XtSetArg(args[ac], XmNdeleteResponse, XmDO_NOTHING); ac++;
    XtSetArg(args[ac], XmNiconName, "Highlight Styles"); ac++;
    XtSetArg(args[ac], XmNtitle, "Highlight Styles"); ac++;
    HSDialog.shell = XtAppCreateShell(APP_NAME, APP_CLASS,
	    applicationShellWidgetClass, TheDisplay, args, ac);
    AddSmallIcon(HSDialog.shell);
    form = XtVaCreateManagedWidget("editHighlightStyles", xmFormWidgetClass,
	    HSDialog.shell, XmNautoUnmanage, False,
	    XmNresizePolicy, XmRESIZE_NONE, 0);
    XtAddCallback(form, XmNdestroyCallback, hsDestroyCB, NULL);
    AddMotifCloseCallback(HSDialog.shell, hsDismissCB, NULL);
        
    topLbl = XtVaCreateManagedWidget("topLabel", xmLabelGadgetClass, form,
    	    XmNlabelString, s1=MKSTRING(
"To modify the properties of an existing highlight style, select the name\n\
from the list on the left.  Select \"New\" to add a new style to the list."),
	    XmNmnemonic, 'N',
	    XmNtopAttachment, XmATTACH_POSITION,
	    XmNtopPosition, 2,
	    XmNleftAttachment, XmATTACH_POSITION,
	    XmNleftPosition, HS_LEFT_MARGIN_POS,
	    XmNrightAttachment, XmATTACH_POSITION,
	    XmNrightPosition, HS_RIGHT_MARGIN_POS, 0);
    XmStringFree(s1);
    
    nameLbl = XtVaCreateManagedWidget("nameLbl", xmLabelGadgetClass, form,
    	    XmNlabelString, s1=XmStringCreateSimple("Name"),
    	    XmNmnemonic, 'm',
    	    XmNalignment, XmALIGNMENT_BEGINNING,
	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, HS_LIST_RIGHT,
	    XmNtopAttachment, XmATTACH_WIDGET,
	    XmNtopOffset, HS_H_MARGIN,
	    XmNtopWidget, topLbl, 0);
    XmStringFree(s1);
 
    HSDialog.nameW = XtVaCreateManagedWidget("name", xmTextWidgetClass, form,
	    XmNleftAttachment, XmATTACH_POSITION,
	    XmNleftPosition, HS_LIST_RIGHT,
	    XmNtopAttachment, XmATTACH_WIDGET,
	    XmNtopWidget, nameLbl,
	    XmNrightAttachment, XmATTACH_POSITION,
	    XmNrightPosition, HS_RIGHT_MARGIN_POS, 0);
    RemapDeleteKey(HSDialog.nameW);
    XtVaSetValues(nameLbl, XmNuserData, HSDialog.nameW, 0);
    
    colorLbl = XtVaCreateManagedWidget("colorLbl", xmLabelGadgetClass, form,
    	    XmNlabelString, s1=XmStringCreateSimple("Color"),
    	    XmNmnemonic, 'C',
    	    XmNalignment, XmALIGNMENT_BEGINNING,
	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, HS_LIST_RIGHT,
	    XmNtopAttachment, XmATTACH_WIDGET,
	    XmNtopOffset, HS_H_MARGIN,
	    XmNtopWidget, HSDialog.nameW, 0);
    XmStringFree(s1);
 
    HSDialog.colorW = XtVaCreateManagedWidget("color", xmTextWidgetClass, form,
	    XmNleftAttachment, XmATTACH_POSITION,
	    XmNleftPosition, HS_LIST_RIGHT,
	    XmNtopAttachment, XmATTACH_WIDGET,
	    XmNtopWidget, colorLbl,
	    XmNrightAttachment, XmATTACH_POSITION,
	    XmNrightPosition, HS_RIGHT_MARGIN_POS, 0);
    RemapDeleteKey(HSDialog.colorW);
    XtVaSetValues(colorLbl, XmNuserData, HSDialog.colorW, 0);
    
    fontLbl = XtVaCreateManagedWidget("fontLbl", xmLabelGadgetClass, form,
    	    XmNlabelString, s1=XmStringCreateSimple("Font"),
    	    XmNalignment, XmALIGNMENT_BEGINNING,
	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, HS_LIST_RIGHT,
	    XmNtopAttachment, XmATTACH_WIDGET,
	    XmNtopOffset, HS_H_MARGIN,
	    XmNtopWidget, HSDialog.colorW, 0);
    XmStringFree(s1);

    fontBox = XtVaCreateManagedWidget("fontBox", xmRowColumnWidgetClass, form,
    	    XmNpacking, XmPACK_COLUMN,
    	    XmNnumColumns, 2,
    	    XmNradioBehavior, True,
	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, HS_LIST_RIGHT,
	    XmNtopAttachment, XmATTACH_WIDGET,
	    XmNtopWidget, fontLbl, 0);
    HSDialog.plainW = XtVaCreateManagedWidget("plain", 
    	    xmToggleButtonWidgetClass, fontBox,
    	    XmNset, True,
    	    XmNlabelString, s1=XmStringCreateSimple("Plain"),
    	    XmNmnemonic, 'P', 0);
    XmStringFree(s1);
    HSDialog.boldW = XtVaCreateManagedWidget("bold", 
    	    xmToggleButtonWidgetClass, fontBox,
    	    XmNlabelString, s1=XmStringCreateSimple("Bold"),
    	    XmNmnemonic, 'B', 0);
    XmStringFree(s1);
    HSDialog.italicW = XtVaCreateManagedWidget("italic", 
    	    xmToggleButtonWidgetClass, fontBox,
    	    XmNlabelString, s1=XmStringCreateSimple("Italic"),
    	    XmNmnemonic, 'I', 0);
    XmStringFree(s1);
    HSDialog.boldItalicW = XtVaCreateManagedWidget("boldItalic", 
    	    xmToggleButtonWidgetClass, fontBox,
    	    XmNlabelString, s1=XmStringCreateSimple("Bold Italic"),
    	    XmNmnemonic, 'o', 0);
    XmStringFree(s1);
    	    
    okBtn = XtVaCreateManagedWidget("ok",xmPushButtonWidgetClass,form,
    	    XmNlabelString, s1=XmStringCreateSimple("OK"),
    	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 10,
    	    XmNrightAttachment, XmATTACH_POSITION,
    	    XmNrightPosition, 30,
    	    XmNbottomAttachment, XmATTACH_POSITION,
    	    XmNbottomPosition, 99, 0);
    XtAddCallback(okBtn, XmNactivateCallback, hsOkCB, NULL);
    XmStringFree(s1);

    applyBtn = XtVaCreateManagedWidget("apply",xmPushButtonWidgetClass,form,
    	    XmNlabelString, s1=XmStringCreateSimple("Apply"),
    	    XmNmnemonic, 'A',
    	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 40,
    	    XmNrightAttachment, XmATTACH_POSITION,
    	    XmNrightPosition, 60,
    	    XmNbottomAttachment, XmATTACH_POSITION,
    	    XmNbottomPosition, 99, 0);
    XtAddCallback(applyBtn, XmNactivateCallback, hsApplyCB, NULL);
    XmStringFree(s1);

    dismissBtn = XtVaCreateManagedWidget("dismiss",xmPushButtonWidgetClass,form,
    	    XmNlabelString, s1=XmStringCreateSimple("Dismiss"),
    	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 70,
    	    XmNrightAttachment, XmATTACH_POSITION,
    	    XmNrightPosition, 90,
    	    XmNbottomAttachment, XmATTACH_POSITION,
    	    XmNbottomPosition, 99, 0);
    XtAddCallback(dismissBtn, XmNactivateCallback, hsDismissCB, NULL);
    XmStringFree(s1);
    
    sep1 = XtVaCreateManagedWidget("sep1", xmSeparatorGadgetClass, form,
	    XmNleftAttachment, XmATTACH_FORM,
	    XmNtopAttachment, XmATTACH_WIDGET,
	    XmNtopWidget, fontBox,
	    XmNtopOffset, HS_H_MARGIN,
 	    XmNrightAttachment, XmATTACH_FORM,
	    XmNbottomAttachment, XmATTACH_WIDGET,
    	    XmNbottomWidget, dismissBtn, 0,
	    XmNbottomOffset, HS_H_MARGIN, 0);
    
    ac = 0;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_WIDGET); ac++;
    XtSetArg(args[ac], XmNtopOffset, HS_H_MARGIN); ac++;
    XtSetArg(args[ac], XmNtopWidget, topLbl); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(args[ac], XmNleftPosition, HS_LEFT_MARGIN_POS); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_POSITION); ac++;
    XtSetArg(args[ac], XmNrightPosition, HS_LIST_RIGHT-1); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_WIDGET); ac++;
    XtSetArg(args[ac], XmNbottomWidget, sep1); ac++;
    XtSetArg(args[ac], XmNbottomOffset, HS_H_MARGIN); ac++;
    HSDialog.managedListW = CreateManagedList(form, "list", args, ac,
    	    (void **)HSDialog.highlightStyleList, &HSDialog.nHighlightStyles,
    	    MAX_HIGHLIGHT_STYLES, 20, hsGetDisplayedCB, NULL, hsSetDisplayedCB,
    	    NULL, hsFreeItemCB);
    XtVaSetValues(topLbl, XmNuserData, HSDialog.managedListW, 0);
 
    /* Set initial default button */
    XtVaSetValues(form, XmNdefaultButton, okBtn, 0);
    XtVaSetValues(form, XmNcancelButton, dismissBtn, 0);
    
    /* If there's a suggestion for an initial selection, make it */
    if (initialStyle != NULL)
	setStyleByName(initialStyle);
    
    /* Handle mnemonic selection of buttons and focus to dialog */
    AddDialogMnemonicHandler(form);
    
    /* Realize all of the widgets in the new dialog */
    XtRealizeWidget(HSDialog.shell);
}

static void hsDestroyCB(Widget w, XtPointer clientData, XtPointer callData)
{
    int i;
    
    for (i=0; i<HSDialog.nHighlightStyles; i++)
    	freeHighlightStyleRec(HSDialog.highlightStyleList[i]);
    XtFree((char *)HSDialog.highlightStyleList);
}

static void hsOkCB(Widget w, XtPointer clientData, XtPointer callData)
{
    if (!updateHSList())
    	return;

    /* pop down and destroy the dialog */
    XtDestroyWidget(HSDialog.shell);
    HSDialog.shell = NULL;
}

static void hsApplyCB(Widget w, XtPointer clientData, XtPointer callData)
{
    updateHSList();
}

static void hsDismissCB(Widget w, XtPointer clientData, XtPointer callData)
{
    /* pop down and destroy the dialog */
    XtDestroyWidget(HSDialog.shell);
    HSDialog.shell = NULL;
}

static void *hsGetDisplayedCB(void *oldItem, int explicitRequest, int *abort,
    	void *cbArg)
{
    highlightStyleRec *hs;
    
    /* If the dialog is currently displaying the "new" entry and the
       fields are empty, that's just fine */
    if (oldItem == NULL && hsDialogEmpty())
    	return NULL;
    
    /* If there are no problems reading the data, just return it */
    hs = readHSDialogFields(True);
    if (hs != NULL)
    	return (void *)hs;
    
    /* If there are problems, and the user didn't ask for the fields to be
       read, give more warning */
    if (!explicitRequest) {
	if (DialogF(DF_WARN, HSDialog.shell, 2,
    		"Discard incomplete entry\nfor current highlight style?",
    		"Keep",
    		"Discard") == 2) {
     	    return oldItem == NULL ? NULL :
     	    	    (void *)copyHighlightStyleRec((highlightStyleRec *)oldItem);
	}
    }

    /* Do readHSDialogFields again without "silent" mode to display warning */
    hs = readHSDialogFields(False);
    *abort = True;
    return NULL;
}

static void hsSetDisplayedCB(void *item, void *cbArg)
{
    highlightStyleRec *hs = (highlightStyleRec *)item;

    if (item == NULL) {
    	XmTextSetString(HSDialog.nameW, "");
    	XmTextSetString(HSDialog.colorW, "");
    	XmToggleButtonSetState(HSDialog.plainW, True, False);
    	XmToggleButtonSetState(HSDialog.boldW, False, False);
    	XmToggleButtonSetState(HSDialog.italicW, False, False);
    	XmToggleButtonSetState(HSDialog.boldItalicW, False, False);
    } else {
    	XmTextSetString(HSDialog.nameW, hs->name);
    	XmTextSetString(HSDialog.colorW, hs->color);
    	XmToggleButtonSetState(HSDialog.plainW, hs->font==PLAIN_FONT, False);
    	XmToggleButtonSetState(HSDialog.boldW, hs->font==BOLD_FONT, False);
    	XmToggleButtonSetState(HSDialog.italicW, hs->font==ITALIC_FONT, False);
    	XmToggleButtonSetState(HSDialog.boldItalicW, hs->font==BOLD_ITALIC_FONT,
    	        False);
    }
}

static void hsFreeItemCB(void *item)
{
    freeHighlightStyleRec((highlightStyleRec *)item);
}

static highlightStyleRec *readHSDialogFields(int silent)
{
    highlightStyleRec *hs;
    Display *display = XtDisplay(HSDialog.shell);
    int screenNum = XScreenNumberOfScreen(XtScreen(HSDialog.shell));
    XColor rgb;

    /* Allocate a language mode structure to return */
    hs = (highlightStyleRec *)XtMalloc(sizeof(highlightStyleRec));

    /* read the name field */
    hs->name = ReadSymbolicFieldTextWidget(HSDialog.nameW,
    	    "highlight style name", silent);
    if (hs->name == NULL) {
    	XtFree((char *)hs);
    	return NULL;
    }
    if (*hs->name == '\0') {
    	if (!silent) {
    	    DialogF(DF_WARN, HSDialog.shell, 1,
    		   "Please specify a name\nfor the highlight style", "Dismiss");
    	    XmProcessTraversal(HSDialog.nameW, XmTRAVERSE_CURRENT);
    	}
    	XtFree(hs->name);
    	XtFree((char *)hs);
   	return NULL;
    }

    /* read the color field */
    hs->color = ReadSymbolicFieldTextWidget(HSDialog.colorW, "color", silent);
    if (hs->color == NULL) {
    	XtFree(hs->name);
    	XtFree((char *)hs);
    	return NULL;
    }
    if (*hs->color == '\0') {
    	if (!silent) {
    	    DialogF(DF_WARN, HSDialog.shell, 1,
    		   "Please specify a color\nfor the highlight style",
    		   "Dismiss");
    	    XmProcessTraversal(HSDialog.colorW, XmTRAVERSE_CURRENT);
    	}
    	XtFree(hs->name);
    	XtFree(hs->color);
    	XtFree((char *)hs);
   	return NULL;
    }

    /* Verify that the color is a valid X color spec */
    if (!XParseColor(display, DefaultColormap(display, screenNum), 
	    hs->color, &rgb)) {
	if (!silent) {
	    DialogF(DF_WARN, HSDialog.shell, 1,
		  "Invalid X color specification: %s\n",  "Dismiss", hs->color);
    	    XmProcessTraversal(HSDialog.colorW, XmTRAVERSE_CURRENT);
    	}
    	XtFree(hs->name);
    	XtFree(hs->color);
    	XtFree((char *)hs);
	return NULL;;
    }
    
    /* read the font buttons */
    if (XmToggleButtonGetState(HSDialog.boldW))
    	hs->font = BOLD_FONT;
    else if (XmToggleButtonGetState(HSDialog.italicW))
    	hs->font = ITALIC_FONT;
    else if (XmToggleButtonGetState(HSDialog.boldItalicW))
    	hs->font = BOLD_ITALIC_FONT;
    else
    	hs->font = PLAIN_FONT;

    return hs;
}

/*
** Copy a highlightStyleRec data structure, and all of the allocated memory
** it contains.
*/
static highlightStyleRec *copyHighlightStyleRec(highlightStyleRec *hs)
{
    highlightStyleRec *newHS;
    
    newHS = (highlightStyleRec *)XtMalloc(sizeof(highlightStyleRec));
    newHS->name = XtMalloc(strlen(hs->name)+1);
    strcpy(newHS->name, hs->name);
    if (hs->color == NULL)
    	newHS->color = NULL;
    else {
	newHS->color = XtMalloc(strlen(hs->color)+1);
	strcpy(newHS->color, hs->color);
    }
    newHS->font = hs->font;
    return newHS;
}

/*
** Free all of the allocated data in a highlightStyleRec, including the
** structure itself.
*/
static void freeHighlightStyleRec(highlightStyleRec *hs)
{
    XtFree(hs->name);
    if (hs->color != NULL)
    	XtFree(hs->color);
    XtFree((char *)hs);
}

/*
** Select a particular style in the highlight styles dialog
*/
static void setStyleByName(char *style)
{
    int i;
    
    for (i=0; i<HSDialog.nHighlightStyles; i++) {
    	if (!strcmp(HSDialog.highlightStyleList[i]->name, style)) {
    	    SelectManagedListItem(HSDialog.managedListW, i);
    	    break;
    	}
    }
}

/*
** Return True if the fields of the highlight styles dialog are consistent
** with a blank "New" style in the dialog.
*/
static int hsDialogEmpty(void)
{
    return TextWidgetIsBlank(HSDialog.nameW) &&
 	    TextWidgetIsBlank(HSDialog.colorW) &&
	    XmToggleButtonGetState(HSDialog.plainW);
}   	

/*
** Apply the changes made in the highlight styles dialog to the stored
** highlight style information in HighlightStyles
*/
static int updateHSList(void)
{
    WindowInfo *window;
    int i;
    
    /* Get the current contents of the dialog fields */
    if (!UpdateManagedList(HSDialog.managedListW, True))
    	return False;
    
    /* Replace the old highlight styles list with the new one from the dialog */
    for (i=0; i<NHighlightStyles; i++)
    	freeHighlightStyleRec(HighlightStyles[i]);
    for (i=0; i<HSDialog.nHighlightStyles; i++)
    	HighlightStyles[i] =
    	    	copyHighlightStyleRec(HSDialog.highlightStyleList[i]);
    NHighlightStyles = HSDialog.nHighlightStyles;
    
    /* If a syntax highlighting dialog is up, update its menu */
    updateHighlightStyleMenu();
    
    /* Redisplay highlighted windows which use changed style(s) */
    for (window=WindowList; window!=NULL; window=window->next)
    	UpdateHighlightStyles(window);
    
    /* Note that preferences have been changed */
    MarkPrefsChanged();

    return True;
}

/*
** Present a dialog for editing highlight pattern information
*/
void EditHighlightPatterns(WindowInfo *window)
{
#define BORDER 4
#define LIST_RIGHT 41
    Widget form, lmOptMenu, lmLbl, patternsForm, patternsFrame, patternsLbl;
    Widget lmForm, contextFrame, contextForm, contextLbl, styleLbl, styleBtn;
    Widget okBtn, applyBtn, checkBtn, deleteBtn, dismissBtn, helpBtn;
    Widget restoreBtn, nameLbl, typeLbl, typeBox, lmBtn, matchBox;
    patternSet *patSet;
    XmString s1;
    int i, n, nPatterns;
    Arg args[20];

    /* if the dialog is already displayed, just pop it to the top and return */
    if (HighlightDialog.shell != NULL) {
    	RaiseShellWindow(HighlightDialog.shell);
    	return;
    }
    
    if (LanguageModeName(0) == NULL) {
    	DialogF(DF_WARN, window->shell, 1, "No Language Modes available \
for syntax highlighting\nAdd language modes under Preferenses->Language Modes",
		"Dismiss");
    	return;
    }
    
    /* Decide on an initial language mode */
    HighlightDialog.langModeName = CopyAllocatedString(
    	    LanguageModeName(window->languageMode == PLAIN_LANGUAGE_MODE ? 0 :
    	    window->languageMode));

    /* Find the associated pattern set (patSet) to edit */
    patSet = FindPatternSet(HighlightDialog.langModeName);
    
    /* Copy the list of patterns to one that the user can freely edit */
    HighlightDialog.patterns = (highlightPattern **)XtMalloc(
    	    sizeof(highlightPattern *) * MAX_PATTERNS);
    nPatterns = patSet == NULL ? 0 : patSet->nPatterns;
    for (i=0; i<nPatterns; i++)
    	HighlightDialog.patterns[i] = copyPatternSrc(&patSet->patterns[i],NULL);
    HighlightDialog.nPatterns = nPatterns;


    /* Create a form widget in an application shell */
    n = 0;
    XtSetArg(args[n], XmNdeleteResponse, XmDO_NOTHING); n++;
    XtSetArg(args[n], XmNiconName, "Highlight Patterns"); n++;
    XtSetArg(args[n], XmNtitle, "Syntax Highlighting Patterns"); n++;
    HighlightDialog.shell = XtAppCreateShell(APP_NAME, APP_CLASS,
	    applicationShellWidgetClass, TheDisplay, args, n);
    AddSmallIcon(HighlightDialog.shell);
    form = XtVaCreateManagedWidget("editHighlightPatterns", xmFormWidgetClass,
	    HighlightDialog.shell, XmNautoUnmanage, False,
	    XmNresizePolicy, XmRESIZE_NONE, 0);
    XtAddCallback(form, XmNdestroyCallback, destroyCB, NULL);
    AddMotifCloseCallback(HighlightDialog.shell, dismissCB, NULL);

    lmForm = XtVaCreateManagedWidget("lmForm", xmFormWidgetClass,
    	    form,
	    XmNleftAttachment, XmATTACH_POSITION,
	    XmNleftPosition, 1,
	    XmNtopAttachment, XmATTACH_POSITION,
	    XmNtopPosition, 1,
	    XmNrightAttachment, XmATTACH_POSITION,
	    XmNrightPosition, 99, 0);
 
    HighlightDialog.lmPulldown = CreateLanguageModeMenu(lmForm, langModeCB,
    	    NULL);
    n = 0;
    XtSetArg(args[n], XmNspacing, 0); n++;
    XtSetArg(args[n], XmNmarginWidth, 0); n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNleftPosition, 50); n++;
    XtSetArg(args[n], XmNsubMenuId, HighlightDialog.lmPulldown); n++;
    lmOptMenu = XmCreateOptionMenu(lmForm, "langModeOptMenu", args, n);
    XtManageChild(lmOptMenu);
    HighlightDialog.lmOptMenu = lmOptMenu;
    
    lmLbl = XtVaCreateManagedWidget("lmLbl", xmLabelGadgetClass, lmForm,
    	    XmNlabelString, s1=XmStringCreateSimple("Language Mode:"),
    	    XmNmnemonic, 'M',
    	    XmNuserData, XtParent(HighlightDialog.lmOptMenu),
    	    XmNalignment, XmALIGNMENT_END,
	    XmNrightAttachment, XmATTACH_POSITION,
	    XmNrightPosition, 50,
	    XmNtopAttachment, XmATTACH_FORM,
	    XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
	    XmNbottomWidget, lmOptMenu, 0);
    XmStringFree(s1);
    
    lmBtn = XtVaCreateManagedWidget("lmBtn", xmPushButtonWidgetClass, lmForm,
    	    XmNlabelString, s1=MKSTRING("Add / Modify\nLanguage Mode..."),
    	    XmNmnemonic, 'A',
    	    XmNrightAttachment, XmATTACH_FORM,
    	    XmNtopAttachment, XmATTACH_FORM, 0);
    XtAddCallback(lmBtn, XmNactivateCallback, lmDialogCB, NULL);
    XmStringFree(s1);
    
    okBtn = XtVaCreateManagedWidget("ok", xmPushButtonWidgetClass, form,
    	    XmNlabelString, s1=XmStringCreateSimple("OK"),
    	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 1,
    	    XmNrightAttachment, XmATTACH_POSITION,
    	    XmNrightPosition, 13,
    	    XmNbottomAttachment, XmATTACH_FORM,
    	    XmNbottomOffset, BORDER, 0);
    XtAddCallback(okBtn, XmNactivateCallback, okCB, NULL);
    XmStringFree(s1);
    
    applyBtn = XtVaCreateManagedWidget("apply", xmPushButtonWidgetClass, form,
    	    XmNlabelString, s1=XmStringCreateSimple("Apply"),
    	    XmNmnemonic, 'y',
    	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 13,
    	    XmNrightAttachment, XmATTACH_POSITION,
    	    XmNrightPosition, 26,
    	    XmNbottomAttachment, XmATTACH_FORM,
    	    XmNbottomOffset, BORDER, 0);
    XtAddCallback(applyBtn, XmNactivateCallback, applyCB, NULL);
    XmStringFree(s1);
    
    checkBtn = XtVaCreateManagedWidget("check", xmPushButtonWidgetClass, form,
    	    XmNlabelString, s1=XmStringCreateSimple("Check"),
    	    XmNmnemonic, 'k',
    	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 26,
    	    XmNrightAttachment, XmATTACH_POSITION,
    	    XmNrightPosition, 39,
    	    XmNbottomAttachment, XmATTACH_FORM,
    	    XmNbottomOffset, BORDER, 0);
    XtAddCallback(checkBtn, XmNactivateCallback, checkCB, NULL);
    XmStringFree(s1);
    
    deleteBtn = XtVaCreateManagedWidget("delete", xmPushButtonWidgetClass, form,
    	    XmNlabelString, s1=XmStringCreateSimple("Delete"),
    	    XmNmnemonic, 'D',
    	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 39,
    	    XmNrightAttachment, XmATTACH_POSITION,
    	    XmNrightPosition, 52,
    	    XmNbottomAttachment, XmATTACH_FORM,
    	    XmNbottomOffset, BORDER, 0);
    XtAddCallback(deleteBtn, XmNactivateCallback, deleteCB, NULL);
    XmStringFree(s1);
    
    restoreBtn = XtVaCreateManagedWidget("restore", xmPushButtonWidgetClass, form,
    	    XmNlabelString, s1=XmStringCreateSimple("Restore Defaults"),
    	    XmNmnemonic, 'f',
    	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 52,
    	    XmNrightAttachment, XmATTACH_POSITION,
    	    XmNrightPosition, 73,
    	    XmNbottomAttachment, XmATTACH_FORM,
    	    XmNbottomOffset, BORDER, 0);
    XtAddCallback(restoreBtn, XmNactivateCallback, restoreCB, NULL);
    XmStringFree(s1);
    
    dismissBtn = XtVaCreateManagedWidget("dismiss", xmPushButtonWidgetClass,
    	    form,
    	    XmNlabelString, s1=XmStringCreateSimple("Dismiss"),
    	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 73,
    	    XmNrightAttachment, XmATTACH_POSITION,
    	    XmNrightPosition, 86,
    	    XmNbottomAttachment, XmATTACH_FORM,
    	    XmNbottomOffset, BORDER, 0);
    XtAddCallback(dismissBtn, XmNactivateCallback, dismissCB, NULL);
    XmStringFree(s1);
    
    helpBtn = XtVaCreateManagedWidget("help", xmPushButtonWidgetClass,
    	    form,
    	    XmNlabelString, s1=XmStringCreateSimple("Help"),
    	    XmNmnemonic, 'H',
    	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 86,
    	    XmNrightAttachment, XmATTACH_POSITION,
    	    XmNrightPosition, 99,
    	    XmNbottomAttachment, XmATTACH_FORM,
    	    XmNbottomOffset, BORDER, 0);
    XtAddCallback(helpBtn, XmNactivateCallback, helpCB, NULL);
    XmStringFree(s1);
    
    contextFrame = XtVaCreateManagedWidget("contextFrame", xmFrameWidgetClass,
    	    form,
	    XmNleftAttachment, XmATTACH_POSITION,
	    XmNleftPosition, 1,
	    XmNrightAttachment, XmATTACH_POSITION,
	    XmNrightPosition, 99,
	    XmNbottomAttachment, XmATTACH_WIDGET,
    	    XmNbottomWidget, okBtn,
    	    XmNbottomOffset, BORDER, 0);
    contextForm = XtVaCreateManagedWidget("contextForm", xmFormWidgetClass,
	    contextFrame, 0);
    contextLbl = XtVaCreateManagedWidget("contextLbl",
    	    xmLabelGadgetClass, contextFrame,
    	    XmNlabelString, s1=XmStringCreateSimple(
    	      "Context requirements for incremental re-parsing after changes"),
	    XmNchildType, XmFRAME_TITLE_CHILD, 0);
    XmStringFree(s1);
    
    HighlightDialog.lineContextW = XtVaCreateManagedWidget("lineContext",
    	    xmTextWidgetClass, contextForm,
	    XmNcolumns, 5,
	    XmNmaxLength, 12,
	    XmNleftAttachment, XmATTACH_POSITION,
	    XmNleftPosition, 15,
	    XmNrightAttachment, XmATTACH_POSITION,
	    XmNrightPosition, 25, 0);
    RemapDeleteKey(HighlightDialog.lineContextW);
    
    XtVaCreateManagedWidget("lineContLbl",
    	    xmLabelGadgetClass, contextForm,
    	    XmNlabelString, s1=XmStringCreateSimple("lines"),
    	    XmNmnemonic, 'l',
    	    XmNuserData, HighlightDialog.lineContextW,
    	    XmNalignment, XmALIGNMENT_BEGINNING,
	    XmNleftAttachment, XmATTACH_WIDGET,
	    XmNleftWidget, HighlightDialog.lineContextW,
	    XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
	    XmNtopWidget, HighlightDialog.lineContextW,
	    XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
    	    XmNbottomWidget, HighlightDialog.lineContextW, 0);
    XmStringFree(s1);

    HighlightDialog.charContextW = XtVaCreateManagedWidget("charContext",
    	    xmTextWidgetClass, contextForm,
	    XmNcolumns, 5,
	    XmNmaxLength, 12,
	    XmNleftAttachment, XmATTACH_POSITION,
	    XmNleftPosition, 58,
	    XmNrightAttachment, XmATTACH_POSITION,
	    XmNrightPosition, 68, 0);
    RemapDeleteKey(HighlightDialog.lineContextW);
    
    XtVaCreateManagedWidget("charContLbl",
    	    xmLabelGadgetClass, contextForm,
    	    XmNlabelString, s1=XmStringCreateSimple("characters"),
    	    XmNmnemonic, 'c',
    	    XmNuserData, HighlightDialog.charContextW,
    	    XmNalignment, XmALIGNMENT_BEGINNING,
	    XmNleftAttachment, XmATTACH_WIDGET,
	    XmNleftWidget, HighlightDialog.charContextW,
	    XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
	    XmNtopWidget, HighlightDialog.charContextW,
	    XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
    	    XmNbottomWidget, HighlightDialog.charContextW, 0);
    XmStringFree(s1);
    
    patternsFrame = XtVaCreateManagedWidget("patternsFrame", xmFrameWidgetClass,
    	    form,
	    XmNleftAttachment, XmATTACH_POSITION,
	    XmNleftPosition, 1,
	    XmNtopAttachment, XmATTACH_WIDGET,
	    XmNtopWidget, lmForm,
	    XmNrightAttachment, XmATTACH_POSITION,
	    XmNrightPosition, 99,
	    XmNbottomAttachment, XmATTACH_WIDGET,
    	    XmNbottomWidget, contextFrame,
    	    XmNbottomOffset, BORDER, 0);
    patternsForm = XtVaCreateManagedWidget("patternsForm", xmFormWidgetClass,
	    patternsFrame, 0);
    patternsLbl = XtVaCreateManagedWidget("patternsLbl", xmLabelGadgetClass,
    	    patternsFrame,
    	    XmNlabelString, s1=XmStringCreateSimple("Patterns"),
    	    XmNmnemonic, 'P',
    	    XmNmarginHeight, 0,
	    XmNchildType, XmFRAME_TITLE_CHILD, 0);
    XmStringFree(s1);
    
    typeLbl = XtVaCreateManagedWidget("typeLbl", xmLabelGadgetClass,
    	    patternsForm,
    	    XmNlabelString, s1=XmStringCreateSimple("Pattern Type:"),
    	    XmNmarginHeight, 0,
    	    XmNalignment, XmALIGNMENT_BEGINNING,
	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, LIST_RIGHT,
	    XmNtopAttachment, XmATTACH_FORM, 0);
    XmStringFree(s1);

    typeBox = XtVaCreateManagedWidget("typeBox", xmRowColumnWidgetClass,
    	    patternsForm,
    	    XmNpacking, XmPACK_COLUMN,
    	    XmNradioBehavior, True,
	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, LIST_RIGHT,
	    XmNtopAttachment, XmATTACH_WIDGET,
	    XmNtopWidget, typeLbl, 0);
    HighlightDialog.topLevelW = XtVaCreateManagedWidget("top", 
    	    xmToggleButtonWidgetClass, typeBox,
    	    XmNset, True,
    	    XmNmarginHeight, 0,
    	    XmNlabelString, s1=XmStringCreateSimple(
    	        "Pass-1 (applied to all text when loaded or modified)"),
    	    XmNmnemonic, '1', 0);
    XmStringFree(s1);
    XtAddCallback(HighlightDialog.topLevelW, XmNvalueChangedCallback,
    	    patTypeCB, NULL);
    HighlightDialog.deferredW = XtVaCreateManagedWidget("deferred", 
    	    xmToggleButtonWidgetClass, typeBox,
    	    XmNmarginHeight, 0,
    	    XmNlabelString, s1=XmStringCreateSimple(
    	        "Pass-2 (parsing is deferred until text is exposed)"),
    	    XmNmnemonic, '2', 0);
    XmStringFree(s1);
    XtAddCallback(HighlightDialog.deferredW, XmNvalueChangedCallback,
    	    patTypeCB, NULL);
    HighlightDialog.subPatW = XtVaCreateManagedWidget("subPat", 
    	    xmToggleButtonWidgetClass, typeBox,
    	    XmNmarginHeight, 0,
    	    XmNlabelString, s1=XmStringCreateSimple(
    	    	"Sub-pattern (processed within start & end of parent)"),
    	    XmNmnemonic, 'u', 0);
    XmStringFree(s1);
    XtAddCallback(HighlightDialog.subPatW, XmNvalueChangedCallback,
    	    patTypeCB, NULL);
    HighlightDialog.colorPatW = XtVaCreateManagedWidget("color", 
    	    xmToggleButtonWidgetClass, typeBox,
    	    XmNmarginHeight, 0,
    	    XmNlabelString, s1=XmStringCreateSimple(
    	    	"Coloring for sub-expressions of parent pattern"),
    	    XmNmnemonic, 'g', 0);
    XmStringFree(s1);
    XtAddCallback(HighlightDialog.colorPatW, XmNvalueChangedCallback,
    	    patTypeCB, NULL);

    HighlightDialog.matchLbl = XtVaCreateManagedWidget("matchLbl",
    	    xmLabelGadgetClass, patternsForm,
    	    XmNlabelString, s1=XmStringCreateSimple("Matching:"),
    	    XmNmarginHeight, 0,
    	    XmNalignment, XmALIGNMENT_BEGINNING,
	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, LIST_RIGHT,
	    XmNtopAttachment, XmATTACH_WIDGET,
	    XmNtopOffset, BORDER,
	    XmNtopWidget, typeBox, 0);
    XmStringFree(s1);

    matchBox = XtVaCreateManagedWidget("matchBox", xmRowColumnWidgetClass,
    	    patternsForm,
    	    XmNpacking, XmPACK_COLUMN,
    	    XmNradioBehavior, True,
	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, LIST_RIGHT,
	    XmNtopAttachment, XmATTACH_WIDGET,
	    XmNtopWidget, HighlightDialog.matchLbl, 0);
    HighlightDialog.simpleW = XtVaCreateManagedWidget("simple", 
    	    xmToggleButtonWidgetClass, matchBox,
    	    XmNset, True,
    	    XmNmarginHeight, 0,
    	    XmNlabelString, s1=XmStringCreateSimple(
    	    	"Highlight text matching regular expression"),
    	    XmNmnemonic, 'x', 0);
    XmStringFree(s1);
    XtAddCallback(HighlightDialog.simpleW, XmNvalueChangedCallback,
    	    matchTypeCB, NULL);
    HighlightDialog.rangeW = XtVaCreateManagedWidget("range", 
    	    xmToggleButtonWidgetClass, matchBox,
    	    XmNmarginHeight, 0,
    	    XmNlabelString, s1=XmStringCreateSimple(
    	    	"Highlight text between starting and ending REs"),
    	    XmNmnemonic, 'b', 0);
    XmStringFree(s1);
    XtAddCallback(HighlightDialog.rangeW, XmNvalueChangedCallback,
    	    matchTypeCB, NULL);

    nameLbl = XtVaCreateManagedWidget("nameLbl", xmLabelGadgetClass,
    	    patternsForm,
    	    XmNlabelString, s1=XmStringCreateSimple("Pattern Name"),
    	    XmNmnemonic, 'N',
    	    XmNrows, 20,
    	    XmNalignment, XmALIGNMENT_BEGINNING,
	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, LIST_RIGHT,
	    XmNtopAttachment, XmATTACH_WIDGET,
	    XmNtopWidget, matchBox,
	    XmNtopOffset, BORDER, 0);
    XmStringFree(s1);
 
    HighlightDialog.nameW = XtVaCreateManagedWidget("name", xmTextWidgetClass,
    	    patternsForm,
	    XmNleftAttachment, XmATTACH_POSITION,
	    XmNleftPosition, LIST_RIGHT,
	    XmNtopAttachment, XmATTACH_WIDGET,
	    XmNtopWidget, nameLbl,
	    XmNrightAttachment, XmATTACH_POSITION,
	    XmNrightPosition, (99 + LIST_RIGHT)/2, 0);
    RemapDeleteKey(HighlightDialog.nameW);
    XtVaSetValues(nameLbl, XmNuserData, HighlightDialog.nameW, 0);

    HighlightDialog.parentLbl = XtVaCreateManagedWidget("parentLbl",
    	    xmLabelGadgetClass, patternsForm,
    	    XmNlabelString, s1=XmStringCreateSimple("Parent Pattern"),
    	    XmNmnemonic, 't',
    	    XmNrows, 20,
    	    XmNalignment, XmALIGNMENT_BEGINNING,
	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, (99 + LIST_RIGHT)/2 + 1,
	    XmNtopAttachment, XmATTACH_WIDGET,
	    XmNtopWidget, matchBox,
	    XmNtopOffset, BORDER, 0);
    XmStringFree(s1);
 
    HighlightDialog.parentW = XtVaCreateManagedWidget("parent",
    	    xmTextWidgetClass, patternsForm,
	    XmNleftAttachment, XmATTACH_POSITION,
	    XmNleftPosition, (99 + LIST_RIGHT)/2 + 1,
	    XmNtopAttachment, XmATTACH_WIDGET,
	    XmNtopWidget, HighlightDialog.parentLbl,
	    XmNrightAttachment, XmATTACH_POSITION,
	    XmNrightPosition, 99, 0);
    RemapDeleteKey(HighlightDialog.parentW);
    XtVaSetValues(HighlightDialog.parentLbl, XmNuserData,
    	    HighlightDialog.parentW, 0);

    HighlightDialog.startLbl = XtVaCreateManagedWidget("startLbl",
    	    xmLabelGadgetClass, patternsForm,
    	    XmNalignment, XmALIGNMENT_BEGINNING,
	    XmNmnemonic, 'R',
	    XmNtopAttachment, XmATTACH_WIDGET,
	    XmNtopWidget, HighlightDialog.parentW,
	    XmNtopOffset, BORDER,
	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 1, 0);
 
    HighlightDialog.errorW = XtVaCreateManagedWidget("error",
    	    xmTextWidgetClass, patternsForm,
	    XmNleftAttachment, XmATTACH_POSITION,
	    XmNleftPosition, 1,
	    XmNrightAttachment, XmATTACH_POSITION,
	    XmNrightPosition, 99,
	    XmNbottomAttachment, XmATTACH_POSITION,
	    XmNbottomPosition, 99, 0);
    RemapDeleteKey(HighlightDialog.errorW);

    HighlightDialog.errorLbl = XtVaCreateManagedWidget("errorLbl",
    	    xmLabelGadgetClass, patternsForm,
    	    XmNlabelString, s1=XmStringCreateSimple(
    	    	"Regular Expression Indicating Error in Match (Optional)"),
    	    XmNmnemonic, 'o',
    	    XmNuserData, HighlightDialog.errorW,
    	    XmNalignment, XmALIGNMENT_BEGINNING,
	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 1,
	    XmNbottomAttachment, XmATTACH_WIDGET,
	    XmNbottomWidget, HighlightDialog.errorW, 0);
    XmStringFree(s1);
 
    HighlightDialog.endW = XtVaCreateManagedWidget("end",
    	    xmTextWidgetClass, patternsForm,
	    XmNleftAttachment, XmATTACH_POSITION,
	    XmNleftPosition, 1,
	    XmNbottomAttachment, XmATTACH_WIDGET,
	    XmNbottomWidget, HighlightDialog.errorLbl,
	    XmNbottomOffset, BORDER,
	    XmNrightAttachment, XmATTACH_POSITION,
	    XmNrightPosition, 99, 0);
    RemapDeleteKey(HighlightDialog.endW);

    HighlightDialog.endLbl = XtVaCreateManagedWidget("endLbl",
    	    xmLabelGadgetClass, patternsForm,
    	    XmNmnemonic, 'E',
    	    XmNuserData, HighlightDialog.endW,
    	    XmNalignment, XmALIGNMENT_BEGINNING,
	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 1,
	    XmNbottomAttachment, XmATTACH_WIDGET,
	    XmNbottomWidget, HighlightDialog.endW, 0);

    n = 0;
    XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT); n++;
    XtSetArg(args[n], XmNscrollHorizontal, False); n++;
    XtSetArg(args[n], XmNwordWrap, True); n++;
    XtSetArg(args[n], XmNrows, 3); n++;
    XtSetArg(args[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNbottomWidget, HighlightDialog.endLbl); n++;
    XtSetArg(args[n], XmNbottomOffset, BORDER); n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNtopWidget, HighlightDialog.startLbl); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNleftPosition, 1); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNrightPosition, 99); n++;
    HighlightDialog.startW = XmCreateScrolledText(patternsForm, "start",args,n);
    XtManageChild(HighlightDialog.startW);
    MakeSingleLineTextW(HighlightDialog.startW);
    RemapDeleteKey(HighlightDialog.startW);
    XtVaSetValues(HighlightDialog.startLbl,
    		XmNuserData,HighlightDialog.startW, 0);

    styleBtn = XtVaCreateManagedWidget("styleLbl", xmPushButtonWidgetClass,
    	    patternsForm,
    	    XmNlabelString, s1=MKSTRING("Add / Modify\nStyle..."),
    	    XmNmnemonic, 'i',
	    XmNrightAttachment, XmATTACH_POSITION,
    	    XmNrightPosition, LIST_RIGHT-1,
	    XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
	    XmNbottomWidget, HighlightDialog.parentW, 0);
    XmStringFree(s1);
    XtAddCallback(styleBtn, XmNactivateCallback, styleDialogCB, NULL);

    HighlightDialog.stylePulldown = createHighlightStylesMenu(patternsForm);
    n = 0;
    XtSetArg(args[n], XmNspacing, 0); n++;
    XtSetArg(args[n], XmNmarginWidth, 0); n++;
    XtSetArg(args[n], XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET); n++;
    XtSetArg(args[n], XmNbottomWidget, HighlightDialog.parentW); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNleftPosition, 1); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNrightWidget, styleBtn); n++;
    XtSetArg(args[n], XmNsubMenuId, HighlightDialog.stylePulldown); n++;
    HighlightDialog.styleOptMenu = XmCreateOptionMenu(patternsForm,
    		"styleOptMenu", args, n);
    XtManageChild(HighlightDialog.styleOptMenu);

    styleLbl = XtVaCreateManagedWidget("styleLbl", xmLabelGadgetClass,
    	    patternsForm,
    	    XmNlabelString, s1=XmStringCreateSimple("Highlight Style"),
    	    XmNmnemonic, 'S',
    	    XmNuserData, XtParent(HighlightDialog.styleOptMenu),
    	    XmNalignment, XmALIGNMENT_BEGINNING,
	    XmNleftAttachment, XmATTACH_POSITION,
    	    XmNleftPosition, 1,
	    XmNbottomAttachment, XmATTACH_WIDGET,
	    XmNbottomWidget, HighlightDialog.styleOptMenu, 0);
    XmStringFree(s1);

    n = 0;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNleftAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNleftPosition, 1); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_POSITION); n++;
    XtSetArg(args[n], XmNrightPosition, LIST_RIGHT-1); n++;
    XtSetArg(args[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
    XtSetArg(args[n], XmNbottomWidget, styleLbl); n++;
    XtSetArg(args[n], XmNbottomOffset, BORDER); n++;
    HighlightDialog.managedListW = CreateManagedList(patternsForm, "list", args,
    	    n, (void **)HighlightDialog.patterns, &HighlightDialog.nPatterns,
    	    MAX_PATTERNS, 18, getDisplayedCB, NULL, setDisplayedCB,
    	    NULL, freeItemCB);
    XtVaSetValues(patternsLbl, XmNuserData, HighlightDialog.managedListW, 0);

    /* Set initial default button */
    XtVaSetValues(form, XmNdefaultButton, okBtn, 0);
    XtVaSetValues(form, XmNcancelButton, dismissBtn, 0);
    
    /* Handle mnemonic selection of buttons and focus to dialog */
    AddDialogMnemonicHandler(form);
    
    /* Fill in the dialog information for the selected language mode */
    SetIntText(HighlightDialog.lineContextW, patSet==NULL ? 1 :
    	    patSet->lineContext);
    SetIntText(HighlightDialog.charContextW, patSet==NULL ? 0 :
    	    patSet->charContext);
    SetLangModeMenu(HighlightDialog.lmOptMenu, HighlightDialog.langModeName);
    updateLabels();
    
    /* Realize all of the widgets in the new dialog */
    XtRealizeWidget(HighlightDialog.shell);
}

/*
** If a syntax highlighting dialog is up, ask to have the option menu for
** chosing highlight styles updated (via a call to createHighlightStylesMenu)
*/
static void updateHighlightStyleMenu(void)
{
    Widget oldMenu;
    int patIndex;
    
    if (HighlightDialog.shell == NULL)
    	return;
    
    oldMenu = HighlightDialog.stylePulldown;
    HighlightDialog.stylePulldown = createHighlightStylesMenu(
    	    XtParent(XtParent(oldMenu)));
    XtVaSetValues(XmOptionButtonGadget(HighlightDialog.styleOptMenu),
    	    XmNsubMenuId, HighlightDialog.stylePulldown, 0);
    patIndex = ManagedListSelectedIndex(HighlightDialog.managedListW);
    if (patIndex == -1)
    	setStyleMenu("Plain");
    else
    	setStyleMenu(HighlightDialog.patterns[patIndex]->style);
    
    XtDestroyWidget(oldMenu);
}

/*
** If a syntax highlighting dialog is up, ask to have the option menu for
** chosing language mode updated (via a call to CreateLanguageModeMenu)
*/
void UpdateLanguageModeMenu(void)
{
    Widget oldMenu;

    if (HighlightDialog.shell == NULL)
    	return;

    oldMenu = HighlightDialog.lmPulldown;
    HighlightDialog.lmPulldown = CreateLanguageModeMenu(
    	    XtParent(XtParent(oldMenu)), langModeCB, NULL);
    XtVaSetValues(XmOptionButtonGadget(HighlightDialog.lmOptMenu),
    	    XmNsubMenuId, HighlightDialog.lmPulldown, 0);
    SetLangModeMenu(HighlightDialog.lmOptMenu, HighlightDialog.langModeName);

    XtDestroyWidget(oldMenu);
}

static void destroyCB(Widget w, XtPointer clientData, XtPointer callData)
{
    int i;
    
    freeNonNull(HighlightDialog.langModeName);
    for (i=0; i<HighlightDialog.nPatterns; i++)
     	freePatternSrc(HighlightDialog.patterns[i], True);
    HighlightDialog.shell = NULL;
}

static void langModeCB(Widget w, XtPointer clientData, XtPointer callData)
{
    char *modeName;
    patternSet *oldPatSet, *newPatSet;
    patternSet emptyPatSet = {NULL, 1, 0, 0, NULL};
    int i, resp;
    
    /* Get the newly selected mode name.  If it's the same, do nothing */
    XtVaGetValues(w, XmNuserData, &modeName, 0);
    if (!strcmp(modeName, HighlightDialog.langModeName))
    	return;
    
    /* Look up the original version of the patterns being edited */
    oldPatSet = FindPatternSet(HighlightDialog.langModeName);
    if (oldPatSet == NULL)
    	oldPatSet = &emptyPatSet;
    
    /* Get the current information displayed by the dialog.  If it's bad,
       give the user the chance to throw it out or go back and fix it.  If
       it has changed, give the user the chance to apply discard or cancel. */
    newPatSet = getDialogPatternSet();
    if (newPatSet == NULL) {
	if (DialogF(DF_WARN, HighlightDialog.shell, 2,
    		"Discard incomplete entry\nfor current language mode?",
    		"Keep", "Discard") == 1) {
    	    SetLangModeMenu(HighlightDialog.lmOptMenu,
	    	    HighlightDialog.langModeName);
     	    return;
     	}
    } else if (patternSetsDiffer(oldPatSet, newPatSet)) {
    	resp = DialogF(DF_WARN, HighlightDialog.shell, 3,
    		"Apply changes for language mode %s?", "Apply Changes",
    		"Discard Changes", "Cancel", HighlightDialog.langModeName);
    	if (resp == 3) {
    	    SetLangModeMenu(HighlightDialog.lmOptMenu,
	    	    HighlightDialog.langModeName);
     	    return;
     	}
     	if (resp == 1)
     	    updatePatternSet();
    }
    if (newPatSet != NULL)
    	freePatternSet(newPatSet);

    /* Free the old dialog information */
    freeNonNull(HighlightDialog.langModeName);
    for (i=0; i<HighlightDialog.nPatterns; i++)
     	freePatternSrc(HighlightDialog.patterns[i], True);
    
    /* Fill the dialog with the new language mode information */
    HighlightDialog.langModeName = CopyAllocatedString(modeName);
    newPatSet = FindPatternSet(modeName);
    if (newPatSet == NULL) {
    	HighlightDialog.nPatterns = 0;
    	SetIntText(HighlightDialog.lineContextW, 1);
    	SetIntText(HighlightDialog.charContextW, 0);
    } else {
	for (i=0; i<newPatSet->nPatterns; i++)
    	    HighlightDialog.patterns[i] =
    		    copyPatternSrc(&newPatSet->patterns[i], NULL);
	HighlightDialog.nPatterns = newPatSet->nPatterns;
    	SetIntText(HighlightDialog.lineContextW, newPatSet->lineContext);
    	SetIntText(HighlightDialog.charContextW, newPatSet->charContext);
    }
    ChangeManagedListData(HighlightDialog.managedListW);
}

static void lmDialogCB(Widget w, XtPointer clientData, XtPointer callData)
{
    EditLanguageModes(HighlightDialog.shell);
}

static void styleDialogCB(Widget w, XtPointer clientData, XtPointer callData)
{
    Widget selectedItem;
    char *style;
    
    XtVaGetValues(HighlightDialog.styleOptMenu, XmNmenuHistory,&selectedItem,0);
    XtVaGetValues(selectedItem, XmNuserData, &style, 0);
    EditHighlightStyles(HighlightDialog.shell, style);
}

static void okCB(Widget w, XtPointer clientData, XtPointer callData)
{
    /* change the patterns */
    if (!updatePatternSet())
    	return;
    
    /* pop down and destroy the dialog */
    XtDestroyWidget(HighlightDialog.shell);
}

static void applyCB(Widget w, XtPointer clientData, XtPointer callData)
{
    /* change the patterns */
    updatePatternSet();
}
	
static void checkCB(Widget w, XtPointer clientData, XtPointer callData)
{
    if (checkHighlightDialogData())
	DialogF(DF_INF, HighlightDialog.shell, 1,
    		"Patterns compiled without error", "Dismiss");
}
	
static void restoreCB(Widget w, XtPointer clientData, XtPointer callData)
{
    patternSet *defaultPatSet;
    int i, psn;
    
    defaultPatSet = readDefaultPatternSet(HighlightDialog.langModeName);
    if (defaultPatSet == NULL) {
    	DialogF(DF_WARN, HighlightDialog.shell, 1,
 		"There is no default pattern set\nfor language mode %s",
 		"Dismiss", HighlightDialog.langModeName);
    	return;
    }
    
    if (DialogF(DF_WARN, HighlightDialog.shell, 2,
"Are you sure you want to discard\n\
all changes to syntax highlighting\n\
patterns for language mode %s?", "Discard", "Cancel",
	    HighlightDialog.langModeName) == 2)
    	return;
    
    /* if a stored version of the pattern set exists, replace it, if it
       doesn't, add a new one */
    for (psn=0; psn<NPatternSets; psn++)
    	if (!strcmp(HighlightDialog.langModeName,
    	    	PatternSets[psn]->languageMode))
    	    break;
    if (psn < NPatternSets) {
     	freePatternSet(PatternSets[psn]);
   	PatternSets[psn] = defaultPatSet;
    } else
    	PatternSets[NPatternSets++] = defaultPatSet;

    /* Free the old dialog information */
    for (i=0; i<HighlightDialog.nPatterns; i++)
     	freePatternSrc(HighlightDialog.patterns[i], True);
    
    /* Update the dialog */
    HighlightDialog.nPatterns = defaultPatSet->nPatterns;
    for (i=0; i<defaultPatSet->nPatterns; i++)
    	HighlightDialog.patterns[i] =
    		copyPatternSrc(&defaultPatSet->patterns[i], NULL);
    	SetIntText(HighlightDialog.lineContextW, defaultPatSet->lineContext);
    	SetIntText(HighlightDialog.charContextW, defaultPatSet->charContext);
    ChangeManagedListData(HighlightDialog.managedListW);
}
	
static void deleteCB(Widget w, XtPointer clientData, XtPointer callData)
{
    int i, psn;
    
    if (DialogF(DF_WARN, HighlightDialog.shell, 2,
"Are you sure you want to delete\n\
syntax highlighting patterns for\n\
language mode %s?", "Yes, Delete", "Cancel", HighlightDialog.langModeName) == 2)
    	return;
    
    /* if a stored version of the pattern set exists, delete it from the list */
    for (psn=0; psn<NPatternSets; psn++)
    	if (!strcmp(HighlightDialog.langModeName,
    	    	PatternSets[psn]->languageMode))
    	    break;
    if (psn < NPatternSets) {
     	freePatternSet(PatternSets[psn]);
   	memmove(&PatternSets[psn], &PatternSets[psn+1],
   	    	(NPatternSets-1 - psn) * sizeof(patternSet *));
    	NPatternSets--;
    }

    /* Free the old dialog information */
    for (i=0; i<HighlightDialog.nPatterns; i++)
     	freePatternSrc(HighlightDialog.patterns[i], True);
    
    /* Clear out the dialog */
    HighlightDialog.nPatterns = 0;
    SetIntText(HighlightDialog.lineContextW, 1);
    SetIntText(HighlightDialog.charContextW, 0);
    ChangeManagedListData(HighlightDialog.managedListW);
}

static void dismissCB(Widget w, XtPointer clientData, XtPointer callData)
{
    /* pop down and destroy the dialog */
    XtDestroyWidget(HighlightDialog.shell);
}

static void helpCB(Widget w, XtPointer clientData, XtPointer callData)
{
    Help(w, HELP_PATTERNS);
}

static void patTypeCB(Widget w, XtPointer clientData, XtPointer callData)
{
    updateLabels();
}

static void matchTypeCB(Widget w, XtPointer clientData, XtPointer callData)
{
    updateLabels();
}

static void *getDisplayedCB(void *oldItem, int explicitRequest, int *abort,
    	void *cbArg)
{
    highlightPattern *pat;
    
    /* If the dialog is currently displaying the "new" entry and the
       fields are empty, that's just fine */
    if (oldItem == NULL && dialogEmpty())
    	return NULL;
    
    /* If there are no problems reading the data, just return it */
    pat = readDialogFields(True);
    if (pat != NULL)
    	return (void *)pat;
    
    /* If there are problems, and the user didn't ask for the fields to be
       read, give more warning */
    if (!explicitRequest) {
	if (DialogF(DF_WARN, HighlightDialog.shell, 2,
    		"Discard incomplete entry\nfor current pattern?",
    		"Keep", "Discard") == 2) {
     	    return oldItem == NULL ? NULL : (void *)copyPatternSrc(
     	    	    (highlightPattern *)oldItem, NULL);
	}
    }

    /* Do readDialogFields again without "silent" mode to display warning */
    pat = readDialogFields(False);
    *abort = True;
    return NULL;
}

static void setDisplayedCB(void *item, void *cbArg)
{
    highlightPattern *pat = (highlightPattern *)item;
    int isSubpat, isDeferred, isColorOnly, isRange;

    if (item == NULL) {
    	XmTextSetString(HighlightDialog.nameW, "");
    	XmTextSetString(HighlightDialog.parentW, "");
    	XmTextSetString(HighlightDialog.startW, "");
    	XmTextSetString(HighlightDialog.endW, "");
    	XmTextSetString(HighlightDialog.errorW, "");
    	XmToggleButtonSetState(HighlightDialog.topLevelW, True, False);
    	XmToggleButtonSetState(HighlightDialog.deferredW, False, False);
    	XmToggleButtonSetState(HighlightDialog.subPatW, False, False);
    	XmToggleButtonSetState(HighlightDialog.colorPatW, False, False);
    	XmToggleButtonSetState(HighlightDialog.simpleW, True, False);
    	XmToggleButtonSetState(HighlightDialog.rangeW, False, False);
    	setStyleMenu("Plain");
    } else {
    	isSubpat = pat->subPatternOf != NULL;
    	isDeferred = pat->flags & DEFER_PARSING;
    	isColorOnly = pat->flags & COLOR_ONLY;
    	isRange = pat->endRE != NULL;
    	XmTextSetString(HighlightDialog.nameW, pat->name);
    	XmTextSetString(HighlightDialog.parentW, pat->subPatternOf);
    	XmTextSetString(HighlightDialog.startW, pat->startRE);
    	XmTextSetString(HighlightDialog.endW, pat->endRE);
    	XmTextSetString(HighlightDialog.errorW, pat->errorRE);
    	XmToggleButtonSetState(HighlightDialog.topLevelW,
    	    	!isSubpat && !isDeferred, False);
    	XmToggleButtonSetState(HighlightDialog.deferredW,
    	    	!isSubpat && isDeferred, False);
    	XmToggleButtonSetState(HighlightDialog.subPatW,
    	    	isSubpat && !isColorOnly, False);
    	XmToggleButtonSetState(HighlightDialog.colorPatW,
    	    	isSubpat && isColorOnly, False);
    	XmToggleButtonSetState(HighlightDialog.simpleW, !isRange, False);
    	XmToggleButtonSetState(HighlightDialog.rangeW, isRange, False);
    	setStyleMenu(pat->style);
    }
    updateLabels();
}

static void freeItemCB(void *item)
{
    freePatternSrc((highlightPattern *)item, True);
}

/*
** Do a test compile of the patterns currently displayed in the highlight
** patterns dialog, and display warning dialogs if there are problems
*/
static int checkHighlightDialogData(void)
{
    patternSet *patSet;
    int result;
    
    /* Get the pattern information from the dialog */
    patSet = getDialogPatternSet();
    if (patSet == NULL)
    	return False;
     
    /* Compile the patterns  */
    result = patSet->nPatterns == 0 ? True : TestHighlightPatterns(patSet);
    freePatternSet(patSet);
    return result;
}

/*
** Update the text field labels and sensitivity of various fields, based on
** the settings of the Pattern Type and Matching radio buttons in the highlight
** patterns dialog.
*/
static void updateLabels(void)
{
    char *startLbl, *endLbl;
    int endSense, errSense, matchSense, parentSense;
    XmString s1;
    
    if (XmToggleButtonGetState(HighlightDialog.colorPatW)) {
	startLbl =  "Sub-expressions to Highlight in Parent's Starting \
Regular Expression (\\1 \\2 etc.)";
	endLbl = "Sub-expressions to Highlight in Parent Pattern's Ending \
Regular Expression";
    	endSense = True;
    	errSense = False;
    	matchSense = False;
    	parentSense = True;
    } else {
    	endLbl = "Ending Regular Expression";
    	matchSense = True;
    	parentSense = XmToggleButtonGetState(HighlightDialog.subPatW);
    	if (XmToggleButtonGetState(HighlightDialog.simpleW)) {
    	    startLbl = "Regular Expression to Match";
    	    endSense = False;
    	    errSense = False;
    	} else {
    	    startLbl = "Starting Regular Expression";
    	    endSense = True;
    	    errSense = True;
	}
    }
    
    XtSetSensitive(HighlightDialog.parentLbl, parentSense);
    XtSetSensitive(HighlightDialog.parentW, parentSense);
    XtSetSensitive(HighlightDialog.endW, endSense);
    XtSetSensitive(HighlightDialog.endLbl, endSense);
    XtSetSensitive(HighlightDialog.errorW, errSense);
    XtSetSensitive(HighlightDialog.errorLbl, errSense);
    XtSetSensitive(HighlightDialog.errorLbl, errSense);
    XtSetSensitive(HighlightDialog.simpleW, matchSense);
    XtSetSensitive(HighlightDialog.rangeW, matchSense);
    XtSetSensitive(HighlightDialog.matchLbl, matchSense);
    XtVaSetValues(HighlightDialog.startLbl, XmNlabelString,
    	    s1=XmStringCreateSimple(startLbl), 0);
    XmStringFree(s1);
    XtVaSetValues(HighlightDialog.endLbl, XmNlabelString,
    	    s1=XmStringCreateSimple(endLbl), 0);
    XmStringFree(s1);
}

/*
** Set the styles menu in the currently displayed highlight dialog to show
** a particular style
*/
static void setStyleMenu(char *styleName)
{
    int i;
    Cardinal nItems;
    WidgetList items;
    Widget selectedItem;
    char *itemStyle;

    XtVaGetValues(HighlightDialog.stylePulldown, XmNchildren, &items,
    	    XmNnumChildren, &nItems, 0);
    if (nItems == 0)
    	return;
    selectedItem = items[0];
    for (i=0; i<nItems; i++) {
    	XtVaGetValues(items[i], XmNuserData, &itemStyle, 0);
    	if (!strcmp(itemStyle, styleName)) {
    	    selectedItem = items[i];
    	    break;
    	}
    }
    XtVaSetValues(HighlightDialog.styleOptMenu, XmNmenuHistory, selectedItem,0);
}

/*
** Read the pattern fields of the highlight dialog, and produce an allocated
** highlightPattern structure reflecting the contents, or pop up dialogs
** telling the user what's wrong (Passing "silent" as True, suppresses these
** dialogs).  Returns NULL on error.
*/ 
static highlightPattern *readDialogFields(int silent)
{
    highlightPattern *pat;
    char *inPtr, *outPtr, *style;
    Widget selectedItem;
    int colorOnly;

    /* Allocate a pattern source structure to return, zero out fields
       so that the whole pattern can be freed on error with freePatternSrc */
    pat = (highlightPattern *)XtMalloc(sizeof(highlightPattern));
    pat->endRE = NULL;
    pat->errorRE = NULL;
    pat->style = NULL;
    pat->subPatternOf = NULL;
    
    /* read the type buttons */
    pat->flags = 0;
    colorOnly = XmToggleButtonGetState(HighlightDialog.colorPatW);
    if (XmToggleButtonGetState(HighlightDialog.deferredW))
    	pat->flags |= DEFER_PARSING;
    else if (colorOnly)
    	pat->flags = COLOR_ONLY;

    /* read the name field */
    pat->name = ReadSymbolicFieldTextWidget(HighlightDialog.nameW,
    	    "highlight pattern name", silent);
    if (pat->name == NULL) {
    	XtFree((char *)pat);
    	return NULL;
    }
    if (*pat->name == '\0') {
    	if (!silent) {
    	    DialogF(DF_WARN, HighlightDialog.shell, 1,
    		   "Please specify a name\nfor the pattern", "Dismiss");
    	    XmProcessTraversal(HighlightDialog.nameW, XmTRAVERSE_CURRENT);
    	}
    	XtFree(pat->name);
    	XtFree((char *)pat);
   	return NULL;
    }
    
    /* read the startRE field */
    pat->startRE = XmTextGetString(HighlightDialog.startW);
    if (*pat->startRE == '\0') {
    	if (!silent) {
    	    DialogF(DF_WARN, HighlightDialog.shell, 1,
    		   "Please specify a regular\nexpression to match", "Dismiss");
    	    XmProcessTraversal(HighlightDialog.startW, XmTRAVERSE_CURRENT);
    	}
    	freePatternSrc(pat, True);
    	return NULL;
    }
    
    /* Make sure coloring patterns contain only sub-expression references
       and put it in replacement regular-expression form */
    if (colorOnly) {
	for (inPtr=pat->startRE, outPtr=pat->startRE; *inPtr!='\0'; inPtr++)
    	    if (*inPtr!=' ' && *inPtr!='\t')
    		*outPtr++ = *inPtr;
	*outPtr = '\0';
    	if (strspn(pat->startRE, "\\0123456789 \t") != strlen(pat->startRE) ||
    	    	*pat->startRE != '\\' || strstr(pat->startRE, "\\\\") != NULL) {
    	    if (!silent) {
    		DialogF(DF_WARN, HighlightDialog.shell, 1,
"The expression field in patterns which specify highlighting for\n\
a parent, must contain only sub-expression references in regular\n\
expression replacement form (\\1\\2 etc.).  See Help -> Regular\n\
Expressions and Help -> Syntax Highlighting for more information", "Dismiss");
    		XmProcessTraversal(HighlightDialog.startW, XmTRAVERSE_CURRENT);
    	    }
    	    freePatternSrc(pat, True);
    	    return NULL;
    	}
    }
    	
    /* read the parent field */
    if (XmToggleButtonGetState(HighlightDialog.subPatW) || colorOnly) {
	if (TextWidgetIsBlank(HighlightDialog.parentW)) {
    	    if (!silent) {
    		DialogF(DF_WARN, HighlightDialog.shell, 1,
    		       "Please specify a parent parent pattern", "Dismiss");
    		XmProcessTraversal(HighlightDialog.parentW, XmTRAVERSE_CURRENT);
    	    }
    	    freePatternSrc(pat, True);
    	    return NULL;
	}
	pat->subPatternOf = XmTextGetString(HighlightDialog.parentW);
    }
    
    /* read the styles option menu */
    XtVaGetValues(HighlightDialog.styleOptMenu, XmNmenuHistory,&selectedItem,0);
    XtVaGetValues(selectedItem, XmNuserData, &style, 0);
    pat->style = XtMalloc(strlen(style) + 1);
    strcpy(pat->style, style);
    
    	
    /* read the endRE field */
    if (colorOnly || XmToggleButtonGetState(HighlightDialog.rangeW)) {
	pat->endRE = XmTextGetString(HighlightDialog.endW);
	if (!colorOnly && *pat->endRE == '\0') {
            if (!silent) {
    		DialogF(DF_WARN, HighlightDialog.shell, 1,
    		       "Please specify an ending\nregular expression", "Dismiss");
    		XmProcessTraversal(HighlightDialog.endW, XmTRAVERSE_CURRENT);
    	    }
    	    freePatternSrc(pat, True);
    	    return NULL;
	}
    }
    
    /* read the errorRE field */
    if (XmToggleButtonGetState(HighlightDialog.rangeW)) {
	pat->errorRE = XmTextGetString(HighlightDialog.errorW);
	if (*pat->errorRE == '\0') {
            XtFree(pat->errorRE);
            pat->errorRE = NULL;
	}
    }
    return pat;
}

/*
** Returns true if the pattern fields of the highlight dialog are set to
** the default ("New" pattern) state.
*/
static int dialogEmpty(void)
{
    return TextWidgetIsBlank(HighlightDialog.nameW) &&
	    XmToggleButtonGetState(HighlightDialog.topLevelW) &&
	    XmToggleButtonGetState(HighlightDialog.simpleW) &&
	    TextWidgetIsBlank(HighlightDialog.parentW) &&
	    TextWidgetIsBlank(HighlightDialog.startW) &&
	    TextWidgetIsBlank(HighlightDialog.endW) &&
	    TextWidgetIsBlank(HighlightDialog.errorW);
}   	

/*
** Update the pattern set being edited in the Syntax Highlighting dialog
** with the information that the dialog is currently displaying, and
** apply changes to any window which is currently using the patterns.
*/
static int updatePatternSet(void)
{
    patternSet *patSet;
    WindowInfo *window;
    int psn;
    	
    /* Make sure the patterns are valid and compile */
    if (!checkHighlightDialogData())
    	return False;
    
    /* Get the current data */
    patSet = getDialogPatternSet();
    if (patSet == NULL)
    	return False;
    
    /* Find the pattern being modified */
    for (psn=0; psn<NPatternSets; psn++)
    	if (!strcmp(HighlightDialog.langModeName,
    	    	PatternSets[psn]->languageMode))
    	    break;
    
    /* If it's a new pattern, add it at the end, otherwise free the
       existing pattern set and replace it */
    if (psn == NPatternSets) {
    	PatternSets[NPatternSets++] = patSet;
    } else {
	freePatternSet(PatternSets[psn]);
	PatternSets[psn] = patSet;
    }
    
    /* Find windows that are currently using this pattern set and
       re-do the highlighting */
    for (window=WindowList; window!=NULL; window=window->next) {
    	if (window->highlightSyntax &&
    		window->languageMode != PLAIN_LANGUAGE_MODE) {
    	    if (!strcmp(LanguageModeName(window->languageMode),
    	    	    patSet->languageMode)) {
    	    	StopHighlighting(window);
    	    	StartHighlighting(window, True);
    	    }
    	}
    }
    
    /* Note that preferences have been changed */
    MarkPrefsChanged();

    return True;
}

/*
** Get the current information that the user has entered in the syntax
** highlighting dialog.  Return NULL if the data is currently invalid
*/
static patternSet *getDialogPatternSet(void)
{
    int i, lineContext, charContext;
    patternSet *patSet;
    
    /* Get the current contents of the "patterns" dialog fields */
    if (!UpdateManagedList(HighlightDialog.managedListW, True))
    	return NULL;
    
    /* Get the line and character context values */
    if (GetIntTextWarn(HighlightDialog.lineContextW, &lineContext,
    	    "context lines", True) != TEXT_READ_OK)
    	return NULL;
    if (GetIntTextWarn(HighlightDialog.charContextW, &charContext,
    	    "context lines", True) != TEXT_READ_OK)
    	return NULL;
    
    /* Allocate a new pattern set structure and copy the fields read from the
       dialog, including the modified pattern list into it */
    patSet = (patternSet *)XtMalloc(sizeof(patternSet));
    patSet->languageMode = CopyAllocatedString(HighlightDialog.langModeName);
    patSet->lineContext = lineContext;
    patSet->charContext = charContext;
    patSet->nPatterns = HighlightDialog.nPatterns;
    patSet->patterns = (highlightPattern *)XtMalloc(sizeof(highlightPattern) *
    	    HighlightDialog.nPatterns);
    for (i=0; i<HighlightDialog.nPatterns; i++)
    	copyPatternSrc(HighlightDialog.patterns[i], &patSet->patterns[i]);
    return patSet;
}

/*
** Return True if "patSet1" and "patSet2" differ
*/
static int patternSetsDiffer(patternSet *patSet1, patternSet *patSet2)
{
    int i;
    highlightPattern *pat1, *pat2;
    
    if (patSet1->lineContext != patSet2->lineContext)
    	return True;
    if (patSet1->charContext != patSet2->charContext)
    	return True;
    if (patSet1->nPatterns != patSet2->nPatterns)
    	return True;
    for (i=0; i<patSet2->nPatterns; i++) {
    	pat1 = &patSet1->patterns[i];
    	pat2 = &patSet2->patterns[i];
    	if (pat1->flags != pat2->flags)
    	    return True;
    	if (AllocatedStringsDiffer(pat1->name, pat2->name))
    	    return True;
    	if (AllocatedStringsDiffer(pat1->startRE, pat2->startRE))
    	    return True;
    	if (AllocatedStringsDiffer(pat1->endRE, pat2->endRE))
    	    return True;
    	if (AllocatedStringsDiffer(pat1->errorRE, pat2->errorRE))
    	    return True;
    	if (AllocatedStringsDiffer(pat1->style, pat2->style))
    	    return True;
    	if (AllocatedStringsDiffer(pat1->subPatternOf, pat2->subPatternOf))
    	    return True;
    }
    return False;
}

/*
** Copy a highlight pattern data structure and all of the allocated data
** it contains.  If "copyTo" is non-null, use that as the top-level structure,
** otherwise allocate a new highlightPattern structure and return it as the
** function value.
*/
static highlightPattern *copyPatternSrc(highlightPattern *pat,
    	highlightPattern *copyTo)
{
    highlightPattern *newPat;
    
    if (copyTo == NULL)
    	newPat = (highlightPattern *)XtMalloc(sizeof(highlightPattern));
    else
    	newPat = copyTo;
    newPat->name = CopyAllocatedString(pat->name);
    newPat->startRE = CopyAllocatedString(pat->startRE);
    newPat->endRE = CopyAllocatedString(pat->endRE);
    newPat->errorRE = CopyAllocatedString(pat->errorRE);
    newPat->style = CopyAllocatedString(pat->style);
    newPat->subPatternOf = CopyAllocatedString(pat->subPatternOf);
    newPat->flags = pat->flags;    
    return newPat;
}

static void freeNonNull(void *ptr)
{
    if (ptr != NULL)
    	XtFree((char *)ptr);
}

/*
** Free the allocated memory contained in a highlightPattern data structure
** If "freeStruct" is true, free the structure itself as well.
*/
static void freePatternSrc(highlightPattern *pat, int freeStruct)
{
    XtFree(pat->name);
    freeNonNull(pat->startRE);
    freeNonNull(pat->endRE);
    freeNonNull(pat->errorRE);
    freeNonNull(pat->style);
    freeNonNull(pat->subPatternOf);
    if (freeStruct)
    	XtFree((char *)pat);
}

/*
** Free the allocated memory contained in a patternSet data structure
** If "freeStruct" is true, free the structure itself as well.
*/
static void freePatternSet(patternSet *p)
{
    int i;
    
    for (i=0; i<p->nPatterns; i++)
    	freePatternSrc(&p->patterns[i], False);
    XtFree(p->languageMode);
    XtFree((char *)p->patterns);
    XtFree((char *)p);
}

/*
** Find the index into the HighlightStyles array corresponding to "styleName".
** If styleName is not found, return -1.
*/
static int lookupNamedStyle(char *styleName)
{
    int i;
    
    for (i=0; i<NHighlightStyles; i++)
    	if (!strcmp(styleName, HighlightStyles[i]->name))
    	    return i;
    return -1;
}

/*
** Write the string representation of int "i" to a static area, and
** return a pointer to it.
*/
static char *intToStr(int i)
{
    static char outBuf[12];
    
    sprintf(outBuf, "%d", i);
    return outBuf;
}
