/*
 * Copyright (c) 1994 Jim Rees
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by Jim Rees.
 * 4. The name of Jim Rees may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/* Boot flags */

#define bootflag_new_prom	0x1
#define bootflag_use_dtty	0x2	/* use dumb terminal */
#define bootflag_normal_mode	0x4
#define bootflag_auto_salvage	0x8
#define bootflag_use_dtty_2	0x10
#define bootflag_config_opt1	0x20	/* in otter this means have_pmmu */
#define bootflag_flow_ctl	0x40	/* use flow-controlled boot protocol */
#define bootflag_diskless	0x80	/* node booted from a network device */
#define bootflag_primary_valid	0x100	/* primary network ctype/cnum in bootflag_data_blk_t are valid */
#define bootflag_uuu9		0x200
#define bootflag_uuu10		0x400
#define bootflag_use_rmt	0x800	/* use remote terminal */
#define bootflag_ez		0x1000	/* EZ command was used */
#define bootflag_dl		0x2000	/* program was loaded via sio line */
#define bootflag_big_disp	0x4000
#define bootflag_ey		0x8000	/* EY command was used */

/* Prom data */

struct promd {
	u_short ctype;
	u_short unit;
	u_short lvno;
	u_short bflags;
};

/* Keys passed in to read_disk blockno arg for cartridge tape */

#define ct_rewind	-2
#define ct_ff		-1
#define ct_read		 0

typedef enum {
	ctype_winchester,
	ctype_floppy,
	ctype_ring_xmit,
	ctype_ring_rcv,
	ctype_smd,
	ctype_cartridge,
	ctype_ether,
	ctype_display,
} ctype_t;

extern char *
ctype_to_name(ctype_t ctype);

extern char *lowram;
extern unsigned int bootdev;
extern unsigned int partner_node_id;
