| Copyright (c) 1994 Regents of the University of Michigan.
| All rights reserved.

| Redistribution and use in source and binary forms are permitted provided
| that this notice is preserved and that due credit is given to the University
| of Michigan at Ann Arbor.  The name of the University may not be used to
| endorse or promote products derived from this software without specific
| prior written permission.  This software is provided ``as is'' without
| express or implied warranty.

| Written by Jim Rees.

	.text
	.globl begin
	.globl _lowram

	low =	0x13d800	| Where we might be loaded
	reloc =	0x1020000	| Where we're going to relocate to
	diff =	reloc-low	| The difference between the two

	.long	low
	.long	begin-diff
	.long	_edata-diff
	.long	0
	.ascii	"NetBSD boot"

	.data
_lowram:
	.long	reloc+0x10000

	.text
	.even
begin:
	pea	.		| Find out where we're running
	movel	sp@+,d0
	andl	#~0x3ff,d0	| round down to page boundary
	movel	d0,a0
|	moveal	#9,a1		| Turn on the cache
|	movec	a1,cacr
	movel	#reloc,a1
moveloop:			| Copy everything from low thru edata
	cmpl	#_edata,a1
	jcc	movedone
	movel	a0@+,a1@+
	jra	moveloop
movedone:
	lea	start,a0	| Jump to the relocated code
	jmp	a0@
start:
	movel	#_edata,a0	| Zero out bss
bssloop:
	cmpl	#_end,a0
	jcc	bssdone
	clrl	a0@+
	jra	bssloop
bssdone:
	jmp	_main		| Jump to the main program
