| Copyright (c) 1994 Regents of the University of Michigan.
| All rights reserved.

| Redistribution and use in source and binary forms are permitted provided
| that this notice is preserved and that due credit is given to the University
| of Michigan at Ann Arbor.  The name of the University may not be used to
| endorse or promote products derived from this software without specific
| prior written permission.  This software is provided ``as is'' without
| express or implied warranty.

| Written by Jim Rees.

	.text
	.even
	.globl _get_char
	.globl _put_char
	.globl _init_disk
	.globl _read_disk
	.globl _write_disk
	.globl __rtt
	.globl _trapf

_get_char:
	link a6,#0
	moveml d2-d7/a2-a6,sp@-	| Save everything...
	movel 0x104,a0		| Address of prom get_char() is stored here.
	jbsr a0@
	moveml sp@+,d2-d7/a2-a6	| Restore everything.
	movel d1,d0		| Result is returned in d1.
	unlk a6
	rts

_put_char:
	link a6,#0
	movel a6@(0x8),d1
	moveml d2-d7/a2-a6,sp@-
	movel 0x108,a0
	jbsr a0@
	moveml sp@+,d2-d7/a2-a6
	unlk a6
	rts

_init_disk:
	link	a6,#0
	moveml	d2-d7/a2-a6,sp@-
	movel	a6@(16),sp@-
	pea	a6@(14)
	pea	a6@(10)
	movel	0x10c,a0
	jbsr	a0@
	addl	#12,sp
	moveml	sp@+,d2-d7/a2-a6
	unlk	a6
	rts

_read_disk:
	link	a6,#0
	moveml	d2-d7/a2-a6,sp@-
	movel	a6@(20),sp@-
	movel	a6@(16),sp@-
	pea	a6@(14)
	pea	a6@(8)
	movel	0x110,a0
	jbsr	a0@
	addl	#16,sp
	moveml	sp@+,d2-d7/a2-a6
	unlk	a6
	rts

_write_disk:
	link	a6,#0
	moveml	d2-d7/a2-a6,sp@-
	movel	a6@(20),sp@-
	movel	a6@(16),sp@-
	pea	a6@(14)
	pea	a6@(8)
	movel	0x120,a0
	jbsr	a0@
	addl	#16,sp
	moveml	sp@+,d2-d7/a2-a6
	unlk	a6
	rts

__rtt:
	movel 0x11c,a0
	jmp a0@

_trapf:
	trap #0xf
	rts
