/*
Copyright (c) 1993 Regents of the University of Michigan.
All rights reserved.

Redistribution and use in source and binary forms are permitted provided
that this notice is preserved and that due credit is given to the University
of Michigan at Ann Arbor.  The name of the University may not be used to
endorse or promote products derived from this software without specific
prior written permission.  This software is provided ``as is'' without
express or implied warranty.

Written by Jim Rees.
*/

#include <sys/param.h>
#include <sys/reboot.h>
#include <a.out.h>

#include "stand.h"
#include "prom.h"
#include "../net/netboot.h"

/*
 * Net boot routines.  These replace the routines by the same names
 * in libsa.a.  You can only have one file open at a time.
 */

open(name, mode)
char *name;
int mode;
{
	boot_rqst_t hdr;
	static int fd;
	long st;

	init_disk(bootdev, 0, &st);
	if (st != 0) {
		prstatus("net init", st);
		return -1;
	}

	hdr.service = msg_boot_service;
	hdr.version = boot_version;
	hdr.machid = *(u_short *) 0x100;
	hdr.kind = boot_load_rqst;
	strcpy(hdr.name, name);

	if (send(partner_node_id, 0, &hdr, sizeof hdr, 0, 0) < 0)
		return -1;
	return ++fd;
}

close(fd)
int fd;
{
	return 0;
}

read(fd, bp, size)
int fd;
void *bp;
u_int size;
{
	static char *ct_bp;
	static int ct_cc;
	int cc = size, n;
	boot_reply_t hdr;
	static int seq, eof;

	while (cc) {
		if (ct_cc <= 0) {
			if (eof)
				break;
			if ((ct_cc = rcv(&hdr, &ct_bp)) < 0)
				_rtt();
			if (hdr.st != 0) {
				printf("%s\n", hdr.u.errmsg);
				_rtt();
			}
			if (hdr.u.u1.copy != 0x13d800 + seq * 0x400) {
				printf("lost packet %d\n", seq);
				_rtt();
			}
			eof = hdr.u.u1.eof;
			seq++;
		}
		n = (cc < ct_cc) ? cc : ct_cc;
		bcopy(ct_bp, bp, n);
		ct_bp += n;
		ct_cc -= n;
		bp += n;
		cc -= n;
	}
	return (size - cc);
}

off_t
lseek(fd, pos, how)
int fd, how;
off_t pos;
{
	return -1;
}

getpage(pagep, ppnp)
char **pagep;
short *ppnp;
{
	static char *page;
	static short ppn;
	static char buf[2 * 1024];

	if (page == 0) {
		/* Get a page-aligned buffer */
		page = (char *) ((int) buf + 1023 & ~0x3ff);
		ppn = (int) page >> 10;
	}
	*pagep = page;
	*ppnp = ppn;
}

send(nodeid, transid, hdr, hdrlen, dat, datlen)
int nodeid, transid;
char *hdr, *dat;
short hdrlen, datlen;
{
	static char *page;
	static short ppn;
	struct {
		boot_hdr_t bh;
		char hdr[256];
	} b;
	long st;

	if (page == 0)
		getpage(&page, &ppn);

	bzero(&b, sizeof b);
	b.bh.hdwr.toid = nodeid;
	b.bh.hdwr.pkttyp = pkt_user_mask;
	if (nodeid == 0)
		b.bh.hdwr.pkttyp |= pkt_brdcst_mask;
	b.bh.cntl.version = 1;
	b.bh.cntl.chksum = 1;
	b.bh.cntl.pkttyp = b.bh.hdwr.pkttyp;
	b.bh.cntl.hdrlen = hdrlen + sizeof b.bh;
	b.bh.cntl.hdrdatlen = hdrlen;
	b.bh.cntl.transid = transid;
	b.bh.lnth = 4;
	b.bh.curr = 1;
	b.bh.route[0] = nodeid;
	b.bh.route[1] = network_netman_sock;

	bcopy(hdr, b.hdr, hdrlen);
	bcopy(dat, page, datlen);

	write_disk(0, ppn, &b, &st);
	if (st != 0) {
		prstatus("net send", st);
		return -1;
	}
	return datlen;
}

rcv(hdr, bp)
char *hdr, **bp;
{
	static char *page;
	static short ppn;
	struct {
		boot_hdr_t bh;
		char hdr[256];
	} b;
	long st;

	if (page == 0)
		getpage(&page, &ppn);

	bzero(&b, sizeof b);
	read_disk(0, ppn, &b, &st);
	if (st != 0) {
		prstatus("net rcv", st);
		return -1;
	}
	bcopy(b.hdr, hdr, b.bh.cntl.hdrdatlen);
	if (bp != NULL)
		*bp = page;
	return b.bh.cntl.datlen;
}
