/* Nickolai Zeldovich, 1996 */

#define FIGSIZE 30     

#include "/sys/ins/base.ins.c"
#include "/sys/ins/gpr.ins.c"
#include "/sys/ins/error.ins.c"
#include "/sys/ins/time.ins.c"
#include "/sys/ins/kbd.ins.c"
#include<sys/types.h>
#include<sys/socket.h>
#include<netinet/in.h>
#include<netdb.h>          
#include<stdio.h>
#include<math.h>
#include "config.h"                 

status_$t                  status;
gpr_$bitmap_desc_t         display_bitmap;
gpr_$offset_t              display_bitmap_size;
gpr_$rgb_plane_t           hi_plane;
gpr_$disp_char_t           display_characteristics;
gpr_$position_t            position;   

void check(messagex )
char *messagex;
{
if (status.all) { error_$print(status); printf("Error occured while $s.\n",messagex);
}
}

void pause(t)
float t;
{ time_$clock_t time;
time.high16=0;time.low32=250000*t;time_$wait(time_$relative,time,status);
check("pausing");
}

void init(mode)

gpr_$display_mode_t mode;
{
static short int unit=1;
static short int disp_len=sizeof(gpr_$disp_char_t);
       short int disp_len_returned;
       short int unobscured;
gpr_$inq_disp_characteristics(mode,unit,disp_len,display_characteristics,disp_len_returned,status);
check("in init after inquiring");
display_bitmap_size.x_size=display_characteristics.x_window_size;
display_bitmap_size.y_size=display_characteristics.y_window_size; 
hi_plane=display_characteristics.n_planes-1;
gpr_$init(mode,unit,display_bitmap_size,hi_plane,display_bitmap,status);
check("in init after initializing");
}

draw_wall(c,x,y)
gpr_$pixel_value_t c;
short int x,y;
{                                
gpr_$window_t window;
window.window_base.x_coord=x;
window.window_base.y_coord=y;
window.window_size.x_size=FIGSIZE-1;
window.window_size.y_size=FIGSIZE-1;
gpr_$set_fill_value(c,status); 
gpr_$rectangle(window,status);
}

main(argc,argv)
   int argc;
   char *argv[];
{
int sock;
struct sockaddr_in server;
struct hostent *hp, *gethostbyname();
char buf[BUFSIZE];         
int x1,x,y1,y;           
gpr_$pixel_value_t BGC,FGC;

BGC=0;
FGC=13;                          

if (argc != 2) {
   fprintf(stderr,"Usage: dld <gld server>\n");
   exit(3);
}

init(gpr_$borrow);
            
gpr_$clear(BGC,status);
gpr_$set_draw_value(FGC,status); 

sock=socket(AF_INET,SOCK_STREAM,0);

server.sin_family=AF_INET;
hp=gethostbyname(argv[1]);
if (hp == 0) {
   fprintf(stderr,"%s: unknown host\n",argv[1]);
   exit(1);
}

bcopy(hp->h_addr, &server.sin_addr, hp->h_length);
server.sin_port=htons(SOCKNO);

if (connect(sock,&server,sizeof(server))<0) {
   perror("connecting stream socket");
   exit(2);
}

bzero(buf,sizeof(buf));
read(sock,buf,sizeof("REACK"));
if (strcmp(buf,"REACK")) {
   printf("The server did NOT return REACK!\nThe server returned %s.\n",buf);
} else {
   printf("The server returned REACK.\n");
}
send(sock,"ACK",sizeof("ACK"),0);

do { 
  bzero(buf,sizeof(buf));       
  read(sock,buf,4);

  buf[1]=buf[1]-65;
  buf[2]=buf[2]-65;
  buf[3]=buf[3]-65;
                                      
  x1=buf[2];
  y1=buf[3];

  x=FIGSIZE*x1;
  y=FIGSIZE*y1;

  if (buf[0]=='N') {   
     if (buf[1]==WALL) draw_wall(4,x,y);
     if (buf[1]==RED) draw_wall(1,x,y);
     if (buf[1]==GREEN) draw_wall(2,x,y);
     if (buf[1]==BLUE) draw_wall(3,x,y);    
  }
 
  if (buf[0]=='E') {
     if (buf[1]==WALL) draw_wall(BGC,x,y);
     if (buf[1]==RED) draw_wall(BGC,x,y);
     if (buf[1]==GREEN) draw_wall(BGC,x,y);
     if (buf[1]==BLUE) draw_wall(BGC,x,y);  
  }                               
  send(sock,"ACK",sizeof("ACK"),0);
 
} while (1);
}
