/* Nickolai Zeldovich, 1996 */

/************************************************************************
 *									*
 *    LLD.C								*
 *									*
 *	Local Daemon, one per every computational node.			*
 *									*
 ************************************************************************/

#include<sys/types.h>
#include<sys/socket.h>
#include<netinet/in.h>
#include<netdb.h>
#include<stdio.h>

#include "config.h"

int main(argc,argv)
   int argc;
   char *argv[];
{
int sock,croc_sock;
struct sockaddr_in server,server_copy,croc_server;
struct hostent *hp, *gethostbyname();
char *buf;
signed char *net1;
signed char *net2;
signed char *net3;
signed char *map1;
signed char *map2;
signed char *map3;
signed char *map4;
long int sum;
int i,j,k;
long int S1,S2,S3;
int quit;

quit = 0;

buf = calloc(BUFSIZE,sizeof(char));         

if (argc != 2) {
   fprintf(stderr,"Usage: lld <gld server>\n");
   exit(3);
}

S1 = SIZE1*SIZE1;
S2 = SIZE2*SIZE2;
S3 = SIZE3*SIZE3;

sock=socket(AF_INET,SOCK_STREAM,0);

server.sin_family=AF_INET;
hp=gethostbyname(argv[1]);
if (hp == 0) {
   fprintf(stderr,"%s: unknown host\n",argv[1]);
   exit(1);
}

bcopy(hp->h_addr, &server.sin_addr, hp->h_length);
server.sin_port=htons(SOCKNO);

server_copy=server;

if (connect(sock,&server,sizeof(server))<0) {
   perror("connecting stream socket");
   exit(2);
}

bzero(buf,BUFSIZE);
read(sock,buf,sizeof("REACK"));
if (strcmp(buf,"REACK")) {
   printf("The server did NOT return REACK!\nThe server returned %s.\n",buf);
}
send(sock,"ACK",sizeof("ACK"),0);

do {
   bzero(buf,BUFSIZE);
   read(sock,buf,sizeof("FORK"));
   if (!(strcmp(buf,"FORK"))) {
      if (fork()==0) {
         buf = calloc(BUFSIZE,sizeof(char));                          
         croc_sock=socket(AF_INET,SOCK_STREAM,0);
         croc_server=server_copy;
         connect(croc_sock,&croc_server,sizeof(croc_server));  
         bzero(buf,BUFSIZE);
         read(croc_sock,buf,sizeof("REACK")); 
         send(croc_sock,"ACK",sizeof("ACK"),0);
         net1=calloc(S1*S2*4,sizeof(short int));
         net2=calloc(S3*S2*4,sizeof(short int));
         net3=calloc(S3*2,sizeof(short int));
         map1=calloc(S1*4,sizeof(short int));
         map2=calloc(S2*4,sizeof(short int));
         map3=calloc(S3,sizeof(short int));
         map4=calloc(2,sizeof(short int));
bzero(buf,BUFSIZE);
         read(croc_sock,buf,S1*S2*4*sizeof(signed char));
         memcpy(net1,buf,S1*S2*4*sizeof(signed char));
bzero(buf,BUFSIZE);
         read(croc_sock,buf,S3*S2*4*sizeof(signed char));
         memcpy(net2,buf,S3*S2*4*sizeof(signed char));
bzero(buf,BUFSIZE);
         read(croc_sock,buf,S3*2*sizeof(signed char));
         memcpy(net3,buf,S3*2*sizeof(signed char)); 
         do {
bzero(buf,BUFSIZE);
            read(croc_sock,buf,sizeof("STAR"));
            if (!(strcmp(buf,"EXIT"))) {
               close(croc_sock); 
               free(map1);
               free(map2);
               free(map3);
               free(map4);
               free(net1);
               free(net2);
               free(net3); 
               free(buf);
               quit=1;
            } else
            if (!(strcmp(buf,"STAR"))) {
bzero(buf,BUFSIZE);
               read(croc_sock,buf,S1*4*sizeof(signed char));
               memcpy(map1,buf,S1*4*sizeof(signed char)); 
               for (i=0;i<4;i++) {
                  for (j=0;j<S2;j++) {
                     sum=0;
                     for (k=0;k<S1;k++) {
                        sum+=(map1[i*S1+k]*2-1)*net1[i*S1*S2+S1*k+j];
                     }
                     if(sum<=0) {
                        map2[i*S2+j]=0;
                     } else {
                        map2[i*S2+j]=1;
                     }
                  }
               }
               for(i=0;i<S3;i++) {
                     sum=0;
                  for(j=0;j<4;j++) {
                     for(k=0;k<S2;k++) {
                        sum+=(map2[j*S2+k]*2-1)*net2[j*S2*S3+S2*i+k];
                     }
                  }
                     if(sum<=0) {
                        map3[i]=0;
                     } else {
                        map3[i]=1;
                     }
               }
               for(i=0;i<2;i++) {
                  sum=0;
                  for(j=0;j<S3;j++) {
                     sum+=(map3[j]*2-1)*net3[i*S3+j];
                  }
                  if(sum<=0) {
                     map4[i]=0;
                  } else {
                     map4[i]=1;
                  }
               }
               /* FINISHED! */
               buf[0]=map4[0]*2+map4[1];
               buf[1]='\0';
               send(croc_sock,buf,1,0);      
bzero(buf,BUFSIZE);
               read(croc_sock,buf,sizeof("ACK"));
            } else
            if (!(strcmp(buf,"INFO"))) {
               send(croc_sock,net1,S1*S2*4*sizeof(signed char),0);
               send(croc_sock,net2,S2*S3*4*sizeof(signed char),0);
               send(croc_sock,net3,S3*2*sizeof(signed char),0);
            }
            if (!(strcmp(buf,"PUTI"))) {
bzero(buf,BUFSIZE);
         read(croc_sock,buf,S1*S2*4*sizeof(signed char));
         memcpy(net1,buf,S1*S2*4*sizeof(signed char));
bzero(buf,BUFSIZE);
         read(croc_sock,buf,S3*S2*4*sizeof(signed char));
         memcpy(net2,buf,S3*S2*4*sizeof(signed char));
bzero(buf,BUFSIZE);
         read(croc_sock,buf,S3*2*sizeof(signed char));
         memcpy(net3,buf,S3*2*sizeof(signed char)); 
            }
         } while (quit==0);
      }
   } else
   if (!(strcmp(buf,"EXIT"))) {
      close(sock);
      quit=1;
   }
} while (quit==0);
return 0;
}
