#ifndef PARSELIB_INC_FLAG

   #define PARSELIB_INC_FLAG
 
   #include <stdio.h>

   #ifndef BOOLEAN_T
      #define  BOOLEAN_T
      typedef  char                 Boolean_t ;
      #ifndef TRUE
         #define  TRUE              1
         #define  FALSE             0
      #endif
   #endif
 
   #define PARSE_TOK_TEXT          1
   #define PARSE_TOK_STRING        2
   #define PARSE_TOK_INTEGER       3
   #define PARSE_TOK_SPECIAL       4
 
   #define PARSE_END_NOTEND        1
   #define PARSE_END_ENDLINE       2
   #define PARSE_END_ENDFILE       3
 
   #define PARSE_INP_TEXT          1
   #define PARSE_INP_STRING        2
   #define PARSE_INP_INTEGER       3
   #define PARSE_INP_FILENAME      4
 
   #define PARSE_STR_NQUOTE        0
   #define PARSE_STR_SQUOTE        1
   #define PARSE_STR_DQUOTE        2
 
   #define PARSE_CVT_NONE          0
   #define PARSE_CVT_LOWER         1
   #define PARSE_CVT_UPPER         2

   typedef char                         Parse_toktype_t ;
   typedef char                         Parse_endtype_t ;
   typedef char                         Parse_inptype_t ;
   typedef char                         Parse_strtype_t ;
 
   struct Parse_string_list_t  { char                            *strptr    ;
                                 struct Parse_string_list_t      *next      ;
                                                                              } ;
 
   typedef struct Parse_string_list_t     Parse_string_list_t     ;
   typedef        Parse_string_list_t    *Parse_string_list_ptr_t ;

   struct Parse_input_tmp_t    { char                            *strptr    ;
                                 short                            strlen    ;
                                 short                            lineno    ;
                                 short                            posit     ;
                                 short                            blanks    ;
                                 short                            trails    ;
                                 short                            options   ;
                                 Parse_toktype_t                  toktype   ;
                                 Parse_strtype_t                  strtype   ;
                                 Parse_endtype_t                  endtype   ;
                                 Boolean_t                        begflag   ;
                                 struct Parse_input_tmp_t        *next      ;
                                 Boolean_t                        used      ;
                                                                             } ;
 
   struct Parse_simple_tmp_t   { char                       *search    ;
                                 Boolean_t                   insens    ;     /* not implemented */
                                 Parse_inptype_t             inptype   ;     /* not implemented */
                                 Boolean_t                   required  ;
                                 Boolean_t                   found     ;
                                 short                       lineno    ;
                                 short                       posit     ;
                                 short                       convert   ;
                                 Parse_inptype_t             outtype   ;     /* not implemented */
                                 char                       *string    ;
                                                                         } ;
 
   struct Parse_argument_tmp_t { char                       *strptr    ;
                                 short                       strlen    ;
                                 short                       lineno    ;
                                 short                       posit     ;
                                                                         } ;
 
   struct Parse_comment_tmp_t  { Boolean_t                  pound      ;      /* #  = comment   */
                                 Boolean_t                  slashd     ;      /* // = comment   */
                                 Boolean_t                  slashs     ;      /* /-* = comment  */
                                 Boolean_t                  pastyp     ;      /* pascal { }     */
                                                                         } ;

   typedef struct Parse_input_tmp_t            Parse_input_t        ;
   typedef        Parse_input_t               *Parse_input_ptr_t    ;

   typedef struct Parse_simple_tmp_t           Parse_simple_t       ;
   typedef        Parse_simple_t              *Parse_simple_ptr_t   ;

   typedef struct Parse_argument_tmp_t         Parse_argument_t     ;
   typedef        Parse_argument_t            *Parse_argument_ptr_t ;
 

   typedef struct Parse_comment_tmp_t          Parse_comment_t      ;
 
 
   short                   Parse_index(char *string, char search)                              ;

   Parse_input_ptr_t       Parse_check(Parse_input_ptr_t *pointer)                             ;

   Parse_argument_ptr_t    Parse_argument(Parse_input_ptr_t *pointer)                          ;

   Parse_argument_ptr_t    Parse_token(Parse_input_ptr_t *pointer)                             ;

   Parse_argument_ptr_t    Parse_filename(Parse_input_ptr_t *pointer)                          ;
 
   Boolean_t               Parse_strcmp(char *string1, char *string2, Boolean_t insens)        ;

   void                    Parse_release(Parse_input_ptr_t pointer)                            ;

   short                   Parse_next(Parse_input_ptr_t *pointer)                              ;

   int                     Parse_save(char *string, short *strlen)                             ;

   void                    Parse_lower(char *string)                                           ;

   void                    Parse_upper(char *string)                                           ;

   void                    Parse_debug(Parse_input_ptr_t  pointer)                             ;
 
   void                    Parse_error_install( int (*output_routine)(Boolean_t, char *) )     ;
 
   void                    Parse_error(Boolean_t fatal, char *string)                          ;

   Parse_input_ptr_t       Parse_file(FILE *finp, Parse_comment_t comments)                    ;
 
   Parse_input_ptr_t       Parse_linklist(Parse_string_list_ptr_t linklist,
                                          Parse_comment_t         comments )                   ;
 
   void                    Parse_linklist_debug(Parse_string_list_ptr_t linklist)              ;

   Parse_simple_ptr_t      Parse_simple_alloc(short  count)                                    ;
 
   void                    Parse_simple_release()                                              ;
 
   void                    Parse_linklist_release(Parse_string_list_ptr_t linklist)            ;
 
   Boolean_t               Parse_strcmp(char *string1, char *string2, Boolean_t insens)        ;

   Boolean_t               Parse_simple_parse(Parse_simple_ptr_t  point,
                                              Parse_input_ptr_t   input )                      ;
 
   short                   Parse_reserved_word(char *string)                                   ;

#endif
