#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "CliLib.h" 
#include "ParseLib.h" 

#include "CliLib.c"
#include "ParseLib.c" 

#define  MAX_AFTER_WITH     25

short     strchk(char *str1, char *str2)
{
   short      i = 0 ;
   char       ch1   ;
   char       ch2   ;
   
   for( i=0 ; 1 ; i++ )
   {
      ch1 = str1[i] ;
      ch2 = str2[i] ; 
      
      ch1 = ch1 >= 'a' && ch1 <= 'z' ? ch1 - ' ' : ch1 ;    /* force upper case           */
      ch2 = ch2 >= 'a' && ch2 <= 'z' ? ch2 - ' ' : ch2 ;    /* force upper case           */
      
      if( ch1 == ch2 )
      {
         if( ch1 == '\0' )
            return 0 ;
      }
      
      else
         return 1 ;
   }
}   
         

void main(short argc, char **argv)
{
   short                     i                          ;

   char                      filename[1024]             ;
   short                     fileleng                   ;
   FILE                     *filedesc                   ;
   Parse_input_ptr_t         filepntr                   ;
   Parse_input_ptr_t         filewalk                   ;
   Parse_input_ptr_t         filelast                   ; 
   Parse_input_ptr_t         filesave                   ;  
   Parse_input_ptr_t         fileprev                   ;
   Parse_input_ptr_t         filetemp                   ;
   Parse_input_ptr_t         filehold                   ;
   Parse_input_ptr_t         filecoln                   ;
   Parse_input_ptr_t         filesemi                   ;
   Parse_input_ptr_t         filestrt                   ;
   Parse_comment_t           comments                   ;
   Parse_input_ptr_t         token                      ;
   Parse_input_ptr_t         token_1                    ;
   Parse_input_ptr_t         token_2                    ;
   Parse_input_ptr_t         token_3                    ;
   Boolean_t                 comma_flag                 ;   
   char                      output  [1024]             ;
   short                     count                      ; 

   Cli_startup("PAS2CC", "Alpha", argc, argv) ;
 
   fileleng = Cli_get_file(filename) ;                                  /* get the filename             */
   if( fileleng == 0 )                                                  /* filename missing             */
   {
      printf("Invocation requires a FILENAME") ;                        /* inform user of problem       */
      exit(2)                                  ;                        /* die                          */
   }
 
   /* attempt to open the file */
 
   filedesc = fopen(filename, "r") ;                                    /* open input file              */
   if( filedesc == 0 )                                                  /* couldnt open file            */
   {
      printf("Input file is unavailable: '%s'.\n", filename) ;
      exit(2)                                                ;
   }
 
   comments.pound  = FALSE ;
   comments.slashd = TRUE  ;
   comments.slashs = TRUE  ;
   comments.pastyp = TRUE  ;

   filepntr = Parse_file(filedesc, comments) ;
   if     ( filepntr == (Parse_input_ptr_t) -1 )
   {
      printf("Internal Error encountered\n") ;
      exit(2)                                ;
   }

   else if( filepntr == NULL                   )
   {
      printf("ParseLib returns NULL: is file empty?\n") ;
      exit(2)                                           ;
   }
   
   fclose(filedesc) ; 

#if 0 
   filewalk = filepntr ;  Parse_debug(filewalk) ;   
#endif
   
   /* change the obvious keywords */

   filewalk = filepntr ;
   filelast = NULL     ;
   
   while( filewalk )
   {
      fileprev = filewalk                 ;
      
      token    = Parse_check( &filewalk ) ;
      
      filesave = filewalk                 ;
      filetemp = filewalk                 ;
      
      token_1  = Parse_check( &filesave ) ;
      token_2  = Parse_check( &filesave ) ;
      token_3  = Parse_check( &filesave ) ;
      
      if     ( token == NULL )
         break ;
         
      /* have a special case when '/' or '\'  */
      
      else if( token->toktype == PARSE_TOK_STRING )
      {
         if( token->strtype == PARSE_STR_SQUOTE )
         {
            if     ( strchk(token->strptr, "/") == 0 )
            {
               token->strptr  = "FSLASH_CH"    ;
               token->strlen  =  9             ;
               token->toktype = PARSE_TOK_TEXT ;
            }
             
            else if( strchk(token->strptr, "\\") == 0 )
            {
               token->strptr  = "BSLASH_CH"    ;
               token->strlen  =  9             ;
               token->toktype = PARSE_TOK_TEXT ;
            }
             
            else if( strchk(token->strptr, "~") == 0 )
            {
               token->strptr  = "TILDE_CH"     ;
               token->strlen  =  8             ;
               token->toktype = PARSE_TOK_TEXT ;
            }
         }
         
         continue ;
      }
         
      else if( ! ( token->strlen > 0 ) )
         continue ;
      
      if     ( strchk(token->strptr, "BEGIN"     ) == 0 )
      {
         token->strptr = "{"                ;
         token->strlen =  1                 ;
      }
         
      else if( strchk(token->strptr, "END"       ) == 0 ) 
      {
         token->strptr  = "}"               ;
         token->strlen  =  1                ; 
         
         if( token_1 )
         {
            if( strchk(token_1->strptr, ";") == 0 )
            {
               token_1->strptr = "" ;
               token_1->strlen = 0  ;
            }
         }
      }
      
      else if( strchk(token->strptr, "ARRAY"     ) == 0 )
      {     
         while( filetemp )
         {
            token_1  = Parse_check( &filetemp ) ;
      
            if     ( token_1 == NULL )
               break ;
               
            else if( strchk(token_1->strptr, ";" ) == 0 )
               break ;
               
            else if( strchk(token_1->strptr, "OF") == 0 )
            {
               token_1->strptr = "TYPE->" ;
               token_1->strlen =  6       ;
               break                      ;
            }
         }
      }
      
      else if( strchk(token->strptr, "WITH"     ) == 0 )
      {
         token->strptr = "WITH BLOCK ->" ;
         token->strlen = 13              ;         
         count         = 0               ;
              
         while( filetemp )
         {
            token_1 = Parse_check( &filetemp ) ;
      
            if     ( token_1 == NULL )
               break ; 
               
            else if( ++count > MAX_AFTER_WITH )
            {
               printf("COUNT > MAX_AFTER_WITH (%d) - BREAKING OUT\n", MAX_AFTER_WITH) ;
               break                                                                  ;
            }
               
            else if( strchk(token_1->strptr, "DO" ) == 0 )
            {
               token_1->strptr = ""                       ;
               token_1->strlen =  0                       ;
               token_1->blanks =  0                       ;
               
               token_2         = Parse_check( &filetemp ) ;
               
               if     ( token_2 == NULL )
                  break ;
                  
               else if( strchk(token_2->strptr, "BEGIN") == 0 )
               {
                  token_2->strptr   = "BEGINS {"        ;
                  token_2->strlen   =  8                ;
               }
               
               else 
               {
                  token_1->strptr = "BEGINS " ;
                  token_1->strlen =  8        ;
               }
               
               break ;
            }
         }
      }
      
      else if( strchk(token->strptr, "CONST"     ) == 0 ||
               strchk(token->strptr, "TYPE"      ) == 0    )
      {   
         while( filetemp )
         {
            token_1  = Parse_check( &filetemp ) ;
            
            if     ( token_1 == NULL )
               break ;
               
            else if( strchk(token_1->strptr, "TYPE"     ) == 0 ||
                     strchk(token_1->strptr, "CONST"    ) == 0 ||
                     strchk(token_1->strptr, "DEFINE"   ) == 0 ||
                     strchk(token_1->strptr, "MODULE"   ) == 0 ||
                     strchk(token_1->strptr, "VAR"      ) == 0 ||
                     strchk(token_1->strptr, "FUNCTION" ) == 0 ||
                     strchk(token_1->strptr, "PROCEDURE") == 0    )
               break ;           
                     
            else if( strchk(token_1->strptr, "=" ) == 0 )
               token_1->strlen = -1 ;  
         }
      }
      
      else if( strchk(token->strptr, "VAR"       ) == 0 )
      {       
         token->strptr = ""       ;
         token->strlen = 0        ;
         token->blanks = 0        ;
         
         filestrt      = filetemp ;
         filecoln      = NULL     ;
         filesemi      = NULL     ;
         
         comma_flag    = FALSE    ;
         
         while( filetemp )
         {
            filehold = filetemp                 ;
            token_1  = Parse_check( &filetemp ) ;             
          
            if     ( token_1 == NULL )
               break ;
               
            else if( strchk(token_1->strptr, "%"        ) == 0 ||
                     strchk(token_1->strptr, "TYPE"     ) == 0 ||
                     strchk(token_1->strptr, "BEGIN"    ) == 0 ||
                     strchk(token_1->strptr, "CONST"    ) == 0 ||
                     strchk(token_1->strptr, "DEFINE"   ) == 0 ||
                     strchk(token_1->strptr, "MODULE"   ) == 0 ||
                     strchk(token_1->strptr, "VAR"      ) == 0 ||
                     strchk(token_1->strptr, "FUNCTION" ) == 0 ||
                     strchk(token_1->strptr, "PROCEDURE") == 0    )
            {
               break ;
            }
            
            /* we have to change ^ in declarations to * in order to
               prevent the ^ conversion later                       */           
                     
            else if( strchk(token_1->strptr, "^" ) == 0 )
            {
               token_1->strptr = "*"   ;
               comma_flag      = FALSE ;
            }           
                     
            else if( strchk(token_1->strptr, ":" ) == 0 )
            {
               filecoln   = filehold ;
               comma_flag = FALSE    ;
            }           
                     
            else if( strchk(token_1->strptr, "," ) == 0 )
               comma_flag = TRUE ;
               
            else if( strchk(token_1->strptr, ";" ) == 0 )
            {
               /* check if we have a colon */
               
               if( filecoln == NULL )
               {
                  printf("NOTICE: Located the semi-colon but not the colon in a declaration\n") ;
                  break                                                                         ;
               }
              
               filesemi   = filehold ;
               comma_flag = FALSE    ; 
               
               /* at this point filestrt points to the first argument of the declaration,
                  filecoln points to the colon and filesemi points to the semicolon       */
#if 0                  
               printf("FILEPREV        %s\n", fileprev->strptr) ;
               printf("FILESTRT        %s\n", filestrt->strptr) ;
               printf("FILECOLN        %s\n", filecoln->strptr) ;
               printf("FILESEMI        %s\n", filesemi->strptr) ;
#endif                                                          
               fileprev->next->blanks = 1                       ;
               fileprev->next         = filecoln->next          ;
               fileprev->next->blanks = 0                       ;
               filecoln->next         = filesemi->next          ;
               filecoln->strptr       = ";"                     ;
               filecoln->blanks       =  1                      ;
               count                  = filecoln->endtype       ;
               filecoln->endtype      = filesemi->endtype       ;                
               
               filesemi->next         = filestrt                ;
               filesemi->strptr       = ""                      ;
               filesemi->strlen       = 0                       ;
               filesemi->endtype      = (Parse_endtype_t) count ;

#if 0
printf("DUMPING TEXT -> ") ;               
filestrt = fileprev ;
while( filestrt )
{
   if( filestrt->blanks )
   {
      for( count=0 ; count < filestrt->blanks ; count++ )
         printf(" ") ;
   }
   
   if( filestrt->strlen )
      printf("%s", filestrt->strptr) ;
      
   if( filestrt->endtype == PARSE_END_ENDLINE )
     printf("\n\n") ;
     
   if( filestrt == filecoln )
      break ;

   filestrt = filestrt->next ;
}
#endif                 
               
               fileprev               = filecoln         ;
               filestrt               = filetemp         ;
               filecoln               = NULL             ;
               filesemi               = NULL             ;
            }
            
            else if( comma_flag )
            {
               comma_flag      = FALSE ;
               token_1->blanks = 1     ;
            }                                
         }
      }      
      
      else if( strchk(token->strptr, "CHR"       ) == 0 )
      {
         if( token_1 && token_2 && token_3 )
         {
            if( strchk(token_1->strptr, "(") == 0 &&
                strchk(token_2->strptr, "0") == 0 && 
                strchk(token_3->strptr, ")") == 0    )
            {
               token->strptr    = "'\\0'"        ;
               token->strlen    =  4             ;
               token_1->strptr  = ""             ;
               token_1->strlen  =  0             ;
               token_1->toktype = PARSE_TOK_TEXT ;
               token_2->strptr  = ""             ;
               token_2->strlen =  0              ;
               token_2->toktype = PARSE_TOK_TEXT ;
               token_3->strptr  = ""             ;
               token_3->strlen =  0              ; 
               token_3->toktype = PARSE_TOK_TEXT ;
            }
         }
      }
      
      else if( strchk(token->strptr, "PACKED"    ) == 0 ) 
      {
         token->strptr = "" ;
         token->strlen = 0  ;
         token->blanks = 0  ;
      } 
      
      else if( strchk(token->strptr, "RECORD"    ) == 0 ) 
      {
         token->strptr = "{" ;
         token->strlen =  1  ;
      }  
      
      else if( strchk(token->strptr, "ELSE"      ) == 0 ) 
      {
         token->strptr = "else"             ;
         token->strlen =   4                ;
      }  
      
      else if( strchk(token->strptr, "NIL"       ) == 0 ) 
      {
         token->strptr = "NULL" ;
         token->strlen =   4    ;
      }
      
      else if( strchk(token->strptr, "IF"        ) == 0 ) 
      {
         token->strptr = "if(" ;
         token->strlen =   3   ;
      }
      
      else if( strchk(token->strptr, "THEN"      ) == 0 ) 
      {
         token->strptr = ")"               ;
         token->strlen =  1                ;
      } 
      
      else if( strchk(token->strptr, "NEXT"      ) == 0 ) 
      {
         token->strptr = "continue" ;
         token->strlen =     8      ;
      }  
      
      else if( strchk(token->strptr, "AND"       ) == 0 ) 
      {
         token->strptr = "&&" ;
         token->strlen =   2  ;
      }  
      
      else if( strchk(token->strptr, "OR"        ) == 0 ) 
      {
         token->strptr = "||" ;
         token->strlen =   2  ;
      }   
      
      else if( strchk(token->strptr, "GOTO"      ) == 0 ) 
      {
         token->strptr = "goto" ;
         token->strlen =   4    ;
      }  
      
      else if( strchk(token->strptr, "RETURN"    ) == 0 ) 
      {
         token->strptr = "return" ;
         token->strlen =    6     ;
      }   
      
      else if( strchk(token->strptr, "INTEGER"   ) == 0 ) 
      {
         token->strptr = "short" ;
         token->strlen =    5    ;
      }     
      
      else if( strchk(token->strptr, "REPEAT"    ) == 0 ) 
      {
         token->strptr = "do {" ;
         token->strlen =   4    ;
      }   
      
      else if( strchk(token->strptr, "UNTIL"     ) == 0 ) 
      {
         token->strptr = "} UNTIL (" ;
         token->strlen =      9      ;
      }   
      
      else if( strchk(token->strptr, "CASE"      ) == 0 ) 
      {
         token->strptr = "switch(" ;
         token->strlen =      7    ;
      }    
      
      else if( strchk(token->strptr, "OF"        ) == 0 ) 
      {
         token->strptr = ") {" ;
         token->strlen =   3   ;
      }     
      
      else if( strchk(token->strptr, "WHILE"     ) == 0 ) 
      {
         token->strptr = "while(" ;
         token->strlen =    6     ;
      }      
      
      else if( strchk(token->strptr, "OTHERWISE" ) == 0 ) 
      {
         token->strptr = "default:" ;
         token->strlen =     8      ;
      }    
      
      else if( strchk(token->strptr, "DO"        ) == 0 ) 
      {
         token->strptr = ")" ;
         token->strlen =  1  ;
      }     
      
      else if( strchk(token->strptr, "FOR"       ) == 0 ) 
      {
         token->strptr = "for(" ;
         token->strlen =   4    ;
      }      
      
      else if( strchk(token->strptr, "TRUE"      ) == 0 ) 
      {
         token->strptr = "TRUE" ;
         token->strlen =   4    ;
      }     
      
      else if( strchk(token->strptr, "FALSE"     ) == 0 ) 
      {
         token->strptr = "FALSE" ;
         token->strlen =    5    ;
      }      
      
      else if( strchk(token->strptr, "EXIT"      ) == 0 ) 
      {
         token->strptr = "break" ;
         token->strlen =    5    ;
      }      
      
      else if( strchk(token->strptr, "NOT"       ) == 0 ) 
      {
         token->strptr = "!" ;
         token->strlen =  1  ;
      }
      
      /* change multiple token lines */
      
      else if( strchk(token->strptr, ":") == 0 && token_1 )
      {
         if( strchk(token_1->strptr, "=") == 0 )
         {
            token->strptr   = "=" ;
            token->strlen   =  1  ;
            
            token_1->strptr = ""  ;
            token_1->strlen =  0  ;
            token_1->blanks =  0  ;
         }
      } 
      
      else if( strchk(token->strptr, "=") == 0 && token_1 )
      {
         if( strchk(token_1->strptr, ">") == 0 )
         {
            token->strptr   = "=>" ;
            token->strlen   =   2  ;
            
            token_1->strptr = ""   ;
            token_1->strlen =  0   ;
            token_1->blanks =  0   ;
         }
         
         else
         {
            token->strptr = "==" ;
            token->strlen =   2  ;
         }         
      }
      
      else if( strchk(token->strptr, ">") == 0 && token_1 )
      {
         if( strchk(token_1->strptr, "=") == 0 )
         {
            token->strptr   = ">=" ;
            token->strlen   =   2  ;
            
            token_1->strptr = ""   ;
            token_1->strlen =  0   ;
            token_1->blanks =  0   ;
         }
      }  
      
      else if( strchk(token->strptr, "<") == 0 && token_1 )
      {
         if     ( strchk(token_1->strptr, ">") == 0 )
         {
            token->strptr   = "!=" ;
            token->strlen   =   2  ;
            
            token_1->strptr = ""   ;
            token_1->strlen =  0   ;
            token_1->blanks =  0   ;
         }
         
         else if( strchk(token_1->strptr, "=") == 0 )
         {
            token->strptr   = "<=" ;
            token->strlen   =   2  ;
            
            token_1->strptr = ""   ;
            token_1->strlen =  0   ;
            token_1->blanks =  0   ;
         }
      }       
      
      /* three level tokens */
      
      else if( strchk(token->strptr, "%") == 0 && token_1 )
      {
         if( strchk(token_1->strptr, "eject") == 0 && token_2 )
         {
            if( strchk(token_2->strptr, ";") == 0 )
            {
               token->strptr   = "" ;
               token->strlen   =  0 ;
               token->blanks   =  0 ;
               
               token_1->strptr = "" ;
               token_1->strlen =  0 ;
               token_1->blanks =  0 ;
               
               token_2->strptr = "" ;
               token_2->strlen =  0 ;
               token_2->blanks =  0 ;
            }
         }
      }
      
      if( token_1 )
      {
         if( strchk(token_1->strptr, "^") == 0 )
         {
            if( token_2 )
            {
               if( strchk(token_2->strptr, ".") == 0 )
               {
                  token_1->strptr = "->" ;
                  token_1->strlen = 2    ;
                  token_2->strptr = ""   ;
                  token_2->strlen = 0    ;
               }
               
               else
               {
                  token_1->strptr = token->strptr  ;
                  token_1->strlen = token->strlen  ;
                  token->strptr   = "*"            ;
                  token->strlen   =  1             ;
               }
            }
         
            else
               printf("Very strange ^ encountered\n", token) ;
         }
      }
      
      if( strchk(token->strptr, "STATUS") == 0 && token_1 && token_2 )
      {
         if( strchk(token_1->strptr, "."  ) == 0 && 
             strchk(token_2->strptr, "ALL") == 0     )
         {
            token->strptr   = "*status" ;
            token->strlen   =  7        ;
            token_1->strptr = ""        ;
            token_1->strlen = 0         ;
            token_2->strptr = ""        ;
            token_2->strlen = 0         ;
         }
      }
      
      if( strchk(token->strptr, ";") == 0 )
      {
         token->blanks = 1 ;
      }
       
      filelast = token ;
   }              
   
   
   /* generate the output */
   
   filewalk = filepntr ;

   strcpy(output, "") ; 
   
   while( filewalk )
   {
      token = Parse_check( &filewalk ) ;
      
      if( token == NULL )
         break ;
      
      if( token->blanks )
      {
         for( i=0 ; i < token->blanks ; i++ )
            strcat(output, " ") ;
      }
      
      if( token->toktype == PARSE_TOK_STRING )
      {
         if     ( token->strtype == PARSE_STR_NQUOTE )
         {
            printf("Hit a token->strtype == PARSE_STR_NQUOTE\n") ;
            exit(1)                                              ;
         }
         
         else if( token->strtype == PARSE_STR_SQUOTE )
            strcat(output, "'") ;
            
         else
            strcat(output, "\"") ;
      }      
         
      if( strlen )
         strcat(output, token->strptr) ; 
      
      if( token->toktype == PARSE_TOK_STRING )
      {
         if( token->strtype == PARSE_STR_SQUOTE )
            strcat(output, "'") ;
            
         else
            strcat(output, "\"") ;
      }
      
      if( token->endtype == PARSE_END_ENDLINE )
      {
         fprintf(stdout, "%s\n", output) ;
         strcpy (output, ""            ) ;
      }    
   }
 
   Parse_release(filepntr) ;
}
