#include "CliLib.h"

Boolean_t         Cli_initialized       = FALSE         ;

int               Cli_pgm_counter                       ;
Cli_argument_t   *Cli_pgm_arguments                     ;
int               Cli_pgm_pointer                       ;

char              Cli_title       [128] = "cli"         ;
char              Cli_error_char        = '?'           ;
FILE             *Cli_error_file                        ;


/* INTERNAL SUPPORT ROUTINES */


void         Cli_concat(char *string1, char *string2)
{
   while ( *string1++              ) ;

   string1--                         ;

   while ( *string1++ = *string2++ ) ;
}


short        Cli_lwc(char *string)
{
   short  length=0;

   while (*string)                                                         /* if a valid character       */
   {
      if(*string >= 'A' && *string <= 'Z') *string += ' ' ;                /* if upper case, make lower  */

      string++ ;                                                           /* bump string pointer        */
      length++ ;                                                           /* bump length counter        */
   }                                                                       /* end while                  */

   return length ;                                                         /* return length              */
}


short        Cli_upc(char *string)
{
   short  length=0;

   while (*string)                                                         /* if a valid character       */
   {
      if(*string >= 'a' && *string <= 'z') *string -= ' ' ;                /* if lower case, make upper  */

      string++ ;                                                           /* bump string pointer        */
      length++ ;                                                           /* bump length counter        */
   }                                                                       /* end while                  */

   return length ;                                                         /* return length              */
}


void         Cli_error(char *string1)
{
   char        string2[256]             ;
   short       strlen2      = 0         ;
   char       *strptr2      = string2   ;
   char       *strptr3      = Cli_title ;

   if( !Cli_initialized )                                                  /* if not initialized         */
   {
     printf("?(cli) System not initialized\n") ;                           /* inform user                */
     exit(1) ;                                                             /* stop run                   */
   }

   *strptr2++ = Cli_error_char      ;                                      /* copy error character       */
   *strptr2++ = '('                 ;                                      /* add a (                    */
   while( *strptr2++ = *strptr3++ ) ;                                      /* copy pgm_text to string    */

   strptr2--                        ;                                      /* decrement over null        */
   *strptr2++ = ')'                 ;                                      /* add a )                    */
   *strptr2++ = ' '                 ;                                      /* add a   (blank)            */
   while( *strptr2++ = *string1++ ) ;                                      /* copy message to string     */

   strptr2--                      ;                                        /* decrement over null        */
   *strptr2++ = '\n'              ;                                        /* add a return               */
   *strptr2++ = '\0'              ;                                        /* add a terminator           */
   strptr2    = string2           ;                                        /* reset character pointer    */
   while ( *strptr2++ ) strlen2++ ;                                        /* bump counter               */

   /*  strlen2 contains full length of string */

   fprintf(Cli_error_file, "%s", string2) ;                                /* force to errout            */
}


void          Cli_chg_name(char *string)
{
  short    i       ;
  char    *strptr1 ;
  char    *strptr2 ;

   if( !Cli_initialized )                                                  /* if not initialized         */
   {
     printf("?(cli) System not initialized\n") ;                           /* inform user                */
     exit(1) ;                                                             /* stop run                   */
   }

   i                    = 0     ;                                          /* clear counter              */
   strptr1              =string ;                                          /* set pointer to string      */
   while( *strptr1++ ) i++      ;                                          /* determine length           */

   if(i == 0)                                                              /* if no text                 */
   {
     Cli_error("Call to CLI_CHG_NAME with null string") ;                  /* inform user of problem     */
     exit(1)                                            ;                  /* stop run                   */
   }

   strptr1 = string                 ;                                      /* reset pointer              */
   strptr2 = Cli_title              ;                                      /* set address of pgm_text    */
   while( *strptr2++ = *strptr1++ ) ;                                      /* copy text                  */
}


Boolean_t    Cli_compare(char *string1, short strlen1,
                         char *string2, short strlen2, Boolean_t cins)
{
   short        pos1     ;
   short        pos2     ;
   char         c1       ;
   char         c2       ;

   if(( strlen1 < 0 ) || ( strlen2 < 0 )) return FALSE ;                  /* check string lengths     */

   pos1 = 0  ;                                                            /* position in string1      */
   pos2 = 0  ;                                                            /* position in string2      */
   strlen1-- ;                                                            /* decrement strlen1        */
   strlen2-- ;                                                            /* decrement strlen2        */

   while( TRUE )
   {
      c1 = string1[pos1];                                                 /* copy c1                  */
      c2 = string2[pos2];                                                 /* copy c2                  */

      if(cins)                                                            /* true := case insensitive */
      {
         c1= c1 >= 'a' && c1 <= 'z' ? c1-' ' : c1;                        /* convert str1 to upper    */
         c2= c2 >= 'a' && c2 <= 'z' ? c2-' ' : c2;                        /* convert str2 to upper    */
      }

      if(       c1          !=       c2          ) return FALSE ;         /* string doesnt match      */
      if( (pos1 == strlen1) && (pos2 == strlen2) ) return TRUE  ;         /* strings match            */
      if(     ++pos1         >     strlen1       ) return FALSE ;         /* strings dont match       */

      if( string1[pos1] == '[' )                                          /* found optional part      */
      {
         if(   pos2 == strlen2 ) return TRUE  ;                           /* strings match            */
         if( ++pos1 >  strlen1 ) return FALSE ;                           /* strings dont match       */
      }

      if( string1[pos1] == ']' )                                          /* close of brace           */
      {
         if( pos2 == strlen2 )                                            /* if at end of string      */
            return TRUE  ;                                                /* strings match            */

         else                                                             /* otherwise                */
            return FALSE ;                                                /* strings dont match       */
      }

      if( ++pos2 > strlen2 )                                              /* if past end of string    */
         return FALSE;                                                    /* strings dont match       */

      else                                                                /* otherwise                */
         continue ;                                                       /* continue spinning        */
   }
}


Boolean_t    Cli_get_arg(short which, char *string, short *strlen)
{
   char      *strptr ;

   if( !Cli_initialized )                                                  /* if not initialized         */
   {
      Cli_error("System not initialized.") ;                               /* inform user                */
      exit(1)                              ;                               /* stop run                   */
   }

   if( (which < 0) || (which >= Cli_pgm_counter) )                         /* if out of range            */
   {
      *string = '\0' ;                                                     /* set terminator             */
      *strlen =   0  ;                                                     /* set length                 */
       return FALSE  ;                                                     /* not available              */
   }

   strptr  = Cli_pgm_arguments[which].arg_point  ;                         /* set pointer to length      */
   *strlen = Cli_pgm_arguments[which].arg_length ;                         /* set length                 */

   while( *string++ = *strptr++ )                ;                         /* copy text to string        */

   return Cli_pgm_arguments[which].arg_avail     ;                         /* return good or bad         */
}


Boolean_t    Cli_get_arg_l(short which, char *string, short *strlen)
{
   Boolean_t   flag ;

   flag = Cli_get_arg(which, string, strlen) ;

   Cli_lwc(string)                           ;

   return flag                               ;
}


Boolean_t    Cli_get_arg_u(short which, char *string, short *strlen)
{
   Boolean_t   flag ;

   flag = Cli_get_arg(which, string, strlen) ;

   Cli_upc(string)                           ;

   return flag ;
}


short        Cli_get_file(char *string)
{
   short      i                ;
   char      *strptr1 = string ;
   char      *strptr2          ;

   if( !Cli_initialized )                                                  /* if not initialized         */
   {
      Cli_error("System not initialized.") ;                               /* inform user                */
      exit(1)                              ;                               /* stop run                   */
   }

   *string = '\0' ;                                                        /* default response           */

   for(i=0 ; i < Cli_pgm_counter ; i++ )                                   /* spin through args          */
      if( Cli_pgm_arguments[i].arg_avail )                                 /* if arg is available        */
      {
         strptr2 = Cli_pgm_arguments[i].arg_point ;                        /* get the address of arg     */
         if( *strptr2 != '-' )                                             /* found a non switch         */
         {
            while( *strptr1++ = *strptr2++ )       ;                       /* copy text to string        */
            Cli_pgm_arguments[i].arg_avail = FALSE ;                       /* no longer available        */
            Cli_pgm_pointer                = 0     ;                       /* clear position             */
            return                           i     ;                       /* returns non-zero           */
         }
      }

   return 0 ;
}


short        Cli_get_file_l(char *string)
{
   short      i ;

   i = Cli_get_file(string) ;

   Cli_lwc(string)          ;

   return i                 ;
}


short        Cli_get_file_u(char *string)
{
   short      i ;

   i = Cli_get_file(string) ;

   Cli_upc(string)          ;

   return i                 ;
}


short        Cli_get_name(char *string)
{
   short      length = 0         ;
   char      *pgmloc = Cli_title ;

   while( *string++ = *pgmloc++ ) length++ ;

   return length ;
}


short        Cli_get_next(char *string)
{
   char      *strptr1 = string ;
   char      *strptr2          ;

   if( !Cli_initialized )                                                 /* if not initialized         */
   {
     printf("?(cli) System not initialized\n") ;                          /* inform user                */
     exit(1) ;                                                            /* stop run                   */
   }

   *string = '\0' ;                                                       /* set terminator             */

   if( Cli_pgm_pointer > 0 && Cli_pgm_pointer < Cli_pgm_counter )         /* got a pointer              */
      if( Cli_pgm_arguments[Cli_pgm_pointer+1].arg_avail )                /* next argument available?   */
      {
         strptr2 = Cli_pgm_arguments[Cli_pgm_pointer+1].arg_point ;       /* get the address of arg     */
         if( *strptr2 != '-' )                                            /* found a non switch         */
         {
            while( *strptr1++ = *strptr2++ )                       ;      /* copy text to string        */
            Cli_pgm_arguments[Cli_pgm_pointer+1].arg_avail = FALSE ;      /* no longer available        */
            return Cli_pgm_arguments[Cli_pgm_pointer++].arg_length ;      /* returns non-zero           */
         }
      }

   Cli_pgm_pointer = 0 ;                                                  /* clear position holder      */
   return            0 ;                                                  /* return zero                */
}


short        Cli_get_next_l(char *string)
{
   short      i ;

   i = Cli_get_next(string) ;

   Cli_lwc(string)          ;

   return i                 ;
}


short        Cli_get_next_u(char *string)
{
   short      i ;

   i = Cli_get_next(string) ;

   Cli_upc(string)          ;

   return i                 ;
}


short        Cli_force_next(char *string)
{
   char      *strptr1 = string ;
   char      *strptr2          ;

   if( !Cli_initialized )                                                 /* if not initialized         */
   {
     printf("?(cli) System not initialized\n") ;                          /* inform user                */
     exit(1) ;                                                            /* stop run                   */
   }

   *string = '\0' ;                                                       /* set terminator             */

   if( Cli_pgm_pointer > 0 && Cli_pgm_pointer < Cli_pgm_counter )         /* got a pointer              */
      if( Cli_pgm_arguments[Cli_pgm_pointer+1].arg_avail )                /* next argument available?   */
      {
         strptr2 = Cli_pgm_arguments[Cli_pgm_pointer+1].arg_point ;       /* get the address of arg     */

         while( *strptr1++ = *strptr2++ )                       ;         /* copy text to string        */
         Cli_pgm_arguments[Cli_pgm_pointer+1].arg_avail = FALSE ;         /* no longer available        */
         return Cli_pgm_arguments[Cli_pgm_pointer++].arg_length ;         /* returns non-zero           */
      }

   Cli_pgm_pointer = 0 ;                                                  /* clear position holder      */
   return            0 ;                                                  /* return zero                */
}


short        Cli_force_next_l(char *string)
{
   short      i ;

   i = Cli_force_next(string) ;

   Cli_lwc(string)            ;

   return i                   ;
}


short        Cli_force_next_u(char *string)
{
   short      i ;

   i = Cli_force_next(string) ;

   Cli_upc(string)            ;

   return i                   ;
}


void         Cli_init(char *title, int arg_count, char **arg_point)
{
   int        i       ;
   int        j       ;
   char      *strptr1 ;
   char      *strptr2 ;

   if( Cli_initialized )                                                  /* if already initialized   */
   {
      Cli_error("System already initialized.") ;                          /* inform user              */
      exit(1)                                  ;                          /* and DIE                  */
   }

   Cli_error_file     = stderr                                      ;     /* set standard error       */
   Cli_pgm_counter    = arg_count                                   ;     /* save the count           */
   Cli_pgm_arguments  = calloc(arg_count+2, sizeof(Cli_argument_t)) ;     /* allocate space           */
   Cli_pgm_pointer    = 0                                           ;     /* clear current pointer    */

   for( i=0 ; i < Cli_pgm_counter ; i++)                                  /* spin through count       */
   {
      j       = 0             ;                                           /* clear counter            */
      strptr1 = arg_point[i]  ;                                           /* set pointer              */
      while( *strptr1++ ) j++ ;                                           /* compute length           */

      Cli_pgm_arguments[i].arg_avail  = TRUE         ;                    /* set available flag       */
      Cli_pgm_arguments[i].arg_point  = arg_point[i] ;                    /* save pointer             */
      Cli_pgm_arguments[i].arg_length = j            ;                    /* save length              */
   }

   Cli_pgm_arguments[0].arg_avail = FALSE ;                               /* invocation argument      */

   i = 0                                  ;                               /* clear counter            */
   strptr1 = Cli_title                    ;                               /* set to storage area      */
   strptr2 = title                        ;                               /* set to title             */
   while( *strptr1++ = *strptr2++ ) i++   ;                               /* copy and bump length     */

   if( i == 0 )                                                           /* if no text               */
   {
      Cli_error("Call to CLI_INIT with null TITLE") ;                     /* inform user of problem   */
      exit(1)                                       ;                     /* stop run                 */
   }

   Cli_initialized = TRUE ;                                               /* initialied               */
}


void         Cli_num_args(short *count)
{
   if( !Cli_initialized )                                                 /* if not initialized       */
   {
     printf("?(cli) System not initialized\n") ;                          /* inform user              */
     exit(1) ;                                                            /* stop run                 */
   }

  *count = Cli_pgm_counter ;
}


short        Cli_number(char string[], long *i4, double *r8, short *error)
{
   char          charx               ;                      /* character we are looking ag      */
   long          lwork       = 0     ;                      /* value working on                 */
   long          twork               ;                      /* value to test with               */
   double        dwork       = 0.0   ;                      /* value working on                 */
   short         stemp               ;                      /* value working on                 */
   long          ltemp               ;                      /* long temp value                  */
   double        dtemp               ;                      /* double temp value                */
   short         indx                ;                      /* position in string               */
   long          lsign       = 1     ;                      /* sign of value (long)             */
   double        dsign       = 1.0   ;                      /* sign of value (double)           */
   short         esign       = 1     ;                      /* sign of exponent                 */
   Boolean_t     periodl     = FALSE ;                      /* have a period flag               */
   double        periodm     = 10.0  ;                      /* period multiplier                */
   Boolean_t     valid       = FALSE ;                      /* do we have a valid number?       */
   Boolean_t     integer     = TRUE  ;                      /* value is an integer              */
   Boolean_t     mantissa    = TRUE  ;                      /* converting mantissa              */
   short         exponentv   = 0     ;                      /* value of exponent                */
   Boolean_t     exponentl   = FALSE ;                      /* have an exponent flag            */
   Boolean_t     exponente   = FALSE ;                      /* does exponent actually exist     */

   static double expmults[61] = {1.e-30, 1.e-29, 1.e-28, 1.e-27, 1.e-26,
                                 1.e-15, 1.e-14, 1.e-13, 1.e-12, 1.e-11,
                                 1.e-20, 1.e-19, 1.e-18, 1.e-17, 1.e-16,
                                 1.e-15, 1.e-14, 1.e-13, 1.e-12, 1.e-11,
                                 1.e-10, 1.e-9 , 1.e-8 , 1.e-7 , 1.e-6 ,
                                 1.e-5 , 1.e-4 , 1.e-3 , 1.e-2 , 1.e-1 ,
                                 1.e+0 ,
                                 1.e+1 , 1.e+2 , 1.e+3 , 1.e+4 , 1.e+5 ,
                                 1.e+6 , 1.e+7 , 1.e+8 , 1.e+9 , 1.e+10,
                                 1.e+11, 1.e+12, 1.e+13, 1.e+14, 1.e+15,
                                 1.e+16, 1.e+17, 1.e+18, 1.e+19, 1.e+20,
                                 1.e+21, 1.e+22, 1.e+23, 1.e+24, 1.e+25,
                                 1.e+26, 1.e+27, 1.e+28, 1.e+29, 1.e+30 } ;

   if( !Cli_initialized )                                                 /* if not initialized               */
   {
     printf("?(cli) System not initialized\n") ;                          /* inform user                      */
     exit(1) ;                                                            /* stop run                         */
   }

   *i4    = 0  ;                                                          /* clear integer*4 value            */
   *r8    = 0.0;                                                          /* clear real*8    value            */
   *error = 0  ;                                                          /* clear error                      */

   for( indx=0 ; string[indx] ; indx++ )                                  /* spin index                       */
   {
      charx=string[indx] ;                                                /* glom off a single character      */

      if( charx == ' ' )                                                  /* imbedded blanks?                 */
      {
         *error = 2    ;                                                  /* return error type                */
         return ++indx ;                                                  /* return error position            */
      }                                                                   /* end if                           */

      if( mantissa )                                                      /* if working mantissa              */
      {
         if( indx == 0 )                                                  /* if on first character            */
         {
            if     ( charx == '+' )                                       /* if +                             */
              continue ;                                                  /*   continue                       */

            else if( charx == '-' )                                       /* if -                             */
            {
               dsign = -1.0 ;                                             /*   make double sign negative      */
               lsign = -1   ;                                             /*   make long   sign negative      */
               continue     ;                                             /*   continue with next indx        */
            }                                                             /* endif charx                      */
         }                                                                /* endif indx                       */

         switch( charx )                                                  /* test character by character      */
         {
            case '.' : if( periodl )                                      /* period already exists            */
                       {
                          *error = 3    ;                                 /* return the type of error         */
                          return ++indx ;                                 /* return the position of the error */
                       }

                       else                                               /* no period already exists         */
                       {
                          periodl = TRUE  ;                               /* flag that we have a period       */
                          integer = FALSE ;                               /* no longer an integer             */
                          continue        ;                               /* break out of switch              */
                       }

            case '0' :                                                    /* if 0 (zero)     or               */
            case '1' :                                                    /* if 1 (one)      or               */
            case '2' :                                                    /* if 2 (zero)     or               */
            case '3' :                                                    /* if 3 (three)    or               */
            case '4' :                                                    /* if 4 (four)     or               */
            case '5' :                                                    /* if 5 (five)     or               */
            case '6' :                                                    /* if 6 (six)      or               */
            case '7' :                                                    /* if 7 (seven)    or               */
            case '8' :                                                    /* if 8 (eight)    or               */
            case '9' :                                                    /* if 9 (nine)       then           */
                       ltemp = charx - '0' ;                              /*   convert character to long      */
                       dtemp = ltemp       ;                              /*   convert long      to double    */

            /* if we are still building integer value, make sure that
               we are not overflowing the integer                    */

            if( integer )                                                 /* if integer, see if breaks bank   */
            {
               twork = (lwork > 0) ? lwork : -lwork ;                     /* get absolute value of lwork      */
               if     ( twork > 214748364L )                              /* number is too big for an int     */
                 integer = FALSE ;                                        /* turn integer off                 */

               else if( twork == 214748364L )                             /* almost largest int value         */
               {
                  if( lsign == 1 )                                        /* if a positive sign               */
                  {
                    if     ( ltemp > 7 )
                       integer = FALSE ;                                  /* value over edge, turn int off    */

                    else if( ltemp > 8 )
                       integer = FALSE ;                                  /* turn integer off                 */
                  }
               }                                                          /* end overflow test                */
            }                                                             /* end if integer                   */

            if( integer )                                                 /* if we are building an integer    */
            {
              if( lsign == 1 )                                            /* is this a positive number?       */
                 lwork = (lwork * 10L) + ltemp ;                          /* multiply and add                 */

              else                                                        /* otherwise                        */
                 lwork = (lwork * 10L) - ltemp ;                          /* multiply and subtract            */
            }                                                             /* end if integer                   */

            if( periodl )                                                 /* if we have a period              */
            {
               dwork   = dwork +                                          /* build double value               */
                       (dsign * dtemp) / periodm ;                        /* build double value               */
               periodm = periodm * 10.0 ;                                 /* multiply periodm by 10           */
            }

            else                                                          /* no period as yet                 */
               dwork = dwork * 10.0 + (dsign * dtemp) ;                   /* build double value               */

            valid = TRUE ;                                                /* set valid number flag            */
            continue     ;                                                /* kick out of this case section    */

            case 'd' :                                                    /* double                           */
            case 'D' :                                                    /*   ditto                          */
            case 'e' :                                                    /* exponent                         */
            case 'E' :                                                    /*   ditto                          */
                       if( !valid )                                       /* if we dont have a valid number   */
                       {
                          *error = 4    ;                                 /* return error type                */
                          return ++indx ;                                 /* return position of error         */
                       }

                       else
                       {
                          integer   = FALSE ;                             /* no longer in integer             */
                          mantissa  = FALSE ;                             /* no longer in mantissa            */
                          continue          ;                             /* kick out of this case section    */
                       }                                                  /* end if not valid                 */

            default  :                                                    /* default answer                   */
                       *error = 7    ;                                    /* set error value                  */
                       return ++indx ;                                    /* return illegal value             */
         }                                                                /* end switch                       */

      }                                                                   /* endif mantissa                   */

      else
      {
         if( !exponentl )                                                 /* if this is first char after DdEe */
         {
             exponentl = TRUE ;                                           /* set the exponent flag            */
             if     ( charx == '-' )                                      /* if char is -                     */
             {
                esign = -1;                                               /* set exponent sign                */
                continue  ;                                               /* jump to next index               */
             }

             else if ( charx == '+' )                                     /* if char is +                     */
                continue;                                                 /* just continue                    */
          }                                                               /* end if exponent                  */

          if( charx >= '0' && charx <= '9' )                              /* check if this is a valid char    */
          {
             stemp     = charx - '0'                          ;
             exponente = TRUE                                 ;
             exponentv = exponentv * 10 + (stemp * esign)     ;
             stemp     = exponentv<0 ? -exponentv : exponentv ;

             if( stemp > 30 )                                             /* too small/too big                */
             {
                *error = 5    ;                                           /* return error condition           */
                return indx+1 ;                                           /* return position                  */
             }                                                            /* endif stemp                      */
             continue ;                                                   /* jump to next indx                */
          }                                                               /* endif charx                      */
          *error = 7    ;                                                 /* return error condition           */
          return indx+1 ;                                                 /* return position                  */
      }                                                                   /* endif mantissa else              */
   }                                                                      /* end for                          */

   if( !valid )                                                           /* we dont have a valid number      */
   {
      *error = 8 ;                                                        /* return error condition           */
      return 0   ;                                                        /* return position                  */
   }

   if( integer )                                                          /* we have a valid integer          */
   {
      *i4    = lwork ;                                                    /* save integer value               */
      *r8    = dwork ;                                                    /* save double value                */
      *error = 0     ;                                                    /* save error value                 */
      return   1     ;                                                    /* return integer type              */
    }                                                                     /* end if integer                   */

   if( (!mantissa) && (!exponente) )                                      /* EeDd, but no value after it      */
   {
      *error = 6 ;                                                        /* flag as exponent problem         */
      return 0   ;                                                        /* unable to return position        */
    }                                                                     /* end if mantiss & exponent        */

   if( exponentl )                                                        /* if exponent                      */
   {
      exponentv += 30                      ;                              /* normalize -30 -> 0               */
      dwork  = dwork * expmults[exponentv] ;                              /* lazy way to manipulate exponent  */
   }                                                                      /* end if exponentl                 */

   *i4    = 0     ;                                                       /* save integer value               */
   *r8    = dwork ;                                                       /* save double value                */
   *error = 0     ;                                                       /* save error value                 */
   return   2     ;                                                       /* return double type               */
}


Boolean_t      Cli_parm(char *string, Boolean_t cins)
{
   short      length ;
   char      *strptr ;
   short      i      ;

   if( !Cli_initialized )                                                  /* if not initialized         */
   {
      Cli_error("System not initialized.") ;                               /* inform user                */
      exit(1)                              ;                               /* stop run                   */
   }

   Cli_pgm_pointer = 0      ;                                              /* clear pointer              */
   length          = 0      ;                                              /* clear length               */
   strptr          = string ;                                              /* set address of string      */

   while ( *strptr++ ) length++ ;                                          /* get length of string       */

   for(i=0 ; i < Cli_pgm_counter ; i++ )                                   /* spin through args          */
     if( Cli_pgm_arguments[i].arg_avail )                                  /* if arg is available        */
        if( Cli_compare(string                         , length                     ,
                         Cli_pgm_arguments[i].arg_point, Cli_pgm_arguments[i].arg_length,
                         cins                                                          ) )
        {
           Cli_pgm_arguments[i].arg_avail = FALSE ;                        /* no longer available       */
           Cli_pgm_pointer                = i     ;                        /* save position             */
           return       (Boolean_t)         i     ;                        /* returns non-zero          */
        }

   return FALSE ;
}


Boolean_t      Cli_parm_ci(char *string)
{
  return Cli_parm(string, TRUE );
}


Boolean_t      Cli_parm_cs(char *string)
{
  return Cli_parm(string, FALSE);
}


Boolean_t      Cli_parm_cnt(char *string, short *count, Boolean_t cins)
{
   Boolean_t    flag  ;

   if( !Cli_initialized )                                                 /* if not initialized         */
   {
     printf("?(cli) System not initialized\n") ;                          /* inform user                */
     exit(1) ;                                                            /* stop run                   */
   }

   *count = 0                      ;                                      /* clear return flag          */
   flag   = Cli_parm(string, cins) ;                                      /* have Cli_parm do the work  */

   /* fix this later */

   return flag ;                                                          /* return the flag value      */
}


Boolean_t     Cli_parm_cnt_ci(char *string, short *count)
{
   return Cli_parm_cnt(string, count, TRUE) ;
}


Boolean_t     Cli_parm_cnt_cs(char *string, short *count)
{
   return Cli_parm_cnt(string, count, FALSE) ;
}


FILE         *Cli_redirect_err(FILE *tsid)
{
   FILE     *temp ;

   if( !Cli_initialized )                                                 /* if not initialized         */
   {
     printf("?(cli) System not initialized\n") ;                          /* inform user                */
     exit(1) ;                                                            /* stop run                   */
   }

  temp           = Cli_error_file ;                                       /* save old sid               */
  Cli_error_file = tsid           ;                                       /* set new sid                */
  return temp                     ;                                       /* return old sid             */
}


void         Cli_reset()
{
   if( !Cli_initialized )                                                 /* if not initialized         */
   {
     printf("?(cli) System not initialized\n") ;                          /* inform user                */
     exit(1) ;                                                            /* stop run                   */
   }

   Cli_initialized = FALSE ;
}


void         Cli_restore()
{
  short    i ;

   if( !Cli_initialized )                                                 /* if not initialized         */
   {
     printf("?(cli) System not initialized\n") ;                          /* inform user                */
     exit(1) ;                                                            /* stop run                   */
   }

   for( i=0 ; i < Cli_pgm_counter ; i++ )
      Cli_pgm_arguments[i].arg_avail = TRUE ;

   Cli_pgm_pointer                = 0     ;
   Cli_pgm_arguments[0].arg_avail = FALSE ;
}

/*
#include "Cli_help.c"
*/


void         Cli_startup(char *title, char *version, int arg_count, char **arg_point)
{
   char        *strptr1 ;
   short        i       ;

#ifdef _APOLLO_SOURCE
   status_t    xtatus  ;
#endif

   if( *title == '-' )
     title++ ;

   else
   {
     i                    = 0     ;
     strptr1              =title  ;
     while( *strptr1++ ) i++      ;
#ifdef _APOLLO_SOURCE
     pm_set_my_name(title,&i,&xtatus) ;
#endif
   }

   Cli_init(title  , arg_count, arg_point ) ;           /*
   Cli_help(version                       ) ;           */
}


void         Cli_unclaimed()
{
   char        string  [512]  ;
   short       i              ;
   char       *strptr         ;
   Boolean_t   error1 = FALSE ;
   Boolean_t   error2 = FALSE ;

   if( !Cli_initialized )                                                 /* if not initialized       */
   {
      Cli_error("System not initialized.") ;                              /* inform user              */
      exit(1)                              ;                              /* stop run                 */
   }

   for(i=0 ; i  < Cli_pgm_counter ; i++)                                  /* spin through arguments   */
      if( Cli_pgm_arguments[i].arg_avail )                                /* if available             */
      {
         strptr = Cli_pgm_arguments[i].arg_point ;                        /* get the address of arg   */
         if( *strptr == '-' )                                             /* found a switch           */
         {
            if( error1 )                                                  /* if error already set     */
            {
               string[0] = '\0'                                   ;
               Cli_concat(string, "Also \""                     ) ;
               Cli_concat(string, Cli_pgm_arguments[i].arg_point) ;
               Cli_concat(string, "\""                          ) ;
               Cli_error (string                                ) ;

            }

            else
            {
               error1    = TRUE                                           ;
               string[0] = '\0'                                           ;
               Cli_concat(string, "Unrecognized or redundant keyword \"") ;
               Cli_concat(string, Cli_pgm_arguments[i].arg_point        ) ;
               Cli_concat(string, "\""                                  ) ;
               Cli_error (string                                        ) ;
            }
         }
      }

   for(i=0 ; i  < Cli_pgm_counter ; i++)                                  /* spin through arguments   */
      if( Cli_pgm_arguments[i].arg_avail )                                /* if available             */
      {
         strptr = Cli_pgm_arguments[i].arg_point ;                        /* get the address of arg   */
         if( *strptr != '-' )                                             /* found a non switch       */
         {
            if( error2 )                                                  /* if error already set     */
            {
               string[0] = '\0'                                   ;
               Cli_concat(string, "Also \""                     ) ;
               Cli_concat(string, Cli_pgm_arguments[i].arg_point) ;
               Cli_concat(string, "\""                          ) ;
               Cli_error (string                                ) ;

            }

            else
            {
               error2    = TRUE                                   ;
               string[0] = '\0'                                   ;
               Cli_concat(string, "Unused file name \""         ) ;
               Cli_concat(string, Cli_pgm_arguments[i].arg_point) ;
               Cli_concat(string, "\""                          ) ;
               Cli_error (string                                ) ;
            }
         }
      }

   if( error1 || error2 ) exit(1) ;
}


void         Cli_unclaimed_switches()
{
   char        string  [512]  ;
   short       i              ;
   char       *strptr         ;
   Boolean_t   error  = FALSE ;

   if( !Cli_initialized )                                                 /* if not initialized       */
   {
      Cli_error("System not initialized.") ;                              /* inform user              */
      exit(1)                              ;                              /* stop run                 */
   }

   for(i=0 ; i  < Cli_pgm_counter ; i++)                                  /* spin through arguments   */
      if( Cli_pgm_arguments[i].arg_avail )                                /* if available             */
      {
         strptr = Cli_pgm_arguments[i].arg_point ;                        /* get the address of arg   */
         if( *strptr == '-' )                                             /* found a switch           */
         {
            if( error )                                                   /* if error already set     */
            {
               string[0] = '\0'                                   ;
               Cli_concat(string, "Also \""                     ) ;
               Cli_concat(string, Cli_pgm_arguments[i].arg_point) ;
               Cli_concat(string, "\""                          ) ;
               Cli_error (string                                ) ;
            }

            else
            {
               error     = TRUE                                           ;
               string[0] = '\0'                                           ;
               Cli_concat(string, "Unrecognized or redundant keyword \"") ;
               Cli_concat(string, Cli_pgm_arguments[i].arg_point        ) ;
               Cli_concat(string, "\""                                  ) ;
               Cli_error (string                                        ) ;
            }
         }
      }

   if( error ) exit(1) ;
}
