
#ifndef CLILIB_INC_FLAG

   #define CLILIB_INC_FLAG

   #include <stdio.h>
   #include <stdlib.h>

   #ifdef _APOLLO_SOURCE
      #include "/usr/include/apollo/base.h"
   #endif

   #ifndef BOOLEAN_T
      #define  BOOLEAN_T
      typedef  char              Boolean_t   ;
      #define  TRUE              1
      #define  FALSE             0
   #endif

   typedef struct  { Boolean_t   arg_avail  ;
                     char       *arg_point  ;
                     short       arg_length ;
                                              } Cli_argument_t ;

   void         Cli_concat(char *string1, char *string2)                                    ;
   short        Cli_lwc(char *string)                                                       ;
   short        Cli_upc(char *string)                                                       ;
   void         Cli_error(char *string1)                                                    ;
   void         Cli_chg_name(char *string)                                                  ;
   Boolean_t    Cli_compare(char *string1, short strlen1,
                            char *string2, short strlen2, Boolean_t cins)                   ;
   Boolean_t    Cli_get_arg(short which, char *string, short *strlen)                       ;
   Boolean_t    Cli_get_arg_l(short which, char *string, short *strlen)                     ;
   Boolean_t    Cli_get_arg_u(short which, char *string, short *strlen)                     ;
   short        Cli_get_file(char *string)                                                  ;
   short        Cli_get_file_l(char *string)                                                ;
   short        Cli_get_file_u(char *string)                                                ;
   short        Cli_get_name(char *string)                                                  ;
   short        Cli_get_next(char *string)                                                  ;
   short        Cli_get_next_l(char *string)                                                ;
   short        Cli_get_next_u(char *string)                                                ;
   short        Cli_force_next(char *string)                                                ;
   short        Cli_force_next_l(char *string)                                              ;
   short        Cli_force_next_u(char *string)                                              ;
   void         Cli_init(char *title, int arg_count, char **arg_point)                      ;
   void         Cli_num_args(short *count)                                                  ;
   short        Cli_number(char string[], long *i4, double *r8, short *error)               ;
   Boolean_t    Cli_parm(char *string, Boolean_t cins)                                      ;
   Boolean_t    Cli_parm_ci(char *string)                                                   ;
   Boolean_t    Cli_parm_cs(char *string)                                                   ;
   Boolean_t    Cli_parm_cnt(char *string, short *count, Boolean_t cins)                    ;
   Boolean_t    Cli_parm_cnt_ci(char *string, short *count)                                 ;
   Boolean_t    Cli_parm_cnt_cs(char *string, short *count)                                 ;
   FILE        *Cli_redirect_err(FILE *tsid)                                                ;
   void         Cli_reset()                                                                 ;
   void         Cli_restore()                                                               ;
   void         Cli_startup(char *title, char *version, int arg_count, char **arg_point)    ;
   void         Cli_unclaimed()                                                             ;
   void         Cli_unclaimed_switches()                                                    ;
 
#endif
