/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 *
 *	@(#)fcntl.h	5.2 (Berkeley) 1/8/86
 */

#ifndef _FCNTL_INCLUDED
#define _FCNTL_INCLUDED

#ifndef _SYS_STDSYMS_INCLUDED
#	include <sys/stdsyms.h>
#endif /* _SYS_STDSYMS_INCLUDED */

/*
 * Flag values accessible to open(2) and fcntl(2)-- copied from
 * <sys/file.h>.  (The first three can only be set by open.)
 */
#define	O_RDONLY	000		/* open for reading */
#define	O_WRONLY	001		/* open for writing */
#define	O_RDWR		002		/* open for read & write */
#define	O_NDELAY	FNDELAY		/* non-blocking open */
					/* really non-blocking I/O for fcntl */
#define	O_APPEND	FAPPEND		/* append on each write */
#define	O_CREAT		FCREAT		/* open with file create */
#define	O_TRUNC		FTRUNC		/* open with truncation */
#define	O_EXCL		FEXCL		/* error on create if file exists */

#ifndef	F_DUPFD
/* fcntl(2) requests */
#define	F_DUPFD	0	/* Duplicate fildes */
#define	F_GETFD	1	/* Get fildes flags */
#define	F_SETFD	2	/* Set fildes flags */
#define	F_GETFL	3	/* Get file flags */
#define	F_SETFL	4	/* Set file flags */
#define	F_GETOWN 5	/* Get owner */
#define F_SETOWN 6	/* Set owner */

/* flags for F_GETFL, F_SETFL-- copied from <sys/file.h> */
#define	FNDELAY		00004		/* non-blocking reads */
#define	FAPPEND		00010		/* append on each write */
#define	FASYNC		00100		/* signal pgrp when data ready */
#define	FCREAT		00400		/* create if nonexistant */
#define	FTRUNC		01000		/* truncate to zero length */
#define	FEXCL		02000		/* error if already created */
#endif

/*  Required for C++ V2.0  */
#ifdef  __cplusplus
extern "C" {
#endif

_DECL_FUNC(int,		fcntl,		(int, int, ...))
#ifdef __cplusplus
_DECL_FUNC(int,		open,	(const char *__path, int __oflag, int))
_DECL_FUNC(int,		creat,	(const char *__path, int __mode))
#endif
  

/* sys/fcntl.h - POSIX, XPG3 Data definitions for file control operations. */

/* cmd values for fcntl(): */
#define F_DUPFD         0       /* Duplicate fildes */
#define F_GETFD         1       /* Get fildes flags */
#define F_SETFD         2       /* Set fildes flags */
#define F_GETFL         3       /* Get file flags */
#define F_SETFL         4       /* Set file flags */
#define F_GETLK         7       /* Get file lock */
#define F_SETLK         8       /* Set file lock */
#define F_SETLKW        9       /* Set file lock and wait */

/* File descriptor flags used for fcntl(): */
#define FD_CLOEXEC      1

/* l_type values for record locking with fcntl(): */
#define F_RDLCK         01      /* Shared or Read lock. */
#define F_WRLCK         02      /* Exclusive or Write lock. */
#define F_UNLCK         03      /* Unlock. */

/* Additonal file status flag for open() and fcntl(): */
#define O_SYNC          020         /* synchronous write option */

/* Additional cmd values for fcntl(). */
#define F_CHKFL         10      /* Check legality of file flag changes */

/* file segment locking set data type - information passed to system by user 
 *
 * Posix defines l_pid as a pid_t.  This is only used if 
 * _INCLUDE_ALL_POSIX_SOURCE is defined in order to maintain
 * backward compatibility when desired
 */
struct flock {
        short   l_type;         /* Type of lock. */
        short   l_whence;       /* Flag for starting offset. */
        off_t   l_start;        /* Relative offset in bytes. */
        off_t   l_len;          /* Size; if 0 then until EOF. */
#ifdef _INCLUDE_ALL_POSIX_SOURCE
        long    l_sysid;
        pid_t   l_pid;          /* Process ID of the lock owner. */
#else
        short   l_sysid;
        short   l_pid;          /* Process ID of the lock owner. */
#endif /* _INCLUDE_ALL_POSIX_SOURCE */
};

#ifdef  __cplusplus
  }
#endif

#endif /* _FCNTL_INCLUDED */
