/*
 * piodrv.c
 *   The routines of the parallel port driver that the application
 *   needs to link with. The rest of the driver gets loaded when
 *   the device is aquired.
 *   Jef Rijmenants, 19-may-1993.
 */

#include <stdio.h>
#include <apollo/base.h>
#include <apollo/error.h>
#include "pbu.h"
#include "piodrv.h"


pbu_$unit_t piodrv_pbu_unit;

/*
 * piodrv_acquire
 *    Acquire the device. The driver libraries are installed and
 *    the driver init routine gets called automatically.
 */
int piodrv_acquire()
{
   status_$t sts;
   boolean debug;

   debug = false;
   pbu_$acquire(PIODRV_DEV, (short)strlen(PIODRV_DEV), debug,
      &piodrv_pbu_unit, &sts);
   if (sts.all != status_$ok) {
      fprintf(stderr, "ERROR: Failed to acquire device.\n");
      /* error_$print(sts); */
      return 0;
   }
   return 1;
}


/*
 * piodrv_release()
 *    Release the device. The driver cleanup routine gets called
 *    automatically.
 */
int piodrv_release()
{
   status_$t sts;
   boolean force;

   force = true;
   pbu_$release(piodrv_pbu_unit, force, &sts);
   if (sts.all != status_$ok) {
      fprintf(stderr, "ERROR: Problem releasing device.\n");
      error_$print(sts);
      return 0;
   }
   return 1;
}

/*
 * piodrv_write_char
 *   write one char to the parallel port (user-level routine)
 */
void piodrv_write_char(
   char c
)
{
   if (!piodrv_put_char((char)c)) {
      if (piodrv_paper_empty()) {
         fprintf(stderr, "WARNING: Out of paper!\n");
         while (piodrv_paper_empty()) sleep(30);
         if (piodrv_put_char((char)c)) return;
      }
      /* give up */
      fprintf(stderr, "ERROR: Printer busy or off-line!\n");
      piodrv_release();
      exit(1);
   }
}



