/*
 * cdjprint.c
 *   A simple printing program for an HP550C color deskjet printer 
 *   that uses the parallel io port driver.
 *   Jef Rijmenants, 19-may-1993.
 */

#include <stdio.h>
#include "piodrv.h"

#define ESC 27
#define CR  13
#define LF  10

/*
 *
 */
print_usage()
{
   fprintf(stderr, "cdjprint - HP550C deskjet printer driver\n");
   fprintf(stderr, "usage: cdjprint [-options...] [filename]\n");   
   fprintf(stderr, "  options:\n");   
   fprintf(stderr, "    -init     (just init PIO board and printer)\n");   
   fprintf(stderr, "    -cvt_nl   (convert nl in cr-lf, default= no cvt_nl)\n");   
   fprintf(stderr, "  If filename is not specified, standard input is read.\n");
}


/*
 *
 */
int print_file(
   char *filename,
   int cvt_nl
)
{
   FILE *infile;
   int inchar;

   if (strlen(filename)) {
      if (!(infile = fopen(filename, "r"))) {
         fprintf(stderr, "ERROR: Unable to open file \"%s\".\n", filename);
         return 0;
      }
   }
   else infile = stdin;

   /* reset */
/*
   piodrv_write_char(ESC);
   piodrv_write_char('E');
*/

   /* load paper */
/*
   piodrv_write_char(ESC);
   piodrv_write_char('&');
   piodrv_write_char('l');
   piodrv_write_char('1');
   piodrv_write_char('H');
*/

   if (cvt_nl) {
      while ((inchar = fgetc(infile)) != EOF) {
         if (inchar == '\n') {
            piodrv_write_char(CR);
            piodrv_write_char(LF);
         }
         else 
            piodrv_write_char((char)inchar);
      }
   }
   else {
      while ((inchar = fgetc(infile)) != EOF)
         piodrv_write_char((char)inchar);
   }

   /* eject paper */
   piodrv_write_char(ESC);
   piodrv_write_char('&');
   piodrv_write_char('l');
   piodrv_write_char('0');
   piodrv_write_char('H');

   if (strlen(filename)) fclose(infile);
   return 1;
}


/*
 *
 */
main(
   int argc,
   char **argv
)
{
   int arg, cvt_nl, init_only;
   char filename[1024];

   cvt_nl = 0;
   init_only = 0;
   filename[0] = '\0';
   for (arg = 1; arg < argc; arg++) {
      if (argv[arg][0] == '-') {
         if      (strcmp(argv[arg], "-cvt_nl") == 0) cvt_nl = 1;
         else if (strcmp(argv[arg], "-init") == 0)   init_only = 1;
         else { print_usage(); exit(0); }
      }
      else if (filename[0] == '\0')  strcpy(filename, argv[arg]);
      else { print_usage(); exit(0); }
   }

   if (!piodrv_acquire()) exit(0);
   if (!init_only) {
      print_file(filename, cvt_nl);   
   }
   piodrv_release();
}
