/*
 * cl.h : Version R1.0.0, based on CL.INS.PAS, /us/ins, jrw 02/15/90
 *
 * General command line parser.
 */

#ifndef _us_cl_h
#define _us_cl_h

#define cl_$module_code                 0x040D0000
#define cl_$arg_too_long                (cl_$module_code + 0x0001)
#define cl_$too_many_arguments          (cl_$module_code + 0x0002)
#define cl_$not_enough_arguments        (cl_$module_code + 0x0003)
#define cl_$invalid_decimal_number      (cl_$module_code + 0x0004)
#define cl_$no_match_for_wildcard       (cl_$module_code + 0x0005)
#define cl_$missing_req_derived_name    (cl_$module_code + 0x0006)
#define cl_$unparsed_keyword            (cl_$module_code + 0x0007)
#define cl_$duplicate_set_element       (cl_$module_code + 0x0008)
#define cl_$invalid_set_element         (cl_$module_code + 0x0009)

#define cl_$undetermined_dc     -1  /* for cl_$set_derived_count */

typedef short enum
{
    cl_$wildcards,          /* causes tokens which look like wildcard */
                            /* names to be expanded and each name     */
                            /* which matches it returned.  (default)  */
    cl_$no_wildcards,       /* suppresses wildcard expansion          */

    cl_$verify_none,        /* causes no verification of names with   */
                            /* the user.  (default)                   */
    cl_$verify_all,         /* causes all names to be verified with   */
                            /* the user.                              */
    cl_$verify_wild,        /* causes only wildcard names to be       */
                            /* verified.                              */

    cl_$dash_nop,           /* causes the dash character, "-" to be   */
                            /* treated like any other token.          */
                            /* (default)                              */
    cl_$dash_names,         /* causes dash to causes names to be read */
                            /* from the standard input.               */

    cl_$name_dft_nop,       /* suppresses any special action when no  */
                            /* names appear on the command line or in */
                            /* "*" files.  (default)                  */
    cl_$name_dft_stdin,     /* causes names to be read from standard  */
                            /* input when no names appear on the      */
                            /* command line.                          */

    cl_$no_match_ok,        /* causes no error or warning when a      */
                            /* wildcard produces no matches           */
    cl_$no_match_warning,   /* causes a warning message to be output  */
                            /* when a wildcard produces no matches    */
                            /* (default)                              */
    cl_$no_match_error,     /* causes an error message and program    */
                            /* termination to occur if a wildcard     */
                            /* produces no matches                    */

    cl_$keyword_delim,      /* causes names and arguments to be       */
                            /* delimited by keywords which have not   */
                            /* yet been read (default)                */
    cl_$no_keyword_delim,   /* causes names and arguments to be       */
                            /* insensitive to keywords                */

    cl_$comments,           /* causes all text enclused within braces */
                            /* to be ignored when read from standard  */
                            /* nput (using cl_$parse_input)           */
    cl_$no_comments,        /* causes no special handling of text     */ 
                            /* within braces  (default)               */

    cl_$star_names,         /* allows names files to be used          */
                            /* (default)                              */
    cl_$no_star_names,      /* treats '*' just like any other         */
                            /* character                              */

    cl_$save_nulls,         /* passes 0-length arguments to the       */
                            /* application (default)                  */
    cl_$dump_nulls,         /* throws away 0-length arguments         */

    cl_$no_negnum,          /* treats '-[0-9][0-9]*' as a keyword, if */
                            /* cl_$keyword_delim (default)            */
    cl_$negnum              /* treats '-[0-9][0-9]*' as an argument   */
                            /* even if cl_$keyword_delim is in effect */
                            /* the argument can be returned as a      */
                            /* negative value by cl_$get_num          */
}
cl_$opt_t;

typedef void
(*cl_$callback_ptr)
(
    status_$t &status,  /* status code - can be status_$ok */
    char      *str,     /* vfmt-style control string */
    ...
);

typedef unsigned long int cl_$opt_set_t;

#define cl_$wildcards_opt          0x00000001
#define cl_$no_wildcards_opt       0x00000002
#define cl_$verify_none_opt        0x00000004
#define cl_$verify_all_opt         0x00000008
#define cl_$verify_wild_opt        0x00000010
#define cl_$dash_nop_opt           0x00000020
#define cl_$dash_names_opt         0x00000040
#define cl_$name_dft_nop_opt       0x00000080
#define cl_$name_dft_stdin_opt     0x00000100
#define cl_$no_match_ok_opt        0x00000200
#define cl_$no_match_warning_opt   0x00000400
#define cl_$no_match_error_opt     0x00000800
#define cl_$keyword_delim_opt      0x00001000
#define cl_$no_keyword_delim_opt   0x00002000
#define cl_$comments_opt           0x00004000
#define cl_$no_comments_opt        0x00008000
#define cl_$star_names_opt         0x00010000
#define cl_$no_star_names_opt      0x00020000
#define cl_$save_nulls_opt         0x00040000
#define cl_$dump_nulls_opt         0x00080000
#define cl_$no_negnum_opt          0x00100000
#define cl_$negnum_opt             0x00200000

typedef short enum
{
    cl_$first,
    cl_$next
}
cl_$arg_select_t;

typedef short enum
{
    cl_$yes,
    cl_$no,
    cl_$quit,
    cl_$go
}
cl_$answer_t;

typedef short enum
{
    cl_$wild_files,
    cl_$wild_dirs,
    cl_$wild_links,
    cl_$wild_exclusive,
    cl_$wild_chase_links,
    cl_$wild_first
}
cl_$wild_t;

#define cl_$wild_files_opt      0x01
#define cl_$wild_dirs_opt       0x02
#define cl_$wild_links_opt      0x04
#define cl_$wild_exclusive_opt  0x08
#define cl_$wild_chase_liks_opt 0x10
#define cl_$wild_first_opt      0x20

typedef unsigned short cl_$wild_set_t;

typedef unsigned short cl_$attr_set_t;

typedef short enum
{
    cl_$required,
    cl_$optional
}
cl_$required_t;

typedef void *cl_$argv[128];

/*
 * Programs that get built for both /com and /usr/apollo should use
 * the following:
 *
 *  cl_$init(cl_$std_options | private_options, ...);
 */

#ifdef USR_APOLLO
# ifdef USR_APOLLO
    /* Suppress wildcard expansion and *file expansion */
#  define cl_$std_options (cl_$no_wildcards_opt | cl_$no_star_names_opt)
# else
#  define cl_$std_options 0
# endif
#else
# define cl_$std_options 0
#endif

/*
 * cl_$stdin_read is true iff the standard input stream was read to
 * acquire pathnames.
 */

extern boolean cl_$stdin_read;
extern linteger cl_$n_wildcards;    /* # wildcards read */

/*
 * cl_$init
 *
 * Initialize the command line package.
 */

void
cl_$init
(
    cl_$opt_set_t &opt,         /* option-set */
    char          *my_name,     /* caller's name */
    short int     &my_name_len  /* length of caller's name */
);

/*
 * cl_$setup
 *
 * This is like cl_$init, except that it does not load in anything to
 * parse.  You are expected to call one of the parse routines to do 
 * that yourself.  This is really no different than calling cl_$init
 * and then calling a parse routine, but it is a trifle cleaner/faster.
 */

void
cl_$setup
(
    cl_$opt_set_t &opt,         /* option-set */
    char          *my_name,     /* caller's name */
    short int     &my_name_len  /* length of caller's name */
);

/*
 * cl_$init_lib
 *
 * This initializes the command line package if not already done.  Does
 * not do argument stuff.  For use by libraries or when you do not want
 * to disturb existing initialization.  Existing init and setup
 * semantics will re-initialize, so can't use them.  Returns true if
 * init was necessary.
 */

boolean
cl_$init_lib
(
    cl_$opt_set_t &opt,         /* option-set */
    char          *my_name,     /* caller's name */
    short int     &my_name_len  /* length of caller's name */
);

/*
 * cl_$set_options
 *
 * This updates the option-set defined in the cl_$init call.
 */

void
cl_$set_options
(
    cl_$opt_set_t &opt          /* option-set */
);

/*
 * cl_$get_options
 *
 * This returns the current option-set.
 */

void
cl_$get_options
(
    cl_$opt_set_t *opt          /* option-set */
);

/*
 * cl_$reset_options
 *
 * This reinitializes the option-set.
 */

void
cl_$reset_options
(
    cl_$opt_set_t *opt          /* option-set */
);

/*
 * cl_$set_wild_options
 *
 * This sets the options to be passed to the wildcard matcher.
 */

void
cl_$set_wild_options
(
    cl_$wild_set_t *opt         /* wildcard options */
);

/*
 * cl_$match
 *
 * - compare string against keyword specification
 * key spec is
 *  <char>* '[' <char>* ']'
 * where first <char>s are the abbreviation; rest is full name
 */

boolean
cl_$match
(
    char  *pattern,
    char  *token,
    short &tlen
);

/*
 * cl_$get_set
 *
 * - analyze char string and create set.  Given an array of single
 * chars, will return a set, where n'th bit of set is on if n'th char
 * of array is in hte argument somewhere.  Duplicates, invalid chars
 * are detected.
 */

cl_$attr_set_t
cl_$get_set
(
    char  *chset,   /* set of chars, in order */
    short &clen,
    char  *arg,     /* argument to parse */
    short &alen
);

/*
 * cl_$get_flag
 *
 * This sees if a flag is present, markes it 'used', and counts the
 * number of tokens following it which are not preceded by "-."
 */

boolean
cl_$get_flag
(
    char  *pattern, /* pattern to match */
    short *tokens   /* # tokens following it w/o "-" */
);

/*
 * cl_$check_flag
 *
 * This sees if a flag is present, markes it 'used', and checks the
 * count of the number of tokens following it which are not preceded by
 * "-."  If the count is incorrect, a diagnostic is written to errout.
 * If the count is negative CL assumes that you want AT LEAST -count
 * arguments, but will accept more.
 */

boolean
cl_$check_flag
(
    char  *pattern,         /* pattern to match */
    short &expected_tokens  /* # tokens expected */
);

/*
 * cl_$get_enum_flag
 *
 * This scans the token list for one of the flags specified by the
 * caller.  If one is found, the index of the flag in the 
 * "pattern_string" is returned.  If none is found, zero is returned.
 * The patterns in the string must be separated by spaces.  The string
 * must be terminated by any non-space character other than "-."
 */

short
cl_$get_enum_flag
(
    cl_$arg_select_t &select,           /* first or next */
    char             *pattern_string,   /* patterns to look for */
    short            *tokens            /* # tokens following it w/o "-" */
);

/*
 * cl_$get_arg
 *
 * This gets the first or next unused argument from the command line.
 */

boolean
cl_$get_arg
(
    cl_$arg_select_t &select,   /* first or next */
    char             *value,    /* returned value */
    short            *len,      /* length, in characters */
    short            &maxlen    /* maximum length */
);

/*
 * cl_$get_num
 *
 * This gets the converted decimal integer from the next unused
 * argument from the command line.
 */

boolean
cl_$get_num
(
    long int *num   /* returned number */
);

/*
 * cl_$get_name
 *
 * This gets the first or next unused name from the command line.
 */

boolean
cl_$get_name
(
    cl_$arg_select_t &select,   /* first or next */
    char             *name,     /* returned name */
    short            *len,      /* length, in characters */
    short            &maxlen    /* maximum length */
);

/*
 * cl_$get_derived_name
 *
 * this gets the next derived name associated with the last name
 * returned by cl_$get_name.
 */

boolean
cl_$get_derived_name
(
    char  *name,    /* returned name */
    short *len,     /* length, in characters */
    short &maxlen   /* maximum length */
);

/*
 * cl_$get_flagged_derived_name
 *
 * This gets the derived name associated with the specified flag.
 */

boolean
cl_$get_flagged_derived_name
(
    char           *flag,       /* flag to search for */
    cl_$required_t &require,    /* optional | required name */
    char           *name,       /* returned name */
    short          *len,        /* length, in characters */
    short          &maxlen      /* maximum length */
);

/*
 * cl_$check_unclaimed
 *
 * This checks for any unclaimed flags and, if found, complains and
 * aborts.
 */

void
cl_$check_unclaimed
(
    void
);

/*
 * cl_$verify
 *
 * This verifies with the user that the program is supposed to operate
 * on this name.
 */

cl_$answer_t
cl_$verify
(
    char  *name,
    short &len
);

/*
 * cl_$get_flag_info
 *
 * This returns the actual text of the previously returned flag.
 */

void
cl_$get_flag_info
(
    char  *flag_ptr,    /* pointer to flag, NULL if no flag */
    short *flag_len     /* length of flag text */
);

/*
 * cl_$get_name_info
 *
 * This returns supplemental info about the previously returned name.
 */

void
cl_$get_name_info
(
    char  *wild_ptr,    /* pointer to wildcard name, NULL if no wc */
    short *wild_len     /* length of wildcard name */
);

/*
 * cl_$reread_names
 *
 * This causes all names to be re-read.  The first name is returned on 
 * the next cl_$get_name call.
 */

void
cl_$reread_names
(
    void
);

/*
 * cl_$reread_flags
 *
 * this causes all of the args (flags) in the list to be reread.
 */

void
cl_$reread_flags
(   
    void
);

/*
 * cl_$reread
 *
 * This causes the entire argument list to be reread.
 */

void
cl_$reread
(
    void
);

/*
 * cl_$parse_line
 *
 * This causes the supplied line to be parsed by CL.  Further calls to
 * the get_argument routines will return information from this line.
 * Any arguments which have not yet been read are destroyed by this 
 * call.
 */

void
cl_$parse_line
(
    char  *line,
    short &len
);

/*
 * cl_$parse_input
 *
 * This reads a line from the specified stream and hands it to 
 * cl_$parse_line.  True is returned if successful; false if end of file
 * has occurred.
 */

boolean
cl_$parse_input
(
    ios_$id_t &strid,
    boolean   *null_line
);

/*
 * cl_$set_name_prefix
 *
 * This defines a character string to prefix all names read from the
 * command line.  This is used when user-specified names are relative
 * to a specific directory.  (The print queue and network root
 * directories are examples.)
 */

void
cl_$set_name_prefix
(
    char  *prefix,
    short &prefix_len
);

/*
 * cl_$set_derived_count
 *
 * This identifies the number of derived names following each wildcard
 * name.
 */

void
cl_$set_derived_count
(
    short &count
);

/*
 * cl_$set_verb
 *
 * This defines a verb to be displayed prior to a pathname in each
 * query message.
 */

void
cl_$set_verb
(
    char  *verb,
    short &len
);

/*
 * cl_$parse_args
 *
 * This takes the argument vector given and makes it the current vector
 * for CL to parse.  Any previous arguments are discarded.
 */

void
cl_$parse_args
(
    short    &argc,
    cl_$argv &argv
);

/*
 * cl_$set_streams
 *
 * This tells CL to use the provided streams as the default input and
 * output channels.
 */

void
cl_$set_streams
(
    ios_$id_t &sti,
    ios_$id_t &sto,
    ios_$id_t &eri,
    ios_$id_t &ero
);

/*
 * cl_$set_callback
 *
 * This sets up a routine to take the place of error_$std_format.
 * This routine is expected to have the same prototype as
 * error_$std_format.
 *
 *  void
 *  error_$std_format
 *  (
 *      status_$t &status,
 *      char      *str,
 *      ...
 *  );
 *
 */

void
cl_$set_callback
(
    cl_$callback_ptr &errproc
);

/*
 * cl_$get_arg_count
 *
 * This returns the number of remaining unseen arguments.
 */

short
cl_$get_arg_count
(   
    void
);

#endif /* _us_cl_h */
