/*
 * pm.h
 *
 * Version 1.0 : Frederick Roeber : 2 March 1993
 *
 * This file contains additional information, to supplement <apollo/pm.h>.
 *
 */

#define pm_$already_named   (0x03010004)

/*
 * pm_$get_name
 *
 * This routine gets the name of a process identified by a uid.
 */

void
pm_$get_name
(
    uid_$t &uid,
    char *buffer,
    short *name_len_p,
    status_$t *status
);

/*
 * pm_$set_my_name
 *
 * This routine sets the name of the current process.
 */

void
pm_$set_my_name
(
    char *proc_name,
    short &name_len,
    status_$t *status
);

/*
 * pm_$set_name
 *
 * This routine sets the name of any process, identified by its uid.
 */

void
pm_$set_name
(
    char *proc_name,
    short &name_len,
    uid_$t &uid,
    status_$t *status
);

typedef
struct
{
    void *entry_point;
    short num_entries;
    struct
    {
        char name[32];
        void *start;
        unsigned long length;
    }
        sections[ 10 ]; /* Some random number */
}
    pm_$load_record_t;  /* Name's a pure guess on my part */

typedef unsigned short pm_$load_opts_t;

#define pm_$copy_proc               0x0001  /* like loader_$copy_proc */
#define pm_$install                 0x0002  /* like loader_$install */
#define pm_$no_unresolveds          0x0004  /* like loader_$no_unresolveds */
#define pm_$load_global             0x0008  /* like loader_$load_global */
#define pm_$dont_load_main          0x0010  /* like !loader_$load_main */
#define pm_$load_writable           0x0020  /* like loader_$load_writable */
#define pm_$opt_dummy_06            0x0040  /* not used? */
#define pm_$keep_on_exec            0x0080  /* like !loader_$load_main | loader_$keep_on_exec */
#define pm_$load_global_data        0x0100  /* like loader_$load_global_data */
#define pm_$dont_redefine           0x0200  /* like loader_$don_redefine */
#define pm_$opt_dummy_10            0x0400  /* not used? */
#define pm_$opt_dummy_11            0x0800  /* not used? */
#define pm_$opt_dummy_12            0x1000  /* not used? */
#define pm_$opt_dummy_13            0x2000  /* not used? */
#define pm_$opt_dummy_14            0x4000  /* not used? */
#define pm_$load_only_post_sr9_5    0x8000  /* like loader_$load_only_post_sr9_5 */

void
pm_$load
(
    char                *name,
    short               &name_len,
    pm_$load_opts_t     &opts,
    short               &n,         /* Number of sections in the load record */
    pm_$load_record_t   *load,
    status_$t           *status
);

void
pm_$load_uid
(
    uid_$t              &uid,
    pm_$load_opts_t     &opts,
    short               &n,         /* Number of sections in the load record */
    pm_$load_record_t   *load,
    status_$t           *status
);

void
pm_$call
(
    pm_$load_record_t   &load
);

short   /* pretty sure !long, !unsigned.anything */
pm_$get_session_id
(
    void
);

