#define socket_$unspec_port = 0;

typedef short enum
{
    socket_$unspec,                 /* Unspecified */
    socket_$unix,                   /* Local to host (pipes, portals) */
    socket_$internet,               /* Internetwork: TCP, UDP, etc */
    socket_$implink,                /* ARPAnet imp addresses */
    socket_$pup,                    /* PUP protocols: e.g. BSP */
    socket_$chaos,                  /* MIT CHAOS protocols */
    socket_$ns,                     /* XEROX NS protocols */
    socket_$nbs,                    /* NBS protocols */
    socket_$ecma,                   /* European computer manufacturers */
    socket_$datakit,                /* Datakit protocols */
    socket_$ccitt,                  /* CCITT protocols, X.25 etc */
    socket_$sna,                    /* IBM SNA */
    socket_$unspec2,
    socket_$dds                     /* Apollo DOMAIN/MSG protocol */
}
socket_$addr_family_t;

#define socket_$num_familes 32

#define socket_$sizeof_family   2
#define socket_$sizeof_data    14
#define socket_$sizeof_ndata   12
#define socket_$sizeof_hdata   12

typedef struct
{
    socket_$addr_family_t family;
    char data[ socket_$sizeof_data ];
}
socket_$addr_t;

typedef struct
{
    socket_$addr_family_t family;
    char data[ socket_$sizeof_ndata];
}
socket_$net_addr_t;

typedef struct
{
    socket_$addr_family_t family;
    char data[ socket_$sizeof_hdata];
}
socket_$host_id_t;

typedef
enum socket_$wk_ports_enum
{
    socket_$wk_fwd
}
socket_$wk_ports_t;

typedef char socket_$string_t[ 100 ];
typedef socket_$addr_t *socket_$addr_list_t;
typedef unsigned long *socket_$len_list_t;
typedef char socket_$local_sockaddr_t[ 50 ];

/* flags for socket_$equal */
#define socket_$eq_hostid   0x1
#define socket_$eq_netaddr  0x2
#define socket_$eq_port     0x4
#define socket_$eq_network  0x8

#define socket_$addr_module_code 0x10020000

#define socket_$buff_too_large            (socket_$addr_module_code +  1)
#define socket_$buff_too_small            (socket_$addr_module_code +  2)
#define socket_$bad_numeric_name          (socket_$addr_module_code +  3)
#define socket_$cant_find_name            (socket_$addr_module_code +  4)
#define socket_$cant_cvrt_addr_to_name    (socket_$addr_module_code +  5)
#define socket_$cant_get_local_name       (socket_$addr_module_code +  6)
#define socket_$cant_create_socket        (socket_$addr_module_code +  7)
#define socket_$cant_get_if_config        (socket_$addr_module_code +  8)
#define socket_$internal_error            (socket_$addr_module_code +  9)
#define socket_$family_not_valid          (socket_$addr_module_code + 10)
#define socket_$invalid_name_format       (socket_$addr_module_code + 11)

typedef
short enum socket_$domain_enum
{
    socket_$unspec_domain    =  0,    /* unspecified */
    socket_$unix_domain      =  1,    /* local to host (pipes, portals) */
    socket_$inet_domain      =  2,    /* internetwork: UDP, TCP, etc. */
    socket_$implink_domain   =  3,    /* arpanet imp addresses */
    socket_$pup_domain       =  4,    /* pup domains: e.g. BSP */
    socket_$chaos_domain     =  5,    /* mit CHAOS domains */
    socket_$ns_domain        =  6,    /* XEROX NS domains */
    socket_$nbs_domain       =  7,    /* nbs domains */
    socket_$ecma_domain      =  8,    /* european computer manufacturers */
    socket_$datakit_domain   =  9,    /* datakit domains */
    socket_$ccitt_domain     = 10,    /* CCITT domains, X.25 etc */
    socket_$sna_domain       = 11,    /* IBM SNA */
    socket_$decNET_domain    = 12,    /* DECnet */
    socket_$dli_domain       = 13,    /* Direct data link interface */
    socket_$lat_domain       = 14,    /* LAT */
    socket_$hylink_domain    = 15,    /* NSC Hyperchannel */
    socket_$appletalk_domain = 16,    /* Apple Talk */
    socket_$osi_domain       = 17,    /* OSI */
    socket_$max_domain       = 18
}
socket_$domain_t;

typedef 
short enum socket_$socket_type_enum
{
    socket_$stream_type    = 1,
    socket_$dgram_type     = 2,
    socket_$raw_type       = 3,
    socket_$rdm_type       = 4,
    socket_$seqpacket_type = 5
}
socket_$socket_type_t;

typedef
short enum socket_$protocol_enum
{
    socket_$unspec_protocol    =  0,    /* unspecified */
    socket_$unix_protocol      =  1,    /* local to host (pipes, portals) */
    socket_$inet_protocol      =  2,    /* internetwork: UDP, TCP, etc. */
    socket_$implink_protocol   =  3,    /* arpanet imp addresses */
    socket_$pup_protocol       =  4,    /* pup protocols: e.g. BSP */
    socket_$chaos_protocol     =  5,    /* mit CHAOS protocols */
    socket_$ns_protocol        =  6,    /* XEROX NS protocols */
    socket_$nbs_protocol       =  7,    /* nbs protocols */
    socket_$ecma_protocol      =  8,    /* european computer manufacturers */
    socket_$datakit_protocol   =  9,    /* datakit protocols */
    socket_$ccitt_protocol     = 10,    /* CCITT protocols, X.25 etc */
    socket_$sna_protocol       = 11,    /* IBM SNA */
    socket_$decNET_protocol    = 12,    /* DECnet */
    socket_$dli_protocol       = 13,    /* Direct data link interface */
    socket_$lat_protocol       = 14,    /* LAT */
    socket_$hylink_protocol    = 15,    /* NSC Hyperchannel */
    socket_$appletalk_protocol = 16,    /* Apple Talk */
    socket_$osi_protocol       = 17,    /* OSI */
    socket_$max_protocol       = 18
}
socket_$protocol_t;

#define socket_$address_data_size (16-sizeof(socket_$domain_t))
typedef char socket_$raw_address_data_t[ socket_$address_data_size ];
typedef unsigned short socket_$ip_port_t;
typedef unsigned long socket_$ip_addr_t;
typedef struct socket_$ip_address_data_struct
{
    socket_$ip_port_t port;
    socket_$ip_addr_t addr;
    char pad[8];
}
socket_$ip_address_data_t;

typedef union socket_$address_data_union
{
    socket_$raw_address_data_t raw;
    socket_$ip_address_data_t  ip;
}
socket_$address_data_t;

typedef
struct socket_$address_struct
{
    socket_$domain_t       family;
    socket_$address_data_t data;
}
socket_$address_t;

/* 
 * socket_$accept
 */

/*
 * socket_$bind
 *
 * Call the type manager's "bind" operation, to bind an address to
 * a socket.
 */

void
socket_$bind
(
    ios_$id_t         &s,       /* the socket */
    socket_$address_t &sa,      /* the address w/ port */
    short             &sa_len,  /* the length of sa */
    status_$t         *status   /* the usual status */
);


/*
 * socket_$connect
 *
 * Call the type manager's "connect" operation, to connect a socket
 * to an address.
 */

void
socket_$connect
(
    ios_$id_t         &s,       /* the socket */
    socket_$address_t &sa,      /* the address */
    short             &sa_len,  /* the length of sa */
    status_$t         *status   /* the usual status */
);

/*
 * socket_$connect_pair
 * socket_$control
 */

/*
 * socket_$create
 *
 * Create a socket of the specified family.
 */

ios_$id_t 
socket_$create
(
    socket_$domain_t      &domain,      /* aka address family */
    socket_$socket_type_t &type,        /* socket type */
    socket_$protocol_t    &protocol,    /* protocol family */
    ios_$id_t             *s,           /* stream identifier (also returned) */
    status_$t             *status       /* status value */
);

/*
 * socket_$create_type
 *
 * Create a socket of the family specified by type UID.
 */

ios_$id_t
socket_$create_type
(
    uid_$t                &domain_type, /* for address family; e.g., tcp_$uid */
    socket_$socket_type_t &type,        /* socket type */
    socket_$protocol_t    &protocol,    /* protocol family */
    ios_$id_t             *s,           /* stream identifier (also returned) */
    status_$t             *status       /* status value */
);

/* 
 * socket_$equal -- from <idl/socket.idl>
 * socket_$equal_
 *
 * Compare two sockaddrs.  The "flags" argument (see "socket_$eq_..." constants
 * defined above) determines how much of the sockaddrs are compared.
 */

boolean
socket_$equal
(
    socket_$addr_t &saddr1,
    unsigned long   slen1,
    socket_$addr_t &saddr2,
    unsigned long   slen2,
    unsigned long   flags,
    status_$t      *status
);

boolean
socket_$equal_
(
    socket_$addr_t &saddr1,
    unsigned long  &slen1,
    socket_$addr_t &saddr2,
    unsigned long  &slen2,
    unsigned long  &flags,
    status_$t      *status
);

/*
 * socket_$family_from_name -- from <idl/socket.idl>
 * socket_$family_from_name_
 *
 * Convert a text name of a protocol/address family to an integer family
 */

unsigned long
socket_$family_from_name
(
    socket_$string_t  name,
    unsigned long     namelen,
    status_$t        *status
);

unsigned long
socket_$family_from_name_
(
    socket_$string_t  name,
    unsigned long    &namelen,
    status_$t        *status
);

/*
 * socket_$family_to_name -- from <idl/socket.idl>
 * socket_$family_to_name_
 *
 * Convert a protocol/address family to a text name.
 */

void
socket_$family_to_name
(
    unsigned long     family,
    socket_$string_t  name,
    unsigned long    *namelen,
    status_$t        *status
);

void
socket_$family_to_name_
(
    unsigned long    &family,
    socket_$string_t  name,
    unsigned long    *namelen,
    status_$t        *status
);

/*
 * socket_$from_local_rep -- from <idl/socket.idl>
 * socket_$from_local_rep_
 *
 * Convert a "local" sockaddr type to a NCS socket_$addr_t.
 * This is really only useful/necessary on systems with
 * non-standard sockaddr structure layouts (e.g. cray unicos)
 * and even then, only if NCS based applications need to
 * use a system's socket primitives with NCS socket_$addr_t's.
 */

void
socket_$from_local_rep
(
    socket_$addr_t           *saddr,
    socket_$local_sockaddr_t  lcl_saddr,
    status_$t                *status
);

void
socket_$from_local_rep_
(
    socket_$addr_t           *saddr,
    socket_$local_sockaddr_t  lcl_saddr,
    status_$t                *status
);

/*
 * socket_$from_name -- from <idl/socket.idl>
 * socket_$from_name_
 *
 * Convert a text name and a port to a sockaddr.  If the family argument is
 * "socket_$unspec" (AF_UNSPEC, 0), then the name is scanned for a prefix of
 * "familyname:" (e.g. "ip:").  If name ends with "[nnn]", "nnn" is taken
 * to be the port number; otherwise, the port argument is used as the port
 * number.  If the host name is missing (e.g. "ip:[37] or "ip:"), the local
 * host name is assumed.  A leading "#" in the host name can be used to
 * indicate that the host name is in the standard numeric form.
 */

void
socket_$from_name
(
    unsigned long    family,
    socket_$string_t name,
    unsigned long    namelen,
    unsigned long    port,
    socket_$addr_t  *saddr,
    unsigned long   *slen,
    status_$t       *status
);

void
socket_$from_name_
(
    unsigned long   &family,
    socket_$string_t name,
    unsigned long   &namelen,
    unsigned long   &port,
    socket_$addr_t  *saddr,
    unsigned long   *slen,
    status_$t       *status
);

/*
 * socket_$get_option
 * socket_$get_peer_name
 */

/*
 * socket_$get_sock_name
 * 
 * Call the type manager's "get_sock_name" operation, to get the 
 * name of the address bound to a socket.
 */

void
socket_$get_sock_name
(
    ios_$id_t         &socket,
    socket_$address_t *saddr,
    short             *slen,
    short             &maxlen,
    status_$t         *status
);

/*
 * socket_$inq_broad_addrs -- from <idl/socket.idl>
 * socket_$inq_broad_addrs_
 *
 * Inquire the supported broadcast addresses supported by
 * family denoted by saddr.
 */

void
socket_$inq_broad_addrs
(
    unsigned long        family,
    unsigned long        port,
    socket_$addr_list_t  brd_addrs,
    socket_$len_list_t   brd_lens,
    unsigned long       *len,
    status_$t           *status
);

void
socket_$inq_broad_addrs_
(
    unsigned long       &family,
    unsigned long       &port,
    socket_$addr_list_t  brd_addrs,
    socket_$len_list_t   brd_lens,
    unsigned long       *len,
    status_$t           *status
);

/*
 * socket_$inq_hostid -- from <idl/socket.idl>
 * socket_$inq_hostid_
 *
 * Return the host ID part of a sockaddr.
 */

void
socket_$inq_hostid
(
    socket_$addr_t     &saddr,
    unsigned long       slen,
    socket_$host_id_t  *hid,
    unsigned long      *hlen,
    status_$t          *status
);

void
socket_$inq_hostid_
(
    socket_$addr_t     &saddr,
    unsigned long      &slen,
    socket_$host_id_t  *hid,
    unsigned long      *hlen,
    status_$t          *status
);

/*
 * socket_$inq_my_netaddr -- from <idl/socket.idl>
 * socket_$inq_my_netaddr_
 *
 * Return the primary network address for the specified family.
 */

void
socket_$inq_my_netaddr
(
    unsigned long       family,
    socket_$net_addr_t *naddr,
    unsigned long      *nlen,
    status_$t          *status
);

void
socket_$inq_my_netaddr_
(
    unsigned long      &family,
    socket_$net_addr_t *naddr,
    unsigned long      *nlen,
    status_$t          *status
);

/*
 * socket_$inq_netaddr -- from <idl/socket.idl>
 * socket_$inq_netaddr_
 *
 * Return the network address part of a sockaddr.
 */

void
socket_$inq_netaddr
(
    socket_$addr_t     &saddr,
    unsigned long       slen,
    socket_$net_addr_t *naddr,
    unsigned long      *nlen,
    status_$t          *status
);

void
socket_$inq_netaddr_
(
    socket_$addr_t     &saddr,
    unsigned long      &slen,
    socket_$net_addr_t *naddr,
    unsigned long      *nlen,
    status_$t          *status
);

/*
 * socket_$inq_port -- from <idl/socket.idl>
 * socket_$inq_port_
 *
 * Return the port field in a sockaddr.
 */

unsigned long
socket_$inq_port
(
    socket_$addr_t &saddr,
    unsigned long   slen,
    status_$t      *status
);

unsigned long
socket_$inq_port_
(
    socket_$addr_t &saddr,
    unsigned long  &slen,
    status_$t      *status
);

/*
 * socket_$inquire
 */

void
socket_$isa
(
    ios_$id_t &s,
    status_$t *st
);

/* 
 * socket_$listen
 */

/*
 * socket_$max_pkt_size -- from <idl/socket.idl>
 * socket_$max_pkt_size_
 *
 * Return the max pkt size for a protocol family.
 */

unsigned long
socket_$max_pkt_size
(
    unsigned long  family,
    status_$t     *status
);

unsigned long
socket_$max_pkt_size_
(
    unsigned long &family,
    status_$t     *status
);

/*
 * socket_$recv
 * socket_$recv_from
 * socket_$recv_it
 * socket_$recv_msg
 * socket_$send
 * socket_$send_it
 * socket_$send_msg
 * socket_$send_to
 */

/*
 * socket_$set_broadcast -- from <idl/socket.idl>
 * socket_$set_broadcast_
 *
 * Set a sockaddr so that sends on it will broadcast.
 */

void
socket_$set_broadcast
(
    socket_$addr_t *saddr,
    unsigned long  *slen,
    status_$t      *status
);

void
socket_$set_broadcast_
(
    socket_$addr_t *saddr,
    unsigned long  *slen,
    status_$t      *status
);

/*
 * socket_$set_hostid -- from <idl/socket.idl>
 * socket_$set_hostid_
 *
 * Set the host ID part of a sockaddr.
 */

void
socket_$set_hostid
(
    socket_$addr_t    *saddr,
    unsigned long     *slen,
    socket_$host_id_t &hid,
    unsigned long      hlen,
    status_$t         *status
);

void
socket_$set_hostid_
(
    socket_$addr_t    *saddr,
    unsigned long     *slen,
    socket_$host_id_t &hid,
    unsigned long     &hlen,
    status_$t         *status
);

/*
 * socket_$set_netaddr -- from <idl/socket.idl>
 * socket_$set_netaddr_
 *
 * Set the network address part of a sockaddr.
 */

void
socket_$set_netaddr
(
    socket_$addr_t     *saddr,
    unsigned long      *slen,
    socket_$net_addr_t &naddr,
    unsigned long       nlen,
    status_$t          *status
);

void
socket_$set_netaddr_
(
    socket_$addr_t     *saddr,
    unsigned long      *slen,
    socket_$net_addr_t &naddr,
    unsigned long      &nlen,
    status_$t          *status
);

/*
 * socket_$set_option
 */

/*
 * socket_$set_port -- from <idl/socket.idl>
 * socket_$set_port_
 *
 * Set the port field in a sockaddr to the specified value.
 */

void
socket_$set_port
(
    socket_$addr_t *saddr,
    unsigned long  *slen,
    unsigned long   port,
    status_$t      *status
);

void
socket_$set_port_
(
    socket_$addr_t *saddr,
    unsigned long  *slen,
    unsigned long  &port,
    status_$t      *status
);

/*
 * socket_$set_wk_port -- from <idl/socket.idl>
 * socket_$set_wk_port_
 *
 * Set a sockaddr's port to a well-known value.
 */

void
socket_$set_wk_port
(
    socket_$addr_t *saddr,
    unsigned long  *slen,
    unsigned long   port,
    status_$t      *status
);

void
socket_$set_wk_port_
(
    socket_$addr_t *saddr,
    unsigned long  *slen,
    unsigned long  &port,
    status_$t      *status
);

/*
 * socket_$shutdown
 */

/*
 * socket_$to_local_rep -- from <idl/socket.idl>
 * socket_$to_local_rep_
 *
 * Convert a NCS socket_$addr_t to a "local" sockaddr type.
 * This is really only useful/necessary on systems with
 * non-standard sockaddr structure layouts (e.g. cray unicos)
 * and even then, only if NCS based applications need to
 * use a system's socket primitives with NCS socket_$addr_t's.
 */

void
socket_$to_local_rep
(
    socket_$addr_t           &saddr,
    socket_$local_sockaddr_t  lcl_saddr,
    status_$t                *status
);

void
socket_$to_local_rep_
(
    socket_$addr_t           &saddr,
    socket_$local_sockaddr_t  lcl_saddr,
    status_$t                *status
);

/*
 * socket_$to_name -- from <idl/socket.idl>
 * socket_$to_name_
 *
 * Convert a sockaddr to a text name and a port.  The next name will have
 * the form "familyname:hostname".  "hostname" may be of the standard numeric
 * form if a more useful name can not be divined.
 */

void
socket_$to_name
(
    socket_$addr_t   &saddr,
    unsigned long     slen,
    socket_$string_t  name,
    unsigned long    *namelen,
    unsigned long    *port,
    status_$t        *status
);

void
socket_$to_name_
(
    socket_$addr_t   &saddr,
    unsigned long    &slen,
    socket_$string_t  name,
    unsigned long    *namelen,
    unsigned long    *port,
    status_$t        *status
);

/* 
 * socket_$to_numeric_name -- from <idl/socket.idl>
 * socket_$to_numeric_name_
 *
 * Like "socket_$to_name", except the hostname string will be of the standard
 * numeric form for the family (e.g. "10.2.0.9" for IP and "29C27.809C" for
 * DDS).
 */

void
socket_$to_numeric_name
(
    socket_$addr_t   &saddr,
    unsigned long     slen,
    socket_$string_t  name,
    unsigned long    *namelen,
    unsigned long    *port,
    status_$t        *status
);

void
socket_$to_numeric_name_
(
    socket_$addr_t   &saddr,
    unsigned long    &slen,
    socket_$string_t  name,
    unsigned long    *namelen,
    unsigned long    *port,
    status_$t        *status
);


/*
 * socket_$valid_families -- from <idl/socket.idl>
 * socket_$valid_families_
 *
 * Return the list of valid address/protocol families.  The status variable is
 * set if there is not enough room in the output array for all the valid families.
 */

void
socket_$valid_families
(
    unsigned long         *num,
    socket_$addr_family_t *families,
    status_$t             *status
);

void
socket_$valid_families_
(
    unsigned long         *num,
    socket_$addr_family_t *families,
    status_$t             *status
);


/*
 * socket_$valid_family -- from <idl/socket.idl>
 * socket_$valid_family_
 *
 * Return whether an address/protocol family is OK to use.
 */

boolean
socket_$valid_family
(
    unsigned long &family,
    status_$t     *st
);

boolean
socket_$valid_family_
(
    unsigned long &family,
    status_$t     *st
);

