{*****************************************************************************
 *****                                                                   *****
 *****                         NETWORK.INS.PAS                           *****
 *****                                                                   *****
 *****      Insert file for programs using the NETWORK library of        *****
 *****      routines to get info about the node and users on the         *****
 *****      Apollo DOMAIN network.                                       *****
 *****                            Version 6                              *****
 *****                  David M. Krowitz March 17, 1987.                 *****
 *****                                                                   *****
 *****      Copyright (c) 1987                                           *****
 *****      David M. Krowitz                                             *****
 *****      Massachusetts Institute of Technology                        *****
 *****      Department of Earth, Atmospheric, and Planetary Sciences     *****
 *****************************************************************************
}
TYPE

    network_$node_id_t      =   array[1..5] of char;
    network_$entry_dir_t    =   array[1..32] of char;
    network_$user_name_t    =   array[1..32] of char;
    network_$user_sid_t     =   array[1..140] of char;
    network_$pathname_t     =   array[1..256] of char;

    network_$node_data_t    =   RECORD
                        node_id:        network_$node_id_t;     {5 digit hex. node ID}
                        entry_dir:      network_$entry_dir_t;   {Entry directory of node}
                        entry_len:      integer16;              {Length of entry dir}
                        catalog_dir:    network_$entry_dir_t;   {Name node cataloged by (same as entry dir for nodes with disks)}
                        catalog_len:    integer16;              {Length of catalog name (0 if diskless node not catalogged)}
                        diskless:       boolean;                {TRUE if node is diskless}
                        partner_id:     network_$node_id_t;     {Node ID of partner for diskless nodes}
                        END;

    network_$node_array_t   =   array[1..1024] of network_$node_data_t;

    network_$user_t         =   RECORD
                        user_sid:       network_$user_sid_t;    {SID of user logged into nodes' DM}
                        user_len:       integer16;              {Length of user SID}
                        node_id:        network_$node_id_t;     {5 digit hex. node ID}
                        entry_dir:      network_$entry_dir_t;   {Entry directory of node}
                        entry_len:      integer16;              {Length of entry dir}
                        catalog_dir:    network_$entry_dir_t;   {Name node cataloged by (same as entry dir for nodes with disks)}
                        catalog_len:    integer16;              {Length of catalog name (0 if diskless node not catalogged)}
                        diskless:       boolean;                {TRUE if node is diskless}
                        END;

    network_$user_array_t   =   array[1..1024] of network_$user_t;

    network_$index_list_t   =   array[1..1024] of pinteger;



    {List all nodes which are currently responding on the Apollo
     DOMAIN network. Use the LCNODE command to get a list of all
     of the currently catalogged nodes.}

    PROCEDURE network_$list_nodes (
                                OUT node_array:     network_$node_array_t;
                                OUT num_nodes:      pinteger
                                );EXTERN;



    {Check that a given node is on the DOMAIN network and find
     the index to the node's entry in the list of nodes supplied
     by NETWORK_$LIST_NODES so that we can look up its node ID.}

    PROCEDURE network_$find_node (
                                IN  catalog_dir:    network_$entry_dir_t;
                                IN  catalog_len:    pinteger;
                                IN  node_list:      network_$node_array_t;
                                IN  num_nodes:      pinteger;
                                OUT index:          pinteger
                                );EXTERN;



    {Check that a given node is on the DOMAIN network and find
     the index to the node's entry in the list of nodes supplied
     by NETWORK_$LIST_NODES so that we can look up its entry
     directory and see whether or not it is a diskless node.}

    PROCEDURE network_$find_node_id (
                                IN  node_id:        network_$node_id_t;
                                IN  node_list:      network_$node_array_t;
                                IN  num_nodes:      pinteger;
                                OUT index:          pinteger
                                );EXTERN;



    {List all users logged into the Apollo DOMAIN network.
     Use the LUSR command to get a list of all of the people who
     are logged in to the display manager of each node on the 
     network.}

    PROCEDURE network_$list_users (
                                OUT user_array:     network_$user_array_t;
                                OUT num_users:      pinteger
                                );EXTERN;



    {Find all the nodes that a given user is logged into on the DOMAIN network.
     Use the list of users logged into each node's display manager which
     is returned by NETWORK_$LIST_USERS to find which nodes a given user
     is logged into. Return a list of indices into the user-list for the
     nodes which they are logged into. Return an index_count of 0 if they
     are not logged in anywhere.}

    PROCEDURE network_$find_user (
                                IN  user_name:      network_$user_name_t;
                                IN  user_name_len:  pinteger;
                                IN  user_list:      network_$user_array_t;
                                IN  num_users:      pinteger;
                                OUT index_list:     network_$index_list_t;
                                OUT index_count:    pinteger
                                );EXTERN;



    {Check that a user is logged into a particular node on the DOMAIN network.
     Use the list of users logged into each node's display manager which
     is returned by NETWORK_$LIST_USERS and the list of nodes on the
     network returned by NETWORK_$LIST_NODES to check if a user is
     logged into a particular node. Return both an index into the user-list
     and an index into the node-list. Return index counts of 0 if the
     user is not logged into the particular node.}

    PROCEDURE network_$find_user_at_node_id (
                                IN  node:           network_$node_id_t;
                                IN  user_name:      network_$user_name_t;
                                IN  user_name_len:  pinteger;
                                IN  user_list:      network_$user_array_t;
                                IN  num_users:      pinteger;
                                OUT user_index:     pinteger
                                );EXTERN;



    {Return the name of the user who owns this process.
     Extract the user name from the full user SID of this
     process (ie. throw away the project, organization, and
     node ID numbers).}

    PROCEDURE network_$get_proc_user_name (
                                OUT user_name:      network_$user_name_t;
                                OUT name_length:    pinteger
                                );EXTERN;



    {Return the full SID of the owner of this process.
     Included with the NETWORK calls for completeness of
     the library even though it duplicates a PM call.}

    PROCEDURE network_$get_proc_user_sid (
                                OUT user_sid:       network_$user_sid_t;
                                OUT sid_length:     pinteger
                                );EXTERN;



    {Return the node ID number of the node running this process.
     Extract the node ID from the full user SID of this process
     (ie. throw away the user name and the project and
     organization numbers).}

    PROCEDURE network_$get_proc_node_id (
                                OUT user_sid:       network_$node_id_t
                                );EXTERN;



    {Return the entry directory of the node running this process.
     Extract this info from the full pathname of the `NODE_DATA
     directory of the node.}

    PROCEDURE network_$get_proc_entry_dir (
                                OUT entry_dir:      network_$entry_dir_t;
                                OUT entry_len:      integer16;
                                OUT diskless_flag:  boolean
                                );EXTERN;



    {Return the home directory of the specified user.
     The user name can be short (eg. "krowitz") or long
     with project and organization fields, but not a node ID
     field (eg. "krowitz.none.jordan"). The name may contain
     wildcards (eg. "krowitz.%.jordan"), in which case the
     first matching entry from the registry is returned.
     Note that the user name is in a variable of the type
     NETWORK_$USER_SID_T not NETWORK_$USER_NAME_Tin order
     to provide enough characters for long names and wild cards.}

    PROCEDURE network_$get_user_home_dir (
                                IN  user_name:      network_$user_sid_t;
                                IN  name_len:       pinteger;
                                OUT home_dir:       network_$pathname_t;
                                OUT dir_len:        pinteger
                                );EXTERN;



    {Return the full name of the specified user.
     The user name is in the short form without wildcards,
     project, or organization (eg. "krowitz" but not
     "krowitz.sys_admin" or "krowitz.%.%"). Note that the
     full name is returned in a variable of the type
     NETWORK_$USER_SID_T in order to have enough space for
     the user's full name.}

    PROCEDURE network_$get_user_full_name (
                                IN  user_name:      network_$user_name_t;
                                IN  name_len:       pinteger;
                                OUT full_name:      network_$user_sid_t;
                                OUT full_len:       pinteger
                                );EXTERN;

