/*
    Derived from Domain/OS:
    type_uids.h /usr/include/apollo, ers, 09/29/84
    object type uid declarations.
*/


typedef struct {
        long high;
        long low;
} uid__t;                           /* for type uids returned by streams */

typedef struct {
	uid__t	uid;
	char	desc[20];
	long	hdr_sz;
} uid_tab;

/* Following are derived from extern consts         */
/* in Apollo type_uids.h, plus some other observed  */
/* values, plus others from Frederick Roeber.       */
/*                     high        low              */
#define UID_BITMAP     0x317,      0x0
#define UID_CASE_HM    0x316,      0x0
#define UID_CMPEXE     0x325,      0x0
#define UID_COFF       0x322,      0x0
#define UID_D3M_AREA   0x30e,      0x0
#define UID_D3M_SCH    0x30f,      0x0
#define UID_DDF        0x30b,      0x0
#define UID_DEV_TTY    0x324,      0x0
#define UID_DIR        0x312,      0x0
#define UID_DM_EDIT    0x31a,      0x0
#define UID_HDRU       0x301,      0x0
#define UID_IPAD       0x309,      0x0
#define UID_IPCSOCK    0x31f,      0x0
#define UID_LHEAP      0x319,      0x0
#define UID_MBX        0x30c,      0x0
#define UID_MT         0x314,      0x0
#define UID_NULL       0x30d,      0x0
#define UID_OBJ        0x302,      0x0
#define UID_OBJLIB     0x318,      0x0
#define UID_OSIO       0x326,      0x0
#define UID_OS_PG_FILE 0x323,      0x0
#define UID_PAD        0x305,      0x0
#define UID_PIPE       0x310,      0x0
#define UID_PTY_SLAVE  0x31d,      0x0
#define UID_PTY        0x31c,      0x0
#define UID_REC        0x300,      0x0
#define UID_SIO        0x30a,      0x0
#define UID_SLINK      0x31e,      0x0
#define UID_SYSBOOT    0x315,      0x0
#define UID_TCP        0x31b,      0x0
#define UID_UASC       0x311,      0x0
#define UID_UNIX_DIR   0x313,      0x0
#define UID_UNSTRUCT   0x321,      0x0
#define UID_VTE        0x320,      0x0
#define UID_UNDEF      0x304,      0x0
#define UID_NIL        0x0  ,	   0x0
#define UID_COMPRESS   0x40c9eb63, 0x40018ec0

#define DESC_BITMAP    "bitmap"
#define DESC_CASE_HM   "case_hm"  
#define DESC_CMPEXE    "cmpexe"   
#define DESC_COFF      "coff"     
#define DESC_D3M_AREA  "d3m_area" 
#define DESC_D3M_SCH   "d3m_sch"  
#define DESC_DEV_TTY   "dev_tty"  
#define DESC_DIR       "dir"      
#define DESC_DM_EDIT   "dm_edit"  
#define DESC_HDRU      "hdru"     
#define DESC_IPAD      "ipad"     
#define DESC_MBX       "mbx"      
#define DESC_MT        "mt"       
#define DESC_NULL      "null"     
#define DESC_OBJ       "obj"      
#define DESC_OSIO      "osio"     
#define DESC_PAD       "pad"      
#define DESC_PIPE      "pipe"      
#define DESC_PTY_SLAVE "pty_slave"
#define DESC_PTY       "pty"      
#define DESC_REC       "rec"      
#define DESC_SIO       "sio"      
#define DESC_TCP       "tcp"      
#define DESC_UASC      "uasc"     
#define DESC_UNSTRUCT  "unstruct" 
#define DESC_NIL       "nil" 
#define DESC_COMPRESS  "compress" 
     
