/*
 *	finfo.h - information about files
 */

#ifndef	FINFO_H
#define	FINFO_H

#include <sys/stat.h>

#define	filetype(m)	((m) & S_IFMT)

#define	isdir(m)	(filetype(m) == S_IFDIR)
#define	islink(m)	(filetype(m) == S_IFLNK)

#define	mode_uid(m)	((m) & S_ISUID)
#define	mode_gid(m)	((m) & S_ISGID)

#if	defined(S_ISTXT) && !defined(S_ISVTX)
#define	S_ISVTX		S_ISTXT
#endif	/* defined(S_ISTXT) && !defined(S_ISVTX) */

#define	mode_vtx(m)	((m) & S_ISVTX)

#define	mode_usr(m)	((m) & S_IRWXU)
#define	mode_grp(m)	((m) & S_IRWXG)
#define	mode_oth(m)	((m) & S_IRWXO)

#endif	/* FINFO_H */
