/*
 *	rbak.h - command line parsing and file operations
 */

#ifndef	RBAK_H
#define	RBAK_H

typedef	struct attrib {			/* attributes for files/directories */
	time_t		at_mtime;
	int		at_mode;
	int		at_uid;
	int		at_gid;
} attrib;

typedef	struct linktab {		/* table for hard links */
	char		*lt_name;
	inode		lt_inode;
	struct linktab	*lt_next;
} linktab;

typedef	struct pathtab {		/* table for pathnames */
	char		*pt_name;
	char		*pt_rename;
	int		pt_found;
	struct pathtab	*pt_next;
} pathtab;

typedef	struct keeptab {		/* table for preserved pathnames */
	char		*kt_name;
	struct keeptab	*kt_next;
} keeptab;

#define	F_TYPE	0	/* file */
#define	D_TYPE	1	/* directory */
#define	L_TYPE	2	/* link */

#define	EX_CREATE	0x0
#define	EX_REPLACE	0x1
#define	EX_MERGE	0x2

#define	EX_MERGE_SOURCE	(EX_MERGE|EX_REPLACE)
#define	EX_MERGE_DEST	(EX_MERGE|EX_CREATE)

#define	DIR_MODE	0777

void	set_opts PROTO((char **));
void	run_rbak PROTO((void));

int	read_block PROTO((void));

void	copy_namelen PROTO((char *, char *, int));

int	check_exist PROTO((char *, int));

void	make_dir PROTO((char *, int));

void	open_file PROTO((char *));
void	close_file PROTO((char *, attrib *));

void	type_handler PROTO((uid__t *, long *, char **));

long	get_size PROTO((char *, long));

void	dir_attrib PROTO((char *, attrib *));
void	get_attrib PROTO((char *, long, attrib *));
int	set_attrib PROTO((char *, attrib *, int));

void	get_inode PROTO((inode *, char *, long));
void	copy_inode PROTO((inode *, inode *));
int	cmp_inode PROTO((inode *, inode *));

int	check_link PROTO((char *, long));
int	make_link PROTO((char *, char *, long));
linktab	*find_link PROTO((char *, inode *));

void	ask_fileno PROTO((void));

void	ask_path PROTO((void));
void	add_path PROTO((char *));
void	rename_path PROTO((char *));
int	sel_path PROTO((char *));
void	adjust_path PROTO((char *));

void	add_keep PROTO((char *));
int	sel_keep PROTO((char *));

vmem_t	get_memory PROTO((unsigned int));

short	get_short PROTO((A_short));
long	get_long PROTO((A_long));

#ifdef	notused
char 	*ctime_apollo PROTO((time_apollo *));
#endif	/* notused */

void	downcase_name PROTO((char *));
int	convert_rec PROTO((unsigned char *, int));
int	ask_vol_swap PROTO((void));

#endif	/* RBAK_H */
