/*
 *	sock.h - sockets and associated options
 */

#ifndef	SOCK_H
#define	SOCK_H

#ifndef	apollo
#if	defined(__hpux) && (_POSIX_VERSION <= 198808L)
#include <netinet/in.h>
#endif	/* defined(__hpux) && (_POSIX_VERSION <= 198808L) */

#include <sys/uio.h>
#include <sys/socket.h>

#if	(defined(__hpux) && (_POSIX_VERSION > 198808L)) || defined(__386BSD__)
typedef	void	*sockoptval_t;
#else
typedef	char	*sockoptval_t;
#endif	/* (defined(__hpux) && (_POSIX_VERSION > 198808L)) || defined(__386BSD__) */

#define	SOCKOPT		/* set input buffer size for socket */

#define	SO_RCVBUF_DEC	1024
#define	SO_RCVBUF_MAX	(8*SO_RCVBUF_DEC)
#endif	/* apollo */

#endif	/* SOCK_H */
