/*
 *	remote.c - remote magtape protocol
 *
 *	This is based on code from dump(8) and restore(8) ...
 *
 *	@(#)dumprmt.c	5.5 (Berkeley) 10/22/87
 *
 *	Note:	The manual page for rmt(8) should not be trusted
 *		on many systems!
 */

#include "lang.h"
#include "std.h"
#include "var.h"
#include "sio.h"
#include "char.h"
#include "str.h"
#include "lim.h"
#include "pathnames.h"
#include "sig.h"
#include "sock.h"
#include "net.h"
#include "passwd.h"
#include "remote.h"
#include "error.h"

extern char	*devname;

int	rfd;

#define	RMTSIZE	(MAXPATHLEN+16)

#if	RMTSIZE < BUFSIZ
#undef	RMTSIZE
#define	RMTSIZE	BUFSIZ
#endif	/* RMTSIZE < BUFSIZ */

char	fu_nrmtu[] = "remote user name is missing";
char	fu_nrmth[] = "remote host name is missing";
char	fu_nrmtd[] = "remote device path is missing";
char	fu_longd[] = "remote device path name too long";

#ifdef	__STDC__
void	rmt_open(void)
#else
void	rmt_open()
#endif	/* __STDC__ */
{
	char	*ruser;
	char	*rhost;
	char	*rdevice;

	struct servent	*sp;
	struct passwd	*pw;

	rdevice = rindex(devname, COLON);

	if (rdevice == (char *) 0)
		erroru(fu_nrmtd);

	*rdevice++ = CNULL;

	if (*rdevice == CNULL)
		erroru(fu_nrmtd);

	if (strlen(rdevice) > MAXPATHLEN)
		erroru(fu_longd);

	rhost = rindex(devname, AT);

	if (rhost != (char *) 0) {
		*rhost++ = CNULL;
		ruser = devname;

		if (*ruser == CNULL)
			erroru(fu_nrmtu);
	} else {
		rhost = devname;
		ruser = (char *) 0;
	}

	if (*rhost == CNULL)
		erroru(fu_nrmth);

	sp = getservbyname(RSH_SERVICE, RSH_PROTOCOL);
	if (sp == (struct servent *) 0)
		errorm(RSH_ERROR);

	pw = getpwuid((pw_uid_t) getuid());
	if ((pw == (struct passwd *) 0) || (*pw->pw_name == CNULL))
		errorm("unable to determine username");

	if (ruser == (char *) 0)
		ruser = pw->pw_name;

	(void) signal(SIGPIPE, (sig_func_t) rmt_lostcon);

	rfd = rcmd(&rhost, (u_short) sp->s_port,
	           pw->pw_name, ruser,
	           PATH_RMT, (int *) 0);
	if (rfd < 0)
		errorm("unable to establish connection to remote host");

#ifdef	SOCKOPT
	{
		int	size;

		for (size = SO_RCVBUF_MAX; size > 0; size -= SO_RCVBUF_DEC)
			if (setsockopt(rfd,
			               SOL_SOCKET,
			               SO_RCVBUF,
			               (sockoptval_t) &size,
			               sizeof(size)) >= 0)
				break;
	}
#endif	/* SOCKOPT */

	(void) rmt_call("O%s\n%d\n", rdevice, O_RDONLY);
}

#ifdef	__STDC__
int	rmt_read(char *buf, int len)
#else
int	rmt_read(buf, len)
char	*buf;
int	len;
#endif	/* __STDC__ */
{
	int	n = rmt_call("R%d\n", len);

	if (n < 0) {
		errno = -n;
		errorm("remote read error");
	}

	if (n == 0)
		return(0);

	if (n != len)
		errorm("remote read length mismatch");

	{
		int	i;
		int	c;

		for (i = 0; i < n; i += c) {
			c = read(rfd,
			         (read_buf_t) (buf+i),
			         (read_size_t) (n-i));

			if (c <= 0)
				rmt_lostcon();
		}
	}

	return(1);
}

#ifdef	__STDC__
void	rmt_ioctl(int op, int count)
#else
void	rmt_ioctl(op, count)
int	op;
int	count;
#endif	/* __STDC__ */
{
	(void) rmt_call("I%d\n%d\n", op, count);
}

#ifdef	__STDC__
void	rmt_close(void)
#else
void	rmt_close()
#endif	/* __STDC__ */
{
	(void) rmt_call("C\n");

	if (close(rfd) < 0)
		rmt_lostcon();
}

/*VARARGS1*/
int	rmt_call(va_alist)	/* XXX - should use stdarg.h for ANSI C */
va_dcl
{
	char	buf[RMTSIZE];

	{
		va_list	args;
		char	*fmt;

		va_start(args);

		fmt = va_arg(args, char *);
		(void) vsprintf(buf, fmt, args);

		va_end(args);
	}

	{
		int	len = strlen(buf);

		if (write(rfd, (write_buf_t) buf, (write_size_t) len) != len)
			rmt_lostcon();
	}

	return rmt_reply();
}

char	fr_botch[] = "protocol to remote tape server botched";

#ifdef	__STDC__
int	rmt_reply(void)
#else
int	rmt_reply()
#endif	/* __STDC__ */
{
	char	buf[BUFSIZ];
	int	code;

	rmt_gets(buf, sizeof(buf));

	if (sscanf(buf+1, "%d", &code) != 1) {
		(void) fprintf(stderr, "Remote error: %s\n", buf);
		erroru(fr_botch);
	}

	switch (*buf) {
		case 'E':
		case 'F':
			if (code <= 0)
				erroru(fr_botch);

			rmt_gets(buf, sizeof(buf));

			erroru(buf);
			break;
		case 'A':
			return(code);
		default:
			erroru(fr_botch);
			break;
	}

	/*NOTREACHED*/
#if	defined(lint) && defined(LINT_IGNORES_NOTREACHED)
	return(0);
#endif	/* defined(lint) && defined(LINT_IGNORES_NOTREACHED) */
}

#ifdef	__STDC__
void	rmt_gets(char *buf, int len)
#else
void	rmt_gets(buf, len)
char	*buf;
int	len;
#endif	/* __STDC__ */
{
	while (len > 1) {
		*buf = rmt_getc();

		if (*buf == NL) {
			*buf = CNULL;
			return;
		}

		++buf;
		--len;
	}

	errorm(fr_botch);
	/*NOTREACHED*/
}

#ifdef	__STDC__
int	rmt_getc(void)
#else
int	rmt_getc()
#endif	/* __STDC__ */
{
	char	c;

	if (read(rfd, (read_buf_t) &c, (read_size_t) sizeof(c)) != sizeof(c))
		rmt_lostcon();

	return(c);
}

#ifdef	__STDC__
void	rmt_lostcon(void)
#else
void	rmt_lostcon()
#endif	/* __STDC__ */
{
	errorm("lost connection to remote host");
}
