/*
 *	remove.c - recursive removal of files and directories
 *
 *	This is based on code from rm(1) ...
 *
 *	@(#)rm.c	4.22 (Berkeley) 4/21/88
 */

#include "lang.h"
#include "std.h"
#include "char.h"
#include "str.h"
#include "lim.h"
#include "dio.h"
#include "finfo.h"
#include "remove.h"
#include "error.h"

#define	RMPATHLEN	(MAXNAMLEN+MAXPATHLEN+2)

char	rmpath[RMPATHLEN];	/* buffer for path */
char	*rmpathp;		/* current pointer to end of path */

	/*
	 *	rm -rf arg
	 */

#ifdef	__STDC__
void	rremove(char *arg, int level)
#else
void	rremove(arg, level)
char	*arg;
int	level;
#endif	/* __STDC__ */
{
	struct stat	buf;		/* for finding out what a file is */
	struct dirent	*dp;		/* for reading a directory */
	DIR	*dirp;			/* ... ditto */
	char	prevname[MAXNAMLEN+1];	/* previous name for recursion */
	char	*cp;

	if (isdot(arg))
		errorm("cannot remove `.' or `..'");

	if (lstat(arg, &buf) < 0)
		errorp(arg);

	if (isdir(buf.st_mode)) {
		if (access(arg, R_OK|W_OK|X_OK) != 0) {
			int	saverrno = errno;

			if (rmdir(arg) == 0)
				return;	/* salvaged: removed empty dir */

			errno = saverrno;
			errorp(arg);
		}

		if ((dirp = opendir(arg)) == NULL)
			errorp(arg);

		if (level == 0) {
			rmpathp = rmpath;
			*rmpathp = CNULL;

			append(arg);
		}

		prevname[0] = CNULL;

		while ((dp = readdir(dirp)) != NULL) {
			if (isdot(dp->d_name)) {
				(void) strcpy(prevname, dp->d_name);
				continue;
			}

			(void) closedir(dirp);

			append(dp->d_name);
			rremove(rmpath, level+1);

			for (cp = rmpathp; (*--cp != SLASH) && (cp > rmpath); )
				;

			rmpathp = cp;
			*cp++ = CNULL;

			if ((dirp = opendir(arg)) == NULL)
				errorp(arg);

			/* pick up where we left off */
			if (prevname[0] != CNULL)
				while (((dp = readdir(dirp)) != NULL) &&
				       (strcmp(prevname, dp->d_name) != 0))
					;
		}

		(void) closedir(dirp);

		if (level == 0) {
			rmpathp = rmpath;
			*rmpathp = CNULL;
		}

		if (rmdir(arg) < 0)
			errorp(arg);

		return;
	}

	if (unlink(arg) < 0)
		errorp(arg);
}

extern char	fe_toolong[];

	/*
	 *	append name to path
	 */

#ifdef	__STDC__
void	append(char *name)
#else
void	append(name)
char	*name;
#endif	/* __STDC__ */
{
	int	n = strlen(name);

	if ((rmpathp+n+2) > (rmpath+RMPATHLEN))
		errorm(fe_toolong);

	if ((rmpathp != rmpath) && (rmpathp[-1] != SLASH))
		*rmpathp++ = SLASH;

	(void) strcpy(rmpathp, name);

	rmpathp += n;
}
