/*
 *	lang.h - C language differences
 */

#ifndef	LANG_H
#define	LANG_H

#if	defined(lint) && defined(apollo)
#define	__attribute(a)	/* nil */
#endif	/* defined(lint) && defined(apollo) */

#define	PRIVATE		static
#define	PUBLIC		/* nil */

#ifdef	__STDC__
#define	PROTO(args)	args
#define	CONCAT(x,y)	x ## y
#define	STRING(x)	#x

#define	SIGNED		signed
#define	CONST		const
#define	VOLATILE	volatile
#if	defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define	INLINE		inline
#else
#define	INLINE		/* nil */
#endif	/* defined(__GNUC__) && !defined(__STRICT_ANSI__) */
#else
#define	PROTO(args)	()
#define	CONCAT(x,y)	x/**/y
#define	STRING(x)	"x"

#ifdef	__GNUC__
#define	SIGNED		__signed
#define	CONST		__const
#define	VOLATILE	__volatile
#define	INLINE		__inline
#else
#define	SIGNED		/* nil */
#define	CONST		/* nil */
#define	VOLATILE	/* nil */
#define	INLINE		/* nil */
#endif	/* __GNUC__ */
#endif	/* __STDC__ */

#if	defined(__GNUC__) && !defined(__STRICT_ANSI__)
#define	NOSIDEFF	CONST		/* no external state or side effects */
#define	NORETURN	VOLATILE	/* never returns */
#else
#define	NOSIDEFF	/* nil */
#define	NORETURN	/* nil */
#endif	/* defined(__GNUC__) && !defined(__STRICT_ANSI__) */

#if	defined(lint) && defined(vax)
#define	LINT_IGNORES_NOTREACHED
#endif	/* defined(lint) && defined(vax) */

#endif	/* LANG_H */
