/*
 *	sio.c - support functions for standard I/O library
 *
 *	This is based on code from vsprintf(3) ...
 *
 *	@(#)vsprintf.c	5.2 (Berkeley) 6/27/88
 */

#include "lang.h"
#include "std.h"
#include "var.h"
#include "sio.h"

#ifdef	NEEDVSPRINTF
int	vsprintf(str, fmt, ap)	/* XXX - should use stdarg.h for ANSI C */
char	*str;
char	*fmt;
va_list	ap;
{
	FILE	f;
	int	len;

	f._flag = _IOWRT + _IOSTRG;
	f._ptr  = str;
	f._cnt  = 32767;

	len = _doprnt(fmt, ap, &f);

	*f._ptr = 0;

	return(len);
}
#endif	/* NEEDVSPRINTF */
