/*
 *	char.h - character classification macros
 */

#ifndef	CHAR_H
#define	CHAR_H

#include <ctype.h>

#define	CNULL	'\0'
#define	NL	'\n'
#define	TAB	'\t'

#define	SPACE	' '
#define	SLASH	'/'
#define	DASH	'-'
#define	DOT	'.'
#define	ZERO	'0'
#define	COLON	':'
#define	AT	'@'

#define	NLC	'n'
#define	NUC	'N'
#define	YLC	'y'
#define	YUC	'Y'

#define	isnull(c)	 ((c) == CNULL)
#define	isnl(c) 	 ((c) == NL)
#define	iswhite(c)	(((c) == SPACE) || ((c) == TAB))

#define	isno(c) 	(((c) == NLC)   || ((c) == NUC))
#define	isyes(c)	(((c) == YLC)   || ((c) == YUC))

#define	iszero(c)	 ((c) == ZERO)
#define	todigit(c)	 ((c)  - ZERO)

#define	dchar(c)	(isprint(c) ? (c) : DOT)

#endif	/* CHAR_H */
