/*
 *	error.h - fatal error messages with exit status codes
 */

#ifndef	ERROR_H
#define	ERROR_H

#include <errno.h>

extern int	errno;	/* sometimes omitted from <errno.h> */

NORETURN void	usage PROTO((void));

NORETURN void	erroru PROTO((char *));
NORETURN void	errors PROTO((char *));
NORETURN void	errorp PROTO((char *));
NORETURN void	errorm PROTO((char *));
NORETURN void	errora PROTO((char *));

#define	E_NONE	0	/* success */
#define	E_USAGE	1	/* user errors */
#define	E_RBAK	2	/* rbak header or operation errors */
#define	E_SYS	3	/* system errors */
#define	E_MISC	4	/* miscellaneous errors */
#define	E_ANSI	5	/* ANSI header errors */

extern char	*prog;

#endif	/* ERROR_H */
