/*
 *	order.h - conversions between local host and Apollo byte orders
 */

#ifndef	ORDER_H
#define	ORDER_H

#if	defined(vax) || defined(__386BSD__) || defined(i386)
#define	ENDIAN_REVERSE	/* little endian */
#else
#define	ENDIAN_APOLLO	/* big endian, like an Apollo */
#endif	/* defined(vax) || defined(i386) */

#if	!defined(SWAB_OVERLAP) && (defined(vax) || defined(sun) || (defined(__hpux) && (defined(__hp9000s300) || (defined(__hp9000s700) && (_POSIX_VERSION > 198808L) && (_POSIX2_VERSION > 198909L)))) || defined(hp300) || defined(__386BSD__))
#define	SWAB_OVERLAP	/* swab can handle overlapping source and destination */
#endif	/* !defined(SWAB_OVERLAP) && (defined(vax) || defined(sun) || (defined(__hpux) && (defined(__hp9000s300) || (defined(__hp9000s700) && (_POSIX_VERSION > 198808L) && (_POSIX2_VERSION > 198909L)))) || defined(hp300) || defined(__386BSD__)) */

#ifdef	SWAB_OVERLAP
#if	(defined(__hpux) && (_POSIX_VERSION > 198808L)) || defined(__386BSD__)
typedef	void	*swab_buf_t;
#else
typedef	char	*swab_buf_t;
#endif	/* (defined(__hpux) && (_POSIX_VERSION > 198808L)) || defined(__386BSD__) */

#if	defined(__hpux) && (_POSIX_VERSION > 198808L) && (_POSIX2_VERSION > 198909L)
typedef	ssize_t	swab_size_t;
#else
#if	(defined(__hpux) && (_POSIX_VERSION > 198808L)) || defined(__386BSD__)
typedef	size_t	swab_size_t;
#else
typedef	int	swab_size_t;
#endif	/* (defined(__hpux) && (_POSIX_VERSION > 198808L)) || defined(__386BSD__) */
#endif	/* defined(__hpux) && (_POSIX_VERSION > 198808L) && (_POSIX2_VERSION > 198909L) */
#endif	/* SWAB_OVERLAP */

#endif	/* ORDER_H */
