/*
 *	sio.h - standard I/O library
 */

#ifndef	SIO_H
#define	SIO_H

#include <stdio.h>

#ifndef	NULL
#define	NULL	0
#endif	/* NULL */

#if	(defined(__hpux) && (_POSIX_VERSION > 198808L) && !defined(_CLASSIC_ANSI_TYPES)) || defined(__386BSD__) || defined(__sgi)
typedef	void	 *fread_buf_t;
typedef	void	*fwrite_buf_t;
#else
typedef	char	 *fread_buf_t;
typedef	char	*fwrite_buf_t;
#endif	/* (defined(__hpux) && (_POSIX_VERSION > 198808L) && !defined(_CLASSIC_ANSI_TYPES)) || defined(__386BSD__) || defined(__sgi) */

#if	(defined(__hpux) && !defined(_CLASSIC_ANSI_TYPES)) || defined(__386BSD__) || defined(__sgi)
typedef	size_t	 fread_size_t;
typedef	size_t	fwrite_size_t;
#else
typedef	int	 fread_size_t;
typedef	int	fwrite_size_t;
#endif	/* (defined(__hpux) && !defined(_CLASSIC_ANSI_TYPES)) || defined(__386BSD__) || defined(__sgi) */

#if	!defined(NEEDVSPRINTF) && defined(vax)
#define	NEEDVSPRINTF
#endif	/* !defined(NEEDVSPRINTF) && defined(vax) */

#ifdef	NEEDVSPRINTF
int	vsprintf();	/* XXX - should use stdarg.h for ANSI C */
#endif	/* NEEDVSPRINTF */

#endif	/* SIO_H */
