/*
 *	std.h - C language standards
 */

#ifndef	STD_H
#define	STD_H

#if	defined(__hpux) && !defined(_HPUX_SOURCE)
#define	_HPUX_SOURCE
#endif	/* defined(__hpux) && !defined(_HPUX_SOURCE) */

#include <sys/types.h>

#if	defined(__STDC__) || defined(sun) || defined(__hpux) || defined(__386BSD__)
#include <stdlib.h>
#else
char	*malloc();
#endif	/* defined(__STDC__) || defined(sun) || defined(__hpux) || defined(__386BSD__) */

#if	defined(vax) || (defined(lint) && defined(ibm032))
typedef	char	*vmem_t;
#else
typedef	void	*vmem_t;
#endif	/* defined(vax) || (defined(lint) && defined(ibm032)) */

#if	defined(__STDC__) || defined(sun) || defined(__hpux) || defined(__386BSD__)
#include <unistd.h>
#else
uid_t	getuid();
gid_t	getgid();
#endif	/* defined(__STDC__) || defined(sun) || defined(__hpux) || defined(__386BSD__) */

#if	defined(__hpux) || defined(__386BSD__)
typedef	uid_t	chown_uid_t;
typedef	gid_t	chown_gid_t;
#else
typedef	int	chown_uid_t;
typedef	int	chown_gid_t;
#endif	/* defined(__hpux) || defined(__386BSD__) */

#if	defined(sun) || defined(__hpux)
#include <fcntl.h>
#else
#include <sys/file.h>
#endif	/* defined(sun) || defined(__hpux) */

#if	(defined(__hpux) && (_POSIX_VERSION > 198808L) && !defined(_XPG3)) || defined(__386BSD__)
typedef	void		 *read_buf_t;
typedef	void		*write_buf_t;

typedef	size_t        	 read_size_t;
typedef	size_t        	write_size_t;
#else
typedef	char		 *read_buf_t;
typedef	char		*write_buf_t;

#ifdef	__hpux
typedef	unsigned int	 read_size_t;
typedef	unsigned int	write_size_t;
#else
typedef	  SIGNED int	 read_size_t;
typedef	  SIGNED int	write_size_t;
#endif	/* __hpux */
#endif	/* (defined(__hpux) && (_POSIX_VERSION > 198808L) && !defined(_XPG3)) || defined(__386BSD__) */

#endif	/* STD_H */
