/*
 *	error.c - fatal error messages with exit status codes
 */

#include "lang.h"
#include "std.h"
#include "sio.h"
#include "error.h"
#include "version.h"

#ifdef	lint
int	errno;
#endif	/* lint */

char	*prog;		/* program name: usually "rbak" (from command line) */

#define	USAGE \
 "usage: %s [-dev [device|[m|mt|c|ct|f][unit]]|-rem[ote|c|ct] [user@]host:device|\n\
             -from filename|-stdin] [-reten|-nreten] [-rewind] [-unload]\n\
            [-f[ile] [fileno|cur]|-f[ile]id fileid] [-anys] [-reo]\n\
            [-int|-index] [-cr|-r|-ms|-md] [-pr pathname ...] [-force] [-du]\n\
            [-l|-ld|-lf|-ll] [-sla|-nsla] [-dacl|-sacl] [-pdt]\n\
            [-v] [-rc|-nrc] [-nty] [-512] [-nodowncase|-ndc]\n\
            [pathname [-as pathname] ...|-all]\n"

NORETURN
#ifdef	__STDC__
void	usage(void)
#else
void	usage()
#endif	/* __STDC__ */
{
	(void) fprintf(stderr, "%s\n", Version);
	(void) fprintf(stderr, USAGE, prog);

	exit(E_USAGE);
	/*NOTREACHED*/
}

char	fe_error[] = "%s: %s\n";

NORETURN
#ifdef	__STDC__
void	erroru(char *message)
#else
void	erroru(message)
char	*message;
#endif	/* __STDC__ */
{
	(void) fprintf(stderr, fe_error, prog, message);

	exit(E_USAGE);
	/*NOTREACHED*/
}

NORETURN
#ifdef	__STDC__
void	errors(char *message)
#else
void	errors(message)
char	*message;
#endif	/* __STDC__ */
{
	extern long	seq;

	(void) fprintf(stderr, "%s: %s (block %ld)\n", prog, message, seq);

	exit(E_RBAK);
	/*NOTREACHED*/
}

NORETURN
#ifdef	__STDC__
void	errorp(char *path)
#else
void	errorp(path)
char	*path;
#endif	/* __STDC__ */
{
	(void) fprintf(stderr, "%s: ", prog);
	(void) perror(path);

	exit(E_SYS);
	/*NOTREACHED*/
}

NORETURN
#ifdef	__STDC__
void	errorm(char *message)
#else
void	errorm(message)
char	*message;
#endif	/* __STDC__ */
{
	if (errno != 0)
		(void) perror(prog);
	else
		(void) fprintf(stderr, fe_error, prog, message);

	exit(E_MISC);
	/*NOTREACHED*/
}

NORETURN
#ifdef	__STDC__
void	errora(char *message)
#else
void	errora(message)
char	*message;
#endif	/* __STDC__ */
{
	extern char	*ansi_ident;

	(void) fprintf(stderr, "%s: %s (%.4s)\n", prog, message, ansi_ident);

	exit(E_ANSI);
	/*NOTREACHED*/
}
