/*
 * export.c
 *
 * Version 2.0 : Frederick Roeber : 3 June 1992
 *
 * This file contains the routines which implement the IO trait export
 * operation for the rlog type manager.
 *
 */

#include "rlog.h"
#include "prototypes.h"

void
rlog_export
(
    handle_t *&h,
    void *mgr_data,
    short int &buf_size,
    short int *mgr_buf_size,
    status_$t *status
)
{
    if( buf_size < sizeof(handle_t) )
    {
        status->all = status_$ok;    /* Honest, that's what the manual says */
        *mgr_buf_size = sizeof(handle_t);
        return;
    }

    pfm_$inhibit();
    mutex_$lock(&h->pfgs->sfcb->header.slock, mutex_$wait_forever);

    if( h->regulated )
    {
        if( h->read_only )
        {
            h->pfgs->sfcb->regulated_readers++;
        }
        else if( h->read_intend_write )
        {
            h->pfgs->sfcb->regulated_riw_ers++;
        }
        else
        {
            h->pfgs->sfcb->regulated_writers++;
        }
    }
    else
    {
        if( h->read_only )
        {
            h->pfgs->sfcb->unregulated_readers++;
        }
        else if( h->read_intend_write )
        {
            h->pfgs->sfcb->unregulated_riw_ers++;
        }
        else
        {
            h->pfgs->sfcb->unregulated_writers++;
        }
    }

    h->pfgs->users ++;
    h->pfgs->sfcb->header.use_count ++;

    *(handle_t *)mgr_data = *h;
    *mgr_buf_size = sizeof(handle_t);

    status->all = status_$ok;

    mutex_$unlock(&h->pfgs->sfcb->header.slock);
    pfm_$enable();
    return;
}
